/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.Ide;
import oracle.ide.controls.DoubleClickTrigger;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ideimpl.MainWindowImpl;
import oracle.ideimpl.editor.Desktop;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.TabGroup;

final class DocTabListener
implements ListSelectionListener,
ListDataListener,
MouseListener {
    private TabGroup _tabGroup;
    private CustomTab _docTabs;
    private DoubleClickTrigger _trigger = new DoubleClickTrigger();

    public DocTabListener(TabGroup tabGroup, CustomTab docTabs) {
        this._tabGroup = tabGroup;
        this._docTabs = docTabs;
    }

    private boolean handleSystemMenu(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return false;
        }
        Point point = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), (Component)this._docTabs);
        int pageAt = e.getComponent() == this._docTabs ? this._docTabs.getPageAt(point) : -1;
        this._tabGroup.showSystemMenu(pageAt, point);
        return true;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this._tabGroup.whenTabSelectionChanges();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.handleSystemMenu(e)) {
            return;
        }
        if (this._trigger.isDoubleClick(e)) {
            MainWindowImpl mainWindow = (MainWindowImpl)Ide.getMainWindow();
            Desktop desktop = EditorManagerImpl.getInstance().getDesktop();
            if (!mainWindow.isMaximized()) {
                desktop.maximizeTabGroup(this._tabGroup);
            } else {
                desktop.restoreTabGroups();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.handleSystemMenu(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.handleSystemMenu(e)) {
            this._tabGroup.focusCurrentEditor();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

