/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import oracle.ide.IdeUIManager;
import oracle.ide.controls.ButtonsLayoutManager;
import oracle.ide.controls.SmallSquareButton;
import oracle.ide.util.BitField;
import oracle.javatools.controls.GradientPanel;
import oracle.javatools.util.SwingUtils;

public final class Handlebar
extends GradientPanel
implements SwingConstants {
    private static final int FLAG_ACTIVE = 1;
    private static final int FLAG_TRUNCATE_TITLE = 2;
    private static final int FLAG_BUTTONS_VISIBLE = 4;
    private static final int ROT_LEFT = -1;
    private static final int ROT_NONE = 0;
    private static final int MINIMUM_SIZE_TO_SHOW_BUTTONS = 50;
    private static final boolean USE_ANTIALIAS = false;
    private static final int GAP_BEFORE_TITLE = 3;
    private static final int GAP_AFTER_TITLE = 3;
    private static final int GAP_ICON = 1;
    private static final Dimension MINIMUM_SIZE = new Dimension(3, 3);
    private Rectangle2D _rectTitle;
    private int _nOrient = 0;
    private String _sTitle = "";
    private Icon _icon;
    private int _flags = 4;
    private static final int GAP_ABOVE = 1;
    private static final int GAP_BELOW = 1;

    public Handlebar() {
        super(5);
        this.setLayout((LayoutManager)new ButtonsLayoutManager(1));
        this.setOrientation(0);
        this.adjustColors();
        this.setFont(UIManager.getFont("Label.font"));
    }

    public String getTitle() {
        return this._sTitle;
    }

    public void setTitle(String sTitle) {
        this._sTitle = sTitle != null ? sTitle : "";
        this.getAccessibleContext().setAccessibleName(sTitle);
        this.invalidateUI();
    }

    private Icon getIcon() {
        return this._icon;
    }

    public void setIcon(Icon icon) {
        this._icon = icon;
        this.invalidateUI();
    }

    private boolean isButtonsVisible() {
        return BitField.isSet((int)this._flags, (int)4);
    }

    private void setButtonsVisible(boolean show) {
        this._flags = show ? BitField.set((int)this._flags, (int)4) : BitField.unset((int)this._flags, (int)4);
    }

    public void addButton(SmallSquareButton button, int pos) {
        button.setRolloverEnabled(false);
        button.setForeground(this.isActive() ? IdeUIManager.getActiveTitleButtonColor() : IdeUIManager.getInactiveTitleButtonColor());
        this.add((Component)button, pos);
    }

    public void removeButton(int pos) {
        ButtonsLayoutManager layoutManager = (ButtonsLayoutManager)this.getLayout();
        Component button = layoutManager.getButton(pos);
        if (button != null) {
            this.remove(button);
        }
    }

    public void setActive(boolean bActive) {
        if (this.isActive() != bActive) {
            this._flags = BitField.toggle((int)this._flags, (int)1);
            this.adjustColors();
        }
    }

    public boolean isActive() {
        return BitField.isSet((int)this._flags, (int)1);
    }

    private void adjustColors() {
        boolean bActive = this.isActive();
        this.setGradientStartColor(bActive ? IdeUIManager.getActiveTitleGradientLightColor() : IdeUIManager.getInactiveTitleGradientLightColor());
        this.setBackground(bActive ? IdeUIManager.getActiveTitleGradientDarkColor() : IdeUIManager.getInactiveTitleGradientDarkColor());
        this.setForeground(bActive ? IdeUIManager.getActiveTitleForegroundColor() : IdeUIManager.getInactiveTitleForegroundColor());
        ButtonsLayoutManager layout = (ButtonsLayoutManager)this.getLayout();
        int i = layout.getButtonCount();
        while (i-- > 0) {
            Component button = layout.getButton(i);
            button.setForeground(bActive ? IdeUIManager.getActiveTitleButtonColor() : IdeUIManager.getInactiveTitleButtonColor());
        }
        if (this.isShowing()) {
            this.repaint();
        }
    }

    private int getRotation() {
        return this._nOrient == 0 ? 0 : -1;
    }

    public void setTruncateTitle(boolean b) {
        if (this.isTruncateTitle() != b) {
            this._flags = BitField.toggle((int)this._flags, (int)2);
            if (this.isShowing()) {
                this.invalidateUI();
            }
        }
    }

    private void invalidateUI() {
        this.setPreferredSize(null);
        this.clearCachedInfo();
        this.repaint();
    }

    private boolean isTruncateTitle() {
        return BitField.isSet((int)this._flags, (int)2);
    }

    private ButtonsLayoutManager getButtonLayout() {
        return (ButtonsLayoutManager)this.getLayout();
    }

    public int getOrientation() {
        return this._nOrient;
    }

    public void setOrientation(int nOrient) {
        this.getButtonLayout().setOrientation(nOrient);
        this._nOrient = nOrient;
        this.setGradientDirection(nOrient == 0 ? 5 : 3);
        this.setPreferredSize(null);
        this.revalidate();
    }

    protected void paintComponent(Graphics gAWT) {
        super.paintComponent(gAWT);
        Graphics2D g = (Graphics2D)gAWT;
        ButtonsLayoutManager blm = this.getButtonLayout();
        Rectangle r = blm.getSpaceLeft();
        Dimension d = this.getSize();
        Insets i = this.getInsets();
        int x = i.left;
        int y = i.top;
        int nTitleWidth = r.width - (i.left + i.right);
        int nTitleHeight = r.height - (i.top + i.bottom);
        this.paint(g, x, y, nTitleWidth, nTitleHeight, d.width, d.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.adaptButtonsBasedOnSize();
    }

    private void adaptButtonsBasedOnSize() {
        boolean bShowButtons;
        if (this.getOrientation() == 1) {
            bShowButtons = this.getHeight() > 50;
        } else {
            boolean bl = bShowButtons = this.getWidth() > 50;
        }
        if (this.isButtonsVisible() != bShowButtons) {
            this.setButtonsVisible(bShowButtons);
            ButtonsLayoutManager layout = (ButtonsLayoutManager)this.getLayout();
            int n = layout.getButtonCount();
            for (int i = 0; i < n; ++i) {
                Component button = layout.getButton(i);
                button.setVisible(bShowButtons);
            }
        }
    }

    public boolean isFocusable() {
        return false;
    }

    public Dimension getPreferredSize() {
        Dimension d;
        if (this.isPreferredSizeSet()) {
            d = super.getPreferredSize();
        } else {
            Graphics2D g = (Graphics2D)this.getGraphics();
            if (g != null) {
                d = this.getPreferredSize(g);
                this.setPreferredSize(d);
            } else {
                d = this.getMinimumSize();
            }
        }
        return d;
    }

    private void clearCachedInfo() {
        this._rectTitle = null;
    }

    public Dimension getMinimumSize() {
        return MINIMUM_SIZE;
    }

    private Dimension getPreferredSize(Graphics2D g) {
        Rectangle2D bounds = this.getTitleRect(g);
        double titleWidth = bounds.getWidth();
        double titleHeight = bounds.getHeight();
        Icon icon = this.getIcon();
        int iconWidth = icon == null ? 0 : icon.getIconWidth();
        int iconHeight = icon == null ? 0 : icon.getIconHeight();
        int componentHeight = 0;
        int i = this.getComponentCount();
        while (i-- > 0) {
            Component c = this.getComponent(i);
            componentHeight = Math.max(componentHeight, c.getMinimumSize().height);
        }
        double labelWidth = (double)(3 + iconWidth) + titleWidth + 3.0;
        double labelHeight = 1.0 + Math.max((double)iconHeight, Math.max(titleHeight, (double)componentHeight)) + 1.0;
        if (this.getRotation() != 0) {
            double tmp = labelWidth;
            labelWidth = labelHeight;
            labelHeight = tmp;
        }
        Insets insets = this.getInsets();
        double width = (double)insets.left + labelWidth + (double)insets.right;
        double height = (double)insets.top + labelHeight + (double)insets.bottom;
        Dimension d = new Dimension((int)width, (int)height);
        return d;
    }

    private void paint(Graphics2D g, int x, int y, int nTitleWidth, int nTitleHeight, int nWindowWidth, int nWindowHeight) {
        AffineTransform at = g.getTransform();
        g.translate(x, y);
        if (this.adaptTransform(g, nWindowHeight)) {
            int i = nTitleWidth;
            nTitleWidth = nTitleHeight;
            nTitleHeight = i;
        }
        this.paintTitle(g, nTitleWidth, nTitleHeight);
        if (at != null) {
            g.setTransform(at);
        }
    }

    private Rectangle2D getTitleRect(Graphics2D g) {
        if (this._rectTitle == null) {
            FontRenderContext frc = g.getFontRenderContext();
            this._rectTitle = this.getFont().getStringBounds(this.getTitle(), frc);
        }
        return this._rectTitle;
    }

    private void paintTitle(Graphics2D g, int width, int height) {
        int iconWidth;
        int pos = 3;
        Icon icon = this.getIcon();
        int n = iconWidth = icon == null ? 0 : icon.getIconWidth() + 1;
        if (icon != null && pos + iconWidth < width) {
            int y = (height - 1 - 1 - icon.getIconHeight()) / 2 + 1;
            icon.paintIcon((Component)((Object)this), g, pos, y);
            pos += iconWidth;
        }
        Rectangle2D bounds = this.getTitleRect(g);
        float dY = (float)(((double)(height - 1 - 1) - bounds.getHeight()) / 2.0 - bounds.getY()) + 1.0f;
        Color fg = this.getForeground();
        Font font = this.getFont();
        g.setColor(fg);
        g.setFont(font);
        String sTitle = this.getTitle();
        Shape oldClip = g.getClip();
        g.setClip(pos, 0, width - pos - 3, height);
        SwingUtils.drawString((Graphics2D)g, (String)sTitle, (float)pos, (float)dY);
        g.setClip(oldClip);
        this.setToolTipText(sTitle);
    }

    private boolean adaptTransform(Graphics2D g, int nWindowHeight) {
        boolean bRet = false;
        int rotation = this.getRotation();
        if (rotation != 0) {
            g.rotate((double)rotation * Math.PI / 2.0, 0.0, 0.0);
            g.translate(-nWindowHeight, 0);
            bRet = true;
        }
        return bRet;
    }
}

