/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking.controls;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JRootPane;
import javax.swing.SwingConstants;
import oracle.ideimpl.docking.controls.DividerEvent;
import oracle.ideimpl.docking.controls.DividerListener;

public final class Divider
extends Box
implements SwingConstants {
    private int _orientation;
    private transient boolean dragging;
    private transient int x1;
    private transient int y1;
    private transient int x2;
    private transient int y2;

    public Divider(int orientation, int size) {
        super(0);
        this.enableEvents(48L);
        this.setOrientation(orientation);
        this.add(Box.createRigidArea(new Dimension(size, size)));
    }

    private int getOrientation() {
        return this._orientation;
    }

    public void setOrientation(int orientation) {
        this._orientation = orientation;
        int nCursor = this._orientation == 0 ? 9 : 11;
        this.setCursor(Cursor.getPredefinedCursor(nCursor));
    }

    public void addDividerListener(DividerListener l) {
        this.listenerList.add(DividerListener.class, l);
    }

    public void removeDividerListener(DividerListener l) {
        this.listenerList.remove(DividerListener.class, l);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Dimension d = this.getSize();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, d.width, d.height);
        }
    }

    private void fireDividerListener(int delta) {
        Object[] listeners = this.listenerList.getListenerList();
        DividerEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DividerListener.class) continue;
            if (e == null) {
                e = new DividerEvent(this, delta);
            }
            ((DividerListener)listeners[i + 1]).dividerMoved(e);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        switch (e.getID()) {
            case 502: {
                if (!this.dragging) break;
                Graphics g = this.getRpGraphics();
                g.drawLine(this.x1, this.y1, this.x2, this.y2);
                g.dispose();
                this.dragging = false;
                int x = e.getX();
                int y = e.getY();
                if (this.getOrientation() == 0) {
                    this.fireDividerListener(y);
                    break;
                }
                this.fireDividerListener(x);
            }
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        switch (e.getID()) {
            case 506: {
                int x = e.getX();
                int y = e.getY();
                Graphics g = this.getRpGraphics();
                if (this.dragging) {
                    g.drawLine(this.x1, this.y1, this.x2, this.y2);
                } else {
                    this.dragging = true;
                }
                if (this.getOrientation() == 0) {
                    this.x1 = 0;
                    this.y1 = y;
                    this.x2 = this.getWidth();
                    this.y2 = y;
                } else {
                    this.x1 = x;
                    this.y1 = 0;
                    this.x2 = x;
                    this.y2 = this.getHeight();
                }
                g.drawLine(this.x1, this.y1, this.x2, this.y2);
                g.dispose();
                break;
            }
            default: {
                super.processMouseMotionEvent(e);
            }
        }
    }

    private Graphics getRpGraphics() {
        JRootPane rp = this.getRootPane();
        Point ptThis = this.getLocationOnScreen();
        Point ptRp = rp.getLocationOnScreen();
        Point ptDiff = new Point(ptThis.x - ptRp.x, ptThis.y - ptRp.y);
        Graphics g = rp.getGraphics();
        g.setXORMode(rp.getBackground());
        g.translate(ptDiff.x, ptDiff.y);
        return g;
    }
}

