/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import oracle.ide.controls.DragComponentEvent;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoLeaf;
import oracle.ideimpl.docking.AbstractDockPanelDragListener;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.TitledPanel;

final class TitledPanelDragListener
extends AbstractDockPanelDragListener {
    private TitledPanel _titledPanel;

    public TitledPanelDragListener(TitledPanel titledPanel) {
        super(titledPanel.getHolder(0));
        this._titledPanel = titledPanel;
    }

    @Override
    protected DockInsertionPoint getDockInsertionPoint(DragComponentEvent e) {
        DockLayoutConstraint dlc;
        TitledPanel compMoved;
        DockInsertionPoint dip = null;
        if (0 == (e.getModifiers() & 2) && (dip = DockStationImpl.getInstance().getDockInsertionAt(e.getPoint())) != null && !DockPanel.canDock(compMoved = this._titledPanel, dlc = dip.createConstraint())) {
            dip = null;
        }
        return dip;
    }

    @Override
    protected void dragComponent(DragComponentEvent e) {
    }

    @Override
    protected void dropComponent(DragComponentEvent e) {
        DockInsertionPoint dip = this.getDockInsertionPoint(e);
        if (dip == null) {
            this.floatComponent(e);
        } else if (dip.getOrientation() != 4) {
            this.dockComponent(dip);
        } else {
            this.dockCenterComponent(dip);
        }
    }

    private void floatComponent(DragComponentEvent e) {
        Rectangle r = this.getFloatingRect(e);
        Container cParent = this._titledPanel.getParent();
        DockStationImpl ds = DockStationImpl.getInstance();
        ds.dockFloat(this._titledPanel, r.getLocation());
        this._titledPanel.activate();
        cParent.validate();
    }

    private void dockComponent(DockInsertionPoint dip) {
        DockStationImpl ds = DockStationImpl.getInstance();
        DockPanel dpTarget = (DockPanel)dip.getContainer();
        DockPanel dpSource = this._titledPanel.getDockPanel();
        DockLayoutInfoLeaf dli = dpSource.getLayoutInfo(this._titledPanel);
        Dimension dPref = dli.getSize(2);
        DockLayoutConstraint dlc = dip.createConstraint();
        dlc.setPreferredDimension(dPref);
        ds._dock(this._titledPanel, dpTarget, dlc);
        this._titledPanel.activate();
        dpSource.revalidate();
    }

    private void dockCenterComponent(DockInsertionPoint dip) {
        TitledPanel tpTarget = (TitledPanel)dip.getCenterReferenceComponent();
        DockStationImpl.transferClients(this._titledPanel, tpTarget, 12);
    }
}

