/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import oracle.ide.controls.Animator;
import oracle.ide.docking.DockableWindow;
import oracle.ideimpl.docking.DrawerEntryImpl;
import oracle.ideimpl.docking.DrawerPanelImpl;
import oracle.javatools.util.Pair;

class MinimizedTray
extends JPanel {
    private Listeners _listeners = new Listeners();
    private DrawerPanelImpl _drawerPanel;
    private JScrollPane _scrollPane;
    private JList _list;

    public MinimizedTray(DrawerPanelImpl drawerPanel) {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.add((Component)new Handle(0), "North");
        this._drawerPanel = drawerPanel;
        DefaultListModel dataModel = new DefaultListModel();
        this._list = new JList(dataModel);
        this._list.addMouseListener(this._listeners);
        this._list.addKeyListener(this._listeners);
        this._scrollPane = new JScrollPane(this._list);
        this._scrollPane.setBorder(null);
        JLabel label = new JLabel("Minimized");
        label.setBackground(Color.GRAY);
        label.setBorder(null);
        label.setAlignmentX(0.5f);
        JPanel panel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, insets, 0, 0));
        panel.add((Component)this._scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, insets, 0, 0));
        this.add((Component)panel, "Center");
    }

    public void addEntry(DrawerEntryImpl entry) {
        DefaultListModel dataModel = (DefaultListModel)this._list.getModel();
        DockableWindow dockable = entry.getDockable();
        String label = dockable.getTabName();
        Pair pair = new Pair((Object)label, (Object)entry);
        dataModel.addElement(pair);
    }

    private void whenRestore() {
        Pair pair = (Pair)this._list.getSelectedValue();
        if (pair != null) {
            DrawerEntryImpl entry = (DrawerEntryImpl)pair.second;
            DefaultListModel model = (DefaultListModel)this._list.getModel();
            model.removeElement(pair);
            this._drawerPanel.restore(entry, false);
        }
        if (this.isEmpty()) {
            this.collapse();
        }
    }

    public boolean isEmpty() {
        return this._list.getModel().getSize() == 0;
    }

    public final void expand(Component parent) {
        this._scrollPane.setVerticalScrollBarPolicy(21);
        RootPaneContainer rootPaneContainer = this.getRootPaneContainer(parent);
        JLayeredPane layeredPane = rootPaneContainer.getLayeredPane();
        layeredPane.add((Component)this, JLayeredPane.MODAL_LAYER);
        Dimension preferredSize = this.getPreferredSize();
        int parentHeight = parent.getHeight();
        int parentWidth = parent.getWidth();
        int preferredHeight = Math.min(preferredSize.height, parentHeight / 3);
        Point pt = SwingUtilities.convertPoint(parent, 0, parentHeight, layeredPane);
        Rectangle rcFrom = new Rectangle(pt.x, pt.y, parentWidth, 0);
        Rectangle rcTo = new Rectangle(pt.x, pt.y - preferredHeight, parentWidth, preferredHeight);
        AnimationListener animationListener = new AnimationListener(this, rcFrom, rcTo);
        Animator.animate((int)30, (long)500L, (PropertyChangeListener)animationListener);
        this.requestFocus();
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addPropertyChangeListener("permanentFocusOwner", this._listeners);
        layeredPane.addComponentListener(this._listeners);
        this._scrollPane.setVerticalScrollBarPolicy(20);
    }

    public void collapse() {
        JLayeredPane layeredPane = (JLayeredPane)this.getParent();
        layeredPane.removeComponentListener(this._listeners);
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.removePropertyChangeListener("permanentFocusOwner", this._listeners);
        Rectangle rcFrom = this.getBounds();
        Rectangle rcTo = new Rectangle(rcFrom.x, rcFrom.y + rcFrom.height, rcFrom.width, 0);
        Animator.animate((int)30, (long)500L, (PropertyChangeListener)new AnimationListener(layeredPane, rcFrom, rcTo));
        layeredPane.remove(this);
        layeredPane.repaint();
    }

    private RootPaneContainer getRootPaneContainer(Component parent) {
        return (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, parent));
    }

    private class Listeners
    implements PropertyChangeListener,
    ComponentListener,
    MouseListener,
    KeyListener {
        private Listeners() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            KeyboardFocusManager focusManager;
            Component permanentFocusOwner;
            String propertyName = evt.getPropertyName();
            if ("permanentFocusOwner".equals(propertyName) && (permanentFocusOwner = (focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager()).getPermanentFocusOwner()) != null && !SwingUtilities.isDescendingFrom(permanentFocusOwner, MinimizedTray.this)) {
                MinimizedTray.this.collapse();
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Container parent = MinimizedTray.this.getParent();
            MinimizedTray.this.setBounds(MinimizedTray.this.getX(), parent.getHeight() - MinimizedTray.this.getHeight(), parent.getWidth(), MinimizedTray.this.getHeight());
            MinimizedTray.this.revalidate();
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            MinimizedTray.this.whenRestore();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int index;
            if (e.getButton() != 1 && (index = MinimizedTray.this._list.locationToIndex(e.getPoint())) >= 0) {
                MinimizedTray.this._list.setSelectedIndex(index);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if ('\n' == e.getKeyChar()) {
                MinimizedTray.this.whenRestore();
            }
        }
    }

    private static class Handle
    extends JPanel {
        private int _orientation;

        public Handle(int orientation) {
            this._orientation = orientation;
            int cursorType = orientation == 0 ? 8 : 10;
            this.setCursor(Cursor.getPredefinedCursor(cursorType));
            this.setPreferredSize(new Dimension(10, 10));
            this.setBorder(BorderFactory.createBevelBorder(0));
        }

        @Override
        protected void paintComponent(Graphics g) {
            Color background = this.getBackground();
            g.setColor(background);
            Insets insets = this.getInsets();
            int width = this.getWidth() - insets.left - insets.right;
            int height = this.getHeight() - insets.top - insets.bottom;
            g.fillRect(insets.left, insets.top, width, height);
            g.setColor(Color.GRAY);
            if (this._orientation == 0) {
                int d = height - 2;
                for (int i = -10; i <= 10; i += 10) {
                    g.drawOval(insets.left + (width - d) / 2 + i, insets.top + (height - d) / 2, d, d);
                }
            } else {
                int d = width - 2;
                for (int i = -10; i <= 10; i += 10) {
                    g.fillOval(insets.left + (width - d) / 2, insets.top + (height - d) / 2 + i, d, d);
                }
            }
        }
    }

    private class AnimationListener
    implements PropertyChangeListener {
        private JComponent _layeredPane;
        private Rectangle _rcFrom;
        private Rectangle _rcTo;

        public AnimationListener(JComponent component, Rectangle rcFrom, Rectangle rcTo) {
            this._layeredPane = component;
            this._rcFrom = rcFrom;
            this._rcTo = rcTo;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            double v = (Double)evt.getNewValue();
            Rectangle rc = Animator.getRectangle((double)v, (Rectangle)this._rcFrom, (Rectangle)this._rcTo);
            MinimizedTray.this.setBounds(rc);
            Graphics g = this._layeredPane.getGraphics();
            this._layeredPane.paintAll(g);
            g.dispose();
        }
    }
}

