/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DrawerDockableWindow;
import oracle.ide.docking.DrawerElement;
import oracle.ide.docking.DrawerEntry;
import oracle.ide.docking.DrawerModel;
import oracle.ide.docking.DrawerPanel;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.DrawerEntryImpl;
import oracle.ideimpl.docking.DrawerPanelImpl;

public final class DrawerModelImpl
extends DrawerModel {
    private DrawerDockableWindow _drawerDockableWindow;
    private final ArrayList<DrawerEntryImpl> _entries = new ArrayList();
    private final List<ListDataListener> _listeners = new CopyOnWriteArrayList<ListDataListener>();

    public DrawerModelImpl(DrawerDockableWindow drawerDockableWindow) {
        this._drawerDockableWindow = drawerDockableWindow;
    }

    public int size() {
        return this._entries.size();
    }

    public DrawerEntryImpl getEntry(int i) {
        return this._entries.get(i);
    }

    protected void setState(int index, DrawerModel.State state) {
        this.getEntry(index).setState(state);
    }

    public List<DrawerEntryImpl> getEntries() {
        return new ArrayList<DrawerEntryImpl>(this._entries);
    }

    public final List<DockableWindow> getDockables() {
        ArrayList<DockableWindow> ret = new ArrayList<DockableWindow>(this.getEntries().size());
        for (DrawerEntryImpl entry : this.getEntries()) {
            DockableWindow dockable = entry.getDockable();
            ret.add(dockable);
        }
        return ret;
    }

    public int indexOf(Dockable dockable) {
        for (int i = 0; i < this._entries.size(); ++i) {
            DrawerEntry entry = this._entries.get(i);
            if (!dockable.equals(entry.getDockable())) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(DrawerElement drawerElement) {
        for (int i = 0; i < this._entries.size(); ++i) {
            DrawerEntry entry = this._entries.get(i);
            if (!drawerElement.equals(entry.getComponent())) continue;
            return i;
        }
        return -1;
    }

    public DrawerEntry add(DockableWindow dockable, DrawerModel.State state) {
        return this.add(dockable, state, this.size());
    }

    public DrawerEntry remove(DockableWindow dockableWindow) {
        int index = this.indexOf((Dockable)dockableWindow);
        return this.remove(index);
    }

    public DrawerPanel createDrawerPanel(DrawerDockableWindow drawerDockableWindow) {
        DrawerPanelImpl drawerPanel = new DrawerPanelImpl(drawerDockableWindow);
        return drawerPanel;
    }

    int indexOf(DrawerEntry entry) {
        return this._entries.indexOf(entry);
    }

    DrawerEntry add(DockableWindow dockableWindow, DrawerModel.State state, int index) {
        DrawerEntryImpl entry = new DrawerEntryImpl(this._drawerDockableWindow, dockableWindow);
        entry.setState(state);
        this._entries.add(index, entry);
        DockStationImpl dockStation = DockStationImpl.getInstance();
        dockStation.addToCache((Dockable)dockableWindow);
        ListDataEvent event = new ListDataEvent((Object)this, 1, index, index);
        this.fireListDataEvent(event);
        return entry;
    }

    void move(DrawerEntryImpl entry, int newIndex) {
        int oldIndex = this._entries.indexOf(entry);
        this._entries.remove(oldIndex);
        if (oldIndex < newIndex) {
            --newIndex;
        }
        this._entries.add(newIndex, entry);
    }

    private DrawerEntry remove(int index) {
        ListDataEvent event = new ListDataEvent((Object)this, 2, index, index);
        this.fireListDataEvent(event);
        DrawerEntryImpl ret = this._entries.remove(index);
        if (ret != null) {
            DockStationImpl dockStation = DockStationImpl.getInstance();
            DockableWindow removedDockable = ret.getDockable();
            dockStation.removeFromCache((Dockable)removedDockable);
        }
        return ret;
    }

    private void fireListDataEvent(ListDataEvent event) {
        int eventTye = event.getType();
        for (ListDataListener listDataListener : this._listeners) {
            switch (eventTye) {
                case 0: {
                    listDataListener.contentsChanged(event);
                    break;
                }
                case 1: {
                    listDataListener.intervalAdded(event);
                    break;
                }
                case 2: {
                    listDataListener.intervalRemoved(event);
                }
            }
        }
    }

    void addListDataListener(ListDataListener listener) {
        this._listeners.add(listener);
    }

    void removeListDataListener(ListDataListener listener) {
        this._listeners.remove(listener);
    }
}

