/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.SwingUtilities;
import oracle.ide.Ide;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableDragContext;
import oracle.ide.docking.DockableDragSource;
import oracle.ide.docking.DockableDropTarget;
import oracle.ide.util.BitField;
import oracle.ide.view.View;
import oracle.ideimpl.MainWindowImpl;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.DockPanelHost;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.controls.FloatingFeedback;

class DockableDragContextImpl
implements DockableDragContext,
KeyEventDispatcher {
    private Dimension _dockedPreferredSize;
    private Dimension _floatingPreferredSize;
    private Dockable[] _dockables;
    private View[] views;
    private DockableDropTarget _currentDropTarget;
    private Point _startPoint;
    private boolean _hasDragStarted;
    private FloatingFeedback _floatingFeedback;
    private static final int START_DRAG_THRESHOLD = DockableDragContextImpl.getDragThreshold();
    private DockableDragSource _dockableDragSource;

    public DockableDragContextImpl(DockableDragSource dockableDragSource) {
        assert (dockableDragSource != null);
        this._dockableDragSource = dockableDragSource;
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addKeyEventDispatcher(this);
    }

    private static int getDragThreshold() {
        String property = Ide.getProperty((String)"docking.dragThreshold", (String)"20");
        try {
            int i = Integer.parseInt(property);
            return i * i;
        }
        catch (NumberFormatException numberFormatException) {
            return 25;
        }
    }

    public View[] views() {
        return this.views;
    }

    public void views(View ... views) {
        this.views = views;
    }

    public void setStartPoint(Point ptScreen) {
        this._startPoint = ptScreen;
    }

    public Point getStartPoint() {
        return new Point(this._startPoint);
    }

    public void setDockables(Dockable[] dockables) {
        this._dockables = dockables;
    }

    public Dockable[] getDockables() {
        return (Dockable[])this._dockables.clone();
    }

    public void setPreferredSizes(Dimension dockedPreferredSize, Dimension floatingPreferredSize) {
        this._dockedPreferredSize = dockedPreferredSize;
        this._floatingPreferredSize = floatingPreferredSize;
    }

    public void mouseMoved(Point ptScreen, int modifiers) {
        assert (this._floatingPreferredSize != null);
        assert (this._dockedPreferredSize != null);
        MainWindowImpl mainWindow = (MainWindowImpl)Ide.getMainWindow();
        int maximizedWindowType = mainWindow.getMaximizedWindowType();
        if (maximizedWindowType != 1 && (this._hasDragStarted || this._startPoint.distanceSq(ptScreen) > (double)START_DRAG_THRESHOLD)) {
            this._hasDragStarted = true;
            boolean isFloating = true;
            if (!BitField.isSet((int)modifiers, (int)2)) {
                DockStationImpl dockStation = DockStationImpl.getInstance();
                DockPanelHost[] dockPanelHosts = dockStation.getAllDockPanelHosts();
                Point pt = new Point();
                for (int i = 0; isFloating && i < dockPanelHosts.length; ++i) {
                    DockPanelHost dockPanelHost = dockPanelHosts[i];
                    DockPanel dockPanel = dockPanelHost.getDockPanel();
                    pt.setLocation(ptScreen);
                    SwingUtilities.convertPointFromScreen(pt, dockPanel);
                    for (Component c = SwingUtilities.getDeepestComponentAt(dockPanel, pt.x, pt.y); isFloating && c != null; c = c.getParent()) {
                        if (!(c instanceof DockableDropTarget)) continue;
                        DockableDropTarget dockableDropTarget = (DockableDropTarget)c;
                        if (dockableDropTarget == this._currentDropTarget) {
                            if (!dockableDropTarget.dragOver((DockableDragContext)this, ptScreen)) continue;
                            isFloating = false;
                            continue;
                        }
                        if (!dockableDropTarget.dragEnter((DockableDragContext)this, ptScreen)) continue;
                        if (this._currentDropTarget != null) {
                            this._currentDropTarget.dragExit((DockableDragContext)this);
                        }
                        this._currentDropTarget = dockableDropTarget;
                        isFloating = false;
                    }
                }
            }
            if (isFloating) {
                if (this._currentDropTarget != null) {
                    this._currentDropTarget.dragExit((DockableDragContext)this);
                    this._currentDropTarget = null;
                }
                ptScreen.translate(-this._floatingPreferredSize.width / 2, -this._floatingPreferredSize.height / 2);
                this.showFloatPanel(ptScreen, this._floatingPreferredSize);
            } else {
                this.hideFloatPanel();
            }
        }
    }

    private void showFloatPanel(Point ptScreen, Dimension dimension) {
        if (this._floatingFeedback == null) {
            this._floatingFeedback = new FloatingFeedback();
        }
        this._floatingFeedback.show(new Rectangle(ptScreen, dimension));
    }

    private void hideFloatPanel() {
        if (this._floatingFeedback != null) {
            this._floatingFeedback.hideFloatPanel();
            this._floatingFeedback = null;
        }
    }

    public void cancelDrag() {
        this._dockableDragSource.canceled();
        this.reset();
    }

    private void reset() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        if (this._currentDropTarget != null) {
            this._currentDropTarget.dragExit((DockableDragContext)this);
            this._currentDropTarget = null;
        }
        this.hideFloatPanel();
    }

    public void endDrag(Point ptScreen, int modifiers) {
        if (this._currentDropTarget != null) {
            this._currentDropTarget.acceptDrop((DockableDragContext)this, ptScreen);
        }
        this.reset();
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        boolean ret = false;
        if (e.getID() == 401) {
            switch (e.getKeyCode()) {
                case 27: {
                    this.cancelDrag();
                    ret = true;
                }
            }
        }
        return ret;
    }
}

