/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controls.dockLayout;

import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.controls.dockLayout.DockDivider;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfo;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoHorzNode;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoLeaf;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoVertNode;
import oracle.ideimpl.controls.dockLayout.DockLayoutPersistence;
import oracle.ideimpl.controls.dockLayout.DockLayoutUtil;
import oracle.ideimpl.controls.dockLayout.XMLDockLayoutPersistence;

public abstract class AbstractDockLayoutInfoNode
implements DockLayoutInfo,
TreeNode {
    private int _orientation;
    private ArrayList _nodes = new ArrayList();
    private ArrayList _dividers = new ArrayList();
    private ArrayList _inserts = new ArrayList();

    AbstractDockLayoutInfoNode(int nOrientation) {
        this._orientation = nOrientation;
    }

    @Override
    public final boolean isReferring(Object ref) {
        return ref == this;
    }

    @Override
    public final int getNodeCount() {
        return this._nodes.size();
    }

    @Override
    public final DockLayoutInfo getNode(int nPos) {
        return (DockLayoutInfo)this._nodes.get(nPos);
    }

    final void insertNode(DockLayoutInfo li, int nPos) {
        this._nodes.add(nPos, li);
    }

    private final void addNode(DockLayoutInfo li) {
        this.insertNode(li, this.getNodeCount());
    }

    private final void setNode(DockLayoutInfo li, int nPos) {
        this._nodes.set(nPos, li);
    }

    private final void removeNode(int nPos) {
        this._nodes.remove(nPos);
    }

    @Override
    public final DockLayoutInfoLeaf getLayoutInfo(JComponent c) {
        DockLayoutInfoLeaf dli = null;
        int n = this.getNodeCount();
        int i = 0;
        while (i < n & dli == null) {
            DockLayoutInfo li = this.getNode(i);
            dli = li.getLayoutInfo(c);
            ++i;
        }
        return dli;
    }

    @Override
    public final void invalidateLayout(Container target) {
        this.removeDividers();
        this.removeInserts();
        int n = this.getNodeCount();
        for (int i = 0; i < n; ++i) {
            this.getNode(i).invalidateLayout(target);
        }
    }

    @Override
    public final boolean isVisible() {
        int n = this.getNodeCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getNode(i).isVisible()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final int moveBy(int nDelta, int nOrient) {
        int nRet = 0;
        int n = this.getNodeCount();
        if (this.isSameOrientation(nOrient)) {
            nRet = nDelta;
            if (DockLayoutUtil.isBefore(nOrient)) {
                for (int i = 0; i < n; ++i) {
                    DockLayoutInfo li = this.getNode(i);
                    nDelta -= li.moveBy(nDelta, nOrient);
                }
            } else {
                for (int i = n - 1; i >= 0; --i) {
                    DockLayoutInfo li = this.getNode(i);
                    nDelta -= li.moveBy(nDelta, nOrient);
                }
            }
            nRet -= nDelta;
        } else {
            nRet = nDelta;
            for (int i = 0; i < n; ++i) {
                DockLayoutInfo li = this.getNode(i);
                int nSub = li.moveBy(nDelta, nOrient);
                nRet = nDelta > 0 ? Math.min(nDelta, nSub) : Math.max(nDelta, nSub);
            }
        }
        return nRet;
    }

    @Override
    public final void getInsertionPoints(ArrayList inserts) {
        inserts.addAll(this.getInserts());
        int n = this.getNodeCount();
        for (int i = 0; i < n; ++i) {
            DockLayoutInfo li = this.getNode(i);
            li.getInsertionPoints(inserts);
        }
    }

    @Override
    public final boolean saveLayout(DockLayoutPersistence p, String strMyName) {
        int n = this.getNodeCount();
        int childNodes = 0;
        p.setProperty(strMyName + ".ItemCount", Integer.toString(n));
        for (int i = 0; i < n; ++i) {
            String strLiName;
            DockLayoutInfo li = this.getNode(i);
            if (!li.saveLayout(p, strLiName = strMyName + ".Item_" + i)) continue;
            ++childNodes;
        }
        return childNodes > 0;
    }

    final boolean addLayoutComponent(JComponent component, DockLayoutConstraint dlc) {
        int n = this.getNodeCount();
        boolean bFound = false;
        Object ref = dlc.getReference();
        if (ref == null || ref == this) {
            int nOrient = dlc.getOrientation();
            int nPos = DockLayoutUtil.isBefore(nOrient) ? 0 : this.getNodeCount() - 1;
            this.addLayoutInfoLeaf(component, nPos, dlc);
            bFound = true;
        } else {
            for (int i = 0; !bFound && i < n; ++i) {
                DockLayoutInfo li = this.getNode(i);
                if (li.isReferring(ref)) {
                    this.addLayoutInfoLeaf(component, i, dlc);
                    bFound = true;
                    continue;
                }
                if (!(li instanceof AbstractDockLayoutInfoNode)) continue;
                AbstractDockLayoutInfoNode lin = (AbstractDockLayoutInfoNode)li;
                bFound = lin.addLayoutComponent(component, dlc);
            }
        }
        return bFound;
    }

    final boolean removeLayoutComponent(JComponent component) {
        int n = this.getNodeCount();
        boolean bFound = false;
        for (int i = 0; !bFound && i < n; ++i) {
            DockLayoutInfo li = this.getNode(i);
            if (li instanceof DockLayoutInfoLeaf) {
                DockLayoutInfoLeaf lil = (DockLayoutInfoLeaf)li;
                if (!lil.isReferring(component)) continue;
                this.removeNode(i);
                bFound = true;
                continue;
            }
            AbstractDockLayoutInfoNode lin = (AbstractDockLayoutInfoNode)li;
            bFound = lin.removeLayoutComponent(component);
        }
        return bFound;
    }

    final void optimize() {
        this.removeDividers();
        this.removeInserts();
        int i = this.getNodeCount() - 1;
        block4: while (i >= 0) {
            DockLayoutInfo li = this.getNode(i);
            if (li instanceof AbstractDockLayoutInfoNode) {
                AbstractDockLayoutInfoNode lin = (AbstractDockLayoutInfoNode)li;
                lin.optimize();
                switch (lin.getNodeCount()) {
                    case 0: {
                        this.removeNode(i);
                        break;
                    }
                    case 1: {
                        DockLayoutInfo liChildOfChild = lin.getNode(0);
                        if (liChildOfChild instanceof AbstractDockLayoutInfoNode) {
                            AbstractDockLayoutInfoNode lincoc = (AbstractDockLayoutInfoNode)liChildOfChild;
                            this.removeNode(i);
                            int n = lincoc.getNodeCount();
                            for (int j = 0; j < n; ++j) {
                                this.insertNode(lincoc.getNode(j), i + j);
                            }
                            continue block4;
                        }
                        this.setNode(liChildOfChild, i);
                        continue block4;
                    }
                }
            }
            --i;
        }
    }

    final DockLayoutInfo loadLayout(Container target, DockLayoutPersistence p, String strMyName) {
        return this.loadLayout(p, strMyName, 0, "");
    }

    protected final ArrayList getDividers() {
        return this._dividers;
    }

    @Override
    public final DockDivider getDivider(JComponent ref, int nOrient) {
        int i;
        DockDivider ret = null;
        int n = this.getNodeCount();
        for (i = 0; i < n; ++i) {
            DockLayoutInfo li = this.getNode(i);
            ret = li.getDivider(ref, nOrient);
            if (ret == null) continue;
            return ret;
        }
        if (nOrient == this._orientation) {
            n = this._dividers.size();
            for (i = 0; i < n; ++i) {
                DockDivider dd = (DockDivider)this._dividers.get(i);
                int nRefType = dd.referenceType(ref);
                if (nRefType == 0) continue;
                ret = dd;
            }
        }
        return ret;
    }

    protected final void addDivider(DockDivider dd) {
        this._dividers.add(dd);
    }

    protected final void removeDividers() {
        this._dividers.clear();
    }

    protected final void addInsert(DockInsertionPoint dip) {
        this._inserts.add(dip);
    }

    protected final void removeInserts() {
        this._inserts.clear();
    }

    private final ArrayList getInserts() {
        return this._inserts;
    }

    private final void addLayoutInfoLeaf(JComponent component, int nPos, DockLayoutConstraint dlc) {
        int nOrient = dlc.getOrientation();
        Dimension dLeaf = dlc.getPreferredDimension();
        DockLayoutInfoLeaf liLeaf = new DockLayoutInfoLeaf(component, dLeaf);
        boolean bBefore = DockLayoutUtil.isBefore(nOrient);
        int nodeCount = this.getNodeCount();
        if (nodeCount == 0 || this.isSameOrientation(nOrient)) {
            if (!bBefore) {
                ++nPos;
            }
            if (nPos > nodeCount) {
                nPos = nodeCount;
            }
            this.insertNode(liLeaf, nPos);
        } else {
            AbstractDockLayoutInfoNode li1 = AbstractDockLayoutInfoNode.createInfoNode(this._orientation);
            int extent = dlc.getExtent();
            int limit = Math.min(extent, nodeCount);
            for (int i = 0; i < limit; ++i) {
                li1.insertNode(this.getNode(nPos), li1.getNodeCount());
                this.removeNode(nPos);
            }
            AbstractDockLayoutInfoNode li2 = AbstractDockLayoutInfoNode.createInfoNode(nOrient);
            li2.insertNode(li1, 0);
            li2.insertNode(liLeaf, bBefore ? 0 : 1);
            this.insertNode(li2, nPos);
        }
    }

    public final boolean isSameOrientation(int nOrientation) {
        return DockLayoutUtil.isSameOrientation(this._orientation, nOrientation);
    }

    private static final AbstractDockLayoutInfoNode createInfoNode(int nOrient) {
        if (DockLayoutUtil.isHorz(nOrient)) {
            return new DockLayoutInfoHorzNode();
        }
        return new DockLayoutInfoVertNode();
    }

    private final DockLayoutInfo loadLayout(DockLayoutPersistence p, String strMyName, int nOrient, String strDbg) {
        DockLayoutInfo liRet = null;
        String strItemCount = p.getProperty(strMyName + ".ItemCount", null);
        if (strItemCount != null) {
            AbstractDockLayoutInfoNode li = AbstractDockLayoutInfoNode.createInfoNode(nOrient);
            int nItemCount = Integer.parseInt(strItemCount);
            for (int i = 0; i < nItemCount; ++i) {
                String strItemName = strMyName + ".Item_" + i;
                DockLayoutInfo liSub = this.loadLayout(p, strItemName, DockLayoutUtil.invertOrientation(nOrient), "  " + strDbg);
                if (liSub == null) continue;
                li.addNode(liSub);
            }
            if (li.getNodeCount() != 0) {
                liRet = li;
            }
        } else {
            liRet = DockLayoutInfoLeaf.loadLayout(p, strMyName);
        }
        return liRet;
    }

    public static AbstractDockLayoutInfoNode loadLayout(XMLDockLayoutPersistence xmlDockLayoutPersistence, StructuredPropertyAccess parent) {
        return AbstractDockLayoutInfoNode.loadLayout(xmlDockLayoutPersistence, parent, 0);
    }

    private static final AbstractDockLayoutInfoNode loadLayout(XMLDockLayoutPersistence xmlDockLayoutPersistence, StructuredPropertyAccess parent, int orientation) {
        AbstractDockLayoutInfoNode parentLayoutInfo = AbstractDockLayoutInfoNode.createInfoNode(orientation);
        Iterator boxes = parent.getChildNodes();
        while (boxes.hasNext()) {
            DockLayoutInfo dockLayoutInfo = null;
            StructuredPropertyAccess node = (StructuredPropertyAccess)boxes.next();
            if ("box".equals(node.getName())) {
                dockLayoutInfo = AbstractDockLayoutInfoNode.loadLayout(xmlDockLayoutPersistence, node, DockLayoutUtil.invertOrientation(orientation));
            } else if ("leafBox".equals(node.getName())) {
                dockLayoutInfo = DockLayoutInfoLeaf.loadLayout(xmlDockLayoutPersistence, node);
            }
            if (dockLayoutInfo == null) continue;
            parentLayoutInfo.addNode(dockLayoutInfo);
        }
        return parentLayoutInfo.getChildCount() > 0 ? parentLayoutInfo : null;
    }

    @Override
    public boolean saveLayout(XMLDockLayoutPersistence layoutPersistence, StructuredPropertyAccess parent) {
        int n = this.getNodeCount();
        int childNodes = 0;
        for (int i = 0; i < n; ++i) {
            DefaultStructuredPropertyAccess box;
            DockLayoutInfo li = this.getNode(i);
            if (!li.saveLayout(layoutPersistence, (StructuredPropertyAccess)(box = new DefaultStructuredPropertyAccess("box")))) continue;
            parent.appendChild((StructuredPropertyAccess)box);
            ++childNodes;
        }
        return childNodes > 0;
    }

    @Override
    public final TreeNode getChildAt(int childIndex) {
        return this.getNode(childIndex);
    }

    @Override
    public final int getChildCount() {
        return this.getNodeCount();
    }

    @Override
    public final TreeNode getParent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int getIndex(TreeNode node) {
        int i;
        for (i = this.getChildCount(); i >= 0 && this.getChildAt(i) != node; --i) {
        }
        return i;
    }

    @Override
    public final boolean getAllowsChildren() {
        return false;
    }

    @Override
    public final boolean isLeaf() {
        return false;
    }

    public final Enumeration children() {
        return Collections.enumeration(this._nodes);
    }
}

