/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.border.Border;
import oracle.ide.IdeConstants;
import oracle.ide.IdeUIManager;
import oracle.ide.controls.customtab.CustomTab;
import oracle.javatools.border.JavatoolsBorderFactory;
import oracle.javatools.ui.themes.Themes;

public final class TabbedHeader
extends Box {
    private Box _tabBox;
    private Box _controlBox;
    private CustomTab _tabs;
    private Component _controls;
    private JPanel _tabBar;

    public TabbedHeader(ListModel model) {
        super(1);
        this._tabs = new CustomTab(model, 1);
        this._tabBox = new Box(2);
        this._controlBox = new Box(0);
        this._tabBar = new JPanel();
        this._tabs.setGradientHighlight(true);
        this._tabs.setOpaque(false);
        this._tabs.setOffsetSelected(0);
        this._controlBox.setBorder(JavatoolsBorderFactory.createBottomBorder((Color)IdeConstants.COLOR_IDE_LINES));
        this._tabBar.setLayout(new BoxLayout(this._tabBar, 0));
        this._tabBar.setBorder(JavatoolsBorderFactory.createLeftBorder((Color)IdeConstants.COLOR_IDE_LINES));
        this._tabBar.add(Box.createVerticalStrut(2));
        this._tabBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                e.getComponent().requestFocus();
            }
        });
        this._tabs.setAlignmentY(0.5f);
        this._controlBox.setAlignmentY(0.5f);
        this._tabBox.add((Component)this._tabs);
        this._tabBox.add(this._controlBox);
        this._tabBox.setAlignmentY(0.5f);
        this._tabBar.setAlignmentY(0.5f);
        this.add(this._tabBox);
        if (!Themes.isThemed()) {
            this.add(this._tabBar);
        }
        this.setFocused(false);
        this.setControls(null);
    }

    public void setControls(Component controls) {
        this._controlBox.removeAll();
        this._controlBox.add(Box.createHorizontalGlue());
        if (controls != null) {
            this._controlBox.add(controls);
        }
        this._controls = controls;
    }

    public Component getControls() {
        return this._controls;
    }

    public void setFocused(boolean focused) {
        if (Themes.isThemed()) {
            Border b = JavatoolsBorderFactory.createBottomBorder((Color)Themes.getActiveTheme().getStateProperties("view", focused ? "active" : "inactive").getColor("bordercolor"));
            this._controlBox.setBorder(b);
        }
        this._tabs.setFocused(focused);
        this._tabBar.setBackground(focused ? IdeUIManager.getActiveTitleGradientDarkColor() : IdeUIManager.getInactiveTitleGradientDarkColor());
    }

    public boolean isFocused() {
        return this._tabs.isFocused();
    }

    public CustomTab getCustomTab() {
        return this._tabs;
    }
}

