/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.controls.ScrollableTabBar;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.util.GraphicsUtils;

public final class SwitchablePanel
extends JLayeredPane
implements ListSelectionListener {
    private ScrollableTabBar _tabBar;
    private HashMap _map = new HashMap();
    private boolean _removingAllPages;

    public SwitchablePanel() {
        this._tabBar = new ScrollableTabBar();
        this._tabBar.getTabs().setPosition(3);
        this._tabBar.getTabs().addSelectionListener((ListSelectionListener)this);
        this._tabBar.getTabs().setCompressible(true);
        this._tabBar.getTabs().setModel(new DefaultListModel());
        this.add((Component)this._tabBar, JLayeredPane.DEFAULT_LAYER - 1, -1);
    }

    public void displayDropdownMenu() {
        this._tabBar.showDropDownMenu();
    }

    public void ensureTabVisible() {
        this._tabBar.ensureSelectedTabVisible();
    }

    @Override
    public void doLayout() {
        Rectangle componentRect;
        Rectangle tabBarRect;
        Insets insets = this.getInsets();
        int paneWidth = this.getWidth() - (insets.left + insets.right);
        int paneHeight = this.getHeight() - (insets.top + insets.bottom);
        Dimension psTabBar = this._tabBar.getPreferredSize();
        int tabBarHeight = Math.min(psTabBar.height, paneHeight);
        if (this.getCustomTab().getPosition() == 1) {
            tabBarRect = new Rectangle(insets.left, insets.top, paneWidth, tabBarHeight);
            componentRect = new Rectangle(insets.left, insets.top + tabBarHeight, paneWidth, paneHeight - tabBarHeight);
        } else {
            componentRect = new Rectangle(insets.left, insets.top, paneWidth, paneHeight - tabBarHeight);
            tabBarRect = new Rectangle(insets.left, insets.top + componentRect.height, paneWidth, tabBarHeight);
        }
        this._tabBar.setBounds(tabBarRect);
        Component[] compsInLayer = this.getComponentsInLayer(JLayeredPane.DEFAULT_LAYER);
        for (int i = 0; i < compsInLayer.length; ++i) {
            Component comp = compsInLayer[i];
            comp.setBounds(componentRect);
        }
    }

    public void addPage(CustomTabPage page, Component component) {
        if (!this._map.containsKey(page)) {
            this._map.put(page, component);
            this.getModel().addElement(page);
            this.add(component, JLayeredPane.DEFAULT_LAYER, -1);
            if (component instanceof Container) {
                ((Container)component).setFocusCycleRoot(true);
            }
        }
    }

    public void addPage(CustomTabPage page, Component component, int index) {
        this.addPage(page, component);
        this.getModel().removeElement(page);
        this.getModel().add(index, page);
    }

    public DefaultListModel getModel() {
        return (DefaultListModel)this._tabBar.getTabs().getModel();
    }

    public void addPage(String name, Icon icon, Component gui, String tooltip, Object data) {
        DefaultCustomTabPage tabPage = null;
        tabPage = new DefaultCustomTabPage(icon, name, data);
        tabPage.setTooltip(tooltip);
        this.addPage((CustomTabPage)tabPage, gui);
        if (gui.getAccessibleContext() != null) {
            gui.getAccessibleContext().setAccessibleName(name);
        }
    }

    public void removePage(CustomTabPage page) {
        final Component comp = (Component)this._map.get(page);
        boolean hadFocus = false;
        if (comp != null) {
            Component focusedComp = GraphicsUtils.getFocusedChildComponent((Component)comp);
            if (focusedComp != null) {
                hadFocus = true;
            }
            this.moveToBack(comp);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwitchablePanel.this.remove(comp);
                }
            });
            this.getModel().removeElement(page);
            this._map.remove(page);
            if (this.getModel().getSize() > 0 && !this._removingAllPages) {
                int selPage = this.getCustomTab().getSelectedPage();
                Component newComp = null;
                if (selPage != -1) {
                    CustomTabPage tabPage = this.getCustomTab().getPage(selPage);
                    newComp = this.getComponentForPage(tabPage);
                    newComp.setVisible(true);
                }
                if (hadFocus && newComp != null) {
                    GraphicsUtils.focusComponentOrChild(newComp, (boolean)true);
                }
            }
        }
    }

    public void removeAllPages() {
        this._removingAllPages = true;
        int numElem = this._map.size();
        CustomTabPage[] pageArr = this._map.keySet().toArray(new CustomTabPage[numElem]);
        for (int i = 0; i < pageArr.length; ++i) {
            this.removePage(pageArr[i]);
        }
        this._removingAllPages = false;
    }

    public void removeComponent(Component comp) {
        Iterator iterator = this._map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry mapEntry = iterator.next();
            if (mapEntry.getValue() != comp) continue;
            iterator.remove();
            return;
        }
    }

    public int getPageCount() {
        return this._map.size();
    }

    public Component getComponentForPage(CustomTabPage page) {
        return (Component)this._map.get(page);
    }

    public DefaultCustomTabPage getTabPageForComponent(Component comp) {
        for (Map.Entry mapEntry : this._map.entrySet()) {
            if (mapEntry.getValue() != comp || !(mapEntry.getKey() instanceof DefaultCustomTabPage)) continue;
            return (DefaultCustomTabPage)mapEntry.getKey();
        }
        return null;
    }

    public CustomTab getCustomTab() {
        return this._tabBar.getTabs();
    }

    public ScrollableTabBar getTabBar() {
        return this._tabBar;
    }

    public void moveToFront(Component comp, boolean takeFocus) {
        JComponent focusComp;
        if (this.getPosition(comp) != 0) {
            Component[] comps = super.getComponentsInLayer(JLayeredPane.DEFAULT_LAYER);
            Component oldComp = comps[0];
            super.moveToFront(comp);
            oldComp.setVisible(false);
            comp.setVisible(true);
            this.validate();
            this._tabBar.ensureSelectedTabVisible();
        }
        if (takeFocus && (focusComp = GraphicsUtils.focusComponentOrChild((Component)comp, (boolean)true)) != null && focusComp.getAccessibleContext() != null) {
            focusComp.getAccessibleContext().setAccessibleName(comp.getAccessibleContext().getAccessibleName());
        }
    }

    public void moveToFront(CustomTabPage page, boolean takeFocus) {
        Component comp = this.getComponentForPage(page);
        if (comp != null) {
            this.moveToFront(comp, takeFocus);
        }
    }

    @Override
    public Component getComponent(int n) {
        Component[] comps = this.getComponents();
        if (n < 0 || n >= comps.length) {
            throw new ArrayIndexOutOfBoundsException("No such child: " + n);
        }
        for (int i = 0; i < comps.length; ++i) {
            Component c;
            if (comps[i] != this._tabBar) continue;
            if (i >= comps.length - 1) break;
            comps[i] = c = comps[comps.length - 1];
            comps[comps.length - 1] = this._tabBar;
            break;
        }
        return comps[n];
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getFirstIndex() == -1) {
            return;
        }
        CustomTabPage selectedPage = this.getCustomTab().getPage(e.getFirstIndex());
        Component comp = this.getComponentForPage(selectedPage);
        if (comp != null && this.getPosition(comp) != 0) {
            boolean panelContainsFocus = GraphicsUtils.isAncestorOfFocusedComponent((Component)this);
            this.moveToFront(comp, panelContainsFocus);
        }
    }
}

