/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.StringBufferInputStream;
import java.util.logging.LogManager;
import oracle.ide.IdeArgs;
import oracle.ide.IdeRunner;
import oracle.ide.IdeStarter;
import oracle.ide.performance.PerformanceLogger;
import oracle.ideimpl.DefaultIdeCore;
import oracle.ideimpl.DefaultIdeStarter;
import oracle.ideri.util.Product;

public final class Main {
    private Main() {
    }

    private static void setupLogging() {
        File directory;
        String path;
        if (System.getProperty("java.util.logging.config.class") != null) {
            return;
        }
        if (System.getProperty("java.util.logging.config.file") != null) {
            return;
        }
        if (Boolean.getBoolean("ide.standard.logging")) {
            return;
        }
        StringBufferInputStream custom = null;
        if (System.getProperty("ide.logging.properties") != null) {
            custom = new StringBufferInputStream(System.getProperty("ide.logging.properties").replace(';', '\n'));
        }
        if ((path = System.getProperty("ide.logging.config.file")) != null && Main.load(new File(path), custom)) {
            return;
        }
        boolean debug = Boolean.getBoolean("ide.debugbuild") && !Boolean.getBoolean("ide.logging.nondebug");
        String conf = System.getProperty("ide.conf");
        if (conf != null) {
            File file = new File(conf);
            directory = file.getParentFile();
            String name = file.getName();
            int dot = name.lastIndexOf(46);
            if (dot < 0) {
                dot = name.length();
            }
            name = name.substring(0, dot);
            if (debug && Main.load(new File(directory, name + "-logging-debug.conf"), custom)) {
                return;
            }
            if (Main.load(new File(directory, name + "-logging.conf"), custom)) {
                return;
            }
        } else {
            directory = new File(System.getProperty("user.dir"));
        }
        directory = new File(new File(directory.getParentFile().getParentFile(), "ide"), "bin");
        if (debug && Main.load(new File(directory, "ide-logging-debug.conf"), custom)) {
            return;
        }
        Main.load(new File(directory, "ide-logging.conf"), custom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean load(File file, InputStream cis) {
        if (file != null && !file.isFile()) {
            return false;
        }
        if (file == null && cis == null) {
            return true;
        }
        InputStream is = null;
        try {
            if (file != null) {
                BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
                is = cis == null ? fis : new SequenceInputStream(fis, cis);
            } else {
                is = cis;
            }
            LogManager.getLogManager().readConfiguration(is);
        }
        catch (IOException e) {
            System.err.println("Exception loading logger configuration: " + file);
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public static void main(String[] args) {
        Main.setupLogging();
        long start = System.nanoTime();
        new Main().start(args);
        PerformanceLogger.get().log("startupTime", "", System.nanoTime() - start);
    }

    private void start(String[] arguments) {
        try {
            DefaultIdeStarter starter;
            String productID = Product.getProductID();
            if (productID == null) {
                productID = "oracle.ide";
            }
            String command = System.getProperty("ide.command");
            String starterTypeName = System.getProperty("ide.starter.class");
            if (starterTypeName != null) {
                Class<?> type = Class.forName(starterTypeName);
                starter = (IdeStarter)type.newInstance();
            } else {
                starter = new DefaultIdeStarter();
            }
            DefaultIdeCore ideCore = new DefaultIdeCore(new IdeArgs(arguments), productID);
            starter.startIde(command, arguments, ideCore);
            String runnerTypeName = System.getProperty("ide.runner.class");
            if (runnerTypeName != null) {
                ClassLoader extensionClassLoader = Thread.currentThread().getContextClassLoader();
                Class<?> type = Class.forName(runnerTypeName, true, extensionClassLoader);
                IdeRunner runner = (IdeRunner)type.newInstance();
                runner.runCommand((IdeStarter)starter);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }
}

