/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.IdeUIManager;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.migration.ExtensionMigrator;
import oracle.ide.net.URLFactory;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

public class IdeMigrator
extends ExtensionMigrator {
    protected List getSettingKeys() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("DockingConfigOptions");
        list.add("editors-options");
        list.add("environment-options");
        list.add("global-ignore-list");
        list.add("HistoryOptions");
        list.add(KeyStrokeOptions.KEY_SETTINGS);
        list.add("WizardSettings");
        list.add("jsr198");
        list.add("proxy-options");
        list.add("WebBrowserOptions");
        return list;
    }

    protected String getExtensionID() {
        return "oracle.ide";
    }

    public String[] migrate(File sourceDir, File destDir) {
        File settingsXmlFile;
        IdeSettings ideSettings = Ide.getSettings();
        KeyStrokeOptions keystrokeOptions = ideSettings.getKeyStrokeOptions();
        ActionListener panelEventDispatcher = keystrokeOptions.getKeyboardPanelEventDispatcher();
        String[] ret = super.migrate(sourceDir, destDir);
        ClientSetting setting = ClientSetting.findOrCreate((String)this.getExtensionID());
        Object data = setting.getData("environment-options");
        if (data == null && (settingsXmlFile = new File(sourceDir, "settings.xml")).exists()) {
            URL url = URLFactory.newFileURL((File)settingsXmlFile);
            Object2Dom o2d = Object2Dom.newInstance();
            Map map = null;
            try {
                map = (Map)o2d.toObject(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (map != null && (data = map.get("environment-options")) instanceof Copyable) {
                setting.putData("environment-options", data);
            }
        }
        if (data instanceof EnvironOptions) {
            EnvironOptions options = (EnvironOptions)data;
            options.adjustAfterMigration();
            options.setLafClass("");
            IdeUIManager uiManager = IdeUIManager.getUIManager();
            String themeClass = options.getLafThemeClass();
            if (ModelUtil.hasLength((String)themeClass)) {
                String lafClass = options.getLafClass();
                IdeUIManager.ThemeInfo[] themes = uiManager.getInstalledThemes(lafClass);
                boolean foundTheme = false;
                for (int i = 0; i < themes.length; ++i) {
                    IdeUIManager.ThemeInfo theme = themes[i];
                    if (!ModelUtil.areEqual((Object)themeClass, (Object)theme.getClassName())) continue;
                    foundTheme = true;
                    break;
                }
                if (!foundTheme) {
                    options.setLafThemeClass("");
                }
            }
            ideSettings = Ide.getSettings();
            ideSettings.removeLegacyData("environment-options");
            ideSettings.putLegacyData("environment-options", (Copyable)options);
        }
        keystrokeOptions = ideSettings.getKeyStrokeOptions();
        keystrokeOptions.setKeyboardPanelEventDispatcher(panelEventDispatcher);
        return ret;
    }
}

