/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.ControllerProvider;
import oracle.ide.controls.FocusHierarchyEvent;
import oracle.ide.controls.FocusHierarchyListener;
import oracle.ide.editor.Editor;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ideimpl.MainWindowImpl;

public class ActiveViewHandlerImpl
implements FocusHierarchyListener,
ChangeListener,
MainWindowImpl.ControllerContextImpl {
    private static final boolean DEBUG_TRACE_VIEW_CHANGES = Boolean.valueOf(Ide.getProperty((String)"DEBUG_TRACE_VIEW_CHANGES", (String)"false"));
    private static final boolean DEBUG_TRACE_FOCUS_CHANGES = Boolean.valueOf(Ide.getProperty((String)"DEBUG_TRACE_FOCUS_CHANGES", (String)"false"));
    private View _lastActiveView;
    private Map<Component, WeakReference<View>> _componentToView = new WeakHashMap<Component, WeakReference<View>>();
    private Map<View, WeakReference<Component>> _viewToComponent = new WeakHashMap<View, WeakReference<Component>>();
    private Map<Component, ControllerProvider> _componentToControllerProvider = new WeakHashMap<Component, ControllerProvider>();
    private ArrayList _activeViewListeners = new ArrayList(2);
    private Map<View, List<ControllerProvider>> _cachedControllerStacks = new WeakHashMap<View, List<ControllerProvider>>();

    ActiveViewHandlerImpl() {
    }

    public synchronized void addDependant(Component component, View view) {
        this._componentToView.put(component, new WeakReference<View>(view));
        this._viewToComponent.put(view, new WeakReference<Component>(component));
        this.clearControllerStacksCache();
    }

    public synchronized void removeDependant(View view) {
        if (view != null) {
            try {
                WeakReference<Component> cRef = this._viewToComponent.remove(view);
                if (cRef == null) {
                    return;
                }
                Component component = (Component)cRef.get();
                if (component != null) {
                    this._componentToView.remove(component);
                    this.clearControllerStacksCache();
                    if (view == this.getLastActiveView()) {
                        this.solveActiveView(null);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void removeDependant(Component component) {
        WeakReference<View> vRef = this._componentToView.get(component);
        if (vRef == null) {
            return;
        }
        View view = (View)vRef.get();
        if (view != null) {
            this.removeDependant(view);
        }
    }

    public synchronized void addControllerProvider(Component component, ControllerProvider controllerProvider) {
        this._componentToControllerProvider.put(component, controllerProvider);
        this.clearControllerStacksCache();
    }

    public synchronized void removeControllerProvider(Component component) {
        this._componentToControllerProvider.remove(component);
        this.clearControllerStacksCache();
    }

    public synchronized void addActiveViewListener(ActiveViewListener l) {
        if (!this._activeViewListeners.contains(l)) {
            this._activeViewListeners.add(l);
        }
    }

    public synchronized void removeActiveViewListener(ActiveViewListener l) {
        this._activeViewListeners.remove(l);
    }

    private synchronized void fireActiveViewChanged(ActiveViewEvent e) {
        int count = this._activeViewListeners.size();
        ActiveViewListener[] listeners = this._activeViewListeners.toArray(new ActiveViewListener[count]);
        for (int i = 0; i < count; ++i) {
            try {
                long startTime = System.nanoTime();
                listeners[i].activeViewChanged(e);
                long endTime = System.nanoTime();
                PerformanceLogger.get().log("ActiveViewListener.activeViewChanged", listeners[i].getClass().getName(), endTime - startTime);
                continue;
            }
            catch (Exception ex) {
                FeedbackManager.reportException((Throwable)ex);
            }
        }
    }

    private void cacheControllerStack(View view, List<ControllerProvider> retControllerStack) {
        this._cachedControllerStacks.put(view, retControllerStack);
    }

    private List<ControllerProvider> getCachedControllerStack(View view) {
        return this._cachedControllerStacks.get(view);
    }

    private void clearControllerStacksCache() {
        this._cachedControllerStacks.clear();
    }

    public View getLastActiveView() {
        return this._lastActiveView;
    }

    private void setActiveView(View activeView) {
        if (activeView != null && activeView != this._lastActiveView) {
            this.clearControllerStacksCache();
            if (DEBUG_TRACE_VIEW_CHANGES) {
                // empty if block
            }
            if (this._lastActiveView != null) {
                try {
                    this._lastActiveView.deactivate();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            ActiveViewEvent e = new ActiveViewEvent((Object)this, this._lastActiveView, activeView);
            this._lastActiveView = activeView;
            if (this._lastActiveView != null) {
                try {
                    this._lastActiveView.activate();
                    this._lastActiveView.updateSelection();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            this.fireActiveViewChanged(e);
        }
    }

    public void focusGained(FocusHierarchyEvent event) {
        this.trace("focusGained", event);
        ArrayList list = event.getHierarchy();
        if (list.size() > 0) {
            this.addTabbedPaneChangeListener(list);
            Component c = (Component)list.get(0);
            this.solveActiveView(c);
        }
    }

    public void focusLost(FocusHierarchyEvent event) {
        this.trace("focusLost", event);
        ArrayList list = event.getHierarchy();
        if (list.size() > 0) {
            this.removeTabbedPaneChangeListener(list);
        }
    }

    private void trace(String focusEventName, FocusHierarchyEvent event) {
        if (DEBUG_TRACE_FOCUS_CHANGES) {
            ArrayList hierarchy = event.getHierarchy();
            System.out.println("-------------------------- " + focusEventName);
            ArrayList<String> lines = new ArrayList<String>(20);
            for (Component focusedComponent = (Component)hierarchy.get(0); focusedComponent != null; focusedComponent = focusedComponent.getParent()) {
                String className = focusedComponent.getClass().getName();
                lines.add(className);
            }
            int n = lines.size();
            for (int i = n - 1; i >= 0; --i) {
                for (int j = 0; j < n - i; ++j) {
                    System.out.print("  ");
                }
                String s = (String)lines.get(i);
                System.out.println(s);
            }
            System.out.flush();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Component source = (Component)e.getSource();
        if (source.hasFocus()) {
            this.solveActiveView(source);
        }
    }

    private void addTabbedPaneChangeListener(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Component c = (Component)list.get(i);
            if (!(c instanceof JTabbedPane)) continue;
            JTabbedPane tabbedPane = (JTabbedPane)c;
            tabbedPane.addChangeListener(this);
            break;
        }
    }

    private void removeTabbedPaneChangeListener(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Component c = (Component)list.get(i);
            if (!(c instanceof JTabbedPane)) continue;
            JTabbedPane tabbedPane = (JTabbedPane)c;
            tabbedPane.removeChangeListener(this);
            break;
        }
    }

    private void solveActiveView(Component component) {
        View activeView = this.findActiveView(component);
        if (component != null && component.getClass().getName().endsWith("ZoomComboBox") && activeView instanceof Editor) {
            return;
        }
        this.setActiveView(activeView);
    }

    private View findActiveView(Component focusedComponent) {
        View activeView = null;
        if (focusedComponent != null) {
            for (Component c = focusedComponent; activeView == null && c != null; c = c.getParent()) {
                WeakReference<View> dependantView = this._componentToView.get(c);
                if (dependantView == null) continue;
                View view = (View)dependantView.get();
                if (activeView != null) continue;
                activeView = view;
            }
        } else {
            IdeMainWindow mainWindow = Ide.getMainWindow();
            activeView = mainWindow.getIdeMainWindowView();
        }
        return activeView;
    }

    public List<ControllerProvider> getControllerProviders(View view) {
        ArrayList<ControllerProvider> retControllerStack;
        ArrayList<ControllerProvider> cachedControllerStack = this.getCachedControllerStack(view);
        if (cachedControllerStack == null) {
            Component currentLevel;
            WeakReference<Component> vRef = this._viewToComponent.get(view);
            if (vRef == null) {
                return Collections.EMPTY_LIST;
            }
            Component viewComponent = (Component)vRef.get();
            retControllerStack = null;
            if (viewComponent != null) {
                currentLevel = viewComponent;
            } else {
                IdeMainWindow mainWindow = Ide.getMainWindow();
                currentLevel = mainWindow;
            }
            for (currentLevel = currentLevel.getParent(); currentLevel != null; currentLevel = currentLevel.getParent()) {
                ControllerProvider controllerProvider = this._componentToControllerProvider.get(currentLevel);
                if (controllerProvider == null) {
                    WeakReference<View> cpRef = this._componentToView.get(currentLevel);
                    View view2 = controllerProvider = cpRef != null ? (View)cpRef.get() : null;
                }
                if (controllerProvider == null) continue;
                if (retControllerStack == null) {
                    retControllerStack = new ArrayList<ControllerProvider>(2);
                }
                retControllerStack.add(controllerProvider);
            }
            if (retControllerStack == null) {
                retControllerStack = Collections.EMPTY_LIST;
            }
            this.cacheControllerStack(view, (List<ControllerProvider>)retControllerStack);
        } else {
            retControllerStack = cachedControllerStack;
        }
        return retControllerStack;
    }

    EventListener[] getListeners(Class listenerType) {
        return this._activeViewListeners.toArray(new EventListener[this._activeViewListeners.size()]);
    }

    List<View> getVisibleViews() {
        ArrayList<View> views = new ArrayList<View>();
        for (View view : this._viewToComponent.keySet()) {
            if (view == null || !view.isVisible()) continue;
            views.add(view);
        }
        views.add(Ide.getMainWindow().getIdeMainWindowView());
        return views;
    }
}

