/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.util.HttpConnection;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WfsUtil {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);

    public static Hashtable getFeatureTypesAttrNamesUsingHttpGet(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        String string2 = string.trim();
        if (string2.lastIndexOf(63) > -1) {
            if (!string2.endsWith("?") && !string2.endsWith("&")) {
                string2 = string2 + "&";
            }
        } else if (!string2.endsWith("&")) {
            string2 = string2 + "?";
        }
        string2 = string2 + "VERSION=1.0.0&SERVICE=WFS&REQUEST=DescribeFeatureType";
        log.info("WFS GET request: " + string2);
        String string3 = "";
        try {
            string3 = Util.issueHttpGetRequest(string2);
        }
        catch (Exception exception) {
            log.info("Exception: " + exception.getMessage());
            return null;
        }
        if (string3 == null) {
            log.warning("Http GET request returned NULL string.");
            return null;
        }
        if (string3.indexOf("<ExceptionReport") > -1) {
            log.warning("Exception report returned:\n" + string3);
            return null;
        }
        Hashtable hashtable = null;
        hashtable = WfsUtil.hasComplexTypeNode(string3) ? WfsUtil.processAttributeNamesRequest(string3) : WfsUtil.processMultipleAttributeSchemas(string3);
        return hashtable;
    }

    public static Hashtable getFeatureTypesAttrNamesUsingHttpPost(String string) {
        Object object;
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        String string2 = string.trim();
        String string3 = "<?xml version=\"1.0\" ?>\n<wfs:DescribeFeatureType\n   service=\"WFS\"\n   version=\"1.0.0\"\n   xmlns:wfs=\"http://www.opengis.net/wfs\"\n   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n   xmlns:xd=\"http://www.w3.org/2001/XMLSchema\"\n   xsi:schemaLocation=\"http://www.opengis.net/wfs ../wfs/1.0.0/WFS-basic.xsd\">\n";
        string3 = string3 + "</wfs:DescribeFeatureType>\n";
        log.info("WFS POST address: " + string2);
        log.info("WFS POST Request: " + string3);
        String string4 = "";
        try {
            object = new HttpConnection();
            ((HttpConnection)object).connect(string2);
            ((HttpConnection)object).sendXMLRequest("", string3);
            string4 = ((HttpConnection)object).getXMLResponse();
        }
        catch (Exception exception) {
            log.info("Exception: " + exception.getMessage());
            return null;
        }
        if (string4 == null) {
            log.warning("Http POST request returned NULL string.");
            return null;
        }
        if (string4.indexOf("<ExceptionReport") > -1) {
            log.warning("Exception report returned:\n" + string4);
            return null;
        }
        object = null;
        object = WfsUtil.hasComplexTypeNode(string4) ? WfsUtil.processAttributeNamesRequest(string4) : WfsUtil.processMultipleAttributeSchemas(string4);
        return object;
    }

    private static Hashtable processAttributeNamesRequest(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        Hashtable hashtable = new Hashtable();
        try {
            Object object;
            AbstractList abstractList;
            XMLDOMParser xMLDOMParser = new XMLDOMParser();
            if (!xMLDOMParser.parse(string)) {
                log.info("Unable to parse describe feature type result.");
                return null;
            }
            Document document = xMLDOMParser.getDocument();
            Node node = document.getFirstChild();
            if (node == null) {
                log.info("No root node found while processing attribute names.");
                return null;
            }
            if (node.getNodeName().indexOf("schema") < 0 && (node = WfsUtil.getSchemaNode(document)) == null) {
                log.info("Unable to find schema node.");
                return null;
            }
            log.info("Parsing feature attribute names.");
            String string2 = "";
            String string3 = node.getNodeName();
            int n = string3.indexOf(":");
            if (n > -1) {
                string2 = string3.substring(0, n) + ":";
            } else {
                abstractList = XMLDOMParser.getRealChildNodes(node);
                if (abstractList != null) {
                    for (int i = 0; i < ((ArrayList)abstractList).size(); ++i) {
                        object = (Node)((ArrayList)abstractList).get(i);
                        int n2 = object.getNodeName().indexOf(":element");
                        if (n2 <= -1) continue;
                        string2 = object.getNodeName().substring(0, n2 + 1);
                        break;
                    }
                }
            }
            abstractList = WfsUtil.getChildNodes(node, string2 + "element");
            String string4 = null;
            object = null;
            String string5 = null;
            if (abstractList != null) {
                for (int i = 0; i < ((Vector)abstractList).size(); ++i) {
                    Node node2;
                    Node node3;
                    Node node4;
                    string4 = null;
                    Node node5 = (Node)((Vector)abstractList).get(i);
                    object = XMLDOMParser.getAttribute(node5, "name");
                    if (object == null) continue;
                    string5 = XMLDOMParser.getAttribute(node5, "type");
                    if (string5 == null) continue;
                    string4 = Util.normalize(string5.trim());
                    Vector vector = WfsUtil.getChildNodes(node, string2 + "complexType");
                    Node node6 = null;
                    if (vector != null) {
                        for (int j = 0; j < vector.size(); ++j) {
                            node4 = (Node)vector.get(j);
                            string5 = XMLDOMParser.getAttribute(node4, "name");
                            if (string5 == null || !string5.trim().equalsIgnoreCase(string4)) continue;
                            node6 = node4;
                            break;
                        }
                    }
                    if (node6 == null || (vector = WfsUtil.getChildNodes(node6, string2 + "complexContent")) == null || (vector = WfsUtil.getChildNodes(node3 = (Node)vector.get(0), string2 + "extension")) == null || (vector = WfsUtil.getChildNodes(node4 = (Node)vector.get(0), string2 + "sequence")) == null || (vector = WfsUtil.getChildNodes(node2 = (Node)vector.get(0), string2 + "element")) == null) continue;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (int j = 0; j < vector.size(); ++j) {
                        Node node7 = (Node)vector.get(j);
                        String string6 = XMLDOMParser.getAttribute(node7, "ref");
                        if (string6 != null) {
                            if (string6.indexOf("gml:") == -1) {
                                arrayList.add(Util.normalize(string6));
                                continue;
                            }
                            arrayList.add(string6);
                            continue;
                        }
                        String string7 = XMLDOMParser.getAttribute(node7, "name");
                        if (string7 == null) continue;
                        arrayList.add(string7);
                    }
                    Collections.sort(arrayList);
                    hashtable.put(object, arrayList);
                    log.info("Feature " + (String)object + " completed.");
                }
            }
        }
        catch (Exception exception) {
            log.info("Exception in processAttributeNamesRequest: " + exception.getMessage());
            return null;
        }
        if (hashtable.size() == 0) {
            hashtable = null;
        }
        log.info("End of parsing feature attribute names.");
        return hashtable;
    }

    private static Hashtable processMultipleAttributeSchemas(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        Hashtable hashtable = null;
        try {
            Node node;
            int n;
            AbstractList abstractList;
            XMLDOMParser xMLDOMParser = new XMLDOMParser();
            if (!xMLDOMParser.parse(string)) {
                log.info("Unable to parse describe feature type result.");
                return null;
            }
            Document document = xMLDOMParser.getDocument();
            Node node2 = document.getFirstChild();
            if (node2 == null) {
                log.info("No root node found while processing attribute names.");
                return null;
            }
            if (node2.getNodeName().indexOf("schema") < 0 && (node2 = WfsUtil.getSchemaNode(document)) == null) {
                log.info("Unable to find schema node.");
                return null;
            }
            log.info("Parsing feature attribute names with multiple schemas.");
            String string2 = "";
            String string3 = node2.getNodeName();
            int n2 = string3.indexOf(":");
            if (n2 > -1) {
                string2 = string3.substring(0, n2) + ":";
            } else {
                abstractList = XMLDOMParser.getRealChildNodes(node2);
                if (abstractList != null) {
                    for (n = 0; n < ((ArrayList)abstractList).size(); ++n) {
                        node = (Node)((ArrayList)abstractList).get(n);
                        int n3 = node.getNodeName().indexOf(":import");
                        if (n3 <= -1) continue;
                        string2 = node.getNodeName().substring(0, n3 + 1);
                        break;
                    }
                }
            }
            abstractList = WfsUtil.getChildNodes(node2, string2 + "import");
            if (abstractList != null) {
                for (n = 0; n < ((Vector)abstractList).size(); ++n) {
                    node = (Node)((Vector)abstractList).get(n);
                    String string4 = XMLDOMParser.getAttribute(node, "schemaLocation");
                    if (string4 == null || string4.trim().length() <= 0) continue;
                    log.info("Schema Location: " + string4);
                    string = Util.issueHttpGetRequest(string4);
                    Hashtable hashtable2 = WfsUtil.processAttributeNamesRequest(string);
                    if (hashtable2 == null) continue;
                    if (hashtable == null) {
                        hashtable = hashtable2;
                        continue;
                    }
                    Enumeration enumeration = hashtable2.keys();
                    while (enumeration.hasMoreElements()) {
                        String string5 = (String)enumeration.nextElement();
                        hashtable.put(string5, hashtable2.get(string5));
                    }
                }
            }
        }
        catch (Exception exception) {
            log.info("Exception in processMultipleAttributeSchemas:\n" + exception.getMessage());
            return null;
        }
        log.info("End of parsing feature attribute names with multiple schemas.");
        return hashtable;
    }

    private static boolean hasComplexTypeNode(String string) {
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        try {
            Vector vector;
            XMLDOMParser xMLDOMParser = new XMLDOMParser();
            if (!xMLDOMParser.parse(string)) {
                log.info("Unable to parse describe feature type result.");
                return false;
            }
            Document document = xMLDOMParser.getDocument();
            Node node = document.getFirstChild();
            if (node == null) {
                log.info("Root node not found while processing attribute names.");
                return false;
            }
            if (node.getNodeName().indexOf("schema") < 0 && (node = WfsUtil.getSchemaNode(document)) == null) {
                log.info("Unable to find schema node.");
                return false;
            }
            String string2 = "";
            String string3 = node.getNodeName();
            int n = string3.indexOf(":");
            if (n > -1) {
                string2 = string3.substring(0, n) + ":";
            }
            if ((vector = WfsUtil.getChildNodes(node, string2 + "complexType")) != null && vector.size() > 0) {
                return true;
            }
            if (n == -1) {
                ArrayList arrayList = XMLDOMParser.getRealChildNodes(node);
                if (arrayList != null) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        Node node2 = (Node)arrayList.get(i);
                        int n2 = node2.getNodeName().indexOf(":complexType");
                        if (n2 <= -1) continue;
                        return true;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static Vector getChildNodes(Node node, String string) {
        if (node == null || string == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null) {
            return null;
        }
        Vector<Node> vector = new Vector<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string2 = node2.getNodeName().trim();
            if (!string2.equalsIgnoreCase(string)) continue;
            vector.add(node2);
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    private static Node getSchemaNode(Document document) {
        if (document == null) {
            return null;
        }
        NodeList nodeList = document.getChildNodes();
        if (nodeList == null || nodeList.getLength() < 1) {
            return null;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeName().indexOf("schema") <= -1) continue;
            return node;
        }
        return null;
    }
}

