/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.Proj;

public class ShapeUtil {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static final float[] closeCoords = new float[6];
    static float[] pointCoord = new float[6];
    static AffineTransform _shiftLeft180 = null;
    static Area _rightHemisphere180 = null;
    static Area _leftHemisphere180 = null;
    private static AffineTransform _shift0 = null;
    private static Area _rightHemisphere0 = null;
    private static Area _leftHemisphere0 = null;

    public static double lengthOf(Shape shape) {
        PathIterator pathIterator = shape.getPathIterator(null);
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.POSITIVE_INFINITY;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.POSITIVE_INFINITY;
        double d7 = 0.0;
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(dArray)) {
                case 0: {
                    d = d5 = dArray[0];
                    d2 = d6 = dArray[1];
                    d3 = Double.POSITIVE_INFINITY;
                    d4 = Double.POSITIVE_INFINITY;
                    break;
                }
                case 1: {
                    if (d3 != Double.POSITIVE_INFINITY && d4 != Double.POSITIVE_INFINITY) {
                        d = d3;
                        d2 = d4;
                    }
                    d3 = dArray[0];
                    d4 = dArray[1];
                    d7 += Math.sqrt((d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2));
                    break;
                }
                case 4: {
                    d = d3;
                    d2 = d4;
                    d3 = d5;
                    d4 = d6;
                    d7 += Math.sqrt((d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2));
                    break;
                }
                case 2: 
                case 3: {
                    log.warning("[ShapeUtil] lengthOf: invalid segment type.");
                }
            }
            pathIterator.next();
        }
        return d7;
    }

    public static double[] getEndPoints(Shape shape) {
        if (shape == null) {
            return null;
        }
        PathIterator pathIterator = shape.getPathIterator(null);
        boolean bl = false;
        double[] dArray = new double[6];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(dArray)) {
                case 0: 
                case 1: {
                    if (!bl) {
                        d = dArray[0];
                        d2 = dArray[1];
                        bl = true;
                    }
                    d3 = dArray[0];
                    d4 = dArray[1];
                    break;
                }
                case 4: {
                    break;
                }
                case 3: {
                    if (!bl) {
                        d = dArray[0];
                        d2 = dArray[1];
                        bl = true;
                    }
                    d3 = dArray[4];
                    d4 = dArray[5];
                    break;
                }
                case 2: {
                    if (!bl) {
                        d = dArray[0];
                        d2 = dArray[1];
                        bl = true;
                    }
                    d3 = dArray[2];
                    d4 = dArray[3];
                }
            }
            pathIterator.next();
        }
        dArray[0] = d;
        dArray[1] = d2;
        dArray[2] = d3;
        dArray[3] = d4;
        return dArray;
    }

    public static double estLengthOf(Shape shape) {
        PathIterator pathIterator = shape.getPathIterator(null);
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.POSITIVE_INFINITY;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.POSITIVE_INFINITY;
        double d7 = 0.0;
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(dArray)) {
                case 0: {
                    d = d5 = dArray[0];
                    d2 = d6 = dArray[1];
                    d3 = Double.POSITIVE_INFINITY;
                    d4 = Double.POSITIVE_INFINITY;
                    break;
                }
                case 1: {
                    if (d3 != Double.POSITIVE_INFINITY && d4 != Double.POSITIVE_INFINITY) {
                        d = d3;
                        d2 = d4;
                    }
                    d3 = dArray[0];
                    d4 = dArray[1];
                    d7 += Math.max(Math.abs(d3 - d), Math.abs(d4 - d2));
                    break;
                }
                case 4: {
                    d = d3;
                    d2 = d4;
                    d3 = d5;
                    d4 = d6;
                    d7 += Math.max(Math.abs(d3 - d), Math.abs(d4 - d2));
                    break;
                }
                case 2: 
                case 3: {
                    log.severe("[ShapeUtil] lengthOf: invalid segment type.");
                }
            }
            pathIterator.next();
        }
        return d7 * 1.2;
    }

    public static boolean lrPoint(Shape shape, double d, float[] fArray) {
        if (d < 0.0 || d > 1.0) {
            return false;
        }
        double d2 = ShapeUtil.lengthOf(shape);
        if (d2 == 0.0) {
            return false;
        }
        d2 *= d;
        PathIterator pathIterator = shape.getPathIterator(null);
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.POSITIVE_INFINITY;
        double d7 = Double.POSITIVE_INFINITY;
        double d8 = Double.POSITIVE_INFINITY;
        double d9 = 0.0;
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(dArray)) {
                case 0: {
                    d3 = d7 = dArray[0];
                    d4 = d8 = dArray[1];
                    break;
                }
                case 1: {
                    d5 = dArray[0];
                    d6 = dArray[1];
                    d9 = Math.sqrt((d5 - d3) * (d5 - d3) + (d6 - d4) * (d6 - d4));
                    d2 -= d9;
                    if (d2 < 0.0) {
                        double d10 = (d9 - Math.abs(d2)) / d9;
                        fArray[0] = (float)(d3 + (d5 - d3) * d10);
                        fArray[1] = (float)(d4 + (d6 - d4) * d10);
                        return true;
                    }
                    d3 = d5;
                    d4 = d6;
                    break;
                }
                case 4: {
                    d5 = d7;
                    d6 = d8;
                    d9 = Math.sqrt((d5 - d3) * (d5 - d3) + (d6 - d4) * (d6 - d4));
                    d2 -= d9;
                    if (!(d2 < 0.0)) break;
                    double d11 = (d9 - Math.abs(d2)) / d9;
                    fArray[0] = (float)(d3 + (d5 - d3) * d11);
                    fArray[1] = (float)(d4 + (d6 - d4) * d11);
                    return true;
                }
                case 2: 
                case 3: {
                    log.severe("[ShapeUtil] lrPoint: invalid segment type.");
                }
            }
            pathIterator.next();
        }
        if (d2 == 0.0 && d == 1.0) {
            fArray[0] = (float)d3;
            fArray[1] = (float)d4;
            return true;
        }
        return false;
    }

    public static int lrSegmentPoints(Shape shape, double d, double[] dArray) {
        if (d < 0.0 || d > 1.0) {
            return 0;
        }
        double d2 = ShapeUtil.lengthOf(shape);
        d2 *= d;
        PathIterator pathIterator = shape.getPathIterator(null);
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.POSITIVE_INFINITY;
        double d7 = Double.POSITIVE_INFINITY;
        double d8 = Double.POSITIVE_INFINITY;
        double d9 = Double.NEGATIVE_INFINITY;
        double d10 = Double.NEGATIVE_INFINITY;
        double d11 = 0.0;
        double[] dArray2 = new double[6];
        int n = 0;
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(dArray2)) {
                case 0: {
                    d3 = d7 = dArray2[0];
                    d4 = d8 = dArray2[1];
                    break;
                }
                case 1: {
                    ++n;
                    d5 = dArray2[0];
                    d6 = dArray2[1];
                    d11 = Math.sqrt((d5 - d3) * (d5 - d3) + (d6 - d4) * (d6 - d4));
                    d2 -= d11;
                    if (d2 < 0.0) {
                        dArray[0] = d3;
                        dArray[1] = d4;
                        dArray[2] = d5;
                        dArray[3] = d6;
                        return n;
                    }
                    d9 = d3;
                    d10 = d4;
                    d3 = d5;
                    d4 = d6;
                    break;
                }
                case 4: {
                    ++n;
                    d5 = d7;
                    d6 = d8;
                    d9 = d3;
                    d10 = d4;
                    d11 = Math.sqrt((d5 - d3) * (d5 - d3) + (d6 - d4) * (d6 - d4));
                    d2 -= d11;
                    if (!(d2 < 0.0)) break;
                    dArray[0] = d3;
                    dArray[1] = d4;
                    dArray[2] = d5;
                    dArray[3] = d6;
                    return n;
                }
                case 2: 
                case 3: {
                    log.severe("[ShapeUtil] lrSegment: invalid segment type.");
                }
            }
            pathIterator.next();
        }
        if (d2 == 0.0 && d == 1.0) {
            dArray[0] = d9;
            dArray[1] = d10;
            dArray[2] = d5;
            dArray[3] = d6;
            return n;
        }
        return 0;
    }

    public static double[] lrSegmentPoints(Shape shape) {
        if (shape == null) {
            return null;
        }
        PathIterator pathIterator = shape.getPathIterator(null);
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.POSITIVE_INFINITY;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.POSITIVE_INFINITY;
        double[] dArray = new double[6];
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n = 0;
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(dArray)) {
                case 0: {
                    d = d5 = dArray[0];
                    d2 = d6 = dArray[1];
                    break;
                }
                case 1: {
                    ++n;
                    d3 = dArray[0];
                    d4 = dArray[1];
                    arrayList.add(d);
                    arrayList.add(d2);
                    arrayList.add(d3);
                    arrayList.add(d4);
                    d = d3;
                    d2 = d4;
                    break;
                }
                case 4: {
                    ++n;
                    d3 = d5;
                    d4 = d6;
                    arrayList.add(d);
                    arrayList.add(d2);
                    arrayList.add(d3);
                    arrayList.add(d4);
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            pathIterator.next();
        }
        if (arrayList.size() == 0) {
            return null;
        }
        double[] dArray2 = new double[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            dArray2[i] = (Double)arrayList.get(i);
        }
        return dArray2;
    }

    public static final int numLineSegments(Shape shape, float[] fArray) {
        int n = 0;
        PathIterator pathIterator = shape.getPathIterator(null);
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(fArray);
            if (n2 == 1 || n2 == 4) {
                ++n;
            }
            pathIterator.next();
        }
        return n;
    }

    public static final int numCloseSegments(Shape shape) {
        int n = 0;
        PathIterator pathIterator = shape.getPathIterator(null);
        while (!pathIterator.isDone()) {
            if (pathIterator.currentSegment(closeCoords) == 4) {
                ++n;
            }
            pathIterator.next();
        }
        return n;
    }

    public static double projection(double d, double d2, double d3, double d4, double d5, double d6, Point2D point2D) {
        if (d3 == d5 && d4 == d6) {
            return Double.NaN;
        }
        double d7 = ((d - d3) * (d5 - d3) + (d2 - d4) * (d6 - d4)) / ((d5 - d3) * (d5 - d3) + (d6 - d4) * (d6 - d4));
        double d8 = d3 + d7 * (d5 - d3);
        double d9 = d4 + d7 * (d6 - d4);
        point2D.setLocation(d8, d9);
        return d7;
    }

    public static final int numPoints(Shape shape) {
        int n = 0;
        boolean bl = false;
        PathIterator pathIterator = shape.getPathIterator(null);
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(pointCoord)) {
                case 0: {
                    if (bl) {
                        ++n;
                    }
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            pathIterator.next();
        }
        if (bl) {
            ++n;
        }
        return n;
    }

    public static final boolean clipLineSegment(double[] dArray, Rectangle2D rectangle2D, double[] dArray2) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        int n = rectangle2D.outcode(d, d2);
        int n2 = rectangle2D.outcode(d3, d4);
        while (true) {
            double d5;
            double d6;
            int n3;
            if ((n | n2) == 0) {
                dArray2[0] = d;
                dArray2[1] = d2;
                dArray2[2] = d3;
                dArray2[3] = d4;
                return true;
            }
            if ((n & n2) != 0) {
                return false;
            }
            int n4 = n3 = n != 0 ? n : n2;
            if ((n3 & 8) != 0) {
                d6 = d + (d3 - d) * (rectangle2D.getMaxY() - d2) / (d4 - d2);
                d5 = rectangle2D.getMaxY();
            } else if ((n3 & 2) != 0) {
                d6 = d + (d3 - d) * (rectangle2D.getMinY() - d2) / (d4 - d2);
                d5 = rectangle2D.getMinY();
            } else if ((n3 & 4) != 0) {
                d6 = rectangle2D.getMaxX();
                d5 = d2 + (d4 - d2) * (rectangle2D.getMaxX() - d) / (d3 - d);
            } else {
                d6 = rectangle2D.getMinX();
                d5 = d2 + (d4 - d2) * (rectangle2D.getMinX() - d) / (d3 - d);
            }
            if (n3 == n) {
                d = d6;
                d2 = d5;
                n = rectangle2D.outcode(d, d2);
                continue;
            }
            d3 = d6;
            d4 = d5;
            n2 = rectangle2D.outcode(d3, d4);
        }
    }

    private static final boolean contains(Rectangle2D rectangle2D, double d, double d2) {
        return d <= rectangle2D.getMaxX() && d2 <= rectangle2D.getMaxY() && d >= rectangle2D.getMinX() && d2 >= rectangle2D.getMinY();
    }

    public static Shape clipLineString(Rectangle2D rectangle2D, Shape shape, Rectangle rectangle) {
        if (shape == null) {
            return shape;
        }
        if (rectangle == null) {
            rectangle = shape.getBounds();
        }
        if (rectangle2D.contains(rectangle)) {
            return shape;
        }
        PathIterator pathIterator = shape.getPathIterator(null);
        if (pathIterator.isDone()) {
            return shape;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float[] fArray = new float[6];
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        GeneralPath generalPath = new GeneralPath(pathIterator.getWindingRule());
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    f = fArray[0];
                    f2 = fArray[1];
                    f5 = f;
                    f6 = f2;
                    if (!ShapeUtil.contains(rectangle2D, fArray[0], fArray[1])) break;
                    generalPath.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    f3 = fArray[0];
                    f4 = fArray[1];
                    dArray[0] = f;
                    dArray[1] = f2;
                    dArray[2] = f3;
                    dArray[3] = f4;
                    if (ShapeUtil.clipLineSegment(dArray, rectangle2D, dArray2)) {
                        if (dArray2[0] != (double)f || dArray2[1] != (double)f2) {
                            generalPath.moveTo((float)dArray2[0], (float)dArray2[1]);
                        }
                        generalPath.lineTo((float)dArray2[2], (float)dArray2[3]);
                    }
                    f = f3;
                    f2 = f4;
                    break;
                }
                case 4: {
                    f = f3;
                    f2 = f4;
                    f3 = f5;
                    f4 = f6;
                    if (!ShapeUtil.clipLineSegment(dArray, rectangle2D, dArray2)) break;
                    if (dArray2[0] != (double)f || dArray2[1] != (double)f2) {
                        generalPath.moveTo((float)dArray2[0], (float)dArray2[1]);
                    }
                    generalPath.lineTo((float)dArray2[2], (float)dArray2[3]);
                    break;
                }
                default: {
                    log.finer("clipLineString: invalid segment type.");
                    return shape;
                }
            }
            pathIterator.next();
        }
        return generalPath;
    }

    public static Shape clipLineString(Rectangle2D rectangle2D, Shape shape) {
        return ShapeUtil.clipLineString(rectangle2D, shape, null);
    }

    private static Shape clipPolygon2(Rectangle2D rectangle2D, Shape shape) {
        Area area = new Area(shape);
        Area area2 = new Area(rectangle2D);
        area.intersect(area2);
        PathIterator pathIterator = area.getPathIterator(null);
        GeneralPath generalPath = new GeneralPath();
        generalPath.append(pathIterator, false);
        return generalPath;
    }

    public static Shape clipPolygon(Rectangle2D rectangle2D, Shape shape) {
        return ShapeUtil.clipPolygon2(rectangle2D, shape);
    }

    public static double drawHashMarkOnSegment(double d, double d2, double d3, double d4, double d5, double d6, double d7, Graphics2D graphics2D) {
        double d8;
        double d9 = d3 - d;
        double d10 = d4 - d2;
        double d11 = -d10;
        double d12 = d9;
        double d13 = Math.sqrt((d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2));
        double d14 = d7 / d13;
        for (d8 = d5; d8 <= d13; d8 += d6) {
            double d15 = d8 / d13;
            double d16 = d + d9 * d15;
            double d17 = d2 + d10 * d15;
            double d18 = d16 + d11 * d14;
            double d19 = d17 + d12 * d14;
            graphics2D.drawLine((int)d16, (int)d17, (int)d18, (int)d19);
            d18 = d16 - d11 * d14;
            d19 = d17 - d12 * d14;
            graphics2D.drawLine((int)d16, (int)d17, (int)d18, (int)d19);
        }
        return d8 - d13;
    }

    public static void drawHashmarksOnShape(Graphics2D graphics2D, Color color, Shape shape, double d, double d2) {
        double d3 = 0.0;
        PathIterator pathIterator = shape.getPathIterator(null);
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = Double.NEGATIVE_INFINITY;
        double d6 = Double.POSITIVE_INFINITY;
        double d7 = Double.POSITIVE_INFINITY;
        double d8 = Double.POSITIVE_INFINITY;
        double d9 = Double.POSITIVE_INFINITY;
        double d10 = 0.0;
        double[] dArray = new double[6];
        graphics2D.setColor(color);
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(dArray)) {
                case 0: {
                    d4 = d8 = dArray[0];
                    d5 = d9 = dArray[1];
                    d6 = Double.POSITIVE_INFINITY;
                    d7 = Double.POSITIVE_INFINITY;
                    d3 = 0.0;
                    break;
                }
                case 1: {
                    if (d6 != Double.POSITIVE_INFINITY && d7 != Double.POSITIVE_INFINITY) {
                        d4 = d6;
                        d5 = d7;
                    }
                    d6 = dArray[0];
                    d7 = dArray[1];
                    d3 = ShapeUtil.drawHashMarkOnSegment(d4, d5, d6, d7, d3, d, d2, graphics2D);
                    break;
                }
                case 4: {
                    d4 = d6;
                    d5 = d7;
                    d6 = d8;
                    d7 = d9;
                    d3 = ShapeUtil.drawHashMarkOnSegment(d4, d5, d6, d7, d3, d, d2, graphics2D);
                    break;
                }
                case 2: 
                case 3: {
                    System.err.println("ShapeUtil::lengthOf: invalid segment type.");
                }
            }
            pathIterator.next();
        }
    }

    public static final void dumpShape(Shape shape) {
        float[] fArray = new float[6];
        PathIterator pathIterator = shape.getPathIterator(null);
        System.out.println("Winding=" + pathIterator.getWindingRule());
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    System.out.print("\nM" + fArray[0] + "," + fArray[1] + " ");
                    break;
                }
                case 1: {
                    System.out.print("L" + fArray[0] + "," + fArray[1] + " ");
                    break;
                }
                case 2: {
                    System.out.print("Q" + fArray[0] + "," + fArray[1] + "," + fArray[2] + "," + fArray[3] + " ");
                    break;
                }
                case 3: {
                    System.out.print("U" + fArray[0] + "," + fArray[1] + "," + fArray[2] + "," + fArray[3] + "," + fArray[4] + "," + fArray[5] + " ");
                    break;
                }
                case 4: {
                    System.out.print("C ");
                }
            }
            pathIterator.next();
        }
    }

    public static void store(Shape shape, ObjectOutputStream objectOutputStream) throws IOException {
        float[] fArray = new float[6];
        PathIterator pathIterator = shape.getPathIterator(null);
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    objectOutputStream.writeByte(77);
                    objectOutputStream.writeFloat(fArray[0]);
                    objectOutputStream.writeFloat(fArray[1]);
                    break;
                }
                case 1: {
                    objectOutputStream.writeByte(76);
                    objectOutputStream.writeFloat(fArray[0]);
                    objectOutputStream.writeFloat(fArray[1]);
                    break;
                }
                case 2: {
                    objectOutputStream.writeByte(81);
                    objectOutputStream.writeFloat(fArray[0]);
                    objectOutputStream.writeFloat(fArray[1]);
                    objectOutputStream.writeFloat(fArray[2]);
                    objectOutputStream.writeFloat(fArray[3]);
                    break;
                }
                case 3: {
                    objectOutputStream.writeByte(85);
                    objectOutputStream.writeFloat(fArray[0]);
                    objectOutputStream.writeFloat(fArray[1]);
                    objectOutputStream.writeFloat(fArray[2]);
                    objectOutputStream.writeFloat(fArray[3]);
                    objectOutputStream.writeFloat(fArray[4]);
                    objectOutputStream.writeFloat(fArray[5]);
                    break;
                }
                case 4: {
                    objectOutputStream.writeByte(67);
                }
            }
            pathIterator.next();
        }
        objectOutputStream.writeByte(88);
    }

    public static Shape load(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        float[] fArray = new float[6];
        GeneralPath generalPath = new GeneralPath();
        boolean bl = false;
        while (!bl) {
            byte by = objectInputStream.readByte();
            switch (by) {
                case 77: {
                    fArray[0] = objectInputStream.readFloat();
                    fArray[1] = objectInputStream.readFloat();
                    generalPath.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 76: {
                    fArray[0] = objectInputStream.readFloat();
                    fArray[1] = objectInputStream.readFloat();
                    generalPath.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 81: {
                    fArray[0] = objectInputStream.readFloat();
                    fArray[1] = objectInputStream.readFloat();
                    fArray[2] = objectInputStream.readFloat();
                    fArray[3] = objectInputStream.readFloat();
                    generalPath.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                    break;
                }
                case 85: {
                    fArray[0] = objectInputStream.readFloat();
                    fArray[1] = objectInputStream.readFloat();
                    fArray[2] = objectInputStream.readFloat();
                    fArray[3] = objectInputStream.readFloat();
                    fArray[4] = objectInputStream.readFloat();
                    fArray[5] = objectInputStream.readFloat();
                    generalPath.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 67: {
                    generalPath.closePath();
                    break;
                }
                case 88: {
                    bl = true;
                }
            }
        }
        return generalPath;
    }

    public static Shape createShape(float[] fArray) {
        GeneralPath generalPath = new GeneralPath();
        boolean bl = false;
        int n = fArray.length;
        if (n < 4) {
            return null;
        }
        generalPath.moveTo(fArray[0], fArray[1]);
        for (int i = 2; i < n; i += 2) {
            generalPath.lineTo(fArray[i], fArray[i + 1]);
        }
        generalPath.closePath();
        return generalPath;
    }

    public static String toSVGPathData(Shape shape) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(2048);
        float[] fArray = new float[6];
        int n2 = 4;
        PathIterator pathIterator = shape.getPathIterator(null);
        while (!pathIterator.isDone()) {
            int n3 = stringBuffer.length();
            int n4 = pathIterator.currentSegment(fArray);
            switch (n4) {
                case 0: {
                    stringBuffer.append("M" + fArray[0] + "," + fArray[1]);
                    break;
                }
                case 1: {
                    if (n2 == 1) {
                        stringBuffer.append(" ").append(fArray[0]).append(",").append(fArray[1]);
                        break;
                    }
                    stringBuffer.append("L").append(fArray[0]).append(",").append(fArray[1]);
                    break;
                }
                case 2: {
                    stringBuffer.append("Q" + fArray[0] + "," + fArray[1] + " " + fArray[2] + "," + fArray[3]);
                    break;
                }
                case 3: {
                    stringBuffer.append("C" + fArray[0] + "," + fArray[1] + " " + fArray[2] + "," + fArray[3] + " " + fArray[4] + "," + fArray[5]);
                    break;
                }
                case 4: {
                    stringBuffer.append("Z");
                }
            }
            n2 = n4;
            if ((n += stringBuffer.length() - n3) >= 255) {
                stringBuffer.append("\n");
                n = 0;
            }
            pathIterator.next();
        }
        return stringBuffer.toString();
    }

    public static Shape splitAt180(Shape shape, boolean bl) {
        if (bl) {
            Area area = new Area(shape);
            Area area2 = new Area(shape);
            if (_rightHemisphere180 == null) {
                _rightHemisphere180 = new Area(new Rectangle2D.Double(180.0, -91.0, 180.0, 182.0));
            }
            if (_leftHemisphere180 == null) {
                _leftHemisphere180 = new Area(new Rectangle2D.Double(0.0, -91.0, 180.0, 182.0));
            }
            area.subtract(_rightHemisphere180);
            area2.subtract(_leftHemisphere180);
            if (_shiftLeft180 == null) {
                _shiftLeft180 = new AffineTransform();
                _shiftLeft180.translate(-360.0, 0.0);
            }
            GeneralPath generalPath = new GeneralPath();
            generalPath.append(area.getPathIterator(null), false);
            generalPath.append(area2.getPathIterator(_shiftLeft180), false);
            return generalPath;
        }
        return ShapeUtil.splitLinestringAt180(shape);
    }

    static Shape splitLinestringAt180(Shape shape) {
        PathIterator pathIterator = shape.getPathIterator(null);
        if (pathIterator.isDone()) {
            return shape;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float[] fArray = new float[6];
        GeneralPath generalPath = new GeneralPath(pathIterator.getWindingRule());
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    f = fArray[0];
                    f2 = fArray[1];
                    generalPath.moveTo(f, f2);
                    break;
                }
                case 1: {
                    boolean bl;
                    f3 = fArray[0];
                    f4 = fArray[1];
                    float f5 = f <= f3 ? f : f3;
                    float f6 = f <= f3 ? f3 : f;
                    boolean bl2 = bl = f5 < 0.0f && f6 > 0.0f && f6 - f5 > 180.0f;
                    if (bl) {
                        double d;
                        double d2 = f < 0.0f ? (double)(f + 360.0f) : (double)f;
                        double d3 = f3 < 0.0f ? (double)(f3 + 360.0f) : (double)f3;
                        double d4 = (double)(f2 - f4) / (d2 - d3);
                        double d5 = d = f2 == f4 ? (double)f2 : (double)f4 + (180.0 - d3) * d4;
                        if (f > 0.0f) {
                            generalPath.lineTo(180.0f, (float)d);
                            generalPath.moveTo(-180.0f, (float)d);
                        } else {
                            generalPath.lineTo(-180.0f, (float)d);
                            generalPath.moveTo(180.0f, (float)d);
                        }
                    }
                    generalPath.lineTo(f3, f4);
                    f = f3;
                    f2 = f4;
                    break;
                }
                default: {
                    log.severe("splitLinestringAt180: invalid segment type.");
                }
            }
            pathIterator.next();
        }
        return generalPath;
    }

    public static Shape splitAt0(Shape shape, boolean bl) {
        if (bl) {
            Area area = new Area(shape);
            Area area2 = new Area(shape);
            double d = 0.0;
            double d2 = 180.0;
            double d3 = d;
            double d4 = d - d2;
            if (_rightHemisphere0 == null) {
                _rightHemisphere0 = new Area(new Rectangle2D.Double(d3, -91.0, d2, 182.0));
            }
            if (_leftHemisphere0 == null) {
                _leftHemisphere0 = new Area(new Rectangle2D.Double(d4, -91.0, d2, 182.0));
            }
            area.subtract(_rightHemisphere0);
            area2.subtract(_leftHemisphere0);
            if (_shift0 == null) {
                _shift0 = new AffineTransform();
                _shift0.translate(360.0, 0.0);
            }
            GeneralPath generalPath = new GeneralPath();
            generalPath.append(area.getPathIterator(_shift0), false);
            GeneralPath generalPath2 = ShapeUtil.ceilingTo0(area2.getPathIterator(null));
            generalPath.append(generalPath2, false);
            return generalPath;
        }
        return ShapeUtil.splitLinestringAt0(shape);
    }

    static Shape splitLinestringAt0(Shape shape) {
        PathIterator pathIterator = shape.getPathIterator(null);
        if (pathIterator.isDone()) {
            return shape;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = -9999.0f;
        float f6 = 0.0f;
        float[] fArray = new float[6];
        GeneralPath generalPath = new GeneralPath(pathIterator.getWindingRule());
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    f = fArray[0];
                    f2 = fArray[1];
                    if (f < 0.0f) {
                        generalPath.moveTo(f + 360.0f, f2);
                        break;
                    }
                    if (f > 0.0f) {
                        generalPath.moveTo(f, f2);
                        break;
                    }
                    f5 = 0.0f;
                    f6 = f2;
                    break;
                }
                case 1: {
                    boolean bl;
                    f3 = fArray[0];
                    f4 = fArray[1];
                    if (f5 == 0.0f) {
                        if (f3 < 0.0f) {
                            generalPath.moveTo(360.0f, f6);
                        } else {
                            generalPath.moveTo(f5, f6);
                        }
                    }
                    f5 = -9999.0f;
                    float f7 = f <= f3 ? f : f3;
                    float f8 = f <= f3 ? f3 : f;
                    boolean bl2 = bl = f7 < 0.0f && f8 > 0.0f && f8 - f7 < 180.0f;
                    if (bl) {
                        double d;
                        double d2 = (f2 - f4) / (f - f3);
                        double d3 = d = f2 == f4 ? (double)f2 : (double)f4 + (double)(0.0f - f3) * d2;
                        if (f < 0.0f) {
                            generalPath.lineTo(360.0f, (float)d);
                            generalPath.moveTo(0.0f, (float)d);
                        } else {
                            generalPath.lineTo(0.0f, (float)d);
                            generalPath.moveTo(360.0f, (float)d);
                        }
                    }
                    if (f3 < 0.0f) {
                        generalPath.lineTo(f3 + 360.0f, f4);
                    } else {
                        generalPath.lineTo(f3, f4);
                    }
                    f = f3;
                    f2 = f4;
                    break;
                }
                default: {
                    log.severe("splitLinestringAt0: invalid segment type.");
                }
            }
            pathIterator.next();
        }
        return generalPath;
    }

    public static Shape positiveTransform(Shape shape) {
        PathIterator pathIterator = shape.getPathIterator(null);
        if (pathIterator.isDone()) {
            return shape;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float[] fArray = new float[6];
        GeneralPath generalPath = new GeneralPath(pathIterator.getWindingRule());
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    f = fArray[0];
                    f2 = fArray[1];
                    if (f < 0.0f) {
                        f += 360.0f;
                    }
                    generalPath.moveTo(f, f2);
                    break;
                }
                case 1: {
                    f = fArray[0];
                    f2 = fArray[1];
                    if (f < 0.0f) {
                        f += 360.0f;
                    }
                    generalPath.lineTo(f, f2);
                    break;
                }
                case 4: {
                    generalPath.closePath();
                    break;
                }
                default: {
                    log.severe("positiveTransform: invalid segment type.");
                }
            }
            pathIterator.next();
        }
        return generalPath;
    }

    public static GeneralPath ceilingTo0(PathIterator pathIterator) {
        GeneralPath generalPath = new GeneralPath(pathIterator.getWindingRule());
        if (pathIterator.isDone()) {
            return generalPath;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    f = fArray[0];
                    f2 = fArray[1];
                    if (f < 0.0f) {
                        f = 0.0f;
                    }
                    generalPath.moveTo(f, f2);
                    break;
                }
                case 1: {
                    f = fArray[0];
                    f2 = fArray[1];
                    if (f < 0.0f) {
                        f = 0.0f;
                    }
                    generalPath.lineTo(f, f2);
                    break;
                }
                case 4: {
                    generalPath.closePath();
                    break;
                }
                default: {
                    log.severe("ceilingTo0: invalid segment type.");
                }
            }
            pathIterator.next();
        }
        return generalPath;
    }

    public static Shape proj(Shape shape, Proj proj) {
        PathIterator pathIterator = shape.getPathIterator(null);
        if (pathIterator.isDone()) {
            return shape;
        }
        GeneralPath generalPath = new GeneralPath(pathIterator.getWindingRule());
        if (pathIterator.isDone()) {
            return generalPath;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float[] fArray = new float[6];
        Proj.P2 p2 = new Proj.P2();
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    f = fArray[0];
                    f2 = fArray[1];
                    proj.forward(f, f2, p2);
                    generalPath.moveTo((float)p2.x, (float)p2.y);
                    break;
                }
                case 1: {
                    f = fArray[0];
                    f2 = fArray[1];
                    proj.forward(f, f2, p2);
                    generalPath.lineTo((float)p2.x, (float)p2.y);
                    break;
                }
                case 4: {
                    generalPath.closePath();
                    break;
                }
                default: {
                    log.severe("Proj: invalid segment type.");
                }
            }
            pathIterator.next();
        }
        return generalPath;
    }

    public static final boolean intersectsShapeSegments(Rectangle2D rectangle2D, Shape shape, Rectangle2D rectangle2D2) {
        if (rectangle2D == null || shape == null) {
            return false;
        }
        if (rectangle2D2 == null) {
            rectangle2D2 = shape.getBounds2D();
        }
        if (rectangle2D.contains(rectangle2D2.getMinX(), rectangle2D2.getMinY()) && rectangle2D.contains(rectangle2D2.getMaxX(), rectangle2D2.getMaxY())) {
            return true;
        }
        if (!rectangle2D.intersects(rectangle2D2) && !rectangle2D.intersectsLine(rectangle2D2.getMinX(), rectangle2D2.getMinY(), rectangle2D2.getMaxX(), rectangle2D2.getMaxY())) {
            return false;
        }
        PathIterator pathIterator = shape.getPathIterator(null);
        if (pathIterator.isDone()) {
            return false;
        }
        float[] fArray = new float[6];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    f = fArray[0];
                    f2 = fArray[1];
                    f5 = f;
                    f6 = f2;
                    break;
                }
                case 1: {
                    f3 = fArray[0];
                    f4 = fArray[1];
                    if (rectangle2D.intersectsLine(f, f2, f3, f4)) {
                        return true;
                    }
                    f = f3;
                    f2 = f4;
                    break;
                }
                case 4: {
                    f = f3;
                    f2 = f4;
                    f3 = f5;
                    f4 = f6;
                    if (!rectangle2D.intersectsLine(f, f2, f3, f4)) break;
                    return true;
                }
                default: {
                    log.finest("intersectsShapeSegments: invalid segment type.");
                    return true;
                }
            }
            pathIterator.next();
        }
        return false;
    }

    public static final boolean intersects(Shape shape, Shape shape2) {
        float[] fArray = new float[6];
        float[] fArray2 = new float[6];
        PathIterator pathIterator = shape.getPathIterator(null);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    f = fArray[0];
                    f2 = fArray[1];
                    break;
                }
                case 1: {
                    f5 = fArray[0];
                    f6 = fArray[1];
                    PathIterator pathIterator2 = shape2.getPathIterator(null);
                    while (!pathIterator2.isDone()) {
                        switch (pathIterator2.currentSegment(fArray2)) {
                            case 0: {
                                f3 = fArray2[0];
                                f4 = fArray2[1];
                                break;
                            }
                            case 1: {
                                f7 = fArray2[0];
                                f8 = fArray2[1];
                                if (ShapeUtil.linesIntersect(f, f2, f5, f6, f3, f4, f7, f8)) {
                                    return true;
                                }
                                f3 = f7;
                                f4 = f8;
                                break;
                            }
                        }
                        pathIterator2.next();
                    }
                    f = f5;
                    f2 = f6;
                    break;
                }
            }
            pathIterator.next();
        }
        return false;
    }

    public static ArrayList getIntersectionPoints(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return ShapeUtil.getIntersectionPoints(d, d2, d3, d4, d5, d6, d7, d8, true);
    }

    public static ArrayList getIntersectionPoints(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, boolean bl) {
        if (d5 == d7 && d6 == d8) {
            return null;
        }
        if (d5 >= d && d5 <= d3 && d6 >= d2 && d6 <= d4 && d7 >= d && d7 <= d3 && d8 >= d2 && d8 <= d4) {
            return null;
        }
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>(2);
        if (d5 == d7) {
            if (d7 < d || d7 > d3 || d8 > d4 && d6 > d4 || d8 < d2 && d6 < d2) {
                return null;
            }
            if (d8 > d4) {
                if (d6 < d2) {
                    arrayList.add(new Point2D.Double(d7, d2));
                    arrayList.add(new Point2D.Double(d7, d4));
                } else {
                    arrayList.add(new Point2D.Double(d7, d4));
                }
            } else if (d8 < d2) {
                if (d6 > d4) {
                    arrayList.add(new Point2D.Double(d7, d4));
                    arrayList.add(new Point2D.Double(d7, d2));
                } else {
                    arrayList.add(new Point2D.Double(d7, d2));
                }
            } else if (d6 < d2) {
                arrayList.add(new Point2D.Double(d7, d2));
            } else if (d6 > d4) {
                arrayList.add(new Point2D.Double(d7, d4));
            }
        } else if (d6 == d8) {
            if (d8 < d2 || d8 > d4 || d7 > d3 && d5 > d3 || d7 < d && d5 < d) {
                return null;
            }
            if (d7 > d3) {
                if (d5 < d) {
                    arrayList.add(new Point2D.Double(d, d8));
                    arrayList.add(new Point2D.Double(d3, d8));
                } else {
                    arrayList.add(new Point2D.Double(d3, d8));
                }
            } else if (d7 < d) {
                if (d5 > d3) {
                    arrayList.add(new Point2D.Double(d3, d8));
                    arrayList.add(new Point2D.Double(d, d8));
                } else {
                    arrayList.add(new Point2D.Double(d, d8));
                }
            } else if (d5 < d) {
                arrayList.add(new Point2D.Double(d, d8));
            } else if (d5 > d3) {
                arrayList.add(new Point2D.Double(d3, d8));
            }
        } else {
            double d9;
            double d10 = (d6 - d8) * 1.0 / (d5 - d7);
            double d11 = (d8 * d5 - d6 * d7) * 1.0 / (d5 - d7);
            double d12 = d10 * d3 + d11;
            Point2D.Double double_ = null;
            Point2D.Double double_2 = null;
            Point2D.Double double_3 = null;
            if (d12 <= d4 && d12 >= d2 && (d12 >= d6 && d12 <= d8 || d12 <= d6 && d12 >= d8)) {
                double_3 = new Point2D.Double(d3, d12);
                if (d5 > d3) {
                    double_ = double_3;
                } else {
                    double_2 = double_3;
                }
            }
            if ((d9 = d10 * d + d11) <= d4 && d9 >= d2 && (d9 >= d6 && d9 <= d8 || d9 <= d6 && d9 >= d8)) {
                double_3 = new Point2D.Double(d, d9);
                if (d5 < d) {
                    double_ = double_3;
                } else {
                    double_2 = double_3;
                }
            }
            if (double_ == null || double_2 == null) {
                double d13;
                double d14 = (d4 - d11) / d10;
                if (d14 <= d3 && d14 >= d && (d14 >= d5 && d14 <= d7 || d14 <= d5 && d14 >= d7)) {
                    if (d6 > d4) {
                        if (double_ == null) {
                            double_ = new Point2D.Double(d14, d4);
                        }
                    } else if (double_2 == null) {
                        double_2 = new Point2D.Double(d14, d4);
                    }
                }
                if ((d13 = (d2 - d11) / d10) <= d3 && d13 >= d && (d13 >= d5 && d13 <= d7 || d13 <= d5 && d13 >= d7)) {
                    if (d6 < d2) {
                        if (double_ == null) {
                            double_ = new Point2D.Double(d13, d2);
                        }
                    } else if (double_2 == null) {
                        double_2 = new Point2D.Double(d13, d2);
                    }
                }
            }
            if (double_ != null) {
                arrayList.add(double_);
            }
            if (double_2 != null) {
                arrayList.add(double_2);
            }
            if (arrayList.size() == 0 && !bl) {
                if (d5 > d3 && d7 > d3 || d5 < d && d7 < d || d6 > d4 && d8 > d4 || d6 < d2 && d8 < d2) {
                    return arrayList;
                }
                if (d12 < d2 && d9 < d2) {
                    if (d5 < d && d6 > d2 || d7 < d && d8 > d2) {
                        arrayList.add(new Point2D.Double(0.0, 0.0));
                    } else if (d5 > d3 && d6 > d2 || d7 > d3 && d8 > d2) {
                        arrayList.add(new Point2D.Double(d3, 0.0));
                    }
                } else if (d12 > d4 && d9 > d4) {
                    if (d5 < d && d6 < d4 || d7 < d && d8 < d4) {
                        arrayList.add(new Point2D.Double(0.0, d4));
                    } else if (d5 > d3 && d6 < d4 || d7 > d3 && d8 < d4) {
                        arrayList.add(new Point2D.Double(d3, d4));
                    }
                }
            }
        }
        return arrayList;
    }

    private static boolean linesIntersect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = (f2 - f6) * (f7 - f5) - (f - f5) * (f8 - f6);
        float f10 = (f3 - f) * (f8 - f6) - (f4 - f2) * (f7 - f5);
        if (f10 == 0.0f) {
            return false;
        }
        float f11 = f9 / f10;
        float f12 = (f2 - f6) * (f3 - f) - (f - f5) * (f4 - f2);
        float f13 = f12 / f10;
        return f11 >= 0.0f && f11 <= 1.0f && f13 >= 0.0f && f13 <= 1.0f;
    }

    public static void extractLinesAndRings(Shape shape, GeneralPath generalPath, GeneralPath generalPath2) {
        int n;
        if (shape == null || generalPath == null || generalPath2 == null) {
            return;
        }
        generalPath.reset();
        generalPath2.reset();
        PathIterator pathIterator = shape.getPathIterator(null);
        Path2D path2D = null;
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    if (path2D != null) {
                        n = ShapeUtil.numCloseSegments(path2D);
                        if (n == 0) {
                            generalPath.append(path2D, false);
                        } else {
                            ShapeUtil.addToShape(generalPath2, path2D);
                        }
                    }
                    path2D = new GeneralPath();
                    ((Path2D.Float)path2D).moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    ((Path2D.Float)path2D).lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 4: {
                    path2D.closePath();
                    break;
                }
                case 3: {
                    ((Path2D.Float)path2D).curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 2: {
                    ((Path2D.Float)path2D).quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                }
            }
            pathIterator.next();
        }
        if (path2D != null) {
            n = ShapeUtil.numCloseSegments(path2D);
            if (n == 0) {
                generalPath.append(path2D, false);
            } else {
                ShapeUtil.addToShape(generalPath2, path2D);
            }
        }
    }

    public static void addToShape(GeneralPath generalPath, Shape shape) {
        if (generalPath == null || shape == null) {
            return;
        }
        PathIterator pathIterator = shape.getPathIterator(null);
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    generalPath.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    generalPath.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 4: {
                    generalPath.closePath();
                    break;
                }
                case 3: {
                    generalPath.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 2: {
                    generalPath.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                }
            }
            pathIterator.next();
        }
    }
}

