/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSet;
import oracle.mapviewer.share.ArrayParameter;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.text.AnnotationText;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.STRUCT;

public class JDBCUtil {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static Method struct_unwrap = null;
    private static Method clob_unwrap = null;
    private static Method blob_unwrap = null;
    private static Method array_unwrap = null;

    public static JSDOGeometry loadGeometry(ResultSet resultSet, int n, boolean bl) throws Exception {
        JSDOGeometry jSDOGeometry = null;
        STRUCT sTRUCT = null;
        if (bl) {
            byte[] byArray = ((OracleResultSet)resultSet).getBytes(n);
            if (byArray == null || byArray.length == 0) {
                return null;
            }
            jSDOGeometry = JSDOGeometry.loadFromDB(byArray);
        } else {
            Object object = resultSet.getObject(n);
            if (object == null) {
                return null;
            }
            try {
                sTRUCT = (STRUCT)object;
            }
            catch (ClassCastException classCastException) {
                if (struct_unwrap == null && (struct_unwrap = object.getClass().getMethod("unwrap", Class.class)) != null) {
                    log.fine("Got WLS unwrap method for STRUCT through introspect.");
                }
                if (struct_unwrap != null) {
                    sTRUCT = (STRUCT)struct_unwrap.invoke(object, STRUCT.class);
                }
                throw classCastException;
            }
            jSDOGeometry = JSDOGeometry.loadFromDB(sTRUCT);
        }
        return jSDOGeometry;
    }

    public static STRUCT getOracleSTRUCT(ResultSet resultSet, int n) throws Exception {
        Object object = resultSet.getObject(n);
        if (object == null) {
            return null;
        }
        STRUCT sTRUCT = null;
        try {
            sTRUCT = (STRUCT)object;
            return sTRUCT;
        }
        catch (ClassCastException classCastException) {
            if (struct_unwrap == null && (struct_unwrap = object.getClass().getMethod("unwrap", Class.class)) != null) {
                log.fine("Got WLS unwrap method for STRUCT through introspect.");
            }
            if (struct_unwrap != null) {
                sTRUCT = (STRUCT)struct_unwrap.invoke(object, STRUCT.class);
                return sTRUCT;
            }
            throw classCastException;
        }
    }

    public static CLOB safeCastCLOB(Clob clob) throws Exception {
        CLOB cLOB = null;
        try {
            cLOB = (CLOB)clob;
            return cLOB;
        }
        catch (ClassCastException classCastException) {
            if (clob_unwrap == null && (clob_unwrap = clob.getClass().getMethod("unwrap", Class.class)) != null) {
                log.fine("Got WLS unwrap method for CLOB through introspect.");
            }
            if (clob_unwrap != null) {
                cLOB = (CLOB)clob_unwrap.invoke((Object)clob, CLOB.class);
                return cLOB;
            }
            return null;
        }
    }

    public static BLOB safeCastBLOB(Blob blob) throws Exception {
        BLOB bLOB = null;
        try {
            bLOB = (BLOB)blob;
            return bLOB;
        }
        catch (ClassCastException classCastException) {
            if (blob_unwrap == null && (blob_unwrap = blob.getClass().getMethod("unwrap", Class.class)) != null) {
                log.fine("Got WLS unwrap method for BLOB through introspect.");
            }
            if (blob_unwrap != null) {
                bLOB = (BLOB)blob_unwrap.invoke((Object)blob, BLOB.class);
                return bLOB;
            }
            return null;
        }
    }

    public static AnnotationText loadAnnotationText(ResultSet resultSet, String string) throws Exception {
        AnnotationText annotationText = null;
        STRUCT sTRUCT = null;
        Object object = resultSet.getObject(string);
        if (object == null) {
            return null;
        }
        try {
            sTRUCT = (STRUCT)object;
        }
        catch (ClassCastException classCastException) {
            if (struct_unwrap == null && (struct_unwrap = object.getClass().getMethod("unwrap", Class.class)) != null) {
                log.fine("Got WLS unwrap method for STRUCT through introspect.");
            }
            if (struct_unwrap != null) {
                sTRUCT = (STRUCT)struct_unwrap.invoke(object, STRUCT.class);
            }
            throw classCastException;
        }
        annotationText = AnnotationText.load(sTRUCT);
        return annotationText;
    }

    public static ARRAY safeCastARRAY(Object object) throws Exception {
        ARRAY aRRAY = null;
        try {
            aRRAY = (ARRAY)object;
            return aRRAY;
        }
        catch (ClassCastException classCastException) {
            if (array_unwrap == null && (array_unwrap = object.getClass().getMethod("unwrap", Class.class)) != null) {
                log.fine("Got WLS unwrap method for ARRAY through introspect.");
            }
            if (array_unwrap != null) {
                aRRAY = (ARRAY)array_unwrap.invoke(object, ARRAY.class);
                return aRRAY;
            }
            return null;
        }
    }

    public static ARRAY createSQLArray(ArrayParameter arrayParameter, Connection connection) throws SQLException {
        String string = arrayParameter.getDataSource();
        Hashtable hashtable = ArrayParameter.getDescriptorTable();
        String string2 = arrayParameter.getTypeName();
        Object object = arrayParameter.getValue();
        ArrayDescriptor arrayDescriptor = null;
        if (string != null) {
            arrayDescriptor = (ArrayDescriptor)hashtable.get(string + ":" + string2);
            if (arrayDescriptor == null) {
                arrayDescriptor = ArrayDescriptor.createDescriptor((String)string2, (Connection)connection);
                hashtable.put(string + ":" + string2, arrayDescriptor);
            }
        } else {
            arrayDescriptor = ArrayDescriptor.createDescriptor((String)string2, (Connection)connection);
        }
        return new ARRAY(arrayDescriptor, connection, object);
    }
}

