/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.sdovis.ds.DBDataSource;
import oracle.sdovis.ds.DSManager;

public abstract class DBTable {
    protected String mTableName = null;
    protected PreparedStatement mDeleteStatement = null;
    protected PreparedStatement mInsertStatement = null;
    protected PreparedStatement mUpdateStatement = null;
    protected Connection mConnection = null;
    protected String mDataSource = null;
    protected Statement mStatement = null;
    protected ResultSet mResultSet = null;
    protected String mUser = null;

    public DBTable(String string, String string2) {
        this.mDataSource = string;
        this.mTableName = string2;
        try {
            DBDataSource dBDataSource = (DBDataSource)DSManager.get(string);
            Connection connection = dBDataSource.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            this.mUser = databaseMetaData.getUserName().toUpperCase();
            connection.close();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot get user name.");
        }
    }

    public int getId() throws SQLException {
        return 0;
    }

    public abstract int update() throws SQLException;

    public abstract int insert() throws SQLException;

    public abstract int delete() throws SQLException;

    public String getTableName() {
        return this.mTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queryCount(String string) throws SQLException {
        Connection connection = null;
        try {
            DBDataSource dBDataSource = (DBDataSource)DSManager.get(this.mDataSource);
            connection = dBDataSource.getConnection();
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            int n = 0;
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            statement.close();
            int n2 = n;
            return n2;
        }
        finally {
            connection.close();
        }
    }

    public int queryCount() throws SQLException {
        return this.queryCount("select count(0) from " + this.getTableName());
    }

    public void query(String string) throws SQLException {
        DBDataSource dBDataSource = (DBDataSource)DSManager.get(this.mDataSource);
        this.mConnection = dBDataSource.getConnection();
        this.mStatement = this.mConnection.createStatement();
        this.mResultSet = this.mStatement.executeQuery(string);
    }

    public void query() throws SQLException {
        DBDataSource dBDataSource = (DBDataSource)DSManager.get(this.mDataSource);
        this.mConnection = dBDataSource.getConnection();
        this.mStatement = this.mConnection.createStatement();
        this.mResultSet = this.mStatement.executeQuery("select * from " + this.getTableName());
    }

    public void query(PreparedStatement preparedStatement) throws SQLException {
        this.mResultSet = preparedStatement.executeQuery();
    }

    public void queryID(String string, long l) throws SQLException {
        DBDataSource dBDataSource = (DBDataSource)DSManager.get(this.mDataSource);
        this.mConnection = dBDataSource.getConnection();
        this.mStatement = this.mConnection.createStatement();
        this.mResultSet = this.mStatement.executeQuery("select * from " + this.getTableName() + " where " + string + "=" + l);
    }

    public void closeQuery() throws SQLException {
        try {
            if (this.mStatement != null) {
                this.mStatement.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mStatement = null;
        try {
            if (this.mResultSet != null) {
                this.mResultSet.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mResultSet = null;
        if (this.mConnection != null) {
            this.mConnection.close();
        }
        this.mConnection = null;
    }

    public boolean next() throws SQLException {
        boolean bl = this.mResultSet.next();
        if (bl) {
            this.updateLocalData();
        }
        return bl;
    }

    public void truncate() throws SQLException {
        DBDataSource dBDataSource = (DBDataSource)DSManager.get(this.mDataSource);
        this.mConnection = dBDataSource.getConnection();
        Statement statement = this.mConnection.createStatement();
        statement.executeUpdate("truncate table " + this.getTableName());
        statement.close();
        this.mConnection.close();
        this.mConnection = null;
    }

    public void close() throws SQLException {
        if (this.mDeleteStatement != null) {
            this.mDeleteStatement.close();
        }
        if (this.mInsertStatement != null) {
            this.mInsertStatement.close();
        }
        if (this.mUpdateStatement != null) {
            this.mUpdateStatement.close();
        }
        this.mDeleteStatement = null;
        this.mInsertStatement = null;
        this.mUpdateStatement = null;
        this.closeQuery();
    }

    protected boolean checkYesNo(String string) {
        return string != null && string.equals("YES");
    }

    protected abstract void initDeleteStatement() throws SQLException;

    protected abstract void initInsertStatement() throws SQLException;

    protected abstract void initUpdateStatement() throws SQLException;

    protected abstract void updateLocalData() throws SQLException;
}

