/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class CanvasCache {
    public static final int DEFAULT_LIMIT = 120;
    private static int canvasLimit = 120;
    private static LinkedHashMap cache;
    private static HashMap countMap;
    private static long hitCount;
    private static long missCount;

    private CanvasCache() {
        CanvasCache.init();
    }

    public static synchronized void init() {
        CanvasCache.destroy();
        cache = new LinkedHashMap(canvasLimit + 1, 0.75f, true){

            public boolean removeEldestEntry(Map.Entry entry) {
                boolean bl;
                boolean bl2 = bl = this.size() > canvasLimit;
                if (bl) {
                    ImageEntry imageEntry = (ImageEntry)entry.getValue();
                    if (imageEntry.busy) {
                        bl = false;
                    } else {
                        String string = CanvasCache.getKeyBase(imageEntry.image);
                        int n = (Integer)countMap.get(string);
                        n = n == 0 ? 0 : n - 1;
                        countMap.put(string, new Integer(n));
                    }
                }
                return bl;
            }
        };
        countMap = new HashMap();
    }

    public static synchronized void destroy() {
        if (cache == null) {
            return;
        }
        for (ImageEntry imageEntry : cache.entrySet()) {
            imageEntry.image.flush();
            imageEntry.image = null;
        }
        cache.clear();
        cache = null;
        if (countMap != null) {
            countMap.clear();
            countMap = null;
        }
    }

    public static synchronized void setCanvasLimit(int n) {
        canvasLimit = n;
    }

    public static synchronized int getCanvasLimit() {
        return canvasLimit;
    }

    public static synchronized BufferedImage getImage(int n, int n2, int n3) {
        String string;
        Integer n4;
        if (cache == null) {
            CanvasCache.init();
        }
        if ((n4 = (Integer)countMap.get(string = CanvasCache.getKeyBase(n, n2, n3))) == null) {
            return CanvasCache.createImage(n, n2, n3, 0);
        }
        string = string + "_c";
        int n5 = n4;
        for (int i = 1; i <= n5; ++i) {
            String string2 = string + i;
            try {
                ImageEntry imageEntry = (ImageEntry)cache.get(string2);
                if (imageEntry.busy) continue;
                imageEntry.busy = true;
                imageEntry.lastAccessedTime = System.currentTimeMillis();
                ++imageEntry.accessCount;
                ++hitCount;
                return imageEntry.image;
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("NPE caught on key: " + string2);
            }
        }
        return CanvasCache.createImage(n, n2, n3, n5);
    }

    private static final String getKeyBase(int n, int n2, int n3) {
        return "img_w" + n + "_h" + n2 + "_t" + n3;
    }

    private static final String getKeyBase(BufferedImage bufferedImage) {
        return CanvasCache.getKeyBase(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
    }

    protected static synchronized BufferedImage createImage(int n, int n2, int n3, int n4) {
        try {
            ++missCount;
            String string = CanvasCache.getKeyBase(n, n2, n3);
            BufferedImage bufferedImage = new BufferedImage(n, n2, n3);
            ImageEntry imageEntry = new ImageEntry();
            imageEntry.image = bufferedImage;
            imageEntry.busy = true;
            imageEntry.lastAccessedTime = System.currentTimeMillis();
            imageEntry.accessCount = 1L;
            cache.put(string + "_c" + ++n4, imageEntry);
            countMap.put(string, new Integer(n4));
            return bufferedImage;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.out.println("OOM error!  Current stats: " + CanvasCache.printStats());
            System.out.println("width: " + n + ", height: " + n2);
            return null;
        }
    }

    public static synchronized void freeImage(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = bufferedImage.getType();
        String string = CanvasCache.getKeyBase(n, n2, n3);
        Integer n4 = (Integer)countMap.get(string);
        int n5 = n4;
        string = string + "_c";
        for (int i = 1; i <= n5; ++i) {
            String string2 = string + i;
            ImageEntry imageEntry = (ImageEntry)cache.get(string2);
            if (bufferedImage != imageEntry.image) continue;
            bufferedImage.flush();
            imageEntry.busy = false;
            return;
        }
    }

    public static long getImageCount() {
        return cache != null ? (long)cache.size() : 0L;
    }

    public static long getHitCount() {
        return hitCount;
    }

    public static long getMissCount() {
        return missCount;
    }

    public static String printStats() {
        String string = new String("\ntotal # of cached images: " + CanvasCache.getImageCount() + "\n");
        string = string + "total hit count: " + CanvasCache.getHitCount() + "\n";
        string = string + "total miss count: " + CanvasCache.getMissCount() + "\n";
        return string;
    }

    static {
        hitCount = 0L;
        missCount = 0L;
    }

    public static class ImageEntry {
        BufferedImage image;
        boolean busy = false;
        long lastAccessedTime;
        long accessCount;
    }
}

