/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme.edit;

import java.awt.geom.Rectangle2D;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import oracle.mapviewer.share.Field;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.cache.CacheGroup;
import oracle.sdovis.theme.NetworkThemeProducer;
import oracle.spatial.edit.index.geometry.IndexedGeometrySet;
import oracle.spatial.edit.model.AbstractFeature;
import oracle.spatial.edit.model.geometry.GeometrySet;
import oracle.spatial.edit.model.network.NetworkModel;
import oracle.spatial.geometry.JGeometry;

public class EditNetworkThemeProducer
extends NetworkThemeProducer {
    private NetworkModel editModel = null;
    private IndexedGeometrySet linkSet = null;
    private IndexedGeometrySet nodeSet = null;
    private boolean editingMode = false;

    public EditNetworkThemeProducer(Theme theme) {
        super(theme);
    }

    public void setNetworkModel(NetworkModel networkModel) {
        this.editModel = networkModel;
    }

    public NetworkModel getNetworkModel() {
        return this.editModel;
    }

    public void setIndexedLinkSet(IndexedGeometrySet indexedGeometrySet) {
        this.linkSet = indexedGeometrySet;
    }

    public IndexedGeometrySet getIndexedLinkSet() {
        return this.linkSet;
    }

    public void setIndexedNodeSet(IndexedGeometrySet indexedGeometrySet) {
        this.nodeSet = indexedGeometrySet;
    }

    public IndexedGeometrySet getIndexedNodeSet() {
        return this.nodeSet;
    }

    public boolean isEditingMode() {
        return this.editingMode;
    }

    public void setEditingMode(boolean bl) {
        this.editingMode = bl;
    }

    protected JSDOGeometry loadGeom(CacheGroup cacheGroup, ResultSet resultSet, String string, boolean bl) throws Exception {
        JGeometry jGeometry = null;
        if (cacheGroup == null) {
            return null;
        }
        if (this.editModel != null) {
            GeometrySet geometrySet = null;
            if (cacheGroup.getName().indexOf("_LINK") > -1) {
                geometrySet = this.editModel.getLinkSet();
            } else if (cacheGroup.getName().indexOf("_NODE") > -1) {
                geometrySet = this.editModel.getNodeSet();
            } else {
                return null;
            }
            if (geometrySet.isRemovedFeature(string)) {
                return null;
            }
            jGeometry = geometrySet.getFeatureGeometry(string);
            if (jGeometry != null) {
                return JSDOGeometry.recast(jGeometry);
            }
        }
        return super.loadGeom(cacheGroup, resultSet, string, bl);
    }

    protected void loadNewLinks(ArrayList arrayList) {
        if (arrayList == null || this.editModel == null) {
            return;
        }
        String[] stringArray = this.editModel.getLinkSet().getNewFeatures();
        if (stringArray == null || stringArray.length < 1) {
            return;
        }
        String[] stringArray2 = this.owner.getRenderingStyles();
        String string = "C.RED";
        if (stringArray2 != null && stringArray2.length > 0) {
            string = stringArray2[0];
        }
        for (int i = 0; i < stringArray.length; ++i) {
            JGeometry jGeometry = this.editModel.getLinkSet().getFeatureGeometry(stringArray[i]);
            if (jGeometry == null) continue;
            StyledFeatureI styledFeatureI = this.getNewStyledFeatureInstance();
            styledFeatureI.setGeometry(JSDOGeometry.recast(jGeometry));
            styledFeatureI.setID(stringArray[i]);
            styledFeatureI.setDataSource(this.def.getDataSourceName());
            styledFeatureI.setFeatureStyleName(string);
            arrayList.add(styledFeatureI);
        }
    }

    protected void loadNewNodes(ArrayList arrayList) {
        if (arrayList == null || this.editModel == null) {
            return;
        }
        String[] stringArray = this.editModel.getNodeSet().getNewFeatures();
        if (stringArray == null || stringArray.length < 1) {
            return;
        }
        String[] stringArray2 = this.owner.getRenderingStyles();
        String string = "M.STAR";
        if (stringArray2 != null && stringArray2.length > 0) {
            string = stringArray2[0];
        }
        for (int i = 0; i < stringArray.length; ++i) {
            JGeometry jGeometry = this.editModel.getNodeSet().getFeatureGeometry(stringArray[i]);
            if (jGeometry == null) continue;
            StyledFeatureI styledFeatureI = this.getNewStyledFeatureInstance();
            styledFeatureI.setGeometry(JSDOGeometry.recast(jGeometry));
            styledFeatureI.setID(stringArray[i]);
            styledFeatureI.setDataSource(this.def.getDataSourceName());
            styledFeatureI.setFeatureStyleName(string);
            arrayList.add(styledFeatureI);
        }
    }

    protected void loadEditLinks(Rectangle2D rectangle2D, ArrayList arrayList) {
        String string;
        String[] stringArray;
        if (this.editModel == null || this.linkSet == null || arrayList == null || rectangle2D == null) {
            return;
        }
        String string2 = this.linkSet.getGeometrySet().getKeyColumn();
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray = (String[])arrayList.get(i);
            if (stringArray == null || stringArray.getID() == null || stringArray.getGeomType() != 2 || (string = this.linkSet.getGeometrySet().getRealKeyValue(string2, stringArray.getID())) == null) continue;
            hashtable.put(string, stringArray);
        }
        Vector vector = this.linkSet.getFeatures(rectangle2D);
        if (vector != null) {
            stringArray = this.owner.getRenderingStyles();
            string = "C.RED";
            if (stringArray != null && stringArray.length > 0) {
                string = stringArray[0];
            }
            for (int i = 0; i < vector.size(); ++i) {
                JGeometry jGeometry;
                Field field = ((AbstractFeature)vector.get(i)).getAttribute(string2);
                if (field == null || field.getValue() == null || hashtable.get(field.getValue().toString()) != null || (jGeometry = this.linkSet.getGeometrySet().getFeatureGeometry(field.getValue().toString())) == null) continue;
                StyledFeatureI styledFeatureI = this.getNewStyledFeatureInstance();
                styledFeatureI.setGeometry(JSDOGeometry.recast(jGeometry));
                styledFeatureI.setID(field.getValue().toString());
                styledFeatureI.setDataSource(this.def.getDataSourceName());
                styledFeatureI.setFeatureStyleName(string);
                arrayList.add(styledFeatureI);
            }
        }
    }

    protected void loadEditNodes(Rectangle2D rectangle2D, ArrayList arrayList) {
        String string;
        String[] stringArray;
        if (this.editModel == null || this.nodeSet == null || arrayList == null || rectangle2D == null) {
            return;
        }
        String string2 = this.nodeSet.getGeometrySet().getKeyColumn();
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray = (String[])arrayList.get(i);
            if (stringArray == null || stringArray.getID() == null || stringArray.getGeomType() != 1 || (string = this.nodeSet.getGeometrySet().getRealKeyValue(string2, stringArray.getID())) == null) continue;
            hashtable.put(string, stringArray);
        }
        Vector vector = this.nodeSet.getFeatures(rectangle2D);
        if (vector != null) {
            stringArray = this.owner.getRenderingStyles();
            string = "M.STAR";
            if (stringArray != null && stringArray.length > 0) {
                string = stringArray.length > 1 ? stringArray[1] : stringArray[0];
            }
            for (int i = 0; i < vector.size(); ++i) {
                JGeometry jGeometry;
                Field field = ((AbstractFeature)vector.get(i)).getAttribute(string2);
                if (field == null || field.getValue() == null || hashtable.get(field.getValue().toString()) != null || (jGeometry = this.nodeSet.getGeometrySet().getFeatureGeometry(field.getValue().toString())) == null) continue;
                StyledFeatureI styledFeatureI = this.getNewStyledFeatureInstance();
                styledFeatureI.setGeometry(JSDOGeometry.recast(jGeometry));
                styledFeatureI.setID(field.getValue().toString());
                styledFeatureI.setDataSource(this.def.getDataSourceName());
                styledFeatureI.setFeatureStyleName(string);
                arrayList.add(styledFeatureI);
            }
        }
    }
}

