/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme.edit;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.mapviewer.share.Field;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.cache.CacheGroup;
import oracle.sdovis.theme.PredGeomThemeProducer;
import oracle.sdovis.util.I18nUtil;
import oracle.sdovis.util.Util;
import oracle.spatial.edit.index.geometry.IndexedGeometrySet;
import oracle.spatial.edit.model.AbstractFeature;
import oracle.spatial.edit.model.geometry.GeometryFeature;
import oracle.spatial.geometry.JGeometry;

public class EditGeomThemeProducer
extends PredGeomThemeProducer {
    private IndexedGeometrySet editSet = null;
    private boolean editingMode = false;

    public EditGeomThemeProducer(Theme theme) {
        super(theme, null);
    }

    public void setIndexedGeometrySet(IndexedGeometrySet indexedGeometrySet) {
        this.editSet = indexedGeometrySet;
    }

    public IndexedGeometrySet getIndexedGeometrySet() {
        return this.editSet;
    }

    public boolean isEditingMode() {
        return this.editingMode;
    }

    public void setEditingMode(boolean bl) {
        this.editingMode = bl;
    }

    protected JSDOGeometry loadGeom(CacheGroup cacheGroup, ResultSet resultSet, String string, boolean bl) throws Exception {
        JGeometry jGeometry = null;
        if (this.editSet != null && this.editSet.getGeometrySet() != null) {
            if (this.editSet.getGeometrySet().isRemovedFeature(string)) {
                return null;
            }
            jGeometry = this.editSet.getGeometrySet().getFeatureGeometry(string);
            if (jGeometry != null) {
                return JSDOGeometry.recast(jGeometry);
            }
        }
        return super.loadGeom(cacheGroup, resultSet, string, bl);
    }

    protected void loadLabel(ResultSet resultSet, StyledFeatureI styledFeatureI, ResultSetMetaData resultSetMetaData, ResourceBundle resourceBundle) throws SQLException {
        String string;
        Field field;
        GeometryFeature geometryFeature = null;
        if (this.editSet != null && (geometryFeature = this.editSet.getFeature(styledFeatureI.getID())) != null && (field = geometryFeature.getAttribute(string = resultSetMetaData.getColumnName(4))) != null) {
            String string2 = null;
            if (field.getValue() != null) {
                string2 = field.getValue().toString();
            }
            styledFeatureI.setLabel(string2);
            styledFeatureI.setLabelStyleName(resultSet.getString(5));
            if (string2 != null && resourceBundle != null) {
                styledFeatureI.setTranslatedLabel(I18nUtil.getTranslation(string2, resourceBundle));
            }
            return;
        }
        super.loadLabel(resultSet, styledFeatureI, resultSetMetaData, resourceBundle);
    }

    public void loadAttributeData(ResultSet resultSet, StyledFeatureI styledFeatureI, int n, ResultSetMetaData resultSetMetaData) throws SQLException, IOException {
        Object object;
        Object object2;
        GeometryFeature geometryFeature = null;
        if (this.editSet != null) {
            geometryFeature = this.editSet.getFeature(styledFeatureI.getID());
        }
        Vector<Object> vector = new Vector<Object>(n - 7);
        for (int i = 8; i < n + 1; ++i) {
            object2 = null;
            Field field = null;
            object = resultSetMetaData.getColumnName(i);
            int n2 = resultSetMetaData.getColumnType(i);
            if (geometryFeature != null) {
                field = geometryFeature.getAttribute((String)object);
            }
            object2 = field == null ? Util.getFieldFromResultSet(n2, resultSet, i) : (Field)field.clone();
            ((Field)object2).setName((String)object);
            vector.add(object2);
        }
        Field[] fieldArray = this.def.getIdentifiableColumns();
        if (fieldArray == null) {
            styledFeatureI.setRenderableAttributes(vector.toArray(new Field[vector.size()]));
        } else {
            object2 = new Field[fieldArray.length];
            block1: for (int i = 0; i < fieldArray.length; ++i) {
                object = fieldArray[i];
                String string = ((Field)object).getName();
                for (int j = 0; j < vector.size(); ++j) {
                    Field field = (Field)vector.get(j);
                    if (!string.equalsIgnoreCase(field.getName())) continue;
                    object2[i] = field;
                    field.setDisplayName(((Field)object).getDisplayName());
                    if (this.columnDefinedInStylingRules(((Field)object).getName())) continue block1;
                    vector.remove(j);
                    continue block1;
                }
            }
            styledFeatureI.setIdentifiableAttributes((Field[])object2);
            if (vector.size() > 0) {
                styledFeatureI.setRenderableAttributes(vector.toArray(new Field[vector.size()]));
            }
        }
    }

    protected void loadNewFeatures(List list) {
        if (list == null || this.editSet == null || this.editSet.getGeometrySet() == null) {
            return;
        }
        String[] stringArray = this.editSet.getGeometrySet().getNewFeatures();
        if (stringArray == null || stringArray.length < 1) {
            return;
        }
        String[] stringArray2 = this.owner.getRenderingStyles();
        String string = "C.RED";
        if (stringArray2 != null && stringArray2.length > 0) {
            string = stringArray2[0];
        }
        for (int i = 0; i < stringArray.length; ++i) {
            JGeometry jGeometry = this.editSet.getGeometrySet().getFeatureGeometry(stringArray[i]);
            if (jGeometry == null) continue;
            StyledFeatureI styledFeatureI = this.getNewStyledFeatureInstance();
            styledFeatureI.setGeometry(JSDOGeometry.recast(jGeometry));
            styledFeatureI.setID(stringArray[i]);
            styledFeatureI.setDataSource(this.def.getDataSourceName());
            styledFeatureI.setFeatureStyleName(string);
            list.add(styledFeatureI);
        }
    }

    protected void loadEditFeatures(Rectangle2D rectangle2D, List list) {
        String string;
        String[] stringArray;
        if (this.editSet == null || this.editSet.getGeometrySet() == null || list == null || rectangle2D == null) {
            return;
        }
        String string2 = this.editSet.getGeometrySet().getKeyColumn();
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        for (int i = 0; i < list.size(); ++i) {
            stringArray = (String[])list.get(i);
            if (stringArray == null || stringArray.getID() == null || (string = this.editSet.getGeometrySet().getRealKeyValue(string2, stringArray.getID())) == null) continue;
            hashtable.put(string, stringArray);
        }
        Vector vector = this.editSet.getFeatures(rectangle2D);
        if (vector != null) {
            stringArray = this.owner.getRenderingStyles();
            string = "C.RED";
            if (stringArray != null && stringArray.length > 0) {
                string = stringArray[0];
            }
            for (int i = 0; i < vector.size(); ++i) {
                JGeometry jGeometry;
                Field field = ((AbstractFeature)vector.get(i)).getAttribute(string2);
                if (field == null || field.getValue() == null || hashtable.get(field.getValue().toString()) != null || (jGeometry = this.editSet.getGeometrySet().getFeatureGeometry(field.getValue().toString())) == null) continue;
                StyledFeatureI styledFeatureI = this.getNewStyledFeatureInstance();
                styledFeatureI.setGeometry(JSDOGeometry.recast(jGeometry));
                styledFeatureI.setID(field.getValue().toString());
                styledFeatureI.setDataSource(this.def.getDataSourceName());
                styledFeatureI.setFeatureStyleName(string);
                list.add(styledFeatureI);
            }
        }
    }
}

