/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.EPSG2SDO;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.DataException;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.RSBundle;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.WMSMapTheme;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.theme.WMSMapThemeDefinition;
import oracle.sdovis.util.ImageUtils;
import oracle.sdovis.util.TopThemeQueries;
import oracle.sdovis.util.Util;

public class WMSMapThemeProducer
implements ThemeDataProducer {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected Theme owner;
    private WMSMapThemeDefinition def;
    private Image wmsMap;
    double xl;
    double yl;
    double xh;
    double yh;
    boolean flag = false;

    public WMSMapThemeProducer(Theme theme) {
        this.owner = theme;
        this.def = (WMSMapThemeDefinition)theme.getDefinition();
    }

    public Theme getTheme() {
        return this.owner;
    }

    public int size() {
        return this.wmsMap == null ? 0 : 1;
    }

    public void setStyledFeatures(StyledFeatureI[] styledFeatureIArray) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int prepareData(Rectangle2D rectangle2D, VisContext visContext) throws DataException {
        Object object;
        Object object2;
        Object object3;
        int n;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        boolean bl;
        long l;
        block40: {
            this.flag = false;
            l = System.currentTimeMillis();
            bl = false;
            this.xl = rectangle2D.getMinX();
            this.yl = rectangle2D.getMinY();
            this.xh = rectangle2D.getMaxX();
            this.yh = rectangle2D.getMaxY();
            int n2 = (int)visContext.getDeviceWindow().getWidth();
            int n3 = (int)visContext.getDeviceWindow().getHeight();
            d5 = this.xl;
            d4 = this.xh;
            d3 = this.yl;
            d2 = this.yh;
            d = visContext.getCurrentScale();
            String string = this.def.getSrs();
            n = this.def.getSrid();
            if (n <= 0 && visContext.getMasterDataSourceName() != null && string != null) {
                object3 = null;
                int n4 = string.indexOf(":");
                if (n4 > -1) {
                    object3 = string.substring(n4 + 1, string.length());
                }
                int n5 = 0;
                try {
                    n5 = Integer.parseInt((String)object3);
                    if (string.toUpperCase().indexOf("EPSG:") <= -1) break block40;
                    object2 = EPSG2SDO.EPSGtoSDO((String)object3);
                    if (object2 != null) {
                        n = Integer.parseInt((String)object2);
                        log.info("EPSG:" + (String)object3 + " is mapped to SDO:" + n);
                    } else {
                        n = Util.EPSGsrid_To_Oraclesrid(visContext.getMasterDataSourceName(), n5);
                    }
                }
                catch (Exception exception) {
                    n = 0;
                }
            }
        }
        object3 = DSManager.getSRSCache(visContext.getMasterDataSourceName());
        SRS sRS = null;
        if (object3 != null) {
            sRS = ((SRSCache)object3).get(n);
        }
        if (visContext.getMasterSRID() > 0 && n > 0 && n != visContext.getMasterSRID() && visContext.getMasterDataSourceName() != null) {
            Connection connection = null;
            try {
                connection = DSUtil.getDBConnection(visContext.getMasterDataSourceName(), visContext);
            }
            catch (Exception exception) {
                log.info("Unable to get datasource connection to convert SRID");
                return 0;
            }
            if (d != Double.POSITIVE_INFINITY && d != Double.NEGATIVE_INFINITY) {
                object2 = new double[4];
                object2[0] = this.xl;
                object2[1] = this.yl;
                object2[2] = this.xh;
                object2[3] = this.yh;
                object = Util.convertMBR((double[])object2, visContext.getMasterSRID(), n, connection);
                if (object == null) {
                    log.severe(RSBundle.getMsg("MAPVIEWER-01024"));
                    DSUtil.closeDBConnection(connection, visContext.getMasterDataSourceName());
                    return 0;
                }
                this.xl = (double)object[0];
                this.yl = (double)object[1];
                this.xh = (double)object[2];
                this.yh = (double)object[3];
                bl = true;
            } else {
                bl = true;
            }
            DSUtil.closeDBConnection(connection, visContext.getMasterDataSourceName());
        }
        if (d != Double.POSITIVE_INFINITY && d != Double.NEGATIVE_INFINITY) {
            double d6 = Math.abs(this.yh - this.yl) / Math.abs(d2 - d3);
            log.finer("[Master scale] " + d + " [Theme scale factor] " + d6);
            double d7 = d * d6;
            if (this.getTheme().getDecorator().getScaleType() == "RATIO") {
                double d8;
                double d9;
                if (visContext.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != visContext.getMasterSRID() && visContext.isTileRequest()) {
                    sRS = ((SRSCache)object3).get(visContext.getMasterSRID());
                    d9 = (d5 + d4) / 2.0;
                    d8 = (d3 + d2) / 2.0;
                    d6 = 1.0;
                } else {
                    d9 = (this.xl + this.xh) / 2.0;
                    d8 = (this.yl + this.yh) / 2.0;
                }
                if (visContext.isTileRequest() && sRS.isGeodetic()) {
                    d9 = 0.0;
                    d8 = 0.0;
                }
                if (sRS == null) {
                    log.severe(RSBundle.getMsg("MAPVIEWER-01025"));
                    return 0;
                }
                d7 = sRS.getRatioScale(d * d6, new Point2D.Double(d9, d8));
                log.finer("Ratio scale to compare: " + d7);
            }
            if (!this.getTheme().getDecorator().withinScaleLimits(d7)) {
                log.warning("Scale definition for theme " + this.getTheme().getName() + " is out of range.");
                return 0;
            }
        }
        if (MapMaker.isSpecial(this.xl, this.yl, this.xh, this.yh) && visContext.getRotation() != 0.0) {
            log.warning("Rotation is currently ignored for full extent.");
        } else if (visContext.getRotation() != 0.0 && !MapMaker.isSpecial(this.xl, this.yl, this.xh, this.yh)) {
            if (visContext.getRotation() < -360.0 || visContext.getRotation() > 360.0) {
                log.warning("Rotation value must be in between -360 to 360 degrees. Ignored");
            } else {
                double[] dArray = Util.rotateMBR(this.xl, this.yl, this.xh, this.yh, visContext.getRotation());
                if (dArray != null) {
                    this.xl = Math.min(dArray[0], this.xl);
                    this.yl = Math.min(dArray[1], this.yl);
                    this.xh = Math.max(dArray[2], this.xh);
                    this.yh = Math.max(dArray[3], this.yh);
                    log.finest("Rotation angle: " + visContext.getRotation());
                    log.finest("Search window for rotation: " + this.xl + "," + this.yl + "," + this.xh + "," + this.yh);
                } else {
                    log.info("Rotated MBR is null. Rotation ignored.");
                }
            }
        }
        String string = this.constructURL(visContext);
        object2 = this.def.getServerUrlPrefix();
        try {
            object = null;
            if (object2 == null) {
                log.severe(RSBundle.getMsg("MAPVIEWER-01047") + " [" + this.owner.getName() + "]");
                return 0;
            }
            if (((String)object2).indexOf(63) > 0) {
                if (!((String)object2).endsWith("&")) {
                    object = new URL((String)object2 + "&" + string);
                    log.finest("WMS map url: " + (String)object2 + "&" + string);
                } else {
                    object = new URL((String)object2 + string);
                    log.finest("WMS map url: " + (String)object2 + string);
                }
            } else {
                object = new URL((String)object2 + "?" + string);
                log.finest("WMS map url: " + (String)object2 + "?" + string);
            }
            this.wmsMap = ImageUtils.blockingLoad((URL)object);
            if (this.wmsMap == null) {
                log.severe(RSBundle.getMsg("MAPVIEWER-01048"));
                this.initMapImage(visContext, "Failure accessing WMS theme " + this.owner.getName());
            } else {
                long l2 = System.currentTimeMillis();
                TopThemeQueries.add(l2 - l, this.getTheme().getName(), this.getTheme().getDataSourceName(), (String)object2, "WMS request.");
            }
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Exception loading WMS map image", exception);
            this.destroyImage();
            return 0;
        }
        if (!bl) return 1;
        object = null;
        try {
            block43: {
                try {
                    object = DSUtil.getDBConnection(visContext.getMasterDataSourceName(), visContext);
                    double[] dArray = new double[]{this.xl, this.yl, this.xh, this.yh};
                    double[] dArray2 = Util.convertMBR(dArray, n, visContext.getMasterSRID(), (Connection)object);
                    if (dArray2 == null) break block43;
                    this.xl = dArray2[0];
                    this.yl = dArray2[1];
                    this.xh = dArray2[2];
                    this.yh = dArray2[3];
                }
                catch (Exception exception) {
                    Object var31_35 = null;
                    if (object == null) return 1;
                    DSUtil.closeDBConnection((Connection)object, visContext.getMasterDataSourceName());
                    return 1;
                }
            }
            Object var31_34 = null;
            if (object == null) return 1;
            DSUtil.closeDBConnection((Connection)object, visContext.getMasterDataSourceName());
            return 1;
        }
        catch (Throwable throwable) {
            Object var31_36 = null;
            if (object == null) throw throwable;
            DSUtil.closeDBConnection((Connection)object, visContext.getMasterDataSourceName());
            throw throwable;
        }
    }

    public void postPreparation(VisContext visContext) {
    }

    public StyledFeatureI getStyledFeature(int n) {
        return null;
    }

    public double[] getDataMBR() {
        return new double[]{this.xl, this.yl, this.xh, this.yh};
    }

    public StyledFeatureI[] getStyledFeatures() {
        return null;
    }

    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D rectangle2D, String string) {
        return null;
    }

    public StyledFeatureI[] getSelectedFeatures(Rectangle2D rectangle2D) {
        return null;
    }

    public void destroy() {
        this.destroyImage();
    }

    public void abort() {
    }

    private void destroyImage() {
        if (this.wmsMap != null) {
            ImageUtils.removeImageFromTracker(this.wmsMap);
            this.wmsMap.flush();
            this.wmsMap = null;
        }
    }

    public Image getWMSMap() {
        return this.wmsMap;
    }

    private void initMapImage(VisContext visContext, String string) {
        int n = (int)visContext.getDeviceWindow().getWidth();
        int n2 = (int)visContext.getDeviceWindow().getHeight();
        try {
            if (this.wmsMap == null || this.wmsMap.getWidth(null) != n || this.wmsMap.getHeight(null) != n2) {
                this.destroyImage();
                this.wmsMap = new BufferedImage(n, n2, 2);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            log.severe("Out of memory allocating buffer image for wms-map theme " + this.def.getName());
            return;
        }
        Color color = new Color(255, 255, 255, 0);
        Graphics2D graphics2D = (Graphics2D)this.wmsMap.getGraphics();
        graphics2D.fillRect(0, 0, this.wmsMap.getWidth(null), this.wmsMap.getHeight(null));
        graphics2D.setFont(new Font("DialogInput", 1, 18));
        graphics2D.setColor(Color.RED);
        graphics2D.drawString(string, this.wmsMap.getWidth(null) / 10, this.wmsMap.getHeight(null) / 10);
        graphics2D.dispose();
    }

    private String constructURL(VisContext visContext) {
        int n;
        String string;
        Object object;
        StringBuffer stringBuffer = new StringBuffer(1024);
        String string2 = this.def.getWmtVersion();
        if ("1.0.0".equalsIgnoreCase(string2)) {
            stringBuffer.append("WMTVER=" + string2);
            stringBuffer.append("&REQUEST=Map");
        } else {
            stringBuffer.append("VERSION=" + string2);
            stringBuffer.append("&REQUEST=GetMap");
        }
        String string3 = "SRS";
        if (string2 != null && string2.equalsIgnoreCase("1.3.0")) {
            string3 = "CRS";
        }
        stringBuffer.append("&" + string3 + "=" + this.def.getSrs());
        stringBuffer.append("&BBOX=" + this.xl + "," + this.yl + "," + this.xh + "," + this.yh);
        stringBuffer.append("&WIDTH=" + (int)visContext.getDeviceWindow().getWidth());
        stringBuffer.append("&HEIGHT=" + (int)visContext.getDeviceWindow().getHeight());
        String string4 = this.def.getFormat();
        stringBuffer.append("&FORMAT=" + string4.replace(' ', '+'));
        stringBuffer.append("&BGCOLOR=" + this.def.getBgColor());
        String string5 = this.def.isTransparent() ? "TRUE" : "FALSE";
        stringBuffer.append("&TRANSPARENT=" + string5);
        log.finer("Added to URL. Version = " + string2 + " " + string3 + " = " + this.def.getSrs() + " FORMAT = " + this.def.getFormat() + " BGCOLOR = " + this.def.getBgColor());
        if (this.def.getLayers() != null) {
            object = this.def.getLayers();
            string = null;
            stringBuffer.append("&LAYERS=");
            for (n = 0; n < ((String[])object).length - 1; ++n) {
                string = object[n].replace(' ', '+');
                stringBuffer.append(string + ",");
            }
            string = object[((String[])object).length - 1].replace(' ', '+');
            stringBuffer.append(string);
        }
        if (this.def.getStyles() != null) {
            object = this.def.getStyles();
            string = null;
            stringBuffer.append("&STYLES=");
            for (n = 0; n < ((String[])object).length - 1; ++n) {
                string = object[n].replace(' ', '+');
                stringBuffer.append(string + ",");
            }
            string = object[((String[])object).length - 1].replace(' ', '+');
            stringBuffer.append(string);
        }
        if (string2 != null && string2.equalsIgnoreCase("1.3.0")) {
            stringBuffer.append("&EXCEPTIONS=XML");
        } else {
            stringBuffer.append("&EXCEPTIONS=" + this.def.getExceptions());
        }
        if (this.def.getVsps() != null) {
            log.finer("Adding VSPs to URL");
            object = this.def.getVsps();
            for (int i = 0; i < ((String)object[0]).length; ++i) {
                String string6 = object[0][i];
                String string7 = object[1][i];
                stringBuffer.append("&" + string6 + "=" + string7);
                log.finer("Appending &" + string6 + "=" + string7);
            }
        } else {
            log.finer("No VendorSpecificParameters defined");
        }
        object = stringBuffer.toString();
        if (((WMSMapTheme)this.owner).getUseURLEncoding()) {
            try {
                return URLEncoder.encode((String)object, "UTF-8");
            }
            catch (Exception exception) {
                log.severe(exception.getMessage());
                return object;
            }
        }
        return object;
    }

    public StyledFeatureI getNewStyledFeatureInstance() {
        return null;
    }
}

