/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSet;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CacheMgr2;
import oracle.sdovis.DataException;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.Proj;
import oracle.sdovis.RSBundle;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.cache.CacheGroup;
import oracle.sdovis.cache.MVLinkedHashMap;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.theme.LocalThemeDataProducer;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.theme.TopologyThemeDefinition;
import oracle.sdovis.util.JDBCUtil;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;

public class TopologyThemeProducer
implements ThemeDataProducer {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static final int YIELD_COUNT = 20;
    protected Theme owner;
    protected TopologyThemeDefinition def;
    LocalThemeDataProducer features;
    int visSRID = 0;
    String dbVersion = null;
    double viewResX = Double.MIN_VALUE;
    double viewResY = Double.MIN_VALUE;
    double swxl = Double.MIN_VALUE;
    double swxh = Double.MAX_VALUE;
    double swyl = Double.MIN_VALUE;
    double swyh = Double.MAX_VALUE;
    boolean applyRotation = false;
    double mapRotation = 0.0;

    public TopologyThemeProducer(Theme theme) {
        this.owner = theme;
        this.def = (TopologyThemeDefinition)theme.getDefinition();
    }

    public Theme getTheme() {
        return this.owner;
    }

    public void destroy() {
    }

    public void abort() {
    }

    public void setStyledFeatures(StyledFeatureI[] styledFeatureIArray) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(styledFeatureIArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int prepareData(Rectangle2D rectangle2D, VisContext visContext) throws DataException {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        boolean bl;
        double d6;
        double d7;
        double d8;
        double d9;
        boolean bl2;
        SRS sRS;
        SRSCache sRSCache;
        ArrayList arrayList;
        int n;
        Connection connection;
        block76: {
            block75: {
                connection = null;
                try {
                    connection = DSUtil.getDBConnection(this.def.getDataSourceName(), visContext);
                }
                catch (Exception exception) {
                    throw new DataException("Cannot obtain a connection to database.", exception);
                }
                if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                    try {
                        if (this.getTheme().getDecorator().getWorkspaceName() == null) break block75;
                        if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                            Util.gotoWorkspaceDate(connection, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceDate(), this.getTheme().getDecorator().getWorkspaceDateFormat(), this.getTheme().getDecorator().getWorkspaceDateNlsParam(), this.getTheme().getDecorator().isWorkspaceDateTsWtz());
                            break block75;
                        }
                        if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                            Util.gotoWorkspaceSavedPoint(connection, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceSavedPoint());
                        } else {
                            Util.gotoWorkspace(connection, this.getTheme().getDecorator().getWorkspaceName());
                        }
                    }
                    catch (Exception exception) {
                        String string = "Cannot go to workspace " + this.getTheme().getDecorator().getWorkspaceName();
                        if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                            string = string + ", Date " + this.getTheme().getDecorator().getWorkspaceDate();
                        } else if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                            string = string + ", Saved Point " + this.getTheme().getDecorator().getWorkspaceSavedPoint();
                        }
                        log.log(Level.SEVERE, string, exception);
                        throw new DataException(string);
                    }
                }
            }
            this.visSRID = visContext.getMasterSRID();
            n = 0;
            arrayList = new ArrayList(128);
            ArrayList arrayList2 = new ArrayList(128);
            sRSCache = DSManager.getSRSCache(this.def.getDataSourceName());
            sRS = sRSCache.get(this.def.getSrid());
            bl2 = false;
            String string = null;
            if (sRS != null) {
                bl2 = sRS.isGeodetic();
                string = sRS.getUnit();
            } else if (this.def.getSrid() > 0) {
                log.warning("cannot locate an SRS object for srid: " + this.def.getSrid());
            }
            d9 = rectangle2D.getMinX();
            d8 = rectangle2D.getMinY();
            d7 = rectangle2D.getMaxX();
            d6 = rectangle2D.getMaxY();
            bl = false;
            d5 = d9;
            d4 = d7;
            d3 = d8;
            d2 = d6;
            d = visContext.getCurrentScale();
            this.getTheme().setShowLabels(true);
            if (visContext.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != visContext.getMasterSRID()) {
                if (this.def.isPredefined()) {
                    this.def.createCacheGeomGroup(visContext.getMasterSRID());
                    this.def.createCacheEdgeGroup(visContext.getMasterSRID());
                    this.def.createCacheNodeGroup(visContext.getMasterSRID());
                }
                if (d != Double.POSITIVE_INFINITY && d != Double.NEGATIVE_INFINITY) {
                    double[] dArray = new double[]{d9, d8, d7, d6};
                    double[] dArray2 = Util.convertMBR(dArray, visContext.getMasterSRID(), this.def.getSrid(), connection);
                    if (dArray2 != null) {
                        d9 = dArray2[0];
                        d8 = dArray2[1];
                        d7 = dArray2[2];
                        d6 = dArray2[3];
                        bl = true;
                        break block76;
                    } else {
                        log.severe(RSBundle.getMsg("MAPVIEWER-01024"));
                        try {
                            if (connection == null) return 0;
                            DSUtil.closeDBConnection(connection, this.def.getDataSourceName());
                            return 0;
                        }
                        catch (Exception exception) {
                            log.warning(exception.getMessage());
                        }
                        return 0;
                    }
                }
                bl = true;
            }
        }
        if (d != Double.POSITIVE_INFINITY && d != Double.NEGATIVE_INFINITY) {
            double d10 = Math.abs(d6 - d8) / Math.abs(d2 - d3);
            log.finer("[Master scale] " + d + " [Scale factor for theme " + this.getTheme().getName() + "] " + d10);
            double d11 = d * d10;
            if (this.getTheme().getDecorator().getScaleType() == "RATIO") {
                double d12;
                double d13;
                if (visContext.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != visContext.getMasterSRID() && visContext.isTileRequest()) {
                    sRS = sRSCache.get(visContext.getMasterSRID());
                    d13 = (d5 + d4) / 2.0;
                    d12 = (d3 + d2) / 2.0;
                    d10 = 1.0;
                } else {
                    d13 = (d9 + d7) / 2.0;
                    d12 = (d8 + d6) / 2.0;
                }
                if (visContext.isTileRequest() && sRS.isGeodetic()) {
                    d13 = 0.0;
                    d12 = 0.0;
                }
                if (sRS != null) {
                    d11 = sRS.getRatioScale(d * d10, new Point2D.Double(d13, d12));
                    log.finer("Ratio scale to compare: " + d11);
                } else {
                    log.severe(RSBundle.getMsg("MAPVIEWER-01025"));
                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                        try {
                            Util.gotoWorkspace(connection, "LIVE");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        if (connection == null) return 0;
                        DSUtil.closeDBConnection(connection, this.def.getDataSourceName());
                        return 0;
                    }
                    catch (Exception exception) {
                        log.warning(exception.getMessage());
                    }
                    return 0;
                }
            }
            if (!this.getTheme().getDecorator().withinScaleLimits(d11)) {
                log.warning("Scale definition for theme " + this.getTheme().getName() + " is out of range.");
                if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                    try {
                        Util.gotoWorkspace(connection, "LIVE");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    if (connection == null) return 0;
                    DSUtil.closeDBConnection(connection, this.def.getDataSourceName());
                    return 0;
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                return 0;
            }
            if (!this.getTheme().getDecorator().withinLabelScaleLimits(d11)) {
                log.info("Label Scale definition for theme " + this.getTheme().getName() + " is out of range. Labels will not be rendered.");
                this.getTheme().setShowLabels(false);
            }
        }
        boolean bl3 = false;
        boolean bl4 = bl3 = bl2 && d7 - d9 >= 2.0 && d7 - d9 < 120.0;
        if (bl3) {
            d9 = Math.floor(d9);
            log.finest("ptvpxfmfxed: xl=" + d9);
        }
        log.finest("[ " + this.def.getName() + " ]:  " + d9 + "," + d8 + "," + d7 + "," + d6);
        this.swxl = d9;
        this.swxh = d7;
        this.swyl = d8;
        this.swyh = d6;
        this.applyRotation = false;
        this.mapRotation = 0.0;
        if (MapMaker.isSpecial(d9, d8, d7, d6) && visContext.getRotation() != 0.0) {
            log.warning("Rotation is currently ignored for full extent.");
        } else if (visContext.getRotation() != 0.0 && !MapMaker.isSpecial(d9, d8, d7, d6)) {
            if (visContext.getRotation() < -360.0 || visContext.getRotation() > 360.0) {
                log.warning("Rotation value must be in between -360 to 360 degrees. ignored");
            } else {
                double[] dArray = Util.rotateMBR(d9, d8, d7, d6, visContext.getRotation());
                if (dArray != null) {
                    d9 = Math.min(dArray[0], d9);
                    d8 = Math.min(dArray[1], d8);
                    d7 = Math.max(dArray[2], d7);
                    d6 = Math.max(dArray[3], d6);
                    log.finest("Rotation angle: " + visContext.getRotation());
                    log.finest("Search window for rotation: " + d9 + "," + d8 + "," + d7 + "," + d6);
                    this.applyRotation = true;
                    this.mapRotation = visContext.getRotation();
                    this.swxl = d9;
                    this.swxh = d7;
                    this.swyl = d8;
                    this.swyh = d6;
                } else {
                    log.info("Rotated MBR is null. Rotation ignored.");
                }
            }
        }
        if (bl) {
            this.swxl = d5;
            this.swxh = d4;
            this.swyl = d3;
            this.swyh = d2;
        }
        Proj proj = visContext.getProjection();
        this.viewResX = visContext.getDeviceWindow().getWidth();
        this.viewResY = visContext.getDeviceWindow().getHeight();
        this.dbVersion = Util.getDBVersion(connection);
        long l = 0L;
        long l2 = 0L;
        if (this.def.getQuery() != null) {
            try {
                l = System.currentTimeMillis();
                n = !this.def.isPredefined() ? this.processJDBCQuery(connection, bl, d9, d8, d7, d6, arrayList, proj, bl2, n, visContext) : this.processPredefinedQuery(connection, bl, d9, d8, d7, d6, arrayList, proj, bl2, n, visContext);
                l2 = System.currentTimeMillis();
                log.info("Processing time (querying and loading) [" + this.def.name + "]: " + (l2 - l) + " ms" + " for " + arrayList.size() + " features");
            }
            catch (Exception exception) {
                if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                    try {
                        Util.gotoWorkspace(connection, "LIVE");
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                try {
                    if (connection == null) throw new DataException(exception);
                    DSUtil.closeDBConnection(connection, this.def.getDataSourceName());
                    throw new DataException(exception);
                }
                catch (Exception exception3) {
                    log.warning(exception3.getMessage());
                }
                throw new DataException(exception);
            }
        }
        if (this.def.getDebugTheme()) {
            l = System.currentTimeMillis();
            try {
                if (this.def.getFaceStyle() != null) {
                    n = this.processFaceQuery(connection, bl, d9, d8, d7, d6, arrayList, proj, bl2, n, visContext);
                }
                if (this.def.getEdgeStyle() != null) {
                    n = this.processEdgeQuery(connection, bl, d9, d8, d7, d6, arrayList, proj, bl2, n, visContext);
                }
                if (this.def.getNodeStyle() != null) {
                    n = this.processNodeQuery(connection, bl, d9, d8, d7, d6, arrayList, proj, bl2, n, visContext);
                }
                l2 = System.currentTimeMillis();
                log.info("Processing time (querying and loading) [" + this.def.name + "]: " + (l2 - l) + " ms" + " for " + arrayList.size() + " features");
            }
            catch (Exception exception) {
                if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                    try {
                        Util.gotoWorkspace(connection, "LIVE");
                    }
                    catch (Exception exception4) {
                        // empty catch block
                    }
                }
                try {
                    if (connection == null) throw new DataException(exception);
                    DSUtil.closeDBConnection(connection, this.def.getDataSourceName());
                    throw new DataException(exception);
                }
                catch (Exception exception5) {
                    log.warning(exception5.getMessage());
                }
                throw new DataException(exception);
            }
        }
        if (this.getTheme().getDecorator().getWorkspaceName() != null) {
            try {
                Util.gotoWorkspace(connection, "LIVE");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (connection != null) {
                DSUtil.closeDBConnection(connection, this.def.getDataSourceName());
            }
        }
        catch (Exception exception) {
            log.warning(exception.getMessage());
        }
        if (arrayList.size() <= 0) {
            return 0;
        }
        this.setStyledFeatures(arrayList);
        return this.features.size();
    }

    private String rewriteTopologyEdgeQuery(Connection connection, boolean bl, double d, double d2, double d3, double d4, boolean bl2) {
        String string = this.def.getQuery();
        if (string == null) {
            return null;
        }
        String string2 = this.def.getTopologyName();
        String string3 = this.def.getFeatureTable();
        String string4 = this.def.getTopoGeometryColumn();
        String string5 = "";
        if (!this.def.getTopologyOwner().equalsIgnoreCase(this.def.getConnectionUser())) {
            string5 = this.def.getTopologyOwner() + ".";
        }
        if (this.def.getTopoView() != null && this.def.getTopoViewColumn() != null) {
            string3 = this.def.getTopoView();
            string4 = this.def.getTopoViewColumn();
        }
        String string6 = "";
        if (this.def.isPredefined()) {
            string6 = string5 + string2 + "_edge$." + this.def.getKeyColumn() + " mv_key, ";
        }
        String string7 = "geometry";
        if (bl) {
            string7 = "sdo_cs.transform(geometry," + this.visSRID + ") geometry";
        }
        String string8 = "select * from (select " + string6 + string7 + ", mv_result.* from " + string5 + string2 + "_edge$ inner join (";
        String string9 = null;
        string9 = "(" + string + ") tpf_feat";
        string8 = string8 + "select edge_id, start_node_id, end_node_id, tpf_feat." + string4 + ".tg_id mv_tgid, " + string5 + string2 + "_edge$.rowid edge_rowid, tpf_feat.* from " + string9 + " inner join " + string5 + string2 + "_relation$ tpf_rel on " + "(tpf_feat." + string4 + ".tg_layer_id = " + "tpf_rel.tg_layer_id and " + "tpf_feat." + string4 + ".tg_id = " + "tpf_rel.tg_id and " + "tpf_feat." + string4 + ".tg_layer_id = " + this.def.getTopoLayerID() + ") inner join " + string5 + string2 + "_edge$ on abs(topo_id) = edge_id " + " and topo_type = 2 order by tpf_feat." + string4 + ".tg_id) mv_result on " + string5 + string2 + "_edge$.rowid = mv_result.edge_rowid";
        String string10 = null;
        if (!this.isFullExtent(this.def.getASIS(), d, d2, d3, d4)) {
            string10 = this.getFilter("geometry", this.def.getSrid(), d, d2, d3, d4, this.def.is9i(), bl2);
        }
        string8 = string10 != null ? string8 + " and " + string10 + ") order by mv_tgid" : string8 + ") order by mv_tgid";
        return string8;
    }

    private String rewriteTopologyEdgeQueryV2(Connection connection, boolean bl, double d, double d2, double d3, double d4, boolean bl2, String string) {
        String string2 = this.def.getQuery();
        if (string2 == null) {
            return null;
        }
        String string3 = this.def.getTopologyName();
        String string4 = this.def.getFeatureTable();
        String string5 = this.def.getTopoGeometryColumn();
        String string6 = "";
        if (!this.def.getTopologyOwner().equalsIgnoreCase(this.def.getConnectionUser())) {
            string6 = this.def.getTopologyOwner() + ".";
        }
        String string7 = string6 + string3;
        if (this.def.getTopoView() != null && this.def.getTopoViewColumn() != null) {
            string4 = this.def.getTopoView();
            string5 = this.def.getTopoViewColumn();
        }
        String string8 = "";
        if (this.def.isPredefined()) {
            string8 = string6 + string3 + "_edge$." + this.def.getKeyColumn() + " mv_key,\n";
        }
        String string9 = "geometry";
        if (bl) {
            string9 = "sdo_cs.transform(geometry," + this.visSRID + ") geometry";
        }
        String string10 = null;
        if (!this.isFullExtent(this.def.getASIS(), d, d2, d3, d4)) {
            string10 = this.getFilter("geometry", this.def.getSrid(), d, d2, d3, d4, this.def.is9i(), bl2);
        }
        String string11 = "select /*+ ordered use_nl (tpf_feat, other_query) */\n        other_query.*,tpf_feat." + string5 + ".tg_id,tpf_feat.*\n" + "from (\n" + "      select /*+ ordered index(tpf_rel " + string7 + "_rel_idx$)\n" + "              use_nl (" + string7 + "_edge$,tpf_rel)\n" + "              use_nl (tpf_rel,topo_idx) */\n" + "        " + string8 + "        " + string9 + ",\n" + "         edge_id,\n" + "         start_node_id,\n" + "         end_node_id,\n" + "         topo_idx.sdo_rowid\n" + "       from " + string7 + "_edge$,\n" + "            " + string7 + "_relation$ tpf_rel,\n" + "            " + string + " topo_idx\n" + "       where\n" + "             topo_idx.sdo_tg_id = tpf_rel.tg_id\n" + "             and tpf_rel.topo_type = 2\n" + "             and tpf_rel.topo_id = edge_id\n" + "             and tpf_rel.tg_layer_id = " + this.def.getTopoLayerID() + "\n";
        if (string10 != null) {
            string11 = string11 + "             and " + string10 + "\n";
        }
        string11 = string11 + "       ) other_query,\n       (" + string2 + ") tpf_feat\n" + "where other_query.sdo_rowid = tpf_feat.rowid\n" + "      order by tpf_feat." + string5 + ".tg_id";
        return string11;
    }

    private String rewriteTopologyPointQuery(Connection connection, boolean bl, double d, double d2, double d3, double d4, boolean bl2) {
        String string = this.def.getQuery();
        if (string == null) {
            return null;
        }
        String string2 = this.def.getTopologyName();
        String string3 = this.def.getFeatureTable();
        String string4 = this.def.getTopoGeometryColumn();
        String string5 = "";
        if (!this.def.getTopologyOwner().equalsIgnoreCase(this.def.getConnectionUser())) {
            string5 = this.def.getTopologyOwner() + ".";
        }
        if (this.def.getTopoView() != null && this.def.getTopoViewColumn() != null) {
            string3 = this.def.getTopoView();
            string4 = this.def.getTopoViewColumn();
        }
        String string6 = "";
        if (this.def.isPredefined()) {
            string6 = string5 + string2 + "_node$." + this.def.getKeyColumn() + " mv_key, ";
        }
        String string7 = "geometry";
        if (bl) {
            string7 = "sdo_cs.transform(geometry," + this.visSRID + ") geometry";
        }
        String string8 = "select * from (select " + string6 + string7 + ", mv_result.* from " + string5 + string2 + "_node$ inner join (";
        String string9 = null;
        string9 = "(" + string + ") tpf_feat";
        string8 = string8 + "select node_id, 0 mv_void1, 0 mv_void2, tpf_feat." + string4 + ".tg_id mv_tgid, " + string5 + string2 + "_node$.rowid node_rowid, tpf_feat.* from " + string9 + " inner join " + string5 + string2 + "_relation$ tpf_rel on " + "(tpf_feat." + string4 + ".tg_layer_id = " + "tpf_rel.tg_layer_id and " + "tpf_feat." + string4 + ".tg_id = " + "tpf_rel.tg_id and " + "tpf_feat." + string4 + ".tg_layer_id = " + this.def.getTopoLayerID() + ") inner join " + string5 + string2 + "_node$ on topo_id = node_id " + " and topo_type = 1 order by tpf_feat." + string4 + ".tg_id) mv_result on " + string5 + string2 + "_node$.rowid = mv_result.node_rowid";
        String string10 = null;
        if (!this.isFullExtent(this.def.getASIS(), d, d2, d3, d4)) {
            string10 = this.getFilter("geometry", this.def.getSrid(), d, d2, d3, d4, this.def.is9i(), bl2);
        }
        string8 = string10 != null ? string8 + " and " + string10 + ") order by mv_tgid" : string8 + ") order by mv_tgid";
        return string8;
    }

    private String rewriteTopologyPointQueryV2(Connection connection, boolean bl, double d, double d2, double d3, double d4, boolean bl2, String string) {
        String string2 = this.def.getQuery();
        if (string2 == null) {
            return null;
        }
        String string3 = this.def.getTopologyName();
        String string4 = this.def.getFeatureTable();
        String string5 = this.def.getTopoGeometryColumn();
        String string6 = "";
        if (!this.def.getTopologyOwner().equalsIgnoreCase(this.def.getConnectionUser())) {
            string6 = this.def.getTopologyOwner() + ".";
        }
        String string7 = string6 + string3;
        if (this.def.getTopoView() != null && this.def.getTopoViewColumn() != null) {
            string4 = this.def.getTopoView();
            string5 = this.def.getTopoViewColumn();
        }
        String string8 = "";
        if (this.def.isPredefined()) {
            string8 = string6 + string3 + "_node$." + this.def.getKeyColumn() + " mv_key,\n";
        }
        String string9 = "geometry";
        if (bl) {
            string9 = "sdo_cs.transform(geometry," + this.visSRID + ") geometry";
        }
        String string10 = null;
        if (!this.isFullExtent(this.def.getASIS(), d, d2, d3, d4)) {
            string10 = this.getFilter("geometry", this.def.getSrid(), d, d2, d3, d4, this.def.is9i(), bl2);
        }
        String string11 = "select /*+ ordered use_nl (tpf_feat, other_query) */\n        other_query.*,tpf_feat." + string5 + ".tg_id,tpf_feat.*\n" + "from (\n" + "      select /*+ ordered index(tpf_rel " + string7 + "_rel_idx$)\n" + "              use_nl (" + string7 + "_node$,tpf_rel)\n" + "              use_nl (tpf_rel,topo_idx) */\n" + "        " + string8 + "        " + string9 + ",\n" + "         node_id,\n" + "         0 mv_void1,\n" + "         0 mv_void2,\n" + "         topo_idx.sdo_rowid\n" + "       from " + string7 + "_node$,\n" + "            " + string7 + "_relation$ tpf_rel,\n" + "            " + string + " topo_idx\n" + "       where\n" + "             topo_idx.sdo_tg_id = tpf_rel.tg_id\n" + "             and tpf_rel.topo_type = 1\n" + "             and tpf_rel.topo_id = node_id\n" + "             and tpf_rel.tg_layer_id = " + this.def.getTopoLayerID() + "\n";
        if (string10 != null) {
            string11 = string11 + "             and " + string10 + "\n";
        }
        string11 = string11 + "       ) other_query,\n       (" + string2 + ") tpf_feat\n" + "where other_query.sdo_rowid = tpf_feat.rowid\n" + "      order by tpf_feat." + string5 + ".tg_id";
        return string11;
    }

    private String rewriteTopologyFaceQuery(boolean bl, double d, double d2, double d3, double d4, boolean bl2) {
        String string = this.def.getQuery();
        if (string == null) {
            return null;
        }
        String string2 = this.def.getTopologyName();
        String string3 = this.def.getFeatureTable();
        String string4 = this.def.getTopoGeometryColumn();
        String string5 = "mbr_geometry";
        String string6 = "geometry";
        String string7 = null;
        String string8 = "";
        if (!this.def.getTopologyOwner().equalsIgnoreCase(this.def.getConnectionUser())) {
            string8 = this.def.getTopologyOwner() + ".";
        }
        if (this.def.getTopoView() != null && this.def.getTopoViewColumn() != null) {
            string3 = this.def.getTopoView();
            string4 = this.def.getTopoViewColumn();
        }
        if (!this.isFullExtent(this.def.getASIS(), d, d2, d3, d4)) {
            string7 = this.getFilter(string5, this.def.getSrid(), d, d2, d3, d4, this.def.is9i(), bl2);
        }
        String string9 = "";
        if (this.def.isPredefined()) {
            string9 = string8 + string2 + "_edge$." + this.def.getKeyColumn() + " mv_rowid,";
        }
        String string10 = string6;
        if (bl) {
            string10 = "sdo_cs.transform(" + string6 + "," + this.visSRID + ") " + string6;
        }
        String string11 = "select * from (select " + string9 + string10 + ",final_result.* from " + string8 + string2 + "_edge$ inner join (" + "select  mv_result.* from " + string8 + string2 + "_face$ inner join (" + "select mv_face_geom.*,mv_face_feat.* from (";
        String string12 = string8 + string2 + "_edge$.rowid edge_rowid, ";
        String string13 = string8 + string2 + "_face$.rowid face_rowid, ";
        String string14 = "select edge_id, start_node_id, end_node_id, next_left_edge_id nextedge, prev_left_edge_id prevedge, left_face_id left_face, right_face_id right_face, " + string12 + string13 + "face_id from " + string8 + string2 + "_edge$ " + "inner join " + string8 + string2 + "_face$ on " + "left_face_id = face_id where (abs(next_left_edge_id) != edge_id " + "or start_node_id = end_node_id) and face_id > 0 " + "and (left_face_id != right_face_id) ";
        String string15 = "select edge_id, start_node_id,end_node_id, next_right_edge_id nextedge, prev_right_edge_id prevedge, left_face_id left_face, right_face_id right_face, " + string12 + string13 + "face_id from " + string8 + string2 + "_edge$ " + "inner join " + string8 + string2 + "_face$ on " + "right_face_id = face_id where (abs(next_right_edge_id) != edge_id " + "or start_node_id = end_node_id) and face_id > 0 " + "and (left_face_id != right_face_id) ";
        string11 = string11 + string14 + " union all " + string15 + ") mv_face_geom inner join (";
        String string16 = this.getRelationExpression();
        String string17 = "select tpf_feat." + string4 + ".tg_id tg_id, " + "topo_id, tpf_feat.* from " + "(" + string + ") tpf_feat inner join " + string16 + " tpf_rel on (" + "tpf_feat." + string4 + ".tg_layer_id = " + "tpf_rel.tg_layer_id and " + "tpf_feat." + string4 + ".tg_id = " + "tpf_rel.tg_id and tpf_rel.topo_type = 3) inner join " + string8 + string2 + "_face$ on topo_id = face_id";
        string11 = string11 + string17 + ") mv_face_feat on " + "mv_face_geom.face_id = mv_face_feat.topo_id " + "order by mv_face_feat." + string4 + ".tg_id,face_id" + " ) mv_result on " + string8 + string2 + "_face$.rowid = " + "mv_result.face_rowid";
        if (string7 != null) {
            string11 = string11 + " and " + string7;
        }
        string11 = string11 + " order by mv_result.tg_id,mv_result.face_id ) final_result on " + string8 + string2 + "_edge$.rowid = " + "final_result.edge_rowid ) " + "order by tg_id,face_id";
        return string11;
    }

    private String rewriteTopologyFaceQueryV2(boolean bl, double d, double d2, double d3, double d4, boolean bl2, String string) {
        Object object;
        String string2 = this.def.getQuery();
        if (string2 == null) {
            return null;
        }
        String string3 = this.def.getTopologyName();
        String string4 = this.def.getFeatureTable();
        String string5 = this.def.getTopoGeometryColumn();
        String string6 = "mbr_geometry";
        String string7 = "geometry";
        String string8 = null;
        String string9 = "";
        if (!this.def.getTopologyOwner().equalsIgnoreCase(this.def.getConnectionUser())) {
            string9 = this.def.getTopologyOwner() + ".";
        }
        String string10 = string9 + string3;
        if (this.def.getTopoView() != null && this.def.getTopoViewColumn() != null) {
            string4 = this.def.getTopoView();
            string5 = this.def.getTopoViewColumn();
        }
        if (!this.isFullExtent(this.def.getASIS(), d, d2, d3, d4)) {
            string8 = this.getFilter(string6, this.def.getSrid(), d, d2, d3, d4, this.def.is9i(), bl2);
        }
        String string11 = "";
        if (this.def.isPredefined()) {
            string11 = string10 + "_edge$." + this.def.getKeyColumn() + " mv_rowid,\n";
        }
        String string12 = string7;
        if (bl) {
            string12 = "sdo_cs.transform(" + string7 + "," + this.visSRID + ") " + string7;
        }
        String string13 = "            " + string10 + "_relation$ tpf_rel,\n";
        String string14 = "                 use_nl (tpf_rel,topo_idx)\n";
        String string15 = "tpf_rel.tg_id\n";
        String string16 = "";
        String string17 = "index(tpf_rel " + string10 + "_rel_idx$)";
        int n = this.def.getTopoLayerID();
        if (this.def.getTopoLayerLevel() > 0) {
            int n2;
            object = this.def.getLayersHierarchy();
            n = object[0];
            string14 = "                 use_nl (tpf_rel,tpf_rel1)\n";
            for (n2 = 1; n2 < this.def.getTopoLayerLevel(); ++n2) {
                string14 = string14 + "                 use_nl (tpf_rel" + n2 + ",tpf_rel" + (n2 + 1) + ")\n";
            }
            string14 = string14 + "                 use_nl (tpf_rel" + this.def.getTopoLayerLevel() + ",topo_idx)\n";
            string16 = "             and tpf_rel1.topo_id = tpf_rel.tg_layer_id\n             and tpf_rel1.topo_type = tpf_rel.tg_id\n             and tpf_rel1.tg_layer_id = " + object[1] + "\n";
            for (n2 = 2; n2 <= this.def.getTopoLayerLevel(); ++n2) {
                string16 = string16 + "             and tpf_rel" + n2 + ".topo_id = tpf_rel" + (n2 - 1) + ".tg_layer_id\n" + "             and tpf_rel" + n2 + ".topo_type = tpf_rel" + (n2 - 1) + ".tg_id\n" + "             and tpf_rel" + n2 + ".tg_layer_id = " + object[n2] + "\n";
            }
            for (n2 = 1; n2 <= this.def.getTopoLayerLevel(); ++n2) {
                string13 = string13 + "            " + string10 + "_relation$ tpf_rel" + n2 + ",\n";
                string17 = string17 + " index(tpf_rel" + n2 + " " + string10 + "_rel_idx$)";
            }
            string17 = string17 + "\n";
            string15 = "tpf_rel" + this.def.getTopoLayerLevel() + ".tg_id\n";
        } else {
            string17 = string17 + "\n";
        }
        object = "select /*+ ordered use_nl (tpf_feat, other_query) */\n      other_query.*,tpf_feat." + string5 + ".tg_id,tpf_feat.* \n" + "from (select /*+ ordered " + string17 + "                 use_nl (" + string10 + "_face$,tpf_rel)\n" + string14 + "                 use_nl (" + string10 + "_face$," + string10 + "_edge$) */\n" + "        " + string11 + "        " + string12 + ",\n" + "        " + string10 + "_edge$.edge_id,\n" + "        " + string10 + "_edge$.start_node_id,\n" + "        " + string10 + "_edge$.end_node_id,\n" + "        " + string10 + "_edge$.next_left_edge_id tpl_nextedge,\n" + "        " + string10 + "_edge$.prev_left_edge_id tpl_prevedge,\n" + "        " + string10 + "_edge$.left_face_id tpl_leftface,\n" + "        " + string10 + "_edge$.right_face_id tpl_rightface,\n" + "        " + string10 + "_edge$.rowid tpl_edge_rowid,\n" + "        " + string10 + "_face$.rowid tpf_face_rowid,\n" + "        " + string10 + "_face$.face_id,\n" + "         topo_idx.sdo_rowid,\n" + "        " + string10 + "_face$.face_id topo_id\n" + "       from " + string10 + "_face$,\n" + "            " + string10 + "_edge$,\n" + string13 + "            " + string + " topo_idx\n" + "       where left_face_id = face_id\n" + "             and (abs(next_left_edge_id) != edge_id OR start_node_id = end_node_id)\n" + "             and (left_face_id != right_face_id)\n";
        if (string8 != null) {
            object = (String)object + "             and " + string8 + "\n";
        }
        object = (String)object + "             and topo_idx.sdo_tg_id = " + string15 + "             and tpf_rel.topo_type = 3\n" + "             and tpf_rel.topo_id = face_id\n" + "             and tpf_rel.tg_layer_id = " + n + "\n" + string16 + "        union all\n" + "        select /*+ ordered " + string17 + "                 use_nl (" + string10 + "_face$,tpf_rel)\n" + string14 + "                 use_nl (" + string10 + "_face$," + string10 + "_edge$) */\n" + "        " + string11 + "        " + string12 + ",\n" + "        " + string10 + "_edge$.edge_id,\n" + "        " + string10 + "_edge$.start_node_id,\n" + "        " + string10 + "_edge$.end_node_id,\n" + "        " + string10 + "_edge$.next_right_edge_id tpl_nextedge,\n" + "        " + string10 + "_edge$.prev_right_edge_id tpl_prevedge,\n" + "        " + string10 + "_edge$.left_face_id tpl_leftface,\n" + "        " + string10 + "_edge$.right_face_id tpl_rightface,\n" + "        " + string10 + "_edge$.rowid tpl_edge_rowid,\n" + "        " + string10 + "_face$.rowid tpf_face_rowid,\n" + "        " + string10 + "_face$.face_id,\n" + "         topo_idx.sdo_rowid,\n" + "        " + string10 + "_face$.face_id topo_id\n" + "       from " + string10 + "_face$,\n" + "            " + string10 + "_edge$,\n" + string13 + "            " + string + " topo_idx\n" + "       where right_face_id = face_id\n" + "             and (abs(next_right_edge_id) != edge_id OR start_node_id = end_node_id)\n" + "             and (left_face_id != right_face_id)\n";
        if (string8 != null) {
            object = (String)object + "             and " + string8 + "\n";
        }
        object = (String)object + "             and topo_idx.sdo_tg_id = " + string15 + "             and tpf_rel.topo_type = 3\n" + "             and tpf_rel.topo_id = face_id\n" + "             and tpf_rel.tg_layer_id = " + n + "\n" + string16 + "       ) other_query, \n" + "       (" + string2 + ") tpf_feat\n" + "where other_query.sdo_rowid = tpf_feat.rowid\n" + "      order by tpf_feat." + string5 + ".tg_id, other_query.face_id";
        return object;
    }

    private String getRelationExpression() {
        String string = this.def.getTopologyName();
        String string2 = this.def.getFeatureTable();
        String string3 = this.def.getTopoGeometryColumn();
        String string4 = "";
        if (!this.def.getTopologyOwner().equalsIgnoreCase(this.def.getConnectionUser())) {
            string4 = this.def.getTopologyOwner() + ".";
        }
        String string5 = string4 + string + "_relation$";
        int n = this.def.getTopoLayerID();
        int n2 = this.def.getChildLayerID();
        int n3 = this.def.getTopoLayerLevel();
        if (this.def.getTopoLayerLevel() > 0) {
            int n4;
            int[] nArray = this.def.getLayersHierarchy();
            string5 = "";
            for (n4 = n3; n4 > 0; --n4) {
                string5 = string5 + "( select mv_table" + (n4 + 1) + n4 + ".tg_layer_id, " + "mv_table" + (n4 + 1) + n4 + ".tg_id, " + "mv_table" + n4 + (n4 + 1) + ".topo_id," + "mv_table" + n4 + (n4 + 1) + ".topo_type from " + string4 + string + "_relation$ mv_table" + (n4 + 1) + n4 + " inner join ";
            }
            string5 = string5 + string4 + string + "_relation$ ";
            for (n4 = 1; n4 <= n3; ++n4) {
                if (n4 != 1) {
                    string5 = string5 + ") ";
                }
                string5 = string5 + " mv_table" + n4 + (n4 + 1) + " on ";
                string5 = string5 + "(mv_table" + (n4 + 1) + n4 + ".topo_id = mv_table" + n4 + (n4 + 1) + ".tg_layer_id and mv_table" + (n4 + 1) + n4 + ".topo_type = " + "mv_table" + n4 + (n4 + 1) + ".tg_id and mv_table" + (n4 + 1) + n4 + ".tg_layer_id = " + nArray[n4 - 1] + ")";
            }
            string5 = string5 + " )";
        }
        return string5;
    }

    private String rewriteFaceQuery(boolean bl, double d, double d2, double d3, double d4, boolean bl2) {
        String string;
        String string2 = "geometry";
        String string3 = "mbr_geometry";
        String string4 = this.def.getTopologyName();
        String string5 = "select geometry, edge_id, start_node_id, end_node_id, next_left_edge_id nextedge, prev_left_edge_id prevedge, left_face_id left_face, right_face_id right_face, face_id from " + string4 + "_edge$ " + "inner join " + string4 + "_face$ on " + "left_face_id = face_id where (abs(next_left_edge_id) != edge_id " + "or start_node_id = end_node_id) and face_id > 0 " + "and (left_face_id != right_face_id) ";
        String string6 = "select geometry, edge_id,start_node_id,end_node_id, next_right_edge_id nextedge, prev_right_edge_id prevedge, left_face_id left_face, right_face_id right_face, face_id from " + string4 + "_edge$ " + "inner join " + string4 + "_face$ on " + "right_face_id = face_id where (abs(next_right_edge_id) != edge_id " + "or start_node_id = end_node_id) and face_id > 0 " + "and (left_face_id != right_face_id) ";
        String string7 = string5;
        String string8 = string6;
        if (bl) {
            string = string2;
            String string9 = "sdo_cs.transform(" + string2 + "," + this.visSRID + ") " + string2;
            string7 = string5.replaceFirst(string, string9);
            string8 = string6.replaceFirst(string, string9);
        }
        if (this.isFullExtent(this.def.getASIS(), d, d2, d3, d4)) {
            return string7 + " union all " + string8 + " order by face_id";
        }
        string = this.getFilter(string3, this.def.getSrid(), d, d2, d3, d4, this.def.is9i(), bl2);
        return string7 + " AND " + string + " union all " + string8 + " AND " + string + " order by face_id";
    }

    private String rewriteFaceQueryV2(boolean bl, double d, double d2, double d3, double d4, boolean bl2) {
        String string = "geometry";
        String string2 = "mbr_geometry";
        String string3 = this.def.getTopologyName();
        String string4 = null;
        if (!this.isFullExtent(this.def.getASIS(), d, d2, d3, d4)) {
            string4 = this.getFilter(string2, this.def.getSrid(), d, d2, d3, d4, this.def.is9i(), bl2);
        }
        if (bl) {
            string = "sdo_cs.transform(" + string + "," + this.visSRID + ") " + string;
        }
        String string5 = "select /*+ ordered \n        use_nl (" + string3 + "_face$," + string3 + "_edge$)*/\n" + "   " + string + ",\n" + "   edge_id, start_node_id, end_node_id,\n" + "   next_left_edge_id nextedge, prev_left_edge_id prevedge,\n" + "   left_face_id left_face, right_face_id right_face, face_id\n" + "from " + string3 + "_face$," + string3 + "_edge$\n" + "where\n" + "   left_face_id = face_id\n" + "   and (abs(next_left_edge_id) != edge_id or start_node_id = end_node_id)\n" + "   and face_id > 0\n" + "   and (left_face_id != right_face_id)\n";
        if (string4 != null) {
            string5 = string5 + "   and " + string4 + "\n";
        }
        string5 = string5 + "union all\nselect /*+ ordered \n        use_nl (" + string3 + "_face$," + string3 + "_edge$)*/\n" + "   " + string + ",\n" + "   edge_id, start_node_id, end_node_id,\n" + "   next_right_edge_id nextedge, prev_right_edge_id prevedge,\n" + "   left_face_id left_face, right_face_id right_face, face_id\n" + "from " + string3 + "_face$," + string3 + "_edge$\n" + "where\n" + "    right_face_id = face_id\n" + "    and (abs(next_right_edge_id) != edge_id or start_node_id = end_node_id)\n" + "    and face_id > 0\n" + "    and (left_face_id != right_face_id)\n";
        if (string4 != null) {
            string5 = string5 + "   and " + string4 + "\n";
        }
        string5 = string5 + "order by face_id";
        return string5;
    }

    private String rewriteEdgeQuery(boolean bl, double d, double d2, double d3, double d4, boolean bl2) {
        String string;
        String string2;
        String string3 = this.def.getEdgeGeometryColumn();
        String string4 = this.def.getTopologyName();
        if (string3 == null) {
            return null;
        }
        String string5 = string2 = "select " + string3 + ", edge_id from " + string4 + "_edge$";
        if (bl) {
            string = string3;
            String string6 = "sdo_cs.transform(" + string3 + "," + this.visSRID + ") " + string3;
            string5 = string2.replaceFirst(string, string6);
        }
        if (this.isFullExtent(this.def.getASIS(), d, d2, d3, d4)) {
            return string5;
        }
        string = this.getFilter(string3, this.def.getSrid(), d, d2, d3, d4, this.def.is9i(), bl2);
        return string5 + " WHERE " + string;
    }

    private String rewriteNodeQuery(boolean bl, double d, double d2, double d3, double d4, boolean bl2) {
        String string;
        String string2;
        String string3 = this.def.getNodeGeometryColumn();
        String string4 = this.def.getTopologyName();
        if (string3 == null) {
            return null;
        }
        String string5 = string2 = "select " + string3 + ", node_id from " + string4 + "_node$";
        if (bl) {
            string = string3;
            String string6 = "sdo_cs.transform(" + string3 + "," + this.visSRID + ") " + string3;
            string5 = string2.replaceFirst(string, string6);
        } else {
            string5 = string2;
        }
        if (this.isFullExtent(this.def.getASIS(), d, d2, d3, d4)) {
            return string5;
        }
        string = this.getFilter(string3, this.def.getSrid(), d, d2, d3, d4, this.def.is9i(), bl2);
        return string5 + " WHERE " + string;
    }

    final String getFilter(String string, int n, double d, double d2, double d3, double d4, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(256);
        String string2 = "";
        if (this.getTheme().getDecorator().getMinimumFeatureSizePx() > 0 && (this.dbVersion.indexOf(" 10.2") > 0 || this.dbVersion.indexOf(" 10.1.0.3") > 0 || this.dbVersion.indexOf(" 10.1.0.4") > 0 || this.dbVersion.indexOf(" 11.") > 0)) {
            double d5 = (d3 - d) / this.viewResX;
            double d6 = (d4 - d2) / this.viewResY;
            double d7 = Math.min(d5, d6) * (double)this.getTheme().getDecorator().getMinimumFeatureSizePx();
            if (bl2) {
                double d8 = 6378137.0;
                d7 *= Math.PI * d8 / 180.0;
            }
            string2 = ",'min_resolution=" + d7 + "'";
        }
        String string3 = this.def.getTopoGeometryColumn();
        if (bl && bl2) {
            stringBuffer.append("SDO_FILTER(" + string + ", ");
            stringBuffer.append("MDSYS.SDO_CS.VIEWPORT_TRANSFORM(");
            stringBuffer.append("MDSYS.SDO_GEOMETRY( 2003, 0, NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(" + d + "," + d2 + "," + d3 + "," + d4 + "))" + ", " + n + " ) " + string2 + ") = 'TRUE'");
            return stringBuffer.toString();
        }
        stringBuffer.append("SDO_FILTER(" + string + ", " + "MDSYS.SDO_GEOMETRY(2003, ");
        if (n == 0) {
            stringBuffer.append("NULL");
        } else {
            stringBuffer.append(n);
        }
        stringBuffer.append(", NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(" + d + "," + d2 + "," + d3 + "," + d4 + ")) " + string2 + ") = 'TRUE'");
        return stringBuffer.toString();
    }

    private Vector getAttributes(ResultSetMetaData resultSetMetaData, ResultSet resultSet, int n, int n2, int n3) throws SQLException, IOException {
        int n4 = n2 <= 0 ? n3 - 1 : n3 - 2;
        Vector<Field> vector = new Vector<Field>(n4);
        boolean bl = false;
        for (int i = 1; i < n3 + 1; ++i) {
            if (i <= n || i == n2) continue;
            Field field = null;
            String string = resultSetMetaData.getColumnName(i);
            int n5 = resultSetMetaData.getColumnType(i);
            field = Util.getFieldFromResultSet(n5, resultSet, i);
            field.setName(string);
            vector.add(field);
        }
        return vector;
    }

    private void fillAttributes(StyledFeatureI styledFeatureI, Vector vector) throws SQLException {
        Field[] fieldArray = this.def.getIdentifiableColumns();
        if (fieldArray == null) {
            styledFeatureI.setRenderableAttributes(vector.toArray(new Field[vector.size()]));
        } else {
            Field[] fieldArray2 = new Field[fieldArray.length];
            block0: for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                String string = field.getName();
                for (int j = 0; j < vector.size(); ++j) {
                    Field field2 = (Field)vector.get(j);
                    if (!string.equalsIgnoreCase(field2.getName())) continue;
                    fieldArray2[i] = field2;
                    vector.remove(j);
                    continue block0;
                }
            }
            styledFeatureI.setIdentifiableAttributes(fieldArray2);
            if (vector.size() > 0) {
                styledFeatureI.setRenderableAttributes(vector.toArray(new Field[vector.size()]));
            }
        }
    }

    private void loadAttributeData(ResultSet resultSet, StyledFeatureI styledFeatureI, int n, ResultSetMetaData resultSetMetaData, int n2) throws SQLException, IOException {
        Object object;
        Vector<Object> vector = new Vector<Object>(n - n2);
        for (int i = n2 + 1; i < n + 1; ++i) {
            object = null;
            String string = resultSetMetaData.getColumnName(i);
            int n3 = resultSetMetaData.getColumnType(i);
            object = Util.getFieldFromResultSet(n3, resultSet, i);
            ((Field)object).setName(string);
            vector.add(object);
        }
        Field[] fieldArray = this.def.getIdentifiableColumns();
        if (fieldArray == null) {
            styledFeatureI.setRenderableAttributes(vector.toArray(new Field[vector.size()]));
        } else {
            object = new Field[fieldArray.length];
            block1: for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                String string = field.getName();
                for (int j = 0; j < vector.size(); ++j) {
                    Field field2 = (Field)vector.get(j);
                    if (!string.equalsIgnoreCase(field2.getName())) continue;
                    object[i] = field2;
                    vector.remove(j);
                    continue block1;
                }
            }
            styledFeatureI.setIdentifiableAttributes((Field[])object);
            if (vector.size() > 0) {
                styledFeatureI.setRenderableAttributes(vector.toArray(new Field[vector.size()]));
            }
        }
    }

    private int processJDBCQuery(Connection connection, boolean bl, double d, double d2, double d3, double d4, ArrayList arrayList, Proj proj, boolean bl2, int n, VisContext visContext) throws DataException {
        int n2 = n;
        if (this.def.getTopoLayerType().equals("POLYGON")) {
            n2 = this.processTopologyFaceQueryV2(connection, bl, d, d2, d3, d4, arrayList, proj, bl2, n, visContext);
        } else if (this.def.getTopoLayerType().equals("LINE")) {
            n2 = this.processTopologyEdgeQueryV2(connection, bl, d, d2, d3, d4, arrayList, proj, bl2, n, visContext);
        } else if (this.def.getTopoLayerType().equals("POINT")) {
            n2 = this.processTopologyNodeQueryV2(connection, bl, d, d2, d3, d4, arrayList, proj, bl2, n, visContext);
        } else if (this.def.getTopoLayerType().equals("COLLECTION")) {
            n2 = this.processTopologyFaceQueryV2(connection, bl, d, d2, d3, d4, arrayList, proj, bl2, n, visContext);
            n2 = this.processTopologyEdgeQueryV2(connection, bl, d, d2, d3, d4, arrayList, proj, bl2, n2, visContext);
            n2 = this.processTopologyNodeQueryV2(connection, bl, d, d2, d3, d4, arrayList, proj, bl2, n2, visContext);
        } else {
            log.warning("Topology type " + this.def.getTopoLayerType() + " is not supported.");
        }
        return n2;
    }

    private int processPredefinedQuery(Connection connection, boolean bl, double d, double d2, double d3, double d4, ArrayList arrayList, Proj proj, boolean bl2, int n, VisContext visContext) throws DataException {
        int n2 = n;
        if (this.def.getTopoLayerType().equals("POLYGON")) {
            n2 = this.processPredefinedTopologyFaceQueryV2(connection, bl, d, d2, d3, d4, arrayList, proj, bl2, n, visContext);
        } else if (this.def.getTopoLayerType().equals("LINE")) {
            n2 = this.processPredefinedTopologyEdgeQueryV2(connection, bl, d, d2, d3, d4, arrayList, proj, bl2, n, visContext);
        } else if (this.def.getTopoLayerType().equals("POINT")) {
            n2 = this.processPredefinedTopologyNodeQueryV2(connection, bl, d, d2, d3, d4, arrayList, proj, bl2, n, visContext);
        } else if (this.def.getTopoLayerType().equals("COLLECTION")) {
            n2 = this.processPredefinedTopologyFaceQueryV2(connection, bl, d, d2, d3, d4, arrayList, proj, bl2, n, visContext);
            n2 = this.processPredefinedTopologyEdgeQueryV2(connection, bl, d, d2, d3, d4, arrayList, proj, bl2, n2, visContext);
            n2 = this.processPredefinedTopologyNodeQueryV2(connection, bl, d, d2, d3, d4, arrayList, proj, bl2, n2, visContext);
        } else {
            log.warning("Topology type " + this.def.getTopoLayerType() + " is not supported.");
        }
        return n2;
    }

    /*
     * Loose catch block
     */
    private int processFaceQuery(Connection connection, boolean bl, double d, double d2, double d3, double d4, ArrayList arrayList, Proj proj, boolean bl2, int n, VisContext visContext) throws DataException {
        int n2;
        block24: {
            PreparedStatement preparedStatement;
            ResultSet resultSet;
            block22: {
                n2 = n;
                resultSet = null;
                preparedStatement = null;
                String string = this.rewriteFaceQueryV2(bl, d, d2, d3, d4, bl2);
                log.finest("Face query [" + this.def.name + "]:\n" + string);
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setFetchSize(this.owner.getFetchSize());
                log.finer("Fetch size: " + preparedStatement.getFetchSize());
                long l = System.currentTimeMillis();
                resultSet = preparedStatement.executeQuery();
                long l2 = System.currentTimeMillis();
                log.info("Face query executed [" + this.def.name + "]: " + (l2 - l) + " ms");
                int n3 = 0;
                Vector<Object> vector = new Vector<Object>(10);
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
                Hashtable<String, TopoNode> hashtable3 = new Hashtable<String, TopoNode>();
                while (resultSet.next()) {
                    Object object;
                    Object object2;
                    int n4 = resultSet.getInt(9);
                    if (n4 != n3 && n3 != 0) {
                        this.generateFacePolygonsFromEdges(n3, vector, hashtable, hashtable3, hashtable2);
                        object2 = this.createStyledFeatureFromFace(vector, n3);
                        if (object2 != null) {
                            object2.setID(String.valueOf(n3));
                            arrayList.add(object2);
                            if (++n2 % 20 == 0) {
                                Thread.currentThread();
                                Thread.yield();
                            }
                        }
                        vector.clear();
                        hashtable2.clear();
                        hashtable3.clear();
                        hashtable.clear();
                    }
                    if ((object2 = this.loadGeometry(resultSet, proj, true, visContext, false)) == null) continue;
                    int n5 = resultSet.getInt(2);
                    int n6 = resultSet.getInt(3);
                    int n7 = resultSet.getInt(4);
                    int n8 = resultSet.getInt(5);
                    int n9 = resultSet.getInt(6);
                    int n10 = resultSet.getInt(7);
                    int n11 = resultSet.getInt(8);
                    if (n6 == n7 && (n5 == Math.abs(n8) || n5 == Math.abs(n9) || Math.abs(n8) == Math.abs(n9))) {
                        object = object2.getOrdinatesArray();
                        object2 = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])object, (int)2, (int)this.def.getSrid()));
                        vector.add(object2);
                    } else {
                        hashtable2.put(String.valueOf(n5), new Integer(n8));
                        object = new TopoEdge(n5, n4);
                        ((TopoEdge)object).setNodes(n6, n7);
                        ((TopoEdge)object).setFaces(n10, n11);
                        ((TopoEdge)object).setGeometry((JSDOGeometry)object2);
                        hashtable.put(String.valueOf(n5), object);
                        TopoNode topoNode = (TopoNode)hashtable3.get(String.valueOf(n6));
                        if (topoNode == null) {
                            topoNode = new TopoNode(n6);
                            hashtable3.put(String.valueOf(n6), topoNode);
                        }
                        topoNode.addEdge(n5);
                        TopoNode topoNode2 = (TopoNode)hashtable3.get(String.valueOf(n7));
                        if (topoNode2 == null) {
                            topoNode2 = new TopoNode(n7);
                            hashtable3.put(String.valueOf(n7), topoNode2);
                        }
                        topoNode2.addEdge(n5);
                    }
                    n3 = n4;
                }
                this.generateFacePolygonsFromEdges(n3, vector, hashtable, hashtable3, hashtable2);
                StyledFeatureI styledFeatureI = this.createStyledFeatureFromFace(vector, n3);
                if (styledFeatureI == null) break block22;
                styledFeatureI.setID(String.valueOf(n3));
                arrayList.add(styledFeatureI);
                if (++n2 % 20 != 0) break block22;
                Thread.currentThread();
                Thread.yield();
            }
            Object var42_37 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                break block24;
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            break block24;
            {
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                    throw new DataException(exception);
                }
            }
            catch (Throwable throwable) {
                Object var42_38 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                throw throwable;
            }
        }
        return n2;
    }

    /*
     * Loose catch block
     */
    private int processEdgeQuery(Connection connection, boolean bl, double d, double d2, double d3, double d4, ArrayList arrayList, Proj proj, boolean bl2, int n, VisContext visContext) throws DataException {
        int n2;
        block18: {
            n2 = n;
            ResultSet resultSet = null;
            PreparedStatement preparedStatement = null;
            String string = this.rewriteEdgeQuery(bl, d, d2, d3, d4, bl2);
            log.finest("Edge query [" + this.def.name + "]:\n" + string);
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setFetchSize(this.owner.getFetchSize());
            log.finer("Fetch size: " + preparedStatement.getFetchSize());
            long l = System.currentTimeMillis();
            resultSet = preparedStatement.executeQuery();
            long l2 = System.currentTimeMillis();
            log.info("Edge query executed [" + this.def.name + "]: " + (l2 - l) + " ms");
            while (resultSet.next()) {
                double[] dArray;
                Point2D point2D;
                JSDOGeometry jSDOGeometry = this.loadGeometry(resultSet, proj, true, visContext, false);
                if (jSDOGeometry == null) continue;
                int n3 = resultSet.getInt(2);
                StyledFeatureI styledFeatureI = this.getNewStyledFeatureInstance();
                styledFeatureI.setID(String.valueOf(n3));
                styledFeatureI.setGeometry(jSDOGeometry);
                styledFeatureI.setFeatureStyleName(this.def.getEdgeStyle());
                styledFeatureI.setDataSource(this.def.getDataSourceName());
                if (this.def.getEdgeLabelStyle() != null) {
                    styledFeatureI.setLabel(String.valueOf(n3));
                    styledFeatureI.setLabelStyleName(this.def.getEdgeLabelStyle());
                }
                arrayList.add(styledFeatureI);
                if (++n2 % 20 == 0) {
                    Thread.currentThread();
                    Thread.yield();
                }
                if (this.def.getEdgeMarkerStyle() == null || (point2D = Util.getLinePoint(dArray = jSDOGeometry.getOrdinatesArray(), 0.5)) == null) continue;
                double[] dArray2 = new double[]{point2D.getX(), point2D.getY()};
                double[] dArray3 = Util.getLineSegment(dArray, 0.5);
                double d5 = 0.0;
                double d6 = 0.0;
                d5 = dArray3[2] - dArray3[0];
                d6 = dArray3[3] - dArray3[1];
                JSDOGeometry jSDOGeometry2 = JSDOGeometry.recast(JSDOGeometry.createPoint((double[])dArray2, (int)2, (int)this.def.getSrid()));
                StyledFeatureI styledFeatureI2 = this.getNewStyledFeatureInstance();
                styledFeatureI2.setGeometry(jSDOGeometry2);
                styledFeatureI2.setDataSource(this.def.getDataSourceName());
                styledFeatureI2.setFeatureStyleName(this.def.getEdgeMarkerStyle());
                styledFeatureI2.setMarkerStyleSize(this.def.getEdgeMarkerSize());
                styledFeatureI2.setMarkerStyleOrientation(d5, d6, 0.0);
                arrayList.add(styledFeatureI2);
                if (++n2 % 20 != 0) continue;
                Thread.currentThread();
                Thread.yield();
            }
            Object var38_30 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                break block18;
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            break block18;
            {
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                    throw new DataException(exception);
                }
            }
            catch (Throwable throwable) {
                Object var38_31 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                throw throwable;
            }
        }
        return n2;
    }

    /*
     * Loose catch block
     */
    private int processNodeQuery(Connection connection, boolean bl, double d, double d2, double d3, double d4, ArrayList arrayList, Proj proj, boolean bl2, int n, VisContext visContext) throws DataException {
        int n2;
        block17: {
            n2 = n;
            ResultSet resultSet = null;
            PreparedStatement preparedStatement = null;
            String string = this.rewriteNodeQuery(bl, d, d2, d3, d4, bl2);
            log.finest("Node query [" + this.def.name + "]:\n" + string);
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setFetchSize(this.owner.getFetchSize());
            log.finer("Fetch size: " + preparedStatement.getFetchSize());
            long l = System.currentTimeMillis();
            resultSet = preparedStatement.executeQuery();
            long l2 = System.currentTimeMillis();
            log.info("Face query executed [" + this.def.name + "]: " + (l2 - l) + " ms");
            while (resultSet.next()) {
                JSDOGeometry jSDOGeometry = this.loadGeometry(resultSet, proj, false, visContext, false);
                if (jSDOGeometry == null) continue;
                int n3 = resultSet.getInt(2);
                StyledFeatureI styledFeatureI = this.getNewStyledFeatureInstance();
                styledFeatureI.setID(String.valueOf(n3));
                styledFeatureI.setGeometry(jSDOGeometry);
                styledFeatureI.setFeatureStyleName(this.def.getNodeStyle());
                styledFeatureI.setDataSource(this.def.getDataSourceName());
                if (this.def.getNodeLabelStyle() != null) {
                    styledFeatureI.setLabel(String.valueOf(n3));
                    styledFeatureI.setLabelStyleName(this.def.getNodeLabelStyle());
                }
                arrayList.add(styledFeatureI);
                if (++n2 % 20 != 0) continue;
                Thread.currentThread();
                Thread.yield();
            }
            Object var28_22 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                break block17;
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            break block17;
            {
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                    throw new DataException(exception);
                }
            }
            catch (Throwable throwable) {
                Object var28_23 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                throw throwable;
            }
        }
        return n2;
    }

    /*
     * Loose catch block
     */
    private int processTopologyFaceQuery(Connection connection, boolean bl, double d, double d2, double d3, double d4, ArrayList arrayList, Proj proj, boolean bl2, int n, VisContext visContext) throws DataException {
        int n2;
        block50: {
            PreparedStatement preparedStatement;
            ResultSet resultSet;
            block48: {
                Cloneable cloneable;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                boolean bl3;
                ResultSetMetaData resultSetMetaData;
                block45: {
                    n2 = n;
                    String string = this.def.getTopoGeometryColumn();
                    if (this.def.getTopoView() != null && this.def.getTopoViewColumn() != null) {
                        string = this.def.getTopoViewColumn();
                    }
                    String string2 = this.def.getLabelColumn();
                    resultSet = null;
                    preparedStatement = null;
                    String string3 = this.rewriteTopologyFaceQuery(bl, d, d2, d3, d4, bl2);
                    if (string3 == null) {
                        log.warning("Topology face query is null.");
                        return n2;
                    }
                    log.finest("Topology Face query [" + this.def.name + "]:\n" + string3);
                    preparedStatement = connection.prepareStatement(string3);
                    preparedStatement.setFetchSize(this.owner.getFetchSize());
                    log.finer("Fetch size: " + preparedStatement.getFetchSize());
                    resultSet = preparedStatement.executeQuery();
                    log.finer("Topology Face query executed.");
                    resultSetMetaData = resultSet.getMetaData();
                    bl3 = false;
                    n7 = 0;
                    n6 = 0;
                    n5 = resultSetMetaData.getColumnCount();
                    int[] nArray = null;
                    Field[] fieldArray = this.def.getIdentifiableColumns();
                    if (fieldArray != null) {
                        nArray = new int[fieldArray.length];
                    }
                    boolean bl4 = false;
                    for (n4 = 0; n4 < n5; ++n4) {
                        if (fieldArray != null) {
                            for (n3 = 0; n3 < fieldArray.length; ++n3) {
                                if (!resultSetMetaData.getColumnName(n4 + 1).equalsIgnoreCase(fieldArray[n3].getName())) continue;
                                nArray[n3] = n4 + 1;
                                break;
                            }
                        }
                        if (string != null && string.length() > 0 && !string.equals("null") && resultSetMetaData.getColumnName(n4 + 1).equalsIgnoreCase(string)) {
                            n7 = n4 + 1;
                            log.finest("Found  Topo Column=" + string + " at column " + n7);
                        }
                        if (this.def.getLabelColumn() == null || !resultSetMetaData.getColumnName(n4 + 1).equalsIgnoreCase(this.def.getLabelColumn())) continue;
                        n6 = n4 + 1;
                        log.finest("Found Label Column=" + this.def.getLabelColumn() + " at column " + n6);
                    }
                    if (nArray != null) {
                        for (n4 = 0; n4 < nArray.length; ++n4) {
                            if (nArray[n4] <= 0) continue;
                            if (n6 == nArray[n4]) {
                                nArray[n4] = -1;
                                continue;
                            }
                            if (n7 > 0 && nArray[n4] > n7) {
                                int n8 = n4;
                                nArray[n8] = nArray[n8] - 1;
                            }
                            if (n6 > 0 && nArray[n4] > n6) {
                                int n9 = n4;
                                nArray[n9] = nArray[n9] - 1;
                            }
                            int n10 = n4;
                            nArray[n10] = nArray[n10] - 1;
                        }
                    }
                    if (n7 != 0) break block45;
                    log.severe(RSBundle.getMsg("MAPVIEWER-01045") + " [" + this.def.getName() + "].");
                    n4 = n2;
                    Object var50_29 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        log.warning(exception.getMessage());
                    }
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (Exception exception) {
                        log.warning(exception.getMessage());
                    }
                    return n4;
                }
                if (n5 > 14 || n6 == 0 && n5 > 13) {
                    bl3 = true;
                }
                n4 = 0;
                n3 = 0;
                long l = 0L;
                long l2 = 0L;
                String string = null;
                Vector vector = null;
                TopoFace topoFace = null;
                TopoFeature topoFeature = null;
                while (resultSet.next()) {
                    double[] dArray;
                    n3 = resultSet.getInt(11);
                    l = resultSet.getLong(12);
                    if (n3 != n4 && n4 != 0) {
                        topoFeature.addFace(topoFace);
                        topoFace = new TopoFace(n3);
                    } else if (topoFace == null) {
                        topoFace = new TopoFace(n3);
                    }
                    if (l != l2 && l2 != 0L) {
                        cloneable = topoFeature.getFeaturePolygons();
                        this.createStyledFeatures((Vector)cloneable, this.def.getRenderStyle(), string, this.def.getLabelStyle(), vector, arrayList, n2);
                        topoFeature = new TopoFeature(l, 3);
                        vector = null;
                        string = null;
                    } else if (topoFeature == null) {
                        topoFeature = new TopoFeature(l, 3);
                    }
                    cloneable = this.loadGeometry(resultSet, proj, true, visContext, false);
                    if (cloneable == null) continue;
                    int n11 = resultSet.getInt(2);
                    int n12 = resultSet.getInt(3);
                    int n13 = resultSet.getInt(4);
                    int n14 = resultSet.getInt(5);
                    int n15 = resultSet.getInt(6);
                    int n16 = resultSet.getInt(7);
                    int n17 = resultSet.getInt(8);
                    if (n6 > 0 && string == null) {
                        string = resultSet.getString(n6);
                    }
                    if (bl3 && vector == null) {
                        vector = this.getAttributes(resultSetMetaData, resultSet, n7, n6, n5);
                    }
                    if (n12 == n13 && (n11 == Math.abs(n14) || n11 == Math.abs(n15) || Math.abs(n14) == Math.abs(n15))) {
                        dArray = cloneable.getOrdinatesArray();
                        cloneable = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])dArray, (int)2, (int)this.def.getSrid()));
                        topoFace.addFacePolygon(n11, n15, n14, (JSDOGeometry)cloneable);
                    } else if (n12 == n13 && n11 != Math.abs(n14) && n11 != Math.abs(n15) && Math.abs(n14) != Math.abs(n15)) {
                        dArray = cloneable.getOrdinatesArray();
                        cloneable = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])dArray, (int)2, (int)this.def.getSrid()));
                        topoFace.addFaceOffsetPolygon(n11, n15, n14, (JSDOGeometry)cloneable);
                    } else {
                        topoFace.addEdge(n11, n12, n13, n16, n17, (JSDOGeometry)cloneable);
                        topoFace.addNextEdge(n11, n14);
                    }
                    n4 = n3;
                    l2 = l;
                }
                if (topoFeature == null) break block48;
                topoFeature.addFace(topoFace);
                cloneable = topoFeature.getFeaturePolygons();
                this.createStyledFeatures((Vector)cloneable, this.def.getRenderStyle(), string, this.def.getLabelStyle(), vector, arrayList, n2);
            }
            Object var50_30 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                break block50;
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            break block50;
            {
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                    throw new DataException(exception);
                }
            }
            catch (Throwable throwable) {
                Object var50_31 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                throw throwable;
            }
        }
        return n2;
    }

    /*
     * Loose catch block
     */
    private int processTopologyFaceQueryV2(Connection connection, boolean bl, double d, double d2, double d3, double d4, ArrayList arrayList, Proj proj, boolean bl2, int n, VisContext visContext) throws DataException {
        int n2;
        block50: {
            PreparedStatement preparedStatement;
            ResultSet resultSet;
            block48: {
                Cloneable cloneable;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                boolean bl3;
                ResultSetMetaData resultSetMetaData;
                block45: {
                    n2 = n;
                    String string = this.def.getTopoGeometryColumn();
                    if (this.def.getTopoView() != null && this.def.getTopoViewColumn() != null) {
                        string = this.def.getTopoViewColumn();
                    }
                    String string2 = this.def.getLabelColumn();
                    resultSet = null;
                    preparedStatement = null;
                    String string3 = this.getIndexTableName(connection);
                    String string4 = this.rewriteTopologyFaceQueryV2(bl, d, d2, d3, d4, bl2, string3);
                    if (string4 == null) {
                        log.warning("Topology face query is null.");
                        return n2;
                    }
                    log.finest("Topology Face query [" + this.def.name + "]:\n" + string4);
                    preparedStatement = connection.prepareStatement(string4);
                    preparedStatement.setFetchSize(this.owner.getFetchSize());
                    log.finer("Fetch size: " + preparedStatement.getFetchSize());
                    long l = System.currentTimeMillis();
                    resultSet = preparedStatement.executeQuery();
                    long l2 = System.currentTimeMillis();
                    log.info("Topology Face query executed [" + this.def.name + "]: " + (l2 - l) + " ms");
                    resultSetMetaData = resultSet.getMetaData();
                    bl3 = false;
                    n7 = 0;
                    n6 = 0;
                    n5 = resultSetMetaData.getColumnCount();
                    int[] nArray = null;
                    Field[] fieldArray = this.def.getIdentifiableColumns();
                    if (fieldArray != null) {
                        nArray = new int[fieldArray.length];
                    }
                    boolean bl4 = false;
                    for (n4 = 0; n4 < n5; ++n4) {
                        if (fieldArray != null) {
                            for (n3 = 0; n3 < fieldArray.length; ++n3) {
                                if (!resultSetMetaData.getColumnName(n4 + 1).equalsIgnoreCase(fieldArray[n3].getName())) continue;
                                nArray[n3] = n4 + 1;
                                break;
                            }
                        }
                        if (string != null && string.length() > 0 && !string.equals("null") && resultSetMetaData.getColumnName(n4 + 1).equalsIgnoreCase(string)) {
                            n7 = n4 + 1;
                            log.finest("Found  Topo Column=" + string + " at column " + n7);
                        }
                        if (this.def.getLabelColumn() == null || !resultSetMetaData.getColumnName(n4 + 1).equalsIgnoreCase(this.def.getLabelColumn())) continue;
                        n6 = n4 + 1;
                        log.finest("Found Label Column=" + this.def.getLabelColumn() + " at column " + n6);
                    }
                    if (nArray != null) {
                        for (n4 = 0; n4 < nArray.length; ++n4) {
                            if (nArray[n4] <= 0) continue;
                            if (n6 == nArray[n4]) {
                                nArray[n4] = -1;
                                continue;
                            }
                            if (n7 > 0 && nArray[n4] > n7) {
                                int n8 = n4;
                                nArray[n8] = nArray[n8] - 1;
                            }
                            if (n6 > 0 && nArray[n4] > n6) {
                                int n9 = n4;
                                nArray[n9] = nArray[n9] - 1;
                            }
                            int n10 = n4;
                            nArray[n10] = nArray[n10] - 1;
                        }
                    }
                    if (n7 != 0) break block45;
                    log.severe(RSBundle.getMsg("MAPVIEWER-01045") + " [" + this.def.getName() + "].");
                    n4 = n2;
                    Object var55_32 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        log.warning(exception.getMessage());
                    }
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (Exception exception) {
                        log.warning(exception.getMessage());
                    }
                    return n4;
                }
                if (n5 > 16 || n6 == 0 && n5 > 15) {
                    bl3 = true;
                }
                n4 = 0;
                n3 = 0;
                long l = 0L;
                long l3 = 0L;
                String string = null;
                Vector vector = null;
                TopoFace topoFace = null;
                TopoFeature topoFeature = null;
                while (resultSet.next()) {
                    double[] dArray;
                    n3 = resultSet.getInt(11);
                    l = resultSet.getLong(14);
                    if (n3 != n4 && n4 != 0) {
                        topoFeature.addFace(topoFace);
                        topoFace = new TopoFace(n3);
                    } else if (topoFace == null) {
                        topoFace = new TopoFace(n3);
                    }
                    if (l != l3 && l3 != 0L) {
                        cloneable = topoFeature.getFeaturePolygons();
                        this.createStyledFeatures((Vector)cloneable, this.def.getRenderStyle(), string, this.def.getLabelStyle(), vector, arrayList, n2);
                        topoFeature = new TopoFeature(l, 3);
                        vector = null;
                        string = null;
                    } else if (topoFeature == null) {
                        topoFeature = new TopoFeature(l, 3);
                    }
                    cloneable = this.loadGeometry(resultSet, proj, true, visContext, false);
                    if (cloneable == null) continue;
                    int n11 = resultSet.getInt(2);
                    int n12 = resultSet.getInt(3);
                    int n13 = resultSet.getInt(4);
                    int n14 = resultSet.getInt(5);
                    int n15 = resultSet.getInt(6);
                    int n16 = resultSet.getInt(7);
                    int n17 = resultSet.getInt(8);
                    if (n6 > 0 && string == null) {
                        string = resultSet.getString(n6);
                    }
                    if (bl3 && vector == null) {
                        vector = this.getAttributes(resultSetMetaData, resultSet, n7, n6, n5);
                    }
                    if (n12 == n13 && (n11 == Math.abs(n14) || n11 == Math.abs(n15) || Math.abs(n14) == Math.abs(n15))) {
                        dArray = cloneable.getOrdinatesArray();
                        cloneable = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])dArray, (int)2, (int)this.def.getSrid()));
                        topoFace.addFacePolygon(n11, n15, n14, (JSDOGeometry)cloneable);
                    } else if (n12 == n13 && n11 != Math.abs(n14) && n11 != Math.abs(n15) && Math.abs(n14) != Math.abs(n15)) {
                        dArray = cloneable.getOrdinatesArray();
                        cloneable = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])dArray, (int)2, (int)this.def.getSrid()));
                        topoFace.addFaceOffsetPolygon(n11, n15, n14, (JSDOGeometry)cloneable);
                    } else {
                        topoFace.addEdge(n11, n12, n13, n16, n17, (JSDOGeometry)cloneable);
                        topoFace.addNextEdge(n11, n14);
                    }
                    n4 = n3;
                    l3 = l;
                }
                if (topoFeature == null) break block48;
                topoFeature.addFace(topoFace);
                cloneable = topoFeature.getFeaturePolygons();
                this.createStyledFeatures((Vector)cloneable, this.def.getRenderStyle(), string, this.def.getLabelStyle(), vector, arrayList, n2);
            }
            Object var55_33 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                break block50;
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            break block50;
            {
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                    throw new DataException(exception);
                }
            }
            catch (Throwable throwable) {
                Object var55_34 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                throw throwable;
            }
        }
        return n2;
    }

    /*
     * Loose catch block
     */
    private int processTopologyEdgeQuery(Connection connection, boolean bl, double d, double d2, double d3, double d4, ArrayList arrayList, Proj proj, boolean bl2, int n, VisContext visContext) throws DataException {
        int n2;
        block45: {
            PreparedStatement preparedStatement;
            ResultSet resultSet;
            block43: {
                int n3;
                int n4;
                int n5;
                boolean bl3;
                ResultSetMetaData resultSetMetaData;
                block40: {
                    int n6;
                    n2 = n;
                    resultSet = null;
                    preparedStatement = null;
                    String string = this.def.getTopoGeometryColumn();
                    if (this.def.getTopoView() != null && this.def.getTopoViewColumn() != null) {
                        string = this.def.getTopoViewColumn();
                    }
                    String string2 = this.def.getLabelColumn();
                    String string3 = null;
                    string3 = this.rewriteTopologyEdgeQuery(connection, bl, d, d2, d3, d4, bl2);
                    if (string3 == null) {
                        log.warning("Topology Edge query is null.");
                        return n2;
                    }
                    log.finest("[Topology Edge query]:  " + string3);
                    preparedStatement = connection.prepareStatement(string3);
                    preparedStatement.setFetchSize(this.owner.getFetchSize());
                    log.finer("Fetch size: " + preparedStatement.getFetchSize());
                    resultSet = preparedStatement.executeQuery();
                    log.finer("Topology Edge query executed.");
                    resultSetMetaData = resultSet.getMetaData();
                    bl3 = false;
                    n5 = 0;
                    n4 = 0;
                    n3 = resultSetMetaData.getColumnCount();
                    int[] nArray = null;
                    Field[] fieldArray = this.def.getIdentifiableColumns();
                    if (fieldArray != null) {
                        nArray = new int[fieldArray.length];
                    }
                    boolean bl4 = false;
                    for (n6 = 0; n6 < n3; ++n6) {
                        if (fieldArray != null) {
                            for (int i = 0; i < fieldArray.length; ++i) {
                                if (!resultSetMetaData.getColumnName(n6 + 1).equalsIgnoreCase(fieldArray[i].getName())) continue;
                                nArray[i] = n6 + 1;
                                break;
                            }
                        }
                        if (string != null && string.length() > 0 && !string.equals("null") && resultSetMetaData.getColumnName(n6 + 1).equalsIgnoreCase(string)) {
                            n5 = n6 + 1;
                            log.finest("Found  Topo Column=" + string);
                        }
                        if (this.def.getLabelColumn() == null || !resultSetMetaData.getColumnName(n6 + 1).equalsIgnoreCase(this.def.getLabelColumn())) continue;
                        n4 = n6 + 1;
                    }
                    if (nArray != null) {
                        for (n6 = 0; n6 < nArray.length; ++n6) {
                            if (nArray[n6] <= 0) continue;
                            if (n4 == nArray[n6]) {
                                nArray[n6] = -1;
                                continue;
                            }
                            if (n5 > 0 && nArray[n6] > n5) {
                                int n7 = n6;
                                nArray[n7] = nArray[n7] - 1;
                            }
                            if (n4 > 0 && nArray[n6] > n4) {
                                int n8 = n6;
                                nArray[n8] = nArray[n8] - 1;
                            }
                            int n9 = n6;
                            nArray[n9] = nArray[n9] - 1;
                        }
                    }
                    if (n5 != 0) break block40;
                    log.severe(RSBundle.getMsg("MAPVIEWER-01045") + " [" + this.def.getName() + "].");
                    n6 = n2;
                    Object var45_30 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        log.warning(exception.getMessage());
                    }
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (Exception exception) {
                        log.warning(exception.getMessage());
                    }
                    return n6;
                }
                if (n3 > 8 || n4 == 0 && n3 > 7) {
                    bl3 = true;
                }
                long l = 0L;
                String string = null;
                Vector vector = null;
                TopoFeature topoFeature = null;
                while (resultSet.next()) {
                    Cloneable cloneable;
                    int n10 = resultSet.getInt(2);
                    int n11 = resultSet.getInt(3);
                    int n12 = resultSet.getInt(4);
                    long l2 = resultSet.getLong(5);
                    if (l != 0L && l2 != l) {
                        cloneable = topoFeature.getFeatureLines();
                        this.createStyledFeatures((Vector)cloneable, this.def.getRenderStyle(), string, this.def.getLabelStyle(), vector, arrayList, n2);
                        topoFeature = null;
                        string = null;
                        vector = null;
                    }
                    if ((cloneable = this.loadGeometry(resultSet, proj, true, visContext, false)) == null) continue;
                    if (n4 > 0 && string == null) {
                        string = resultSet.getString(n4);
                    }
                    if (bl3 && vector == null) {
                        vector = this.getAttributes(resultSetMetaData, resultSet, n5, n4, n3);
                    }
                    if (topoFeature == null) {
                        topoFeature = new TopoFeature(l2, 2);
                    }
                    TopoEdge topoEdge = new TopoEdge(n10);
                    topoEdge.setNodes(n11, n12);
                    topoEdge.setGeometry((JSDOGeometry)cloneable);
                    topoFeature.addEdge(topoEdge);
                    TopoNode topoNode = topoFeature.getNode(n11);
                    if (topoNode == null) {
                        topoNode = new TopoNode(n11);
                        topoFeature.addNode(topoNode);
                    }
                    topoNode.addEdge(n10);
                    TopoNode topoNode2 = topoFeature.getNode(n12);
                    if (topoNode2 == null) {
                        topoNode2 = new TopoNode(n12);
                        topoFeature.addNode(topoNode2);
                    }
                    if (n11 != n12) {
                        topoNode2.addEdge(n10);
                    }
                    l = l2;
                }
                if (topoFeature == null) break block43;
                Vector vector2 = topoFeature.getFeatureLines();
                this.createStyledFeatures(vector2, this.def.getRenderStyle(), string, this.def.getLabelStyle(), vector, arrayList, n2);
            }
            Object var45_31 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                break block45;
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            break block45;
            {
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                    throw new DataException(exception);
                }
            }
            catch (Throwable throwable) {
                Object var45_32 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                throw throwable;
            }
        }
        return n2;
    }

    /*
     * Loose catch block
     */
    private int processTopologyEdgeQueryV2(Connection connection, boolean bl, double d, double d2, double d3, double d4, ArrayList arrayList, Proj proj, boolean bl2, int n, VisContext visContext) throws DataException {
        int n2;
        block45: {
            PreparedStatement preparedStatement;
            ResultSet resultSet;
            block43: {
                int n3;
                int n4;
                int n5;
                boolean bl3;
                ResultSetMetaData resultSetMetaData;
                block40: {
                    int n6;
                    n2 = n;
                    resultSet = null;
                    preparedStatement = null;
                    String string = this.def.getTopoGeometryColumn();
                    if (this.def.getTopoView() != null && this.def.getTopoViewColumn() != null) {
                        string = this.def.getTopoViewColumn();
                    }
                    String string2 = this.def.getLabelColumn();
                    String string3 = null;
                    String string4 = this.getIndexTableName(connection);
                    string3 = this.rewriteTopologyEdgeQueryV2(connection, bl, d, d2, d3, d4, bl2, string4);
                    if (string3 == null) {
                        log.warning("Topology Edge query is null.");
                        return n2;
                    }
                    log.finest("Topology Edge query [" + this.def.name + "]:\n" + string3);
                    preparedStatement = connection.prepareStatement(string3);
                    preparedStatement.setFetchSize(this.owner.getFetchSize());
                    log.finer("Fetch size: " + preparedStatement.getFetchSize());
                    long l = System.currentTimeMillis();
                    resultSet = preparedStatement.executeQuery();
                    long l2 = System.currentTimeMillis();
                    log.info("Topology Edge query executed [" + this.def.name + "]: " + (l2 - l) + " ms");
                    resultSetMetaData = resultSet.getMetaData();
                    bl3 = false;
                    n5 = 0;
                    n4 = 0;
                    n3 = resultSetMetaData.getColumnCount();
                    int[] nArray = null;
                    Field[] fieldArray = this.def.getIdentifiableColumns();
                    if (fieldArray != null) {
                        nArray = new int[fieldArray.length];
                    }
                    boolean bl4 = false;
                    for (n6 = 0; n6 < n3; ++n6) {
                        if (fieldArray != null) {
                            for (int i = 0; i < fieldArray.length; ++i) {
                                if (!resultSetMetaData.getColumnName(n6 + 1).equalsIgnoreCase(fieldArray[i].getName())) continue;
                                nArray[i] = n6 + 1;
                                break;
                            }
                        }
                        if (string != null && string.length() > 0 && !string.equals("null") && resultSetMetaData.getColumnName(n6 + 1).equalsIgnoreCase(string)) {
                            n5 = n6 + 1;
                            log.finest("Found  Topo Column=" + string);
                        }
                        if (this.def.getLabelColumn() == null || !resultSetMetaData.getColumnName(n6 + 1).equalsIgnoreCase(this.def.getLabelColumn())) continue;
                        n4 = n6 + 1;
                    }
                    if (nArray != null) {
                        for (n6 = 0; n6 < nArray.length; ++n6) {
                            if (nArray[n6] <= 0) continue;
                            if (n4 == nArray[n6]) {
                                nArray[n6] = -1;
                                continue;
                            }
                            if (n5 > 0 && nArray[n6] > n5) {
                                int n7 = n6;
                                nArray[n7] = nArray[n7] - 1;
                            }
                            if (n4 > 0 && nArray[n6] > n4) {
                                int n8 = n6;
                                nArray[n8] = nArray[n8] - 1;
                            }
                            int n9 = n6;
                            nArray[n9] = nArray[n9] - 1;
                        }
                    }
                    if (n5 != 0) break block40;
                    log.severe(RSBundle.getMsg("MAPVIEWER-01045") + " [" + this.def.getName() + "].");
                    n6 = n2;
                    Object var50_33 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        log.warning(exception.getMessage());
                    }
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (Exception exception) {
                        log.warning(exception.getMessage());
                    }
                    return n6;
                }
                if (n3 > 8 || n4 == 0 && n3 > 7) {
                    bl3 = true;
                }
                long l = 0L;
                String string = null;
                Vector vector = null;
                TopoFeature topoFeature = null;
                while (resultSet.next()) {
                    Cloneable cloneable;
                    int n10 = resultSet.getInt(2);
                    int n11 = resultSet.getInt(3);
                    int n12 = resultSet.getInt(4);
                    long l3 = resultSet.getLong(6);
                    if (l != 0L && l3 != l) {
                        cloneable = topoFeature.getFeatureLines();
                        this.createStyledFeatures((Vector)cloneable, this.def.getRenderStyle(), string, this.def.getLabelStyle(), vector, arrayList, n2);
                        topoFeature = null;
                        string = null;
                        vector = null;
                    }
                    if ((cloneable = this.loadGeometry(resultSet, proj, true, visContext, false)) == null) continue;
                    if (n4 > 0 && string == null) {
                        string = resultSet.getString(n4);
                    }
                    if (bl3 && vector == null) {
                        vector = this.getAttributes(resultSetMetaData, resultSet, n5, n4, n3);
                    }
                    if (topoFeature == null) {
                        topoFeature = new TopoFeature(l3, 2);
                    }
                    TopoEdge topoEdge = new TopoEdge(n10);
                    topoEdge.setNodes(n11, n12);
                    topoEdge.setGeometry((JSDOGeometry)cloneable);
                    topoFeature.addEdge(topoEdge);
                    TopoNode topoNode = topoFeature.getNode(n11);
                    if (topoNode == null) {
                        topoNode = new TopoNode(n11);
                        topoFeature.addNode(topoNode);
                    }
                    topoNode.addEdge(n10);
                    TopoNode topoNode2 = topoFeature.getNode(n12);
                    if (topoNode2 == null) {
                        topoNode2 = new TopoNode(n12);
                        topoFeature.addNode(topoNode2);
                    }
                    if (n11 != n12) {
                        topoNode2.addEdge(n10);
                    }
                    l = l3;
                }
                if (topoFeature == null) break block43;
                Vector vector2 = topoFeature.getFeatureLines();
                this.createStyledFeatures(vector2, this.def.getRenderStyle(), string, this.def.getLabelStyle(), vector, arrayList, n2);
            }
            Object var50_34 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                break block45;
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            break block45;
            {
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                    throw new DataException(exception);
                }
            }
            catch (Throwable throwable) {
                Object var50_35 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                throw throwable;
            }
        }
        return n2;
    }

    /*
     * Loose catch block
     */
    private int processTopologyNodeQuery(Connection connection, boolean bl, double d, double d2, double d3, double d4, ArrayList arrayList, Proj proj, boolean bl2, int n, VisContext visContext) throws DataException {
        int n2;
        block41: {
            int n3;
            int n4;
            int n5;
            boolean bl3;
            ResultSetMetaData resultSetMetaData;
            PreparedStatement preparedStatement;
            ResultSet resultSet;
            block37: {
                int n6;
                n2 = n;
                resultSet = null;
                preparedStatement = null;
                String string = this.def.getTopoGeometryColumn();
                if (this.def.getTopoView() != null && this.def.getTopoViewColumn() != null) {
                    string = this.def.getTopoViewColumn();
                }
                String string2 = this.def.getLabelColumn();
                String string3 = null;
                string3 = this.rewriteTopologyPointQuery(connection, bl, d, d2, d3, d4, bl2);
                if (string3 == null) {
                    log.warning("Topology point query is null.");
                    return n2;
                }
                log.info("[Topology point query]:  " + string3);
                preparedStatement = connection.prepareStatement(string3);
                preparedStatement.setFetchSize(this.owner.getFetchSize());
                log.finer("Fetch size: " + preparedStatement.getFetchSize());
                resultSet = preparedStatement.executeQuery();
                log.finer("Topology Node query executed.");
                resultSetMetaData = resultSet.getMetaData();
                bl3 = false;
                n5 = 0;
                n4 = 0;
                n3 = resultSetMetaData.getColumnCount();
                int[] nArray = null;
                Field[] fieldArray = this.def.getIdentifiableColumns();
                if (fieldArray != null) {
                    nArray = new int[fieldArray.length];
                }
                boolean bl4 = false;
                for (n6 = 0; n6 < n3; ++n6) {
                    if (fieldArray != null) {
                        for (int i = 0; i < fieldArray.length; ++i) {
                            if (!resultSetMetaData.getColumnName(n6 + 1).equalsIgnoreCase(fieldArray[i].getName())) continue;
                            nArray[i] = n6 + 1;
                            break;
                        }
                    }
                    if (string != null && string.length() > 0 && !string.equals("null") && resultSetMetaData.getColumnName(n6 + 1).equalsIgnoreCase(string)) {
                        n5 = n6 + 1;
                        log.finest("Found  Topo Column=" + string);
                    }
                    if (this.def.getLabelColumn() == null || !resultSetMetaData.getColumnName(n6 + 1).equalsIgnoreCase(this.def.getLabelColumn())) continue;
                    n4 = n6 + 1;
                }
                if (nArray != null) {
                    for (n6 = 0; n6 < nArray.length; ++n6) {
                        if (nArray[n6] <= 0) continue;
                        if (n4 == nArray[n6]) {
                            nArray[n6] = -1;
                            continue;
                        }
                        if (n5 > 0 && nArray[n6] > n5) {
                            int n7 = n6;
                            nArray[n7] = nArray[n7] - 1;
                        }
                        if (n4 > 0 && nArray[n6] > n4) {
                            int n8 = n6;
                            nArray[n8] = nArray[n8] - 1;
                        }
                        int n9 = n6;
                        nArray[n9] = nArray[n9] - 1;
                    }
                }
                if (n5 != 0) break block37;
                log.severe(RSBundle.getMsg("MAPVIEWER-01045") + " [" + this.def.getName() + "].");
                n6 = n2;
                Object var34_32 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                return n6;
            }
            if (n3 > 8 || n4 == 0 && n3 > 7) {
                bl3 = true;
            }
            while (resultSet.next()) {
                JSDOGeometry jSDOGeometry = this.loadGeometry(resultSet, proj, true, visContext, false);
                if (jSDOGeometry == null) continue;
                StyledFeatureI styledFeatureI = this.getNewStyledFeatureInstance();
                styledFeatureI.setGeometry(jSDOGeometry);
                if (this.def.getRenderingRules() != null && this.def.getRenderingRules().length > 0) {
                    styledFeatureI.setFeatureStyleName(this.def.getRenderingRules()[0].getStyleName());
                } else {
                    styledFeatureI.setFeatureStyleName(this.def.getRenderStyle());
                }
                if (n4 > 0) {
                    styledFeatureI.setLabel(resultSet.getString(n4));
                }
                styledFeatureI.setLabelStyleName(this.def.getLabelStyle());
                if (bl3) {
                    Vector vector = this.getAttributes(resultSetMetaData, resultSet, n5, n4, n3);
                    this.fillAttributes(styledFeatureI, vector);
                }
                styledFeatureI.setDataSource(this.def.getDataSourceName());
                styledFeatureI.setRenderingRules(this.def.getRenderingRules());
                arrayList.add(styledFeatureI);
                if (++n2 % 20 != 0) continue;
                Thread.currentThread();
                Thread.yield();
            }
            Object var34_33 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                break block41;
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            break block41;
            {
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                    throw new DataException(exception);
                }
            }
            catch (Throwable throwable) {
                Object var34_34 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                throw throwable;
            }
        }
        return n2;
    }

    /*
     * Loose catch block
     */
    private int processTopologyNodeQueryV2(Connection connection, boolean bl, double d, double d2, double d3, double d4, ArrayList arrayList, Proj proj, boolean bl2, int n, VisContext visContext) throws DataException {
        int n2;
        block41: {
            int n3;
            int n4;
            int n5;
            boolean bl3;
            ResultSetMetaData resultSetMetaData;
            PreparedStatement preparedStatement;
            ResultSet resultSet;
            block37: {
                int n6;
                n2 = n;
                resultSet = null;
                preparedStatement = null;
                String string = this.def.getTopoGeometryColumn();
                if (this.def.getTopoView() != null && this.def.getTopoViewColumn() != null) {
                    string = this.def.getTopoViewColumn();
                }
                String string2 = this.def.getLabelColumn();
                String string3 = null;
                String string4 = this.getIndexTableName(connection);
                string3 = this.rewriteTopologyPointQueryV2(connection, bl, d, d2, d3, d4, bl2, string4);
                if (string3 == null) {
                    log.warning("Topology point query is null.");
                    return n2;
                }
                log.finest("Topology point query [" + this.def.name + "]:\n" + string3);
                preparedStatement = connection.prepareStatement(string3);
                preparedStatement.setFetchSize(this.owner.getFetchSize());
                log.finer("Fetch size: " + preparedStatement.getFetchSize());
                long l = System.currentTimeMillis();
                resultSet = preparedStatement.executeQuery();
                long l2 = System.currentTimeMillis();
                log.info("Topology point query executed [" + this.def.name + "]: " + (l2 - l) + " ms");
                resultSetMetaData = resultSet.getMetaData();
                bl3 = false;
                n5 = 0;
                n4 = 0;
                n3 = resultSetMetaData.getColumnCount();
                int[] nArray = null;
                Field[] fieldArray = this.def.getIdentifiableColumns();
                if (fieldArray != null) {
                    nArray = new int[fieldArray.length];
                }
                boolean bl4 = false;
                for (n6 = 0; n6 < n3; ++n6) {
                    if (fieldArray != null) {
                        for (int i = 0; i < fieldArray.length; ++i) {
                            if (!resultSetMetaData.getColumnName(n6 + 1).equalsIgnoreCase(fieldArray[i].getName())) continue;
                            nArray[i] = n6 + 1;
                            break;
                        }
                    }
                    if (string != null && string.length() > 0 && !string.equals("null") && resultSetMetaData.getColumnName(n6 + 1).equalsIgnoreCase(string)) {
                        n5 = n6 + 1;
                        log.finest("Found  Topo Column=" + string);
                    }
                    if (this.def.getLabelColumn() == null || !resultSetMetaData.getColumnName(n6 + 1).equalsIgnoreCase(this.def.getLabelColumn())) continue;
                    n4 = n6 + 1;
                }
                if (nArray != null) {
                    for (n6 = 0; n6 < nArray.length; ++n6) {
                        if (nArray[n6] <= 0) continue;
                        if (n4 == nArray[n6]) {
                            nArray[n6] = -1;
                            continue;
                        }
                        if (n5 > 0 && nArray[n6] > n5) {
                            int n7 = n6;
                            nArray[n7] = nArray[n7] - 1;
                        }
                        if (n4 > 0 && nArray[n6] > n4) {
                            int n8 = n6;
                            nArray[n8] = nArray[n8] - 1;
                        }
                        int n9 = n6;
                        nArray[n9] = nArray[n9] - 1;
                    }
                }
                if (n5 != 0) break block37;
                log.severe(RSBundle.getMsg("MAPVIEWER-01045") + " [" + this.def.getName() + "].");
                n6 = n2;
                Object var39_35 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                return n6;
            }
            if (n3 > 8 || n4 == 0 && n3 > 7) {
                bl3 = true;
            }
            while (resultSet.next()) {
                JSDOGeometry jSDOGeometry = this.loadGeometry(resultSet, proj, true, visContext, false);
                if (jSDOGeometry == null) continue;
                StyledFeatureI styledFeatureI = this.getNewStyledFeatureInstance();
                styledFeatureI.setGeometry(jSDOGeometry);
                if (this.def.getRenderingRules() != null && this.def.getRenderingRules().length > 0) {
                    styledFeatureI.setFeatureStyleName(this.def.getRenderingRules()[0].getStyleName());
                } else {
                    styledFeatureI.setFeatureStyleName(this.def.getRenderStyle());
                }
                if (n4 > 0) {
                    styledFeatureI.setLabel(resultSet.getString(n4));
                }
                styledFeatureI.setLabelStyleName(this.def.getLabelStyle());
                if (bl3) {
                    Vector vector = this.getAttributes(resultSetMetaData, resultSet, n5, n4, n3);
                    this.fillAttributes(styledFeatureI, vector);
                }
                styledFeatureI.setDataSource(this.def.getDataSourceName());
                styledFeatureI.setRenderingRules(this.def.getRenderingRules());
                arrayList.add(styledFeatureI);
                if (++n2 % 20 != 0) continue;
                Thread.currentThread();
                Thread.yield();
            }
            Object var39_36 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                break block41;
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            break block41;
            {
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                    throw new DataException(exception);
                }
            }
            catch (Throwable throwable) {
                Object var39_37 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                throw throwable;
            }
        }
        return n2;
    }

    /*
     * Loose catch block
     */
    private int processPredefinedTopologyFaceQuery(Connection connection, boolean bl, double d, double d2, double d3, double d4, ArrayList arrayList, Proj proj, boolean bl2, int n, VisContext visContext) throws DataException {
        int n2;
        block33: {
            Statement statement;
            ResultSet resultSet;
            block31: {
                Cloneable cloneable;
                n2 = n;
                String string = this.def.getTopoGeometryColumn();
                String string2 = this.def.getLabelColumn();
                resultSet = null;
                statement = null;
                String string3 = this.rewriteTopologyFaceQuery(bl, d, d2, d3, d4, bl2);
                if (string3 == null) {
                    log.warning("Predefined Topology face query is null.");
                    return n2;
                }
                log.info("[Predefined Topology Face query]:  " + string3);
                String string4 = null;
                String string5 = null;
                String string6 = null;
                string6 = this.def.getCacheEdgeGroup();
                if (bl) {
                    string6 = this.def.getCacheEdgeGroupName(this.visSRID);
                }
                statement = connection.prepareStatement(string3);
                statement.setFetchSize(this.owner.getFetchSize());
                log.finer("Fetch size: " + statement.getFetchSize());
                resultSet = statement.executeQuery();
                log.finer("Topology Face query executed.");
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n3 = resultSetMetaData.getColumnCount();
                int n4 = 0;
                int n5 = 0;
                long l = 0L;
                long l2 = 0L;
                String string7 = null;
                String string8 = null;
                String string9 = null;
                Vector vector = null;
                TopoFace topoFace = null;
                TopoFeature topoFeature = null;
                while (resultSet.next()) {
                    double[] dArray;
                    n5 = resultSet.getInt(12);
                    l2 = resultSet.getLong(13);
                    if (n5 != n4 && n4 != 0) {
                        topoFeature.addFace(topoFace);
                        topoFace = new TopoFace(n5);
                    } else if (topoFace == null) {
                        topoFace = new TopoFace(n5);
                    }
                    if (l2 != l && l != 0L) {
                        cloneable = topoFeature.getFeaturePolygons();
                        this.createStyledFeatures((Vector)cloneable, this.def.getRenderStyle(), string7, string8, vector, arrayList, n2);
                        topoFeature = new TopoFeature(l2, 3);
                        vector = null;
                        string7 = null;
                        string8 = null;
                        string9 = null;
                    } else if (topoFeature == null) {
                        topoFeature = new TopoFeature(l2, 3);
                    }
                    cloneable = null;
                    string5 = string4 = resultSet.getString(1);
                    if (bl) {
                        string5 = string4 + this.visSRID;
                    }
                    if ((cloneable = this.loadPredefinedGeometry(resultSet, proj, string5, string6, true, visContext, false)) == null) continue;
                    int n6 = resultSet.getInt(3);
                    int n7 = resultSet.getInt(4);
                    int n8 = resultSet.getInt(5);
                    int n9 = resultSet.getInt(6);
                    int n10 = resultSet.getInt(7);
                    int n11 = resultSet.getInt(8);
                    int n12 = resultSet.getInt(9);
                    if (string9 == null) {
                        string9 = resultSet.getString(15);
                    }
                    if (resultSet.getFloat(19) > 0.0f && string7 == null) {
                        string7 = resultSet.getString(17);
                        string8 = resultSet.getString(18);
                    }
                    if (n3 > 19 && vector == null) {
                        vector = this.getAttributes(resultSetMetaData, resultSet, 18, 19, n3);
                    }
                    if (n7 == n8 && (n6 == Math.abs(n9) || n6 == Math.abs(n10) || Math.abs(n9) == Math.abs(n10))) {
                        dArray = cloneable.getOrdinatesArray();
                        cloneable = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])dArray, (int)2, (int)this.def.getSrid()));
                        topoFace.addFacePolygon(n6, n10, n9, (JSDOGeometry)cloneable);
                    } else if (n7 == n8 && n6 != Math.abs(n9) && n6 != Math.abs(n10) && Math.abs(n9) != Math.abs(n10)) {
                        dArray = cloneable.getOrdinatesArray();
                        cloneable = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])dArray, (int)2, (int)this.def.getSrid()));
                        topoFace.addFaceOffsetPolygon(n6, n10, n9, (JSDOGeometry)cloneable);
                    } else {
                        topoFace.addEdge(n6, n7, n8, n11, n12, (JSDOGeometry)cloneable);
                        topoFace.addNextEdge(n6, n9);
                    }
                    n4 = n5;
                    l = l2;
                }
                if (topoFeature == null) break block31;
                topoFeature.addFace(topoFace);
                cloneable = topoFeature.getFeaturePolygons();
                this.createStyledFeatures((Vector)cloneable, this.def.getRenderStyle(), string7, string8, vector, arrayList, n2);
            }
            Object var49_43 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            try {
                if (statement != null) {
                    statement.close();
                }
                break block33;
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            break block33;
            {
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                    throw new DataException(exception);
                }
            }
            catch (Throwable throwable) {
                Object var49_44 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                throw throwable;
            }
        }
        return n2;
    }

    /*
     * Loose catch block
     */
    private int processPredefinedTopologyFaceQueryV2(Connection connection, boolean bl, double d, double d2, double d3, double d4, ArrayList arrayList, Proj proj, boolean bl2, int n, VisContext visContext) throws DataException {
        int n2;
        block33: {
            Statement statement;
            ResultSet resultSet;
            block31: {
                Cloneable cloneable;
                n2 = n;
                String string = this.def.getTopoGeometryColumn();
                String string2 = this.def.getLabelColumn();
                resultSet = null;
                statement = null;
                String string3 = this.getIndexTableName(connection);
                String string4 = this.rewriteTopologyFaceQueryV2(bl, d, d2, d3, d4, bl2, string3);
                if (string4 == null) {
                    log.warning("Predefined Topology face query is null.");
                    return n2;
                }
                log.finest("Predefined Topology Face query [" + this.def.name + "]: \n" + string4);
                String string5 = null;
                String string6 = null;
                String string7 = null;
                string7 = this.def.getCacheEdgeGroup();
                if (bl) {
                    string7 = this.def.getCacheEdgeGroupName(this.visSRID);
                }
                statement = connection.prepareStatement(string4);
                statement.setFetchSize(this.owner.getFetchSize());
                log.finer("Fetch size: " + statement.getFetchSize());
                long l = System.currentTimeMillis();
                resultSet = statement.executeQuery();
                long l2 = System.currentTimeMillis();
                log.info("Predefined Topology Face query executed [" + this.def.name + "]: " + (l2 - l) + " ms");
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n3 = resultSetMetaData.getColumnCount();
                int n4 = 0;
                int n5 = 0;
                long l3 = 0L;
                long l4 = 0L;
                String string8 = null;
                String string9 = null;
                String string10 = null;
                Vector vector = null;
                TopoFace topoFace = null;
                TopoFeature topoFeature = null;
                while (resultSet.next()) {
                    double[] dArray;
                    n5 = resultSet.getInt(12);
                    l4 = resultSet.getLong(15);
                    if (n5 != n4 && n4 != 0) {
                        topoFeature.addFace(topoFace);
                        topoFace = new TopoFace(n5);
                    } else if (topoFace == null) {
                        topoFace = new TopoFace(n5);
                    }
                    if (l4 != l3 && l3 != 0L) {
                        cloneable = topoFeature.getFeaturePolygons();
                        this.createStyledFeatures((Vector)cloneable, this.def.getRenderStyle(), string8, string9, vector, arrayList, n2);
                        topoFeature = new TopoFeature(l4, 3);
                        vector = null;
                        string8 = null;
                        string9 = null;
                        string10 = null;
                    } else if (topoFeature == null) {
                        topoFeature = new TopoFeature(l4, 3);
                    }
                    cloneable = null;
                    string6 = string5 = resultSet.getString(1);
                    if (bl) {
                        string6 = string5 + this.visSRID;
                    }
                    if ((cloneable = this.loadPredefinedGeometry(resultSet, proj, string6, string7, true, visContext, false)) == null) continue;
                    int n6 = resultSet.getInt(3);
                    int n7 = resultSet.getInt(4);
                    int n8 = resultSet.getInt(5);
                    int n9 = resultSet.getInt(6);
                    int n10 = resultSet.getInt(7);
                    int n11 = resultSet.getInt(8);
                    int n12 = resultSet.getInt(9);
                    if (string10 == null) {
                        string10 = resultSet.getString(17);
                    }
                    if (resultSet.getFloat(20) > 0.0f && string8 == null) {
                        string8 = resultSet.getString(18);
                        string9 = resultSet.getString(19);
                    }
                    if (n3 > 20 && vector == null) {
                        vector = this.getAttributes(resultSetMetaData, resultSet, 19, 20, n3);
                    }
                    if (n7 == n8 && (n6 == Math.abs(n9) || n6 == Math.abs(n10) || Math.abs(n9) == Math.abs(n10))) {
                        dArray = cloneable.getOrdinatesArray();
                        cloneable = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])dArray, (int)2, (int)this.def.getSrid()));
                        topoFace.addFacePolygon(n6, n10, n9, (JSDOGeometry)cloneable);
                    } else if (n7 == n8 && n6 != Math.abs(n9) && n6 != Math.abs(n10) && Math.abs(n9) != Math.abs(n10)) {
                        dArray = cloneable.getOrdinatesArray();
                        cloneable = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])dArray, (int)2, (int)this.def.getSrid()));
                        topoFace.addFaceOffsetPolygon(n6, n10, n9, (JSDOGeometry)cloneable);
                    } else {
                        topoFace.addEdge(n6, n7, n8, n11, n12, (JSDOGeometry)cloneable);
                        topoFace.addNextEdge(n6, n9);
                    }
                    n4 = n5;
                    l3 = l4;
                }
                if (topoFeature == null) break block31;
                topoFeature.addFace(topoFace);
                cloneable = topoFeature.getFeaturePolygons();
                this.createStyledFeatures((Vector)cloneable, this.def.getRenderStyle(), string8, string9, vector, arrayList, n2);
            }
            Object var54_46 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            try {
                if (statement != null) {
                    statement.close();
                }
                break block33;
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            break block33;
            {
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                    throw new DataException(exception);
                }
            }
            catch (Throwable throwable) {
                Object var54_47 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                throw throwable;
            }
        }
        return n2;
    }

    private void printResultsetColumns(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        try {
            System.out.println("Result set columns:");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                String string = resultSetMetaData.getColumnName(i);
                System.out.println("" + i + " : " + string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Loose catch block
     */
    private int processPredefinedTopologyEdgeQuery(Connection connection, boolean bl, double d, double d2, double d3, double d4, ArrayList arrayList, Proj proj, boolean bl2, int n, VisContext visContext) throws DataException {
        int n2;
        block28: {
            Statement statement;
            ResultSet resultSet;
            block26: {
                n2 = n;
                resultSet = null;
                statement = null;
                String string = this.def.getTopoGeometryColumn();
                String string2 = this.def.getLabelColumn();
                String string3 = null;
                string3 = this.rewriteTopologyEdgeQuery(connection, bl, d, d2, d3, d4, bl2);
                if (string3 == null) {
                    log.warning("Predefine Topology Edge query is null.");
                    return n2;
                }
                log.info("[Predefined Topology Edge query]:  " + string3);
                String string4 = null;
                String string5 = null;
                String string6 = null;
                string6 = this.def.getCacheEdgeGroup();
                if (bl) {
                    string6 = this.def.getCacheEdgeGroupName(this.visSRID);
                }
                statement = connection.prepareStatement(string3);
                statement.setFetchSize(this.owner.getFetchSize());
                log.finer("Fetch size: " + statement.getFetchSize());
                resultSet = statement.executeQuery();
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n3 = resultSetMetaData.getColumnCount();
                long l = 0L;
                String string7 = null;
                String string8 = null;
                String string9 = null;
                Vector vector = null;
                TopoFeature topoFeature = null;
                while (resultSet.next()) {
                    Cloneable cloneable;
                    long l2 = resultSet.getLong(6);
                    if (l2 != l && l != 0L) {
                        cloneable = topoFeature.getFeatureLines();
                        this.createStyledFeatures((Vector)cloneable, string9, string7, string8, vector, arrayList, n2);
                        topoFeature = null;
                        vector = null;
                        string7 = null;
                        string8 = null;
                        string9 = null;
                    }
                    cloneable = null;
                    string5 = string4 = resultSet.getString(1);
                    if (bl) {
                        string5 = string4 + this.visSRID;
                    }
                    if ((cloneable = this.loadPredefinedGeometry(resultSet, proj, string5, string6, true, visContext, false)) == null) continue;
                    if (string9 == null) {
                        string9 = resultSet.getString(9);
                    }
                    if (resultSet.getFloat(12) > 0.0f && string7 == null) {
                        string7 = resultSet.getString(10);
                        string8 = resultSet.getString(11);
                    }
                    if (n3 > 12 && vector == null) {
                        vector = this.getAttributes(resultSetMetaData, resultSet, 12, 13, n3);
                    }
                    int n4 = resultSet.getInt(3);
                    int n5 = resultSet.getInt(4);
                    int n6 = resultSet.getInt(5);
                    if (topoFeature == null) {
                        topoFeature = new TopoFeature(l2, 2);
                    }
                    TopoEdge topoEdge = new TopoEdge(n4);
                    topoEdge.setNodes(n5, n6);
                    topoEdge.setGeometry((JSDOGeometry)cloneable);
                    topoFeature.addEdge(topoEdge);
                    TopoNode topoNode = topoFeature.getNode(n5);
                    if (topoNode == null) {
                        topoNode = new TopoNode(n5);
                        topoFeature.addNode(topoNode);
                    }
                    topoNode.addEdge(n4);
                    TopoNode topoNode2 = topoFeature.getNode(n6);
                    if (topoNode2 == null) {
                        topoNode2 = new TopoNode(n6);
                        topoFeature.addNode(topoNode2);
                    }
                    if (n5 != n6) {
                        topoNode2.addEdge(n4);
                    }
                    l = l2;
                }
                if (topoFeature == null) break block26;
                Vector vector2 = topoFeature.getFeatureLines();
                this.createStyledFeatures(vector2, string9, string7, string8, vector, arrayList, n2);
            }
            Object var44_39 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            try {
                if (statement != null) {
                    statement.close();
                }
                break block28;
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            break block28;
            {
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                    throw new DataException(exception);
                }
            }
            catch (Throwable throwable) {
                Object var44_40 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                throw throwable;
            }
        }
        return n2;
    }

    /*
     * Loose catch block
     */
    private int processPredefinedTopologyEdgeQueryV2(Connection connection, boolean bl, double d, double d2, double d3, double d4, ArrayList arrayList, Proj proj, boolean bl2, int n, VisContext visContext) throws DataException {
        int n2;
        block28: {
            Statement statement;
            ResultSet resultSet;
            block26: {
                n2 = n;
                resultSet = null;
                statement = null;
                String string = this.def.getTopoGeometryColumn();
                String string2 = this.def.getLabelColumn();
                String string3 = null;
                String string4 = this.getIndexTableName(connection);
                string3 = this.rewriteTopologyEdgeQueryV2(connection, bl, d, d2, d3, d4, bl2, string4);
                if (string3 == null) {
                    log.warning("Predefine Topology Edge query is null.");
                    return n2;
                }
                log.finest("Predefined Topology Edge query [" + this.def.name + "]:\n" + string3);
                String string5 = null;
                String string6 = null;
                String string7 = null;
                string7 = this.def.getCacheEdgeGroup();
                if (bl) {
                    string7 = this.def.getCacheEdgeGroupName(this.visSRID);
                }
                statement = connection.prepareStatement(string3);
                statement.setFetchSize(this.owner.getFetchSize());
                log.finer("Fetch size: " + statement.getFetchSize());
                long l = System.currentTimeMillis();
                resultSet = statement.executeQuery();
                long l2 = System.currentTimeMillis();
                log.info("Predefined Topology Edge query executed [" + this.def.name + "]: " + (l2 - l) + " ms");
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n3 = resultSetMetaData.getColumnCount();
                long l3 = 0L;
                String string8 = null;
                String string9 = null;
                String string10 = null;
                Vector vector = null;
                TopoFeature topoFeature = null;
                while (resultSet.next()) {
                    Cloneable cloneable;
                    long l4 = resultSet.getLong(7);
                    if (l4 != l3 && l3 != 0L) {
                        cloneable = topoFeature.getFeatureLines();
                        this.createStyledFeatures((Vector)cloneable, string10, string8, string9, vector, arrayList, n2);
                        topoFeature = null;
                        vector = null;
                        string8 = null;
                        string9 = null;
                        string10 = null;
                    }
                    cloneable = null;
                    string6 = string5 = resultSet.getString(1);
                    if (bl) {
                        string6 = string5 + this.visSRID;
                    }
                    if ((cloneable = this.loadPredefinedGeometry(resultSet, proj, string6, string7, true, visContext, false)) == null) continue;
                    if (string10 == null) {
                        string10 = resultSet.getString(9);
                    }
                    if (resultSet.getFloat(12) > 0.0f && string8 == null) {
                        string8 = resultSet.getString(10);
                        string9 = resultSet.getString(11);
                    }
                    if (n3 > 12 && vector == null) {
                        vector = this.getAttributes(resultSetMetaData, resultSet, 12, 13, n3);
                    }
                    int n4 = resultSet.getInt(3);
                    int n5 = resultSet.getInt(4);
                    int n6 = resultSet.getInt(5);
                    if (topoFeature == null) {
                        topoFeature = new TopoFeature(l4, 2);
                    }
                    TopoEdge topoEdge = new TopoEdge(n4);
                    topoEdge.setNodes(n5, n6);
                    topoEdge.setGeometry((JSDOGeometry)cloneable);
                    topoFeature.addEdge(topoEdge);
                    TopoNode topoNode = topoFeature.getNode(n5);
                    if (topoNode == null) {
                        topoNode = new TopoNode(n5);
                        topoFeature.addNode(topoNode);
                    }
                    topoNode.addEdge(n4);
                    TopoNode topoNode2 = topoFeature.getNode(n6);
                    if (topoNode2 == null) {
                        topoNode2 = new TopoNode(n6);
                        topoFeature.addNode(topoNode2);
                    }
                    if (n5 != n6) {
                        topoNode2.addEdge(n4);
                    }
                    l3 = l4;
                }
                if (topoFeature == null) break block26;
                Vector vector2 = topoFeature.getFeatureLines();
                this.createStyledFeatures(vector2, string10, string8, string9, vector, arrayList, n2);
            }
            Object var49_42 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            try {
                if (statement != null) {
                    statement.close();
                }
                break block28;
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            break block28;
            {
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                    throw new DataException(exception);
                }
            }
            catch (Throwable throwable) {
                Object var49_43 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                throw throwable;
            }
        }
        return n2;
    }

    /*
     * Loose catch block
     */
    private int processPredefinedTopologyNodeQuery(Connection connection, boolean bl, double d, double d2, double d3, double d4, ArrayList arrayList, Proj proj, boolean bl2, int n, VisContext visContext) throws DataException {
        int n2;
        block23: {
            n2 = n;
            ResultSet resultSet = null;
            Statement statement = null;
            String string = this.def.getTopoGeometryColumn();
            String string2 = this.def.getLabelColumn();
            String string3 = null;
            string3 = this.rewriteTopologyPointQuery(connection, bl, d, d2, d3, d4, bl2);
            if (string3 == null) {
                log.warning("Predefined Topology Point query is null.");
                return n2;
            }
            log.info("[Predefined Topology Point query]:  " + string3);
            String string4 = null;
            String string5 = null;
            String string6 = null;
            string6 = this.def.getCacheNodeGroup();
            if (bl) {
                string6 = this.def.getCacheNodeGroupName(this.visSRID);
            }
            statement = connection.prepareStatement(string3);
            statement.setFetchSize(this.owner.getFetchSize());
            log.finer("Fetch size: " + statement.getFetchSize());
            resultSet = statement.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n3 = resultSetMetaData.getColumnCount();
            while (resultSet.next()) {
                JSDOGeometry jSDOGeometry = null;
                string5 = string4 = resultSet.getString(1);
                if (bl) {
                    string5 = string4 + this.visSRID;
                }
                if ((jSDOGeometry = this.loadPredefinedGeometry(resultSet, proj, string5, string6, true, visContext, false)) == null) continue;
                StyledFeatureI styledFeatureI = this.getNewStyledFeatureInstance();
                styledFeatureI.setGeometry(jSDOGeometry);
                if (this.def.getRenderingRules() != null && this.def.getRenderingRules().length > 0) {
                    styledFeatureI.setFeatureStyleName(this.def.getRenderingRules()[0].getStyleName());
                } else {
                    styledFeatureI.setFeatureStyleName(resultSet.getString(9));
                }
                if (resultSet.getFloat(12) > 0.0f) {
                    styledFeatureI.setLabel(resultSet.getString(10));
                    styledFeatureI.setLabelStyleName(resultSet.getString(11));
                }
                if (n3 > 12) {
                    this.loadAttributeData(resultSet, styledFeatureI, n3, resultSetMetaData, 12);
                }
                styledFeatureI.setDataSource(this.def.getDataSourceName());
                styledFeatureI.setRenderingRules(this.def.getRenderingRules());
                arrayList.add(styledFeatureI);
                if (++n2 % 20 != 0) continue;
                Thread.currentThread();
                Thread.yield();
            }
            Object var30_26 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            try {
                if (statement != null) {
                    statement.close();
                }
                break block23;
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            break block23;
            {
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                    throw new DataException(exception);
                }
            }
            catch (Throwable throwable) {
                Object var30_27 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                throw throwable;
            }
        }
        return n2;
    }

    /*
     * Loose catch block
     */
    private int processPredefinedTopologyNodeQueryV2(Connection connection, boolean bl, double d, double d2, double d3, double d4, ArrayList arrayList, Proj proj, boolean bl2, int n, VisContext visContext) throws DataException {
        int n2;
        block23: {
            n2 = n;
            ResultSet resultSet = null;
            Statement statement = null;
            String string = this.def.getTopoGeometryColumn();
            String string2 = this.def.getLabelColumn();
            String string3 = null;
            String string4 = this.getIndexTableName(connection);
            string3 = this.rewriteTopologyPointQueryV2(connection, bl, d, d2, d3, d4, bl2, string4);
            if (string3 == null) {
                log.warning("Predefined Topology Point query is null.");
                return n2;
            }
            log.finest("Predefined Topology Point query [" + this.def.name + "]:\n" + string3);
            String string5 = null;
            String string6 = null;
            String string7 = null;
            string7 = this.def.getCacheNodeGroup();
            if (bl) {
                string7 = this.def.getCacheNodeGroupName(this.visSRID);
            }
            statement = connection.prepareStatement(string3);
            statement.setFetchSize(this.owner.getFetchSize());
            log.finer("Fetch size: " + statement.getFetchSize());
            long l = System.currentTimeMillis();
            resultSet = statement.executeQuery();
            long l2 = System.currentTimeMillis();
            log.info("Predefined Topology Point query executed [" + this.def.name + "]: " + (l2 - l) + " ms");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n3 = resultSetMetaData.getColumnCount();
            while (resultSet.next()) {
                JSDOGeometry jSDOGeometry = null;
                string6 = string5 = resultSet.getString(1);
                if (bl) {
                    string6 = string5 + this.visSRID;
                }
                if ((jSDOGeometry = this.loadPredefinedGeometry(resultSet, proj, string6, string7, true, visContext, false)) == null) continue;
                StyledFeatureI styledFeatureI = this.getNewStyledFeatureInstance();
                styledFeatureI.setGeometry(jSDOGeometry);
                if (this.def.getRenderingRules() != null && this.def.getRenderingRules().length > 0) {
                    styledFeatureI.setFeatureStyleName(this.def.getRenderingRules()[0].getStyleName());
                } else {
                    styledFeatureI.setFeatureStyleName(resultSet.getString(9));
                }
                if (resultSet.getFloat(12) > 0.0f) {
                    styledFeatureI.setLabel(resultSet.getString(10));
                    styledFeatureI.setLabelStyleName(resultSet.getString(11));
                }
                if (n3 > 12) {
                    this.loadAttributeData(resultSet, styledFeatureI, n3, resultSetMetaData, 12);
                }
                styledFeatureI.setDataSource(this.def.getDataSourceName());
                styledFeatureI.setRenderingRules(this.def.getRenderingRules());
                arrayList.add(styledFeatureI);
                if (++n2 % 20 != 0) continue;
                Thread.currentThread();
                Thread.yield();
            }
            Object var35_29 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            try {
                if (statement != null) {
                    statement.close();
                }
                break block23;
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            break block23;
            {
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                    throw new DataException(exception);
                }
            }
            catch (Throwable throwable) {
                Object var35_30 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                throw throwable;
            }
        }
        return n2;
    }

    private int createStyledFeatures(Vector vector, String string, String string2, String string3, Vector vector2, ArrayList arrayList, int n) throws Exception {
        int n2 = n;
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                JSDOGeometry jSDOGeometry = (JSDOGeometry)vector.get(i);
                StyledFeatureI styledFeatureI = this.getNewStyledFeatureInstance();
                styledFeatureI.setGeometry(jSDOGeometry);
                if (string2 != null) {
                    styledFeatureI.setLabel(string2);
                    styledFeatureI.setLabelStyleName(string3);
                }
                if (vector2 != null) {
                    try {
                        this.fillAttributes(styledFeatureI, vector2);
                    }
                    catch (Exception exception) {
                        throw new Exception(exception.getMessage());
                    }
                }
                styledFeatureI.setFeatureStyleName(string);
                styledFeatureI.setDataSource(this.def.getDataSourceName());
                styledFeatureI.setRenderingRules(this.def.getRenderingRules());
                arrayList.add(styledFeatureI);
                if (++n2 % 20 != 0) continue;
                Thread.currentThread();
                Thread.yield();
            }
        }
        return n2;
    }

    private StyledFeatureI createStyledFeatureFromFace(Vector vector, int n) {
        StyledFeatureI styledFeatureI = null;
        JSDOGeometry jSDOGeometry = this.getFaceGeometry(vector);
        if (jSDOGeometry != null) {
            styledFeatureI = this.getNewStyledFeatureInstance();
            styledFeatureI.setGeometry(jSDOGeometry);
            styledFeatureI.setFeatureStyleName(this.def.getFaceStyle());
            styledFeatureI.setDataSource(this.def.getDataSourceName());
            if (this.def.getFaceLabelStyle() != null) {
                styledFeatureI.setLabel(String.valueOf(n));
                styledFeatureI.setLabelStyleName(this.def.getFaceLabelStyle());
            }
        }
        return styledFeatureI;
    }

    private JSDOGeometry getFaceGeometry(Vector vector) {
        JSDOGeometry jSDOGeometry = null;
        if (vector != null && vector.size() > 0) {
            JSDOGeometry jSDOGeometry2 = null;
            double[][] dArrayArray = new double[vector.size()][];
            if (vector.size() == 1) {
                jSDOGeometry2 = (JSDOGeometry)vector.get(0);
                dArrayArray[0] = jSDOGeometry2.getOrdinatesArray();
            } else {
                double d;
                double d2;
                int n;
                double d3 = 0.0;
                int n2 = -1;
                for (n = 0; n < vector.size(); ++n) {
                    jSDOGeometry2 = (JSDOGeometry)vector.get(n);
                    double[] dArray = jSDOGeometry2.getMBR();
                    d2 = (dArray[2] - dArray[0]) * (dArray[3] - dArray[1]);
                    if (!(d2 > d3)) continue;
                    n2 = n;
                    d3 = d2;
                }
                jSDOGeometry2 = (JSDOGeometry)vector.get(n2);
                dArrayArray[0] = jSDOGeometry2.getOrdinatesArray();
                if (this.isClockwise(dArrayArray[0])) {
                    n = dArrayArray[0].length;
                    for (int i = 0; i < (n - 2) / 2; i += 2) {
                        d2 = dArrayArray[0][i];
                        d = dArrayArray[0][i + 1];
                        dArrayArray[0][i] = dArrayArray[0][n - 2 - i];
                        dArrayArray[0][i + 1] = dArrayArray[0][n - 1 - i];
                        dArrayArray[0][n - 2 - i] = d2;
                        dArrayArray[0][n - 1 - i] = d;
                    }
                }
                n = 1;
                for (int i = 0; i < vector.size(); ++i) {
                    if (i == n2) continue;
                    jSDOGeometry2 = (JSDOGeometry)vector.get(i);
                    dArrayArray[n] = jSDOGeometry2.getOrdinatesArray();
                    if (!this.isClockwise(dArrayArray[n])) {
                        int n3 = dArrayArray[n].length;
                        for (int j = 0; j < (n3 - 2) / 2; j += 2) {
                            d = dArrayArray[n][j];
                            double d4 = dArrayArray[n][j + 1];
                            dArrayArray[n][j] = dArrayArray[n][n3 - 2 - j];
                            dArrayArray[n][j + 1] = dArrayArray[n][n3 - 1 - j];
                            dArrayArray[n][n3 - 2 - j] = d;
                            dArrayArray[n][n3 - 1 - j] = d4;
                        }
                    }
                    ++n;
                }
            }
            if (dArrayArray != null) {
                jSDOGeometry = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((Object[])dArrayArray, (int)2, (int)this.def.getSrid()));
            }
        }
        return jSDOGeometry;
    }

    private JSDOGeometry getFaceExteriorGeometry(Vector vector) {
        JSDOGeometry jSDOGeometry = null;
        int n = -1;
        if (vector != null && vector.size() > 0) {
            if (vector.size() == 1) {
                n = 0;
            } else {
                double d = 0.0;
                for (int i = 0; i < vector.size(); ++i) {
                    JSDOGeometry jSDOGeometry2 = (JSDOGeometry)vector.get(i);
                    double[] dArray = jSDOGeometry2.getMBR();
                    double d2 = (dArray[2] - dArray[0]) * (dArray[3] - dArray[1]);
                    if (!(d2 > d)) continue;
                    n = i;
                    d = d2;
                }
            }
        }
        if (n > -1 && n < vector.size()) {
            jSDOGeometry = (JSDOGeometry)vector.get(n);
        }
        return jSDOGeometry;
    }

    private void generateFacePolygonsFromEdges(int n, Vector vector, Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3) {
        int n2 = hashtable.size();
        if (n2 > 0) {
            Vector<Object> vector2 = new Vector<Object>(10);
            Object[] objectArray = hashtable.values().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object;
                int n3;
                TopoEdge topoEdge = (TopoEdge)objectArray[i];
                String string = String.valueOf(topoEdge.getID());
                if (vector2.contains(string)) continue;
                int n4 = topoEdge.getStartNodeID();
                int n5 = topoEdge.getEndNodeID();
                int n6 = 0;
                n6 = topoEdge.getLeftFaceID() == n ? 2 : 1;
                int n7 = Integer.parseInt(hashtable3.get(string).toString());
                Object object2 = string;
                JSDOGeometry jSDOGeometry = topoEdge.getGeometry();
                vector2.add(string);
                int n8 = Integer.parseInt(string);
                double[] dArray = null;
                dArray = jSDOGeometry.getOrdinatesArray();
                double[] dArray2 = new double[dArray.length];
                if (topoEdge.getLeftFaceID() == n && !jSDOGeometry.LoadedAndReoriented() || topoEdge.getRightFaceID() == n && jSDOGeometry.LoadedAndReoriented()) {
                    for (n3 = 0; n3 < dArray.length; ++n3) {
                        dArray2[n3] = dArray[n3];
                    }
                } else {
                    for (n3 = 0; n3 < dArray.length; n3 += 2) {
                        dArray2[n3] = dArray[dArray.length - 1 - n3 - 1];
                        dArray2[n3 + 1] = dArray[dArray.length - 1 - n3];
                    }
                }
                n3 = 1;
                boolean bl = false;
                int n9 = 0;
                while (n3 != 0) {
                    int n10;
                    Object object3;
                    int n11;
                    if (n9 > n2) {
                        log.warning("Unable to close polygon for face " + n);
                        break;
                    }
                    ++n9;
                    object = String.valueOf(Math.abs(n7));
                    TopoEdge topoEdge2 = (TopoEdge)hashtable.get(object);
                    JSDOGeometry jSDOGeometry2 = null;
                    if (topoEdge2 == null) {
                        int n12;
                        Vector vector3;
                        n11 = dArray2.length;
                        if (Math.abs(dArray2[0] - dArray2[n11 - 2]) <= this.def.getTolerance() && Math.abs(dArray2[1] - dArray2[n11 - 1]) <= this.def.getTolerance()) {
                            bl = true;
                            n3 = 0;
                            continue;
                        }
                        if (n6 == 1) {
                            object3 = (TopoNode)hashtable2.get(String.valueOf(n4));
                            vector3 = ((TopoNode)object3).getEdges();
                            for (n12 = 0; n12 < vector3.size(); ++n12) {
                                String string2 = (String)vector3.get(n12);
                                if (string2.equals(object2)) continue;
                                topoEdge2 = (TopoEdge)hashtable.get(string2);
                                object = string2;
                                n7 = topoEdge2.getID();
                                if (topoEdge2.getStartNodeID() == n4) break;
                                n7 = topoEdge2.getID() * -1;
                                break;
                            }
                        } else {
                            object3 = (TopoNode)hashtable2.get(String.valueOf(n5));
                            vector3 = ((TopoNode)object3).getEdges();
                            for (n12 = 0; n12 < vector3.size(); ++n12) {
                                String string3 = (String)vector3.get(n12);
                                if (string3.equals(object2)) continue;
                                topoEdge2 = (TopoEdge)hashtable.get(string3);
                                object = string3;
                                n7 = topoEdge2.getID();
                                if (topoEdge2.getStartNodeID() == n5) break;
                                n7 = topoEdge2.getID() * -1;
                                break;
                            }
                        }
                        if (topoEdge2 == null) {
                            bl = false;
                            log.warning("Next edge (" + (String)object + ") is null. Face (" + n + ") polygon discarded.");
                            break;
                        }
                    }
                    n11 = dArray2.length;
                    if (n8 == Math.abs(n7)) {
                        if (Math.abs(dArray2[0] - dArray2[n11 - 2]) <= this.def.getTolerance() && Math.abs(dArray2[1] - dArray2[n11 - 1]) <= this.def.getTolerance()) {
                            bl = true;
                        } else {
                            log.warning("Polygon start and end points are not the same for face " + n + " : face discarded.");
                        }
                        n3 = 0;
                        continue;
                    }
                    jSDOGeometry2 = topoEdge2.getGeometry();
                    object3 = jSDOGeometry2.getOrdinatesArray();
                    int n13 = ((double[])object3).length;
                    double[] dArray3 = new double[dArray2.length];
                    System.arraycopy(dArray2, 0, dArray3, 0, dArray2.length);
                    dArray2 = null;
                    dArray2 = new double[dArray3.length + ((Object)object3).length - 2];
                    System.arraycopy(dArray3, 0, dArray2, 0, dArray3.length);
                    if (n7 > 0) {
                        if (!jSDOGeometry2.LoadedAndReoriented()) {
                            for (n10 = 2; n10 < ((Object)object3).length; ++n10) {
                                dArray2[dArray3.length + n10 - 2] = (double)object3[n10];
                            }
                        } else {
                            for (n10 = 2; n10 < ((Object)object3).length; n10 += 2) {
                                dArray2[dArray3.length + n10 - 2] = (double)object3[((Object)object3).length - 1 - n10 - 1];
                                dArray2[dArray3.length + n10 - 1] = (double)object3[((Object)object3).length - 1 - n10];
                            }
                        }
                        n6 = 2;
                    } else {
                        if (jSDOGeometry2.LoadedAndReoriented()) {
                            for (n10 = 2; n10 < ((Object)object3).length; ++n10) {
                                dArray2[dArray3.length + n10 - 2] = (double)object3[n10];
                            }
                        } else {
                            for (n10 = 2; n10 < ((Object)object3).length; n10 += 2) {
                                dArray2[dArray3.length + n10 - 2] = (double)object3[((Object)object3).length - 1 - n10 - 1];
                                dArray2[dArray3.length + n10 - 1] = (double)object3[((Object)object3).length - 1 - n10];
                            }
                        }
                        n6 = 1;
                    }
                    vector2.add(object);
                    topoEdge = topoEdge2;
                    n4 = topoEdge.getStartNodeID();
                    n5 = topoEdge.getEndNodeID();
                    object2 = object;
                    n7 = Integer.parseInt(hashtable3.get(object).toString());
                }
                if (!bl) continue;
                object = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])dArray2, (int)2, (int)this.def.getSrid()));
                vector.add(object);
            }
        }
    }

    private JSDOGeometry loadGeometry(ResultSet resultSet, Proj proj, boolean bl, VisContext visContext, boolean bl2) {
        JSDOGeometry jSDOGeometry = null;
        try {
            Object object;
            if (this.getTheme().getDecorator().isFastUnpickle()) {
                object = ((OracleResultSet)resultSet).getBytes(1);
                jSDOGeometry = bl && this.getTheme().getDecorator().isReorientLines() ? JSDOGeometry.loadAndReorient(object) : JSDOGeometry.loadFromDB(object);
            } else {
                jSDOGeometry = JDBCUtil.loadGeometry(resultSet, 1, false);
            }
            if (jSDOGeometry == null) {
                return null;
            }
            if (this.applyRotation) {
                object = Util.rotateGeometry(jSDOGeometry, (this.swxl + this.swxh) / 2.0, (this.swyl + this.swyh) / 2.0, this.mapRotation);
                if (object == null) {
                    return null;
                }
                jSDOGeometry = JSDOGeometry.recast((JGeometry)object);
                if (jSDOGeometry == null) {
                    return null;
                }
            }
            if (bl2 && (jSDOGeometry = visContext.getSrs().shift(jSDOGeometry, visContext.getQueryWindow())) == null) {
                log.finer("SRS.shif method returned null geometry.");
                return null;
            }
            if (proj != null) {
                object = proj.getOpposite();
                if (jSDOGeometry.pointInPolygon(object.x, object.y)) {
                    return null;
                }
                if ((jSDOGeometry = SRS.proj(jSDOGeometry, proj, 0)) == null) {
                    return null;
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
        return jSDOGeometry;
    }

    private JSDOGeometry loadPredefinedGeometry(ResultSet resultSet, Proj proj, String string, String string2, boolean bl, VisContext visContext, boolean bl2) {
        JSDOGeometry jSDOGeometry = null;
        try {
            Object object;
            if (this.def.getCachingMode() != 3 && this.getTheme().getDecorator().getWorkspaceName() == null) {
                object = CacheMgr2.getGroup(this.def.cacheSubRegionName, string2);
                jSDOGeometry = (JSDOGeometry)((MVLinkedHashMap)object).get(string);
                if (jSDOGeometry == null && (jSDOGeometry = JDBCUtil.loadGeometry(resultSet, 2, false)) != null) {
                    ((CacheGroup)object).put(string, jSDOGeometry, jSDOGeometry.getSize());
                }
            } else {
                jSDOGeometry = JDBCUtil.loadGeometry(resultSet, 2, false);
            }
            if (jSDOGeometry == null) {
                return null;
            }
            if (this.applyRotation) {
                object = Util.rotateGeometry(jSDOGeometry, (this.swxl + this.swxh) / 2.0, (this.swyl + this.swyh) / 2.0, this.mapRotation);
                if (object == null) {
                    return null;
                }
                jSDOGeometry = JSDOGeometry.recast((JGeometry)object);
                if (jSDOGeometry == null) {
                    return null;
                }
            }
            if (bl2 && (jSDOGeometry = visContext.getSrs().shift(jSDOGeometry, visContext.getQueryWindow())) == null) {
                log.finer("SRS.shif method returned null geometry.");
                return null;
            }
            if (proj != null) {
                object = proj.getOpposite();
                if (jSDOGeometry.pointInPolygon(((Proj.P2)object).x, ((Proj.P2)object).y)) {
                    return null;
                }
                if ((jSDOGeometry = SRS.proj(jSDOGeometry, proj, 0)) == null) {
                    return null;
                }
            }
        }
        catch (Exception exception) {
            log.warning(exception.getMessage());
            return null;
        }
        return jSDOGeometry;
    }

    public void setStyledFeatures(ArrayList arrayList) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(arrayList);
    }

    public StyledFeatureI[] getStyledFeatures() {
        if (this.features != null) {
            return this.features.getStyledFeatures();
        }
        return null;
    }

    public StyledFeatureI[] getSelectedFeatures(Rectangle2D rectangle2D) {
        if (this.features == null) {
            return null;
        }
        return this.features.getSelectedFeatures(rectangle2D);
    }

    public StyledFeatureI getStyledFeature(int n) {
        if (this.features == null) {
            return null;
        }
        return this.features.getStyledFeature(n);
    }

    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D rectangle2D, String string) {
        if (this.features == null) {
            return null;
        }
        return this.features.getSelectedFeaturesAsTheme(rectangle2D, string);
    }

    public double[] getDataMBR() {
        if (this.features == null) {
            return null;
        }
        return this.features.getDataMBR();
    }

    public void postPreparation(VisContext visContext) {
        if (this.features != null) {
            this.features.postPreparation(visContext);
        }
    }

    public int size() {
        if (this.features != null) {
            return this.features.size();
        }
        return 0;
    }

    private boolean isFullExtent(boolean bl, double d, double d2, double d3, double d4) {
        return bl || Double.isInfinite(d) || Double.isNaN(d) || Double.isInfinite(d2) || Double.isNaN(d2) || Double.isInfinite(d3) || Double.isNaN(d3) || Double.isInfinite(d4) || Double.isNaN(d4);
    }

    private boolean isClockwise(double[] dArray) {
        double d = this.getPolygonArea(dArray);
        return !(d < 0.0);
    }

    private double getPolygonArea(double[] dArray) {
        if (dArray == null) {
            return 0.0;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = dArray[0];
        double d5 = dArray[1];
        for (int i = 2; i < dArray.length - 1; i += 2) {
            double d6 = dArray[i];
            double d7 = dArray[i + 1];
            d += d4 * d7;
            d2 += d5 * d6;
            d4 = d6;
            d5 = d7;
        }
        d3 = (d2 - d) / 2.0;
        return d3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getIndexTableName(Connection var1_1) {
        block25: {
            block20: {
                block21: {
                    if (var1_1 == null) {
                        return null;
                    }
                    var2_2 = null;
                    var3_3 = null;
                    var4_4 = null;
                    try {
                        try {
                            var4_4 = "    select sdo_index_table\n    from all_sdo_index_info\n    where table_owner = ?\n    and table_name = ?\n    and column_name = ?";
                            var2_2 = var1_1.prepareStatement(var4_4);
                            var2_2.setString(1, this.def.getTableOwner().toUpperCase());
                            var2_2.setString(2, this.def.getFeatureTable().toUpperCase());
                            var2_2.setString(3, this.def.getTopoGeometryColumn().toUpperCase());
                            var3_3 = var2_2.executeQuery();
                            if (!var3_3.next()) break block20;
                            var5_5 = var3_3.getString(1);
                            var7_7 = null;
                            if (var3_3 == null) break block21;
                        }
                        catch (Exception var5_6) {
                            TopologyThemeProducer.log.severe(var4_4 + "\n" + var5_6.getMessage());
                            var7_9 = null;
                            if (var3_3 != null) {
                                try {
                                    var3_3.close();
                                }
                                catch (Exception var8_13) {
                                    // empty catch block
                                }
                            }
                            if (var2_2 == null) return null;
                            try {
                                var2_2.close();
                                return null;
                            }
                            catch (Exception var8_13) {
                                return null;
                            }
                        }
                    }
                    catch (Throwable var6_15) {
                        block24: {
                            var7_10 = null;
                            if (var3_3 != null) {
                                ** try [egrp 2[TRYBLOCK] [5 : 171->180)] { 
lbl42:
                                // 1 sources

                                var3_3.close();
                                break block24;
lbl44:
                                // 1 sources

                                catch (Exception var8_14) {
                                    // empty catch block
                                }
                            }
                        }
                        if (var2_2 == null) throw var6_15;
                        ** try [egrp 3[TRYBLOCK] [6 : 186->195)] { 
lbl49:
                        // 1 sources

                        var2_2.close();
                        throw var6_15;
lbl51:
                        // 1 sources

                        catch (Exception var8_14) {
                            // empty catch block
                        }
                        throw var6_15;
                    }
                    ** try [egrp 2[TRYBLOCK] [5 : 171->180)] { 
lbl56:
                    // 1 sources

                    var3_3.close();
                    break block21;
lbl58:
                    // 1 sources

                    catch (Exception var8_11) {
                        // empty catch block
                    }
                }
                if (var2_2 == null) return var5_5;
                try {}
                catch (Exception var8_11) {
                    // empty catch block
                    return var5_5;
                }
                var2_2.close();
                return var5_5;
            }
            var7_8 = null;
            if (var3_3 != null) {
                ** try [egrp 2[TRYBLOCK] [5 : 171->180)] { 
lbl72:
                // 1 sources

                var3_3.close();
                break block25;
lbl74:
                // 1 sources

                catch (Exception var8_12) {
                    // empty catch block
                }
            }
        }
        if (var2_2 == null) return null;
        try {}
        catch (Exception var8_12) {}
        var2_2.close();
        return null;
        return null;
    }

    public StyledFeatureI getNewStyledFeatureInstance() {
        return new StyledFeature();
    }

    private class TopoFeatureGeometry {
        Vector faceIds = new Vector(10);
        Vector polygons = new Vector(10);

        public boolean addPolygon(JSDOGeometry jSDOGeometry, Vector vector) {
            if (jSDOGeometry == null || vector.size() == 0) {
                return false;
            }
            for (int i = 0; i < vector.size(); ++i) {
                if (this.faceIds.contains(vector.get(i))) continue;
                this.faceIds.add(vector.get(i));
            }
            this.polygons.add(jSDOGeometry);
            return true;
        }

        public Vector getPolygons() {
            return this.polygons;
        }

        public boolean faceIn(String string) {
            return this.faceIds.contains(string);
        }

        public JSDOGeometry getGeometry() {
            if (this.polygons.size() == 0) {
                return null;
            }
            return TopologyThemeProducer.this.getFaceGeometry(this.polygons);
        }

        public JSDOGeometry getExternalGeometry() {
            if (this.polygons.size() == 0) {
                return null;
            }
            return TopologyThemeProducer.this.getFaceExteriorGeometry(this.polygons);
        }
    }

    private class TopoFeature {
        long featID = 0L;
        int featType = 0;
        Hashtable edgeFaces = new Hashtable(10);
        Hashtable commonEdges = new Hashtable();
        Hashtable edges = new Hashtable();
        Hashtable polyFaces = new Hashtable();
        Vector edgeIDs = new Vector(10);
        Hashtable nodes = new Hashtable(10);
        Hashtable containedFaces = new Hashtable(10);

        public TopoFeature(long l, int n) {
            this.featID = l;
            this.featType = n;
        }

        public void addCommonEdge(TopoEdge topoEdge) {
            this.commonEdges.put(String.valueOf(topoEdge.getID()), topoEdge);
            this.edges.remove(String.valueOf(topoEdge.getID()));
        }

        public void addEdge(TopoEdge topoEdge) {
            this.edges.put(String.valueOf(topoEdge.getID()), topoEdge);
        }

        public void addNode(TopoNode topoNode) {
            this.nodes.put(String.valueOf(topoNode.getID()), topoNode);
        }

        public TopoNode getNode(int n) {
            return (TopoNode)this.nodes.get(String.valueOf(n));
        }

        public void addFace(TopoFace topoFace) {
            int n;
            Object object;
            int n2;
            if (this.edgeFaces.get(String.valueOf(topoFace.getID())) != null) {
                return;
            }
            if (this.polyFaces.get(String.valueOf(topoFace.getID())) != null) {
                return;
            }
            int n3 = topoFace.getPolygons().size();
            if (n3 > 0) {
                n2 = 0;
                Vector vector = topoFace.getFacePolygonsEdges();
                block0: for (int i = 0; i < topoFace.getPolygons().size(); ++i) {
                    TopoEdge topoEdge = (TopoEdge)vector.get(i);
                    Enumeration enumeration = this.polyFaces.elements();
                    while (enumeration.hasMoreElements()) {
                        TopoEdge topoEdge2;
                        object = (TopoFace)enumeration.nextElement();
                        if (((TopoFace)object).getPolygons().size() == 0) continue;
                        boolean bl = false;
                        Vector vector2 = ((TopoFace)object).getFacePolygonsEdges();
                        for (n = 0; n < ((TopoFace)object).getPolygons().size(); ++n) {
                            topoEdge2 = (TopoEdge)vector2.get(n);
                            if (topoEdge.getID() != topoEdge2.getID() || Math.abs(topoEdge.getPreviousEdge()) != Math.abs(topoEdge.getNextEdge()) || Math.abs(topoEdge2.getPreviousEdge()) != Math.abs(topoEdge2.getNextEdge())) continue;
                            topoFace.removeFacePolygon(i);
                            --i;
                            ((TopoFace)object).removeFacePolygon(n);
                            ++n2;
                            bl = true;
                            break;
                        }
                        if (bl) continue block0;
                        vector2 = ((TopoFace)object).getFaceOffsetPolygonsEdges();
                        for (n = 0; n < ((TopoFace)object).getOffsetPolygons().size(); ++n) {
                            topoEdge2 = (TopoEdge)vector2.get(n);
                            if (topoEdge.getID() != topoEdge2.getID()) continue;
                            topoFace.removeFacePolygon(i);
                            --i;
                            ++n2;
                            bl = true;
                            break;
                        }
                        if (!bl) continue;
                        continue block0;
                    }
                }
                if (n3 != n2) {
                    this.polyFaces.put(String.valueOf(topoFace.getID()), topoFace);
                }
            }
            if (topoFace.getNumberOfEdges() > 0) {
                n2 = topoFace.getNumberOfEdges();
                int n4 = 0;
                Object[] objectArray = topoFace.getEdges().values().toArray();
                for (int i = 0; i < n2; ++i) {
                    int n5 = ((TopoEdge)objectArray[i]).getID();
                    object = (TopoEdge)this.edges.get(String.valueOf(n5));
                    if (object != null) {
                        TopoCommonEdge topoCommonEdge = new TopoCommonEdge(n5);
                        topoCommonEdge.setFaceId(((TopoEdge)object).getFaceId());
                        topoCommonEdge.setNodes(0, 0);
                        topoCommonEdge.setFaces(((TopoEdge)object).getLeftFaceID(), ((TopoEdge)object).getRightFaceID());
                        topoCommonEdge.setFirstFaceID(((TopoEdge)object).getFaceId());
                        topoCommonEdge.setSecondFaceID(topoFace.getID());
                        this.addCommonEdge(topoCommonEdge);
                        this.edges.remove(String.valueOf(n5));
                        this.edgeIDs.remove(String.valueOf(n5));
                        ++n4;
                        continue;
                    }
                    object = (TopoEdge)objectArray[i];
                    int n6 = ((TopoEdge)object).getStartNodeID();
                    int n7 = ((TopoEdge)object).getEndNodeID();
                    n = ((TopoEdge)object).getLeftFaceID();
                    int n8 = ((TopoEdge)object).getRightFaceID();
                    object = new TopoEdge(n5, topoFace.getID());
                    ((TopoEdge)object).setNodes(n6, n7);
                    ((TopoEdge)object).setFaces(n, n8);
                    this.edges.put(String.valueOf(n5), object);
                    this.edgeIDs.add(String.valueOf(n5));
                }
                if (n2 > 0 && n4 != n2) {
                    this.edgeFaces.put(String.valueOf(topoFace.getID()), topoFace);
                } else if (n2 > 0 && n4 == n2) {
                    this.containedFaces.put(String.valueOf(topoFace.getID()), topoFace);
                }
            }
        }

        public Vector getFeaturePolygons() {
            Object object;
            Object object2;
            Object object3;
            Vector<Object> vector;
            if (this.edges.size() == 0 && this.polyFaces.size() == 0) {
                return null;
            }
            Vector<Object> vector2 = new Vector<Object>(10);
            int n = this.edgeIDs.size();
            if (n > 0) {
                vector = new Vector(10);
                object3 = new Vector(10);
                for (int i = 0; i < n; ++i) {
                    boolean bl;
                    Object object4;
                    int n2;
                    object2 = (String)this.edgeIDs.get(i);
                    if (vector.contains(object2)) continue;
                    TopoEdge topoEdge = (TopoEdge)this.edges.get(object2);
                    object = String.valueOf(topoEdge.getFaceId());
                    TopoFace topoFace = (TopoFace)this.edgeFaces.get(object);
                    int n3 = topoEdge.getStartNodeID();
                    int n4 = topoEdge.getEndNodeID();
                    int n5 = 0;
                    n5 = topoEdge.getLeftFaceID() == Integer.parseInt((String)object) ? 2 : 1;
                    int n6 = topoFace.getNextEdgeID(Integer.parseInt((String)object2));
                    Object object5 = object2;
                    JSDOGeometry jSDOGeometry = topoFace.getEdgeGeometry(Integer.parseInt((String)object2));
                    vector.add(object2);
                    int n7 = Integer.parseInt((String)object2);
                    double[] dArray = null;
                    dArray = jSDOGeometry.getOrdinatesArray();
                    double[] dArray2 = new double[dArray.length];
                    for (n2 = 0; n2 < dArray.length; ++n2) {
                        dArray2[n2] = dArray[n2];
                    }
                    n2 = 1;
                    boolean bl2 = false;
                    boolean bl3 = true;
                    ((Vector)object3).add(object);
                    int n8 = topoFace.getID();
                    int n9 = topoFace.getID();
                    while (n2 != 0) {
                        int n10;
                        JSDOGeometry jSDOGeometry2;
                        int n11;
                        Object object6;
                        int n12;
                        object4 = (TopoCommonEdge)this.commonEdges.get(String.valueOf(Math.abs(n6)));
                        bl = false;
                        int n13 = 0;
                        while (object4 != null) {
                            if (n13 > 2 * this.commonEdges.size()) {
                                bl = true;
                                break;
                            }
                            int n14 = 0;
                            n14 = ((TopoCommonEdge)object4).getFirstFaceID() == topoFace.getID() ? ((TopoCommonEdge)object4).getSecondFaceID() : ((TopoCommonEdge)object4).getFirstFaceID();
                            topoFace = (TopoFace)this.edgeFaces.get(String.valueOf(n14));
                            if (topoFace == null) {
                                topoFace = (TopoFace)this.containedFaces.get(String.valueOf(n14));
                                int n15 = topoFace.getNextEdgeID(((TopoEdge)object4).getID());
                                object4 = (TopoCommonEdge)this.commonEdges.get(String.valueOf(Math.abs(n15)));
                                n14 = ((TopoCommonEdge)object4).getFirstFaceID() == topoFace.getID() ? ((TopoCommonEdge)object4).getSecondFaceID() : ((TopoCommonEdge)object4).getFirstFaceID();
                                topoFace = (TopoFace)this.edgeFaces.get(String.valueOf(n14));
                            }
                            n9 = n14;
                            n6 = topoFace.getNextEdgeID(((TopoEdge)object4).getID());
                            object5 = String.valueOf(((TopoEdge)object4).getID());
                            object4 = (TopoCommonEdge)this.commonEdges.get(String.valueOf(Math.abs(n6)));
                            ++n13;
                        }
                        if (bl) {
                            log.warning("Unable to close polygon for feature " + this.featID + " starting with edge " + n7);
                            n2 = 0;
                            continue;
                        }
                        String string = String.valueOf(Math.abs(n6));
                        TopoEdge topoEdge2 = (TopoEdge)topoFace.getEdges().get(string);
                        if (topoEdge2 == null) {
                            n12 = dArray2.length;
                            if (Math.abs(dArray2[0] - dArray2[n12 - 2]) <= TopologyThemeProducer.this.def.getTolerance() && Math.abs(dArray2[1] - dArray2[n12 - 1]) <= TopologyThemeProducer.this.def.getTolerance()) {
                                bl2 = true;
                                n2 = 0;
                                continue;
                            }
                            int n16 = n3;
                            if (n5 != 1) {
                                n16 = n4;
                            }
                            object6 = (TopoNode)topoFace.getNodes().get(String.valueOf(n16));
                            Vector vector3 = ((TopoNode)object6).getEdges();
                            for (n11 = 0; n11 < vector3.size(); ++n11) {
                                String string2 = (String)vector3.get(n11);
                                if (string2.equals(object5)) continue;
                                TopoCommonEdge topoCommonEdge = (TopoCommonEdge)this.commonEdges.get(string2);
                                if (topoCommonEdge == null) {
                                    topoEdge2 = (TopoEdge)topoFace.getEdges().get(string2);
                                    string = string2;
                                    n6 = topoEdge2.getID();
                                    if (topoEdge2.getLeftFaceID() == topoFace.getID()) break;
                                    n6 = topoEdge2.getID() * -1;
                                    break;
                                }
                                int n17 = 0;
                                n17 = topoCommonEdge.getFirstFaceID() == topoFace.getID() ? topoCommonEdge.getSecondFaceID() : topoCommonEdge.getFirstFaceID();
                                topoFace = (TopoFace)this.edgeFaces.get(String.valueOf(n17));
                                n9 = n17;
                                n6 = topoFace.getNextEdgeID(topoCommonEdge.getID());
                                string = String.valueOf(Math.abs(n6));
                                topoEdge2 = (TopoEdge)topoFace.getEdges().get(String.valueOf(Math.abs(n6)));
                                break;
                            }
                            if (topoEdge2 == null) {
                                log.warning("Unable to close polygon for feature " + this.featID + " starting with edge " + n7);
                                n2 = 0;
                                continue;
                            }
                        }
                        n12 = dArray2.length;
                        if (n7 == Math.abs(n6)) {
                            if (Math.abs(dArray2[0] - dArray2[n12 - 2]) <= TopologyThemeProducer.this.def.getTolerance() && Math.abs(dArray2[1] - dArray2[n12 - 1]) <= TopologyThemeProducer.this.def.getTolerance()) {
                                bl2 = true;
                            } else {
                                log.warning("Unable to close polygon for feature " + this.featID + " starting with edge " + n7 + " : feature polygon discarded.");
                            }
                            n2 = 0;
                            continue;
                        }
                        if (n9 != n8) {
                            if (!((Vector)object3).contains(String.valueOf(topoFace.getID()))) {
                                ((Vector)object3).add(String.valueOf(topoFace.getID()));
                            }
                            n8 = n9;
                        }
                        if ((jSDOGeometry2 = topoEdge2.getGeometry()) == null) {
                            log.warning("Next edge (" + n6 + ") is not on face edge list. Face polygon discarded.");
                            bl2 = false;
                            break;
                        }
                        object6 = jSDOGeometry2.getOrdinatesArray();
                        int n18 = ((double[])object6).length;
                        if (bl3) {
                            if (n6 > 0 && !jSDOGeometry2.LoadedAndReoriented() && Math.abs(dArray2[0] - object6[0]) <= TopologyThemeProducer.this.def.getTolerance() && Math.abs(dArray2[1] - object6[1]) <= TopologyThemeProducer.this.def.getTolerance() || n6 > 0 && jSDOGeometry2.LoadedAndReoriented() && Math.abs(dArray2[0] - object6[n18 - 2]) <= TopologyThemeProducer.this.def.getTolerance() && Math.abs(dArray2[1] - object6[n18 - 1]) <= TopologyThemeProducer.this.def.getTolerance() || n6 < 0 && !jSDOGeometry2.LoadedAndReoriented() && Math.abs(dArray2[0] - object6[n18 - 2]) <= TopologyThemeProducer.this.def.getTolerance() && Math.abs(dArray2[1] - object6[n18 - 1]) <= TopologyThemeProducer.this.def.getTolerance() || n6 < 0 && jSDOGeometry2.LoadedAndReoriented() && Math.abs(dArray2[0] - object6[0]) <= TopologyThemeProducer.this.def.getTolerance() && Math.abs(dArray2[1] - object6[1]) <= TopologyThemeProducer.this.def.getTolerance()) {
                                n11 = dArray2.length;
                                for (int j = 0; j < (n11 - 2) / 2; j += 2) {
                                    double d = dArray2[j];
                                    double d2 = dArray2[j + 1];
                                    dArray2[j] = dArray2[n11 - 2 - j];
                                    dArray2[j + 1] = dArray2[n11 - 1 - j];
                                    dArray2[n11 - 2 - j] = d;
                                    dArray2[n11 - 1 - j] = d2;
                                }
                            }
                            bl3 = false;
                        }
                        double[] dArray3 = new double[dArray2.length];
                        System.arraycopy(dArray2, 0, dArray3, 0, dArray2.length);
                        dArray2 = null;
                        dArray2 = new double[dArray3.length + ((Object)object6).length - 2];
                        System.arraycopy(dArray3, 0, dArray2, 0, dArray3.length);
                        if (n6 > 0) {
                            if (!jSDOGeometry2.LoadedAndReoriented()) {
                                for (n10 = 2; n10 < ((Object)object6).length; ++n10) {
                                    dArray2[dArray3.length + n10 - 2] = (double)object6[n10];
                                }
                            } else {
                                for (n10 = 2; n10 < ((Object)object6).length; n10 += 2) {
                                    dArray2[dArray3.length + n10 - 2] = (double)object6[((Object)object6).length - 1 - n10 - 1];
                                    dArray2[dArray3.length + n10 - 1] = (double)object6[((Object)object6).length - 1 - n10];
                                }
                            }
                            n5 = 2;
                        } else {
                            if (jSDOGeometry2.LoadedAndReoriented()) {
                                for (n10 = 2; n10 < ((Object)object6).length; ++n10) {
                                    dArray2[dArray3.length + n10 - 2] = (double)object6[n10];
                                }
                            } else {
                                for (n10 = 2; n10 < ((Object)object6).length; n10 += 2) {
                                    dArray2[dArray3.length + n10 - 2] = (double)object6[((Object)object6).length - 1 - n10 - 1];
                                    dArray2[dArray3.length + n10 - 1] = (double)object6[((Object)object6).length - 1 - n10];
                                }
                            }
                            n5 = 1;
                        }
                        vector.add(string);
                        n3 = topoEdge2.getStartNodeID();
                        n4 = topoEdge2.getEndNodeID();
                        object5 = string;
                        n6 = topoFace.getNextEdgeID(Integer.parseInt(string));
                    }
                    if (bl2) {
                        object4 = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])dArray2, (int)2, (int)TopologyThemeProducer.this.def.getSrid()));
                        bl = false;
                        TopoFeatureGeometry topoFeatureGeometry = null;
                        block10: for (int j = 0; j < vector2.size(); ++j) {
                            topoFeatureGeometry = (TopoFeatureGeometry)vector2.get(j);
                            for (int k = 0; k < ((Vector)object3).size(); ++k) {
                                if (!topoFeatureGeometry.faceIn((String)((Vector)object3).get(k))) continue;
                                topoFeatureGeometry.addPolygon((JSDOGeometry)object4, (Vector)object3);
                                bl = true;
                                continue block10;
                            }
                        }
                        if (!bl) {
                            topoFeatureGeometry = new TopoFeatureGeometry();
                            topoFeatureGeometry.addPolygon((JSDOGeometry)object4, (Vector)object3);
                            vector2.add(topoFeatureGeometry);
                        }
                    }
                    ((Vector)object3).clear();
                }
            }
            vector = this.polyFaces.elements();
            while (vector.hasMoreElements()) {
                int n19;
                object3 = (TopoFace)vector.nextElement();
                Vector vector4 = ((TopoFace)object3).getPolygons();
                if (vector4 == null || vector4.size() == 0) continue;
                object2 = new Vector();
                ((Vector)object2).add(String.valueOf(((TopoFace)object3).getID()));
                boolean bl = false;
                object = null;
                for (n19 = 0; n19 < vector2.size(); ++n19) {
                    object = (TopoFeatureGeometry)vector2.get(n19);
                    if (!((TopoFeatureGeometry)object).faceIn(String.valueOf(((TopoFace)object3).getID()))) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    object = new TopoFeatureGeometry();
                    vector2.add(object);
                }
                for (n19 = 0; n19 < vector4.size(); ++n19) {
                    JSDOGeometry jSDOGeometry = (JSDOGeometry)vector4.get(n19);
                    ((TopoFeatureGeometry)object).addPolygon(jSDOGeometry, (Vector)object2);
                }
            }
            vector = new Vector<Object>(10);
            for (int i = 0; i < vector2.size(); ++i) {
                TopoFeatureGeometry topoFeatureGeometry = (TopoFeatureGeometry)vector2.get(i);
                object2 = null;
                object2 = TopologyThemeProducer.this.def.getTopoLayerLevel() > 0 ? topoFeatureGeometry.getExternalGeometry() : topoFeatureGeometry.getGeometry();
                if (object2 == null) continue;
                vector.add(object2);
            }
            return vector;
        }

        public Vector getFeatureLines() {
            if (this.featType != 2) {
                return null;
            }
            Vector<Cloneable> vector = new Vector<Cloneable>(10);
            Vector<String> vector2 = new Vector<String>(10);
            if (this.edges.size() == 0 || this.nodes.size() == 0) {
                return null;
            }
            for (int i = 0; i < 2 && (i != 1 || this.edges.size() != vector2.size()); ++i) {
                Enumeration enumeration = this.edges.elements();
                while (enumeration.hasMoreElements()) {
                    int n;
                    Cloneable cloneable;
                    int n2;
                    TopoEdge topoEdge = (TopoEdge)enumeration.nextElement();
                    int n3 = topoEdge.getID();
                    if (topoEdge.getGeometry() == null) {
                        log.warning("Feature edge with null geometry.");
                        vector2.add(String.valueOf(n3));
                        continue;
                    }
                    if (vector2.contains(String.valueOf(n3))) continue;
                    int n4 = topoEdge.getStartNodeID();
                    int n5 = topoEdge.getEndNodeID();
                    TopoNode topoNode = this.getNode(n4);
                    TopoNode topoNode2 = this.getNode(n5);
                    if (i == 0 && topoNode.getNumberOfEdges() > 1 && topoNode2.getNumberOfEdges() > 1) continue;
                    if (n4 == 0 || n5 == 0 || topoNode.getNumberOfEdges() == 1 && topoNode2.getNumberOfEdges() == 1) {
                        vector.add(topoEdge.getGeometry());
                        vector2.add(String.valueOf(n3));
                        continue;
                    }
                    vector2.add(String.valueOf(n3));
                    int n6 = n3;
                    int n7 = 0;
                    int n8 = 0;
                    if (i == 0) {
                        if (topoNode.getNumberOfEdges() == 1) {
                            n7 = n4;
                            n8 = n5;
                        } else {
                            n7 = n5;
                            n8 = n4;
                        }
                    } else {
                        n7 = n4;
                        n8 = n5;
                    }
                    JSDOGeometry jSDOGeometry = topoEdge.getGeometry();
                    double[] dArray = jSDOGeometry.getOrdinatesArray();
                    double[] dArray2 = new double[dArray.length];
                    if (!jSDOGeometry.LoadedAndReoriented() && n7 == n4 || jSDOGeometry.LoadedAndReoriented() && n7 == n5) {
                        for (n2 = 0; n2 < dArray.length; ++n2) {
                            dArray2[n2] = dArray[n2];
                        }
                    } else {
                        for (n2 = 0; n2 < dArray.length; n2 += 2) {
                            dArray2[n2] = dArray[dArray.length - 1 - n2 - 1];
                            dArray2[n2 + 1] = dArray[dArray.length - 1 - n2];
                        }
                    }
                    Vector<String> vector3 = new Vector<String>(10);
                    vector3.add(String.valueOf(n7));
                    TopoNode topoNode3 = (TopoNode)this.nodes.get(String.valueOf(n8));
                    block4: while (topoNode3.getNumberOfEdges() > 1 && topoEdge != null && !vector3.contains(String.valueOf(n8))) {
                        cloneable = topoNode3.getEdges();
                        n = 0;
                        topoEdge = null;
                        for (int j = 0; j < ((Vector)cloneable).size(); ++j) {
                            int n9;
                            int n10 = Integer.parseInt(((Vector)cloneable).get(j).toString());
                            if (n10 == n6 || vector2.contains(String.valueOf(n10))) continue;
                            topoEdge = (TopoEdge)this.edges.get(String.valueOf(n10));
                            n = topoEdge.getID();
                            n4 = topoEdge.getStartNodeID();
                            n5 = topoEdge.getEndNodeID();
                            JSDOGeometry jSDOGeometry2 = topoEdge.getGeometry();
                            double[] dArray3 = jSDOGeometry2.getOrdinatesArray();
                            double[] dArray4 = new double[dArray2.length];
                            System.arraycopy(dArray2, 0, dArray4, 0, dArray2.length);
                            dArray2 = null;
                            dArray2 = new double[dArray4.length + dArray3.length - 2];
                            System.arraycopy(dArray4, 0, dArray2, 0, dArray4.length);
                            if (!jSDOGeometry2.LoadedAndReoriented() && n8 == n4 || jSDOGeometry2.LoadedAndReoriented() && n8 == n5) {
                                for (n9 = 2; n9 < dArray3.length; ++n9) {
                                    dArray2[dArray4.length + n9 - 2] = dArray3[n9];
                                }
                            } else {
                                for (n9 = 2; n9 < dArray3.length; n9 += 2) {
                                    dArray2[dArray4.length + n9 - 2] = dArray3[dArray3.length - 1 - n9 - 1];
                                    dArray2[dArray4.length + n9 - 1] = dArray3[dArray3.length - 1 - n9];
                                }
                            }
                            vector2.add(String.valueOf(n));
                            vector3.add(String.valueOf(n8));
                            n8 = n8 == n4 ? n5 : n4;
                            topoNode3 = (TopoNode)this.nodes.get(String.valueOf(n8));
                            n6 = n;
                            continue block4;
                        }
                    }
                    if (dArray2 == null) continue;
                    if (TopologyThemeProducer.this.getTheme().getDecorator().isReorientLines() && dArray2[0] > dArray2[dArray2.length - 2]) {
                        int n11 = dArray2.length;
                        for (n = 0; n < (n11 - 2) / 2; n += 2) {
                            double d = dArray2[n];
                            double d2 = dArray2[n + 1];
                            dArray2[n] = dArray2[n11 - 2 - n];
                            dArray2[n + 1] = dArray2[n11 - 1 - n];
                            dArray2[n11 - 2 - n] = d;
                            dArray2[n11 - 1 - n] = d2;
                        }
                    }
                    cloneable = JSDOGeometry.recast(JSDOGeometry.createLinearLineString((double[])dArray2, (int)2, (int)TopologyThemeProducer.this.def.getSrid()));
                    vector.add(cloneable);
                }
            }
            return vector;
        }
    }

    private class TopoFace {
        int faceID = 0;
        Vector facePolygons = new Vector(10);
        Vector facePolygonsEdges = new Vector(10);
        Vector faceoffsetPolygons = new Vector(10);
        Vector faceoffsetPolygonsEdges = new Vector(10);
        Hashtable edgeNextEdge = new Hashtable();
        Hashtable topoEdges = new Hashtable();
        Hashtable topoNodes = new Hashtable();

        public TopoFace(int n) {
            this.faceID = n;
        }

        public int getID() {
            return this.faceID;
        }

        public void addFacePolygon(int n, int n2, int n3, JSDOGeometry jSDOGeometry) {
            TopoEdge topoEdge = new TopoEdge(n, this.faceID);
            topoEdge.setSequenceEdges(n2, n3);
            this.facePolygonsEdges.add(topoEdge);
            this.facePolygons.add(jSDOGeometry);
        }

        public void addFaceOffsetPolygon(int n, int n2, int n3, JSDOGeometry jSDOGeometry) {
            TopoEdge topoEdge = new TopoEdge(n, this.faceID);
            topoEdge.setSequenceEdges(n2, n3);
            this.faceoffsetPolygonsEdges.add(topoEdge);
            this.faceoffsetPolygons.add(jSDOGeometry);
        }

        public void removeFacePolygon(int n) {
            if (n < 0 || n > this.facePolygons.size() - 1) {
                return;
            }
            this.facePolygonsEdges.remove(n);
            this.facePolygons.remove(n);
        }

        public Vector getFacePolygonsEdges() {
            return this.facePolygonsEdges;
        }

        public Vector getFaceOffsetPolygonsEdges() {
            return this.faceoffsetPolygonsEdges;
        }

        public int getNumberOfFacePolygons() {
            return this.facePolygons.size();
        }

        public int getNumberOfFaceOffsetPolygons() {
            return this.faceoffsetPolygons.size();
        }

        public boolean addEdge(int n, int n2, int n3, int n4, int n5, JSDOGeometry jSDOGeometry) {
            TopoEdge topoEdge = new TopoEdge(n, this.faceID);
            topoEdge.setNodes(n2, n3);
            topoEdge.setFaces(n4, n5);
            topoEdge.setGeometry(jSDOGeometry);
            this.topoEdges.put(String.valueOf(n), topoEdge);
            TopoNode topoNode = (TopoNode)this.topoNodes.get(String.valueOf(n2));
            if (topoNode == null) {
                topoNode = new TopoNode(n2);
                this.topoNodes.put(String.valueOf(n2), topoNode);
            }
            topoNode.addEdge(n);
            TopoNode topoNode2 = (TopoNode)this.topoNodes.get(String.valueOf(n3));
            if (topoNode2 == null) {
                topoNode2 = new TopoNode(n3);
                this.topoNodes.put(String.valueOf(n3), topoNode2);
            }
            topoNode2.addEdge(n);
            return true;
        }

        public void addNextEdge(int n, int n2) {
            this.edgeNextEdge.put(String.valueOf(n), new Integer(n2));
        }

        public Hashtable getEdges() {
            return this.topoEdges;
        }

        public Hashtable getNodes() {
            return this.topoNodes;
        }

        public Vector getPolygons() {
            return this.facePolygons;
        }

        public Vector getOffsetPolygons() {
            return this.faceoffsetPolygons;
        }

        public int getNumberOfEdges() {
            return this.topoEdges.size();
        }

        public JSDOGeometry getEdgeGeometry(int n) {
            TopoEdge topoEdge = (TopoEdge)this.topoEdges.get(String.valueOf(n));
            if (topoEdge == null) {
                return null;
            }
            return topoEdge.getGeometry();
        }

        public int getNextEdgeID(int n) {
            Integer n2 = (Integer)this.edgeNextEdge.get(String.valueOf(n));
            return n2;
        }
    }

    private class TopoCommonEdge
    extends TopoEdge {
        int firstFaceID;
        int scndFaceID;

        public TopoCommonEdge(int n) {
            this.firstFaceID = 0;
            this.scndFaceID = 0;
            this.edgeID = n;
        }

        public int getFirstFaceID() {
            return this.firstFaceID;
        }

        public int getSecondFaceID() {
            return this.scndFaceID;
        }

        public void setFirstFaceID(int n) {
            this.firstFaceID = n;
        }

        public void setSecondFaceID(int n) {
            this.scndFaceID = n;
        }
    }

    private class TopoEdge {
        int edgeID = 0;
        int faceID = 0;
        int leftFaceID = 0;
        int rightFaceID = 0;
        int startNodeID = 0;
        int endNodeID = 0;
        int nextEdgeId = 0;
        int prevEdgeId = 0;
        JSDOGeometry geom = null;

        public TopoEdge() {
        }

        public TopoEdge(int n) {
            this.edgeID = n;
        }

        public TopoEdge(int n, int n2) {
            this.edgeID = n;
            this.faceID = n2;
        }

        public void setFaceId(int n) {
            this.faceID = n;
        }

        public int getFaceId() {
            return this.faceID;
        }

        public void setNodes(int n, int n2) {
            this.startNodeID = n;
            this.endNodeID = n2;
        }

        public void setFaces(int n, int n2) {
            this.leftFaceID = n;
            this.rightFaceID = n2;
        }

        public void setSequenceEdges(int n, int n2) {
            this.prevEdgeId = n;
            this.nextEdgeId = n2;
        }

        public int getPreviousEdge() {
            return this.prevEdgeId;
        }

        public int getNextEdge() {
            return this.nextEdgeId;
        }

        public int getID() {
            return this.edgeID;
        }

        public int getLeftFaceID() {
            return this.leftFaceID;
        }

        public int getRightFaceID() {
            return this.rightFaceID;
        }

        public void setLeftFaceID(int n) {
            this.leftFaceID = n;
        }

        public void setRightFaceID(int n) {
            this.rightFaceID = n;
        }

        public int getStartNodeID() {
            return this.startNodeID;
        }

        public int getEndNodeID() {
            return this.endNodeID;
        }

        public void setGeometry(JSDOGeometry jSDOGeometry) {
            this.geom = jSDOGeometry;
        }

        public JSDOGeometry getGeometry() {
            return this.geom;
        }
    }

    private class TopoNode {
        int nodeID = 0;
        Vector edgesID = new Vector(3);
        JSDOGeometry geom = null;

        public TopoNode(int n) {
            this.nodeID = n;
        }

        public int getID() {
            return this.nodeID;
        }

        public Vector getEdges() {
            return this.edgesID;
        }

        public void addEdge(int n) {
            this.edgesID.add(String.valueOf(n));
        }

        public int getNumberOfEdges() {
            return this.edgesID.size();
        }

        public void setGeometry(JSDOGeometry jSDOGeometry) {
            this.geom = jSDOGeometry;
        }

        public JSDOGeometry getGeometry() {
            return this.geom;
        }
    }
}

