/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.mapviewer.share.ThemeStyleInfo;
import oracle.mapviewer.share.theme.ThemeDecorator;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.MapMaker;
import oracle.sdovis.PredefinedGeometryTheme;
import oracle.sdovis.RSBundle;
import oracle.sdovis.Theme;
import oracle.sdovis.ThemeCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.Style;
import oracle.sdovis.stylex.HeatMapStyle;
import oracle.sdovis.theme.PredGeomThemeDefinition;
import oracle.sdovis.theme.ThemeDefinition;

public class ThemeUtils {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);

    public static Theme loadPredefinedGeometryTheme(String string, String string2, VisContext visContext) throws SQLException {
        string = string.toUpperCase();
        PredefinedGeometryTheme predefinedGeometryTheme = null;
        ThemeDefinition themeDefinition = null;
        ThemeCache themeCache = null;
        AbstractDBDataSource abstractDBDataSource = (AbstractDBDataSource)DSManager.get(string2);
        themeCache = abstractDBDataSource.getThemeCache();
        themeDefinition = themeCache.getOrLoadThemeDefinition(string);
        if (themeDefinition == null) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01002") + " [" + string + "]");
            return null;
        }
        ThemeDecorator themeDecorator = new ThemeDecorator();
        themeDecorator.setLabelAlwaysOn(false);
        String string3 = themeDefinition.getThemeType();
        if (!"GEOM_PREDEFINED".equals(string3)) {
            log.severe("Invalid theme type found. Requires simple predefined geometry theme ");
            return null;
        }
        PredGeomThemeDefinition predGeomThemeDefinition = (PredGeomThemeDefinition)themeDefinition;
        predefinedGeometryTheme = new PredefinedGeometryTheme(string, predGeomThemeDefinition, null);
        predefinedGeometryTheme.setDecorator(themeDecorator);
        return predefinedGeometryTheme;
    }

    public static boolean isHeatMapTheme(ThemeDefinition themeDefinition, VisContext visContext) {
        ThemeStyleInfo[] themeStyleInfoArray = themeDefinition.getStyleList(visContext);
        if (themeStyleInfoArray == null) {
            return false;
        }
        for (int i = 0; i < themeStyleInfoArray.length; ++i) {
            String string;
            Style style;
            ThemeStyleInfo themeStyleInfo = themeStyleInfoArray[i];
            if (!themeStyleInfo.isRendering() || (style = MapMaker.getStyleWithName(string = themeStyleInfo.getName(), themeDefinition.getDataSourceName(), visContext)) == null || !(style instanceof HeatMapStyle)) continue;
            return true;
        }
        return false;
    }
}

