/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.ThemeStyleInfo;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisConstants;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.Style;
import oracle.sdovis.theme.BasicThemeInfo;

public abstract class ThemeDefinition
implements Serializable,
VisConstants {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    public static final String THEME_TYPE_LOCAL = "LOCAL";
    public static final String THEME_TYPE_GEOMETRY = "GEOMETRY";
    public static final String THEME_TYPE_DEFAULT = "GEOMETRY";
    public static final String THEME_TYPE_IMAGE = "IMAGE";
    public static final String THEME_TYPE_GEORASTER = "GEORASTER";
    public static final String THEME_TYPE_SHADED_RELIEF = "SHADED_RELIEF";
    public static final String THEME_TYPE_NETWORK = "NETWORK";
    public static final String THEME_TYPE_TOPOLOGY = "TOPOLOGY";
    public static final String THEME_TYPE_GEOM_PREDEFINED = "GEOM_PREDEFINED";
    public static final String THEME_TYPE_GEOM_DYNAMIC = "GEOM_DYNAMIC";
    public static final String THEME_TYPE_WMS = "WMS";
    public static final String THEME_TYPE_WFS = "WFS";
    public static final String THEME_TYPE_GEOM_CUSTOM = "GEOM_CUSTOM";
    public static final String THEME_TYPE_ANNOTATION_TEXT = "ANNOTATION";
    public static final String THEME_TYPE_GEOM_FILE = "GEOM_FILE";
    protected String name = null;
    protected String description = null;
    protected String dataSource = null;
    protected int srid = 0;
    protected boolean is9i = false;
    protected Hashtable customTags = new Hashtable();
    protected int fetchSize = 100;
    protected String resourceClassName;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDataSourceName() {
        return this.dataSource;
    }

    public void setDataSourceName(String string) {
        this.dataSource = string;
    }

    public int getSrid() {
        return this.srid;
    }

    public void setSrid(int n) {
        this.srid = n;
    }

    public String getThemeType() {
        return THEME_TYPE_LOCAL;
    }

    public boolean is9i() {
        return this.is9i;
    }

    public void set9i(boolean bl) {
        this.is9i = bl;
    }

    public abstract String getXMLDefinition();

    public Hashtable getCustomTags() {
        return this.customTags;
    }

    public void setCustomTags(Hashtable hashtable) {
        this.customTags = hashtable == null ? new Hashtable() : hashtable;
    }

    public String getCustomTag(String string) {
        if (string == null || this.customTags.size() == 0) {
            return null;
        }
        return (String)this.customTags.get(string);
    }

    public void addCustomTag(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        this.customTags.put(string, string2);
    }

    public void removeCustomTag(String string) {
        if (string == null) {
            return;
        }
        this.customTags.remove(string);
    }

    public int getNumberOfCustomtags() {
        return this.customTags.size();
    }

    public void clearCustomTags() {
        this.customTags.clear();
    }

    public abstract BasicThemeInfo getBasicThemeInfo();

    public abstract String[] getRenderingStyles();

    public abstract String[] getLabelingStyles();

    public ThemeStyleInfo[] getStyleList(VisContext visContext) {
        String[] stringArray;
        Object object;
        if (this.dataSource == null) {
            return null;
        }
        StyleCache styleCache = DSManager.getStyleCache(this.dataSource);
        if (styleCache == null) {
            log.warning("cannot locate the style cache for datasource: " + this.dataSource);
            return null;
        }
        Vector<Object> vector = new Vector<Object>();
        String[] stringArray2 = this.getRenderingStyles();
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                Style style = null;
                if (visContext != null) {
                    style = visContext.getDynamicStyle(stringArray2[i]);
                }
                if (style == null) {
                    style = styleCache.get(stringArray2[i]);
                    if (style != null) continue;
                    log.warning("render style cannot be found [" + stringArray2[i] + "].");
                    continue;
                }
                object = new ThemeStyleInfo(stringArray2[i]);
                ((ThemeStyleInfo)object).setRendering(true);
                ((ThemeStyleInfo)object).setType(style.getModel().getTypeName());
                ((ThemeStyleInfo)object).setDescription(style.getModel().getDescription());
                vector.add(object);
            }
        }
        if ((stringArray = this.getLabelingStyles()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                object = null;
                if (visContext != null) {
                    object = visContext.getDynamicStyle(stringArray[i]);
                }
                if (object == null) {
                    object = styleCache.get(stringArray[i]);
                    if (object != null) continue;
                    log.warning("label style cannot be found [" + stringArray[i] + "].");
                    continue;
                }
                ThemeStyleInfo themeStyleInfo = new ThemeStyleInfo(stringArray[i]);
                themeStyleInfo.setLabeling(true);
                themeStyleInfo.setType(object.getModel().getTypeName());
                themeStyleInfo.setDescription(object.getModel().getDescription());
                vector.add(themeStyleInfo);
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector.toArray(new ThemeStyleInfo[vector.size()]);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int n) {
        this.fetchSize = n < 1 ? 100 : n;
    }

    public void setResourceClassName(String string) {
        this.resourceClassName = string;
    }

    public String getResourceClassName() {
        return this.resourceClassName;
    }
}

