/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SphereCG;
import oracle.sdovis.CacheMgr2;
import oracle.sdovis.DataException;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.Proj;
import oracle.sdovis.RSBundle;
import oracle.sdovis.SRS;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.cache.CacheGroup;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.theme.LocalThemeDataProducer;
import oracle.sdovis.theme.NetworkThemeDefinition;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.util.JDBCUtil;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.network.Link;
import oracle.spatial.network.MBR;
import oracle.spatial.network.Network;
import oracle.spatial.network.NetworkFactory;
import oracle.spatial.network.NetworkManager;
import oracle.spatial.network.Path;

public class NetworkThemeProducer
implements ThemeDataProducer {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static final int YIELD_COUNT = 20;
    protected Theme owner;
    protected NetworkThemeDefinition def;
    LocalThemeDataProducer features;
    int visSRID = 0;
    String dbVersion = null;
    double viewResX = Double.MIN_VALUE;
    double viewResY = Double.MIN_VALUE;
    double swxl = Double.MIN_VALUE;
    double swxh = Double.MAX_VALUE;
    double swyl = Double.MIN_VALUE;
    double swyh = Double.MAX_VALUE;
    boolean applyRotation = false;

    public NetworkThemeProducer(Theme theme) {
        this.owner = theme;
        this.def = (NetworkThemeDefinition)theme.getDefinition();
    }

    public Theme getTheme() {
        return this.owner;
    }

    public void destroy() {
    }

    public void abort() {
    }

    public void setStyledFeatures(StyledFeatureI[] styledFeatureIArray) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(styledFeatureIArray);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public int prepareData(Rectangle2D var1_1, VisContext var2_2) throws DataException {
        block266: {
            block270: {
                block261: {
                    block271: {
                        block268: {
                            block269: {
                                block258: {
                                    block267: {
                                        if (this.def.getNetworkCategory() == null) {
                                            NetworkThemeProducer.log.severe(RSBundle.getMsg("MAPVIEWER-01043"));
                                            return 0;
                                        }
                                        if (this.def.getGeometryType() == null) {
                                            NetworkThemeProducer.log.severe(RSBundle.getMsg("MAPVIEWER-01044"));
                                            return 0;
                                        }
                                        if (!this.def.getNetworkCategory().equals("SPATIAL") || !this.def.getGeometryType().equals("SDO_GEOMETRY") && !this.def.getGeometryType().equals("LRS_GEOMETRY")) {
                                            NetworkThemeProducer.log.warning("Only 'SPATIAL' networks of type 'SDO_GEOMETRY'  or 'LRS_GEOMETRY' are supported in this version.");
                                            return 0;
                                        }
                                        var3_3 = null;
                                        try {
                                            var3_3 = DSUtil.getDBConnection(this.def.getDataSourceName(), var2_2);
                                        }
                                        catch (Exception var4_4) {
                                            throw new DataException("Cannot obtain a connection to database.");
                                        }
                                        if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                            try {
                                                if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                                    if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                                                        Util.gotoWorkspaceDate(var3_3, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceDate(), this.getTheme().getDecorator().getWorkspaceDateFormat(), this.getTheme().getDecorator().getWorkspaceDateNlsParam(), this.getTheme().getDecorator().isWorkspaceDateTsWtz());
                                                    } else if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                                                        Util.gotoWorkspaceSavedPoint(var3_3, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceSavedPoint());
                                                    } else {
                                                        Util.gotoWorkspace(var3_3, this.getTheme().getDecorator().getWorkspaceName());
                                                    }
                                                }
                                            }
                                            catch (Exception var4_5) {
                                                var5_7 = "Cannot go to workspace " + this.getTheme().getDecorator().getWorkspaceName();
                                                if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                                                    var5_7 = var5_7 + ", Date " + this.getTheme().getDecorator().getWorkspaceDate();
                                                } else if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                                                    var5_7 = var5_7 + ", Saved Point " + this.getTheme().getDecorator().getWorkspaceSavedPoint();
                                                }
                                                NetworkThemeProducer.log.log(Level.SEVERE, var5_7, var4_5);
                                                if (var3_3 != null) {
                                                    try {
                                                        DSUtil.closeDBConnection(var3_3, this.def.getDataSourceName());
                                                    }
                                                    catch (Exception var6_9) {
                                                        // empty catch block
                                                    }
                                                }
                                                throw new DataException(var5_7);
                                            }
                                        }
                                        this.visSRID = var2_2.getMasterSRID();
                                        var4_6 = null;
                                        var5_8 = null;
                                        var6_10 = 0;
                                        var7_11 = new ArrayList<StyledFeatureI>(128);
                                        var8_12 = new ArrayList<E>(128);
                                        var9_13 = DSManager.getSRSCache(this.def.getDataSourceName());
                                        var10_14 = var9_13.get(this.def.getSrid());
                                        var11_15 = false;
                                        var12_16 = null;
                                        if (var10_14 != null) {
                                            var11_15 = var10_14.isGeodetic();
                                            var12_16 = var10_14.getUnit();
                                        } else if (this.def.getSrid() > 0) {
                                            NetworkThemeProducer.log.warning("cannot locate an SRS object for srid: " + this.def.getSrid());
                                        }
                                        var13_17 = var1_1.getMinX();
                                        var15_18 = var1_1.getMinY();
                                        var17_19 = var1_1.getMaxX();
                                        var19_20 = var1_1.getMaxY();
                                        var21_21 = false;
                                        var22_22 = var13_17;
                                        var24_23 = var17_19;
                                        var26_24 = var15_18;
                                        var28_25 = var19_20;
                                        var30_26 = var2_2.getCurrentScale();
                                        this.getTheme().setShowLabels(true);
                                        if (var2_2.getMasterSRID() <= 0 || this.def.getSrid() <= 0 || this.def.getSrid() == var2_2.getMasterSRID()) break block267;
                                        if (this.def.isPredefined()) {
                                            this.def.createLinkCacheGroup(var2_2.getMasterSRID());
                                            this.def.createNodeCacheGroup(var2_2.getMasterSRID());
                                        }
                                        if (var30_26 == Infinity || var30_26 == -Infinity) ** GOTO lbl101
                                        var32_27 = new double[]{var13_17, var15_18, var17_19, var19_20};
                                        var33_30 = Util.convertMBR(var32_27, var2_2.getMasterSRID(), this.def.getSrid(), var3_3);
                                        if (var33_30 != null) {
                                            var13_17 = (double)var33_30[0];
                                            var15_18 = (double)var33_30[1];
                                            var17_19 = (double)var33_30[2];
                                            var19_20 = (double)var33_30[3];
                                            var21_21 = true;
                                        } else {
                                            NetworkThemeProducer.log.severe(RSBundle.getMsg("MAPVIEWER-01024"));
                                            if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                                try {
                                                    Util.gotoWorkspace(var3_3, "LIVE");
                                                }
                                                catch (Exception var34_31) {
                                                    NetworkThemeProducer.log.warning(var34_31.getMessage());
                                                }
                                            }
                                            try {
                                                if (var3_3 != null) {
                                                    DSUtil.closeDBConnection(var3_3, this.def.getDataSourceName());
                                                }
                                            }
                                            catch (Exception var34_32) {
                                                NetworkThemeProducer.log.warning(var34_32.getMessage());
                                            }
                                            return 0;
lbl101:
                                            // 1 sources

                                            var21_21 = true;
                                        }
                                    }
                                    if (var30_26 != Infinity && var30_26 != -Infinity) {
                                        var32_28 = Math.abs(var19_20 - var15_18) / Math.abs(var28_25 - var26_24);
                                        NetworkThemeProducer.log.finest("[Master scale] " + var30_26 + " [Scale factor for theme " + this.getTheme().getName() + "] " + var32_28);
                                        var34_33 = var30_26 * var32_28;
                                        if (this.getTheme().getDecorator().getScaleType() == "RATIO") {
                                            if (var2_2.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != var2_2.getMasterSRID() && var2_2.isTileRequest()) {
                                                var10_14 = var9_13.get(var2_2.getMasterSRID());
                                                var36_43 = (var22_22 + var24_23) / 2.0;
                                                var38_67 = (var26_24 + var28_25) / 2.0;
                                                var32_28 = 1.0;
                                            } else {
                                                var36_43 = (var13_17 + var17_19) / 2.0;
                                                var38_67 = (var15_18 + var19_20) / 2.0;
                                            }
                                            if (var2_2.isTileRequest() && var10_14.isGeodetic()) {
                                                var36_43 = 0.0;
                                                var38_67 = 0.0;
                                            }
                                            if (var10_14 != null) {
                                                var34_33 = var10_14.getRatioScale(var30_26 * var32_28, new Point2D.Double(var36_43, var38_67));
                                                NetworkThemeProducer.log.finer("Ratio scale to compare: " + var34_33);
                                            } else {
                                                NetworkThemeProducer.log.severe(RSBundle.getMsg("MAPVIEWER-01025"));
                                                if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                                    try {
                                                        Util.gotoWorkspace(var3_3, "LIVE");
                                                    }
                                                    catch (Exception var40_75) {
                                                        // empty catch block
                                                    }
                                                }
                                                try {
                                                    if (var3_3 != null) {
                                                        DSUtil.closeDBConnection(var3_3, this.def.getDataSourceName());
                                                    }
                                                }
                                                catch (Exception var40_76) {
                                                    NetworkThemeProducer.log.warning(var40_76.getMessage());
                                                }
                                                return 0;
                                            }
                                        }
                                        if (!this.getTheme().getDecorator().withinScaleLimits(var34_33)) {
                                            NetworkThemeProducer.log.warning("Scale definition for theme " + this.getTheme().getName() + " is out of range.");
                                            if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                                try {
                                                    Util.gotoWorkspace(var3_3, "LIVE");
                                                }
                                                catch (Exception var36_44) {
                                                    NetworkThemeProducer.log.warning(var36_44.getMessage());
                                                }
                                            }
                                            try {
                                                if (var3_3 != null) {
                                                    DSUtil.closeDBConnection(var3_3, this.def.getDataSourceName());
                                                }
                                            }
                                            catch (Exception var36_45) {
                                                NetworkThemeProducer.log.warning(var36_45.getMessage());
                                            }
                                            return 0;
                                        }
                                        if (!this.getTheme().getDecorator().withinLabelScaleLimits(var34_33)) {
                                            NetworkThemeProducer.log.info("Label Scale definition for theme " + this.getTheme().getName() + " is out of range. Labels will not be rendered.");
                                            this.getTheme().setShowLabels(false);
                                        }
                                    }
                                    var32_29 = false;
                                    v0 = var32_29 = var11_15 != false && var17_19 - var13_17 >= 2.0 && var17_19 - var13_17 < 120.0;
                                    if (var32_29) {
                                        var13_17 = Math.floor(var13_17);
                                        NetworkThemeProducer.log.finest("ptvpxfmfxed: xl=" + var13_17);
                                    }
                                    var33_30 = var2_2.getProjection();
                                    this.viewResX = var2_2.getDeviceWindow().getWidth();
                                    this.viewResY = var2_2.getDeviceWindow().getHeight();
                                    this.dbVersion = Util.getDBVersion(var3_3);
                                    NetworkThemeProducer.log.finest("[ " + this.def.getName() + " ]:  " + var13_17 + "," + var15_18 + "," + var17_19 + "," + var19_20);
                                    this.swxl = var13_17;
                                    this.swxh = var17_19;
                                    this.swyl = var15_18;
                                    this.swyh = var19_20;
                                    this.applyRotation = false;
                                    if (MapMaker.isSpecial(var13_17, var15_18, var17_19, var19_20) && var2_2.getRotation() != 0.0) {
                                        NetworkThemeProducer.log.warning("Rotation is currently ignored for full extent.");
                                    } else if (var2_2.getRotation() != 0.0 && !MapMaker.isSpecial(var13_17, var15_18, var17_19, var19_20)) {
                                        if (var2_2.getRotation() < -360.0 || var2_2.getRotation() > 360.0) {
                                            NetworkThemeProducer.log.warning("Rotation value must be in between -360 to 360 degrees. ignored");
                                        } else {
                                            var34_34 = Util.rotateMBR(var13_17, var15_18, var17_19, var19_20, var2_2.getRotation());
                                            if (var34_34 != null) {
                                                var13_17 = Math.min(var34_34[0], var13_17);
                                                var15_18 = Math.min(var34_34[1], var15_18);
                                                var17_19 = Math.max(var34_34[2], var17_19);
                                                var19_20 = Math.max(var34_34[3], var19_20);
                                                NetworkThemeProducer.log.finest("Rotation angle: " + var2_2.getRotation());
                                                NetworkThemeProducer.log.finest("Search window for rotation: " + var13_17 + "," + var15_18 + "," + var17_19 + "," + var19_20);
                                                this.applyRotation = true;
                                                this.swxl = var13_17;
                                                this.swxh = var17_19;
                                                this.swyl = var15_18;
                                                this.swyh = var19_20;
                                            } else {
                                                NetworkThemeProducer.log.info("Rotated MBR is null. Rotation ignored.");
                                            }
                                        }
                                    }
                                    if (var21_21) {
                                        this.swxl = var22_22;
                                        this.swxh = var24_23;
                                        this.swyl = var26_24;
                                        this.swyh = var28_25;
                                    }
                                    if (this.def.getLinkQuery() != null) {
                                        var34_35 = null;
                                        try {
                                            if (this.def.getGeometryType().equals("SDO_GEOMETRY")) {
                                                var34_35 = this.rewriteLinkQuery(var21_21, var13_17, var15_18, var17_19, var19_20, var11_15);
                                                if (var34_35 != null) {
                                                    NetworkThemeProducer.log.finest("[Geometry Network link query]:  " + var34_35);
                                                    var6_10 = this.processGeomLinkQuery(var3_3, var34_35, var7_11, var8_12, var6_10, (Proj)var33_30, var2_2, var21_21, var13_17, var15_18, var17_19, var19_20);
                                                }
                                            } else {
                                                var34_35 = this.getLRSDirectionQuery(var21_21, var13_17, var15_18, var17_19, var19_20, var11_15);
                                                if (var34_35 != null) {
                                                    NetworkThemeProducer.log.finest("[LRS Network link query]:  " + var34_35);
                                                    var6_10 = (this.def.getLinkLabelStyle() == null || this.def.getLinkLabelColumn() == null) && this.def.getDirectionStyle() == null && this.def.getBiDirectionStyle() == null ? this.processGeomLinkQuery(var3_3, var34_35, var7_11, var8_12, var6_10, (Proj)var33_30, var2_2, var21_21, var13_17, var15_18, var17_19, var19_20) : this.processLRSLinkQuery(var3_3, var34_35, var7_11, var8_12, var6_10, (Proj)var33_30, var2_2, var21_21);
                                                }
                                            }
                                        }
                                        catch (Exception var35_79) {
                                            if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                                try {
                                                    Util.gotoWorkspace(var3_3, "LIVE");
                                                }
                                                catch (Exception var36_46) {
                                                    NetworkThemeProducer.log.warning(var36_46.getMessage());
                                                }
                                            }
                                            try {
                                                if (var3_3 != null) {
                                                    DSUtil.closeDBConnection(var3_3, this.def.getDataSourceName());
                                                }
                                            }
                                            catch (Exception var36_47) {
                                                NetworkThemeProducer.log.warning(var36_47.getMessage());
                                            }
                                            throw new DataException(var35_79);
                                        }
                                    }
                                    if (this.def.getPathQueries() != null) {
                                        var34_36 = this.def.getPathQueries();
                                        var35_80 /* !! */  = this.def.getPathIds();
                                        for (var36_48 = 0; var36_48 < var34_36.length; ++var36_48) {
                                            if (var34_36[var36_48] == null) continue;
                                            var37_84 = this.rewritePathQuery(var36_48, var21_21, var13_17, var15_18, var17_19, var19_20, var11_15);
                                            NetworkThemeProducer.log.finest("[Network path query][path_id=" + var35_80 /* !! */ [var36_48] + "] " + var37_84);
                                            try {
                                                var38_68 = this.def.getPathStyles();
                                                var39_91 = false;
                                                if (this.def.getPathLabelStyle() != null && this.def.getPathLabelColumn() != null) {
                                                    var39_91 = this.def.getGeometryType().equals("SDO_GEOMETRY") != false ? 2 != 0 : 5 != 0;
                                                }
                                                if (this.def.getGeometryType().equals("SDO_GEOMETRY")) {
                                                    var6_10 = this.processPathQuery(var3_3, var37_84, var38_68[var36_48], this.def.getPathLabelStyle(), (int)var39_91, var7_11, var6_10, (Proj)var33_30, var2_2);
                                                    continue;
                                                }
                                                var6_10 = this.processLRSPathQuery(var3_3, var37_84, var38_68[var36_48], this.def.getPathLabelStyle(), (int)var39_91, var7_11, var6_10, (Proj)var33_30, var2_2);
                                                continue;
                                            }
                                            catch (Exception var38_69) {
                                                if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                                    try {
                                                        Util.gotoWorkspace(var3_3, "LIVE");
                                                    }
                                                    catch (Exception var39_92) {
                                                        NetworkThemeProducer.log.warning(var39_92.getMessage());
                                                    }
                                                }
                                                try {
                                                    if (var3_3 != null) {
                                                        DSUtil.closeDBConnection(var3_3, this.def.getDataSourceName());
                                                    }
                                                }
                                                catch (Exception var39_93) {
                                                    NetworkThemeProducer.log.warning(var39_93.getMessage());
                                                }
                                                throw new DataException(var38_69);
                                            }
                                        }
                                    }
                                    if (this.def.getShortestPathAlgorithm() == null || !this.def.getShortestPathAlgorithm().equalsIgnoreCase("DIJKSTRA") && !this.def.getShortestPathAlgorithm().equalsIgnoreCase("ASEARCH")) break block268;
                                    var34_37 = null;
                                    if (this.isFullExtent(this.def.getASIS(), var13_17, var15_18, var17_19, var19_20)) {
                                        var34_37 = this.runShortestPathAnalysis(var3_3, null);
                                    } else {
                                        var35_80 /* !! */  = (int[])new double[2];
                                        var35_80 /* !! */ [0] = (int)var13_17;
                                        var35_80 /* !! */ [1] = (int)var15_18;
                                        var36_49 = new double[]{var17_19, var19_20};
                                        var37_84 = NetworkFactory.createMBR((double[])var35_80 /* !! */ , (double[])var36_49);
                                        var34_37 = this.runShortestPathAnalysis(var3_3, (MBR)var37_84);
                                    }
                                    if (var34_37 == null) break block269;
                                    var35_80 /* !! */  = (int[])JSDOGeometry.recast(JSDOGeometry.createLinearLineString((double[])var34_37, (int)2, (int)this.def.getSrid()));
                                    if (var21_21) {
                                        block256: {
                                            var36_50 = "NULL";
                                            if (this.def.getSrid() != 0) {
                                                var36_50 = String.valueOf(this.def.getSrid());
                                            }
                                            var37_84 = "MDSYS.SDO_GEOMETRY(2002, " + var36_50 + ", NULL, " + "MDSYS.SDO_ELEM_INFO_ARRAY(1, 2, 1), " + "MDSYS.SDO_ORDINATE_ARRAY(";
                                            for (var38_70 = 0; var38_70 < var34_37.length; ++var38_70) {
                                                var37_84 = var38_70 > 0 ? var37_84 + "," + var34_37[var38_70] : var37_84 + var34_37[var38_70];
                                            }
                                            var37_84 = var37_84 + "))";
                                            var38_71 = "select sdo_cs.transform(" + var37_84 + "," + var2_2.getMasterSRID() + ") from dual";
                                            var5_8 = var3_3.prepareStatement(var38_71);
                                            var4_6 = var5_8.executeQuery();
                                            var39_91 = this.getTheme().getDecorator().isFastUnpickle();
                                            var35_80 /* !! */  = (int[])JDBCUtil.loadGeometry(var4_6, 1, var39_91);
                                            var42_99 = null;
                                            if (this.getTheme().getDecorator().getWorkspaceName() == null) break block256;
                                            try {
                                                Util.gotoWorkspace(var3_3, "LIVE");
                                            }
                                            catch (Exception var43_101) {
                                                NetworkThemeProducer.log.warning(var43_101.getMessage());
                                            }
                                        }
                                        try {
                                            if (var4_6 != null) {
                                                var4_6.close();
                                            }
                                        }
                                        catch (Exception var43_101) {
                                            NetworkThemeProducer.log.warning(var43_101.getMessage());
                                        }
                                        try {
                                            if (var5_8 != null) {
                                                var5_8.close();
                                            }
                                            break block258;
                                        }
                                        catch (Exception var43_101) {
                                            NetworkThemeProducer.log.warning(var43_101.getMessage());
                                        }
                                        break block258;
                                        {
                                            catch (Exception var39_94) {
                                                NetworkThemeProducer.log.warning(var39_94.getMessage());
                                                try {
                                                    if (var3_3 != null) {
                                                        DSUtil.closeDBConnection(var3_3, this.def.getDataSourceName());
                                                    }
                                                }
                                                catch (Exception var40_77) {
                                                    NetworkThemeProducer.log.warning(var40_77.getMessage());
                                                }
                                                throw new DataException(var39_94);
                                            }
                                        }
                                        catch (Throwable var41_105) {
                                            var42_100 = null;
                                            if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                                try {
                                                    Util.gotoWorkspace(var3_3, "LIVE");
                                                }
                                                catch (Exception var43_102) {
                                                    NetworkThemeProducer.log.warning(var43_102.getMessage());
                                                }
                                            }
                                            try {
                                                if (var4_6 != null) {
                                                    var4_6.close();
                                                }
                                            }
                                            catch (Exception var43_102) {
                                                NetworkThemeProducer.log.warning(var43_102.getMessage());
                                            }
                                            try {
                                                if (var5_8 != null) {
                                                    var5_8.close();
                                                }
                                            }
                                            catch (Exception var43_102) {
                                                NetworkThemeProducer.log.warning(var43_102.getMessage());
                                            }
                                            throw var41_105;
                                        }
                                    }
                                }
                                var36_51 = this.getNewStyledFeatureInstance();
                                var37_85 = true;
                                if (var33_30 != null) {
                                    var38_72 = var33_30.getOpposite();
                                    if (var35_80 /* !! */ .pointInPolygon(var38_72.x, var38_72.y)) {
                                        var37_85 = false;
                                    } else {
                                        if (this.applyRotation && (var39_95 = Util.rotateGeometry((JGeometry)var35_80 /* !! */ , (this.swxl + this.swxh) / 2.0, (this.swyl + this.swyh) / 2.0, var2_2.getRotation())) != null) {
                                            var35_80 /* !! */  = (int[])JSDOGeometry.recast(var39_95);
                                        }
                                        if ((var35_80 /* !! */  = (int[])var2_2.getSrs().shift((JSDOGeometry)var35_80 /* !! */ , var2_2.getQueryWindow())) != null) {
                                            var35_80 /* !! */  = (int[])SRS.proj((JSDOGeometry)var35_80 /* !! */ , (Proj)var33_30, 0);
                                        }
                                    }
                                }
                                if (var37_85 && var35_80 /* !! */  != null) {
                                    var36_51.setGeometry((JSDOGeometry)var35_80 /* !! */ );
                                    var36_51.setDataSource(this.def.getDataSourceName());
                                    var36_51.setFeatureStyleName(this.def.getShortestPathStyle());
                                    var7_11.add(var36_51);
                                    if (++var6_10 % 20 == 0) {
                                        Thread.currentThread();
                                        Thread.yield();
                                    }
                                }
                            }
                            if (this.def.getShortestPathStartStyle() != null) {
                                try {
                                    if (this.def.getGeometryType().equals("SDO_GEOMETRY")) {
                                        var35_80 /* !! */  = (int[])this.getStyleNodeQuery(var21_21, this.def.getShortestPathStartNode());
                                        if (var35_80 /* !! */  != null) {
                                            NetworkThemeProducer.log.finest("[Start node style query]:  " + (String)var35_80 /* !! */ );
                                            var6_10 = this.processQuery(var3_3, (String)var35_80 /* !! */ , this.def.getShortestPathStartStyle(), null, 0, var7_11, var6_10, (Proj)var33_30, var2_2);
                                        }
                                    } else if (this.def.getGeometryType().equals("LRS_GEOMETRY") && (var35_80 /* !! */  = (int[])this.getLRSNodeGeometry(var3_3, var21_21, this.def.getShortestPathStartNode(), (Proj)var33_30, var2_2)) != null) {
                                        var36_52 = this.getNewStyledFeatureInstance();
                                        var36_52.setGeometry((JSDOGeometry)var35_80 /* !! */ );
                                        var36_52.setFeatureStyleName(this.def.getShortestPathStartStyle());
                                        var36_52.setDataSource(this.def.getDataSourceName());
                                        var7_11.add(var36_52);
                                    }
                                }
                                catch (Exception var35_81) {
                                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                        try {
                                            Util.gotoWorkspace(var3_3, "LIVE");
                                        }
                                        catch (Exception var36_53) {
                                            NetworkThemeProducer.log.warning(var36_53.getMessage());
                                        }
                                    }
                                    try {
                                        if (var3_3 != null) {
                                            DSUtil.closeDBConnection(var3_3, this.def.getDataSourceName());
                                        }
                                    }
                                    catch (Exception var36_54) {
                                        NetworkThemeProducer.log.warning(var36_54.getMessage());
                                    }
                                    throw new DataException(var35_81);
                                }
                            }
                            if (this.def.getShortestPathEndStyle() != null) {
                                try {
                                    if (this.def.getGeometryType().equals("SDO_GEOMETRY")) {
                                        var35_80 /* !! */  = (int[])this.getStyleNodeQuery(var21_21, this.def.getShortestPathEndNode());
                                        if (var35_80 /* !! */  != null) {
                                            NetworkThemeProducer.log.finest("[End node style query]:  " + (String)var35_80 /* !! */ );
                                            var6_10 = this.processQuery(var3_3, (String)var35_80 /* !! */ , this.def.getShortestPathEndStyle(), null, 0, var7_11, var6_10, (Proj)var33_30, var2_2);
                                        }
                                    } else if (this.def.getGeometryType().equals("LRS_GEOMETRY") && (var35_80 /* !! */  = (int[])this.getLRSNodeGeometry(var3_3, var21_21, this.def.getShortestPathEndNode(), (Proj)var33_30, var2_2)) != null) {
                                        var36_55 = this.getNewStyledFeatureInstance();
                                        var36_55.setGeometry((JSDOGeometry)var35_80 /* !! */ );
                                        var36_55.setFeatureStyleName(this.def.getShortestPathEndStyle());
                                        var36_55.setDataSource(this.def.getDataSourceName());
                                        var7_11.add(var36_55);
                                    }
                                }
                                catch (Exception var35_82) {
                                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                        try {
                                            Util.gotoWorkspace(var3_3, "LIVE");
                                        }
                                        catch (Exception var36_56) {
                                            NetworkThemeProducer.log.warning(var36_56.getMessage());
                                        }
                                    }
                                    try {
                                        if (var3_3 != null) {
                                            DSUtil.closeDBConnection(var3_3, this.def.getDataSourceName());
                                        }
                                    }
                                    catch (Exception var36_57) {
                                        NetworkThemeProducer.log.warning(var36_57.getMessage());
                                    }
                                    throw new DataException(var35_82);
                                }
                            }
                        }
                        if (this.def.getShortestPathAlgorithm() == null || !this.def.getShortestPathAlgorithm().equalsIgnoreCase("WITHINCOST")) break block270;
                        var34_38 = null;
                        if (this.isFullExtent(this.def.getASIS(), var13_17, var15_18, var17_19, var19_20)) {
                            var34_38 = this.runWithinCostAnalysis(var3_3, null);
                        } else {
                            var35_80 /* !! */  = (int[])new double[2];
                            var35_80 /* !! */ [0] = (int)var13_17;
                            var35_80 /* !! */ [1] = (int)var15_18;
                            var36_58 = new double[]{var17_19, var19_20};
                            var37_86 = NetworkFactory.createMBR((double[])var35_80 /* !! */ , (double[])var36_58);
                            var34_38 = this.runWithinCostAnalysis(var3_3, var37_86);
                        }
                        if (!this.def.getGeometryType().equals("SDO_GEOMETRY")) break block271;
                        var35_80 /* !! */  = (int[])this.rewriteSpatialQuery(var21_21, var34_38);
                        if (var35_80 /* !! */  != null) {
                            NetworkThemeProducer.log.finest("[Within Cost path query]:  " + (String)var35_80 /* !! */ );
                            try {
                                var6_10 = this.processQuery(var3_3, (String)var35_80 /* !! */ , this.def.getShortestPathStyle(), null, 0, var7_11, var6_10, (Proj)var33_30, var2_2);
                            }
                            catch (Exception var36_59) {
                                if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                    try {
                                        Util.gotoWorkspace(var3_3, "LIVE");
                                    }
                                    catch (Exception var37_87) {
                                        NetworkThemeProducer.log.warning(var37_87.getMessage());
                                    }
                                }
                                try {
                                    if (var3_3 != null) {
                                        DSUtil.closeDBConnection(var3_3, this.def.getDataSourceName());
                                    }
                                }
                                catch (Exception var37_88) {
                                    NetworkThemeProducer.log.warning(var37_88.getMessage());
                                }
                                throw new DataException(var36_59);
                            }
                        }
                        break block261;
                    }
                    if (this.def.getGeometryType().equals("LRS_GEOMETRY") && (var35_80 /* !! */  = (int[])this.getLRSLinkQuery(var21_21, var34_38)) != null) {
                        block259: {
                            var5_8 = var3_3.prepareStatement((String)var35_80 /* !! */ );
                            var5_8.setFetchSize(this.owner.getFetchSize());
                            NetworkThemeProducer.log.finer("Fetch size: " + var5_8.getFetchSize());
                            var4_6 = var5_8.executeQuery();
                            var36_60 = 0;
                            var37_89 = null;
                            while (var4_6.next()) {
                                var38_73 = null;
                                var39_97 = -9999.0;
                                var41_106 = -9999.0;
                                var43_103 = 0;
                                var44_108 = 0;
                                var43_103 = var4_6.getInt(2);
                                var44_108 = var4_6.getInt(3);
                                var39_97 = var4_6.getDouble(4);
                                var41_106 = var4_6.getDouble(5);
                                if (var44_108 == var36_60) {
                                    var38_73 = var37_89;
                                } else {
                                    var45_109 = this.getTheme().getDecorator().isFastUnpickle();
                                    var38_73 = JDBCUtil.loadGeometry(var4_6, 1, var45_109);
                                }
                                if (var38_73 == null || var44_108 != var36_60 && this.applyRotation && ((var45_110 = Util.rotateGeometry(var38_73, (this.swxl + this.swxh) / 2.0, (this.swyl + this.swyh) / 2.0, var2_2.getRotation())) == null || (var38_73 = JSDOGeometry.recast(var45_110)) == null) || (var38_73 = var2_2.getSrs().shift(var38_73, var2_2.getQueryWindow())) == null) continue;
                                var36_60 = var44_108;
                                var37_89 = var38_73;
                                if (var33_30 != null) {
                                    var45_111 = var33_30.getOpposite();
                                    if (var38_73.pointInPolygon(var45_111.x, var45_111.y) || (var38_73 = SRS.proj(var38_73, (Proj)var33_30, 0)) == null) continue;
                                }
                                if ((var45_112 = this.getLRSLink(var38_73, var39_97, var41_106)) == null) continue;
                                var46_114 = var45_112.size();
                                var47_119 = new double[var46_114 * 2];
                                for (var48_121 = 0; var48_121 < var46_114; ++var48_121) {
                                    var49_123 = (Point2D)var45_112.get(var48_121);
                                    var47_119[2 * var48_121] = var49_123.getX();
                                    var47_119[2 * var48_121 + 1] = var49_123.getY();
                                }
                                var48_120 = this.getNewStyledFeatureInstance();
                                var49_123 = JSDOGeometry.recast(JSDOGeometry.createLinearLineString((double[])var47_119, (int)2, (int)this.def.getSrid()));
                                var48_120.setGeometry((JSDOGeometry)var49_123);
                                var48_120.setDataSource(this.def.getDataSourceName());
                                var48_120.setFeatureStyleName(this.def.getShortestPathStyle());
                                var7_11.add(var48_120);
                            }
                            var51_124 = null;
                            if (this.getTheme().getDecorator().getWorkspaceName() == null) break block259;
                            try {
                                Util.gotoWorkspace(var3_3, "LIVE");
                            }
                            catch (Exception var52_126) {
                                NetworkThemeProducer.log.warning(var52_126.getMessage());
                            }
                        }
                        try {
                            if (var4_6 != null) {
                                var4_6.close();
                            }
                        }
                        catch (Exception var52_126) {
                            NetworkThemeProducer.log.warning(var52_126.getMessage());
                        }
                        try {
                            if (var5_8 != null) {
                                var5_8.close();
                            }
                            break block261;
                        }
                        catch (Exception var52_126) {
                            NetworkThemeProducer.log.warning(var52_126.getMessage());
                        }
                        break block261;
                        {
                            catch (Exception var36_61) {
                                NetworkThemeProducer.log.warning(var36_61.getMessage());
                                throw new DataException(var36_61);
                            }
                        }
                        catch (Throwable var50_128) {
                            var51_125 = null;
                            if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                try {
                                    Util.gotoWorkspace(var3_3, "LIVE");
                                }
                                catch (Exception var52_127) {
                                    NetworkThemeProducer.log.warning(var52_127.getMessage());
                                }
                            }
                            try {
                                if (var4_6 != null) {
                                    var4_6.close();
                                }
                            }
                            catch (Exception var52_127) {
                                NetworkThemeProducer.log.warning(var52_127.getMessage());
                            }
                            try {
                                if (var5_8 != null) {
                                    var5_8.close();
                                }
                            }
                            catch (Exception var52_127) {
                                NetworkThemeProducer.log.warning(var52_127.getMessage());
                            }
                            throw var50_128;
                        }
                    }
                }
                if (this.def.getShortestPathStartStyle() != null) {
                    try {
                        if (this.def.getGeometryType().equals("SDO_GEOMETRY")) {
                            var35_80 /* !! */  = (int[])this.getStyleNodeQuery(var21_21, this.def.getShortestPathStartNode());
                            if (var35_80 /* !! */  != null) {
                                NetworkThemeProducer.log.finest("[Start node style query]:  " + (String)var35_80 /* !! */ );
                                var6_10 = this.processQuery(var3_3, (String)var35_80 /* !! */ , this.def.getShortestPathStartStyle(), null, 0, var7_11, var6_10, (Proj)var33_30, var2_2);
                            }
                        } else if (this.def.getGeometryType().equals("LRS_GEOMETRY") && (var35_80 /* !! */  = (int[])this.getLRSNodeGeometry(var3_3, var21_21, this.def.getShortestPathStartNode(), (Proj)var33_30, var2_2)) != null) {
                            var36_62 = this.getNewStyledFeatureInstance();
                            var36_62.setGeometry((JSDOGeometry)var35_80 /* !! */ );
                            var36_62.setFeatureStyleName(this.def.getShortestPathStartStyle());
                            var36_62.setDataSource(this.def.getDataSourceName());
                            var7_11.add(var36_62);
                        }
                    }
                    catch (Exception var35_83) {
                        if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                            try {
                                Util.gotoWorkspace(var3_3, "LIVE");
                            }
                            catch (Exception var36_63) {
                                NetworkThemeProducer.log.warning(var36_63.getMessage());
                            }
                        }
                        try {
                            if (var3_3 != null) {
                                DSUtil.closeDBConnection(var3_3, this.def.getDataSourceName());
                            }
                        }
                        catch (Exception var36_64) {
                            NetworkThemeProducer.log.warning(var36_64.getMessage());
                        }
                        throw new DataException(var35_83);
                    }
                }
            }
            if (this.def.getNodeQuery() != null) {
                block263: {
                    block262: {
                        var34_39 = this.getMarkerSize(this.def.getNodeStyleSize(), var2_2);
                        var35_80 /* !! */  = (int[])this.rewriteNodeQuery(var21_21, var13_17, var15_18, var17_19, var19_20, var11_15);
                        NetworkThemeProducer.log.finest("[Network node query]:  " + (String)var35_80 /* !! */ );
                        var5_8 = var3_3.prepareStatement((String)var35_80 /* !! */ );
                        var5_8.setFetchSize(this.owner.getFetchSize());
                        NetworkThemeProducer.log.finer("Fetch size: " + var5_8.getFetchSize());
                        var4_6 = var5_8.executeQuery();
                        var36_65 = null;
                        var37_90 = null;
                        var38_74 = null;
                        if (this.def.isPredefined()) {
                            if (this.def.getGeometryType().equals("SDO_GEOMETRY")) {
                                var38_74 = this.def.getNodeCacheGroup();
                                if (var21_21) {
                                    var38_74 = this.def.getNodeCacheGroup(var2_2.getMasterSRID());
                                }
                            } else if (this.def.getGeometryType().equals("LRS_GEOMETRY")) {
                                var38_74 = this.def.getLinkCacheGroup();
                                if (var21_21) {
                                    var38_74 = this.def.getLinkCacheGroup(var2_2.getMasterSRID());
                                }
                            }
                        }
                        var39_98 = 0;
                        var40_78 = -999;
                        var41_107 = null;
                        while (var4_6.next()) {
                            var42_99 = null;
                            var43_104 = 0.0;
                            var45_113 = null;
                            if (!this.def.isPredefined()) {
                                if (this.def.getGeometryType().equals("LRS_GEOMETRY")) {
                                    var43_104 = var4_6.getDouble(2);
                                    var39_98 = var4_6.getInt(3);
                                    if (this.def.getNodeLabelStyle() != null && this.def.getNodeLabelColumn() != null) {
                                        var45_113 = var4_6.getString(4);
                                    }
                                } else if (this.def.getNodeLabelStyle() != null && this.def.getNodeLabelColumn() != null) {
                                    var45_113 = var4_6.getString(2);
                                }
                                if (var40_78 == var39_98) {
                                    var42_99 = var41_107;
                                } else {
                                    var46_115 = this.getTheme().getDecorator().isFastUnpickle();
                                    var42_99 = JDBCUtil.loadGeometry(var4_6, 1, var46_115);
                                }
                            } else {
                                var37_90 = var36_65 = var4_6.getString(1);
                                if (var21_21) {
                                    var37_90 = var36_65 + var2_2.getMasterSRID();
                                }
                                if (this.def.getGeometryType().equals("LRS_GEOMETRY")) {
                                    var43_104 = var4_6.getDouble(3);
                                    var39_98 = var4_6.getInt(4);
                                    if (this.def.getNodeLabelStyle() != null && this.def.getNodeLabelColumn() != null) {
                                        var45_113 = var4_6.getString(5);
                                    }
                                } else if (this.def.getNodeLabelStyle() != null && this.def.getNodeLabelColumn() != null) {
                                    var45_113 = var4_6.getString(3);
                                }
                                if (this.def.getGeometryType().equals("LRS_GEOMETRY") && var40_78 == var39_98) {
                                    var42_99 = var41_107;
                                } else {
                                    var46_116 = CacheMgr2.getGroup(this.def.getCacheSubRegion(), var38_74);
                                    var42_99 = this.loadGeom(var46_116, var4_6, var37_90, false);
                                }
                            }
                            if (this.applyRotation && (this.def.getGeometryType().equals("LRS_GEOMETRY") && var39_98 != var40_78 || !this.def.getGeometryType().equals("LRS_GEOMETRY")) && ((var46_117 = Util.rotateGeometry((JGeometry)var42_99, (this.swxl + this.swxh) / 2.0, (this.swyl + this.swyh) / 2.0, var2_2.getRotation())) == null || (var42_99 = JSDOGeometry.recast(var46_117)) == null) || var42_99 == null || (var42_99 = var2_2.getSrs().shift((JSDOGeometry)var42_99, var2_2.getQueryWindow())) == null) continue;
                            if (this.def.getGeometryType().equals("LRS_GEOMETRY")) {
                                var40_78 = var39_98;
                                var41_107 = var42_99;
                            }
                            var46_118 = this.getNewStyledFeatureInstance();
                            if (var33_30 != null) {
                                var47_119 = var33_30.getOpposite();
                                if (var42_99.pointInPolygon(var47_119.x, var47_119.y) || (var42_99 = SRS.proj((JSDOGeometry)var42_99, (Proj)var33_30, 0)) == null) continue;
                            }
                            if (this.def.getGeometryType().equals("SDO_GEOMETRY")) {
                                var46_118.setGeometry((JSDOGeometry)var42_99);
                                var46_118.setDataSource(this.def.getDataSourceName());
                                var46_118.setFeatureStyleName(this.def.getNodeStyle());
                                var46_118.setMarkerStyleSize(var34_39);
                                if (var45_113 != null) {
                                    var46_118.setLabel(var45_113);
                                    var46_118.setLabelStyleName(this.def.getNodeLabelStyle());
                                }
                                var7_11.add(var46_118);
                                if (++var6_10 % 20 != 0) continue;
                                Thread.currentThread();
                                Thread.yield();
                                continue;
                            }
                            if (!this.def.getGeometryType().equals("LRS_GEOMETRY")) continue;
                            var47_119 = var42_99.getOrdinatesArray();
                            var48_122 = var47_119[2];
                            var50_129 = var47_119[((Object)var47_119).length - 1];
                            if (var43_104 < var48_122 || var43_104 > var50_129) continue;
                            var52_126 = new double[2];
                            for (var53_131 = 0; var53_131 < ((Object)var47_119).length / 3; ++var53_131) {
                                if (var47_119[3 * var53_131 + 2] == var43_104) {
                                    var52_126[0] = var47_119[3 * var53_131];
                                    var52_126[1] = var47_119[3 * var53_131 + 1];
                                    break;
                                }
                                if (!(var47_119[3 * var53_131 + 2] > var43_104)) continue;
                                var54_133 = var43_104 / var50_129;
                                var56_134 = new double[((Object)var47_119).length / 3 * 2];
                                for (var57_136 = 0; var57_136 < ((Object)var47_119).length / 3; ++var57_136) {
                                    var56_134[2 * var57_136] = (double)var47_119[3 * var57_136];
                                    var56_134[2 * var57_136 + 1] = (double)var47_119[3 * var57_136 + 1];
                                }
                                var57_135 = Util.getLinePoint(var56_134, var54_133);
                                var52_126[0] = var57_135.getX();
                                var52_126[1] = var57_135.getY();
                                break;
                            }
                            var53_130 = JSDOGeometry.recast(JSDOGeometry.createPoint((double[])var52_126, (int)2, (int)this.def.getSrid()));
                            var54_132 = this.getNewStyledFeatureInstance();
                            var54_132.setGeometry(var53_130);
                            var54_132.setDataSource(this.def.getDataSourceName());
                            var54_132.setFeatureStyleName(this.def.getNodeStyle());
                            var54_132.setMarkerStyleSize(var34_39);
                            if (var45_113 != null) {
                                var54_132.setLabel(var45_113);
                                var54_132.setLabelStyleName(this.def.getNodeLabelStyle());
                            }
                            var7_11.add(var54_132);
                            if (++var6_10 % 20 != 0) continue;
                            Thread.currentThread();
                            Thread.yield();
                        }
                        if (MapMaker.isSpecial(var13_17, var15_18, var17_19, var19_20)) {
                            this.loadNewNodes(var7_11);
                            break block262;
                        }
                        var42_99 = new Rectangle2D.Double(var13_17, var15_18, var17_19 - var13_17, var19_20 - var15_18);
                        this.loadEditNodes((Rectangle2D)var42_99, var7_11);
                    }
                    var59_137 = null;
                    if (this.getTheme().getDecorator().getWorkspaceName() == null) break block263;
                    try {
                        Util.gotoWorkspace(var3_3, "LIVE");
                    }
                    catch (Exception var60_139) {
                        NetworkThemeProducer.log.warning(var60_139.getMessage());
                    }
                }
                try {
                    if (var4_6 != null) {
                        var4_6.close();
                    }
                }
                catch (Exception var60_139) {
                    NetworkThemeProducer.log.warning(var60_139.getMessage());
                }
                try {
                    if (var5_8 != null) {
                        var5_8.close();
                    }
                }
                catch (Exception var60_139) {
                    NetworkThemeProducer.log.warning(var60_139.getMessage());
                }
                try {
                    if (var3_3 != null) {
                        DSUtil.closeDBConnection(var3_3, this.def.getDataSourceName());
                    }
                    break block266;
                }
                catch (Exception var60_139) {
                    NetworkThemeProducer.log.warning(var60_139.getMessage());
                }
                break block266;
                {
                    catch (Exception var36_66) {
                        NetworkThemeProducer.log.warning(var36_66.getMessage());
                        throw new DataException(var36_66);
                    }
                }
                catch (Throwable var58_141) {
                    var59_138 = null;
                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                        try {
                            Util.gotoWorkspace(var3_3, "LIVE");
                        }
                        catch (Exception var60_140) {
                            NetworkThemeProducer.log.warning(var60_140.getMessage());
                        }
                    }
                    try {
                        if (var4_6 != null) {
                            var4_6.close();
                        }
                    }
                    catch (Exception var60_140) {
                        NetworkThemeProducer.log.warning(var60_140.getMessage());
                    }
                    try {
                        if (var5_8 != null) {
                            var5_8.close();
                        }
                    }
                    catch (Exception var60_140) {
                        NetworkThemeProducer.log.warning(var60_140.getMessage());
                    }
                    try {
                        if (var3_3 != null) {
                            DSUtil.closeDBConnection(var3_3, this.def.getDataSourceName());
                        }
                    }
                    catch (Exception var60_140) {
                        NetworkThemeProducer.log.warning(var60_140.getMessage());
                    }
                    throw var58_141;
                }
            }
        }
        if (this.getTheme().getDecorator().getWorkspaceName() != null) {
            try {
                Util.gotoWorkspace(var3_3, "LIVE");
            }
            catch (Exception var34_40) {
                NetworkThemeProducer.log.warning(var34_40.getMessage());
            }
        }
        try {
            if (var3_3 != null) {
                DSUtil.closeDBConnection(var3_3, this.def.getDataSourceName());
            }
        }
        catch (Exception var34_41) {
            NetworkThemeProducer.log.warning(var34_41.getMessage());
        }
        for (var34_42 = 0; var34_42 < var8_12.size(); ++var34_42) {
            var7_11.add((StyledFeatureI)var8_12.get(var34_42));
        }
        if (var7_11.size() <= 0) {
            return 0;
        }
        this.setStyledFeatures(var7_11);
        var7_11 = null;
        return this.features.size();
    }

    /*
     * Loose catch block
     */
    private int processQuery(Connection connection, String string, String string2, String string3, int n, ArrayList arrayList, int n2, Proj proj, VisContext visContext) throws DataException {
        int n3;
        block19: {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            n3 = n2;
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setFetchSize(this.owner.getFetchSize());
            log.finer("[ " + this.def.getName() + " ] Fetch size: " + preparedStatement.getFetchSize());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Object object;
                JSDOGeometry jSDOGeometry = null;
                String string4 = null;
                boolean bl = this.getTheme().getDecorator().isFastUnpickle();
                jSDOGeometry = JDBCUtil.loadGeometry(resultSet, 1, bl);
                if (jSDOGeometry == null || this.applyRotation && ((object = Util.rotateGeometry(jSDOGeometry, (this.swxl + this.swxh) / 2.0, (this.swyl + this.swyh) / 2.0, visContext.getRotation())) == null || (jSDOGeometry = JSDOGeometry.recast((JGeometry)object)) == null) || (jSDOGeometry = visContext.getSrs().shift(jSDOGeometry, visContext.getQueryWindow())) == null) continue;
                if (proj != null) {
                    object = proj.getOpposite();
                    if (jSDOGeometry.pointInPolygon(((Proj.P2)object).x, ((Proj.P2)object).y) || (jSDOGeometry = SRS.proj(jSDOGeometry, proj, 0)) == null) continue;
                }
                if (n > 0) {
                    string4 = resultSet.getString(n);
                }
                object = this.getNewStyledFeatureInstance();
                object.setGeometry(jSDOGeometry);
                object.setFeatureStyleName(string2);
                object.setDataSource(this.def.getDataSourceName());
                if (string4 != null) {
                    object.setLabel(string4);
                    object.setLabelStyleName(string3);
                }
                arrayList.add(object);
                if (++n3 % 20 != 0) continue;
                Thread.currentThread();
                Thread.yield();
            }
            Object var18_18 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                break block19;
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            break block19;
            {
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                    throw new DataException(exception);
                }
            }
            catch (Throwable throwable) {
                Object var18_19 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                throw throwable;
            }
        }
        return n3;
    }

    /*
     * Loose catch block
     */
    private int processPathQuery(Connection connection, String string, String string2, String string3, int n, ArrayList arrayList, int n2, Proj proj, VisContext visContext) throws DataException {
        int n3;
        block24: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block22: {
                int n4;
                preparedStatement = null;
                resultSet = null;
                n3 = n2;
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setFetchSize(this.owner.getFetchSize());
                log.finer("[ " + this.def.getName() + " ] Fetch size: " + preparedStatement.getFetchSize());
                resultSet = preparedStatement.executeQuery();
                double[] dArray = null;
                String string4 = null;
                while (resultSet.next()) {
                    Object object;
                    JSDOGeometry jSDOGeometry = null;
                    n4 = this.getTheme().getDecorator().isFastUnpickle();
                    jSDOGeometry = JDBCUtil.loadGeometry(resultSet, 1, n4 != 0);
                    if (jSDOGeometry == null || this.applyRotation && ((object = Util.rotateGeometry(jSDOGeometry, (this.swxl + this.swxh) / 2.0, (this.swyl + this.swyh) / 2.0, visContext.getRotation())) == null || (jSDOGeometry = JSDOGeometry.recast((JGeometry)object)) == null) || (jSDOGeometry = visContext.getSrs().shift(jSDOGeometry, visContext.getQueryWindow())) == null) continue;
                    if (proj != null) {
                        object = proj.getOpposite();
                        if (jSDOGeometry.pointInPolygon(((Proj.P2)object).x, ((Proj.P2)object).y)) continue;
                        jSDOGeometry = SRS.proj(jSDOGeometry, proj, 0);
                    }
                    if (n > 0 && string4 == null) {
                        string4 = resultSet.getString(n);
                    }
                    if (dArray == null) {
                        dArray = jSDOGeometry.getOrdinatesArray();
                        continue;
                    }
                    object = jSDOGeometry.getOrdinatesArray();
                    double[] dArray2 = new double[dArray.length];
                    System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
                    dArray = null;
                    dArray = new double[dArray2.length + ((Object)object).length - 2];
                    System.arraycopy(dArray2, 0, dArray, 0, dArray2.length);
                    for (int i = 2; i < ((Object)object).length; ++i) {
                        dArray[dArray2.length + i - 2] = (double)object[i];
                    }
                }
                if (dArray == null) break block22;
                if (string4 != null && dArray[0] > dArray[dArray.length - 2]) {
                    int n5 = dArray.length;
                    for (n4 = 0; n4 < (n5 - 2) / 2; n4 += 2) {
                        void var17_24 = dArray[n4];
                        double d = dArray[n4 + 1];
                        dArray[n4] = dArray[n5 - 2 - n4];
                        dArray[n4 + 1] = dArray[n5 - 1 - n4];
                        dArray[n5 - 2 - n4] = var17_24;
                        dArray[n5 - 1 - n4] = d;
                    }
                }
                JSDOGeometry jSDOGeometry = JSDOGeometry.recast(JSDOGeometry.createLinearLineString(dArray, (int)2, (int)this.def.getSrid()));
                StyledFeatureI styledFeatureI = this.getNewStyledFeatureInstance();
                styledFeatureI.setGeometry(jSDOGeometry);
                styledFeatureI.setFeatureStyleName(string2);
                styledFeatureI.setDataSource(this.def.getDataSourceName());
                if (string4 != null) {
                    styledFeatureI.setLabel(string4);
                    styledFeatureI.setLabelStyleName(string3);
                }
                arrayList.add(styledFeatureI);
                if (++n3 % 20 != 0) break block22;
                Thread.currentThread();
                Thread.yield();
            }
            Object var22_29 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                break block24;
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            break block24;
            {
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                    throw new DataException(exception);
                }
            }
            catch (Throwable throwable) {
                Object var22_30 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                throw throwable;
            }
        }
        return n3;
    }

    /*
     * Loose catch block
     */
    private int processLRSPathQuery(Connection connection, String string, String string2, String string3, int n, ArrayList arrayList, int n2, Proj proj, VisContext visContext) throws DataException {
        int n3;
        block28: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block26: {
                int n4;
                preparedStatement = null;
                resultSet = null;
                n3 = n2;
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setFetchSize(this.owner.getFetchSize());
                log.finer("[ " + this.def.getName() + " ] Fetch size: " + preparedStatement.getFetchSize());
                resultSet = preparedStatement.executeQuery();
                double[] dArray = null;
                String string4 = null;
                while (resultSet.next()) {
                    int n5;
                    int n6;
                    Vector vector;
                    Proj.P2 p2;
                    JSDOGeometry jSDOGeometry = null;
                    n4 = this.getTheme().getDecorator().isFastUnpickle();
                    jSDOGeometry = JDBCUtil.loadGeometry(resultSet, 1, n4 != 0);
                    if (jSDOGeometry == null || this.applyRotation && ((p2 = Util.rotateGeometry(jSDOGeometry, (this.swxl + this.swxh) / 2.0, (this.swyl + this.swyh) / 2.0, visContext.getRotation())) == null || (jSDOGeometry = JSDOGeometry.recast((JGeometry)p2)) == null) || (jSDOGeometry = visContext.getSrs().shift(jSDOGeometry, visContext.getQueryWindow())) == null) continue;
                    if (proj != null) {
                        p2 = proj.getOpposite();
                        if (jSDOGeometry.pointInPolygon(p2.x, p2.y) || (jSDOGeometry = SRS.proj(jSDOGeometry, proj, 0)) == null) continue;
                    }
                    int n7 = resultSet.getInt(2);
                    double d = resultSet.getDouble(3);
                    double d2 = resultSet.getDouble(4);
                    if (n > 0 && string4 == null) {
                        string4 = resultSet.getString(n);
                    }
                    if ((vector = this.getLRSLink(jSDOGeometry, d, d2)) == null) continue;
                    int n8 = vector.size();
                    double[] dArray2 = new double[n8 * 2];
                    if (n7 > 0) {
                        for (n6 = 0; n6 < n8; ++n6) {
                            Point2D point2D = (Point2D)vector.get(n6);
                            dArray2[2 * n6] = point2D.getX();
                            dArray2[2 * n6 + 1] = point2D.getY();
                        }
                    } else {
                        n6 = 0;
                        for (n5 = n8 - 1; n5 >= 0; --n5) {
                            Point2D point2D = (Point2D)vector.get(n5);
                            dArray2[2 * n6] = point2D.getX();
                            dArray2[2 * n6 + 1] = point2D.getY();
                            ++n6;
                        }
                    }
                    if (dArray == null) {
                        dArray = new double[n8 * 2];
                        System.arraycopy(dArray2, 0, dArray, 0, dArray2.length);
                        continue;
                    }
                    double[] dArray3 = new double[dArray.length];
                    System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
                    dArray = null;
                    dArray = new double[dArray3.length + dArray2.length - 2];
                    System.arraycopy(dArray3, 0, dArray, 0, dArray3.length);
                    for (n5 = 2; n5 < dArray2.length; ++n5) {
                        dArray[dArray3.length + n5 - 2] = dArray2[n5];
                    }
                }
                if (dArray == null) break block26;
                if (string4 != null && dArray[0] > dArray[dArray.length - 2]) {
                    int n9 = dArray.length;
                    for (n4 = 0; n4 < (n9 - 2) / 2; n4 += 2) {
                        void var17_24 = dArray[n4];
                        void var19_35 = dArray[n4 + 1];
                        dArray[n4] = dArray[n9 - 2 - n4];
                        dArray[n4 + 1] = dArray[n9 - 1 - n4];
                        dArray[n9 - 2 - n4] = var17_24;
                        dArray[n9 - 1 - n4] = var19_35;
                    }
                }
                JSDOGeometry jSDOGeometry = JSDOGeometry.recast(JSDOGeometry.createLinearLineString(dArray, (int)2, (int)this.def.getSrid()));
                StyledFeatureI styledFeatureI = this.getNewStyledFeatureInstance();
                styledFeatureI.setGeometry(jSDOGeometry);
                styledFeatureI.setFeatureStyleName(string2);
                styledFeatureI.setDataSource(this.def.getDataSourceName());
                if (string4 != null) {
                    styledFeatureI.setLabel(string4);
                    styledFeatureI.setLabelStyleName(string3);
                }
                arrayList.add(styledFeatureI);
                if (++n3 % 20 != 0) break block26;
                Thread.currentThread();
                Thread.yield();
            }
            Object var29_36 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                break block28;
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            break block28;
            {
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                    throw new DataException(exception);
                }
            }
            catch (Throwable throwable) {
                Object var29_37 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                throw throwable;
            }
        }
        return n3;
    }

    private String rewriteLinkQuery(boolean bl, double d, double d2, double d3, double d4, boolean bl2) {
        String string;
        if (this.def.getLinkQuery() == null) {
            return null;
        }
        String string2 = null;
        String string3 = this.def.getLinkQuery();
        String string4 = null;
        if (this.def.getGeometryType().equals("SDO_GEOMETRY")) {
            string4 = this.def.getLinkGeometryColumn();
        } else if (this.def.getGeometryType().equals("LRS_GEOMETRY")) {
            string4 = this.def.getLRSGeometryColumn();
        } else {
            return null;
        }
        if (bl) {
            string = string4;
            String string5 = "sdo_cs.transform(" + string4 + "," + this.visSRID + ") " + string4;
            string2 = string3.replaceFirst(string, string5);
        } else {
            string2 = string3;
        }
        if (this.isFullExtent(this.def.getASIS(), d, d2, d3, d4)) {
            return string2;
        }
        string = this.getFilter(string4, this.def.getSrid(), d, d2, d3, d4, this.def.is9i(), bl2);
        return string2 + " WHERE " + string;
    }

    private String rewriteNodeQuery(boolean bl, double d, double d2, double d3, double d4, boolean bl2) {
        String string;
        if (this.def.getNodeQuery() == null) {
            return null;
        }
        String string2 = null;
        String string3 = this.def.getNodeQuery();
        String string4 = null;
        if (this.def.getGeometryType().equals("SDO_GEOMETRY")) {
            string4 = this.def.getNodeGeometryColumn();
        } else if (this.def.getGeometryType().equals("LRS_GEOMETRY")) {
            string4 = this.def.getLRSGeometryColumn();
        } else {
            return null;
        }
        if (bl) {
            string = string4;
            String string5 = "sdo_cs.transform(" + string4 + "," + this.visSRID + ") " + string4;
            string2 = string3.replaceFirst(string, string5);
        } else {
            string2 = string3;
        }
        if (this.isFullExtent(this.def.getASIS(), d, d2, d3, d4)) {
            return string2;
        }
        string = this.getFilter(string4, this.def.getSrid(), d, d2, d3, d4, this.def.is9i(), bl2);
        return string2 + " WHERE " + string;
    }

    private String rewritePathQuery(int n, boolean bl, double d, double d2, double d3, double d4, boolean bl2) {
        String[] stringArray = this.def.getPathQueries();
        if (stringArray != null && stringArray[n] == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        if (this.def.getGeometryType().equals("SDO_GEOMETRY")) {
            string2 = this.def.getLinkGeometryColumn();
        } else if (this.def.getGeometryType().equals("LRS_GEOMETRY")) {
            string2 = this.def.getLRSGeometryColumn();
        } else {
            return null;
        }
        if (bl) {
            if (this.def.getGeometryType().equals("SDO_GEOMETRY") && this.def.getPathLabelColumn() != null && this.def.getPathLabelStyle() != null) {
                String string3 = this.def.getLinkTableName() + "." + string2;
                String string4 = "sdo_cs.transform(" + string2 + "," + this.visSRID + ") " + string2;
                string = stringArray[n].replaceFirst(string3, string4);
            } else {
                String string5 = string2;
                String string6 = "sdo_cs.transform(" + string2 + "," + this.visSRID + ") " + string2;
                string = stringArray[n].replaceFirst(string5, string6);
            }
        } else {
            string = stringArray[n];
        }
        return string;
    }

    private String rewriteSpatialQuery(boolean bl, int[] nArray) {
        if (nArray == null) {
            return null;
        }
        String string = "";
        if (this.def.getConnectionUser() != null && this.def.getNetworkOwner() != null && !this.def.getConnectionUser().equalsIgnoreCase(this.def.getNetworkOwner())) {
            string = this.def.getNetworkOwner() + ".";
        }
        String string2 = null;
        String string3 = this.def.getLinkGeometryColumn();
        String string4 = this.def.getLinkTableName();
        String string5 = "select " + string3 + " from " + string + string4 + " where link_id in (";
        for (int i = 0; i < nArray.length; ++i) {
            string5 = i == 0 ? string5 + nArray[i] : string5 + "," + nArray[i];
        }
        string2 = string5 = string5 + ")";
        if (bl) {
            String string6 = string3;
            String string7 = "sdo_cs.transform(" + string3 + "," + this.visSRID + ") " + string3;
            string2 = string5.replaceFirst(string6, string7);
        }
        return string2;
    }

    private String getLRSDirectionQuery(boolean bl, double d, double d2, double d3, double d4, boolean bl2) {
        String string;
        String string2 = null;
        if (!this.def.getGeometryType().equals("LRS_GEOMETRY")) {
            return null;
        }
        String string3 = "";
        if (this.def.getConnectionUser() != null && this.def.getNetworkOwner() != null && !this.def.getConnectionUser().equalsIgnoreCase(this.def.getNetworkOwner())) {
            string3 = this.def.getNetworkOwner() + ".";
        }
        if ((this.def.getLinkLabelStyle() == null || this.def.getLinkLabelColumn() == null) && this.def.getDirectionStyle() == null && this.def.getBiDirectionStyle() == null) {
            return this.rewriteLinkQuery(bl, d, d2, d3, d4, bl2);
        }
        String string4 = "";
        if (this.def.hasBidirectionAttribute()) {
            string4 = ", bidirected";
        }
        String string5 = this.def.getLRSTableName();
        String string6 = this.def.getLRSGeometryColumn();
        String string7 = this.def.getLinkTableName();
        string2 = !this.def.isPredefined() ? (this.def.getLinkLabelStyle() == null || this.def.getLinkLabelColumn() == null ? "select " + string6 + ", link_id, " + string3 + string5 + ".geom_id, start_measure, end_measure " + string4 + " from " + string3 + string5 + " inner join " + string3 + string7 + " on " + string3 + string5 + ".geom_id = " + string3 + string7 + ".geom_id" : "select " + string6 + ", link_id, " + string3 + string5 + ".geom_id, start_measure, end_measure, " + string3 + string7 + "." + this.def.getLinkLabelColumn() + string4 + " from " + string3 + string5 + " inner join " + string3 + string7 + " on " + string3 + string5 + ".geom_id = " + string3 + string7 + ".geom_id") : (this.def.getLinkLabelStyle() == null || this.def.getLinkLabelColumn() == null ? "select " + string3 + string5 + ".rowid, " + string6 + ", link_id, " + string3 + string5 + ".geom_id, start_measure, end_measure " + string4 + " from " + string3 + string5 + " inner join " + string3 + string7 + " on " + string3 + string5 + ".geom_id = " + string3 + string7 + ".geom_id" : "select " + string3 + string5 + ".rowid, " + string6 + ", link_id, " + string3 + string5 + ".geom_id, start_measure, end_measure, " + string3 + string7 + "." + this.def.getLinkLabelColumn() + string4 + " from " + string3 + string5 + " inner join " + string3 + string7 + " on " + string3 + string5 + ".geom_id = " + string3 + string7 + ".geom_id");
        String string8 = null;
        if (bl) {
            string = string6;
            String string9 = "sdo_cs.transform(" + string6 + "," + this.visSRID + ") " + string6;
            string8 = string2.replaceFirst(string, string9);
        } else {
            string8 = string2;
        }
        if (this.isFullExtent(this.def.getASIS(), d, d2, d3, d4)) {
            return string8 + " order by " + string3 + string5 + ".geom_id";
        }
        string = this.getFilter(string6, this.def.getSrid(), d, d2, d3, d4, this.def.is9i(), bl2);
        return string8 + " WHERE " + string + " order by " + string3 + string5 + ".geom_id";
    }

    private String getLRSLinkQuery(boolean bl, int[] nArray) {
        String string = null;
        if (!this.def.getGeometryType().equals("LRS_GEOMETRY")) {
            return null;
        }
        String string2 = "";
        if (this.def.getConnectionUser() != null && this.def.getNetworkOwner() != null && !this.def.getConnectionUser().equalsIgnoreCase(this.def.getNetworkOwner())) {
            string2 = this.def.getNetworkOwner() + ".";
        }
        String string3 = this.def.getLRSTableName();
        String string4 = this.def.getLRSGeometryColumn();
        String string5 = this.def.getLinkTableName();
        string = "select " + string4 + ", link_id, " + string2 + string3 + ".geom_id, start_measure, end_measure from " + string2 + string3 + " inner join " + string2 + string5 + " on " + string2 + string3 + ".geom_id = " + string2 + string5 + ".geom_id";
        String string6 = null;
        if (bl) {
            String string7 = string4;
            String string8 = "sdo_cs.transform(" + string4 + "," + this.visSRID + ") " + string4;
            string6 = string.replaceFirst(string7, string8);
        } else {
            string6 = string;
        }
        string6 = string6 + " where link_id in (";
        for (int i = 0; i < nArray.length; ++i) {
            string6 = i == 0 ? string6 + nArray[i] : string6 + "," + nArray[i];
        }
        string6 = string6 + ")";
        return string6 + " order by " + string2 + string3 + ".geom_id";
    }

    final String getFilter(String string, int n, double d, double d2, double d3, double d4, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(256);
        String string2 = "'querytype=WINDOW'";
        if (this.getTheme().getDecorator().getMinimumFeatureSizePx() > 0 && (this.dbVersion.indexOf(" 10.2") > 0 || this.dbVersion.indexOf(" 10.1.0.3") > 0 || this.dbVersion.indexOf(" 10.1.0.4") > 0 || this.dbVersion.indexOf(" 11.") > 0)) {
            double d5 = (d3 - d) / this.viewResX;
            double d6 = (d4 - d2) / this.viewResY;
            double d7 = Math.min(d5, d6) * (double)this.getTheme().getDecorator().getMinimumFeatureSizePx();
            if (bl2) {
                double d8 = 6378137.0;
                d7 *= Math.PI * d8 / 180.0;
            }
            string2 = "'min_resolution=" + d7 + " querytype=WINDOW'";
        }
        if (bl && bl2) {
            stringBuffer.append("MDSYS.SDO_FILTER(" + string + ", ");
            stringBuffer.append("MDSYS.SDO_CS.VIEWPORT_TRANSFORM(");
            stringBuffer.append("MDSYS.SDO_GEOMETRY( 2003, 0, NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(" + d + "," + d2 + "," + d3 + "," + d4 + "))" + ", " + n + " ), " + string2 + ") = 'TRUE'");
            return stringBuffer.toString();
        }
        stringBuffer.append("MDSYS.SDO_FILTER(" + string + ", " + "MDSYS.SDO_GEOMETRY(2003, ");
        if (n == 0) {
            stringBuffer.append("NULL");
        } else {
            stringBuffer.append(n);
        }
        stringBuffer.append(", NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(" + d + "," + d2 + "," + d3 + "," + d4 + ")), " + string2 + ") = 'TRUE'");
        return stringBuffer.toString();
    }

    private double[] runShortestPathAnalysis(Connection connection, MBR mBR) {
        int n;
        int[] nArray = null;
        int n2 = this.def.getShortestPathStartNode();
        if (n2 == (n = this.def.getShortestPathEndNode())) {
            log.severe("Start Node (" + n2 + ") and End Node (" + n + ") must be different.");
            return null;
        }
        Network network = null;
        try {
            long l = System.currentTimeMillis();
            log.finest("SP: Calling NetworkManager.readNetwork to load network data.");
            network = NetworkManager.readNetwork((Connection)connection, (String)this.def.getNetworkName(), (MBR)mBR, (boolean)false);
            long l2 = System.currentTimeMillis();
            log.finest("Time spent loading network (mbr:" + (mBR != null ? mBR.toString() : "null") + "): " + (l2 - l) + " ms");
            log.finest("network: #nodes=" + network.getNoOfNodes() + ", #links=" + network.getNoOfLinks());
            log.finest("End of NetworkManager.readNetwork call.");
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
            return null;
        }
        Path path = null;
        Link[] linkArray = null;
        double[] dArray = null;
        try {
            log.finest("Calling NetworkManager Shortest Path Algorithm");
            path = this.def.getShortestPathAlgorithm().equalsIgnoreCase("DIJKSTRA") ? NetworkManager.shortestPathDijkstra((Network)network, (int)n2, (int)n) : NetworkManager.shortestPathAStar((Network)network, (int)n2, (int)n);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
            return null;
        }
        log.finest("End of Shortest Path Algorithm.");
        if (path != null) {
            linkArray = path.getLinkArray();
            nArray = new int[linkArray.length];
            for (int i = 0; i < linkArray.length; ++i) {
                nArray[i] = linkArray[i].getID();
            }
            path.computeGeometry(0.0);
            JGeometry jGeometry = path.getGeometry();
            dArray = jGeometry.getOrdinatesArray();
        } else {
            log.warning("Result of Shortest Path algorithm is null.");
        }
        this.def.setShortestPathIds(nArray);
        return dArray;
    }

    private int[] runWithinCostAnalysis(Connection connection, MBR mBR) {
        int[] nArray = null;
        Path[] pathArray = null;
        Link[] linkArray = null;
        Network network = null;
        try {
            log.finest("WC: Calling NetworkManager.readNetwork to load network data.");
            long l = System.currentTimeMillis();
            network = NetworkManager.readNetwork((Connection)connection, (String)this.def.getNetworkName(), (MBR)mBR, (boolean)false);
            long l2 = System.currentTimeMillis();
            log.finest("Time spent loading network (mbr:" + (mBR != null ? mBR.toString() : "null") + "): " + (l2 - l) + " ms");
            log.finest("network: #nodes=" + network.getNoOfNodes() + ", #links=" + network.getNoOfLinks());
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
            return null;
        }
        int n = this.def.getShortestPathStartNode();
        double d = this.def.getShortestPathCost();
        try {
            log.finest("Calling NetworkManager.withinCost method.");
            pathArray = NetworkManager.withinCost((Network)network, (int)n, (double)d);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
            return null;
        }
        log.finest("End of NetworkManager.withinCost call.");
        if (pathArray != null) {
            int n2;
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            for (int i = 0; i < pathArray.length; ++i) {
                linkArray = pathArray[i].getLinkArray();
                for (n2 = 0; n2 < linkArray.length; ++n2) {
                    if (hashtable.containsKey(String.valueOf(linkArray[n2].getID()))) continue;
                    String string = String.valueOf(linkArray[n2].getID());
                    hashtable.put(string, string);
                }
            }
            Object[] objectArray = hashtable.values().toArray();
            nArray = new int[objectArray.length];
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                nArray[n2] = Integer.parseInt(objectArray[n2].toString());
            }
        }
        this.def.setShortestPathIds(nArray);
        return nArray;
    }

    private String getStyleNodeQuery(boolean bl, int n) {
        String string;
        String string2 = "";
        if (this.def.getConnectionUser() != null && this.def.getNetworkOwner() != null && !this.def.getConnectionUser().equalsIgnoreCase(this.def.getNetworkOwner())) {
            string2 = this.def.getNetworkOwner() + ".";
        }
        String string3 = this.def.getNodeGeometryColumn();
        String string4 = this.def.getNodeTableName();
        String string5 = string = "select " + string3 + " from " + string2 + string4 + " where node_id = " + n;
        if (bl) {
            String string6 = string3;
            String string7 = "sdo_cs.transform(" + string3 + "," + this.visSRID + ") " + string3;
            string5 = string.replaceFirst(string6, string7);
        }
        return string5;
    }

    /*
     * Loose catch block
     */
    private JSDOGeometry getLRSNodeGeometry(Connection connection, boolean bl, int n, Proj proj, VisContext visContext) throws DataException {
        block37: {
            Object object;
            Object object2;
            block33: {
                JSDOGeometry jSDOGeometry;
                Object object3;
                String string;
                if (!this.def.getGeometryType().equals("LRS_GEOMETRY")) {
                    return null;
                }
                String string2 = "";
                if (this.def.getConnectionUser() != null && this.def.getNetworkOwner() != null && !this.def.getConnectionUser().equalsIgnoreCase(this.def.getNetworkOwner())) {
                    string2 = this.def.getNetworkOwner() + ".";
                }
                String string3 = this.def.getLRSGeometryColumn();
                String string4 = this.def.getLRSTableName();
                String string5 = this.def.getNodeTableName();
                String string6 = string = "select " + string3 + ", measure from " + string2 + string4 + " inner join " + string2 + string5 + " on " + string2 + string4 + ".geom_id = " + string2 + string5 + ".geom_id where node_id = " + n;
                if (bl) {
                    object2 = string3;
                    object = "sdo_cs.transform(" + string3 + "," + this.visSRID + ") " + string3;
                    string6 = string.replaceFirst((String)object2, (String)object);
                }
                object2 = null;
                object = null;
                object2 = connection.prepareStatement(string6);
                object2.setFetchSize(this.owner.getFetchSize());
                log.finer("[ " + this.def.getName() + " ] Fetch size: " + object2.getFetchSize());
                object = object2.executeQuery();
                if (!object.next()) break block33;
                JSDOGeometry jSDOGeometry2 = null;
                boolean bl2 = this.getTheme().getDecorator().isFastUnpickle();
                jSDOGeometry2 = JDBCUtil.loadGeometry((ResultSet)object, 1, bl2);
                double d = object.getDouble(2);
                boolean bl3 = true;
                if (jSDOGeometry2 != null && proj != null) {
                    object3 = proj.getOpposite();
                    if (jSDOGeometry2.pointInPolygon(((Proj.P2)object3).x, ((Proj.P2)object3).y)) {
                        bl3 = false;
                    } else {
                        if (this.applyRotation) {
                            JGeometry jGeometry = Util.rotateGeometry(jSDOGeometry2, (this.swxl + this.swxh) / 2.0, (this.swyl + this.swyh) / 2.0, visContext.getRotation());
                            if (jGeometry == null) {
                                bl3 = false;
                            } else {
                                jSDOGeometry2 = JSDOGeometry.recast(jGeometry);
                                if (jSDOGeometry2 == null) {
                                    bl3 = false;
                                }
                            }
                        }
                        if ((jSDOGeometry2 = visContext.getSrs().shift(jSDOGeometry2, visContext.getQueryWindow())) == null) {
                            bl3 = false;
                        }
                        if ((jSDOGeometry2 = SRS.proj(jSDOGeometry2, proj, 0)) == null) {
                            bl3 = false;
                        }
                    }
                }
                if (!bl3) break block33;
                object3 = jSDOGeometry2.getOrdinatesArray();
                Object object4 = object3[((Object)object3).length - 1];
                double[] dArray = null;
                for (int i = 0; i < ((Object)object3).length / 3; ++i) {
                    if (object3[3 * i + 2] == d) {
                        dArray = new double[]{(double)object3[3 * i], (double)object3[3 * i + 1]};
                        break;
                    }
                    if (!(object3[3 * i + 2] > d)) continue;
                    double d2 = d / object4;
                    double[] dArray2 = new double[((Object)object3).length / 3 * 2];
                    for (int j = 0; j < ((Object)object3).length / 3; ++j) {
                        dArray2[2 * j] = (double)object3[3 * j];
                        dArray2[2 * j + 1] = (double)object3[3 * j + 1];
                    }
                    Point2D point2D = Util.getLinePoint(dArray2, d2);
                    dArray = new double[]{point2D.getX(), point2D.getY()};
                    break;
                }
                if (dArray == null) break block33;
                JSDOGeometry jSDOGeometry3 = jSDOGeometry = JSDOGeometry.recast(JSDOGeometry.createPoint(dArray, (int)2, (int)this.def.getSrid()));
                Object var29_30 = null;
                try {
                    if (object != null) {
                        object.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (object2 != null) {
                        object2.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                return jSDOGeometry3;
            }
            try {
                Object var29_31 = null;
            }
            catch (Throwable throwable) {
                Object var29_32 = null;
                try {
                    if (object != null) {
                        object.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (object2 != null) {
                        object2.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                throw throwable;
            }
            try {
                if (object != null) {
                    object.close();
                }
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            try {
                if (object2 != null) {
                    object2.close();
                }
                break block37;
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            break block37;
            {
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                    throw new DataException(exception);
                }
            }
        }
        return null;
    }

    private Vector getLRSLink(JSDOGeometry jSDOGeometry, double d, double d2) {
        int n;
        Vector<Point2D> vector = new Vector<Point2D>(10);
        double[] dArray = jSDOGeometry.getOrdinatesArray();
        double d3 = dArray[2];
        double d4 = dArray[dArray.length - 1];
        int n2 = -1;
        int n3 = -1;
        double[] dArray2 = new double[dArray.length / 3 * 2];
        for (n = 0; n < dArray.length / 3; ++n) {
            dArray2[2 * n] = dArray[3 * n];
            dArray2[2 * n + 1] = dArray[3 * n + 1];
        }
        for (n = 0; n < dArray.length / 3; ++n) {
            Point2D point2D;
            Point2D.Double double_;
            if (n2 == -1) {
                if (dArray[3 * n + 2] == d) {
                    n2 = n;
                    double_ = new Point2D.Double();
                    ((Point2D)double_).setLocation(dArray[3 * n], dArray[3 * n + 1]);
                    vector.add(double_);
                } else if (dArray[3 * n + 2] > d) {
                    double d5 = d / d4;
                    point2D = Util.getLinePoint(dArray2, d5);
                    vector.add(point2D);
                    n2 = n;
                }
            }
            if (n3 == -1) {
                if (dArray[3 * n + 2] == d2) {
                    n3 = n;
                    double_ = new Point2D.Double();
                    ((Point2D)double_).setLocation(dArray[3 * n], dArray[3 * n + 1]);
                    vector.add(double_);
                } else if (dArray[3 * n + 2] > d2) {
                    double d6 = d2 / d4;
                    point2D = Util.getLinePoint(dArray2, d6);
                    vector.add(point2D);
                    n3 = n;
                } else if (dArray[3 * n + 2] != d && n2 != -1) {
                    double_ = new Point2D.Double();
                    ((Point2D)double_).setLocation(dArray[3 * n], dArray[3 * n + 1]);
                    vector.add(double_);
                }
            }
            if (n2 > -1 && n3 > -1) break;
        }
        if (n2 == -1 || n3 == -1) {
            return null;
        }
        return vector;
    }

    public void setStyledFeatures(ArrayList arrayList) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(arrayList);
    }

    public StyledFeatureI[] getStyledFeatures() {
        if (this.features != null) {
            return this.features.getStyledFeatures();
        }
        return null;
    }

    public StyledFeatureI[] getSelectedFeatures(Rectangle2D rectangle2D) {
        if (this.features == null) {
            return null;
        }
        return this.features.getSelectedFeatures(rectangle2D);
    }

    public StyledFeatureI getStyledFeature(int n) {
        if (this.features == null) {
            return null;
        }
        return this.features.getStyledFeature(n);
    }

    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D rectangle2D, String string) {
        if (this.features == null) {
            return null;
        }
        return this.features.getSelectedFeaturesAsTheme(rectangle2D, string);
    }

    public double[] getDataMBR() {
        if (this.features == null) {
            return null;
        }
        return this.features.getDataMBR();
    }

    public void postPreparation(VisContext visContext) {
        if (this.features != null) {
            this.features.postPreparation(visContext);
        }
    }

    public int size() {
        if (this.features != null) {
            return this.features.size();
        }
        return 0;
    }

    /*
     * Loose catch block
     */
    private int processGeomLinkQuery(Connection connection, String string, ArrayList arrayList, ArrayList arrayList2, int n, Proj proj, VisContext visContext, boolean bl, double d, double d2, double d3, double d4) throws DataException {
        int n2;
        block44: {
            ResultSet resultSet;
            Statement statement;
            block42: {
                Object object;
                statement = null;
                resultSet = null;
                n2 = n;
                int n3 = this.getMarkerSize(this.def.getDirectionStyleSize(), visContext);
                String string2 = null;
                String string3 = null;
                String string4 = null;
                if (this.def.isPredefined()) {
                    string4 = this.def.getLinkCacheGroup();
                    if (bl) {
                        string4 = this.def.getLinkCacheGroup(visContext.getMasterSRID());
                    }
                }
                statement = connection.prepareStatement(string);
                statement.setFetchSize(this.owner.getFetchSize());
                log.finer("[ " + this.def.getName() + " ] Fetch size: " + statement.getFetchSize());
                resultSet = statement.executeQuery();
                block12: while (resultSet.next()) {
                    double d5;
                    Object object2;
                    JGeometry jGeometry;
                    object = "";
                    JSDOGeometry jSDOGeometry = null;
                    if (!this.def.isPredefined()) {
                        boolean bl2 = this.getTheme().getDecorator().isFastUnpickle();
                        jSDOGeometry = JDBCUtil.loadGeometry(resultSet, 1, bl2);
                        if (this.def.hasBidirectionAttribute()) {
                            object = this.def.getLinkLabelStyle() == null || this.def.getLinkLabelColumn() == null ? resultSet.getString(2) : resultSet.getString(3);
                        }
                    } else {
                        string3 = string2 = resultSet.getString(1);
                        if (bl) {
                            string3 = string2 + visContext.getMasterSRID();
                        }
                        CacheGroup cacheGroup = CacheMgr2.getGroup(this.def.getCacheSubRegion(), string4);
                        jSDOGeometry = this.loadGeom(cacheGroup, resultSet, string3, false);
                        if (this.def.hasBidirectionAttribute()) {
                            object = this.def.getLinkLabelStyle() == null || this.def.getLinkLabelColumn() == null ? resultSet.getString(3) : resultSet.getString(4);
                        }
                    }
                    if (jSDOGeometry == null || this.applyRotation && ((jGeometry = Util.rotateGeometry(jSDOGeometry, (this.swxl + this.swxh) / 2.0, (this.swyl + this.swyh) / 2.0, visContext.getRotation())) == null || (jSDOGeometry = JSDOGeometry.recast(jGeometry)) == null) || (jSDOGeometry = visContext.getSrs().shift(jSDOGeometry, visContext.getQueryWindow())) == null) continue;
                    String string5 = null;
                    if (this.def.getLinkLabelStyle() != null && this.def.getLinkLabelColumn() != null) {
                        string5 = this.def.isPredefined() ? resultSet.getString(3) : resultSet.getString(2);
                    }
                    StyledFeatureI styledFeatureI = this.getNewStyledFeatureInstance();
                    if (proj != null) {
                        object2 = proj.getOpposite();
                        if (jSDOGeometry.pointInPolygon(((Proj.P2)object2).x, ((Proj.P2)object2).y) || (jSDOGeometry = SRS.proj(jSDOGeometry, proj, 0)) == null) continue;
                    }
                    if (string5 != null) {
                        object2 = jSDOGeometry.getOrdinatesArray();
                        int n4 = ((Object)object2).length;
                        double[] dArray = new double[n4];
                        JSDOGeometry jSDOGeometry2 = jSDOGeometry;
                        if (object2[0] > object2[n4 - 2]) {
                            for (int i = 0; i < ((Object)object2).length; i += 2) {
                                dArray[i] = (double)object2[((Object)object2).length - 1 - i - 1];
                                dArray[i + 1] = (double)object2[((Object)object2).length - 1 - i];
                            }
                            jSDOGeometry2 = JSDOGeometry.recast(JSDOGeometry.createLinearLineString((double[])dArray, (int)2, (int)this.def.getSrid()));
                        }
                        styledFeatureI.setLabel(string5);
                        styledFeatureI.setLabelStyleName(this.def.getLinkLabelStyle());
                        styledFeatureI.setGeometry(jSDOGeometry2);
                    } else {
                        styledFeatureI.setGeometry(jSDOGeometry);
                    }
                    styledFeatureI.setFeatureStyleName(this.def.getLinkStyle());
                    styledFeatureI.setDataSource(this.def.getDataSourceName());
                    arrayList.add(styledFeatureI);
                    if (++n2 % 20 == 0) {
                        Thread.currentThread();
                        Thread.yield();
                    }
                    if ((this.def.getDirectionStyle() == null || ((String)object).equalsIgnoreCase("Y")) && (this.def.getBiDirectionStyle() == null || !((String)object).equalsIgnoreCase("Y")) || this.def.getLinkDirection().equalsIgnoreCase("UNDIRECTED") || this.def.getGeometryType().equals("LRS_GEOMETRY") || ((Object)(object2 = (Object)jSDOGeometry.getOrdinatesArray())).length < 4) continue;
                    double d6 = visContext.getCurrentScale();
                    boolean bl3 = false;
                    double d7 = 0.0;
                    double d8 = 0.0;
                    if (d6 != Double.POSITIVE_INFINITY && d6 != Double.NEGATIVE_INFINITY) {
                        d5 = 96.0;
                        d8 = (double)n3 / d5 * d6;
                        Object object3 = object2[2];
                        Object object4 = object2[0];
                        Object object5 = object2[3];
                        Object object6 = object2[1];
                        double d9 = Math.sqrt((double)((object3 - object4) * (object3 - object4) + (object5 - object6) * (object5 - object6)));
                        if (0.6 * d9 >= d8) {
                            bl3 = true;
                        } else {
                            for (int i = 2; i < ((Object)object2).length; i += 2) {
                                object3 = object2[i];
                                object5 = object2[i + 1];
                                d7 += Math.sqrt((double)((object3 - object4) * (object3 - object4) + (object5 - object6) * (object5 - object6)));
                                object4 = object3;
                                object6 = object5;
                            }
                        }
                    } else {
                        bl3 = true;
                    }
                    if (!bl3 && !(d8 <= 0.6 * d7)) continue;
                    for (d5 = this.def.getLinkDirectionPosition(); d5 > 0.0 && d5 < 1.0; d5 += this.def.getLinkDirectionPosition()) {
                        Point2D point2D = Util.getLinePoint((double[])object2, d5);
                        if (point2D != null) {
                            double[] dArray = new double[]{point2D.getX(), point2D.getY()};
                            double[] dArray2 = Util.getLineSegment((double[])object2, d5);
                            double d10 = dArray2[2] - dArray2[0];
                            double d11 = dArray2[3] - dArray2[1];
                            JSDOGeometry jSDOGeometry3 = JSDOGeometry.recast(JSDOGeometry.createPoint((double[])dArray, (int)2, (int)this.def.getSrid()));
                            StyledFeatureI styledFeatureI2 = this.getNewStyledFeatureInstance();
                            styledFeatureI2.setGeometry(jSDOGeometry3);
                            styledFeatureI2.setDataSource(this.def.getDataSourceName());
                            if (!((String)object).equalsIgnoreCase("Y")) {
                                styledFeatureI2.setFeatureStyleName(this.def.getDirectionStyle());
                            } else {
                                styledFeatureI2.setFeatureStyleName(this.def.getBiDirectionStyle());
                            }
                            styledFeatureI2.setMarkerStyleSize(n3);
                            styledFeatureI2.setMarkerStyleOrientation(d10, d11, 0.0);
                            arrayList2.add(styledFeatureI2);
                        }
                        if (!this.def.hasMultipleDirectionMarkers()) continue block12;
                    }
                }
                if (MapMaker.isSpecial(d, d2, d3, d4)) {
                    this.loadNewLinks(arrayList);
                    break block42;
                }
                object = new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
                this.loadEditLinks((Rectangle2D)object, arrayList);
            }
            Object var50_52 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            try {
                if (statement != null) {
                    statement.close();
                }
                break block44;
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            break block44;
            {
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                    try {
                        if (connection != null) {
                            DSUtil.closeDBConnection(connection, this.def.getDataSourceName());
                        }
                    }
                    catch (Exception exception2) {
                        log.warning(exception2.getMessage());
                    }
                    throw new DataException(exception);
                }
            }
            catch (Throwable throwable) {
                Object var50_53 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                throw throwable;
            }
        }
        return n2;
    }

    /*
     * Loose catch block
     */
    private int processLRSLinkQuery(Connection connection, String string, ArrayList arrayList, ArrayList arrayList2, int n, Proj proj, VisContext visContext, boolean bl) throws DataException {
        int n2;
        block54: {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            n2 = n;
            int n3 = this.getMarkerSize(this.def.getDirectionStyleSize(), visContext);
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setFetchSize(this.owner.getFetchSize());
            log.finer("[ " + this.def.getName() + " ] Fetch size: " + preparedStatement.getFetchSize());
            resultSet = preparedStatement.executeQuery();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            if (this.def.isPredefined()) {
                string4 = this.def.getLinkCacheGroup();
                if (bl) {
                    string4 = this.def.getLinkCacheGroup(visContext.getMasterSRID());
                }
            }
            int n4 = 0;
            JSDOGeometry jSDOGeometry = null;
            while (resultSet.next()) {
                int n5;
                Vector vector;
                JGeometry jGeometry;
                String string5 = "";
                JSDOGeometry jSDOGeometry2 = null;
                double d = -9999.0;
                double d2 = -9999.0;
                int n6 = 0;
                int n7 = 0;
                String string6 = null;
                if (!this.def.isPredefined()) {
                    n6 = resultSet.getInt(2);
                    n7 = resultSet.getInt(3);
                    d = resultSet.getDouble(4);
                    d2 = resultSet.getDouble(5);
                    if (this.def.getLinkLabelStyle() != null && this.def.getLinkLabelColumn() != null) {
                        string6 = resultSet.getString(6);
                    }
                    if (n7 == n4) {
                        jSDOGeometry2 = jSDOGeometry;
                    } else {
                        boolean bl2 = this.getTheme().getDecorator().isFastUnpickle();
                        jSDOGeometry2 = JDBCUtil.loadGeometry(resultSet, 1, bl2);
                    }
                    if (this.def.hasBidirectionAttribute()) {
                        string5 = this.def.getLinkLabelStyle() == null || this.def.getLinkLabelColumn() == null ? resultSet.getString(6) : resultSet.getString(7);
                    }
                } else {
                    string3 = string2 = resultSet.getString(1);
                    if (bl) {
                        string3 = string2 + visContext.getMasterSRID();
                    }
                    n6 = resultSet.getInt(3);
                    n7 = resultSet.getInt(4);
                    d = resultSet.getDouble(5);
                    d2 = resultSet.getDouble(6);
                    if (this.def.getLinkLabelStyle() != null && this.def.getLinkLabelColumn() != null) {
                        string6 = resultSet.getString(7);
                    }
                    if (n7 == n4) {
                        jSDOGeometry2 = jSDOGeometry;
                    } else if (this.def.getCachingMode() != 3 && this.getTheme().getDecorator().getWorkspaceName() == null) {
                        CacheGroup cacheGroup = CacheMgr2.getGroup(this.def.getCacheSubRegion(), string4);
                        if (cacheGroup != null) {
                            jSDOGeometry2 = (JSDOGeometry)cacheGroup.get(string3);
                        }
                        if (jSDOGeometry2 == null && (jSDOGeometry2 = JDBCUtil.loadGeometry(resultSet, 2, false)) != null) {
                            cacheGroup.put(string3, jSDOGeometry2, jSDOGeometry2.getSize());
                        }
                    } else {
                        jSDOGeometry2 = JDBCUtil.loadGeometry(resultSet, 2, false);
                    }
                    if (this.def.hasBidirectionAttribute()) {
                        string5 = this.def.getLinkLabelStyle() == null || this.def.getLinkLabelColumn() == null ? resultSet.getString(7) : resultSet.getString(8);
                    }
                }
                if (jSDOGeometry2 == null || n7 != n4 && this.applyRotation && ((jGeometry = Util.rotateGeometry(jSDOGeometry2, (this.swxl + this.swxh) / 2.0, (this.swyl + this.swyh) / 2.0, visContext.getRotation())) == null || (jSDOGeometry2 = JSDOGeometry.recast(jGeometry)) == null) || (jSDOGeometry2 = visContext.getSrs().shift(jSDOGeometry2, visContext.getQueryWindow())) == null) continue;
                n4 = n7;
                jSDOGeometry = jSDOGeometry2;
                if (proj != null) {
                    Proj.P2 p2 = proj.getOpposite();
                    if (jSDOGeometry2.pointInPolygon(p2.x, p2.y) || (jSDOGeometry2 = SRS.proj(jSDOGeometry2, proj, 0)) == null) continue;
                }
                if ((vector = this.getLRSLink(jSDOGeometry2, d, d2)) == null) continue;
                int n8 = vector.size();
                double[] dArray = new double[n8 * 2];
                if (n6 > 0) {
                    for (n5 = 0; n5 < n8; ++n5) {
                        Point2D point2D = (Point2D)vector.get(n5);
                        dArray[2 * n5] = point2D.getX();
                        dArray[2 * n5 + 1] = point2D.getY();
                    }
                } else {
                    n5 = 0;
                    for (int i = n8 - 1; i >= 0; --i) {
                        Point2D point2D = (Point2D)vector.get(i);
                        dArray[2 * n5] = point2D.getX();
                        dArray[2 * n5 + 1] = point2D.getY();
                        ++n5;
                    }
                }
                if ((this.def.getDirectionStyle() != null && !string5.equalsIgnoreCase("Y") || this.def.getBiDirectionStyle() != null && string5.equalsIgnoreCase("Y")) && !this.def.getLinkDirection().equalsIgnoreCase("UNDIRECTED")) {
                    double d3;
                    double d4;
                    double d5;
                    if (dArray.length < 4) continue;
                    double d6 = visContext.getCurrentScale();
                    boolean bl3 = false;
                    double d7 = 0.0;
                    double d8 = 0.0;
                    if (d6 != Double.POSITIVE_INFINITY && d6 != Double.NEGATIVE_INFINITY) {
                        d5 = 96.0;
                        d8 = (double)n3 / d5 * d6;
                        d4 = dArray[2];
                        double d9 = dArray[0];
                        double d10 = dArray[3];
                        d3 = dArray[1];
                        double d11 = Math.sqrt((d4 - d9) * (d4 - d9) + (d10 - d3) * (d10 - d3));
                        if (0.6 * d11 >= d8) {
                            bl3 = true;
                        } else {
                            for (int i = 2; i < dArray.length; i += 2) {
                                d4 = dArray[i];
                                d10 = dArray[i + 1];
                                d7 += Math.sqrt((d4 - d9) * (d4 - d9) + (d10 - d3) * (d10 - d3));
                                d9 = d4;
                                d3 = d10;
                            }
                        }
                    } else {
                        bl3 = true;
                    }
                    if (bl3 || d8 <= 0.6 * d7) {
                        for (d5 = this.def.getLinkDirectionPosition(); d5 > 0.0 && d5 < 1.0; d5 += this.def.getLinkDirectionPosition()) {
                            Point2D point2D = Util.getLinePoint(dArray, d5);
                            if (point2D != null) {
                                double[] dArray2 = Util.getLineSegment(dArray, d5);
                                d3 = dArray2[2] - dArray2[0];
                                d4 = dArray2[3] - dArray2[1];
                                double[] dArray3 = new double[]{point2D.getX(), point2D.getY()};
                                JSDOGeometry jSDOGeometry3 = JSDOGeometry.recast(JSDOGeometry.createPoint((double[])dArray3, (int)2, (int)this.def.getSrid()));
                                StyledFeatureI styledFeatureI = this.getNewStyledFeatureInstance();
                                styledFeatureI.setGeometry(jSDOGeometry3);
                                styledFeatureI.setDataSource(this.def.getDataSourceName());
                                if (!string5.equalsIgnoreCase("Y")) {
                                    styledFeatureI.setFeatureStyleName(this.def.getDirectionStyle());
                                } else {
                                    styledFeatureI.setFeatureStyleName(this.def.getBiDirectionStyle());
                                }
                                styledFeatureI.setMarkerStyleSize(n3);
                                styledFeatureI.setMarkerStyleOrientation(d3, d4, 0.0);
                                arrayList2.add(styledFeatureI);
                            }
                            if (!this.def.hasMultipleDirectionMarkers()) break;
                        }
                    }
                }
                JSDOGeometry jSDOGeometry4 = null;
                StyledFeatureI styledFeatureI = this.getNewStyledFeatureInstance();
                if (string6 != null) {
                    int n9 = dArray.length;
                    double[] dArray4 = new double[n9];
                    if (dArray[0] > dArray[n9 - 2]) {
                        for (int i = 0; i < dArray.length; i += 2) {
                            dArray4[i] = dArray[n9 - 1 - i - 1];
                            dArray4[i + 1] = dArray[n9 - 1 - i];
                        }
                        jSDOGeometry4 = JSDOGeometry.recast(JSDOGeometry.createLinearLineString((double[])dArray4, (int)2, (int)this.def.getSrid()));
                    } else {
                        jSDOGeometry4 = JSDOGeometry.recast(JSDOGeometry.createLinearLineString((double[])dArray, (int)2, (int)this.def.getSrid()));
                    }
                    styledFeatureI.setLabel(string6);
                    styledFeatureI.setLabelStyleName(this.def.getLinkLabelStyle());
                    styledFeatureI.setGeometry(jSDOGeometry4);
                } else {
                    jSDOGeometry4 = JSDOGeometry.recast(JSDOGeometry.createLinearLineString((double[])dArray, (int)2, (int)this.def.getSrid()));
                }
                styledFeatureI.setGeometry(jSDOGeometry4);
                styledFeatureI.setFeatureStyleName(this.def.getLinkStyle());
                styledFeatureI.setDataSource(this.def.getDataSourceName());
                arrayList.add(styledFeatureI);
                if (++n2 % 20 != 0) continue;
                Thread.currentThread();
                Thread.yield();
            }
            Object var51_58 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                break block54;
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            break block54;
            {
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                    throw new DataException(exception);
                }
            }
            catch (Throwable throwable) {
                Object var51_59 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                throw throwable;
            }
        }
        return n2;
    }

    private boolean isFullExtent(boolean bl, double d, double d2, double d3, double d4) {
        return bl || Double.isInfinite(d) || Double.isNaN(d) || Double.isInfinite(d2) || Double.isNaN(d2) || Double.isInfinite(d3) || Double.isNaN(d3) || Double.isInfinite(d4) || Double.isNaN(d4);
    }

    public StyledFeatureI getNewStyledFeatureInstance() {
        return new StyledFeature();
    }

    private int getMarkerSize(SizeDefinition sizeDefinition, VisContext visContext) {
        if (sizeDefinition == null || sizeDefinition.isPixelUnit() || visContext == null || Util.isFullExtent(visContext.getQueryWindow().getMinX(), visContext.getQueryWindow().getMinX(), visContext.getQueryWindow().getMaxX(), visContext.getQueryWindow().getMaxY()) || visContext.getQueryWindow().getWidth() == 0.0 && visContext.getQueryWindow().getHeight() == 0.0) {
            return 8;
        }
        Rectangle2D rectangle2D = visContext.getDeviceWindow();
        Rectangle2D rectangle2D2 = visContext.getQueryWindow();
        double d = rectangle2D2.getHeight() / rectangle2D.getHeight();
        Double d2 = SRS.getDistanceConversionFactor(sizeDefinition.getUnit());
        if (d2 == null) {
            return 8;
        }
        double d3 = sizeDefinition.getValue() * d2;
        if (visContext.getSrs() != null && visContext.getSrs().isGeodetic()) {
            double d4 = SphereCG.convertRadius(0.0, 0.0, d3);
            return (int)(d4 / d + 0.5);
        }
        return (int)(d3 / d + 0.5);
    }

    protected JSDOGeometry loadGeom(ResultSet resultSet, boolean bl) throws Exception {
        return JDBCUtil.loadGeometry(resultSet, 2, bl);
    }

    protected JSDOGeometry loadGeom(CacheGroup cacheGroup, ResultSet resultSet, String string, boolean bl) throws Exception {
        JSDOGeometry jSDOGeometry = null;
        if (this.def.getCachingMode() != 3 && cacheGroup != null && this.getTheme().getDecorator().getWorkspaceName() == null) {
            jSDOGeometry = (JSDOGeometry)cacheGroup.get(string);
            if (jSDOGeometry == null && (jSDOGeometry = this.loadGeom(resultSet, bl)) != null) {
                cacheGroup.put(string, jSDOGeometry, jSDOGeometry.getSize());
            }
        } else {
            jSDOGeometry = this.loadGeom(resultSet, bl);
        }
        return jSDOGeometry;
    }

    protected void loadNewLinks(ArrayList arrayList) {
    }

    protected void loadNewNodes(ArrayList arrayList) {
    }

    protected void loadEditLinks(Rectangle2D rectangle2D, ArrayList arrayList) {
    }

    protected void loadEditNodes(Rectangle2D rectangle2D, ArrayList arrayList) {
    }
}

