/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.svg;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.Reader;
import java.io.StringReader;
import oracle.sdovis.svg.SVGImageTranscoder;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGDomUtil {
    public static Document parseSVGFromReader(Reader reader) throws Exception {
        String string = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory sAXSVGDocumentFactory = new SAXSVGDocumentFactory(string);
        Document document = sAXSVGDocumentFactory.createDocument(null, reader);
        return document;
    }

    public static Document parseSVGFromString(String string) throws Exception {
        StringReader stringReader = new StringReader(string);
        return SVGDomUtil.parseSVGFromReader(stringReader);
    }

    public static Document parseSVGFromURL(String string) throws Exception {
        String string2 = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory sAXSVGDocumentFactory = new SAXSVGDocumentFactory(string2);
        Document document = sAXSVGDocumentFactory.createDocument(string);
        return document;
    }

    public static double[] getSVGPreferredSize(Document document) {
        NodeList nodeList = document.getElementsByTagName("svg");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!"svg".equalsIgnoreCase(node.getNodeName())) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string = null;
            String string2 = null;
            if (namedNodeMap.getNamedItem("width") != null) {
                string = namedNodeMap.getNamedItem("width").getNodeValue();
            }
            if (namedNodeMap.getNamedItem("height") != null) {
                string2 = namedNodeMap.getNamedItem("height").getNodeValue();
            }
            if (string == null || string2 == null) continue;
            try {
                double[] dArray = new double[]{Double.parseDouble(string), Double.parseDouble(string2)};
                return dArray;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static BufferedImage renderSVGDocument(Document document, int n, int n2) {
        SVGImageTranscoder sVGImageTranscoder = new SVGImageTranscoder();
        sVGImageTranscoder.addTranscodingHint(ImageTranscoder.KEY_WIDTH, new Float(n));
        sVGImageTranscoder.addTranscodingHint(ImageTranscoder.KEY_HEIGHT, new Float(n2));
        TranscoderInput transcoderInput = new TranscoderInput(document);
        try {
            sVGImageTranscoder.transcode(transcoderInput, null);
        }
        catch (TranscoderException transcoderException) {
            return null;
        }
        BufferedImage bufferedImage = sVGImageTranscoder.getRenderedImage();
        return bufferedImage;
    }

    public static BufferedImage renderSVGDocument(Document document, BufferedImage bufferedImage) {
        SVGImageTranscoder sVGImageTranscoder = new SVGImageTranscoder(bufferedImage);
        sVGImageTranscoder.addTranscodingHint(ImageTranscoder.KEY_WIDTH, new Float(bufferedImage.getWidth()));
        sVGImageTranscoder.addTranscodingHint(ImageTranscoder.KEY_HEIGHT, new Float(bufferedImage.getHeight()));
        TranscoderInput transcoderInput = new TranscoderInput(document);
        try {
            sVGImageTranscoder.transcode(transcoderInput, null);
        }
        catch (TranscoderException transcoderException) {
            transcoderException.printStackTrace();
            return null;
        }
        BufferedImage bufferedImage2 = sVGImageTranscoder.getRenderedImage();
        return bufferedImage2;
    }

    public static void renderSVGDocument(GraphicsNode graphicsNode, Graphics2D graphics2D) {
        graphicsNode.paint(graphics2D);
    }

    public static GraphicsNode getGraphicsRootNode(Document document) {
        UserAgentAdapter userAgentAdapter = new UserAgentAdapter();
        DocumentLoader documentLoader = new DocumentLoader((UserAgent)userAgentAdapter);
        BridgeContext bridgeContext = new BridgeContext((UserAgent)userAgentAdapter, documentLoader);
        bridgeContext.setDynamicState(2);
        GVTBuilder gVTBuilder = new GVTBuilder();
        GraphicsNode graphicsNode = gVTBuilder.build(bridgeContext, document);
        return graphicsNode;
    }

    public static void renderSVGDocument(Document document, Graphics2D graphics2D) {
        GraphicsNode graphicsNode = SVGDomUtil.getGraphicsRootNode(document);
        if (graphicsNode != null) {
            graphicsNode.paint(graphics2D);
        }
    }
}

