/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stylex;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.stylex.Bucket;
import oracle.mapviewer.share.stylex.BucketSeries;
import oracle.mapviewer.share.stylex.VariableMarkerStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.SVGMap;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.MarkerStyleModifiers;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleMarker;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.stylex.AdvancedStyle;
import oracle.sdovis.stylex.AdvancedStyleModifiers;
import oracle.sdovis.stylex.BucketStyle;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class VariableMarkerStyle
extends BucketStyle {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    StyleMarker baseMarker = null;

    public VariableMarkerStyle() {
        this.bean = new VariableMarkerStyleModel();
    }

    public VariableMarkerStyle(StyleModel styleModel) {
        this.setModel(styleModel);
    }

    public VariableMarkerStyle(Document document) throws StyleException {
        this.bean = new VariableMarkerStyleModel();
        try {
            Node node = XMLDOMParser.getSubElement(document, "AdvancedStyle");
            Node node2 = XMLDOMParser.getSubElement(node, "VariableMarkerStyle");
            node = XMLDOMParser.getSubElement(node2, "Buckets");
            BucketStyle.fetchBuckets(node, this.bean.getBucketSeries());
            ((VariableMarkerStyleModel)this.bean).setBaseMarkerName(XMLDOMParser.getAttribute(node2, "basemarker"));
            String string = XMLDOMParser.getAttribute(node2, "startsize");
            String string2 = XMLDOMParser.getAttribute(node2, "increment");
            SizeDefinition2D sizeDefinition2D = SizeDefinition2D.parse(string, string2);
            if (sizeDefinition2D == null) {
                throw new StyleException("Invalid sizes in VariableMarker style definition.");
            }
            ((VariableMarkerStyleModel)this.bean).setSizes(sizeDefinition2D);
        }
        catch (Exception exception) {
            throw new StyleException("Invalid VariableMarker style definition.");
        }
    }

    public VariableMarkerStyle(BucketSeries bucketSeries, StyleMarker styleMarker, int n, int n2) {
        this.bean = new VariableMarkerStyleModel(bucketSeries);
        this.baseMarker = styleMarker;
        ((VariableMarkerStyleModel)this.bean).setStartSize(n);
        ((VariableMarkerStyleModel)this.bean).setIncrement(n2);
        this.reset();
    }

    public Object clone() {
        VariableMarkerStyle variableMarkerStyle = (VariableMarkerStyle)super.clone();
        variableMarkerStyle.setModel((StyleModel)this.bean.clone());
        return variableMarkerStyle;
    }

    public StyleModel getModel() {
        return this.bean;
    }

    public void setModel(StyleModel styleModel) {
        if (!(styleModel instanceof VariableMarkerStyleModel)) {
            throw new IllegalArgumentException("Not a VariableMarkerStyleModel instance.");
        }
        this.bean = (VariableMarkerStyleModel)styleModel;
    }

    public String getBaseMarkerName() {
        return ((VariableMarkerStyleModel)this.bean).getBaseMarkerName();
    }

    public void setBaseMarkerName(String string) {
        ((VariableMarkerStyleModel)this.bean).setBaseMarkerName(string);
    }

    public StyleMarker getBaseMakerStyle() {
        return this.baseMarker;
    }

    public void setBaseMarkerStyle(StyleMarker styleMarker) {
        this.baseMarker = styleMarker;
    }

    public String getDefinition() {
        return this.bean.toXMLString();
    }

    public void reset() {
        double d = ((VariableMarkerStyleModel)this.bean).getDoubleStartSize();
        BucketSeries bucketSeries = this.bean.getBucketSeries();
        for (int i = 0; i < bucketSeries.size(); ++i) {
            Bucket bucket = bucketSeries.getBucket(i);
            if (bucket.getRenderStyle() != null || bucket.getRenderStyleName() != null) {
                log.finest("using user specified style.");
                continue;
            }
            StyleMarker styleMarker = (StyleMarker)this.baseMarker.clone();
            styleMarker.setDesiredWidth(d);
            styleMarker.setDesiredHeight(d);
            styleMarker.setDesiredUnit(((VariableMarkerStyleModel)this.bean).getSizesUnit());
            bucket.setRenderStyle(styleMarker);
            d += ((VariableMarkerStyleModel)this.bean).getDoubleIncrement();
        }
    }

    public boolean resolveStyles(StyleCache styleCache, Hashtable hashtable) {
        String string;
        String string2 = this.bean.getBucketSeries().getDefaultRenderStyleName();
        Style style = (Style)this.bean.getBucketSeries().getDefaultRenderStyle();
        if (string2 != null && style == null) {
            style = Util.getStyle(string2, styleCache, hashtable);
            this.bean.getBucketSeries().setDefaultRenderStyle(style);
        }
        if (style != null && !(style instanceof AdvancedStyle)) {
            style.resolveStyles(styleCache, hashtable);
        }
        if ((string = ((VariableMarkerStyleModel)this.bean).getBaseMarkerName()) == null || this.baseMarker != null) {
            return true;
        }
        this.baseMarker = (StyleMarker)Util.getStyle(string, styleCache, hashtable);
        if (this.baseMarker != null) {
            this.reset();
            return true;
        }
        return false;
    }

    public int getMaxLegendWidth(Graphics2D graphics2D, int n) {
        return super.getMaxLegendWidth(graphics2D, n);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("Cannot apply VariableMarkerStyle to a point without attribute.");
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        double d = rectangle2D.getWidth();
        double d2 = rectangle2D.getHeight();
        BucketSeries bucketSeries = this.bean.getBucketSeries();
        int n = bucketSeries.size();
        try {
            int n2 = ((StyleMarker)bucketSeries.getBucket(n - 1).getRenderStyle()).getDesiredWidth();
            int n3 = ((StyleMarker)bucketSeries.getBucket(0).getRenderStyle()).getDesiredWidth();
            if (styleModifiers != null && styleModifiers instanceof AdvancedStyleModifiers) {
                StyleModifiers styleModifiers2 = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers(this.getBaseMarkerName().toUpperCase() + "_" + (n - 1));
                if (styleModifiers2 != null && styleModifiers2 instanceof MarkerStyleModifiers) {
                    n2 = ((MarkerStyleModifiers)styleModifiers2).getWidth();
                }
                if ((styleModifiers2 = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers(this.getBaseMarkerName().toUpperCase() + "_0")) != null && styleModifiers2 instanceof MarkerStyleModifiers) {
                    n3 = ((MarkerStyleModifiers)styleModifiers2).getWidth();
                }
            }
            n2 = Math.max(n2, n3);
            double d3 = rectangle2D.getMinX();
            double d4 = rectangle2D.getMinY() + 2.0;
            Rectangle2D.Float float_ = new Rectangle2D.Float();
            for (int i = 0; i < n; ++i) {
                StyleModifiers styleModifiers3 = null;
                Bucket bucket = bucketSeries.getBucket(i);
                StyleMarker styleMarker = (StyleMarker)bucket.getRenderStyle();
                int n4 = styleMarker.getDesiredWidth();
                int n5 = styleMarker.getDesiredHeight();
                if (styleModifiers != null && styleModifiers instanceof AdvancedStyleModifiers && (styleModifiers3 = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers(this.getBaseMarkerName().toUpperCase() + "_" + i)) != null && styleModifiers3 instanceof MarkerStyleModifiers) {
                    n4 = ((MarkerStyleModifiers)styleModifiers3).getWidth();
                    n5 = ((MarkerStyleModifiers)styleModifiers3).getHeight();
                }
                double d5 = d3 + (double)(n2 - n4) / 2.0;
                ((Rectangle2D)float_).setRect(d5, d4, d, n5);
                this.drawBucketWithLabel(graphics2D, bucket, float_, (float)((double)n4 / d), 0.0f, styleModifiers3);
                d4 += (double)(n5 + 2);
            }
        }
        catch (Exception exception) {
            graphics2D.drawString(" * bad style *", 10, 10);
        }
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (!(shape instanceof Rectangle2D)) {
            throw new StyleNotApplicableException("VariableMarkerStyle not applicable without an attr value.");
        }
        this.apply(null, graphics2D, (Rectangle2D)shape, styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        super.apply(visContext, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        super.apply(visContext, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, stringArray, styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, Style style, String[] stringArray2, String string2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        super.apply(visContext, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, stringArray, style, stringArray2, string2, styleModifiers);
    }

    public void apply(VisContext visContext, SVGMap sVGMap, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("Cannot apply ColorSchemeStyle to a point without attribute.");
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        int n = (int)rectangle2D.getCenterX();
        int n2 = (int)rectangle2D.getCenterY();
        int n3 = (int)rectangle2D.getWidth();
        int n4 = (int)rectangle2D.getHeight();
        BucketSeries bucketSeries = this.bean.getBucketSeries();
        int n5 = bucketSeries.size();
        try {
            int n6;
            int n7 = n - n3 / 4;
            int n8 = n6 = n2 - n4 / 2;
            int n9 = 0;
            int n10 = ((StyleMarker)bucketSeries.getBucket(n5 - 1).getRenderStyle()).getDesiredWidth();
            Rectangle2D.Float float_ = new Rectangle2D.Float();
            for (int i = 0; i < n5; ++i) {
                Bucket bucket = bucketSeries.getBucket(i);
                StyleMarker styleMarker = (StyleMarker)bucket.getRenderStyle();
                int n11 = styleMarker.getDesiredWidth();
                int n12 = styleMarker.getDesiredHeight();
                int n13 = n7;
                n8 = n6 + n9;
                n8 += n12 / 2;
                ((Rectangle2D)float_).setRect(n7, n6 + n9, 9.0, 9.0);
                if (styleMarker != null) {
                    styleMarker.apply(null, sVGMap, (Rectangle2D)float_, null);
                }
                n9 += n12 < 10 ? 10 : n12 + 3;
                String string = bucket.getBucketLabel();
                if (string == null) continue;
                int n14 = n6 + n9 - 3;
                sVGMap.drawText(string, n7 + n10 / 2 + 2, n14, 0.0, new Font("Dialog", 0, 10), Color.black);
            }
        }
        catch (Exception exception) {
            sVGMap.drawText(" * bad style *", 10.0, 10.0, 0.0, new Font("Dialog", 0, 10), Color.black);
        }
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (point2D == null && shape == null) {
            return;
        }
        if (point2D == null) {
            Rectangle2D rectangle2D = shape.getBounds2D();
            point2D = new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY());
        }
        if (fieldArray[0] == null) {
            return;
        }
        int n2 = (int)point2D.getX();
        int n3 = (int)point2D.getY();
        StyleMarker styleMarker = (StyleMarker)this.chooseStyle(fieldArray[0]);
        if (styleMarker == null) {
            System.out.println("cannot find a suitable variable marker style based on your values [" + fieldArray[0] + "].");
            return;
        }
        int n4 = styleMarker.getDesiredWidth();
        int n5 = styleMarker.getDesiredHeight();
        Rectangle2D.Float float_ = new Rectangle2D.Float(n2 - n4 / 2, n3 - n5 / 2, n4, n5);
        styleMarker.apply(null, sVGMap, (Rectangle2D)float_, null);
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (fieldArray == null) {
            throw new StyleNotApplicableException("BucketStyle not applicable without an attribute value.");
        }
        if (stringArray == null) {
            this.apply(null, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
        } else {
            Field[] fieldArray2 = new Field[]{null};
            String string2 = stringArray[0];
            fieldArray2[0] = Util.getField(string2, fieldArray);
            if (fieldArray2[0] == null) {
                throw new StyleNotApplicableException("Unable to find column " + string2 + " for BucketStyle.");
            }
            this.apply(null, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray2, styleModifiers);
        }
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(null, sVGMap, shape, n, string, null, null, fieldArray, styleModifiers);
        return null;
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return super.applyToSVG(visContext, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, stringArray, styleModifiers);
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, Style style2, String[] stringArray2, String string4, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return super.applyToSVG(visContext, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, stringArray, style2, stringArray2, string4, styleModifiers);
    }

    public Object getPropertyValue(String string) {
        return null;
    }
}

