/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stylex;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.stylex.HeatMapStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SphereCG;
import oracle.sdovis.SRS;
import oracle.sdovis.SVGMap;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.stylex.AdvancedStyle;
import oracle.sdovis.stylex.HeatMapStyleModifiers;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HeatMapStyle
implements AdvancedStyle {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    HeatMapStyleModel bean;

    public int getMaxLegendWidth(Graphics2D graphics2D, int n) {
        return 250;
    }

    public StyleModel getModel() {
        return this.bean;
    }

    public void setModel(StyleModel styleModel) {
        this.bean = (HeatMapStyleModel)styleModel;
    }

    public HeatMapStyle(StyleModel styleModel) {
        this.setModel(styleModel);
    }

    public HeatMapStyle(Document document) throws StyleException {
        this.bean = new HeatMapStyleModel();
        try {
            int n;
            Node node = XMLDOMParser.getSubElement(document, "AdvancedStyle");
            node = XMLDOMParser.getSubElement(node, "HeatMapStyle");
            Node node2 = XMLDOMParser.getSubElement(node, "color_stops");
            String string = XMLDOMParser.getAttribute(node2, "num_steps");
            try {
                n = Integer.parseInt(string);
                this.bean.setNumSteps(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = XMLDOMParser.getAttribute(node2, "alpha");
            try {
                n = Integer.parseInt(string);
                this.bean.setAlpha(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = XMLDOMParser.getElementValue(node2);
            Color[] colorArray = HeatMapStyleModel.stringToColorStops(string);
            if (colorArray.length < 2) {
                log.severe("Must have at least two color stops.");
                throw new IllegalArgumentException("Invalid number of color stops.");
            }
            for (int i = 0; i < colorArray.length; ++i) {
                if (colorArray[i] != null) continue;
                throw new IllegalArgumentException("Invalid color in color stops.");
            }
            this.bean.setColorStops(colorArray);
            Node node3 = XMLDOMParser.getSubElement(node, "spot_light_radius");
            string = XMLDOMParser.getElementValue(node3);
            SizeDefinition sizeDefinition = SizeDefinition.parse(string);
            if (sizeDefinition == null) {
                throw new StyleException("Invalid spot light radius size in HeatMapStyle definition.");
            }
            this.bean.setSpotLightRadiusSize(sizeDefinition);
            node3 = XMLDOMParser.getSubElement(node, "grid_sample_factor");
            string = XMLDOMParser.getElementValue(node3);
            try {
                double d = Double.parseDouble(string);
                this.bean.setGridSampleFactor(d);
            }
            catch (Exception exception) {
                // empty catch block
            }
            node3 = XMLDOMParser.getSubElement(node, "container_theme");
            string = XMLDOMParser.getElementValue(node3);
            this.bean.setContainerThemeName(string);
        }
        catch (Exception exception) {
            throw new StyleException("Invalid HeatMapStyle definition.", exception);
        }
    }

    public String getDefinition() {
        return this.bean.toXMLString();
    }

    public boolean resolveStyles(StyleCache styleCache, Hashtable hashtable) {
        return true;
    }

    public Object getPropertyValue(String string) {
        return null;
    }

    public StyleModifiers convertToPixelSize(VisContext visContext) {
        if (this.isPixelUnit(this.bean.getSpotLightRadiusUnit())) {
            return null;
        }
        HeatMapStyleModifiers heatMapStyleModifiers = new HeatMapStyleModifiers();
        if (visContext == null || Util.isFullExtent(visContext.getQueryWindow().getMinX(), visContext.getQueryWindow().getMinX(), visContext.getQueryWindow().getMaxX(), visContext.getQueryWindow().getMaxY()) || visContext.getQueryWindow().getWidth() == 0.0 && visContext.getQueryWindow().getHeight() == 0.0) {
            if (this.isPixelUnit(this.bean.getSpotLightRadiusUnit())) {
                heatMapStyleModifiers.setSpotLightRadius((int)this.bean.getSpotLightRadius());
            }
        } else {
            double d;
            Rectangle2D rectangle2D = visContext.getDeviceWindow();
            Rectangle2D rectangle2D2 = visContext.getQueryWindow();
            double d2 = rectangle2D2.getWidth() / rectangle2D.getWidth();
            double d3 = d = rectangle2D2.getHeight() / rectangle2D.getHeight();
            Double d4 = null;
            if (this.bean.getSpotLightRadiusUnit() != null) {
                d4 = SRS.getDistanceConversionFactor(this.bean.getSpotLightRadiusUnit());
            }
            if (this.isPixelUnit(this.bean.getSpotLightRadiusUnit())) {
                heatMapStyleModifiers.setSpotLightRadius((int)this.bean.getSpotLightRadius());
            } else if (d4 != null) {
                double d5 = this.bean.getSpotLightRadius() * d4;
                if (visContext.getSrs() != null && visContext.getSrs().isGeodetic()) {
                    double d6 = SphereCG.convertRadius(0.0, 0.0, d5);
                    heatMapStyleModifiers.setSpotLightRadius((int)(d6 / d3 + 0.5));
                } else {
                    heatMapStyleModifiers.setSpotLightRadius((int)(d5 / d3 + 0.5));
                }
            }
        }
        return heatMapStyleModifiers;
    }

    private boolean isPixelUnit(String string) {
        return string == null || string.equalsIgnoreCase("px") || string.equalsIgnoreCase("pt");
    }

    public Object clone() {
        try {
            HeatMapStyle heatMapStyle = (HeatMapStyle)super.clone();
            heatMapStyle.setModel((StyleModel)this.bean.clone());
            return heatMapStyle;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        Color[] colorArray = null;
        try {
            colorArray = StyleUtils.createMultiStopGradient(this.bean.getColorStops(), this.bean.getNumSteps(), this.bean.getAlpha());
        }
        catch (Exception exception) {
            throw new StyleNotApplicableException("failed to create gradient", exception);
        }
        int n = (int)rectangle2D.getHeight();
        BufferedImage bufferedImage = new BufferedImage(colorArray.length, n, 2);
        Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
        for (int i = 0; i < colorArray.length; ++i) {
            graphics2D2.setColor(colorArray[i]);
            graphics2D2.fillRect(i, 0, 1, n);
        }
        graphics2D2.dispose();
        graphics2D.drawImage(bufferedImage, 0, 0, (int)(rectangle2D.getWidth() - 1.0), (int)(rectangle2D.getHeight() - 1.0), 0, 0, colorArray.length - 1, (int)(rectangle2D.getHeight() - 1.0), null);
        bufferedImage.flush();
        bufferedImage = null;
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, StyleModifiers styleModifiers) throws StyleNotApplicableException {
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, Style style, String[] stringArray2, String string2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
    }

    public void apply(VisContext visContext, SVGMap sVGMap, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return null;
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return null;
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, Style style2, String[] stringArray2, String string4, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return null;
    }
}

