/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stylex;

import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Vector;
import oracle.sdovis.stylex.Grid;

class Dot {
    Object[] grids;
    Point2D.Double[] dots;

    public Dot() {
    }

    public Dot(long l, Area area, Rectangle2D.Double double_) {
        this.dots = new Point2D.Double[(int)l];
        Vector<Grid> vector = new Vector<Grid>();
        int n = 0;
        while ((long)n < l) {
            vector.add(new Grid(n, l, area, double_));
            ++n;
        }
        this.grids = vector.toArray();
        Arrays.sort(this.grids);
    }

    private boolean checkContainment(int n) {
        return ((Grid)this.grids[n]).isContained();
    }

    public Point2D.Double getDot(int n) {
        return this.dots[n];
    }

    public void arrangeDot(int n) {
        if (this.checkContainment(n)) {
            this.placeDot(n);
        } else if (this.dotInside(n)) {
            this.placeDot(n);
        } else {
            Point2D point2D = this.getCentroid(n);
            this.placeDot(n, point2D);
        }
    }

    private void placeDot(int n) {
        Point2D.Double double_;
        double d = ((Grid)this.grids[n]).getWidth();
        this.dots[n] = double_ = new Point2D.Double();
        this.dots[n].setLocation(((Grid)this.grids[n]).getX() + d / 2.0, ((Grid)this.grids[n]).getY() + d / 2.0);
        this.randomizeDot(n, d / 4.0);
    }

    private void placeDot(int n, Point2D point2D) {
        Point2D.Double double_;
        this.dots[n] = double_ = new Point2D.Double();
        this.dots[n].setLocation(point2D);
        double d = ((Grid)this.grids[n]).getWidth();
        this.randomizeDot(n, d);
    }

    private void randomizeDot(int n, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray = new double[]{this.dots[n].getX(), this.dots[n].getY()};
        int n2 = 0;
        do {
            d2 = Math.PI * Math.random() * 2.0;
            d3 = d * Math.random();
            this.dots[n].setLocation(dArray[0] + d3 * Math.cos(d2), dArray[1] + d3 * Math.sin(d2));
        } while (!this.dotInside(n, this.dots[n].getX(), this.dots[n].getY()) && n2++ < 10);
    }

    private boolean dotInside(int n) {
        double d = ((Grid)this.grids[n]).getWidth();
        Point2D.Double double_ = new Point2D.Double(((Grid)this.grids[n]).getX() + d / 2.0, ((Grid)this.grids[n]).getY() + d / 2.0);
        return ((Grid)this.grids[n]).getIntersection().contains(double_);
    }

    private boolean dotInside(int n, double d, double d2) {
        Point2D.Double double_ = new Point2D.Double();
        double_.setLocation(d, d2);
        return ((Grid)this.grids[n]).getIntersection().contains(double_);
    }

    private Point2D getCentroid(int n) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        Area area = ((Grid)this.grids[n]).getIntersection();
        double[] dArray = new double[6];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        PathIterator pathIterator = area.getPathIterator(null);
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(dArray);
            switch (n2) {
                case 0: {
                    dArray2[0] = dArray[0];
                    dArray2[1] = dArray[1];
                    dArray3[0] = dArray[0];
                    dArray3[1] = dArray[1];
                    break;
                }
                case 4: {
                    d4 = dArray2[0] * dArray3[1] - dArray2[1] * dArray3[0];
                    d += d4;
                    d2 += (dArray2[0] + dArray3[0]) * d4;
                    d3 += (dArray2[1] + dArray3[1]) * d4;
                    break;
                }
                case 1: {
                    d4 = dArray2[0] * dArray[1] - dArray2[1] * dArray[0];
                    d += d4;
                    d2 += (dArray2[0] + dArray[0]) * d4;
                    d3 += (dArray2[1] + dArray[1]) * d4;
                    dArray2[0] = dArray[0];
                    dArray2[1] = dArray[1];
                    break;
                }
                default: {
                    System.out.println("Error: cannot calculate area of polygon with curve/cubic edge");
                    System.exit(1);
                }
            }
            pathIterator.next();
        }
        double d5 = d2 / ((d /= 2.0) * 6.0);
        double d6 = d3 / (d * 6.0);
        return new Point2D.Double(d5, d6);
    }

    private double Area2(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        return (point2D2.getX() - point2D.getX()) * (point2D3.getY() - point2D.getY()) - (point2D3.getX() - point2D.getX()) * (point2D2.getY() - point2D.getY());
    }

    private void Centroid3(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        double d = point2D.getX() + point2D2.getX() + point2D3.getX();
        double d2 = point2D.getY() + point2D2.getY() + point2D3.getY();
        point2D4.setLocation(d, d2);
    }

    private double getAreaSize(Area area, AffineTransform affineTransform) {
        double d = 0.0;
        double d2 = 0.0;
        double[] dArray = new double[6];
        double[] dArray2 = new double[2];
        PathIterator pathIterator = area.getPathIterator(affineTransform);
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: {
                    dArray2[0] = dArray[0];
                    dArray2[1] = dArray[1];
                    break;
                }
                case 4: {
                    break;
                }
                case 1: {
                    d += (dArray2[0] + dArray[0]) * (dArray[1] - dArray2[1]);
                    d2 += dArray2[0] * dArray[1] - dArray2[1] * dArray[0];
                    dArray2[0] = dArray[0];
                    dArray2[1] = dArray[1];
                    break;
                }
                default: {
                    System.out.println("Error: cannot calculate area of polygon with curve/cubic edge");
                    System.exit(1);
                }
            }
            pathIterator.next();
        }
        d2 /= 2.0;
        return d > 0.0 ? d : -1.0 * (d /= 2.0);
    }
}

