/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stylex;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.stylex.CollectionStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.SVGMap;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleArea;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleLine;
import oracle.sdovis.style.StyleMarker;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.stylex.AdvancedStyle;
import oracle.sdovis.stylex.AdvancedStyleModifiers;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CollectionStyle
implements AdvancedStyle {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private CollectionStyleModel bean = null;

    public CollectionStyle() {
        this.bean = new CollectionStyleModel();
        this.bean.setDefaultStyle(new StyleColor(Color.red));
    }

    public CollectionStyle(CollectionStyleModel collectionStyleModel) {
        this.setModel(collectionStyleModel);
    }

    public void setModel(CollectionStyleModel collectionStyleModel) {
        if (!(collectionStyleModel instanceof CollectionStyleModel)) {
            throw new IllegalArgumentException("Not a CollectionStyleModel instance.");
        }
        this.bean = collectionStyleModel;
        this.bean.setDefaultStyle(new StyleColor(Color.red));
    }

    public StyleModel getModel() {
        return this.bean;
    }

    public void setModel(StyleModel styleModel) {
        if (!(styleModel instanceof CollectionStyleModel)) {
            throw new IllegalArgumentException("Not a CollectionStyleModel instance.");
        }
        this.bean = (CollectionStyleModel)styleModel;
        this.bean.setDefaultStyle(new StyleColor(Color.red));
    }

    public CollectionStyle(Document document) throws StyleException {
        this.bean = new CollectionStyleModel();
        try {
            Node node = XMLDOMParser.getSubElement(document, "AdvancedStyle");
            Node node2 = XMLDOMParser.getSubElement(node, "CollectionStyle");
            ArrayList arrayList = XMLDOMParser.getRealChildNodes(node2);
            if (arrayList == null || arrayList.size() <= 0) {
                return;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                Node node3 = (Node)arrayList.get(i);
                if (!node3.getNodeName().equalsIgnoreCase("style")) continue;
                String string = XMLDOMParser.getAttribute(node3, "name");
                if (string == null || string.trim().length() < 1) {
                    log.info("Style name (index " + i + ") must be defined.");
                    continue;
                }
                String string2 = XMLDOMParser.getAttribute(node3, "shape");
                if (string2 == null || string2.trim().length() < 1) {
                    string2 = null;
                }
                this.bean.addStyle(string, null, string2);
            }
        }
        catch (Exception exception) {
            throw new StyleException("Invalid Collection style definition.");
        }
    }

    public String getDefinition() {
        return this.bean.toXMLString();
    }

    public boolean resolveStyles(StyleCache styleCache, Hashtable hashtable) {
        if (this.bean == null) {
            return false;
        }
        for (int i = 0; i < this.bean.getNumberOfStyles(); ++i) {
            String string = this.bean.getStyleName(i);
            Style style = Util.getStyle(string, styleCache, hashtable);
            if (style == null) continue;
            this.bean.setStyle(string, style);
            style.resolveStyles(styleCache, hashtable);
        }
        return true;
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (this.bean == null) {
            return;
        }
        for (int i = 0; i < this.bean.getNumberOfStyles(); ++i) {
            String string;
            Style style = (Style)this.bean.getStyle(i);
            if (style == null) continue;
            StyleModifiers styleModifiers2 = null;
            if (styleModifiers != null && styleModifiers instanceof AdvancedStyleModifiers) {
                styleModifiers2 = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers(this.bean.getStyleName(i).toUpperCase());
            }
            if ((string = this.bean.getStyleShape(i)) != null) {
                if (!string.equalsIgnoreCase(CollectionStyleModel.POINT_SHAPE) || style instanceof AdvancedStyle) continue;
                style.apply(null, graphics2D, f, f2, styleModifiers2);
                continue;
            }
            if (!(style instanceof StyleMarker) && !(style instanceof StyleColor)) continue;
            style.apply(null, graphics2D, f, f2, styleModifiers2);
        }
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (this.bean == null) {
            return;
        }
        double d = rectangle2D.getWidth() / (double)this.bean.getNumberOfStyles();
        double d2 = 0.0;
        for (int i = 0; i < this.bean.getNumberOfStyles(); ++i) {
            Style style = (Style)this.bean.getStyle(i);
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            double_.setRect(rectangle2D.getMinX() + d2, rectangle2D.getMinY(), d, rectangle2D.getHeight());
            style.apply(null, graphics2D, (Rectangle2D)double_, styleModifiers);
            d2 += d;
        }
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (this.bean == null) {
            return;
        }
        if (shape == null) {
            return;
        }
        block12: for (int i = 0; i < this.bean.getNumberOfStyles(); ++i) {
            String string;
            Style style = (Style)this.bean.getStyle(i);
            if (style == null) continue;
            StyleModifiers styleModifiers2 = null;
            if (styleModifiers != null && styleModifiers instanceof AdvancedStyleModifiers) {
                styleModifiers2 = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers(this.bean.getStyleName(i).toUpperCase());
            }
            if ((string = this.bean.getStyleShape(i)) != null) {
                switch (n) {
                    case 1: 
                    case 5: {
                        if (!string.equalsIgnoreCase(CollectionStyleModel.POINT_SHAPE) || style instanceof AdvancedStyle) continue block12;
                        style.apply(null, graphics2D, shape, n, styleModifiers2);
                        break;
                    }
                    case 2: 
                    case 6: {
                        if (!string.equalsIgnoreCase(CollectionStyleModel.LINE_SHAPE) || style instanceof AdvancedStyle) continue block12;
                        style.apply(null, graphics2D, shape, n, styleModifiers2);
                        break;
                    }
                    case 3: 
                    case 7: {
                        if (!string.equalsIgnoreCase(CollectionStyleModel.POLYGON_SHAPE) || style instanceof AdvancedStyle) continue block12;
                        style.apply(null, graphics2D, shape, n, styleModifiers2);
                        break;
                    }
                    case 4: {
                        style.apply(null, graphics2D, shape, n, styleModifiers2);
                        break;
                    }
                }
                continue;
            }
            switch (n) {
                case 1: 
                case 5: {
                    if (!(style instanceof StyleMarker) && !(style instanceof StyleColor)) continue block12;
                    style.apply(null, graphics2D, shape, n, styleModifiers2);
                    continue block12;
                }
                case 2: 
                case 6: {
                    if (!(style instanceof StyleLine) && !(style instanceof StyleColor)) continue block12;
                    style.apply(null, graphics2D, shape, n, styleModifiers2);
                    continue block12;
                }
                case 3: 
                case 7: {
                    if (!(style instanceof StyleArea) && !(style instanceof StyleColor) && !(style instanceof StyleLine)) continue block12;
                    style.apply(null, graphics2D, shape, n, styleModifiers2);
                    continue block12;
                }
                case 4: {
                    style.apply(null, graphics2D, shape, n, styleModifiers2);
                    continue block12;
                }
            }
        }
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (this.bean == null) {
            return;
        }
        if (shape == null) {
            return;
        }
        block12: for (int i = 0; i < this.bean.getNumberOfStyles(); ++i) {
            String string2;
            Style style = (Style)this.bean.getStyle(i);
            if (style == null) continue;
            StyleModifiers styleModifiers2 = null;
            if (styleModifiers != null && styleModifiers instanceof AdvancedStyleModifiers) {
                styleModifiers2 = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers(this.bean.getStyleName(i).toUpperCase());
            }
            if ((string2 = this.bean.getStyleShape(i)) != null) {
                switch (n) {
                    case 1: 
                    case 5: {
                        if (!string2.equalsIgnoreCase(CollectionStyleModel.POINT_SHAPE)) continue block12;
                        style.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers2);
                        break;
                    }
                    case 2: 
                    case 6: {
                        if (!string2.equalsIgnoreCase(CollectionStyleModel.LINE_SHAPE)) continue block12;
                        style.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers2);
                        break;
                    }
                    case 3: 
                    case 7: {
                        if (!string2.equalsIgnoreCase(CollectionStyleModel.POLYGON_SHAPE)) continue block12;
                        style.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers2);
                        break;
                    }
                    case 4: {
                        style.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers2);
                        break;
                    }
                }
                continue;
            }
            switch (n) {
                case 1: 
                case 5: {
                    if (!(style instanceof StyleMarker) && !(style instanceof StyleColor) && !(style instanceof AdvancedStyle)) continue block12;
                    style.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers2);
                    continue block12;
                }
                case 2: 
                case 6: {
                    if (!(style instanceof StyleLine) && !(style instanceof StyleColor) && !(style instanceof AdvancedStyle)) continue block12;
                    style.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers2);
                    continue block12;
                }
                case 3: 
                case 7: {
                    if (!(style instanceof StyleArea) && !(style instanceof StyleColor) && !(style instanceof StyleLine) && !(style instanceof AdvancedStyle)) continue block12;
                    style.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers2);
                    continue block12;
                }
                case 4: {
                    style.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers2);
                    continue block12;
                }
            }
        }
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, Style style, String[] stringArray2, String string2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
    }

    public void apply(VisContext visContext, SVGMap sVGMap, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (this.bean == null) {
            return;
        }
        for (int i = 0; i < this.bean.getNumberOfStyles(); ++i) {
            String string;
            Style style = (Style)this.bean.getStyle(i);
            if (style == null) continue;
            StyleModifiers styleModifiers2 = null;
            if (styleModifiers != null && styleModifiers instanceof AdvancedStyleModifiers) {
                styleModifiers2 = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers(this.bean.getStyleName(i).toUpperCase());
            }
            if ((string = this.bean.getStyleShape(i)) != null) {
                if (!string.equalsIgnoreCase(CollectionStyleModel.POINT_SHAPE) || style instanceof AdvancedStyle) continue;
                style.apply(null, sVGMap, f, f2, styleModifiers2);
                continue;
            }
            if (!(style instanceof StyleMarker) && !(style instanceof StyleColor)) continue;
            style.apply(null, sVGMap, f, f2, styleModifiers2);
        }
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (this.bean == null) {
            return;
        }
        for (int i = 0; i < this.bean.getNumberOfStyles(); ++i) {
            String string;
            Style style = (Style)this.bean.getStyle(i);
            if (style == null) continue;
            StyleModifiers styleModifiers2 = null;
            if (styleModifiers != null && styleModifiers instanceof AdvancedStyleModifiers) {
                styleModifiers2 = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers(this.bean.getStyleName(i).toUpperCase());
            }
            if ((string = this.bean.getStyleShape(i)) != null) {
                if (string.equalsIgnoreCase(CollectionStyleModel.POINT_SHAPE) || style instanceof AdvancedStyle) continue;
                style.apply(null, sVGMap, rectangle2D, styleModifiers2);
                continue;
            }
            if (!(style instanceof StyleArea) && !(style instanceof StyleColor) && !(style instanceof StyleLine)) continue;
            style.apply(null, sVGMap, rectangle2D, styleModifiers2);
        }
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (this.bean == null) {
            return;
        }
        if (shape == null) {
            return;
        }
        block12: for (int i = 0; i < this.bean.getNumberOfStyles(); ++i) {
            String string2;
            Style style = (Style)this.bean.getStyle(i);
            if (style == null) continue;
            StyleModifiers styleModifiers2 = null;
            if (styleModifiers != null && styleModifiers instanceof AdvancedStyleModifiers) {
                styleModifiers2 = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers(this.bean.getStyleName(i).toUpperCase());
            }
            if ((string2 = this.bean.getStyleShape(i)) != null) {
                switch (n) {
                    case 1: 
                    case 5: {
                        if (!string2.equalsIgnoreCase(CollectionStyleModel.POINT_SHAPE)) continue block12;
                        style.apply(null, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers2);
                        break;
                    }
                    case 2: 
                    case 6: {
                        if (!string2.equalsIgnoreCase(CollectionStyleModel.LINE_SHAPE)) continue block12;
                        style.apply(null, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers2);
                        break;
                    }
                    case 3: 
                    case 7: {
                        if (!string2.equalsIgnoreCase(CollectionStyleModel.POLYGON_SHAPE)) continue block12;
                        style.apply(null, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers2);
                        break;
                    }
                    case 4: {
                        style.apply(null, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers2);
                        break;
                    }
                }
                continue;
            }
            switch (n) {
                case 1: 
                case 5: {
                    if (!(style instanceof StyleMarker) && !(style instanceof StyleColor) && !(style instanceof AdvancedStyle)) continue block12;
                    style.apply(null, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers2);
                    continue block12;
                }
                case 2: 
                case 6: {
                    if (!(style instanceof StyleLine) && !(style instanceof StyleColor) && !(style instanceof AdvancedStyle)) continue block12;
                    style.apply(null, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers2);
                    continue block12;
                }
                case 3: 
                case 7: {
                    if (!(style instanceof StyleArea) && !(style instanceof StyleColor) && !(style instanceof StyleLine) && !(style instanceof AdvancedStyle)) continue block12;
                    style.apply(null, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers2);
                    continue block12;
                }
                case 4: {
                    style.apply(null, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers2);
                    continue block12;
                }
            }
        }
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(null, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (this.bean == null) {
            return null;
        }
        if (shape == null) {
            return null;
        }
        block12: for (int i = 0; i < this.bean.getNumberOfStyles(); ++i) {
            String string4;
            Style style2 = (Style)this.bean.getStyle(i);
            if (style2 == null) continue;
            StyleModifiers styleModifiers2 = null;
            if (styleModifiers != null && styleModifiers instanceof AdvancedStyleModifiers) {
                styleModifiers2 = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers(this.bean.getStyleName(i).toUpperCase());
            }
            if ((string4 = this.bean.getStyleShape(i)) != null) {
                switch (n) {
                    case 1: 
                    case 5: {
                        if (!string4.equalsIgnoreCase(CollectionStyleModel.POINT_SHAPE)) continue block12;
                        return style2.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, styleModifiers2);
                    }
                    case 2: 
                    case 6: {
                        if (!string4.equalsIgnoreCase(CollectionStyleModel.LINE_SHAPE)) continue block12;
                        return style2.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, styleModifiers2);
                    }
                    case 3: 
                    case 7: {
                        if (!string4.equalsIgnoreCase(CollectionStyleModel.POLYGON_SHAPE)) continue block12;
                        return style2.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, styleModifiers2);
                    }
                    case 4: {
                        return style2.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, styleModifiers2);
                    }
                }
                continue;
            }
            switch (n) {
                case 1: 
                case 5: {
                    if (!(style2 instanceof StyleMarker) && !(style2 instanceof StyleColor) && !(style2 instanceof AdvancedStyle)) continue block12;
                    return style2.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, styleModifiers2);
                }
                case 2: 
                case 6: {
                    if (!(style2 instanceof StyleLine) && !(style2 instanceof StyleColor) && !(style2 instanceof AdvancedStyle)) continue block12;
                    return style2.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, styleModifiers2);
                }
                case 3: 
                case 7: {
                    if (!(style2 instanceof StyleArea) && !(style2 instanceof StyleColor) && !(style2 instanceof StyleLine) && !(style2 instanceof AdvancedStyle)) continue block12;
                    return style2.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, styleModifiers2);
                }
                case 4: {
                    return style2.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, styleModifiers2);
                }
            }
        }
        return null;
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return this.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, styleModifiers);
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, Style style2, String[] stringArray2, String string4, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return this.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, styleModifiers);
    }

    public int getMaxLegendWidth(Graphics2D graphics2D, int n) {
        return 0;
    }

    public Object getPropertyValue(String string) {
        return null;
    }

    public StyleModifiers convertToPixelSize(VisContext visContext) {
        AdvancedStyleModifiers advancedStyleModifiers = new AdvancedStyleModifiers();
        for (int i = 0; i < this.bean.getNumberOfStyles(); ++i) {
            StyleModifiers styleModifiers;
            Style style = (Style)this.bean.getStyle(i);
            if (style == null || (styleModifiers = style.convertToPixelSize(visContext)) == null) continue;
            advancedStyleModifiers.addStyleModifiers(this.bean.getStyleName(i).toUpperCase(), styleModifiers);
        }
        if (advancedStyleModifiers.getStyleModifiers().size() == 0) {
            return null;
        }
        return advancedStyleModifiers;
    }
}

