/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stylex;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.LabelingHints;
import oracle.mapviewer.share.style.LineStyleModel;
import oracle.mapviewer.share.style.MarkerStyleModel;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.style.TextStyleModel;
import oracle.mapviewer.share.stylex.AbstractBucketStyleModel;
import oracle.mapviewer.share.stylex.Bucket;
import oracle.mapviewer.share.stylex.BucketSeries;
import oracle.mapviewer.share.stylex.BucketStyleModel;
import oracle.mapviewer.share.stylex.CollectionBucket;
import oracle.mapviewer.share.stylex.PieChartStyleModel;
import oracle.mapviewer.share.stylex.RangedBucket;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CasedLineHelper;
import oracle.sdovis.DataException;
import oracle.sdovis.SVGMap;
import oracle.sdovis.StyleCache;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.MarkerStyleModifiers;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleLine;
import oracle.sdovis.style.StyleMarker;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.style.StyleTable;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.stylex.AdvancedStyle;
import oracle.sdovis.stylex.AdvancedStyleModifiers;
import oracle.sdovis.stylex.PieChartStyle;
import oracle.sdovis.stylex.PieChartStyleModifiers;
import oracle.sdovis.stylex.VariableMarkerStyle;
import oracle.sdovis.stylex.VariablePieChartStyle;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class BucketStyle
implements AdvancedStyle {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    public static final int EQUALRANGED = 1;
    public static final int RANGEDBUCKET = 2;
    public static final int COLLECTIONBUCKET = 3;
    private static FontRenderContext frc = new FontRenderContext(null, true, false);
    protected AbstractBucketStyleModel bean;
    double equalRangeMin = 0.0;
    double equalRangeMax = 0.0;
    private boolean hasCasedLineStyles = false;

    public BucketStyle() {
        this.bean = new BucketStyleModel();
    }

    public BucketStyle(BucketSeries bucketSeries) {
        this.bean = new BucketStyleModel(bucketSeries);
    }

    public BucketStyle(StyleModel styleModel) {
        this.setModel(styleModel);
    }

    public BucketStyle(Document document) throws StyleException {
        this.bean = new BucketStyleModel();
        try {
            Node node = XMLDOMParser.getSubElement(document, "AdvancedStyle");
            node = XMLDOMParser.getSubElement(node, "BucketStyle");
            node = XMLDOMParser.getSubElement(node, "Buckets");
            BucketStyle.fetchBuckets(node, this.bean.getBucketSeries());
        }
        catch (Exception exception) {
            throw new StyleException("Invalid Bucket style definition.");
        }
    }

    public Object clone() {
        try {
            BucketStyle bucketStyle = (BucketStyle)super.clone();
            bucketStyle.setModel((StyleModel)this.bean.clone());
            return bucketStyle;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public String getDefinition() {
        return this.bean.toXMLString();
    }

    public void setDefaultStyleName(String string) {
        this.bean.getBucketSeries().setDefaultRenderStyleName(string);
        this.bean.getBucketSeries().setDefaultRenderStyle(null);
    }

    public void setDefaultStyle(Style style) {
        this.bean.getBucketSeries().setDefaultRenderStyleName(null);
        this.bean.getBucketSeries().setDefaultRenderStyle(style);
    }

    public Style getDefaultStyle() {
        return (Style)this.bean.getBucketSeries().getDefaultRenderStyle();
    }

    public String getDefaultStyleName() {
        return this.bean.getBucketSeries().getDefaultRenderStyleName();
    }

    public static BucketSeries fetchBuckets(Node node, BucketSeries bucketSeries) {
        String string;
        boolean bl = false;
        ArrayList arrayList = XMLDOMParser.getRealChildNodes(node);
        int n = 0;
        Node node2 = null;
        n = arrayList != null ? arrayList.size() : 0;
        if (n == 0) {
            bl = true;
            n = Integer.parseInt(XMLDOMParser.getAttribute(node, "nbuckets"));
        }
        if (bucketSeries == null) {
            bucketSeries = new BucketSeries();
        } else {
            bucketSeries.removeAll();
        }
        String string2 = XMLDOMParser.getAttribute(node, "default_style");
        if (string2 != null && string2.length() > 0) {
            bucketSeries.setDefaultRenderStyleName(string2);
        }
        if ((string = XMLDOMParser.getAttribute(node, "default_label_style")) != null && string.length() > 0) {
            bucketSeries.setDefaultLabelStyleName(string);
        }
        if (bl) {
            int n2;
            String[] stringArray;
            ArrayList arrayList2;
            double d = Double.parseDouble(XMLDOMParser.getAttribute(node, "low"));
            double d2 = Double.parseDouble(XMLDOMParser.getAttribute(node, "high"));
            String string3 = XMLDOMParser.getAttribute(node, "styles");
            bucketSeries.setupEqualRangedBuckets(d, d2, n);
            if (string3 != null && string3.length() > 0) {
                arrayList2 = Util.splitBy(string3, ",");
                stringArray = arrayList2.toArray(new String[arrayList2.size()]);
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    bucketSeries.getBucketById("" + n2).setRenderStyleName(stringArray[n2]);
                }
            }
            if ((string3 = XMLDOMParser.getAttribute(node, "label_styles")) != null && string3.length() > 0) {
                arrayList2 = Util.splitBy(string3, ",");
                stringArray = arrayList2.toArray(new String[arrayList2.size()]);
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    bucketSeries.getBucketById("" + n2).setLabelStyleName(stringArray[n2]);
                }
            }
            bucketSeries.setScheme(2);
        } else {
            bucketSeries.setScheme(1);
            for (int i = 0; i < n; ++i) {
                Object object;
                String string4;
                Object object2;
                Object object3;
                String string5;
                Object object4;
                Object object5;
                String string6;
                Node node3 = (Node)arrayList.get(i);
                if (node3.getNodeName().equalsIgnoreCase("RangedBucket")) {
                    string6 = XMLDOMParser.getAttribute(node3, "label");
                    object5 = null;
                    object4 = null;
                    String string7 = XMLDOMParser.getAttribute(node3, "low");
                    if (string7 != null && string7.length() > 0) {
                        object5 = new Field(Double.parseDouble(string7));
                    }
                    if ((string5 = XMLDOMParser.getAttribute(node3, "high")) != null && string5.length() > 0) {
                        object4 = new Field(Double.parseDouble(string5));
                    }
                    object3 = new RangedBucket("" + i, (Field)object5, (Field)object4);
                    if (string6 != null && string6.length() > 0) {
                        ((Bucket)object3).setBucketLabel(string6);
                    }
                    bucketSeries.add((Bucket)object3);
                    object2 = XMLDOMParser.getAttribute(node3, "style");
                    if (object2 != null && ((String)object2).length() > 0) {
                        ((Bucket)object3).setRenderStyleName((String)object2);
                    }
                    if ((object2 = XMLDOMParser.getAttribute(node3, "label_style")) == null || ((String)object2).length() <= 0) continue;
                    ((Bucket)object3).setLabelStyleName((String)object2);
                    continue;
                }
                if (!node3.getNodeName().equalsIgnoreCase("CollectionBucket")) continue;
                string6 = XMLDOMParser.getAttribute(node3, "label");
                object5 = XMLDOMParser.getAttribute(node3, "delimiter");
                object4 = XMLDOMParser.getAttribute(node3, "type");
                boolean bl2 = false;
                string5 = XMLDOMParser.getAttribute(node3, "keep_white_space");
                if (string5 != null && string5.length() > 0 && "TRUE".equalsIgnoreCase(string5)) {
                    bl2 = true;
                }
                if (object5 == null || ((String)object5).length() == 0) {
                    object5 = ",";
                }
                node2 = node3.getFirstChild();
                object3 = bl2 ? node2.getNodeValue() : node2.getNodeValue().trim();
                object2 = Util.splitBy((String)object3, (String)object5);
                ArrayList<Field> arrayList3 = new ArrayList<Field>(((ArrayList)object2).size());
                if (((ArrayList)object2).size() > 0) {
                    for (int j = 0; j < ((ArrayList)object2).size(); ++j) {
                        String string8 = string4 = bl2 ? (String)((ArrayList)object2).get(j) : ((String)((ArrayList)object2).get(j)).trim();
                        if (string4.toUpperCase().indexOf("#DEFAULT#") == 0) {
                            string4 = "#DEFAULT#";
                        }
                        arrayList3.add(Field.createField(string4, (String)object4));
                    }
                } else {
                    object = object3;
                    if (((String)object).toUpperCase().indexOf("#DEFAULT#") == 0) {
                        object = "#DEFAULT#";
                    }
                    arrayList3.add(Field.createField((String)object, (String)object4));
                }
                object = new CollectionBucket("" + i, arrayList3);
                if (string6 != null && string6.length() > 0) {
                    ((Bucket)object).setBucketLabel(string6);
                }
                bucketSeries.add((Bucket)object);
                string4 = XMLDOMParser.getAttribute(node3, "style");
                if (string4 != null && string4.length() > 0) {
                    ((Bucket)object).setRenderStyleName(string4);
                }
                if ((string4 = XMLDOMParser.getAttribute(node3, "label_style")) != null && string4.length() > 0) {
                    ((Bucket)object).setLabelStyleName(string4);
                }
                ((CollectionBucket)object).setDelimiter((String)object5);
                ((CollectionBucket)object).setType((String)object4);
                ((CollectionBucket)object).setKeepWhiteSpace(bl2);
            }
        }
        return bucketSeries;
    }

    public double getEqualRangeMinValue() {
        return this.equalRangeMin;
    }

    public double getEqualRangeMaxValue() {
        return this.equalRangeMax;
    }

    public void addBucket(Bucket bucket) {
        this.bean.getBucketSeries().add(bucket);
    }

    public void linkStyleToBucket(Style style, String string) {
        Bucket bucket = this.bean.getBucketSeries().getBucketById(string);
        if (bucket != null) {
            bucket.setRenderStyle(style);
        }
    }

    public void linkLabelStyleToBucket(Style style, String string) {
        Bucket bucket = this.bean.getBucketSeries().getBucketById(string);
        if (bucket != null) {
            bucket.setLabelStyle(style);
        }
    }

    public int getNumBuckets() {
        return this.bean.getBucketSeries().size();
    }

    public Bucket getBucketById(String string) {
        return this.bean.getBucketSeries().getBucketById(string);
    }

    public Bucket getBucket(int n) {
        return this.bean.getBucketSeries().getBucket(n);
    }

    public int getBucketIndex(Field field) {
        return this.bean.getBucketSeries().getBucketIndex(field);
    }

    public Style chooseStyle(Field field) {
        Bucket bucket = this.pickBucket(field);
        if (bucket == null) {
            return (Style)this.bean.getBucketSeries().getDefaultRenderStyle();
        }
        return (Style)bucket.getRenderStyle();
    }

    public Style chooseLabelStyle(Field field) {
        Bucket bucket = this.pickBucket(field);
        if (bucket == null) {
            return (Style)this.bean.getBucketSeries().getDefaultLabelStyle();
        }
        return (Style)bucket.getLabelStyle();
    }

    public boolean hasCasedLineStyles() {
        return this.hasCasedLineStyles;
    }

    public boolean resolveStyles(StyleCache styleCache, Hashtable hashtable) {
        Cloneable cloneable;
        this.hasCasedLineStyles = false;
        boolean bl = true;
        if (this.bean.getBucketSeries().size() == 0) {
            return true;
        }
        ArrayList arrayList = this.bean.getBucketSeries().getBuckets();
        for (int i = 0; i < arrayList.size(); ++i) {
            Style style;
            cloneable = (Bucket)arrayList.get(i);
            String string = ((Bucket)cloneable).getRenderStyleName();
            if (string != null) {
                style = Util.getStyle(string, styleCache, hashtable);
                if (style != null) {
                    ((Bucket)cloneable).setRenderStyle(style);
                    if (!(style instanceof AdvancedStyle)) {
                        style.resolveStyles(styleCache, hashtable);
                    }
                    if (style instanceof StyleLine && ((StyleLine)style).supportCasedLine()) {
                        this.hasCasedLineStyles = true;
                    }
                } else {
                    bl = false;
                }
            }
            if ((string = ((Bucket)cloneable).getLabelStyleName()) == null) continue;
            style = Util.getStyle(string, styleCache, hashtable);
            if (style != null) {
                ((Bucket)cloneable).setLabelStyle(style);
                if (style instanceof AdvancedStyle) continue;
                style.resolveStyles(styleCache, hashtable);
                continue;
            }
            bl = false;
        }
        String string = this.bean.getBucketSeries().getDefaultRenderStyleName();
        cloneable = (Style)this.bean.getBucketSeries().getDefaultRenderStyle();
        if (string != null && cloneable == null) {
            cloneable = Util.getStyle(string, styleCache, hashtable);
            this.bean.getBucketSeries().setDefaultRenderStyle(cloneable);
        }
        if (cloneable != null && !(cloneable instanceof AdvancedStyle)) {
            cloneable.resolveStyles(styleCache, hashtable);
        }
        string = this.bean.getBucketSeries().getDefaultLabelStyleName();
        cloneable = (Style)this.bean.getBucketSeries().getDefaultLabelStyle();
        if (string != null && cloneable == null) {
            cloneable = Util.getStyle(string, styleCache, hashtable);
            this.bean.getBucketSeries().setDefaultLabelStyle(cloneable);
        }
        if (cloneable != null && !(cloneable instanceof AdvancedStyle)) {
            cloneable.resolveStyles(styleCache, hashtable);
        }
        return bl;
    }

    public Bucket pickBucket(Field field) {
        return this.bean.getBucketSeries().getBucket(field);
    }

    public Style getStyle(String string) {
        Bucket bucket = this.bean.getBucketSeries().getBucketById(string);
        if (bucket != null) {
            return (Style)bucket.getRenderStyle();
        }
        return null;
    }

    public Style getLabelStyle(String string) {
        Bucket bucket = this.bean.getBucketSeries().getBucketById(string);
        if (bucket != null) {
            return (Style)bucket.getLabelStyle();
        }
        return null;
    }

    public int getMaxLegendWidth(Graphics2D graphics2D, int n) {
        Font font;
        int n2 = 0;
        int n3 = 0;
        Font font2 = font = new Font("Serif", 0, n);
        String string = null;
        Style style = null;
        int n4 = 0;
        StyleModifiers styleModifiers = this.convertToPixelSize(null);
        for (int i = 0; i < this.getNumBuckets(); ++i) {
            Object object;
            int n5;
            Bucket bucket = this.bean.getBucketSeries().getBucket(i);
            Style style2 = (Style)bucket.getRenderStyle();
            if (style2 != null && this instanceof VariableMarkerStyle && styleModifiers != null) {
                n5 = ((StyleMarker)style2).getDesiredWidth();
                object = ((VariableMarkerStyle)this).getBaseMarkerName();
                StyleModifiers styleModifiers2 = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers(((String)object).toUpperCase() + "_" + i);
                if (styleModifiers2 != null && styleModifiers2 instanceof MarkerStyleModifiers) {
                    n5 = ((MarkerStyleModifiers)styleModifiers2).getWidth();
                }
                if (n4 < n5) {
                    n4 = n5;
                }
            } else if (style2 != null && this instanceof VariablePieChartStyle && styleModifiers != null) {
                n5 = ((PieChartStyle)style2).getPieRadius() * 2;
                object = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers("PIECHART_" + i);
                if (object != null && object instanceof PieChartStyleModifiers) {
                    n5 = ((PieChartStyleModifiers)object).getPieRadius() * 2;
                }
                if (n4 < n5) {
                    n4 = n5;
                }
            } else if (style2 != null && style2 instanceof StyleMarker) {
                n5 = ((StyleMarker)style2).getDesiredWidth();
                if (styleModifiers != null && styleModifiers instanceof AdvancedStyleModifiers && (object = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers(this.bean.getBucketSeries().getBucket(i).getRenderStyleName().toUpperCase() + "_" + i)) != null && object instanceof MarkerStyleModifiers) {
                    n5 = ((MarkerStyleModifiers)object).getWidth();
                }
                if (n4 < n5) {
                    n4 = n5;
                }
            }
            string = bucket.getBucketLabel();
            if (string == null || string.length() == 0) continue;
            string = string + " ";
            style = (Style)bucket.getLabelStyle();
            font2 = style != null && style instanceof StyleText ? ((StyleText)style).getFont() : font;
            n2 = graphics2D != null ? (int)font2.getStringBounds(string, graphics2D.getFontRenderContext()).getWidth() : (int)font2.getStringBounds(string, frc).getWidth();
            if (n2 <= n3) continue;
            n3 = n2;
        }
        double d = (double)n3 / 0.8 * 0.2 + 3.0;
        n3 = (double)n4 > d ? (n3 += n4 + 3) : (int)((double)n3 + d);
        return n3;
    }

    public void print() {
        int n = this.bean.getBucketSeries().size();
        String[] stringArray = new String[]{"UNDEFINEDBUCKET", "EQUALRANGED", "RANGEDBUCKET", "COLLECTIONBUCKET"};
        System.out.println("Bucket contents:");
        System.out.println("#buckets: " + n);
        for (int i = 0; i < n; ++i) {
            String string = "";
            String string2 = "";
            Bucket bucket = this.bean.getBucketSeries().getBucket(i);
            if (bucket.getBucketLabel() != null) {
                string = bucket.getBucketLabel();
            }
            string2 = bucket.getRenderStyleName();
            System.out.println("  " + i + " - label: " + string + "  style: " + string2 + "\n");
        }
    }

    public static AdvancedStyle create(Document document, StyleCache styleCache, Hashtable hashtable) throws DataException {
        return null;
    }

    public static AdvancedStyle create(Document document, StyleTable styleTable) throws DataException {
        return null;
    }

    public static String[] getStyleNames(Document document) throws DataException {
        return new String[0];
    }

    public StyleModel getModel() {
        return this.bean;
    }

    public void setModel(StyleModel styleModel) {
        if (!(styleModel instanceof BucketStyleModel)) {
            throw new IllegalArgumentException("Not a BucketStyleModel instance.");
        }
        this.bean = (BucketStyleModel)styleModel;
    }

    protected void drawBucketWithLabel(Graphics2D graphics2D, Bucket bucket, Rectangle2D rectangle2D, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        Object object;
        double d = rectangle2D.getHeight();
        double d2 = rectangle2D.getWidth();
        Style style = (Style)bucket.getRenderStyle();
        if (style != null) {
            object = new Rectangle2D.Double(rectangle2D.getMinX(), rectangle2D.getMinY(), d2 * (double)f, d);
            style.apply(null, graphics2D, (Rectangle2D)object, styleModifiers);
        }
        if ((object = bucket.getBucketLabel()) == null) {
            return;
        }
        Style style2 = (Style)bucket.getLabelStyle();
        LineMetrics lineMetrics = null;
        int n = 0;
        int n2 = 0;
        if (style2 == null || !(style2 instanceof StyleText)) {
            Font font = null;
            font = d < 10.0 ? new Font("Serif", 0, 9) : new Font("Serif", 0, 10);
            graphics2D.setFont(font);
            lineMetrics = font.getLineMetrics((String)object, graphics2D.getFontRenderContext());
            n = (int)lineMetrics.getAscent();
            n2 = (int)lineMetrics.getHeight();
            graphics2D.setColor(Color.black);
            int n3 = 0;
            n3 = f2 <= 0.0f ? (int)(rectangle2D.getMinX() + d2 * (double)f + 3.0) : (int)(rectangle2D.getMaxX() - d2 * (double)f2 + 3.0);
            int n4 = (int)(d - (double)n2) / 2;
            if (n4 < 0) {
                n4 = 0;
            }
            int n5 = (int)(rectangle2D.getMinY() + (double)n + (double)n4);
            graphics2D.drawString((String)object, n3, n5);
        } else {
            Font font = ((StyleText)style2).getFont();
            Font font2 = null;
            Color color = null;
            float f3 = -1.0f;
            if (d <= (double)font.getSize()) {
                StyleText styleText = (StyleText)style2;
                font2 = new Font(font.getName(), font.getStyle(), (int)d);
                color = styleText.getColor();
                f3 = ((TextStyleModel)styleText.getModel()).getHaloWidth();
                style2 = new StyleText(font2, color, f3);
            } else {
                font2 = font;
            }
            graphics2D.setFont(font2);
            int n6 = 0;
            n6 = f2 <= 0.0f ? (int)(rectangle2D.getMinX() + d2 * (double)f + 3.0) : (int)(rectangle2D.getMaxX() - d2 * (double)f2 + 3.0);
            int n7 = (int)(rectangle2D.getMinY() + rectangle2D.getHeight() / 2.0);
            ((StyleText)style2).apply(graphics2D, n6, n7, LabelingHints.VALUE_OPOINT_HALIGN_START, 0.0, 0, (String)object, null);
        }
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("Cannot apply BucketStyle to a point.");
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        int n = this.bean.getBucketSeries().size();
        try {
            StyleModifiers styleModifiers2;
            int n2;
            Cloneable cloneable;
            double d = rectangle2D.getMinX();
            double d2 = rectangle2D.getMinY();
            double d3 = (rectangle2D.getHeight() - 4.0) / (double)n;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                cloneable = (Style)this.bean.getBucketSeries().getBucket(i).getRenderStyle();
                if (cloneable != null && cloneable instanceof StyleMarker) {
                    n2 = ((StyleMarker)cloneable).getDesiredWidth();
                    if (styleModifiers != null && styleModifiers instanceof AdvancedStyleModifiers && (styleModifiers2 = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers(this.bean.getBucketSeries().getBucket(i).getRenderStyleName().toUpperCase() + "_" + i)) != null && styleModifiers2 instanceof MarkerStyleModifiers) {
                        n2 = ((MarkerStyleModifiers)styleModifiers2).getWidth();
                    }
                    if (n3 >= n2) continue;
                    n3 = n2;
                    continue;
                }
                if (cloneable == null || !(cloneable instanceof PieChartStyle)) continue;
                n2 = ((PieChartStyle)cloneable).getPieRadius() * 2;
                if (styleModifiers != null && styleModifiers instanceof AdvancedStyleModifiers && (styleModifiers2 = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers(this.bean.getBucketSeries().getBucket(i).getRenderStyleName().toUpperCase() + "_" + i)) != null && styleModifiers2 instanceof PieChartStyleModifiers) {
                    n2 = ((PieChartStyleModifiers)styleModifiers2).getPieRadius() * 2;
                }
                if (n3 >= n2) continue;
                n3 = n2;
            }
            float f = 0.2f;
            if (rectangle2D.getWidth() * (double)f < (double)n3) {
                f = (float)((double)n3 / rectangle2D.getWidth());
            }
            cloneable = new Rectangle2D.Float();
            for (n2 = 0; n2 < n; ++n2) {
                styleModifiers2 = null;
                if (styleModifiers != null && styleModifiers instanceof AdvancedStyleModifiers) {
                    styleModifiers2 = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers(this.bean.getBucketSeries().getBucket(n2).getRenderStyleName().toUpperCase() + "_" + n2);
                }
                Bucket bucket = this.bean.getBucketSeries().getBucket(n2);
                ((Rectangle2D)cloneable).setRect(d, d2 + (double)n2 * d3, rectangle2D.getWidth(), d3);
                this.drawBucketWithLabel(graphics2D, bucket, (Rectangle2D)cloneable, f, 1.0f - f, styleModifiers2);
            }
        }
        catch (Exception exception) {
            graphics2D.drawString(" * bad style *", 10, 10);
        }
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (!(shape instanceof Rectangle2D)) {
            throw new StyleNotApplicableException("BucketStyle not applicable without an attr value.");
        }
        this.apply(null, graphics2D, (Rectangle2D)shape, styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (fieldArray == null) {
            throw new StyleNotApplicableException("BucketStyle not applicable without an attribute value.");
        }
        BucketDescription bucketDescription = this.chooseRenderStyle(fieldArray[0], styleModifiers);
        if (bucketDescription.style != null) {
            if (bucketDescription.style instanceof StyleMarker && bucketDescription.styleMods != null && bucketDescription.styleMods instanceof MarkerStyleModifiers && (((MarkerStyleModifiers)bucketDescription.styleMods).getWidth() < 1 || ((MarkerStyleModifiers)bucketDescription.styleMods).getHeight() < 1)) {
                return;
            }
            bucketDescription.style.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, bucketDescription.styleMods);
        }
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (fieldArray == null) {
            throw new StyleNotApplicableException("BucketStyle not applicable without an attribute value.");
        }
        if (stringArray == null) {
            this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
        } else {
            Field[] fieldArray2 = new Field[]{null};
            String string2 = stringArray[0];
            fieldArray2[0] = Util.getField(string2, fieldArray);
            if (fieldArray2[0] == null) {
                throw new StyleNotApplicableException("Unable to find column " + string2 + " for BucketStyle.");
            }
            this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray2, styleModifiers);
        }
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, Style style, String[] stringArray2, String string2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (fieldArray == null) {
            throw new StyleNotApplicableException("BucketStyle not applicable without an attribute value.");
        }
        if (style == null) {
            this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, stringArray, styleModifiers);
        } else {
            this.applySubStyle(graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, stringArray, style, stringArray2, string2, styleModifiers, false, null, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void applySubStyle(Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, Style style, String[] stringArray2, String string2, StyleModifiers styleModifiers, boolean bl, VisContext visContext, StyledFeatureI styledFeatureI) throws StyleNotApplicableException {
        StyleMarker styleMarker;
        if (style == null) {
            return;
        }
        if (!(style instanceof AdvancedStyle)) throw new StyleNotApplicableException("Just Bucket Styles are accepted as sub-styles");
        if (stringArray2 == null) {
            throw new StyleNotApplicableException("Sub style column must be defined.");
        }
        if (!(style instanceof BucketStyle)) throw new StyleNotApplicableException("Can not use Advanced Style " + style.getModel().getName() + " as sub-style");
        Field field = null;
        String string3 = stringArray2[0];
        field = Util.getField(string3, fieldArray);
        if (field == null) {
            throw new StyleNotApplicableException("Unable to find attribute " + string3 + " for Sub style.");
        }
        Style style2 = ((BucketStyle)style).chooseStyle(field);
        if (style2 == null) {
            log.warning("cannot find a suitable sub style based on your values [" + field + "].");
            return;
        }
        field = fieldArray[0];
        if (stringArray != null && (field = Util.getField(stringArray[0], fieldArray)) == null) {
            throw new StyleNotApplicableException("Unable to find attribute " + stringArray[0] + " for Bucket Style.");
        }
        BucketDescription bucketDescription = this.chooseRenderStyle(field, styleModifiers);
        Style style3 = bucketDescription.style;
        if (style3 == null) {
            log.warning("cannot find a suitable style based on your values [" + field + "].");
            return;
        }
        Color color = null;
        if (style2 instanceof StyleColor) {
            color = ((StyleColor)style2).getFillColor();
        } else if (style2 instanceof StyleLine) {
            color = ((LineStyleModel)style2.getModel()).getFillColor();
        } else {
            if (!(style2 instanceof StyleMarker)) throw new StyleNotApplicableException("Invalid bucket style type of substyle.");
            styleMarker = (StyleMarker)style2;
            int n2 = ((MarkerStyleModel)styleMarker.getModel()).getMarkerType();
            if (n2 == 5 || n2 == 6) {
                throw new StyleNotApplicableException("Substyle marker type must be of vector type.");
            }
            color = styleMarker.getColorStyle().getFillColor();
        }
        if (color == null) return;
        styleMarker = null;
        if (style3 instanceof StyleColor) {
            Color color2 = ((StyleColor)style3).getFillColor();
            ((StyleColor)style3).setFillColor(color);
            style3.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, null);
            ((StyleColor)style3).setFillColor(color2);
            return;
        } else if (style3 instanceof StyleLine) {
            Color color3 = ((LineStyleModel)style3.getModel()).getFillColor();
            ((LineStyleModel)style3.getModel()).setFillColor(color);
            if (!bl || !((StyleLine)style3).supportCasedLine() || n != 2 && n != 6) {
                style3.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, bucketDescription.styleMods);
            } else {
                StyleLine styleLine = (StyleLine)((StyleLine)style3).clone();
                CasedLineHelper casedLineHelper = visContext.getCasedLines();
                casedLineHelper.addStyledFeature(styledFeatureI, shape, styleLine);
            }
            ((LineStyleModel)style3.getModel()).setFillColor(color3);
            return;
        } else {
            if (!(style3 instanceof StyleMarker)) throw new StyleNotApplicableException("Invalid bucket style type of base style.");
            Color color4 = ((StyleMarker)style3).getColorStyle().getStrokeColor();
            StyleColor styleColor = ((StyleMarker)style3).getColorStyle();
            StyleColor styleColor2 = new StyleColor(color, color4);
            ((StyleMarker)style3).setColorStyle(styleColor2);
            style3.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, bucketDescription.styleMods);
            ((StyleMarker)style3).setColorStyle(styleColor);
        }
    }

    public void apply(VisContext visContext, SVGMap sVGMap, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("Cannot apply BucketStyle to a point.");
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        int n = (int)rectangle2D.getCenterX();
        int n2 = (int)rectangle2D.getCenterY();
        int n3 = (int)rectangle2D.getWidth();
        int n4 = (int)rectangle2D.getHeight();
        int n5 = this.bean.getBucketSeries().size();
        try {
            int n6;
            int n7 = n - n3 / 2;
            int n8 = n6 = n2 - n4 / 2;
            int n9 = n4 / n5;
            Rectangle2D.Float float_ = new Rectangle2D.Float();
            for (int i = 0; i < n5; ++i) {
                Bucket bucket = this.bean.getBucketSeries().getBucket(i);
                Style style = (Style)bucket.getRenderStyle();
                int n10 = (int)((double)n3 * 0.2);
                int n11 = n9;
                ((Rectangle2D)float_).setRect(n7, n6 + i * n9, n10, n11);
                int n12 = (int)((double)n7 + (double)n3 * 0.1);
                n8 = n6 + i * n9 + n9 / 2;
                style.apply(null, sVGMap, (Rectangle2D)float_, null);
                String string = bucket.getBucketLabel();
                if (string == null) continue;
                Font font = new Font("Dialog", 0, 10);
                int n13 = n6 + n9 * i + n9 - 3;
                sVGMap.drawText(string, (int)((double)n7 + (double)n3 * 0.2 + 3.0), n13, 0.0, font, Color.black);
            }
        }
        catch (Exception exception) {
            sVGMap.drawText(" * bad style *", 10.0, 10.0, 0.0, new Font("Dialog", 0, 10), Color.black);
        }
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        Style style = this.chooseStyle(fieldArray[0]);
        if (style == null) {
            log.warning("cannot find a suitable style based on your values [" + fieldArray[0] + "].");
            return;
        }
        style.apply(null, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (fieldArray == null) {
            throw new StyleNotApplicableException("BucketStyle not applicable without an attribute value.");
        }
        if (stringArray == null) {
            this.apply(null, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
        } else {
            Field[] fieldArray2 = new Field[]{null};
            String string2 = stringArray[0];
            fieldArray2[0] = Util.getField(string2, fieldArray);
            if (fieldArray2[0] == null) {
                throw new StyleNotApplicableException("Unable to find column " + string2 + " for BucketStyle.");
            }
            this.apply(null, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray2, styleModifiers);
        }
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        Style style2 = this.chooseStyle(fieldArray[0]);
        if (style2 != null) {
            return style2.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, null);
        }
        log.warning("cannot find a suitable style based on your values [" + fieldArray[0] + "].");
        return null;
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (fieldArray == null) {
            throw new StyleNotApplicableException("BucketStyle not applicable without an attribute value.");
        }
        if (stringArray == null) {
            return this.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, styleModifiers);
        }
        Field[] fieldArray2 = new Field[]{null};
        String string4 = stringArray[0];
        fieldArray2[0] = Util.getField(string4, fieldArray);
        if (fieldArray2[0] == null) {
            throw new StyleNotApplicableException("Unable to find column " + string4 + " for BucketStyle.");
        }
        return this.applyToSVG(null, sVGMap, shape, n, fieldArray2, rectangle2D, string, style, string2, d, bl, string3, styleModifiers);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, Style style2, String[] stringArray2, String string4, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        StyleMarker styleMarker;
        if (fieldArray == null) {
            throw new StyleNotApplicableException("BucketStyle not applicable without an attribute value.");
        }
        if (style2 == null) {
            return this.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, stringArray, styleModifiers);
        }
        if (!(style2 instanceof AdvancedStyle)) throw new StyleNotApplicableException("Just Bucket Styles are accepted as sub-styles");
        if (stringArray2 == null) {
            throw new StyleNotApplicableException("Sub style column must be defined.");
        }
        if (!(style2 instanceof BucketStyle)) throw new StyleNotApplicableException("Can not use Advanced Style " + style2.getModel().getName() + " as sub-style");
        Field field = null;
        String string5 = stringArray2[0];
        field = Util.getField(string5, fieldArray);
        if (field == null) {
            throw new StyleNotApplicableException("Unable to find attribute " + string5 + " for Sub style.");
        }
        Style style3 = ((BucketStyle)style2).chooseStyle(field);
        if (style3 == null) {
            log.warning("cannot find a suitable sub style based on your values [" + field + "].");
            return null;
        }
        field = fieldArray[0];
        if (stringArray != null && (field = Util.getField(stringArray[0], fieldArray)) == null) {
            throw new StyleNotApplicableException("Unable to find attribute " + stringArray[0] + " for Bucket Style.");
        }
        Style style4 = this.chooseStyle(field);
        if (style4 == null) {
            log.warning("cannot find a suitable style based on your values [" + field + "].");
            return null;
        }
        Color color = null;
        if (style3 instanceof StyleColor) {
            color = ((StyleColor)style3).getFillColor();
        } else if (style3 instanceof StyleLine) {
            color = ((LineStyleModel)style3.getModel()).getFillColor();
        } else {
            if (!(style3 instanceof StyleMarker)) throw new StyleNotApplicableException("Invalid bucket style type of substyle.");
            styleMarker = (StyleMarker)style3;
            int n2 = ((MarkerStyleModel)styleMarker.getModel()).getMarkerType();
            if (n2 == 5 || n2 == 6) {
                throw new StyleNotApplicableException("Substyle marker type must be of vector type.");
            }
            color = styleMarker.getColorStyle().getFillColor();
        }
        if (color == null) throw new StyleNotApplicableException("Unable to get substyle color.");
        styleMarker = null;
        if (style4 instanceof StyleColor) {
            Color color2 = ((StyleColor)style4).getFillColor();
            ((StyleColor)style4).setFillColor(color);
            style4.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, null);
            ((StyleColor)style4).setFillColor(color2);
            return null;
        } else if (style4 instanceof StyleLine) {
            Color color3 = ((LineStyleModel)style4.getModel()).getFillColor();
            ((LineStyleModel)style4.getModel()).setFillColor(color);
            style4.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, null);
            ((LineStyleModel)style4.getModel()).setFillColor(color3);
            return null;
        } else {
            if (!(style4 instanceof StyleMarker)) throw new StyleNotApplicableException("Invalid bucket style type of base style.");
            Color color4 = ((StyleMarker)style4).getColorStyle().getStrokeColor();
            StyleColor styleColor = ((StyleMarker)style4).getColorStyle();
            StyleColor styleColor2 = new StyleColor(color, color4);
            ((StyleMarker)style4).setColorStyle(styleColor2);
            style4.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, null);
            ((StyleMarker)style4).setColorStyle(styleColor);
        }
        return null;
    }

    public Object getPropertyValue(String string) {
        return null;
    }

    public StyleModifiers convertToPixelSize(VisContext visContext) {
        boolean bl = false;
        if (visContext == null || Util.isFullExtent(visContext.getQueryWindow().getMinX(), visContext.getQueryWindow().getMinX(), visContext.getQueryWindow().getMaxX(), visContext.getQueryWindow().getMaxY()) || visContext.getQueryWindow().getWidth() == 0.0 && visContext.getQueryWindow().getHeight() == 0.0) {
            bl = true;
        }
        int n = 7;
        int n2 = 4;
        AdvancedStyleModifiers advancedStyleModifiers = new AdvancedStyleModifiers();
        StyleModifiers styleModifiers = null;
        Style style = this.getDefaultStyle();
        if (style != null && (styleModifiers = style.convertToPixelSize(visContext)) != null) {
            if (this.getDefaultStyleName() != null) {
                advancedStyleModifiers.addStyleModifiers(this.getDefaultStyleName().toUpperCase(), styleModifiers);
            } else {
                log.warning("Default style name is null. Not added to style modifiers list.");
            }
        }
        int n3 = this.getNumBuckets();
        for (int i = 0; i < n3; ++i) {
            Object object;
            Style style2 = (Style)this.getBucket(i).getRenderStyle();
            if (style2 != null && (styleModifiers = style2.convertToPixelSize(visContext)) != null) {
                object = this.getBucket(i).getRenderStyleName();
                if (this instanceof VariableMarkerStyle) {
                    object = ((VariableMarkerStyle)this).getBaseMarkerName();
                    if (bl && !((MarkerStyleModel)style2.getModel()).getMarkerSize().isPixelUnit()) {
                        ((MarkerStyleModifiers)styleModifiers).setWidth(n);
                        ((MarkerStyleModifiers)styleModifiers).setHeight(n);
                        n += n2;
                    }
                } else if (this instanceof VariablePieChartStyle) {
                    object = "PIECHART";
                    if (bl && !((PieChartStyleModel)style2.getModel()).getPieRadiusSize().isPixelUnit()) {
                        ((PieChartStyleModifiers)styleModifiers).setPieRadius(n);
                        n += n2;
                    }
                }
                if (object != null) {
                    advancedStyleModifiers.addStyleModifiers(((String)object).toUpperCase() + "_" + i, styleModifiers);
                } else {
                    log.warning("Bucket " + i + " render style name is null. Not added to style modifiers list.");
                }
            }
            if ((object = (Style)this.getBucket(i).getLabelStyle()) == null || (styleModifiers = object.convertToPixelSize(visContext)) == null) continue;
            if (this.getBucket(i).getLabelStyleName() != null) {
                advancedStyleModifiers.addStyleModifiers(this.getBucket(i).getLabelStyleName().toUpperCase() + "_" + i, styleModifiers);
                continue;
            }
            log.warning("Bucket " + i + " label style name is null. Not added to style modifiers list.");
        }
        if (advancedStyleModifiers.getStyleModifiers().size() == 0) {
            return null;
        }
        return advancedStyleModifiers;
    }

    public BucketDescription chooseRenderStyle(Field field, StyleModifiers styleModifiers) {
        int n;
        BucketDescription bucketDescription = new BucketDescription();
        if (field == null) {
            return bucketDescription;
        }
        bucketDescription.bucketIndex = n = this.bean.getBucketSeries().getBucketIndex(field);
        bucketDescription.style = n < 0 ? (Style)this.bean.getBucketSeries().getDefaultRenderStyle() : (Style)this.bean.getBucketSeries().getBucket(n).getRenderStyle();
        if (bucketDescription.style != null && n > -1 && styleModifiers != null && styleModifiers instanceof AdvancedStyleModifiers) {
            String string = this.bean.getBucketSeries().getBucket(n).getRenderStyleName();
            if (this instanceof VariableMarkerStyle) {
                string = ((VariableMarkerStyle)this).getBaseMarkerName();
            } else if (this instanceof VariablePieChartStyle) {
                string = "PIECHART";
            }
            bucketDescription.styleMods = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers(string.toUpperCase() + "_" + n);
        }
        return bucketDescription;
    }

    public void applyDeferringCasedLines(Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers, VisContext visContext, StyledFeatureI styledFeatureI) throws StyleNotApplicableException {
        if (fieldArray == null) {
            throw new StyleNotApplicableException("BucketStyle not applicable without an attribute value.");
        }
        BucketDescription bucketDescription = this.chooseRenderStyle(fieldArray[0], styleModifiers);
        if (bucketDescription.style != null) {
            if (bucketDescription.style instanceof StyleMarker && bucketDescription.styleMods != null && bucketDescription.styleMods instanceof MarkerStyleModifiers && (((MarkerStyleModifiers)bucketDescription.styleMods).getWidth() < 1 || ((MarkerStyleModifiers)bucketDescription.styleMods).getHeight() < 1)) {
                return;
            }
            if ((n == 2 || n == 6) && bucketDescription.style instanceof StyleLine && ((StyleLine)bucketDescription.style).supportCasedLine()) {
                CasedLineHelper casedLineHelper = visContext.getCasedLines();
                casedLineHelper.addStyledFeature(styledFeatureI, shape, bucketDescription.style);
            } else {
                bucketDescription.style.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, bucketDescription.styleMods);
            }
        }
    }

    public void applyDeferringCasedLines(Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, Style style, String[] stringArray2, String string2, StyleModifiers styleModifiers, VisContext visContext, StyledFeatureI styledFeatureI) throws StyleNotApplicableException {
        if (fieldArray == null) {
            throw new StyleNotApplicableException("BucketStyle not applicable without an attribute value.");
        }
        if (style == null) {
            if (stringArray == null) {
                this.applyDeferringCasedLines(graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers, visContext, styledFeatureI);
            } else {
                Field[] fieldArray2 = new Field[]{null};
                String string3 = stringArray[0];
                fieldArray2[0] = Util.getField(string3, fieldArray);
                if (fieldArray2[0] == null) {
                    throw new StyleNotApplicableException("Unable to find column " + string3 + " for BucketStyle.");
                }
                this.applyDeferringCasedLines(graphics2D, shape, n, string, point2D, conflictResolver, fieldArray2, styleModifiers, visContext, styledFeatureI);
            }
        } else {
            this.applySubStyle(graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, stringArray, style, stringArray2, string2, styleModifiers, true, visContext, styledFeatureI);
        }
    }

    public class BucketDescription {
        public Style style = null;
        public StyleModifiers styleMods = null;
        public int bucketIndex = -1;
    }
}

