/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stylex;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.LabelingHints;
import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.stylex.BarChartStyleModel;
import oracle.mapviewer.share.stylex.BarInfo;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SphereCG;
import oracle.sdovis.LabelHelper;
import oracle.sdovis.SRS;
import oracle.sdovis.SVGMap;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.stylex.AdvancedStyle;
import oracle.sdovis.stylex.BarChartStyleModifiers;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.RectArray;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class BarChartStyle
implements AdvancedStyle {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private BarChartStyleModel bean;

    public BarChartStyle() {
        this.bean = new BarChartStyleModel();
    }

    public BarChartStyle(StyleModel styleModel) {
        this.setModel(styleModel);
    }

    public BarChartStyle(int n, int n2, BarInfo[] barInfoArray) {
        this.bean = new BarChartStyleModel(barInfoArray);
        this.bean.setWidth(n);
        this.bean.setHeight(n2);
    }

    public BarChartStyle(Document document) throws StyleException {
        this.bean = new BarChartStyleModel();
        try {
            String string;
            Node node = XMLDOMParser.getSubElement(document, "AdvancedStyle");
            node = XMLDOMParser.getSubElement(node, "BarChartStyle");
            String string2 = XMLDOMParser.getAttribute(node, "width");
            String string3 = XMLDOMParser.getAttribute(node, "height");
            SizeDefinition2D sizeDefinition2D = SizeDefinition2D.parse(string2, string3);
            if (sizeDefinition2D == null) {
                throw new StyleException("Invalid bar size in BarChartStyle definition.");
            }
            this.bean.setWidth(sizeDefinition2D.getWidth());
            this.bean.setHeight(sizeDefinition2D.getHeight());
            this.bean.setSizeUnit(sizeDefinition2D.getUnit());
            String string4 = XMLDOMParser.getAttribute(node, "share_scale");
            if (string4 != null && "false".equalsIgnoreCase(string4)) {
                this.bean.setShareScale(false);
            }
            if ((string = XMLDOMParser.getAttribute(node, "show_x_axis")) != null && "true".equalsIgnoreCase(string)) {
                this.bean.setShowXAxis(true);
            }
            double d = Double.NaN;
            double d2 = Double.NaN;
            String string5 = XMLDOMParser.getAttribute(node, "min_value");
            if (string5 != null && string5.length() > 0) {
                d = Double.parseDouble(string5);
            }
            if ((string5 = XMLDOMParser.getAttribute(node, "max_value")) != null && string5.length() > 0) {
                d2 = Double.parseDouble(string5);
            }
            if (!Double.isNaN(d) && !Double.isNaN(d2)) {
                this.bean.setMinMaxValues(d, d2);
            }
            ArrayList arrayList = XMLDOMParser.getSubElements(node, "Bar");
            BarInfo[] barInfoArray = new BarInfo[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                Node node2 = (Node)arrayList.get(i);
                BarInfo barInfo = new BarInfo();
                barInfo.setName(XMLDOMParser.getAttribute(node2, "name"));
                try {
                    barInfo.setColor(StyleUtils.getColor(XMLDOMParser.getAttribute(node2, "color")));
                }
                catch (Exception exception) {
                    barInfo.setColor(Color.black);
                }
                barInfoArray[i] = barInfo;
            }
            this.bean.setBars(barInfoArray);
        }
        catch (Exception exception) {
            throw new StyleException("Invalid BarChartStyle definition.", exception);
        }
    }

    public Object clone() {
        try {
            BarChartStyle barChartStyle = (BarChartStyle)super.clone();
            barChartStyle.setModel((StyleModel)this.bean.clone());
            return barChartStyle;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public int getMaxLegendWidth(Graphics2D graphics2D, int n) {
        int n2 = 0;
        int n3 = 0;
        Font font = new Font("Serif", 0, n);
        String string = null;
        BarInfo[] barInfoArray = this.bean.getBars();
        FontRenderContext fontRenderContext = graphics2D == null ? new FontRenderContext(null, true, false) : graphics2D.getFontRenderContext();
        for (int i = 0; i < this.bean.getNumBars(); ++i) {
            string = barInfoArray[i].getName();
            if (string == null || string.length() == 0 || (n2 = (int)font.getStringBounds(string, fontRenderContext).getWidth()) <= n3) continue;
            n3 = n2;
        }
        return n3;
    }

    public StyleModel getModel() {
        return this.bean;
    }

    public void setModel(StyleModel styleModel) {
        if (!(styleModel instanceof BarChartStyleModel)) {
            throw new IllegalArgumentException("Not a BarChartStyleModel instance.");
        }
        this.bean = (BarChartStyleModel)styleModel;
    }

    public String getDefinition() {
        return this.bean.toXMLString();
    }

    public void setDimension(int n, int n2) {
        this.bean.setWidth(n);
        this.bean.setHeight(n2);
    }

    public boolean resolveStyles(StyleCache styleCache, Hashtable hashtable) {
        return true;
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("BarChartStyle not applicable to a point.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(VisContext visContext, Graphics2D graphics2D, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        int n;
        int n2 = this.bean.getNumBars();
        if (n2 <= 0) {
            return;
        }
        int n3 = 100 / (n2 / 2 + 1);
        int n4 = (int)Math.ceil((double)n2 / 2.0) - 1;
        double[] dArray = new double[n2];
        dArray[n4] = 96.0;
        for (n = 1; n <= n2 / 2; ++n) {
            try {
                dArray[n4 - n] = 100 - n * n3;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dArray[n4 + n] = 100 - n * n3;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        n = this.bean.isShareScale() ? 1 : 0;
        boolean bl = this.bean.isShowXAxis();
        this.bean.setShareScale(false);
        this.bean.setShowXAxis(true);
        try {
            this.drawBarChart(graphics2D, rectangle2D, dArray, true);
        }
        finally {
            this.bean.setShareScale(n != 0);
            this.bean.setShowXAxis(bl);
        }
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (!(shape instanceof Rectangle2D)) {
            throw new StyleNotApplicableException("BarChartStyle not applicable without values.");
        }
        this.apply(null, graphics2D, (Rectangle2D)shape, styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        int n2;
        int n3 = this.bean.getWidth();
        int n4 = this.bean.getHeight();
        if (styleModifiers != null && styleModifiers instanceof BarChartStyleModifiers) {
            n3 = ((BarChartStyleModifiers)styleModifiers).getBarWidth();
            n4 = ((BarChartStyleModifiers)styleModifiers).getBarHeight();
        }
        if (point2D == null) {
            if (n == 3 || n == 7) {
                float[] fArray = LabelHelper.findLoc4RectInPolygon(shape, 5.0, 5.0, (RectArray)conflictResolver, true, false, null);
                if (fArray != null) {
                    point2D = new Point2D.Float(fArray[0], fArray[1]);
                }
            } else {
                return;
            }
        }
        if (point2D != null && conflictResolver != null) {
            conflictResolver.insert(point2D.getX() - (double)(n3 / 2), point2D.getY() - (double)(n4 / 2), (double)n3, (double)n4);
        }
        int n5 = this.bean.getNumBars();
        if (fieldArray == null || fieldArray.length < n5) {
            log.warning("Insufficient attribute fields for the given bar chart style.");
            return;
        }
        double[] dArray = new double[n5];
        try {
            for (n2 = 0; n2 < n5; ++n2) {
                dArray[n2] = fieldArray[n2].isNoData() ? Double.NaN : (fieldArray[n2].getShortJavaTypeName().equalsIgnoreCase("string") ? Double.parseDouble(fieldArray[n2].getString()) : fieldArray[n2].getDouble());
            }
        }
        catch (Exception exception) {
            log.warning("invalid (type of) values for BarChartStyle.");
            return;
        }
        n2 = (int)point2D.getX();
        int n6 = (int)point2D.getY();
        this.drawBarChart(graphics2D, new Rectangle2D.Double(n2 - n3 / 2, n6 - n4 / 2, n3, n4), dArray, false);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (fieldArray == null) {
            throw new StyleNotApplicableException("BarChartStyle not applicable without attribute values.");
        }
        int n2 = this.bean.getNumBars();
        if (stringArray == null) {
            this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
        } else {
            if (n2 < 1) {
                throw new StyleNotApplicableException("BarChartStyle must have at least one bar.");
            }
            if (stringArray.length < n2) {
                throw new StyleNotApplicableException("Not enough style columns for BarChartStyle.");
            }
            Field[] fieldArray2 = new Field[n2];
            for (int i = 0; i < stringArray.length; ++i) {
                fieldArray2[i] = null;
                String string2 = stringArray[i];
                fieldArray2[i] = Util.getField(string2, fieldArray);
                if (fieldArray2[i] != null) continue;
                throw new StyleNotApplicableException("Unable to find attribute " + string2 + " for BarChartStyle.");
            }
            this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray2, styleModifiers);
        }
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, Style style, String[] stringArray2, String string2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (stringArray == null) {
            this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
        } else {
            this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, stringArray, styleModifiers);
        }
    }

    public void apply(VisContext visContext, SVGMap sVGMap, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return null;
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return null;
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, Style style2, String[] stringArray2, String string4, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return null;
    }

    public void drawBarChart(Graphics2D graphics2D, Rectangle2D rectangle2D, double[] dArray, boolean bl) {
        Serializable serializable;
        int n;
        int n2 = this.bean.getNumBars();
        double d = rectangle2D.getWidth();
        double d2 = rectangle2D.getHeight();
        double d3 = (d - (double)n2 + 1.0) / (double)n2;
        double d4 = 0.0;
        double d5 = this.bean.getMinValue();
        double d6 = this.bean.getMaxValue();
        if (d3 < 1.0) {
            d3 = 1.0;
        }
        double d7 = dArray[0];
        double d8 = dArray[0];
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isNaN(dArray[i])) continue;
            if (d8 < dArray[i]) {
                d8 = dArray[i];
            }
            if (!(d7 > dArray[i])) continue;
            d7 = dArray[i];
        }
        if (!this.bean.isShareScale() || Double.isNaN(d5) || Double.isNaN(d6)) {
            d5 = d7;
            d6 = d8;
        }
        double d9 = d6 - (d5 < 0.0 ? d5 : 0.0);
        int n3 = 6;
        if (!bl) {
            n3 = 0;
        }
        d4 = (d2 - (double)n3) / d9;
        int n4 = 0;
        if (d7 < 0.0) {
            n4 = (int)(Math.abs(d7) * d4);
        }
        float[] fArray = bl ? new float[n2] : null;
        float[] fArray2 = bl ? new float[n2] : null;
        double d10 = rectangle2D.getMinX();
        for (n = 0; n < n2; ++n) {
            BarInfo barInfo = this.bean.getBarInfo(n);
            serializable = barInfo.getColor();
            graphics2D.setColor((Color)serializable);
            double d11 = dArray[n];
            double d12 = rectangle2D.getMaxY() - (double)n4 + (double)n3;
            double d13 = 0.0;
            if (!Double.isNaN(d11)) {
                d13 = Math.abs(d11) * d4;
            }
            if (d11 >= 0.0) {
                d12 -= d13;
            }
            if ((int)d12 + (int)d13 < (int)rectangle2D.getMaxY()) {
                d13 += 1.0;
            }
            graphics2D.fillRect((int)d10, (int)d12, (int)d3, (int)d13);
            if (bl) {
                fArray[n] = (float)(d10 + d3 / 2.0);
                fArray2[n] = (float)(d12 - 6.0);
            }
            d10 += d3 + 1.0;
        }
        if (bl) {
            StyleText styleText = new StyleText(new Font("serif", 0, 9), Color.black, 2.0f);
            for (int i = 0; i < n2; ++i) {
                serializable = this.bean.getBarInfo(i);
                String string = ((BarInfo)serializable).getName();
                try {
                    styleText.apply(graphics2D, fArray[i], fArray2[i], LabelingHints.VALUE_OPOINT_HALIGN_CENTER, 0.0, 0, string, null);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.bean.isShowXAxis()) {
            graphics2D.setColor(Color.gray);
            n = (int)rectangle2D.getMaxY() - n4 + n3;
            if ((double)n >= rectangle2D.getMaxY()) {
                --n;
            }
            graphics2D.drawLine((int)rectangle2D.getMinX() - 1, n, (int)(d10 + 1.0), n);
        }
    }

    public Object getPropertyValue(String string) {
        return null;
    }

    public StyleModifiers convertToPixelSize(VisContext visContext) {
        if (this.bean.getBarSize().isPixelUnit()) {
            return null;
        }
        BarChartStyleModifiers barChartStyleModifiers = new BarChartStyleModifiers();
        if (visContext == null || Util.isFullExtent(visContext.getQueryWindow().getMinX(), visContext.getQueryWindow().getMinX(), visContext.getQueryWindow().getMaxX(), visContext.getQueryWindow().getMaxY()) || visContext.getQueryWindow().getWidth() == 0.0 && visContext.getQueryWindow().getHeight() == 0.0) {
            if (this.bean.getBarSize().isPixelUnit()) {
                barChartStyleModifiers.setBarWidth(this.bean.getWidth());
                barChartStyleModifiers.setBarHeight(this.bean.getHeight());
            }
        } else {
            Rectangle2D rectangle2D = visContext.getDeviceWindow();
            Rectangle2D rectangle2D2 = visContext.getQueryWindow();
            double d = rectangle2D2.getWidth() / rectangle2D.getWidth();
            double d2 = rectangle2D2.getHeight() / rectangle2D.getHeight();
            Double d3 = null;
            if (this.bean.getSizeUnit() != null) {
                d3 = SRS.getDistanceConversionFactor(this.bean.getSizeUnit());
            }
            if (this.bean.getBarSize().isPixelUnit()) {
                barChartStyleModifiers.setBarWidth(this.bean.getWidth());
                barChartStyleModifiers.setBarHeight(this.bean.getHeight());
            } else if (d3 != null) {
                double d4;
                double d5 = this.bean.getDoubleWidth() * d3;
                if (visContext.getSrs() != null && visContext.getSrs().isGeodetic()) {
                    d4 = SphereCG.convertRadius(0.0, 0.0, d5);
                    barChartStyleModifiers.setBarWidth((int)(d4 / d + 0.5));
                } else {
                    barChartStyleModifiers.setBarWidth((int)(d5 / d + 0.5));
                }
                d4 = this.bean.getDoubleHeight() * d3;
                if (visContext.getSrs() != null && visContext.getSrs().isGeodetic()) {
                    double d6 = SphereCG.convertRadius(0.0, 0.0, d4);
                    barChartStyleModifiers.setBarHeight((int)(d6 / d2 + 0.5));
                } else {
                    barChartStyleModifiers.setBarHeight((int)(d4 / d2 + 0.5));
                }
            }
        }
        return barChartStyleModifiers;
    }
}

