/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.style;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.LabelingHints;
import oracle.mapviewer.share.style.TextStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.style.TextStyleModifiers;
import oracle.sdovis.util.RectArray;
import oracle.sdovis.util.ShapeUtil;

public class TextPath {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static final FontRenderContext frc = new FontRenderContext(null, true, false);
    private TextStyleModel bean;
    private TextStyleModifiers textmods = null;
    private Font font;
    private GlyphVector glyphVector;
    private int nGlyphs;
    private AffineTransform at = new AffineTransform();
    private AffineTransform glyphTransform = new AffineTransform();
    private double ascent;
    static int MIN_GLYPH_WIDTH = 4;
    static int GROW_SIZE = 32;

    public TextPath(TextStyleModel textStyleModel, TextStyleModifiers textStyleModifiers) {
        this.bean = textStyleModel;
        this.textmods = textStyleModifiers;
        this.font = this.bean.getFont();
        Font font = this.bean.getFont();
        if (textStyleModifiers != null) {
            font = this.font.deriveFont((float)textStyleModifiers.getFontSize());
        }
        LineMetrics lineMetrics = font.getLineMetrics("ljqLJQ", frc);
        this.ascent = lineMetrics.getAscent();
    }

    public TextStyleModifiers getTextStyleModifiers() {
        return this.textmods;
    }

    public double getAscent() {
        return this.ascent;
    }

    public TextStyleModel getBean() {
        return this.bean;
    }

    public void setBean(TextStyleModel textStyleModel) {
        this.bean = textStyleModel;
    }

    public FontRenderContext getFrc() {
        return frc;
    }

    public Shape putTextOnPath(Graphics2D graphics2D, Shape shape, String string, double d, RectArray rectArray, boolean bl, boolean bl2, boolean bl3) {
        int n;
        boolean bl4 = false;
        GeneralPath generalPath = new GeneralPath();
        CandidateRuns[] candidateRunsArray = this.getCandidates(shape, d);
        block0: for (int i = 0; !(i >= candidateRunsArray.length || bl4 && bl2); ++i) {
            CandidateRuns candidateRuns = candidateRunsArray[i];
            if (candidateRuns.size <= 1 || candidateRuns.len < d) continue;
            n = -1;
            for (int j = 0; j < 3; ++j) {
                int n2 = candidateRuns.indexes[j];
                if (n2 < 0 || n2 == n) continue;
                Shape shape2 = this.putTextOnPath(candidateRuns.x, candidateRuns.y, n2, candidateRuns.numPoints[j], string, rectArray, bl, bl3);
                if (shape2 != null) {
                    generalPath.append(shape2, false);
                    bl4 = true;
                    continue block0;
                }
                n = n2;
            }
        }
        if (bl4 || !bl) {
            return generalPath;
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        int n3 = (int)rectangle2D.getCenterX();
        n = (int)rectangle2D.getCenterY();
        double[] dArray = ShapeUtil.getEndPoints(shape);
        double d2 = 0.0;
        if (dArray != null) {
            if (!bl3 && dArray[2] < dArray[0]) {
                double d3 = dArray[0];
                double d4 = dArray[1];
                dArray[0] = dArray[2];
                dArray[1] = dArray[3];
                dArray[2] = d3;
                dArray[3] = d4;
            }
            d2 = Math.atan2(dArray[3] - dArray[1], dArray[2] - dArray[0]);
        }
        Font font = this.font;
        if (this.font != null && this.textmods != null) {
            font = this.font.deriveFont((float)this.textmods.getFontSize());
        }
        GlyphVectorInfo glyphVectorInfo = new GlyphVectorInfo();
        glyphVectorInfo.txt = string;
        this.glyphVector = font.createGlyphVector(frc, string);
        this.glyphVector.performDefaultLayout();
        glyphVectorInfo.visualBounds = this.glyphVector.getVisualBounds();
        glyphVectorInfo.avgGW = glyphVectorInfo.visualBounds.getWidth() / (double)this.glyphVector.getNumGlyphs();
        glyphVectorInfo.visualCenterY = glyphVectorInfo.visualBounds.getCenterY();
        Point2D point2D = this.glyphVector.getGlyphPosition(0);
        glyphVectorInfo.ngx = point2D.getX();
        glyphVectorInfo.ngy = point2D.getY();
        Object object = this.bean.getLabelingHint(LabelingHints.KEY_LINE_VALIGN);
        if (object == null) {
            object = LabelingHints.VALUE_LINE_VALIGN_BASELINE;
        }
        double[] dArray2 = this.getGlyphOffset(glyphVectorInfo, 0.0, object);
        return StyleText.getLayout(graphics2D, string, n3, n, LabelingHints.VALUE_OPOINT_HALIGN_CENTER, d2, (int)dArray2[1], this.bean, this.textmods);
    }

    private CandidateRuns[] getCandidates(Shape shape, double d) {
        Vector<CandidateRuns> vector = null;
        PathIterator pathIterator = shape.getPathIterator(null);
        float[] fArray = new float[6];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        double d2 = 0.0;
        int n = 0;
        CandidateRuns candidateRuns = new CandidateRuns();
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    f = fArray[0];
                    f2 = fArray[1];
                    if (n == 0) {
                        candidateRuns.append(f, f2, d);
                        break;
                    }
                    if (f == f3 && f2 == f4) break;
                    candidateRuns.setStartingIndexes(d);
                    if (vector == null) {
                        vector = new Vector<CandidateRuns>(1);
                    }
                    vector.add(candidateRuns);
                    candidateRuns = new CandidateRuns();
                    candidateRuns.append(f, f2, d);
                    break;
                }
                case 1: {
                    f3 = fArray[0];
                    f4 = fArray[1];
                    candidateRuns.append(f3, f4, d);
                }
            }
            ++n;
            pathIterator.next();
        }
        candidateRuns.setStartingIndexes(d);
        if (vector == null) {
            return new CandidateRuns[]{candidateRuns};
        }
        vector.add(candidateRuns);
        return vector.toArray(new CandidateRuns[vector.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Shape putTextOnPath(float[] fArray, float[] fArray2, int n, int n2, String string, RectArray rectArray, boolean bl, boolean bl2) {
        SegmentCtl segmentCtl;
        Object object;
        boolean bl3;
        block21: {
            if (n2 <= 1) {
                return null;
            }
            bl3 = false;
            if (!bl2) {
                bl3 = this.ensureUpRight(fArray, fArray2, n, n2);
            }
            object = null;
            if (bl3 && this.bean.isSmartPathFollowing() && (object = this.bean.getLabelingHint(LabelingHints.KEY_LINE_VALIGN)) != null) {
                if (object == LabelingHints.VALUE_LINE_VALIGN_BOTTOM) {
                    this.bean.setLabelingHint(LabelingHints.KEY_LINE_VALIGN, LabelingHints.VALUE_LINE_VALIGN_TOP);
                } else if (object == LabelingHints.VALUE_LINE_VALIGN_TOP) {
                    this.bean.setLabelingHint(LabelingHints.KEY_LINE_VALIGN, LabelingHints.VALUE_LINE_VALIGN_BOTTOM);
                }
            }
            Font font = this.font;
            if (this.font != null && this.textmods != null) {
                font = this.font.deriveFont((float)this.textmods.getFontSize());
            }
            segmentCtl = new SegmentCtl();
            GlyphVectorInfo glyphVectorInfo = new GlyphVectorInfo();
            glyphVectorInfo.txt = string;
            this.glyphVector = font.createGlyphVector(frc, string);
            this.glyphVector.performDefaultLayout();
            this.nGlyphs = this.glyphVector.getNumGlyphs();
            glyphVectorInfo.visualBounds = this.glyphVector.getVisualBounds();
            glyphVectorInfo.avgGW = glyphVectorInfo.visualBounds.getWidth() / (double)this.glyphVector.getNumGlyphs();
            glyphVectorInfo.visualCenterY = glyphVectorInfo.visualBounds.getCenterY();
            Point2D point2D = this.glyphVector.getGlyphPosition(0);
            glyphVectorInfo.ngx = point2D.getX();
            glyphVectorInfo.ngy = point2D.getY();
            segmentCtl.sx = fArray[n];
            segmentCtl.sy = fArray2[n];
            for (int i = n + 1; i < n + n2; ++i) {
                segmentCtl.ex = fArray[i];
                segmentCtl.ey = fArray2[i];
                if (this.processSegment(segmentCtl, glyphVectorInfo, i == fArray.length - 1, rectArray, bl)) break;
                segmentCtl.sx = segmentCtl.ex;
                segmentCtl.sy = segmentCtl.ey;
            }
            if (glyphVectorInfo.ngi >= this.nGlyphs - 1 && !segmentCtl.abort) break block21;
            Shape shape = null;
            Object var17_19 = null;
            if (bl3) {
                this.reorient(fArray, fArray2, n, n2);
                if (object != null && this.bean.isSmartPathFollowing()) {
                    this.bean.setLabelingHint(LabelingHints.KEY_LINE_VALIGN, object);
                }
            }
            return shape;
        }
        try {
            if (rectArray != null) {
                rectArray.addAll(segmentCtl.mbrs);
            }
            GeneralPath generalPath = segmentCtl.s;
            Object var17_20 = null;
            if (bl3) {
                this.reorient(fArray, fArray2, n, n2);
                if (object != null && this.bean.isSmartPathFollowing()) {
                    this.bean.setLabelingHint(LabelingHints.KEY_LINE_VALIGN, object);
                }
            }
            return generalPath;
        }
        catch (Exception exception) {
            try {
                log.log(Level.INFO, exception.getMessage(), exception);
                segmentCtl = null;
                Object var17_21 = null;
                if (bl3) {
                    this.reorient(fArray, fArray2, n, n2);
                    if (object != null && this.bean.isSmartPathFollowing()) {
                        this.bean.setLabelingHint(LabelingHints.KEY_LINE_VALIGN, object);
                    }
                }
                return segmentCtl;
            }
            catch (Throwable throwable) {
                block22: {
                    Object var17_22 = null;
                    if (!bl3) break block22;
                    this.reorient(fArray, fArray2, n, n2);
                    if (object != null && this.bean.isSmartPathFollowing()) {
                        this.bean.setLabelingHint(LabelingHints.KEY_LINE_VALIGN, object);
                    }
                }
                throw throwable;
            }
        }
    }

    private boolean processSegment(SegmentCtl segmentCtl, GlyphVectorInfo glyphVectorInfo, boolean bl, RectArray rectArray, boolean bl2) {
        double d = Point2D.distance(segmentCtl.sx, segmentCtl.sy, segmentCtl.ex, segmentCtl.ey);
        double d2 = Math.atan2(segmentCtl.ey - segmentCtl.sy, segmentCtl.ex - segmentCtl.sx);
        if (Math.abs(d2) > 2.199114857512855 && !bl2) {
            segmentCtl.abort = true;
            return true;
        }
        double d3 = (segmentCtl.ex - segmentCtl.sx) / d;
        double d4 = (segmentCtl.ey - segmentCtl.sy) / d;
        double d5 = segmentCtl.sx;
        double d6 = segmentCtl.sy;
        if (glyphVectorInfo.ngi != 0) {
            Point2D point2D = this.getRealStartPoint(segmentCtl, glyphVectorInfo);
            if (point2D == null) {
                segmentCtl.abort = true;
                return true;
            }
            if (point2D.distance(segmentCtl.ex, segmentCtl.ey) <= d) {
                d5 = point2D.getX();
                d6 = point2D.getY();
            }
        }
        double d7 = this.glyphVector.getGlyphLogicalBounds(glyphVectorInfo.ngi).getBounds2D().getWidth();
        d5 += d7 * 0.5 * d3;
        d6 += d7 * 0.5 * d4;
        Object object = this.bean.getLabelingHint(LabelingHints.KEY_LINE_VALIGN);
        if (object == null) {
            object = LabelingHints.VALUE_LINE_VALIGN_BASELINE;
        }
        double[] dArray = this.getGlyphOffset(glyphVectorInfo, d2, object);
        double d8 = dArray[0];
        double d9 = dArray[1];
        if (glyphVectorInfo.ngi > 0 && Math.abs(d2 - segmentCtl.previousAngle) > 1.4) {
            ++segmentCtl.numSharpTurns;
            if (segmentCtl.numSharpTurns >= 3 && !bl2) {
                segmentCtl.abort = true;
                return true;
            }
        }
        segmentCtl.previousAngle = d2;
        segmentCtl.fits = true;
        while (segmentCtl.fits) {
            Shape shape = this.glyphVector.getGlyphOutline(glyphVectorInfo.ngi);
            Rectangle2D rectangle2D = this.glyphVector.getGlyphLogicalBounds(glyphVectorInfo.ngi).getBounds2D();
            d7 = rectangle2D.getWidth();
            double d10 = glyphVectorInfo.ngx + d7 / 2.0;
            double d11 = glyphVectorInfo.visualCenterY;
            this.glyphTransform.setToIdentity();
            double d12 = d5 + d8;
            double d13 = d6 + d9;
            this.glyphTransform.rotate(d2, d12, d13);
            this.glyphTransform.translate(d12 - d10, d13 - d11);
            segmentCtl.setCorners(shape, this.glyphTransform);
            shape = this.glyphTransform.createTransformedShape(shape);
            rectangle2D = shape.getBounds2D();
            if (rectArray != null && !bl2 && rectArray.conflicts(rectangle2D)) {
                segmentCtl.abort = true;
                break;
            }
            segmentCtl.mbrs.addElement(rectangle2D);
            segmentCtl.s.append(shape, false);
            ++glyphVectorInfo.ngi;
            if (glyphVectorInfo.ngi >= this.nGlyphs) break;
            Point2D point2D = this.glyphVector.getGlyphPosition(glyphVectorInfo.ngi);
            double d14 = Point2D.distance(point2D.getX(), point2D.getY(), glyphVectorInfo.ngx, glyphVectorInfo.ngy);
            if (d14 < 4.0) {
                d14 = 4.0;
            }
            rectangle2D = this.glyphVector.getGlyphLogicalBounds(glyphVectorInfo.ngi).getBounds2D();
            glyphVectorInfo.ngx = point2D.getX();
            glyphVectorInfo.ngy = point2D.getY();
            boolean bl3 = segmentCtl.fits = Point2D.distance(d5 += (d14 + rectangle2D.getWidth()) / 2.0 * d3, d6 += (d14 + rectangle2D.getWidth()) / 2.0 * d4, segmentCtl.sx, segmentCtl.sy) < d + glyphVectorInfo.avgGW;
            if (segmentCtl.fits) continue;
            if (bl) {
                if (bl2 || (double)(this.nGlyphs - glyphVectorInfo.ngi) / (double)this.nGlyphs <= 0.14) {
                    segmentCtl.fits = true;
                    segmentCtl.abort = false;
                    continue;
                }
                segmentCtl.abort = true;
                continue;
            }
            if (glyphVectorInfo.ngi != this.nGlyphs - 1) continue;
            segmentCtl.fits = true;
            segmentCtl.abort = false;
        }
        return glyphVectorInfo.ngi >= this.nGlyphs || segmentCtl.abort;
    }

    private Point2D getRealStartPoint(SegmentCtl segmentCtl, GlyphVectorInfo glyphVectorInfo) {
        int n;
        int n2 = segmentCtl.previousCorners2 == null ? 4 : 8;
        Point2D[] point2DArray = new Point2D[n2];
        for (int i = 0; i < n2; ++i) {
            point2DArray[i] = new Point2D.Double(0.0, 0.0);
        }
        Point2D[] point2DArray2 = new Point2D[n2];
        for (n = 0; n < 4; ++n) {
            point2DArray2[n] = segmentCtl.previousCorners.getCorners()[n];
        }
        if (n2 > 4) {
            for (n = 4; n < 8; ++n) {
                point2DArray2[n] = segmentCtl.previousCorners2.getCorners()[n - 4];
            }
        }
        for (n = 0; n < n2; ++n) {
            Point2D point2D = point2DArray2[n];
            ShapeUtil.projection(point2D.getX(), point2D.getY(), segmentCtl.sx, segmentCtl.sy, segmentCtl.ex, segmentCtl.ey, point2DArray[n]);
        }
        double d = 99999.0;
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            double d2 = Point2D.distance(point2DArray[i].getX(), point2DArray[i].getY(), segmentCtl.ex, segmentCtl.ey);
            if (!(d2 < d)) continue;
            d = d2;
            n3 = i;
        }
        return point2DArray[n3];
    }

    private double[] getGlyphOffset(GlyphVectorInfo glyphVectorInfo, double d, Object object) {
        double d2 = 0.0;
        double d3 = 0.0;
        if (object == LabelingHints.VALUE_LINE_VALIGN_MIDDLE) {
            d2 = 0.0;
            d3 = 0.0;
        } else if (object == LabelingHints.VALUE_LINE_VALIGN_BASELINE) {
            double d4 = glyphVectorInfo.visualCenterY - glyphVectorInfo.ngy;
            d2 = -d4 * Math.sin(d);
            d3 = d4 * Math.cos(d);
        } else if (object == LabelingHints.VALUE_LINE_VALIGN_BOTTOM) {
            double d5 = glyphVectorInfo.visualBounds.getHeight() / 2.0 + 1.0;
            d2 = d5 * Math.sin(d);
            d3 = -d5 * Math.cos(d);
        } else if (object == LabelingHints.VALUE_LINE_VALIGN_TOP) {
            double d6 = glyphVectorInfo.visualBounds.getHeight() / 2.0 + 1.0;
            d2 = -d6 * Math.sin(d);
            d3 = d6 * Math.cos(d);
        }
        return new double[]{d2, d3};
    }

    private boolean ensureUpRight(float[] fArray, float[] fArray2, int n, int n2) {
        if (n2 < 2) {
            return false;
        }
        float f = fArray[n];
        float f2 = fArray[n + 1];
        float f3 = fArray[n + n2 - 1];
        float f4 = fArray[n + n2 / 2];
        if (f > f4 || f > f2) {
            this.reorient(fArray, fArray2, n, n2);
            return true;
        }
        return false;
    }

    private void reorient(float[] fArray, float[] fArray2, int n, int n2) {
        int n3 = n;
        int n4 = n + n2 - 1;
        while (n3 < n + n2 / 2) {
            float f = fArray[n3];
            fArray[n3] = fArray[n4];
            fArray[n4] = f;
            f = fArray2[n3];
            fArray2[n3] = fArray2[n4];
            fArray2[n4] = f;
            ++n3;
            --n4;
        }
    }

    public int getGROW_SIZE() {
        return GROW_SIZE;
    }

    class CandidateRuns {
        float[] x;
        float[] y;
        int[] indexes = new int[3];
        int[] numPoints;
        int size;
        double len;

        public CandidateRuns() {
            this.indexes[0] = -1;
            this.indexes[1] = -1;
            this.indexes[2] = 0;
            this.numPoints = new int[3];
            this.numPoints[0] = 0;
            this.numPoints[1] = 0;
            this.numPoints[2] = 0;
            this.size = 0;
        }

        public CandidateRuns(int n) {
            this();
            this.x = new float[n];
            this.y = new float[n];
        }

        public void append(float f, float f2, double d) {
            if (this.size >= 1) {
                double d2 = Point2D.distance(this.x[this.size - 1], this.y[this.size - 1], f, f2);
                if (d2 < TextPath.this.ascent * 0.5) {
                    this.x[this.size - 1] = f;
                    this.y[this.size - 1] = f2;
                    return;
                }
                if (d2 > d) {
                    double d3 = (double)(f - this.x[this.size - 1]) / d2;
                    double d4 = (double)(f2 - this.y[this.size - 1]) / d2;
                    double d5 = (d2 - d) / 2.0;
                    float f3 = (float)((double)this.x[this.size - 1] + d3 * (d5 - 2.0));
                    float f4 = (float)((double)this.y[this.size - 1] + d4 * (d5 - 2.0));
                    this.ensureCapacity(this.size + 1);
                    this.indexes[0] = this.size;
                    this.numPoints[0] = 2;
                    this.x[this.size] = f3;
                    this.y[this.size++] = f4;
                }
            }
            this.ensureCapacity(this.size + 1);
            this.x[this.size] = f;
            this.y[this.size++] = f2;
        }

        public double getLength() {
            if (this.size == 0) {
                return 0.0;
            }
            this.len = 0.0;
            float f = this.x[0];
            float f2 = this.y[0];
            float f3 = 0.0f;
            float f4 = 0.0f;
            for (int i = 1; i < this.size; ++i) {
                f3 = this.x[i];
                f4 = this.y[i];
                this.len += Point2D.distance(f, f2, f3, f4);
                f = f3;
                f2 = f4;
            }
            return this.len;
        }

        public void ensureCapacity(int n) {
            if (this.x != null && this.x.length > n) {
                return;
            }
            float[] fArray = new float[n + GROW_SIZE];
            if (this.x != null) {
                System.arraycopy(this.x, 0, fArray, 0, this.size);
            }
            this.x = fArray;
            fArray = new float[n + GROW_SIZE];
            if (this.y != null) {
                System.arraycopy(this.y, 0, fArray, 0, this.size);
            }
            this.y = fArray;
        }

        public void setStartingIndexes(double d) {
            if (this.x == null || this.y == null) {
                this.indexes[1] = -1;
                return;
            }
            if (this.len <= 0.0) {
                this.getLength();
            }
            if (this.len < d) {
                this.indexes[1] = -1;
                return;
            }
            double d2 = (this.len - d) / 2.0;
            this.indexes[1] = this.findStartVertexForOffset(d2);
            this.numPoints[1] = this.findEndVertexForOffset(d2 + d) - this.indexes[1] + 1;
            this.numPoints[2] = this.findEndVertexForOffset(d) + 1;
        }

        private int findStartVertexForOffset(double d) {
            if (this.x == null || this.y == null) {
                return -1;
            }
            double d2 = 0.0;
            float f = this.x[0];
            float f2 = this.y[0];
            float f3 = 0.0f;
            float f4 = 0.0f;
            for (int i = 1; i < this.size; ++i) {
                f3 = this.x[i];
                f4 = this.y[i];
                if ((d2 += Point2D.distance(f, f2, f3, f4)) > d) {
                    return i - 1;
                }
                if (d2 == d) {
                    return i;
                }
                f = f3;
                f2 = f4;
            }
            return -1;
        }

        private int findEndVertexForOffset(double d) {
            double d2 = 0.0;
            float f = this.x[0];
            float f2 = this.y[0];
            float f3 = 0.0f;
            float f4 = 0.0f;
            for (int i = 1; i < this.size; ++i) {
                f3 = this.x[i];
                f4 = this.y[i];
                if ((d2 += Point2D.distance(f, f2, f3, f4)) >= d) {
                    return i;
                }
                f = f3;
                f2 = f4;
            }
            return this.size - 1;
        }
    }

    class SegmentCtl {
        boolean abort = false;
        boolean fits = true;
        GeneralPath s = new GeneralPath();
        Vector mbrs = new Vector(24);
        int numSharpTurns;
        double sx;
        double sy;
        double ex;
        double ey;
        GlyphCorners previousCorners = null;
        GlyphCorners previousCorners2 = null;
        double previousAngle;

        SegmentCtl() {
        }

        public void setCorners(Shape shape, AffineTransform affineTransform) {
            if (this.previousCorners != null) {
                this.previousCorners2 = (GlyphCorners)this.previousCorners.clone();
            }
            if (this.previousCorners == null) {
                this.previousCorners = new GlyphCorners();
            }
            this.previousCorners.setCorners(shape, affineTransform);
        }
    }

    class GlyphCorners {
        Point2D[] pts = new Point2D[4];

        public GlyphCorners() {
            for (int i = 0; i < 4; ++i) {
                this.pts[i] = new Point2D.Double(0.0, 0.0);
            }
        }

        public Object clone() {
            GlyphCorners glyphCorners = new GlyphCorners();
            for (int i = 0; i < 4; ++i) {
                glyphCorners.pts[i].setLocation(this.pts[i]);
            }
            return glyphCorners;
        }

        public void setCorners(Shape shape, AffineTransform affineTransform) {
            Rectangle2D rectangle2D = affineTransform.createTransformedShape(shape).getBounds2D();
            this.pts[0].setLocation(rectangle2D.getMinX(), rectangle2D.getMaxY());
            this.pts[1].setLocation(rectangle2D.getMinX(), rectangle2D.getMinY());
            this.pts[2].setLocation(rectangle2D.getMaxX(), rectangle2D.getMinY());
            this.pts[3].setLocation(rectangle2D.getMaxX(), rectangle2D.getMaxY());
        }

        public Point2D[] getCorners() {
            return this.pts;
        }
    }

    class GlyphVectorInfo {
        String txt = null;
        Rectangle2D visualBounds;
        double visualCenterY = 0.0;
        int ngi;
        double ngx;
        double ngy;
        double avgGW;

        GlyphVectorInfo() {
        }
    }
}

