/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.style;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.style.AreaStyleModel;
import oracle.mapviewer.share.style.StyleModel;
import oracle.sdovis.SVGMap;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleLine;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.ImageUtils;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;

public class StyleArea
implements Style {
    static final long serialVersionUID = 252711490847139593L;
    AreaStyleModel bean = null;
    transient Rectangle2D.Double mbr = null;
    transient BasicStroke stroke = null;
    transient TexturePaint tp = null;
    transient BufferedImage bufferedImage = null;
    transient StyleLine borderLineStyle = null;

    public StyleArea() {
        this.bean = new AreaStyleModel();
        this.createGraphicsObjects();
    }

    public StyleArea(StyleModel styleModel) {
        this.setModel(styleModel);
    }

    public StyleArea(String string, byte[] byArray) throws StyleException {
        this.bean = new AreaStyleModel();
        this.bean.setFillPatternImage(byArray);
        this.parseAreaStyle(string);
        this.createGraphicsObjects();
    }

    public Object clone() {
        try {
            StyleArea styleArea = (StyleArea)super.clone();
            styleArea.setModel((StyleModel)this.bean.clone());
            return styleArea;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public String getDefinition() {
        return this.bean.toXMLString();
    }

    private void parseAreaStyle(String string) throws StyleException {
        XMLDOMParser xMLDOMParser = new XMLDOMParser();
        if (!xMLDOMParser.parse(string)) {
            return;
        }
        String string2 = xMLDOMParser.getAttribute("g", "class");
        if (!string2.equalsIgnoreCase(this.bean.getTypeName())) {
            System.err.println("[StyleArea] svg error: wrong type of style (expecting AREA)");
            return;
        }
        try {
            this.bean.setBorderStyleName(this.parseLineStyleName(xMLDOMParser.getAttribute("g", "style")));
        }
        catch (Exception exception) {
            this.bean.setBorderStyleName(null);
        }
        try {
            StyleColor styleColor = new StyleColor(string);
            this.bean.setBorderColor(styleColor.getStrokeColor());
            this.bean.setFillColor(styleColor.getFillColor());
            if (styleColor.getStrokeWidth() >= 1.0f) {
                this.bean.setBorderWidth(styleColor.getStrokeWidth());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createGraphicsObjects() {
        float f;
        if (this.bean.getFillPatternImage() != null) {
            Image image = Toolkit.getDefaultToolkit().createImage(this.bean.getFillPatternImage());
            ImageUtils.waitForImage(image);
            this.bufferedImage = ImageUtils.makeBufferedImage(image, 2);
            this.tp = new TexturePaint(this.bufferedImage, new Rectangle2D.Double(0.0, 0.0, this.bufferedImage.getWidth(), this.bufferedImage.getHeight()));
            this.mbr = new Rectangle2D.Double(0.0, 0.0, this.bufferedImage.getWidth(), this.bufferedImage.getHeight());
            ImageUtils.removeImageFromTracker(image);
            image.flush();
            image = null;
        }
        if ((f = this.bean.getBorderWidth()) < 1.0f) {
            f = 1.0f;
        }
        this.stroke = new BasicStroke(f, 0, 2);
    }

    private String parseLineStyleName(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = string.indexOf("line-style:");
        if (n < 0) {
            return null;
        }
        int n2 = string.indexOf(";", n);
        if (n2 < 0) {
            n2 = string.length();
        }
        if (n2 <= 0) {
            return null;
        }
        return string.substring(n + 11, n2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.createGraphicsObjects();
    }

    public StyleModel getModel() {
        return this.bean;
    }

    public void setModel(StyleModel styleModel) {
        if (!(styleModel instanceof AreaStyleModel)) {
            throw new IllegalArgumentException("Not a valid Area style model");
        }
        this.bean = (AreaStyleModel)styleModel;
        this.createGraphicsObjects();
    }

    public boolean resolveStyles(StyleCache styleCache, Hashtable hashtable) {
        if (this.borderLineStyle != null || this.bean.getBorderStyleName() == null) {
            return true;
        }
        this.borderLineStyle = (StyleLine)Util.getStyle(this.bean.getBorderStyleName(), styleCache, hashtable);
        if (this.borderLineStyle == null) {
            return false;
        }
        return this.borderLineStyle.resolveStyles(styleCache, hashtable);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("AREA style cannot be applied to a point.");
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(null, graphics2D, (Shape)rectangle2D, 3, null, null, null, null, styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(null, graphics2D, shape, n, null, null, null, null, styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        Color color = this.bean.getBorderColor();
        Color color2 = this.bean.getFillColor();
        if (this.bean.getAreaStyleType() == 2 && this.tp != null) {
            graphics2D.setPaint(this.tp);
        } else if (this.bean.getAreaStyleType() == 1) {
            graphics2D.setPaint(color2);
        }
        graphics2D.fill(shape);
        if (this.bean.getBorderStyleName() != null && this.borderLineStyle == null) {
            System.err.println("Warning: border style not resolved.");
        }
        if (this.borderLineStyle != null) {
            this.borderLineStyle.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
        } else if (color != null && this.stroke != null) {
            graphics2D.setColor(color);
            graphics2D.setStroke(this.stroke);
            graphics2D.draw(shape);
        }
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, Style style, String[] stringArray2, String string2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
    }

    public void apply(VisContext visContext, SVGMap sVGMap, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("AREA style cannot be applied to a point.");
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        Color color = this.bean.getBorderColor();
        Color color2 = this.bean.getFillColor();
        if (color != null) {
            sVGMap.drawRectangle(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getWidth(), rectangle2D.getHeight(), color, color2);
        }
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.applyToSVG(null, sVGMap, shape, n, fieldArray, null, string, null, null, 0.0, false, null, styleModifiers);
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(null, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        Color color = this.bean.getBorderColor();
        Color color2 = this.bean.getFillColor();
        String string4 = sVGMap.drawShape(shape, color, 1.0f, color2, string, string2, rectangle2D, d, bl, string3);
        return string4;
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return this.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, styleModifiers);
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, Style style2, String[] stringArray2, String string4, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return this.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, styleModifiers);
    }

    public void setBorderLineStyle(StyleLine styleLine) {
        this.borderLineStyle = styleLine;
    }

    public StyleLine getBroderLineStyle() {
        return this.borderLineStyle;
    }

    public Object getPropertyValue(String string) {
        return null;
    }

    public StyleModifiers convertToPixelSize(VisContext visContext) {
        return null;
    }
}

