/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.sam;

import java.awt.Color;
import java.util.ArrayList;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.spatial.util.RTree;

public class HeatMapCore {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    int gridWidth = 0;
    int gridHeight = 0;
    double minCoordX = 0.0;
    double maxCoordX = 0.0;
    double minCoordY = 0.0;
    double maxCoordY = 0.0;
    double[][] data = null;
    double[][] grid = null;
    double minGridCellValue = 0.0;
    double maxGridCellValue = 0.0;
    double gridCellValueRange = 0.0;
    RTree rTree = null;
    double cellWidth = 0.0;
    double cellHeight = 0.0;
    double spotlightRadius = -1.0;
    private static ArrayList emptyList = new ArrayList(1);

    public HeatMapCore(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Invalid grid dimension specified.");
        }
        this.gridWidth = n;
        this.gridHeight = n2;
        try {
            this.grid = new double[n][n2];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new IllegalArgumentException("Out of memory error caused by grid allocation.", outOfMemoryError);
        }
    }

    public void setData(double[][] dArray) {
        this.data = dArray;
        this.rTree = null;
        if (dArray != null) {
            this.buildRTree();
        }
    }

    public double[][] getData() {
        return this.data;
    }

    public void setCoordBounds(double d, double d2, double d3, double d4) {
        this.minCoordX = d;
        this.maxCoordX = d2;
        this.minCoordY = d3;
        this.maxCoordY = d4;
        this.cellWidth = (this.maxCoordX - this.minCoordX) / (double)this.gridWidth;
        this.cellHeight = (this.maxCoordY - this.minCoordY) / (double)this.gridHeight;
    }

    public double[] getCoordBounds() {
        return new double[]{this.minCoordX, this.maxCoordX, this.minCoordY, this.maxCoordY};
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public int getGridHeight() {
        return this.gridHeight;
    }

    protected double classicBandwidth(int n) {
        return 0.68 * Math.pow(n, -0.2);
    }

    protected double kEstimate(double d, double d2, ArrayList arrayList, double d3) {
        double d4 = 0.0;
        double d5 = d3 * d3;
        for (int i = 0; i < arrayList.size(); ++i) {
            double d6;
            double[] dArray = (double[])arrayList.get(i);
            double d7 = dArray[0];
            double d8 = (d7 - d) * (d7 - d) + ((d6 = dArray[1]) - d2) * (d6 - d2);
            if (d8 > d5) continue;
            double d9 = 1.0 - d8 / d5;
            double d10 = d9 * d9;
            double d11 = 3.0 * d10 / (Math.PI * d5);
            d4 += d11;
        }
        return d4;
    }

    protected void buildRTree() {
        this.rTree = new RTree(2, 100, 5);
        int n = this.data.length;
        int n2 = 10000;
        double[][][] dArrayArray = new double[n][][];
        Object[] objectArray = new Object[n];
        long l = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = new double[2][];
            dArrayArray[i][0] = new double[2];
            dArrayArray[i][1] = new double[2];
            double[] dArray = this.data[i];
            dArrayArray[i][0][0] = dArray[0];
            dArrayArray[i][0][1] = dArray[0];
            dArrayArray[i][1][0] = dArray[1];
            dArrayArray[i][1][1] = dArray[1];
            objectArray[i] = dArray;
        }
        try {
            this.rTree.packTree((double[][][])dArrayArray, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.rTree = null;
        }
        log.finest("Elapsed time building HeatMap RTree: " + (System.currentTimeMillis() - l) + " milliseconds for " + n + " geometries");
    }

    protected ArrayList findNeighbours(double[][] dArray) {
        if (this.rTree == null) {
            return emptyList;
        }
        ArrayList arrayList = new ArrayList(250);
        if (this.rTree.search(dArray, arrayList)) {
            return arrayList;
        }
        return emptyList;
    }

    public double[][] computeHeatMap() throws Exception {
        if (this.maxCoordX - this.minCoordX == 0.0 || this.maxCoordY - this.minCoordY == 0.0) {
            throw new Exception("Must specify valid coordinate bounds first.");
        }
        this.minGridCellValue = Double.POSITIVE_INFINITY;
        this.maxGridCellValue = Double.NEGATIVE_INFINITY;
        long l = System.currentTimeMillis();
        double d = this.spotlightRadius;
        if (d < 0.0) {
            d = (this.maxCoordY - this.minCoordY) * this.classicBandwidth(this.data.length);
            d *= 0.55;
        }
        for (int i = 0; i < this.gridWidth; ++i) {
            for (int j = 0; j < this.gridHeight; ++j) {
                double d2;
                double d3 = this.minCoordX + this.cellWidth * (double)i + this.cellWidth / 2.0;
                double d4 = this.minCoordY + this.cellHeight * (double)j + this.cellHeight / 2.0;
                double[][] dArrayArray = new double[][]{new double[2], new double[2]};
                dArrayArray[0][0] = d3 - d;
                dArrayArray[0][1] = d3 + d;
                dArrayArray[1][0] = d4 - d;
                dArrayArray[1][1] = d4 + d;
                ArrayList arrayList = this.findNeighbours(dArrayArray);
                this.grid[i][j] = d2 = this.kEstimate(d3, d4, arrayList, d);
                if (this.minGridCellValue > d2) {
                    this.minGridCellValue = d2;
                }
                if (!(this.maxGridCellValue < d2)) continue;
                this.maxGridCellValue = d2;
            }
        }
        this.gridCellValueRange = this.maxGridCellValue - this.minGridCellValue;
        long l2 = System.currentTimeMillis();
        log.finest(" Time spent on computing heat map: " + (l2 - l) + "ms. Grid size: " + this.gridWidth + " x " + this.gridHeight + ". bandwidth: " + d + ".");
        return this.grid;
    }

    public Color getMatchingColor(int n, int n2, Color[] colorArray) {
        if (this.gridCellValueRange == 0.0) {
            return null;
        }
        double d = (this.grid[n][n2] - this.minGridCellValue) / this.gridCellValueRange;
        int n3 = (int)Math.floor(d * (double)(colorArray.length - 1));
        return colorArray[n3];
    }

    public void setSpotlightRadius(double d) {
        this.spotlightRadius = d;
    }

    public double getSpotlightRadius() {
        return this.spotlightRadius;
    }
}

