/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.raytracing;

import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;
import oracle.sdovis.raytracing.Hit;
import oracle.sdovis.raytracing.Object3d;
import oracle.sdovis.raytracing.Ray;

public class Transform {
    Matrix4d transf;
    Object3d obj;
    Matrix4d inverse;

    public Transform(Matrix4d matrix4d, Object3d object3d) {
        this.transf = matrix4d;
        this.obj = object3d;
        this.inverse = new Matrix4d();
        this.inverse.invert(this.transf);
    }

    public Vector3d getTextureCoordinates(Hit hit, Ray ray) {
        return new Vector3d();
    }

    public boolean intersect(Ray ray, Hit hit, double d) {
        Vector3d vector3d = ray.getOrigin();
        Transform.transform3D(this.inverse, vector3d);
        Vector3d vector3d2 = ray.getDirection();
        Transform.transformDirection3D(this.inverse, vector3d2);
        double d2 = vector3d2.length();
        double d3 = ray.getDirection().length();
        double d4 = d2 / d3;
        vector3d2.normalize();
        Ray ray2 = new Ray(vector3d2, vector3d);
        Hit hit2 = hit;
        hit2.set(hit2.getT() * d4, hit2.getMaterial());
        boolean bl = this.obj.intersect(ray2, hit2, d);
        if (bl) {
            hit.set(hit2.getT() / d4, hit2.getMaterial());
            Vector3d vector3d3 = hit2.getNormal();
            Matrix4d matrix4d = new Matrix4d();
            matrix4d.transpose(this.inverse);
            Transform.transform3D(matrix4d, vector3d3);
            vector3d3.normalize();
            hit.set(hit.getT(), hit.getMaterial(), vector3d3);
            return bl;
        }
        return false;
    }

    public static void transform4D(Matrix4d matrix4d, Vector4d vector4d) {
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        vector4d.get(dArray2);
        for (int i = 0; i < 4; ++i) {
            dArray[i] = 0.0;
            for (int j = 0; j < 4; ++j) {
                dArray[i] = dArray[i] + matrix4d.getElement(i, j) * dArray2[j];
            }
        }
        vector4d.set(dArray);
    }

    public static void transform3D(Matrix4d matrix4d, Vector3d vector3d) {
        Vector4d vector4d = new Vector4d(vector3d.x, vector3d.y, vector3d.z, 1.0);
        Transform.transform4D(matrix4d, vector4d);
        vector3d.set(vector4d.x, vector4d.y, vector4d.z);
    }

    public static void transformDirection3D(Matrix4d matrix4d, Vector3d vector3d) {
        Vector4d vector4d = new Vector4d(vector3d.x, vector3d.y, vector3d.z, 0.0);
        Transform.transform4D(matrix4d, vector4d);
        vector3d.set(vector4d.x, vector4d.y, vector4d.z);
    }
}

