/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.raytracing;

import javax.vecmath.Vector3d;
import oracle.sdovis.raytracing.Hit;
import oracle.sdovis.raytracing.Material;
import oracle.sdovis.raytracing.PhongMaterial;
import oracle.sdovis.raytracing.Plane;
import oracle.sdovis.raytracing.Ray;

public class TextureMap
extends Material {
    Material basemat;
    double[][] demdata;
    Vector3d[][] normalmap;
    Vector3d[][] xvmap;
    Vector3d[][] yvmap;
    int width;
    int height;
    int imWidth;
    int imHeight;
    int numBands;
    Vector3d u;
    Vector3d v;
    Vector3d w;
    boolean image_only = false;
    int g = 1;

    public TextureMap(Vector3d vector3d, Vector3d vector3d2, double d, Vector3d vector3d3, Vector3d vector3d4, double d2, double[][] dArray, int n, int n2, int n3) {
        super(vector3d, vector3d3, vector3d4, d2);
        this.demdata = dArray;
        this.width = n2;
        this.height = n3;
        this.numBands = n;
        this.xvmap = new Vector3d[this.height][this.width];
        this.yvmap = new Vector3d[this.height][this.width];
        this.normalmap = new Vector3d[this.height][this.width];
        this.basemat = new PhongMaterial(vector3d, vector3d2, d, vector3d3, vector3d4, d2);
        this.calcNormalMap();
    }

    public Vector3d shade(Ray ray, Hit hit, Vector3d vector3d, Vector3d vector3d2) {
        Hit hit2 = new Hit(hit.getT(), hit.getMaterial());
        Vector3d vector3d3 = ray.getOrigin();
        Vector3d vector3d4 = ray.getDirection();
        double d = vector3d3.x + vector3d4.x * hit.getT();
        double d2 = vector3d3.y + vector3d4.y * hit.getT();
        int n = (int)(d * (double)this.width);
        int n2 = (int)(d2 * (double)this.height);
        ((Plane)hit.getObject()).setWindow(this.width, this.height);
        Vector3d vector3d5 = hit.getObject().getTextureCoordinates(hit, ray);
        if (vector3d5 != null) {
            double d3 = vector3d5.x;
            double d4 = vector3d5.y;
            Vector3d vector3d6 = hit.getObject().getOrigin();
            Vector3d vector3d7 = new Vector3d();
            int n3 = (int)(d4 * (double)(this.height - 1));
            int n4 = (int)(d3 * (double)(this.width - 1));
            int n5 = n4 * this.numBands;
            if (this.numBands >= 3) {
                if (this.image_only) {
                    hit.getMaterial().setDiffuseColor(new Vector3d(this.demdata[n3][n5] / 255.0, this.demdata[n3][n5 + 1] / 255.0, this.demdata[n3][n5 + 2] / 255.0));
                    vector3d7 = new Vector3d(this.demdata[n3][n5] / 255.0, this.demdata[n3][n5 + 1] / 255.0, this.demdata[n3][n5 + 2] / 255.0);
                }
            } else if (this.image_only) {
                hit.getMaterial().setDiffuseColor(new Vector3d(this.demdata[n3][n5] / 255.0, this.demdata[n3][n5] / 255.0, this.demdata[n3][n5] / 255.0));
                vector3d7 = new Vector3d(this.demdata[n3][n5] / 255.0, this.demdata[n3][n5] / 255.0, this.demdata[n3][n5] / 255.0);
            } else {
                Vector3d vector3d8 = this.normalmap[n3][n5];
                Vector3d vector3d9 = hit.getNormal();
                hit.setNormal(this.normalmap[n3][n5]);
            }
        }
        return this.basemat.shade(ray, hit, vector3d, vector3d2);
    }

    public void calcNormalMap() {
        for (int i = 0; i < this.demdata.length; ++i) {
            for (int j = 0; j < this.demdata[i].length; ++j) {
                Vector3d vector3d;
                Vector3d vector3d2;
                double d = 0.0;
                double d2 = 0.0;
                d = j == 0 || j - this.g < 0 ? this.demdata[i][j + this.g] : (j == this.demdata[i].length - 1 || j + this.g > this.demdata[i].length - 1 ? -this.demdata[i][j - this.g] : this.demdata[i][j + this.g] - this.demdata[i][j - this.g]);
                d2 = i == 0 || i - this.g < 0 ? this.demdata[i + this.g][j] : (i == this.demdata.length - 1 || i + this.g > this.demdata.length - 1 ? -this.demdata[i - this.g][j] : this.demdata[i + this.g][j] - this.demdata[i - this.g][j]);
                this.xvmap[i][j] = vector3d2 = new Vector3d(1.0, 0.0, d);
                this.yvmap[i][j] = vector3d = new Vector3d(0.0, 1.0, d2);
                Vector3d vector3d3 = new Vector3d();
                vector3d3.cross(vector3d2, vector3d);
                this.normalmap[i][j] = vector3d3;
            }
        }
    }
}

