/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.raytracing;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.vecmath.Point2d;
import javax.vecmath.Vector3d;
import oracle.sdovis.raytracing.Camera;
import oracle.sdovis.raytracing.DEMTracer;
import oracle.sdovis.raytracing.Group;
import oracle.sdovis.raytracing.Hit;
import oracle.sdovis.raytracing.LightSource;
import oracle.sdovis.raytracing.Material;
import oracle.sdovis.raytracing.PhongMaterial;
import oracle.sdovis.raytracing.Ray;
import oracle.sdovis.raytracing.Render3DException;

public class RTRenderer {
    Camera cam;
    Group gr;
    Vector3d background_color;
    Vector3d ambient_light;
    LightSource[] lights;
    Material[] materials;

    public RTRenderer() {
        this.cam = null;
        this.gr = null;
        this.background_color = null;
        this.ambient_light = null;
        this.lights = null;
        this.materials = null;
    }

    public RTRenderer(Camera camera, Group group, Vector3d vector3d, Vector3d vector3d2, LightSource[] lightSourceArray, Material[] materialArray) {
        this.cam = camera;
        this.gr = group;
        this.background_color = vector3d;
        this.ambient_light = vector3d2;
        this.lights = lightSourceArray;
        this.materials = materialArray;
    }

    public RenderedImage doRendering(WritableRaster writableRaster, int n, int n2, int n3, int n4) {
        Vector3d vector3d = this.background_color;
        Vector3d vector3d2 = new Vector3d();
        PhongMaterial phongMaterial = new PhongMaterial(vector3d, vector3d2, 1.0, vector3d2, vector3d2, 1.0);
        DEMTracer dEMTracer = new DEMTracer(this, n, n2);
        double d = Double.NEGATIVE_INFINITY;
        int n5 = n4 - 1;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                Point2d point2d = new Point2d((double)j / (double)n3, (double)i / (double)n4);
                Ray ray = this.cam.generateRay(point2d);
                Hit hit = new Hit(Double.POSITIVE_INFINITY, phongMaterial);
                Vector3d vector3d3 = new Vector3d();
                vector3d3 = dEMTracer.traceRay(ray, d, n, n2, 1.0, hit);
                double[] dArray = new double[]{vector3d3.x, vector3d3.y, vector3d3.z};
                writableRaster.setPixel(i, n5 - j, dArray);
            }
        }
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, writableRaster.getSampleModel().getDataType());
        BufferedImage bufferedImage = new BufferedImage(componentColorModel, writableRaster, false, null);
        return bufferedImage;
    }

    public void saveTGA(String string, int n, int n2, Raster raster) throws FileNotFoundException, IOException, Render3DException {
        int n3;
        if (!(string = string.trim()).endsWith(".tga")) {
            // empty if block
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        byte[] byArray = new byte[18];
        for (n3 = 0; n3 < 18; ++n3) {
            byArray[n3] = n3 == 2 ? 2 : (n3 == 12 ? (int)(n % 256) : (n3 == 13 ? (int)(n / 256) : (n3 == 14 ? (int)(n2 % 256) : (n3 == 15 ? (int)(n2 / 256) : (n3 == 16 ? 24 : (n3 == 17 ? 32 : 0))))));
        }
        fileOutputStream.write(byArray);
        fileOutputStream.flush();
        for (n3 = 0; n3 < n2; ++n3) {
            byte[] byArray2 = new byte[n * 3];
            int n4 = 0;
            for (int i = 0; i < n; ++i) {
                double[] dArray = new double[raster.getNumBands()];
                if (dArray.length < 3) {
                    double d = dArray[0];
                    dArray = new double[]{d, d, d};
                }
                dArray = raster.getPixel(i, n3, dArray);
                Vector3d vector3d = new Vector3d(dArray);
                byArray2[n4] = this.clampColorComponent(vector3d.z);
                byArray2[n4 + 1] = this.clampColorComponent(vector3d.y);
                byArray2[n4 + 2] = this.clampColorComponent(vector3d.x);
                n4 += 3;
            }
            fileOutputStream.write(byArray2);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    private byte clampColorComponent(double d) {
        int n = (int)(d * 255.0);
        if (n < 0) {
            n = 0;
        }
        if (n > 255) {
            n = 255;
        }
        return (byte)n;
    }

    public void setCamera(Camera camera) {
        this.cam = camera;
    }

    public void setGroup(Group group) {
        this.gr = group;
    }

    public void setBackgroundColor(Vector3d vector3d) {
        this.background_color = vector3d;
    }

    public void setAmbientLight(Vector3d vector3d) {
        this.ambient_light = vector3d;
    }

    public void setLights(LightSource[] lightSourceArray) {
        this.lights = lightSourceArray;
    }

    public void setMaterials(Material[] materialArray) {
        this.materials = materialArray;
    }

    public Camera getCamera() {
        return this.cam;
    }

    public Group getGroup() {
        return this.gr;
    }

    public Vector3d getBackgroundColor() {
        return this.background_color;
    }

    public Vector3d getAmbientLight() {
        return this.ambient_light;
    }

    public LightSource[] getLights() {
        return this.lights;
    }

    public LightSource getLight(int n) {
        return this.lights[n];
    }

    public Material[] getMaterials() {
        return this.materials;
    }

    public Material getMaterial(int n) {
        return this.materials[n];
    }
}

