/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.georss;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import oracle.spatial.geometry.JGeometry;
import org.w3c.dom.Node;

public class GMLParser {
    public static JGeometry getGeometry(Node node) {
        String string = node.getNodeName();
        if ("gml:point".equals(string = string.toLowerCase(Locale.ENGLISH))) {
            return GMLParser.getPoint(node);
        }
        if ("gml:linestring".equals(string) || "gml:curve".equals(string)) {
            return GMLParser.getLineString(node);
        }
        if ("gml:polygon".equals(string)) {
            return GMLParser.getPolygon(node);
        }
        if ("gml:envelope".equals(string)) {
            return GMLParser.getBox(node);
        }
        return null;
    }

    public static JGeometry getPoint(Node node) {
        Node node2 = XMLDOMParser.getSubElement(node, "gml:pos");
        if (node2 == null) {
            return null;
        }
        String string = XMLDOMParser.getElementValue(node2);
        ArrayList arrayList = Util.splitBy(string, " ");
        double[] dArray = new double[2];
        dArray[1] = Double.parseDouble((String)arrayList.get(0));
        dArray[0] = Double.parseDouble((String)arrayList.get(1));
        return JSDOGeometry.createPoint((double[])dArray, (int)2, (int)8307);
    }

    public static JGeometry getLineString(Node node) {
        Node node2 = XMLDOMParser.getSubElement(node, "gml:posList");
        if (node2 == null) {
            return null;
        }
        String string = XMLDOMParser.getElementValue(node2);
        ArrayList arrayList = Util.splitBy(string, " ");
        double[] dArray = new double[arrayList.size()];
        for (int i = 0; i < arrayList.size() / 2; ++i) {
            dArray[i * 2] = Double.parseDouble((String)arrayList.get(i * 2 + 1));
            dArray[i * 2 + 1] = Double.parseDouble((String)arrayList.get(i * 2));
        }
        return JSDOGeometry.createLinearLineString((double[])dArray, (int)2, (int)8307);
    }

    public static JGeometry getBox(Node node) {
        Node node2 = XMLDOMParser.getSubElement(node, "gml:lowerCorner");
        if (node2 == null) {
            return null;
        }
        String string = XMLDOMParser.getElementValue(node2);
        ArrayList arrayList = Util.splitBy(string, " ");
        double[] dArray = new double[2];
        dArray[1] = Double.parseDouble((String)arrayList.get(0));
        dArray[0] = Double.parseDouble((String)arrayList.get(1));
        Node node3 = XMLDOMParser.getSubElement(node, "gml:upperCorner");
        if (node3 == null) {
            return null;
        }
        string = XMLDOMParser.getElementValue(node2);
        arrayList = Util.splitBy(string, " ");
        double[] dArray2 = new double[2];
        dArray2[1] = Double.parseDouble((String)arrayList.get(0));
        dArray2[0] = Double.parseDouble((String)arrayList.get(1));
        return new JGeometry(Math.min(dArray[0], dArray2[0]), Math.min(dArray[1], dArray2[1]), Math.max(dArray[0], dArray2[0]), Math.max(dArray[1], dArray2[1]), 8307);
    }

    public static JGeometry getPolygon(Node node) {
        double[] dArray = GMLParser.getPolygonExterior(node);
        List list = GMLParser.getPolygonInterior(node);
        Object[] objectArray = new Object[list.size() + 1];
        objectArray[0] = dArray;
        for (int i = 0; i < list.size(); ++i) {
            objectArray[i + 1] = (double[])list.get(i);
        }
        return JSDOGeometry.createLinearPolygon((Object[])objectArray, (int)2, (int)8307);
    }

    private static double[] getPolygonExterior(Node node) {
        Node node2 = XMLDOMParser.getSubElement(node, "gml:exterior");
        if (node2 == null) {
            return null;
        }
        Node node3 = XMLDOMParser.getSubElement(node2, "gml:LinearRing");
        if (node3 == null) {
            return null;
        }
        Node node4 = XMLDOMParser.getSubElement(node3, "gml:posList");
        if (node4 == null) {
            return null;
        }
        String string = XMLDOMParser.getElementValue(node4);
        ArrayList arrayList = Util.splitBy(string, " ");
        double[] dArray = new double[arrayList.size()];
        for (int i = 0; i < arrayList.size() / 2; ++i) {
            dArray[i * 2] = Double.parseDouble((String)arrayList.get(i * 2 + 1));
            dArray[i * 2 + 1] = Double.parseDouble((String)arrayList.get(i * 2));
        }
        return dArray;
    }

    private static List getPolygonInterior(Node node) {
        ArrayList arrayList = XMLDOMParser.getSubElements(node, "gml:interior");
        if (arrayList == null || arrayList.size() == 0) {
            return new ArrayList(1);
        }
        ArrayList<double[]> arrayList2 = new ArrayList<double[]>(2);
        for (int i = 0; i < arrayList.size(); ++i) {
            Node node2;
            Node node3 = (Node)arrayList.get(i);
            Node node4 = XMLDOMParser.getSubElement(node3, "gml:LinearRing");
            if (node4 == null || (node2 = XMLDOMParser.getSubElement(node4, "gml:posList")) == null) continue;
            String string = XMLDOMParser.getElementValue(node2);
            ArrayList arrayList3 = Util.splitBy(string, " ");
            double[] dArray = new double[arrayList3.size()];
            for (int j = 0; j < arrayList3.size() / 2; ++j) {
                dArray[j * 2] = Double.parseDouble((String)arrayList3.get(j * 2 + 1));
                dArray[j * 2 + 1] = Double.parseDouble((String)arrayList3.get(j * 2));
            }
            arrayList2.add(dArray);
        }
        return arrayList2;
    }
}

