/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.charts.piechart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.charts.Chart;
import oracle.sdovis.charts.internal.Errorfcn;
import oracle.sdovis.charts.internal.MsgUtil;
import oracle.sdovis.charts.internal.Precision;
import oracle.sdovis.charts.internal.RoundGradientPaint;
import oracle.sdovis.charts.internal.SliceLabelBreak;
import oracle.sdovis.charts.types.ChartException;
import oracle.sdovis.charts.types.GaugeStyleDesc;
import oracle.sdovis.charts.types.ImageMapAreaDesc;
import oracle.sdovis.charts.types.PieSliceDesc;
import oracle.sdovis.charts.types.PieStyleDesc;

public class PieChart
extends Chart {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private final int PIECHART = 0;
    private final int GAUGE = 1;
    private int PieSubType = 0;
    double GaugeSpanPrivate = 120.0;
    double GaugeLevelPrivate = 50.0;
    double GaugeWidthFraction = 1.0;
    Color GaugeNeedleColorPrivate = Color.black;
    double GaugeLevelDegreesPrivate = 0.0;
    double GaugeNeedleX = 0.0;
    double GaugeNeedleY = 0.0;
    double initialStartAngle = 0.0;
    PieSliceDesc[] SliceDesc;
    PieSliceAngle[] SliceAngle;
    PieSliceLabelLoc[] SliceLabelLoc;
    String[] SliceSecondLabel;
    String[] SliceOriginalLabel;
    StoredLayout[] SliceStoredLayout;
    Arc2D[] Arc;
    boolean[] interiorLabel;
    boolean AutoColorAdjustSliceLabel = true;
    boolean DrawLegend = false;
    BufferedImage BI = null;
    int displayHeight = super.getHeight();
    int displayWidth = super.getWidth();
    double PieDiameterFraction = 0.6;
    int PieDiameter = (int)((double)Math.min(this.displayWidth, this.displayHeight) * this.PieDiameterFraction);
    double PieRadius = (double)this.PieDiameter / 2.0;
    int PieDiameterHeight = this.PieDiameter;
    int PieDiameterWidth = this.PieDiameter;
    Color colorStart = new Color(0.9f, 0.9f, 0.9f);
    Color colorEnd = new Color(0.4f, 0.4f, 0.4f);
    boolean userDefinedPieColors = false;
    int XOffset = (int)Math.round((double)(this.displayWidth - this.PieDiameter) / 2.0);
    int YOffset = (int)Math.round((double)(this.displayHeight - this.PieDiameter) / 2.0);
    static final int DRAWNOTHING = 0;
    static final int DRAWALL = 1;
    static final int DRAWSLICEONLY = 2;
    int HilightIndex = -1;
    int HilightLabelIndex = -1;
    Color HilightColor = Color.blue;
    Color HilightLabelColor = Color.white;
    boolean testInSlice = false;
    boolean testPie = false;
    boolean testPlace90 = false;
    boolean testRect = false;
    boolean testcomputeScore = false;
    boolean test = false;
    boolean testdrawBuffer = false;
    boolean test2 = false;
    boolean testAutoDiameter = false;
    boolean drawText = true;
    private boolean fontMetricsGot = false;
    private Font font = new Font("sansserif", 1, 12);
    private FontMetrics fontmet;
    boolean disableLegend = false;
    boolean drawBackgroundRect = true;
    boolean lastWordNewline = false;
    String SeparateLineChars = "";
    char[] SeparateLineCharsC = new char[0];
    boolean userDefinedDelimiters = false;
    char[] userDelimiters;
    int LabelPrecision = -1;
    int CircumfVerticalSpace = 0;
    int CircumfHorizontalSpace = 0;
    int LegendPieYSpacer = 5;
    int LegendPieXSpacer = 5;
    int MIN_PIE = 0;
    CrescentAdjust Adjust3D = new CrescentAdjust();
    boolean deriveLabelPct = false;
    boolean deriveLabelVal = false;
    boolean useNumberFormat = false;
    NumberFormat numFormat = null;
    boolean labelInteriorPct = false;
    boolean labelInteriorVal = false;
    PieStyleDesc StyleDesc = new PieStyleDesc();
    GaugeStyleDesc GaugeStyleDesc = new GaugeStyleDesc();
    double[] savedSliceValues;
    boolean clockwise = false;
    Color Grey5 = new Color(0.5f, 0.5f, 0.5f);
    final double almostZero = 0.001;
    final double almostOne = 0.999;
    LayoutScore LScore;
    ScoreDesc ScoreD = new ScoreDesc();
    double xMinNormalized = -1.0;
    double yMinNormalized = -1.0;
    double xMaxNormalized = 1.0;
    double yMaxNormalized = 1.0;
    double xMinTextNormalized = -1.0;
    double yMinTextNormalized = -1.0;
    double xMaxTextNormalized = 1.0;
    double yMaxTextNormalized = 1.0;
    double CircumLabelHeightOffset = 0.0;
    double CircumLabelWidthOffset = 0.0;
    int CircumLabelHeightOffsetInt = 0;
    int CircumLabelWidthOffsetInt = 0;
    double CircumLabelNorthExtra = 0.0;
    double CircumLabelSouthExtra = 0.0;
    int CircumLabelNorthExtraInt = 0;
    int CircumLabelSouthExtraInt = 0;
    double CircumLabelEastExtra = 0.0;
    double CircumLabelWestExtra = 0.0;
    int CircumLabelEastExtraInt = 0;
    int CircumLabelWestExtraInt = 0;
    int minX = Integer.MAX_VALUE;
    int maxX = Integer.MIN_VALUE;
    int minY = Integer.MAX_VALUE;
    int maxY = Integer.MIN_VALUE;
    boolean[] IEGlobal;
    BasicStroke PieStroke = new BasicStroke(1.0f, 0, 2);
    BasicStroke ConnectorStroke = new BasicStroke(1.0f, 0, 1);
    Color Foreground = Color.black;
    Color ConnectorColor = Color.black;
    boolean simpleApproach = false;
    boolean forceLegendApproach = false;
    boolean DrawBufferCalled = false;
    RenderingHints RHOriginal = null;
    Effect3D E3D = new Effect3D();
    private static final int POINTER_BACKGROUND = 0;
    private static final int POINTER_HIGHLIGHT = 1;
    float CenterX;
    float CenterY;
    int NumMinorTicks = 20;
    int MajorTickLength = 11;
    int MinorTickLength = 7;
    BasicStroke MajorTickStroke = new BasicStroke(2.0f, 1, 1);
    double InnerTickPos = this.PieRadius * 0.75;
    int InnerTickLength = 6;
    boolean DrawFirstAndLastMajorTicks = true;
    boolean genImageMapCoords = false;
    int[][] ImageMapCoords;
    int ImageMapShape = 1;
    boolean SizeChanged = false;
    boolean circumferenceCalled = false;
    private double PieRadiusCircumL = 0.0;
    double NormalizationFactor = 1.0;
    ExLabelLayout exLayout;

    public PieChart() {
        this.initPie();
    }

    public String getChartState() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.emitVersion());
        stringBuffer.append("PieChart chs = new PieChart();\n\n");
        stringBuffer.append(this.emitSize());
        stringBuffer.append(this.emitBackground());
        stringBuffer.append(this.emitEdgeColor());
        stringBuffer.append(this.emitSetFont());
        stringBuffer.append(this.emitTitle());
        stringBuffer.append(this.emitBorders());
        stringBuffer.append(this.emitSeriesDirection());
        stringBuffer.append(this.emitStartAngle());
        stringBuffer.append(this.emitSeries());
        return stringBuffer.toString();
    }

    protected String emitStartAngle() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("chs.setStartAngle(");
        stringBuffer.append(this.initialStartAngle);
        stringBuffer.append(");\n");
        return stringBuffer.toString();
    }

    protected String emitSetFont() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("chs.");
        stringBuffer.append(this.emitFont(this.font));
        return stringBuffer.toString();
    }

    protected String emitSeries() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.SliceDesc.length;
        stringBuffer.append("\n");
        stringBuffer.append("PieSliceDesc slices[] = {\n");
        for (n = 0; n < n2; ++n) {
            if (this.SliceDesc[n] == null) continue;
            stringBuffer.append("  new PieSliceDesc(\"");
            stringBuffer.append(this.SliceOriginalLabel[n]);
            stringBuffer.append("\", ");
            stringBuffer.append(this.savedSliceValues[n]);
            stringBuffer.append("),\n");
        }
        stringBuffer.append("};\n\n");
        for (n = 0; n < n2; ++n) {
            if (this.SliceDesc[n] == null) continue;
            stringBuffer.append("slices[");
            stringBuffer.append(n);
            stringBuffer.append("].setBackground(");
            stringBuffer.append(this.emitNewColor(this.SliceDesc[n].getBackground()));
            stringBuffer.append(");\n");
        }
        stringBuffer.append("chs.setSeries(slices);\n");
        stringBuffer.append(this.emitStyle());
        return stringBuffer.toString();
    }

    protected String emitSeriesDirection() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("chs.setSeriesDirection(");
        stringBuffer.append(this.getSeriesDirection());
        stringBuffer.append(");\n");
        return stringBuffer.toString();
    }

    protected String emitStyle() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.StyleDesc.getStyleType() == 2) {
            stringBuffer.append("\n// 3D style \n");
            stringBuffer.append("PieStyleDesc styleD = new PieStyleDesc();\n");
            stringBuffer.append("styleD.setStyleType(PieStyleDesc.STYLE_EFFECT_3D);\n");
            stringBuffer.append("styleD.setExtrusionAngle(");
            stringBuffer.append(this.StyleDesc.getExtrusionAngle());
            stringBuffer.append(");\n");
            stringBuffer.append("styleD.setExtrusionThickness(");
            stringBuffer.append(this.StyleDesc.getExtrusionThickness());
            stringBuffer.append(");\n");
            stringBuffer.append("styleD.setPerspectiveDistance(");
            stringBuffer.append(this.StyleDesc.getPerspectiveDistance());
            stringBuffer.append(");\n");
            stringBuffer.append("chs.setChartAttributes(styleD);\n");
        }
        return stringBuffer.toString();
    }

    protected void initPie() {
        this.assertPieChart();
        try {
            this.L2.getLegendDesc().setLegendAlignment(-1);
            this.L2.resetLegendAlignment();
        }
        catch (ChartException chartException) {
            // empty catch block
        }
        this.L2.setPieChartType(true);
        this.L2.setMaximumSize(this.getWidth(), this.getHeight());
        this.L2.setBorders(this.getBorderLeft(), this.getBorderRight(), this.getBorderTop(), this.getBorderBottom());
    }

    protected void initGauge(double d, double d2, Color color) {
        this.assertPieChart();
        try {
            this.L2.getLegendDesc().setLegendAlignment(4);
        }
        catch (ChartException chartException) {
            // empty catch block
        }
        this.setGaugeSpanPrivate(d);
        this.setGaugeLevelPrivate(d2);
        this.setGaugeNeedleColorPrivate(color);
        this.PieSubType = 1;
        this.initGaugeStyleParams();
    }

    protected void initGaugeStyleParams() {
        this.E3D.setExtrusionAngle(this.GaugeStyleDesc.getShadowAngle());
        this.E3D.setExtrusionThickness(this.GaugeStyleDesc.getShadowThickness());
        this.MajorTickLength = (int)Math.round(this.PieRadius * this.GaugeStyleDesc.getTickLengthMajor());
        this.MinorTickLength = (int)Math.round(this.PieRadius * this.GaugeStyleDesc.getTickLengthMinor());
    }

    protected void setGaugeSpanPrivate(double d) {
        this.GaugeSpanPrivate = d;
        this.initialStartAngle = (180.0 - d) / 2.0;
        this.GaugeWidthFraction = Math.cos(Math.toRadians(this.initialStartAngle));
        if (this.SliceDesc != null && this.savedSliceValues.length > 0) {
            this.recomputeSliceValues();
        }
    }

    protected void setGaugeLevelPrivate(double d) {
        this.GaugeLevelPrivate = d;
    }

    protected void setGaugeNeedleColorPrivate(Color color) {
        this.GaugeNeedleColorPrivate = color;
    }

    private void computeGaugeNeedle() {
        int n = this.MinorTickLength / 2;
        if (n < 0) {
            n = 0;
        }
        this.GaugeLevelDegreesPrivate = this.initialStartAngle + this.GaugeSpanPrivate * (this.GaugeLevelPrivate / 100.0);
        double d = Math.toRadians(this.GaugeLevelDegreesPrivate);
        double d2 = (double)this.XOffset + (double)this.CircumLabelWidthOffsetInt + this.PieRadius;
        double d3 = (double)this.YOffset + (double)this.CircumLabelHeightOffsetInt + this.PieRadius;
        this.GaugeNeedleX = Math.cos(d) * (this.PieRadius - (double)n) + d2;
        this.GaugeNeedleY = -Math.sin(d) * (this.PieRadius - (double)n) + d3;
    }

    public void setChartLocale(Locale locale) {
        this.ChartLocale = locale;
    }

    public Locale getChartLocale() {
        return this.ChartLocale;
    }

    public void setFont(Font font) {
        this.font = font;
        this.fontMetricsGot = false;
    }

    private void getFMetrics(Graphics2D graphics2D) {
        if (this.fontMetricsGot) {
            return;
        }
        this.fontmet = graphics2D.getFontMetrics(this.font);
        this.fontMetricsGot = true;
    }

    public void setStartAngle(double d) {
        this.initialStartAngle = d;
    }

    public void setExternalLabelsOff() {
        this.simpleApproach = true;
    }

    public void setLegendForceOn() {
        this.forceLegendApproach = true;
    }

    public void setLegendDisable(boolean bl) {
        this.disableLegend = true;
    }

    public boolean getLegendDisable() {
        return this.disableLegend;
    }

    public void setBackgroundRectOff() {
        this.drawBackgroundRect = false;
    }

    public void setLastWordNewline() {
        this.lastWordNewline = true;
    }

    public void setSeparateLine(char c) {
        this.SeparateLineCharsC = new char[1];
        this.SeparateLineCharsC[0] = c;
    }

    public void setSeparateLine(char[] cArray) {
        this.SeparateLineCharsC = cArray;
    }

    public void setDelimiter(char c) {
        this.userDefinedDelimiters = true;
        this.userDelimiters = new char[]{c};
    }

    public void setDelimiter(char[] cArray) {
        this.userDefinedDelimiters = true;
        this.userDelimiters = cArray;
    }

    public void setEnableAutoColorAdjustSliceLabel(boolean bl) {
        this.AutoColorAdjustSliceLabel = bl;
    }

    public boolean getEnableAutoColorAdjustSliceLabel() {
        return this.AutoColorAdjustSliceLabel;
    }

    private void dumpDelimiters() {
        System.out.println("dumpDelimiters" + this.userDelimiters.length);
        for (int i = 0; i < this.userDelimiters.length; ++i) {
            System.out.println("|" + this.userDelimiters[i] + "|");
        }
    }

    private boolean containsDelimiters(PieSliceDesc pieSliceDesc) {
        String string = pieSliceDesc.getLabel();
        if (string == null || string == "") {
            return false;
        }
        string = string.trim();
        if (!this.userDefinedDelimiters) {
            int n = string.indexOf(32);
            if (n > -1) {
                return true;
            }
        } else {
            for (int i = 0; i < this.userDelimiters.length; ++i) {
                int n = string.indexOf(this.userDelimiters[i]);
                if (n <= -1) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsSeparateLineDelimiters(PieSliceDesc pieSliceDesc) {
        String string = pieSliceDesc.getLabel();
        if (string == null || string == "") {
            return false;
        }
        for (int i = 0; i < this.SeparateLineCharsC.length; ++i) {
            int n = string.indexOf(this.SeparateLineCharsC[i]);
            if (n <= -1) continue;
            return true;
        }
        return false;
    }

    private int evenPieDiameter(int n) {
        if (n % 2 != 0) {
            --n;
        }
        return n;
    }

    private void setPieDiameter2() {
        int n;
        boolean bl = false;
        bl = false;
        int n2 = this.displayWidth - super.getBorderLeft() - super.getBorderRight() - this.ScoreD.space_left_needed - this.ScoreD.space_right_needed;
        int n3 = this.displayHeight - super.getBorderTop() - super.getBorderBottom() - this.ScoreD.space_top_needed - this.ScoreD.space_bottom_needed;
        if (n3 < 0) {
            n3 = 10;
        }
        if (n2 < 0) {
            n2 = 10;
        }
        PieDim pieDim = new PieDim();
        if (this.StyleDesc.getStyleType() != 0) {
            pieDim.width = n2;
            pieDim.height = n3;
            pieDim = this.Adjust3D.setAdjustPieDiameter(pieDim);
            n2 = pieDim.width;
            n3 = pieDim.height;
        }
        if (this.PieSubType == 1) {
            if (this.GaugeSpanPrivate <= 180.0) {
                n3 *= 2;
            }
            n2 = (int)((double)n2 + (double)n2 * (1.0 - this.GaugeWidthFraction));
        }
        this.PieDiameter = Math.min(n2, n3);
        this.PieDiameter = this.evenPieDiameter(this.PieDiameter);
        this.PieRadius = (double)this.PieDiameter / 2.0;
        this.PieDiameterHeight = this.PieDiameter;
        this.PieDiameterWidth = this.PieDiameter;
        if (this.PieSubType == 1) {
            this.PieDiameterHeight = this.PieDiameter / 2;
            this.PieDiameterWidth = this.PieDiameter;
        }
        int n4 = this.displayWidth - super.getBorderLeft() - super.getBorderRight() - this.ScoreD.space_left_needed - this.ScoreD.space_right_needed - this.PieDiameterWidth - this.CircumLabelEastExtraInt - this.CircumLabelWestExtraInt;
        int n5 = this.displayHeight - super.getBorderTop() - this.ScoreD.space_top_needed - super.getBorderBottom() - this.ScoreD.space_bottom_needed - this.PieDiameterHeight - this.CircumLabelNorthExtraInt - this.CircumLabelSouthExtraInt;
        this.YOffset = super.getBorderTop() + this.ScoreD.space_top_needed + (n5 -= this.Adjust3D.Offset3D_Bottom + this.Adjust3D.Offset3D_Top) / 2;
        this.XOffset = super.getBorderLeft() + this.ScoreD.space_left_needed + (n4 -= this.Adjust3D.Offset3D_Left + this.Adjust3D.Offset3D_Right) / 2;
        this.XOffset += this.Adjust3D.Offset3D_Left;
        this.YOffset += this.Adjust3D.Offset3D_Top;
        int n6 = this.getAvailableHorizontalSpace() / 2;
        this.ScoreD.space_top_available = n = this.getAvailableVerticalSpace() / 2;
        this.ScoreD.space_bottom_available = n;
        this.ScoreD.space_left_available = n6;
        this.ScoreD.space_right_available = n6;
    }

    private int getAvailableHorizontalSpace() {
        int n = this.displayWidth - super.getBorderLeft() - super.getBorderRight() - this.PieDiameter - this.CircumLabelEastExtraInt - this.CircumLabelWestExtraInt;
        return n -= this.Adjust3D.Offset3D_Left + this.Adjust3D.Offset3D_Right;
    }

    private int getAvailableVerticalSpace() {
        int n = this.displayHeight - super.getBorderTop() - super.getBorderBottom() - this.PieDiameter - this.CircumLabelNorthExtraInt - this.CircumLabelSouthExtraInt;
        return n -= this.Adjust3D.Offset3D_Bottom + this.Adjust3D.Offset3D_Top;
    }

    private void setPieCenter() {
        int n = this.ScoreD.space_top_available + this.ScoreD.space_bottom_available - (this.ScoreD.space_top_needed + this.ScoreD.space_bottom_needed);
        int n2 = this.ScoreD.space_left_available + this.ScoreD.space_right_available - (this.ScoreD.space_left_needed + this.ScoreD.space_right_needed);
        this.XOffset = super.getBorderLeft() + this.ScoreD.space_left_needed + n2 / 2;
        this.YOffset = super.getBorderTop() + this.ScoreD.space_top_needed + n / 2;
        this.XOffset += this.Adjust3D.Offset3D_Left;
        this.YOffset += this.Adjust3D.Offset3D_Top;
    }

    protected int countLegendColumns(int n) {
        int n2;
        int n3 = this.L2.getLegendColumnWidth();
        int n4 = this.L2.getLegendNumItems();
        if (n4 < (n2 = n / n3)) {
            return n4;
        }
        int n5 = Precision.IntCeil(n4, n2);
        int n6 = Precision.IntCeil(n4, n5);
        return n6;
    }

    protected int countLegendColsHeight(int n, int n2) {
        int n3 = this.L2.getLegendHeightProjected(1);
        int n4 = Precision.IntCeil(n3, n);
        int n5 = this.L2.getLegendWidth() * n4;
        if (n5 > n2 - this.MIN_PIE) {
            n4 = this.countLegendColumns(n2 - this.MIN_PIE);
        }
        return n4;
    }

    private int getAvailableWidth() {
        return this.getAvailableWidth(false);
    }

    private int getAvailableWidth(boolean bl) {
        int n = this.displayWidth - super.getBorderLeft() - super.getBorderRight();
        if (bl) {
            n = (int)((double)n * this.L2.getLegendDesc().getLegendMaxWidthFraction());
        }
        return n;
    }

    private int getAvailableHeight() {
        return this.getAvailableHeight(false);
    }

    private int getAvailableHeight(boolean bl) {
        int n = this.displayHeight - super.getBorderTop() - super.getBorderBottom();
        if (bl) {
            n = (int)((double)n * this.L2.getLegendDesc().getLegendMaxHeightFraction());
        }
        return n;
    }

    private boolean setPieDiameterLegend(int n, int n2) {
        boolean bl = false;
        bl = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.L2.getLegendDesc().getLegendAlignment();
        switch (n5) {
            case -1: 
            case 4: 
            case 7: {
                n3 = this.countLegendColumns(this.displayWidth);
                n4 = this.L2.getLegendHeightProjected(n3);
                break;
            }
            case 2: 
            case 3: {
                boolean bl2;
                if (n > this.getAvailableWidth(true) && !(bl2 = this.L2.setLegendReduceWidth(this.getAvailableWidth(true)))) {
                    return false;
                }
                n4 = n2;
                if (n4 <= this.getAvailableHeight()) break;
                n3 = this.countLegendColsHeight(this.getAvailableHeight(), this.getAvailableWidth(true));
            }
        }
        PieDim pieDim = new PieDim();
        int n6 = this.displayWidth - super.getBorderLeft() - super.getBorderRight() - n;
        int n7 = this.displayHeight - super.getBorderTop() - super.getBorderBottom() - n4;
        if (this.StyleDesc.getStyleType() != 0) {
            pieDim.width = n6;
            pieDim.height = n7;
            pieDim = this.Adjust3D.setAdjustPieDiameter(pieDim);
            n6 = pieDim.width;
            n7 = pieDim.height;
        }
        int n8 = 0;
        int n9 = 0;
        if (n5 == -1 && n7 > n6 || n5 == 4 || n5 == 7) {
            int n10;
            this.L2.setLegendColumns(n3);
            double d = this.displayHeight - super.getBorderTop() - super.getBorderBottom();
            double d2 = d * this.L2.getLegendDesc().getLegendMaxHeightFraction();
            this.L2.setLegendMaxHeight((int)Math.round(d2));
            this.L2.reduceLegendElements();
            n2 = this.L2.getLegendHeight();
            n = this.L2.getLegendWidth();
            n6 = this.displayWidth - super.getBorderLeft() - super.getBorderRight();
            n7 = this.displayHeight - super.getBorderTop() - super.getBorderBottom() - n2;
            if (this.StyleDesc.getStyleType() != 0) {
                pieDim.width = n6;
                pieDim.height = n7;
                pieDim = this.Adjust3D.setAdjustPieDiameter(pieDim);
                n6 = pieDim.width;
                n7 = pieDim.height;
            }
            n8 = n7;
            n9 = n6;
            if (this.PieSubType == 1) {
                n8 *= 2;
                n9 = (int)((double)n9 + (double)n9 * (1.0 - this.GaugeWidthFraction));
            }
            this.PieDiameter = Math.min(n9, n8);
            this.PieDiameterHeight = this.PieDiameter = this.evenPieDiameter(this.PieDiameter);
            this.PieDiameterWidth = this.PieDiameter;
            if (this.PieSubType == 1) {
                this.PieDiameterHeight = this.PieDiameter / 2;
                this.PieDiameterWidth = n8 > n9 ? this.PieDiameter : this.PieDiameter;
            }
            if ((n10 = this.displayWidth - super.getBorderLeft() - super.getBorderRight() - n) < 0) {
                n10 = 0;
            }
            int n11 = this.displayWidth - super.getBorderLeft() - super.getBorderRight() - this.PieDiameterWidth;
            if (this.PieSubType != 1 && (n11 -= this.Adjust3D.Offset3D_Left + this.Adjust3D.Offset3D_Right) < 0) {
                n11 = 0;
            }
            int n12 = this.displayHeight - super.getBorderTop() - super.getBorderBottom() - this.PieDiameterHeight - n2 - this.LegendPieYSpacer - this.CircumLabelSouthExtraInt - this.CircumLabelNorthExtraInt;
            if ((n12 -= this.Adjust3D.Offset3D_Bottom + this.Adjust3D.Offset3D_Top) < 0) {
                n12 = 0;
            }
            n5 = this.L2.getLegendDesc().getLegendAlignment();
            int n13 = 0;
            int n14 = 0;
            switch (n5) {
                case -1: 
                case 4: {
                    this.YOffset = super.getBorderTop() + n12 / 2;
                    this.XOffset = super.getBorderLeft() + n11 / 2;
                    this.YOffset += this.Adjust3D.Offset3D_Top;
                    this.XOffset += this.Adjust3D.Offset3D_Left;
                    n14 = super.getBorderTop() + this.PieDiameterHeight + n12 / 2 + this.LegendPieYSpacer;
                    n13 = super.getBorderLeft() + n10 / 2;
                    this.L2.setLegendLocation(n13, n14 += this.Adjust3D.Offset3D_Bottom + this.Adjust3D.Offset3D_Top);
                    break;
                }
                case 7: {
                    this.YOffset = super.getBorderTop() + n2 + n12 / 2 + this.LegendPieYSpacer - this.CircumLabelSouthExtraInt / 2 + this.CircumLabelNorthExtraInt;
                    this.XOffset = super.getBorderLeft() + n11 / 2;
                    this.YOffset += this.Adjust3D.Offset3D_Top;
                    this.XOffset += this.Adjust3D.Offset3D_Left;
                    n14 = super.getBorderTop();
                    n13 = super.getBorderLeft() + n10 / 2;
                    this.L2.setLegendLocation(n13, n14);
                }
            }
            this.CircumfVerticalSpace = n7 - this.PieDiameter - n2;
            this.CircumfHorizontalSpace = n6 - this.PieDiameter;
        } else {
            if (n5 == -1) {
                this.L2.setLegendColumns(1);
                n2 = this.L2.getLegendHeight();
                n = this.L2.getLegendWidth();
                n4 = n2;
                n3 = 1;
                if (n > this.getAvailableWidth(true)) {
                    return false;
                }
                if (n4 > this.getAvailableHeight()) {
                    n3 = this.countLegendColsHeight(this.getAvailableHeight(), this.getAvailableWidth(true));
                }
            }
            this.L2.setLegendColumns(n3);
            n2 = this.L2.getLegendHeight();
            n = this.L2.getLegendWidth();
            double d = this.getAvailableHeight();
            if (d < (double)n2) {
                this.L2.setLegendMaxHeight((int)Math.round(d));
                this.L2.reduceLegendElements();
                n2 = this.L2.getLegendHeight();
            }
            n7 = this.displayHeight - super.getBorderTop() - super.getBorderBottom();
            n6 = this.displayWidth - super.getBorderLeft() - super.getBorderRight() - n;
            if (this.StyleDesc.getStyleType() != 0) {
                pieDim.width = n6;
                pieDim.height = n7;
                pieDim = this.Adjust3D.setAdjustPieDiameter(pieDim);
                n6 = pieDim.width;
                n7 = pieDim.height;
            }
            n8 = n7;
            n9 = n6;
            this.PieDiameter = Math.min(n9, n8);
            this.PieDiameter = this.evenPieDiameter(this.PieDiameter);
            int n15 = this.displayWidth - n - this.LegendPieYSpacer - super.getBorderLeft() - super.getBorderRight();
            if (n15 < this.PieDiameter) {
                this.PieDiameter = n15;
            }
            int n16 = this.displayHeight - super.getBorderTop() - super.getBorderBottom() - this.PieDiameter;
            if ((n16 -= this.Adjust3D.Offset3D_Bottom + this.Adjust3D.Offset3D_Top) < 0) {
                n16 = 0;
            }
            n2 = this.L2.getLegendHeight();
            n = this.L2.getLegendWidth();
            int n17 = this.displayWidth - super.getBorderLeft() - super.getBorderRight() - this.PieDiameter - this.LegendPieYSpacer;
            int n18 = this.displayHeight - super.getBorderTop() - super.getBorderBottom() - n2;
            if (n18 < 0) {
                n18 = 0;
            }
            int n19 = this.displayWidth - super.getBorderLeft() - super.getBorderRight() - this.PieDiameter - n - this.LegendPieXSpacer - this.CircumLabelEastExtraInt - this.CircumLabelWestExtraInt;
            if ((n19 -= this.Adjust3D.Offset3D_Left + this.Adjust3D.Offset3D_Right) < 0) {
                n19 = 0;
            }
            n5 = this.L2.getLegendDesc().getLegendAlignment();
            int n20 = 0;
            int n21 = 0;
            switch (n5) {
                case -1: 
                case 3: {
                    this.XOffset = super.getBorderLeft() + n19 / 3;
                    this.YOffset = super.getBorderTop() + n16 / 2;
                    this.YOffset += this.Adjust3D.Offset3D_Top;
                    this.XOffset += this.Adjust3D.Offset3D_Left;
                    n20 = super.getBorderLeft() + this.PieDiameter + 2 * n19 / 3 + this.LegendPieXSpacer;
                    n21 = super.getBorderTop() + n18 / 2;
                    this.L2.setLegendLocation(n20 += this.Adjust3D.Offset3D_Right + this.Adjust3D.Offset3D_Left, n21);
                    break;
                }
                case 2: {
                    this.XOffset = super.getBorderLeft() + n + 2 * n19 / 3 + this.LegendPieXSpacer;
                    this.YOffset = super.getBorderTop() + n16 / 2;
                    this.YOffset += this.Adjust3D.Offset3D_Top;
                    this.XOffset += this.Adjust3D.Offset3D_Left;
                    n20 = super.getBorderLeft() + n19 / 3;
                    n21 = super.getBorderTop() + n18 / 2;
                    this.L2.setLegendLocation(n20, n21);
                }
            }
            this.CircumfVerticalSpace = n7 - this.PieDiameter;
            this.CircumfHorizontalSpace = n6 - this.PieDiameter;
        }
        this.PieRadius = (double)this.PieDiameter / 2.0;
        return true;
    }

    private void adjustLegendPlacement() {
        int n = this.L2.getLegendDesc().getLegendAlignment();
        int n2 = this.L2.getLegendHeight();
        int n3 = this.L2.getLegendWidth();
        int n4 = this.displayWidth - super.getBorderLeft() - super.getBorderRight() - n3;
        int n5 = this.displayHeight - super.getBorderTop() - super.getBorderBottom() - n2;
        int n6 = this.L2.getLegendX();
        int n7 = this.L2.getLegendY();
        if (n == -1 && n5 > n4 || n == 4 || n == 7) {
            n = this.L2.getLegendDesc().getLegendAlignment();
            switch (n) {
                case -1: 
                case 4: {
                    if (this.CircumLabelSouthExtraInt == 0) break;
                    this.L2.setLegendLocation(n6, n7 += this.CircumLabelSouthExtraInt);
                    break;
                }
            }
        } else {
            switch (n) {
                case -1: 
                case 3: {
                    if (this.CircumLabelEastExtraInt == 0) break;
                    this.L2.setLegendLocation(n6 += this.CircumLabelEastExtraInt, n7);
                    break;
                }
                case 2: {
                    if (this.CircumLabelWestExtraInt == 0) break;
                    this.L2.setLegendLocation(n6 -= this.CircumLabelWestExtraInt, n7);
                }
            }
        }
        this.PieRadius = (double)this.PieDiameter / 2.0;
    }

    private void setPieDiameter(int n) {
        if (n <= 0) {
            return;
        }
        if (n > this.displayHeight) {
            return;
        }
        if (n > this.displayWidth) {
            return;
        }
        this.PieDiameter = n;
    }

    public void setAutoSliceColor(Color color, Color color2) {
        this.colorStart = color;
        this.colorEnd = color2;
        this.userDefinedPieColors = true;
        this.autoSliceColor();
    }

    public PieSliceDesc getPieSliceDesc(int n) throws ChartException {
        String string = "getPieSliceDesc()";
        if (this.SliceDesc == null) {
            Errorfcn.chartError(string, MsgUtil.getMsg("CHT-001"));
        }
        if (this.SliceDesc.length > n && n >= 0) {
            return this.SliceDesc[n];
        }
        Errorfcn.chartError(string, MsgUtil.getMsg("CHT-004"));
        return this.SliceDesc[0];
    }

    public void setDeriveLabelPct() throws ChartException {
        String string = "setDeriveLabelPct()";
        if (this.labelInteriorVal) {
            Errorfcn.chartError(string, MsgUtil.getMsg("CHT-006"));
        }
        this.deriveLabelPct = true;
        this.useNumberFormat = true;
        this.numFormat = NumberFormat.getPercentInstance();
        if (this.SliceDesc != null) {
            this.deriveNumericalLabelPct(false);
        }
    }

    public void setDeriveLabelPct(NumberFormat numberFormat) throws ChartException {
        String string = "setDeriveLabelPct()";
        if (this.labelInteriorVal) {
            Errorfcn.chartError(string, MsgUtil.getMsg("CHT-006"));
        }
        this.useNumberFormat = true;
        this.numFormat = numberFormat;
        this.deriveLabelPct = true;
        if (this.SliceDesc != null) {
            this.deriveNumericalLabelPct(false);
        }
    }

    public void setDeriveLabelPctOff() {
        this.deriveLabelPct = false;
        this.deriveNumericalLabelValOrPctOff();
    }

    public void setDeriveLabelPct(int n) throws ChartException {
        String string = "setDeriveLabelPct()";
        if (this.labelInteriorVal) {
            Errorfcn.chartError(string, MsgUtil.getMsg("CHT-006"));
        }
        if (n >= 0) {
            this.LabelPrecision = n;
        }
        this.setDeriveLabelPct();
    }

    public void setLabelInteriorPct() throws ChartException {
        String string = "setLabelInteriorPct()";
        if (this.labelInteriorVal) {
            Errorfcn.chartError(string, MsgUtil.getMsg("CHT-006"));
        }
        this.labelInteriorPct = true;
        this.deriveLabelPct = true;
        if (!this.useNumberFormat) {
            this.useNumberFormat = true;
            this.numFormat = NumberFormat.getPercentInstance();
        }
        if (this.SliceDesc != null) {
            this.deriveNumericalLabelPct(false);
        }
    }

    public void setLabelInteriorPctOff() {
        this.labelInteriorPct = false;
        this.deriveLabelVal = false;
        this.deriveLabelPct = false;
        this.deriveNumericalLabelValOrPctOff();
    }

    public void setLabelInteriorVal() {
        this.labelInteriorVal = true;
        this.deriveLabelVal = true;
        if (!this.useNumberFormat) {
            this.useNumberFormat = true;
            this.numFormat = NumberFormat.getInstance(this.ChartLocale);
        }
        if (this.SliceDesc != null) {
            this.deriveNumericalLabelVal(this.savedSliceValues, false);
        }
    }

    public void setLabelInteriorValOff() {
        this.labelInteriorVal = false;
        this.deriveLabelVal = false;
        this.deriveLabelPct = false;
        this.deriveNumericalLabelValOrPctOff();
    }

    public void setDeriveLabelVal() throws ChartException {
        String string = "setDeriveLabelVal()";
        if (this.labelInteriorPct) {
            Errorfcn.chartError(string, MsgUtil.getMsg("CHT-005"));
        }
        this.deriveLabelVal = true;
        if (this.SliceDesc != null && this.savedSliceValues.length > 0) {
            this.deriveNumericalLabelVal(this.savedSliceValues, false);
        }
    }

    public void setDeriveLabelVal(NumberFormat numberFormat) throws ChartException {
        String string = "setDeriveLabelVal()";
        if (this.labelInteriorPct) {
            Errorfcn.chartError(string, MsgUtil.getMsg("CHT-005"));
        }
        this.useNumberFormat = true;
        this.numFormat = numberFormat;
        this.deriveLabelVal = true;
        if (this.SliceDesc != null && this.savedSliceValues.length > 0) {
            this.deriveNumericalLabelVal(this.savedSliceValues, false);
        }
    }

    public void setDeriveLabelValOff() {
        this.deriveLabelVal = false;
        this.deriveNumericalLabelValOrPctOff();
    }

    public void setDeriveLabelVal(int n) throws ChartException {
        String string = "setDeriveLabelVal()";
        if (this.labelInteriorPct) {
            Errorfcn.chartError(string, MsgUtil.getMsg("CHT-005"));
        }
        if (n >= 0) {
            this.LabelPrecision = n;
        }
        this.setDeriveLabelVal();
    }

    private void autoSliceColor() {
        if (this.SliceDesc == null) {
            return;
        }
        if (this.SliceDesc.length != 0) {
            int n = this.SliceDesc.length - 1;
            int n2 = this.colorStart.getRed();
            int n3 = this.colorStart.getGreen();
            int n4 = this.colorStart.getBlue();
            this.SliceDesc[0].setBackground(new Color(n2, n3, n4));
            if (n > 0) {
                int n5 = this.colorEnd.getRed();
                int n6 = (n5 - n2) / n;
                int n7 = this.colorEnd.getGreen();
                int n8 = (n7 - n3) / n;
                int n9 = this.colorEnd.getBlue();
                int n10 = (n9 - n4) / n;
                this.SliceDesc[this.SliceDesc.length - 1].setBackground(new Color(n5, n7, n9));
                for (int i = 1; i < this.SliceDesc.length - 1; ++i) {
                    int n11 = n2 + i * n6;
                    int n12 = n3 + i * n8;
                    int n13 = n4 + i * n10;
                    this.SliceDesc[i].setBackground(new Color(n11, n12, n13));
                }
            }
        }
    }

    public void setChartAttributes(PieStyleDesc pieStyleDesc) throws ChartException {
        this.StyleDesc = pieStyleDesc;
        if (pieStyleDesc.getStyleType() == 2) {
            this.E3D.setExtrusionAngle(pieStyleDesc.getExtrusionAngle());
            this.E3D.setExtrusionThickness(pieStyleDesc.getExtrusionThickness());
            this.E3D.setPerspectiveDistance(pieStyleDesc.getPerspectiveDistance());
        } else if (pieStyleDesc.getStyleType() == 1) {
            this.E3D.setExtrusionAngle(pieStyleDesc.getExtrusionAngle());
            this.E3D.setExtrusionThickness(pieStyleDesc.getExtrusionThickness());
            this.E3D.setPerspectiveDistance(pieStyleDesc.getPerspectiveDistance());
        }
    }

    protected void setGaugeAttributes(GaugeStyleDesc gaugeStyleDesc) throws ChartException {
        this.GaugeStyleDesc = gaugeStyleDesc;
        this.initGaugeStyleParams();
    }

    public void setSeries(PieSliceDesc[] pieSliceDescArray) throws ChartException {
        int n;
        String string = "setSeries()";
        int n2 = pieSliceDescArray.length;
        this.SliceDesc = new PieSliceDesc[n2];
        this.SliceAngle = new PieSliceAngle[n2];
        this.SliceLabelLoc = new PieSliceLabelLoc[n2];
        this.SliceSecondLabel = new String[n2];
        this.SliceOriginalLabel = new String[n2];
        this.SliceStoredLayout = new StoredLayout[n2];
        this.IEGlobal = new boolean[n2];
        this.interiorLabel = new boolean[n2];
        for (n = 0; n < n2; ++n) {
            if (pieSliceDescArray[n] == null) {
                Errorfcn.chartError("setSeries()", MsgUtil.getMsg("CHT-000"));
            }
            this.interiorLabel[n] = false;
            this.SliceAngle[n] = new PieSliceAngle();
            this.SliceLabelLoc[n] = new PieSliceLabelLoc();
            this.SliceStoredLayout[n] = new StoredLayout();
            this.SliceSecondLabel[n] = "";
            String string2 = pieSliceDescArray[n].getLabel();
            if (string2 != null) continue;
            pieSliceDescArray[n].setLabel("");
        }
        double d = 0.0;
        for (n = 0; n < n2; ++n) {
            double d2 = pieSliceDescArray[n].getValue();
            if (d2 < 0.0) {
                log.info(MsgUtil.getMsg("CHT-002"));
            }
            d += d2;
        }
        d = this.PieSubType == 1 ? (d /= this.GaugeSpanPrivate / 360.0 * 100.0) : (d /= 100.0);
        boolean bl = false;
        this.savedSliceValues = new double[n2];
        for (n = 0; n < n2; ++n) {
            double d3;
            this.savedSliceValues[n] = d3 = pieSliceDescArray[n].getValue();
            this.SliceOriginalLabel[n] = pieSliceDescArray[n].getLabel();
            this.SliceDesc[n] = new PieSliceDesc(pieSliceDescArray[n].getLabel(), d3 / d);
            this.SliceDesc[n].setBackground(pieSliceDescArray[n].getBackground());
            this.SliceDesc[n].setLabelColor(pieSliceDescArray[n].getLabelColor());
        }
        if (d == 0.0) {
            this.rewriteZeroPct(this.savedSliceValues);
        }
        if (this.deriveLabelVal) {
            this.deriveNumericalLabelVal(this.savedSliceValues, false);
        } else if (this.deriveLabelPct) {
            this.deriveNumericalLabelPct(false);
        }
        if (this.genImageMapCoords) {
            this.ImageMapCoords = new int[pieSliceDescArray.length][0];
        }
        if (this.userDefinedPieColors) {
            this.autoSliceColor();
        }
    }

    public void setSeriesDirection(boolean bl) {
        this.clockwise = bl;
    }

    public boolean getSeriesDirection() {
        return this.clockwise;
    }

    private void recomputeSliceValues() {
        int n;
        double d = 0.0;
        int n2 = this.savedSliceValues.length;
        for (n = 0; n < n2; ++n) {
            d += this.savedSliceValues[n];
        }
        d = this.PieSubType == 1 ? (d /= this.GaugeSpanPrivate / 360.0 * 100.0) : (d /= 100.0);
        for (n = 0; n < n2; ++n) {
            this.SliceDesc[n].setValue(this.savedSliceValues[n] / d);
        }
    }

    void rewriteZeroPct(double[] dArray) {
        double d;
        int n;
        int n2 = dArray.length;
        boolean bl = true;
        for (n = 0; n < n2; ++n) {
            d = dArray[n];
            if (d == 0.0) continue;
            bl = false;
            break;
        }
        if (bl) {
            for (n = 0; n < n2; ++n) {
                d = dArray[n];
                this.SliceDesc[n] = new PieSliceDesc(this.SliceDesc[n].getLabel(), 100.0 / (double)n2);
                d = this.SliceDesc[n].getValue();
            }
        }
    }

    private void deriveNumericalLabelPct(boolean bl) {
        int n = this.SliceDesc.length;
        if (this.deriveLabelPct && this.useNumberFormat) {
            for (int i = 0; i < n; ++i) {
                double d = this.SliceDesc[i].getValue() / 100.0;
                String string = this.numFormat.format(d);
                if (this.labelInteriorPct && !bl) {
                    this.SliceSecondLabel[i] = string;
                    this.SliceDesc[i].setLabel(this.SliceOriginalLabel[i]);
                    continue;
                }
                String string2 = this.SliceOriginalLabel[i];
                string2 = string2 != null && string2.length() > 0 ? string2.trim() + " " + string : string;
                this.SliceDesc[i].setLabel(string2);
            }
        }
    }

    private void deriveNumericalLabelVal(double[] dArray, boolean bl) {
        block7: {
            int n = dArray.length;
            if (!this.deriveLabelVal) break block7;
            if (this.useNumberFormat) {
                for (int i = 0; i < n; ++i) {
                    String string = this.numFormat.format(dArray[i]);
                    if (this.labelInteriorVal && !bl) {
                        this.SliceSecondLabel[i] = string;
                        this.SliceDesc[i].setLabel(this.SliceOriginalLabel[i]);
                        continue;
                    }
                    String string2 = this.SliceOriginalLabel[i];
                    string2 = string2 != null && string2.length() > 0 ? string2.trim() + " " + string : string;
                    this.SliceDesc[i].setLabel(string2);
                }
            } else {
                boolean bl2 = !this.isFractional(dArray);
                int n2 = 0;
                if (!bl2) {
                    n2 = Precision.computeSignif(dArray);
                }
                for (int i = 0; i < n; ++i) {
                    String string = this.LabelPrecision != -1 ? (this.LabelPrecision == 0 ? String.valueOf((int)dArray[i]) : Precision.roundNSig(dArray[i], this.LabelPrecision - 1)) : (bl2 ? String.valueOf((int)dArray[i]) : Precision.roundNSig(dArray[i], n2));
                    if (this.labelInteriorVal && !bl) {
                        this.SliceSecondLabel[i] = string;
                        continue;
                    }
                    String string3 = this.SliceOriginalLabel[i];
                    string3 = string3 != null && string3.length() > 0 ? string3.trim() + " " + string : string;
                    this.SliceDesc[i].setLabel(string3);
                }
            }
        }
    }

    private void deriveNumericalLabelValOrPctOff() {
        if (this.SliceOriginalLabel != null) {
            int n = this.SliceOriginalLabel.length;
            for (int i = 0; i < n; ++i) {
                this.SliceDesc[i].setLabel(this.SliceOriginalLabel[i]);
            }
        }
    }

    private boolean isFractionalSlicePct() {
        if (this.SliceDesc != null) {
            int n = this.SliceDesc.length;
            for (int i = 0; i < n; ++i) {
                int n2;
                double d;
                double d2 = this.SliceDesc[i].getValue();
                double d3 = d2 - (d = (double)(n2 = (int)Math.round(d2)));
                if (d3 == 0.0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isFractional(double[] dArray) {
        for (double d : dArray) {
            int n = (int)d;
            double d2 = n;
            double d3 = d - d2;
            if (d3 == 0.0) continue;
            return true;
        }
        return false;
    }

    private int getQuadNumber(double d) {
        double d2 = this.getNormalizedAngle(d);
        if (d2 > 0.0 && d2 <= 90.0) {
            return 1;
        }
        if (d2 > 90.0 && d2 <= 180.0) {
            return 2;
        }
        if (d2 > 180.0 && d2 <= 270.0) {
            return 3;
        }
        if (d2 > 270.0 && d2 <= 360.0) {
            return 4;
        }
        return 1;
    }

    private boolean inQuad1(double d) {
        return d >= 0.0 && d <= 90.0;
    }

    private boolean inQuad2(double d) {
        return d >= 90.0 && d < 180.0;
    }

    private boolean inQuad3(double d) {
        return d >= 180.0 && d < 270.0;
    }

    private boolean inQuad4(double d) {
        return d >= 270.0 && d <= 360.0;
    }

    private boolean openTopHemisphere(double d, double d2) {
        int n;
        int n2 = n = 10;
        int n3 = 180 - n;
        if (d2 < (double)n) {
            d2 += 360.0;
        }
        return d <= (double)n2 || d >= (double)n3 && d <= 360.0 && d2 >= (double)n3 && d2 <= (double)(360 + n) && d > d2;
    }

    private boolean openBottomHemisphere(double d, double d2) {
        double d3 = d + 180.0;
        double d4 = d2 + 180.0;
        return this.openTopHemisphere(d3, d4);
    }

    private double getNormalizedAngle(double d) {
        if (d < 360.0 && d >= 0.0) {
            return d;
        }
        if (Math.abs(d) < 0.001) {
            return 0.0;
        }
        while (d >= 360.0) {
            d -= 360.0;
        }
        while (d < 0.0) {
            d += 360.0;
        }
        return d;
    }

    private void initCircumference() {
        this.xMinTextNormalized = -1.0;
        this.yMinTextNormalized = -1.0;
        this.xMaxTextNormalized = 1.0;
        this.yMaxTextNormalized = 1.0;
        this.xMinNormalized = -1.0;
        this.yMinNormalized = -1.0;
        this.xMaxNormalized = 1.0;
        this.yMaxNormalized = 1.0;
        this.CircumLabelHeightOffset = 0.0;
        this.CircumLabelWidthOffset = 0.0;
        this.CircumLabelNorthExtra = 0.0;
        this.CircumLabelSouthExtra = 0.0;
        this.CircumLabelEastExtra = 0.0;
        this.CircumLabelWestExtra = 0.0;
    }

    private void initCircumference2() {
        this.CircumLabelEastExtraInt = 0;
        this.CircumLabelWestExtraInt = 0;
        this.CircumLabelHeightOffsetInt = 0;
        this.CircumLabelWidthOffsetInt = 0;
        this.CircumLabelNorthExtraInt = 0;
        this.CircumLabelSouthExtraInt = 0;
    }

    private void printXYNormal() {
        System.out.println("   printXYNormal " + this.xMinTextNormalized + " " + this.yMinTextNormalized + " " + this.xMaxTextNormalized + " " + this.yMaxTextNormalized);
    }

    private void printXYNormal2() {
        System.out.println("printXYNormal " + this.xMinNormalized + " " + this.yMinNormalized + " " + this.xMaxNormalized + " " + this.yMaxNormalized);
    }

    private void convertCircumLabelOffset() {
        this.CircumLabelHeightOffsetInt = (int)Math.round(this.CircumLabelHeightOffset * this.PieRadius);
        this.CircumLabelWidthOffsetInt = (int)Math.round(this.CircumLabelWidthOffset * this.PieRadius);
        this.CircumLabelNorthExtraInt = (int)Math.round(this.CircumLabelNorthExtra * this.PieRadius);
        this.CircumLabelSouthExtraInt = (int)Math.round(this.CircumLabelSouthExtra * this.PieRadius);
        this.CircumLabelEastExtraInt = (int)Math.round(this.CircumLabelEastExtra * this.PieRadius);
        this.CircumLabelWestExtraInt = (int)Math.round(this.CircumLabelWestExtra * this.PieRadius);
    }

    private void convertCircumEastWest() {
        this.CircumLabelEastExtraInt = (int)Math.round(this.CircumLabelEastExtra * this.PieRadius);
        this.CircumLabelWestExtraInt = (int)Math.round(this.CircumLabelWestExtra * this.PieRadius);
    }

    private void convertCircumNorthSouth() {
        this.CircumLabelNorthExtraInt = (int)Math.round(this.CircumLabelNorthExtra * this.PieRadius);
        this.CircumLabelSouthExtraInt = (int)Math.round(this.CircumLabelSouthExtra * this.PieRadius);
    }

    private double allocateCircumNorthSouth() {
        double d = 1.0;
        if (this.yMinNormalized == -1.0) {
            double d2;
            this.CircumLabelHeightOffset = d2 = (this.yMaxNormalized - 1.0) / 2.0;
            d = 1.0 + d2;
        } else if (this.yMaxNormalized == 1.0) {
            double d3;
            this.CircumLabelHeightOffset = d3 = (this.yMinNormalized + 1.0) / 2.0;
            d = 1.0 + Math.abs(d3);
        } else {
            d = Math.max(Math.abs(this.yMinNormalized), Math.abs(this.yMaxNormalized));
        }
        return d;
    }

    private double allocateCircumEastWest() {
        double d = 1.0;
        if (this.xMinNormalized == -1.0) {
            double d2 = (this.xMaxNormalized - 1.0) / 2.0;
            this.CircumLabelWidthOffset = -d2;
            d = 1.0 + d2;
        } else if (this.xMaxNormalized == 1.0) {
            double d3 = (this.xMinNormalized + 1.0) / 2.0;
            this.CircumLabelWidthOffset = Math.abs(d3);
            d = 1.0 + Math.abs(d3);
        } else {
            d = Math.max(Math.abs(this.xMinNormalized), Math.abs(this.xMaxNormalized));
        }
        return d;
    }

    private void adjustCircumEastWest() {
        if (this.xMaxNormalized > Math.abs(this.xMinNormalized)) {
            double d;
            this.CircumLabelEastExtra = d = this.xMaxNormalized - 1.0;
        } else {
            double d = this.xMinNormalized + 1.0;
            this.CircumLabelWestExtra = Math.abs(d);
        }
    }

    private void adjustCircumNorthSouth() {
        double d;
        this.CircumLabelNorthExtra = d = (this.yMaxNormalized - 1.0) / 2.0;
        d = (this.yMinNormalized + 1.0) / 2.0;
        this.CircumLabelSouthExtra = Math.abs(d);
    }

    private double getMaxXYNormalized() {
        if (this.CircumfHorizontalSpace > 0) {
            double d = this.allocateCircumNorthSouth();
            this.adjustCircumEastWest();
            this.convertCircumEastWest();
            if (this.CircumLabelEastExtraInt + this.CircumLabelWestExtraInt < this.CircumfHorizontalSpace) {
                return d;
            }
            double d2 = this.allocateCircumEastWest();
            this.CircumLabelEastExtra = 0.0;
            this.CircumLabelWestExtra = 0.0;
            return Math.max(d, d2);
        }
        if (this.CircumfVerticalSpace > 0) {
            double d = this.allocateCircumEastWest();
            this.adjustCircumNorthSouth();
            this.convertCircumNorthSouth();
            if (this.CircumLabelNorthExtraInt + this.CircumLabelSouthExtraInt < this.CircumfVerticalSpace) {
                return d;
            }
            double d3 = this.allocateCircumNorthSouth();
            this.CircumLabelNorthExtra = 0.0;
            this.CircumLabelSouthExtra = 0.0;
            return Math.max(d3, d);
        }
        double d = Math.max(Math.abs(this.yMinNormalized), Math.abs(this.yMaxNormalized));
        double d4 = Math.max(Math.abs(this.xMinNormalized), Math.abs(this.xMaxNormalized));
        this.CircumLabelHeightOffset = 0.0;
        this.CircumLabelWidthOffset = 0.0;
        return Math.max(d, d4);
    }

    private void test500() {
        PieLayout pieLayout = new PieLayout();
        double d = 0.8;
        double d2 = 10.0;
        pieLayout.getBottomEdge2(d, Math.toRadians(10.0));
        pieLayout.getBottomEdge2(d, Math.toRadians(45.0));
        pieLayout.getBottomEdge2(d, Math.toRadians(80.0));
    }

    void drawLabelInSlice(Graphics2D graphics2D, PieLayout pieLayout, boolean bl, String string, Vector vector, int n) {
        if (string == null || string == "") {
            return;
        }
        boolean bl2 = false;
        if (bl2) {
            System.out.println("");
            System.out.println("######## drawLabelInSlice ######### " + n);
            System.out.println("PieRadius" + this.PieRadius);
            System.out.println("PieDiameter" + this.PieDiameter);
        }
        if (bl2) {
            System.out.println("drawLabelInSlice: XTr(), YTr(): (" + pieLayout.getXTr() + "," + pieLayout.getYTr() + ")");
        }
        if (bl2) {
            System.out.println("drawLabelInSlice: XTr(), YTr() * PieRadius: (" + pieLayout.getXTr() * this.PieRadius + "," + pieLayout.getYTr() * this.PieRadius + ")");
        }
        int n2 = (int)Math.round(pieLayout.getXTr() * this.PieRadius) + this.XOffset + this.CircumLabelWidthOffsetInt;
        int n3 = (int)Math.round(pieLayout.getYTr() * this.PieRadius) + this.YOffset + this.CircumLabelHeightOffsetInt;
        if (bl2) {
            System.out.println("drawLabelInSlice: x,y: (" + n2 + "," + n3 + ")");
        }
        int n4 = (int)Math.round(pieLayout.getWidth() * this.PieRadius);
        int n5 = (int)Math.round(pieLayout.getHeight() * this.PieRadius);
        if (bl2) {
            System.out.println("drawLabelInSlice: w,h: (" + n4 + "," + n5 + ")");
        }
        int n6 = this.fontmet.getMaxAscent();
        bl2 = false;
        int n7 = this.getFontMetrics(this.font).stringWidth(string);
        if (this.testRect) {
            Rectangle2D.Float float_ = new Rectangle2D.Float();
            ((Rectangle2D)float_).setRect(n2, n3, n4, n5);
            graphics2D.draw(float_);
        }
        int n8 = n2 + (n4 - n7) / 2;
        if (!bl) {
            if (this.drawText) {
                if (this.HilightLabelIndex == n) {
                    graphics2D.setColor(this.HilightLabelColor);
                    if (this.DrawLegend) {
                        this.L2.setLegendLabelColor(this.SliceDesc[n].getLabel(), this.HilightLabelColor);
                    }
                } else if (!this.AutoColorAdjustSliceLabel) {
                    graphics2D.setColor(this.SliceDesc[n].getLabelColor());
                } else {
                    float[] fArray = new float[3];
                    Color.RGBtoHSB(this.SliceDesc[n].getBackground().getRed(), this.SliceDesc[n].getBackground().getGreen(), this.SliceDesc[n].getBackground().getBlue(), fArray);
                    if (fArray[2] < 0.6f) {
                        float[] fArray2 = new float[3];
                        Color.RGBtoHSB(this.SliceDesc[n].getLabelColor().getRed(), this.SliceDesc[n].getLabelColor().getGreen(), this.SliceDesc[n].getLabelColor().getBlue(), fArray2);
                        if (fArray2[2] < 0.6f) {
                            graphics2D.setColor(Color.getHSBColor(fArray2[0], fArray2[2], 0.8f));
                        } else {
                            graphics2D.setColor(this.SliceDesc[n].getLabelColor());
                        }
                    } else {
                        graphics2D.setColor(this.SliceDesc[n].getLabelColor());
                    }
                }
                graphics2D.setFont(this.font);
                this.SliceLabelLoc[n].drawStringSetLocSize(graphics2D, string, n8, n3 + n6, n7, n6);
            }
        } else {
            int n9 = this.fontmet.getMaxAscent() + this.fontmet.getLeading();
            int n10 = n3;
            int n11 = 0;
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = (String)vector.elementAt(i);
                if (this.test) {
                    System.out.println("*** label *** " + i + " " + string2);
                }
                n11 = this.fontmet.stringWidth(string2);
                n8 = n2 + (n4 - n11) / 2;
                if (this.drawText) {
                    graphics2D.setFont(this.font);
                    if (this.HilightLabelIndex == n) {
                        graphics2D.setColor(this.HilightLabelColor);
                        if (this.DrawLegend) {
                            this.L2.setLegendLabelColor(this.SliceDesc[n].getLabel(), this.HilightLabelColor);
                        }
                    } else {
                        graphics2D.setColor(this.SliceDesc[n].getLabelColor());
                    }
                    if (i == 0) {
                        this.SliceLabelLoc[n].drawStringSetLocSize(graphics2D, string2, n8, n10 + n6, n7, n6);
                    } else {
                        this.SliceLabelLoc[n].drawString(graphics2D, string2, n8, n10 + n6);
                    }
                }
                n10 += n9;
            }
            this.SliceLabelLoc[n].setSize(n7, n10 - n3);
        }
        if (this.test) {
            System.out.println("xywh (" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        }
        if (this.test) {
            System.out.println("");
        }
    }

    void hilightLegendText(Graphics2D graphics2D) {
        if (!this.DrawLegend) {
            return;
        }
        for (int i = 0; i < this.SliceDesc.length; ++i) {
            if (this.HilightLabelIndex != i) continue;
            this.L2.setLegendLabelColor(this.SliceDesc[i].getLabel(), this.HilightLabelColor);
        }
    }

    void initMinMax() {
        this.minX = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
        this.minY = Integer.MAX_VALUE;
        this.maxY = Integer.MIN_VALUE;
    }

    public void redrawBuffer(Graphics2D graphics2D) throws ChartException {
        if (this.isZeroMask(this.IEGlobal)) {
            this.layoutL(graphics2D);
        } else {
            this.doLayout(graphics2D);
        }
        if (this.DrawLegend) {
            this.L2.drawLegendBuffer(graphics2D, this.genImageMapCoords);
        }
    }

    private boolean isZeroMask(boolean[] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            return false;
        }
        return true;
    }

    public BasicStroke getPieStroke() {
        return this.PieStroke;
    }

    public void setPieStroke(BasicStroke basicStroke) {
        this.PieStroke = basicStroke;
    }

    public BasicStroke getConnectorStroke() {
        return this.ConnectorStroke;
    }

    public void setConnectorStroke(BasicStroke basicStroke) {
        this.ConnectorStroke = basicStroke;
    }

    public Color getForeground() {
        return this.Foreground;
    }

    public void setForeground(Color color) {
        this.Foreground = color;
        super.setTitlesForeground(color);
        if (this.SliceDesc != null) {
            for (int i = 0; i < this.SliceDesc.length; ++i) {
                this.SliceDesc[i].setLabelColor(color);
            }
        }
    }

    private Color getConnectorColor() {
        return this.ConnectorColor;
    }

    private void setConnectorColor(Color color) {
        this.ConnectorColor = color;
    }

    public void drawBuffer(Graphics2D graphics2D) throws ChartException {
        int n;
        int n2;
        int n3;
        String string = "drawBuffer()";
        this.DrawBufferCalled = true;
        if (this.PieSubType == 1) {
            this.initGaugeStyleParams();
        }
        if (this.testdrawBuffer) {
            System.out.println();
            System.out.println("drawBuffer " + super.getWidth() + " " + super.getWidth());
            System.out.println("---------- ");
        }
        if (this.testAutoDiameter) {
            System.out.println();
            System.out.println();
            System.out.println("drawBuffer ");
            System.out.println("---------------------------------------------- ");
            System.out.println("---------------------------------------------- ");
        }
        if (this.isSetRenderingHintsChart()) {
            graphics2D.setRenderingHints(super.getRenderingHintsChart());
        }
        if (this.SliceDesc == null) {
            Errorfcn.chartError("drawBuffer()", MsgUtil.getMsg("CHT-000"));
        }
        if (this.SliceDesc.length <= 0) {
            return;
        }
        LayoutScore layoutScore = new LayoutScore();
        double d = 0.0;
        for (n3 = 0; n3 < this.SliceDesc.length; ++n3) {
            d += this.SliceDesc[n3].getValue();
        }
        if (d > 100.5) {
            Errorfcn.chartError("drawBuffer()", MsgUtil.getMsg("CHT-003"));
        }
        super.getTitle().setFontMetrics(graphics2D);
        super.getSubtitle().setFontMetrics(graphics2D);
        super.getFootnote().setFontMetrics(graphics2D);
        n3 = 0;
        if (super.getTitle().getText() != "") {
            n3 += super.getTitle().getHeight();
            super.getTitle().setLocation(0, 0);
            super.getTitle().setWidth(this.displayWidth);
        }
        if (super.getSubtitle().getText() != "") {
            n3 += super.getSubtitle().getHeight();
            if (super.getTitle().getText() != "") {
                super.getSubtitle().setLocation(0, super.getTitle().getHeight());
            } else {
                super.getSubtitle().setLocation(0, 0);
            }
            super.getSubtitle().setWidth(this.displayWidth);
        }
        if (super.getTitle().getText() != "" && super.getSubtitle().getText() == "") {
            n2 = super.getTitle().getHeight() / 6;
            n3 += n2;
        }
        if (n3 != 0) {
            this.setBorderTopInternal(n3);
        }
        if (super.getFootnote().getText() != "") {
            n3 = super.getFootnote().getHeight();
            n2 = (int)Math.round(1.5 * (double)n3);
            super.getFootnote().setLocation(0, this.displayHeight - n2);
            super.getFootnote().setWidth(this.displayWidth);
            n = 10;
            super.setBorderBottomInternal(n3 + n);
        }
        graphics2D.setFont(this.font);
        this.getFMetrics(graphics2D);
        graphics2D.setStroke(this.getPieStroke());
        if (this.testAutoDiameter) {
            System.out.println("Display " + this.displayWidth + " " + this.displayHeight);
        }
        boolean[] blArray = new boolean[this.SliceDesc.length];
        this.ScoreD.init();
        this.DrawLegend = false;
        n2 = 0;
        if (this.labelInteriorPct || this.labelInteriorVal) {
            for (n = 0; n < this.SliceDesc.length; ++n) {
                this.IEGlobal[n] = true;
            }
            if (this.forceLegendApproach) {
                this.addLegend();
                this.deriveNumericalLabelVal(this.savedSliceValues, true);
                this.deriveNumericalLabelPct(true);
                if (this.DrawLegend) {
                    this.L2.drawLegendBuffer(graphics2D, this.genImageMapCoords);
                }
                this.layoutL(graphics2D);
            } else {
                this.addLegend();
                n2 = this.layoutCircumferenceAllFit(graphics2D) ? 1 : 0;
                if (n2 != 0) {
                    this.deriveNumericalLabelVal(this.savedSliceValues, false);
                    this.deriveNumericalLabelPct(false);
                }
                if (n2 == 0) {
                    if (!this.simpleApproach) {
                        this.layoutCircumference(graphics2D);
                    }
                    if (this.simpleApproach) {
                        this.deriveNumericalLabelVal(this.savedSliceValues, true);
                        this.deriveNumericalLabelPct(true);
                    }
                }
                this.adjustLegendPlacement();
                if (this.DrawLegend) {
                    this.L2.drawLegendBuffer(graphics2D, this.genImageMapCoords);
                }
            }
        }
        if (this.simpleApproach && !this.labelInteriorPct && !this.labelInteriorVal || this.simpleApproach && (this.labelInteriorPct || this.labelInteriorVal) && n2 == 0) {
            this.setPieDiameter2();
            blArray = this.layout(graphics2D, 0, false, blArray);
            if (this.testAutoDiameter) {
                this.ScoreD.dumpScoreDesc(blArray);
            }
            this.setPieDiameter2();
            if (layoutScore.isAllOnesMask(blArray)) {
                this.layout(graphics2D, 1, true, blArray);
            } else {
                if (this.testAutoDiameter) {
                    System.out.println();
                    System.out.println("&&&&&&&&&& Duplicate or Zero &&&&&&&&&&");
                    System.out.println();
                }
                this.ScoreD.init();
                for (n = 0; n < this.SliceDesc.length; ++n) {
                    this.IEGlobal[n] = false;
                }
                this.layoutL(graphics2D);
            }
        } else if (!this.labelInteriorPct && !this.labelInteriorVal) {
            for (n = 0; n < 8; ++n) {
                if (this.testAutoDiameter) {
                    System.out.println();
                    System.out.println("j " + n);
                    System.out.println("================================================");
                }
                if (this.testAutoDiameter) {
                    System.out.println("YOffset " + this.YOffset);
                }
                this.setPieDiameter2();
                this.ScoreD.initSpaceNeeded();
                blArray = this.layout(graphics2D, 0, false, blArray);
                if (this.testAutoDiameter) {
                    System.out.print("First Score Descriptor - ");
                    this.ScoreD.dumpScoreDesc(blArray);
                }
                if (this.PieDiameter > 0) {
                    if (this.testAutoDiameter) {
                        System.out.print("Second Score Descriptor - ");
                        this.ScoreD.dumpScoreDesc(blArray);
                    }
                    if (this.testAutoDiameter) {
                        System.out.println("ScoreD[" + n + "] =  ( " + this.ScoreD.space_top_needed + " " + this.ScoreD.space_bottom_needed + " " + this.ScoreD.space_left_needed + " " + this.ScoreD.space_right_needed + ")");
                        System.out.println("YOffset " + this.YOffset + " PD " + this.PieDiameter);
                        System.out.println("min/max Y " + this.minY + " " + this.maxY);
                    }
                    if (this.ScoreD.enoughYSpace() && this.ScoreD.enoughXSpace() && !layoutScore.isZeroMask(blArray)) {
                        if (this.testAutoDiameter) {
                            System.out.println();
                            System.out.println("&&&&&&&&&& enoughYSpace &&&&&&&&&&");
                            System.out.println();
                        }
                        if (this.testAutoDiameter) {
                            System.out.print("Score Descriptor - ");
                            this.ScoreD.dumpScoreDesc(blArray);
                        }
                        this.setPieCenter();
                        this.layout(graphics2D, 1, true, blArray);
                        this.computeArc();
                        this.IEGlobal = blArray;
                        break;
                    }
                }
                if (layoutScore.isDuplicateMask(blArray) || layoutScore.isZeroMask(blArray) || this.PieDiameter < 0) {
                    if (this.testAutoDiameter) {
                        System.out.println();
                        System.out.println("&&&&&&&&&& Duplicate or Zero &&&&&&&&&&");
                        System.out.println();
                    }
                    this.ScoreD.init();
                    for (int i = 0; i < this.SliceDesc.length; ++i) {
                        this.IEGlobal[i] = false;
                    }
                    this.layoutL(graphics2D);
                    break;
                }
                ScoreDesc scoreDesc = new ScoreDesc();
                scoreDesc.setBottomSpaceAvailable(this.ScoreD.space_bottom_available);
                scoreDesc.setBottomSpaceNeeded(this.ScoreD.space_bottom_needed);
                scoreDesc.setTopSpaceAvailable(this.ScoreD.space_top_available);
                scoreDesc.setTopSpaceNeeded(this.ScoreD.space_top_needed);
                scoreDesc.setMask(blArray);
                layoutScore.LabelIntExt.addElement(scoreDesc);
                if (!this.testAutoDiameter) continue;
                scoreDesc.dumpScoreDesc();
            }
        }
        if (this.testAutoDiameter) {
            layoutScore.dumpScore();
        }
        if (this.DrawLegend && this.forceLegendApproach || this.DrawLegend && !this.labelInteriorPct && !this.labelInteriorVal || this.simpleApproach && (this.labelInteriorPct || this.labelInteriorVal) && n2 == 0) {
            this.L2.drawLegendBuffer(graphics2D, this.genImageMapCoords);
        }
    }

    private double percentToAngle(double d) {
        return d * 3.6;
    }

    private void setSliceRenderingHints(Graphics2D graphics2D) {
        if (this.isSetRenderingHintsChart()) {
            graphics2D.setRenderingHints(super.getRenderingHintsChart());
        } else {
            this.RHOriginal = graphics2D.getRenderingHints();
            RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderingHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            renderingHints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            graphics2D.setRenderingHints(renderingHints);
        }
    }

    private Shape getPolyShape(float f, float f2, float f3, float f4) {
        GeneralPath generalPath = new GeneralPath();
        Point2D.Double double_ = this.E3D.getVanishPoint();
        float f5 = -((float)((double)f - double_.x));
        float f6 = -((float)((double)f2 - double_.y));
        float f7 = -((float)((double)f3 - double_.x));
        float f8 = -((float)((double)f4 - double_.y));
        generalPath.moveTo((float)double_.x, (float)double_.y);
        generalPath.lineTo(f - f5, f2 - f6);
        generalPath.lineTo(f3 - f7, f4 - f8);
        generalPath.lineTo((float)double_.x, (float)double_.y);
        return generalPath;
    }

    private Shape getCircleConeShape(Effect3D effect3D) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)effect3D.startCircumXShadow, (float)effect3D.startCircumYShadow);
        generalPath.lineTo((float)effect3D.endCircumXShadow, (float)effect3D.endCircumYShadow);
        generalPath.lineTo((float)effect3D.endCircumX, (float)effect3D.endCircumY);
        generalPath.lineTo((float)effect3D.startCircumX, (float)effect3D.startCircumY);
        generalPath.lineTo((float)effect3D.startCircumXShadow, (float)effect3D.startCircumYShadow);
        return generalPath;
    }

    private Shape getTriangleShape(float f, float f2, float f3, float f4, float f5, float f6) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f3, f4);
        generalPath.lineTo(f5, f6);
        generalPath.lineTo(f, f2);
        return generalPath;
    }

    private Shape getNeedleArrow(float f, float f2, float f3, float f4) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f3, f4);
        generalPath.lineTo(f3 + 2.0f, f4);
        generalPath.lineTo(f + 2.0f, f2);
        generalPath.lineTo(f, f2);
        return generalPath;
    }

    private Shape getNeedleArrow2(float f, float f2, float f3, float f4) {
        GeneralPath generalPath = new GeneralPath();
        float f5 = 0.9f;
        float f6 = (float)(this.PieRadius * 0.01);
        float f7 = (float)(this.PieRadius * 0.02);
        float f8 = (float)(this.PieRadius * 0.05);
        double d = Math.toRadians(this.GaugeLevelDegreesPrivate + 90.0);
        float f9 = (float)Math.cos(d) * f6;
        float f10 = (float)(-Math.sin(d)) * f6;
        generalPath.moveTo(f + f9, f2 + f10);
        float f11 = (float)Math.cos(d) * f7;
        float f12 = (float)(-Math.sin(d)) * f7;
        float f13 = (float)Math.cos(d) * f8;
        float f14 = (float)(-Math.sin(d)) * f8;
        float f15 = f5 * (f3 - f);
        float f16 = f5 * (f4 - f2);
        generalPath.lineTo(f + f15 + f11, f2 + f16 + f12);
        generalPath.lineTo(f + f15 + f13, f2 + f16 + f14);
        generalPath.lineTo(f3, f4);
        generalPath.lineTo(f + f15 - f13, f2 + f16 - f14);
        generalPath.lineTo(f + f15 - f11, f2 + f16 - f12);
        generalPath.lineTo(f - f9, f2 - f10);
        generalPath.lineTo(f + f9, f2 + f10);
        return generalPath;
    }

    private Shape getNeedlePointer(int n, float f, float f2, float f3, float f4) {
        GeneralPath generalPath = new GeneralPath();
        float f5 = 0.15f;
        float f6 = 0.9f;
        float f7 = (float)(this.PieRadius * 0.06);
        float f8 = (float)(this.PieRadius * 0.037);
        float f9 = f5 * (f3 - f);
        float f10 = f5 * (f4 - f2);
        float f11 = f6 * (f3 - f);
        float f12 = f6 * (f4 - f2);
        double d = Math.toRadians(this.GaugeLevelDegreesPrivate + 90.0);
        float f13 = (float)Math.cos(d) * f7;
        float f14 = (float)(-Math.sin(d)) * f7;
        float f15 = (float)Math.cos(d) * f8;
        float f16 = (float)(-Math.sin(d)) * f8;
        switch (n) {
            case 0: {
                generalPath.moveTo(f, f2);
                generalPath.lineTo(f + f9 + f13, f2 + f10 + f14);
                generalPath.lineTo(f + f11 + f15, f2 + f12 + f16);
                generalPath.lineTo(f3, f4);
                generalPath.lineTo(f + f11 - f15, f2 + f12 - f16);
                generalPath.lineTo(f + f9 - f13, f2 + f10 - f14);
                generalPath.lineTo(f, f2);
                break;
            }
            case 1: {
                generalPath.moveTo(f, f2);
                generalPath.lineTo(f + f9, f2 + f10);
                generalPath.lineTo(f + f11, f2 + f12);
                generalPath.lineTo(f3, f4);
                generalPath.lineTo(f + f11 - f15, f2 + f12 - f16);
                generalPath.lineTo(f + f9 - f13, f2 + f10 - f14);
                generalPath.lineTo(f, f2);
            }
        }
        return generalPath;
    }

    private void drawGaugeNeedle(Graphics2D graphics2D) {
        Shape shape = this.getNeedlePointer(0, this.CenterX, this.CenterY, (float)this.GaugeNeedleX, (float)this.GaugeNeedleY);
        Area area = new Area(shape);
        graphics2D.setColor(this.GaugeNeedleColorPrivate);
        graphics2D.fill(area);
        Shape shape2 = this.getNeedlePointer(1, this.CenterX, this.CenterY, (float)this.GaugeNeedleX, (float)this.GaugeNeedleY);
        Area area2 = new Area(shape2);
        if (this.GaugeNeedleColorPrivate.equals(Color.black)) {
            graphics2D.setColor(new Color(60, 60, 60));
        } else {
            graphics2D.setColor(this.getDarkerColor(this.GaugeNeedleColorPrivate));
        }
        graphics2D.fill(area2);
    }

    private void drawSlices(Graphics2D graphics2D, int n) {
        Serializable serializable;
        this.CenterX = (float)this.XOffset + (float)this.CircumLabelWidthOffsetInt + (float)this.PieRadius;
        this.CenterY = (float)this.YOffset + (float)this.CircumLabelHeightOffsetInt + (float)this.PieRadius;
        boolean bl = false;
        boolean bl2 = false;
        double d = this.initialStartAngle;
        double d2 = 0.0;
        this.setSliceRenderingHints(graphics2D);
        this.Arc = new Arc2D[this.SliceDesc.length];
        Object var9_7 = null;
        Area area = null;
        Area area2 = null;
        Area area3 = null;
        Area area4 = null;
        Object var14_12 = null;
        Area area5 = null;
        Point2D.Double double_ = this.E3D.getShadowOffset();
        if (this.StyleDesc.getStyleType() != 0 && n != 0) {
            this.E3D.computeCircumference();
            this.E3D.computeShadowCircumference();
            double d3 = this.E3D.getShadowDiameter();
            double d4 = ((double)this.PieDiameter - d3) / 2.0;
            serializable = new Ellipse2D.Double((double)(this.XOffset + this.CircumLabelWidthOffsetInt) + double_.x + d4, (double)(this.YOffset + this.CircumLabelHeightOffsetInt) + double_.y + d4, d3, d3);
            Ellipse2D.Double double_2 = new Ellipse2D.Double(this.XOffset + this.CircumLabelWidthOffsetInt, this.YOffset + this.CircumLabelHeightOffsetInt, this.PieDiameter, this.PieDiameter);
            area3 = new Area((Shape)((Object)serializable));
            area4 = new Area((Shape)((Object)serializable));
            area2 = new Area(double_2);
            Shape shape = this.getCircleConeShape(this.E3D);
            area5 = new Area(shape);
            area4.add(area5);
            area2.exclusiveOr(area4);
            area2.intersect(area4);
        }
        serializable = Color.gray;
        if (this.PieSubType == 1) {
            this.drawGaugeBackground2(graphics2D, false);
        }
        for (int i = 0; i < this.SliceDesc.length; ++i) {
            this.SliceAngle[i].deltaAngle = d2 = this.percentToAngle(this.SliceDesc[i].getValue());
            this.SliceAngle[i].startAngle = !this.clockwise ? d : 360.0 + d - d2;
            int n2 = (this.XOffset + this.CircumLabelWidthOffsetInt) / 2;
            int n3 = (this.YOffset + this.CircumLabelHeightOffsetInt) / 2;
            if (n != 0) {
                this.Arc[i] = new Arc2D.Double(2);
                this.Arc[i].setFrame(this.XOffset + this.CircumLabelWidthOffsetInt, this.YOffset + this.CircumLabelHeightOffsetInt, this.PieDiameter, this.PieDiameter);
                this.Arc[i].setAngleStart(this.SliceAngle[i].startAngle);
                this.Arc[i].setAngleExtent(d2);
                serializable = this.SliceDesc[i].getBackground();
                if (this.HilightIndex == i) {
                    graphics2D.setColor(this.HilightColor);
                    serializable = this.HilightColor;
                    if (this.DrawLegend) {
                        this.L2.setLegendItemColor(this.SliceDesc[i].getLabel(), this.HilightColor);
                    }
                }
                if (this.StyleDesc.getStyleType() == 2) {
                    Rectangle2D rectangle2D = new Rectangle2D.Double();
                    rectangle2D = this.Arc[i].getBounds2D();
                    double d5 = this.getNormalizedAngle(this.SliceAngle[i].startAngle);
                    double d6 = this.getNormalizedAngle(this.SliceAngle[i].startAngle + d2);
                    double d7 = this.getNormalizedAngle(this.SliceAngle[i].startAngle + d2 / 2.0);
                    if (this.E3D.oneSliceShadow(d5, d6, d2)) {
                        Color color = this.getDarkerColor((Color)serializable);
                        graphics2D.setColor(color);
                        graphics2D.fill(area2);
                        graphics2D.setColor(color);
                        graphics2D.draw(area2);
                    } else if (this.E3D.inShadow(d5) || this.E3D.inShadow(d6) || this.E3D.inShadow(d7)) {
                        Object object;
                        Shape shape;
                        double d8 = this.SliceAngle[i].startCircumX;
                        double d9 = this.SliceAngle[i].startCircumY;
                        double d10 = this.SliceAngle[i].endCircumX;
                        double d11 = this.SliceAngle[i].endCircumY;
                        if (this.E3D.inInOutShadow(d5, d6, d7)) {
                            shape = this.getPolyShape((float)d8, (float)d9, (float)this.E3D.endCircumX, (float)this.E3D.endCircumY);
                            object = this.getPolyShape((float)d10, (float)d11, (float)this.E3D.startCircumX, (float)this.E3D.startCircumY);
                            Color color = this.getDarkerColor((Color)serializable);
                            area = new Area(shape);
                            area.intersect(area2);
                            graphics2D.setColor(color);
                            graphics2D.fill(area);
                            graphics2D.setColor(color);
                            graphics2D.draw(area);
                            area = new Area((Shape)object);
                            area.intersect(area2);
                            graphics2D.setColor(color);
                            graphics2D.fill(area);
                            graphics2D.setColor(color);
                            graphics2D.draw(area);
                        } else {
                            if (this.E3D.inOutShadow(d5, d6)) {
                                d10 = this.E3D.endCircumX;
                                d11 = this.E3D.endCircumY;
                            }
                            if (this.E3D.outInShadow(d5, d6)) {
                                d8 = this.E3D.startCircumX;
                                d9 = this.E3D.startCircumY;
                            }
                            shape = this.getPolyShape((float)d8, (float)d9, (float)d10, (float)d11);
                            area = new Area(shape);
                            area.intersect(area2);
                            object = this.getDarkerColor((Color)serializable);
                            graphics2D.setColor((Color)object);
                            graphics2D.fill(area);
                            graphics2D.setColor((Color)object);
                            graphics2D.draw(area);
                        }
                    }
                }
                graphics2D.setColor((Color)serializable);
                boolean bl3 = true;
                if (this.PieSubType == 1 && bl3) {
                    this.drawRings(graphics2D, i, (Color)serializable);
                } else {
                    graphics2D.setColor((Color)serializable);
                    graphics2D.fill(this.Arc[i]);
                }
                if (this.StyleDesc.getStyleType() != 0 || this.PieSubType == 1) {
                    graphics2D.setColor(this.getDarkerColor((Color)serializable));
                } else {
                    graphics2D.setColor(this.getForeground());
                }
                if (this.PieSubType != 1) {
                    graphics2D.draw(this.Arc[i]);
                }
            }
            if (this.clockwise) {
                d -= this.percentToAngle(this.SliceDesc[i].getValue());
                continue;
            }
            d += this.percentToAngle(this.SliceDesc[i].getValue());
        }
        if (this.SliceDesc.length == 1 && d2 >= 360.0) {
            serializable = this.SliceDesc[0].getBackground();
            if (this.HilightIndex == 0) {
                serializable = this.HilightColor;
                if (this.DrawLegend) {
                    this.L2.setLegendItemColor(this.SliceDesc[0].getLabel(), this.HilightColor);
                }
            }
            Color color = this.getDarkerColor((Color)serializable);
            if (this.StyleDesc.getStyleType() != 0 && n != 0) {
                graphics2D.setColor(color);
                graphics2D.fill(area2);
                graphics2D.setColor(color);
                graphics2D.draw(area2);
            }
            Ellipse2D.Double double_3 = new Ellipse2D.Double(this.XOffset + this.CircumLabelWidthOffsetInt, this.YOffset + this.CircumLabelHeightOffsetInt, this.PieDiameter, this.PieDiameter);
            graphics2D.setColor((Color)serializable);
            graphics2D.fill(double_3);
            if (this.StyleDesc.getStyleType() != 0 || this.PieSubType == 1) {
                graphics2D.setColor(color);
            } else {
                graphics2D.setColor(this.getForeground());
            }
            graphics2D.draw(double_3);
        }
        if (n != 0 && this.PieSubType == 1) {
            this.drawAllGaugeTicks(graphics2D);
            this.drawGaugeMinorTicks(graphics2D);
            this.computeGaugeNeedle();
            this.drawGaugeNeedle(graphics2D);
            this.drawRingOutline(graphics2D);
        }
        if (!this.isSetRenderingHintsChart()) {
            graphics2D.setRenderingHints(this.RHOriginal);
        }
    }

    private void drawGaugeMinorTicks(Graphics2D graphics2D) {
        double d;
        double d2 = Math.toRadians(this.initialStartAngle);
        double d3 = Math.toRadians(this.initialStartAngle + this.GaugeSpanPrivate);
        graphics2D.setStroke(this.MajorTickStroke);
        if (this.DrawFirstAndLastMajorTicks) {
            d = 1.0;
            this.drawSingleGaugeTick(graphics2D, d2, this.MajorTickLength, this.GaugeStyleDesc.getTickColor(), d);
            this.drawSingleGaugeTick(graphics2D, d3, this.MajorTickLength, this.GaugeStyleDesc.getTickColor(), d);
        }
        graphics2D.setStroke(this.getPieStroke());
        this.NumMinorTicks = 20 / this.SliceDesc.length * this.SliceDesc.length;
        for (int i = 1; i < this.NumMinorTicks; ++i) {
            d = d2 + (d3 - d2) * ((double)i / (double)this.NumMinorTicks);
            this.drawSingleGaugeTick(graphics2D, d, this.MinorTickLength, this.GaugeStyleDesc.getTickColor(), 0.5);
        }
    }

    private void drawSingleGaugeTick(Graphics2D graphics2D, double d, int n, Color color, double d2) {
        double d3 = Math.cos(d) * (this.PieRadius - (double)n) + (double)this.CenterX;
        double d4 = -Math.sin(d) * (this.PieRadius - (double)n) + (double)this.CenterY;
        double d5 = Math.cos(d) * (this.PieRadius - d2) + (double)this.CenterX;
        double d6 = -Math.sin(d) * (this.PieRadius - d2) + (double)this.CenterY;
        graphics2D.setColor(this.GaugeStyleDesc.getTickColor());
        graphics2D.drawLine((int)Math.round(d3), (int)Math.round(d4), (int)Math.round(d5), (int)Math.round(d6));
    }

    private void drawAllGaugeTicks(Graphics2D graphics2D) {
        int n;
        double d = Math.toRadians(this.initialStartAngle + this.GaugeSpanPrivate);
        int n2 = (int)Math.round(Math.cos(d) * this.InnerTickPos + (double)this.CenterX);
        int n3 = (int)Math.round(-Math.sin(d) * this.InnerTickPos + (double)this.CenterY);
        int n4 = (int)Math.round(Math.cos(d) * (this.InnerTickPos - (double)this.InnerTickLength) + (double)this.CenterX);
        int n5 = (int)Math.round(-Math.sin(d) * (this.InnerTickPos - (double)this.InnerTickLength) + (double)this.CenterY);
        graphics2D.setColor(this.GaugeStyleDesc.getTickInnerColor());
        graphics2D.drawLine(n2, n3, n4, n5);
        graphics2D.setStroke(this.getPieStroke());
        for (n = 0; n < this.SliceDesc.length; ++n) {
            this.drawGaugeSliceInnerTick(graphics2D, n);
        }
        graphics2D.setStroke(this.MajorTickStroke);
        for (n = 1; n < this.SliceDesc.length; ++n) {
            this.drawGaugeSliceMajorTick(graphics2D, n);
        }
    }

    private void drawGaugeSliceInnerTick(Graphics2D graphics2D, int n) {
        graphics2D.setColor(this.GaugeStyleDesc.getTickInnerColor());
        graphics2D.drawLine((int)Math.round(this.SliceAngle[n].startCircumXInnerTick), (int)Math.round(this.SliceAngle[n].startCircumYInnerTick), (int)Math.round(this.SliceAngle[n].startCircumXInnerTick2), (int)Math.round(this.SliceAngle[n].startCircumYInnerTick2));
    }

    private void drawGaugeSliceMajorTick(Graphics2D graphics2D, int n) {
        int n2 = (int)Math.round(this.SliceAngle[n].startCircumXTick);
        int n3 = (int)Math.round(this.SliceAngle[n].startCircumYTick);
        int n4 = (int)Math.round(this.SliceAngle[n].startCircumX);
        int n5 = (int)Math.round(this.SliceAngle[n].startCircumY);
        graphics2D.setColor(this.GaugeStyleDesc.getTickColor());
        graphics2D.drawLine(n2, n3, n4, n5);
    }

    private void drawGaugeBackground(Graphics2D graphics2D) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(this.XOffset + this.CircumLabelWidthOffsetInt, this.YOffset + this.CircumLabelHeightOffsetInt, this.PieDiameter, this.PieDiameter);
        RoundGradientPaint roundGradientPaint = new RoundGradientPaint((double)(this.XOffset + this.CircumLabelWidthOffsetInt) + this.PieRadius, (double)(this.YOffset + this.CircumLabelHeightOffsetInt) + this.PieRadius, new Color(255, 0, 0, 128), 0.0, this.PieRadius, new Color(0, 0, 255, 128));
        graphics2D.setPaint(roundGradientPaint);
        graphics2D.fill(double_);
    }

    private void drawGaugeBackground2(Graphics2D graphics2D, boolean bl) {
        this.E3D.computeCircumference();
        this.E3D.computeShadowCircumference();
        Point2D.Double double_ = this.E3D.getShadowOffset();
        double d = Math.pow(this.PieDiameter, 0.3) * 0.04;
        Ellipse2D.Double double_2 = new Ellipse2D.Double((double)(this.XOffset + this.CircumLabelWidthOffsetInt) + double_.x * d, (double)(this.YOffset + this.CircumLabelHeightOffsetInt) + double_.y * d, this.PieDiameter, this.PieDiameter);
        double d2 = 0.66;
        Ellipse2D.Double double_3 = new Ellipse2D.Double((double)(this.XOffset + this.CircumLabelWidthOffsetInt) - d2 * double_.x, (double)(this.YOffset + this.CircumLabelHeightOffsetInt) - d2 * double_.y, this.PieDiameter, this.PieDiameter);
        Ellipse2D.Double double_4 = new Ellipse2D.Double(this.XOffset + this.CircumLabelWidthOffsetInt, this.YOffset + this.CircumLabelHeightOffsetInt, this.PieDiameter, this.PieDiameter);
        Area area = new Area(double_3);
        Area area2 = new Area(double_2);
        Area area3 = new Area(double_4);
        Rectangle2D.Double double_5 = new Rectangle2D.Double();
        int n = this.PieDiameter / 3;
        int n2 = n / 2;
        double_5.setFrame(this.XOffset + this.CircumLabelWidthOffsetInt - n2, this.YOffset + this.CircumLabelHeightOffsetInt - n2, this.PieDiameter + n, this.PieDiameter + n);
        double d3 = Math.toRadians(this.initialStartAngle);
        Arc2D.Double double_6 = new Arc2D.Double(double_5, this.initialStartAngle, this.GaugeSpanPrivate, 2);
        Area area4 = new Area(double_6);
        area3.exclusiveOr(area2);
        area3.intersect(area2);
        area3.intersect(area4);
        int n3 = 180;
        int n4 = 200;
        graphics2D.setColor(new Color(n3, n3, n3, n4));
        graphics2D.fill(area3);
        area3 = new Area(double_4);
        area.exclusiveOr(area3);
        area.intersect(area3);
        area.intersect(area4);
        n3 = 150;
        n4 = 100;
        graphics2D.setColor(new Color(n3, n3, n3, n4));
        graphics2D.fill(area);
    }

    private Shape getInnerRingShape() {
        double d = this.PieRadius * this.GaugeStyleDesc.getRingWidth();
        Ellipse2D.Double double_ = new Ellipse2D.Double((double)this.XOffset + d + (double)this.CircumLabelWidthOffsetInt, (double)this.YOffset + d + (double)this.CircumLabelHeightOffsetInt, (double)this.PieDiameter - 2.0 * d, (double)this.PieDiameter - 2.0 * d);
        return double_;
    }

    private void drawRings(Graphics2D graphics2D, int n, Color color) {
        Shape shape = this.getTriangleShape(this.CenterX, this.CenterY, (float)this.SliceAngle[n].startCircumXExtra, (float)this.SliceAngle[n].startCircumYExtra, (float)this.SliceAngle[n].endCircumXExtra, (float)this.SliceAngle[n].endCircumYExtra);
        Ellipse2D.Double double_ = new Ellipse2D.Double(this.XOffset + this.CircumLabelWidthOffsetInt, this.YOffset + this.CircumLabelHeightOffsetInt, this.PieDiameter, this.PieDiameter);
        Area area = new Area(double_);
        Shape shape2 = this.getInnerRingShape();
        Area area2 = new Area(shape2);
        Area area3 = new Area(shape);
        area.exclusiveOr(area2);
        area3.intersect(area);
        graphics2D.setColor(color);
        graphics2D.fill(area3);
    }

    private void drawRingOutline(Graphics2D graphics2D) {
        for (int i = 0; i < this.SliceDesc.length; ++i) {
            Color color = this.SliceDesc[0].getBackground();
            Shape shape = this.getTriangleShape(this.CenterX, this.CenterY, (float)this.SliceAngle[i].startCircumXExtra, (float)this.SliceAngle[i].startCircumYExtra, (float)this.SliceAngle[i].endCircumXExtra, (float)this.SliceAngle[i].endCircumYExtra);
            int n = 3;
            int n2 = n / 2;
            Ellipse2D.Double double_ = new Ellipse2D.Double(this.XOffset + n2 + this.CircumLabelWidthOffsetInt, this.YOffset + n2 + this.CircumLabelHeightOffsetInt, this.PieDiameter - n, this.PieDiameter - n);
            Area area = new Area(double_);
            Area area2 = new Area(shape);
            Ellipse2D.Double double_2 = new Ellipse2D.Double(this.XOffset + this.CircumLabelWidthOffsetInt, this.YOffset + this.CircumLabelHeightOffsetInt, this.PieDiameter, this.PieDiameter);
            Area area3 = new Area(double_2);
            area3.exclusiveOr(area);
            area2.intersect(area3);
            graphics2D.setColor(this.getDarkerColor(color));
            graphics2D.fill(area2);
        }
    }

    private void copyImageMapSlice(int n, double[] dArray, double[] dArray2) {
        this.ImageMapCoords[n] = new int[dArray.length + dArray2.length];
        this.ImageMapShape = 2;
        for (int i = 0; i < dArray.length; ++i) {
            this.ImageMapCoords[n][i * 2] = (int)Math.round(dArray[i]);
            this.ImageMapCoords[n][i * 2 + 1] = (int)Math.round(dArray2[i]);
        }
    }

    private void copyImageMapSingleSlice(int n, int n2, int n3, int n4) {
        this.ImageMapShape = 1;
        this.ImageMapCoords[n] = new int[3];
        this.ImageMapCoords[n][0] = n2;
        this.ImageMapCoords[n][1] = n3;
        this.ImageMapCoords[n][2] = n4;
    }

    public void setEnableImageMapArea() throws ChartException {
        this.genImageMapCoords = true;
        if (this.SliceDesc != null) {
            this.ImageMapCoords = new int[this.SliceDesc.length][0];
        }
    }

    public ImageMapAreaDesc getImageMapAreaDesc() {
        ImageMapAreaDesc imageMapAreaDesc = new ImageMapAreaDesc();
        imageMapAreaDesc.setCoords(this.ImageMapCoords);
        imageMapAreaDesc.setShape(this.ImageMapShape);
        return imageMapAreaDesc;
    }

    private void computeArc() {
        double d = this.initialStartAngle;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        d3 = (double)this.XOffset + (double)this.CircumLabelWidthOffsetInt + this.PieRadius;
        d4 = (double)this.YOffset + (double)this.CircumLabelHeightOffsetInt + this.PieRadius;
        Point2D.Double double_ = this.E3D.getShadowOffset();
        this.Arc = new Arc2D[this.SliceDesc.length];
        for (int i = 0; i < this.SliceDesc.length; ++i) {
            this.SliceAngle[i].deltaAngle = d2 = this.percentToAngle(this.SliceDesc[i].getValue());
            this.SliceAngle[i].startAngle = !this.clockwise ? d : 360.0 + d - d2;
            this.Arc[i] = new Arc2D.Double(2);
            this.Arc[i].setFrame(this.XOffset + this.CircumLabelWidthOffsetInt, this.YOffset + this.CircumLabelHeightOffsetInt, this.PieDiameter, this.PieDiameter);
            this.Arc[i].setAngleStart(this.SliceAngle[i].startAngle);
            this.Arc[i].setAngleExtent(d2);
            if (this.SliceDesc.length == 1) {
                if (this.genImageMapCoords && this.genImageMapCoords) {
                    this.copyImageMapSingleSlice(i, (int)d3, (int)d4, (int)this.PieRadius);
                }
            } else {
                double d5;
                double d6 = 0.0;
                double d7 = 0.0;
                double d8 = 0.0;
                double d9 = 0.0;
                double d10 = Math.toRadians(this.SliceAngle[i].startAngle);
                double d11 = Math.toRadians(this.SliceAngle[i].startAngle + d2);
                double d12 = Math.toRadians(this.SliceAngle[i].startAngle + d2 / 2.0);
                d6 = Math.cos(d10) * this.PieRadius + d3;
                d7 = -Math.sin(d10) * this.PieRadius + d4;
                d8 = Math.cos(d11) * this.PieRadius + d3;
                d9 = -Math.sin(d11) * this.PieRadius + d4;
                if (this.genImageMapCoords) {
                    d5 = 720.0 / this.PieRadius;
                    int n = (int)Math.round(d2 / d5);
                    double[] dArray = new double[n + 3];
                    double[] dArray2 = new double[n + 3];
                    for (int j = 0; j < n; ++j) {
                        double d13 = Math.toRadians(this.SliceAngle[i].startAngle + (double)j * d5);
                        dArray[j + 1] = Math.cos(d13) * this.PieRadius + d3;
                        dArray2[j + 1] = -Math.sin(d13) * this.PieRadius + d4;
                    }
                    dArray[0] = d3;
                    dArray2[0] = d4;
                    dArray[n + 1] = Math.cos(d11) * this.PieRadius + d3;
                    dArray2[n + 1] = -Math.sin(d11) * this.PieRadius + d4;
                    dArray[n + 2] = d3;
                    dArray2[n + 2] = d4;
                    if (this.genImageMapCoords) {
                        this.copyImageMapSlice(i, dArray, dArray2);
                    }
                }
                d5 = 1.5;
                this.SliceAngle[i].startCircumX = Math.cos(d10) * (this.PieRadius - d5) + d3;
                this.SliceAngle[i].startCircumY = -Math.sin(d10) * (this.PieRadius - d5) + d4;
                this.SliceAngle[i].startCircumXTick = Math.cos(d10) * (this.PieRadius - (double)this.MajorTickLength) + d3;
                this.SliceAngle[i].startCircumYTick = -Math.sin(d10) * (this.PieRadius - (double)this.MajorTickLength) + d4;
                this.SliceAngle[i].startCircumXInnerTick = Math.cos(d10) * this.InnerTickPos + d3;
                this.SliceAngle[i].startCircumYInnerTick = -Math.sin(d10) * this.InnerTickPos + d4;
                this.SliceAngle[i].startCircumXInnerTick2 = Math.cos(d10) * (this.InnerTickPos - (double)this.InnerTickLength) + d3;
                this.SliceAngle[i].startCircumYInnerTick2 = -Math.sin(d10) * (this.InnerTickPos - (double)this.InnerTickLength) + d4;
                this.SliceAngle[i].startCircumXExtra = Math.cos(d10) * 2.0 * this.PieRadius + d3;
                this.SliceAngle[i].startCircumYExtra = -Math.sin(d10) * 2.0 * this.PieRadius + d4;
                this.SliceAngle[i].endCircumX = Math.cos(d11) * this.PieRadius + d3;
                this.SliceAngle[i].endCircumY = -Math.sin(d11) * this.PieRadius + d4;
                this.SliceAngle[i].endCircumXExtra = Math.cos(d11) * 2.0 * this.PieRadius + d3;
                this.SliceAngle[i].endCircumYExtra = -Math.sin(d11) * 2.0 * this.PieRadius + d4;
                this.SliceAngle[i].midCircumShadowX = Math.cos(d12) * this.PieRadius + d3 + double_.x;
                this.SliceAngle[i].midCircumShadowY = -Math.sin(d12) * this.PieRadius + d4 + double_.y;
            }
            if (this.clockwise) {
                d -= this.percentToAngle(this.SliceDesc[i].getValue());
                continue;
            }
            d += this.percentToAngle(this.SliceDesc[i].getValue());
        }
    }

    private void redrawEmptySlices(Graphics2D graphics2D, int n) {
        this.setSliceRenderingHints(graphics2D);
        if (n == 1) {
            for (int i = 0; i < this.SliceDesc.length; ++i) {
                if (this.interiorLabel[i]) continue;
                Color color = this.SliceDesc[i].getBackground();
                graphics2D.setStroke(this.getPieStroke());
                if (this.HilightIndex == i) {
                    graphics2D.setColor(this.HilightColor);
                    if (this.DrawLegend) {
                        this.L2.setLegendItemColor(this.SliceDesc[i].getLabel(), this.HilightColor);
                    }
                } else {
                    graphics2D.setColor(color);
                }
                float f = (float)this.XOffset + (float)this.CircumLabelWidthOffsetInt + (float)this.PieRadius;
                float f2 = (float)this.YOffset + (float)this.CircumLabelHeightOffsetInt + (float)this.PieRadius;
                int n2 = (int)Math.round((this.SliceAngle[i].startCircumX + this.SliceAngle[i].endCircumX) / 2.0 + (double)f);
                int n3 = (int)Math.round((this.SliceAngle[i].startCircumY + this.SliceAngle[i].endCircumY) / 2.0 + (double)f2);
                GradientPaint gradientPaint = new GradientPaint(f, f2, Color.white, n2, n2, color);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fill(this.Arc[i]);
                if (this.StyleDesc.getStyleType() != 0 || this.PieSubType == 1) {
                    graphics2D.setColor(this.getDarkerColor(color));
                } else {
                    graphics2D.setColor(this.getForeground());
                }
                graphics2D.draw(this.Arc[i]);
            }
        }
        if (!this.isSetRenderingHintsChart()) {
            graphics2D.setRenderingHints(this.RHOriginal);
        }
    }

    private void redrawLabeledSlices(Graphics2D graphics2D, int n) {
        this.setSliceRenderingHints(graphics2D);
        if (n == 1) {
            for (int i = 0; i < this.SliceDesc.length; ++i) {
                if (!this.interiorLabel[i]) continue;
                graphics2D.setStroke(this.getPieStroke());
                if (this.HilightIndex == i) {
                    graphics2D.setColor(this.HilightColor);
                    if (this.DrawLegend) {
                        this.L2.setLegendItemColor(this.SliceDesc[i].getLabel(), this.HilightColor);
                    }
                } else {
                    graphics2D.setColor(this.SliceDesc[i].getBackground());
                }
                graphics2D.fill(this.Arc[i]);
                graphics2D.setColor(this.getForeground());
                graphics2D.draw(this.Arc[i]);
            }
        }
        double d = this.percentToAngle(this.SliceDesc[0].getValue());
        if (this.SliceDesc.length == 1 && d >= 360.0) {
            if (this.HilightIndex == 0) {
                graphics2D.setColor(this.HilightColor);
                if (this.DrawLegend) {
                    this.L2.setLegendItemColor(this.SliceDesc[0].getLabel(), this.HilightColor);
                }
            } else {
                graphics2D.setColor(this.SliceDesc[0].getBackground());
            }
            Ellipse2D.Double double_ = new Ellipse2D.Double(this.XOffset + this.CircumLabelWidthOffsetInt, this.YOffset + this.CircumLabelHeightOffsetInt, this.PieDiameter, this.PieDiameter);
            graphics2D.fill(double_);
            graphics2D.setColor(this.getForeground());
            graphics2D.draw(double_);
        }
        if (!this.isSetRenderingHintsChart()) {
            graphics2D.setRenderingHints(this.RHOriginal);
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 > 0 || n4 > 0) {
            this.setSize(n3, n4);
        }
        super.setBounds(n, n2, n3, n4);
    }

    public void setBounds(Rectangle rectangle) {
        if (rectangle.width > 0 || rectangle.height > 0) {
            this.setSize(rectangle.width, rectangle.height);
        }
        super.setBounds(rectangle);
    }

    public void setSize(Dimension dimension) {
        if (dimension.width > 0 || dimension.height > 0) {
            this.setSize(dimension.height, dimension.width);
        }
    }

    public void setSize(int n, int n2) {
        if (n <= 0 && n2 <= 0) {
            return;
        }
        this.SizeChanged = true;
        if (n == 0) {
            this.setHeightInternal(n2);
        } else if (n2 == 0) {
            this.setWidthInternal(n);
        } else {
            super.setSizeInternal(n, n2);
        }
        this.displayHeight = super.getHeight();
        this.displayWidth = super.getWidth();
        this.setPieDiameter2();
    }

    private void drawBackground(Graphics2D graphics2D) {
        if (this.drawBackgroundRect) {
            graphics2D.setColor(super.getBackground());
            graphics2D.fillRect(0, 0, this.displayWidth, this.displayHeight);
            graphics2D.setColor(this.getEdgeColor());
            graphics2D.drawRect(0, 0, this.displayWidth - 1, this.displayHeight - 1);
        }
        super.getTitle().drawBuffer(graphics2D);
        super.getSubtitle().drawBuffer(graphics2D);
        super.getFootnote().drawBuffer(graphics2D);
    }

    private void addLegend() {
        this.L2.clearLegend();
        this.L2.resetLegendReduce();
        if (this.disableLegend) {
            return;
        }
        for (int i = 0; i < this.SliceDesc.length; ++i) {
            int n = this.PieSubType == 1 ? this.SliceDesc.length - i - 1 : i;
            String string = this.SliceDesc[n].getLabel();
            String string2 = null;
            this.L2.setAddLegendItem(string, this.SliceDesc[n].getBackground());
            this.L2.setUpdateLegendItemXLink(string, string2);
        }
        if (!this.disableLegend) {
            this.DrawLegend = true;
        }
        this.L2.setLegendColumns(1);
        this.L2.getLegendHeight();
        this.L2.getLegendWidth();
        Dimension dimension = this.L2.getLegendSize();
        boolean bl = this.setPieDiameterLegend(dimension.width, dimension.height);
        if (!bl) {
            this.setPieDiameter2();
            this.DrawLegend = false;
        }
    }

    private void layoutL(Graphics2D graphics2D) {
        this.addLegend();
        this.drawBackground(graphics2D);
        this.computeArc();
        this.drawSlices(graphics2D, 1);
        if (this.HilightLabelIndex > -1) {
            this.hilightLegendText(graphics2D);
        }
    }

    private boolean[] layout(Graphics2D graphics2D, int n, boolean bl, boolean[] blArray) throws ChartException {
        this.initMinMax();
        this.computeArc();
        if (n != 0) {
            this.drawBackground(graphics2D);
        }
        this.drawSlices(graphics2D, n);
        boolean bl2 = false;
        for (int i = 0; i < this.SliceDesc.length; ++i) {
            Vector vector = null;
            boolean bl3 = false;
            PieLayout pieLayout = new PieLayout();
            String string = this.SliceDesc[i].getLabel();
            this.interiorLabel[i] = false;
            if (!bl) {
                blArray[i] = false;
            }
            int n2 = this.fontmet.getAscent();
            int n3 = string != null ? this.fontmet.stringWidth(string) : 0;
            double d = (double)n2 / this.PieRadius;
            double d2 = (double)n3 / this.PieRadius;
            int n4 = this.fontmet.getMaxAscent();
            boolean bl4 = false;
            boolean bl5 = this.containsDelimiters(this.SliceDesc[i]);
            boolean bl6 = this.containsSeparateLineDelimiters(this.SliceDesc[i]);
            if ((!bl5 || !this.lastWordNewline && !bl6) && (!bl || bl && blArray[i])) {
                bl4 = string == null || string == "" ? true : this.deriveRect(graphics2D, pieLayout, this.SliceAngle[i].startAngle, this.SliceAngle[i].deltaAngle, d2, d, null);
                if (bl4) {
                    bl3 = false;
                    if (n == 1) {
                        this.drawLabelInSlice(graphics2D, pieLayout, bl3, string, null, i);
                    }
                    this.interiorLabel[i] = true;
                    if (!bl) {
                        blArray[i] = true;
                    }
                }
            } else {
                bl4 = false;
                this.interiorLabel[i] = false;
                if (!bl) {
                    blArray[i] = false;
                }
            }
            if (!bl4 && (!bl || bl && blArray[i])) {
                SliceLabelBreak sliceLabelBreak = new SliceLabelBreak(string);
                if (this.lastWordNewline) {
                    sliceLabelBreak.setLastWordNewline();
                }
                if (this.userDefinedDelimiters) {
                    sliceLabelBreak.setDelimiters(this.userDelimiters);
                }
                sliceLabelBreak.init(new String(this.SeparateLineCharsC));
                int n5 = sliceLabelBreak.getNumDelimiters();
                for (int j = 0; j < n5; ++j) {
                    String string2 = "";
                    vector = sliceLabelBreak.getLabel(j);
                    if (vector == null) continue;
                    boolean bl7 = false;
                    for (int k = 0; k < vector.size(); ++k) {
                        String string3 = (String)vector.elementAt(k);
                        if (string3.length() <= string2.length()) continue;
                        string2 = string3;
                    }
                    n2 = this.fontmet.getAscent() * vector.size();
                    d = (double)n2 / this.PieRadius;
                    n3 = this.fontmet.stringWidth(string2);
                    d2 = (double)n3 / this.PieRadius;
                    bl4 = string == null || string == "" ? true : this.deriveRect(graphics2D, pieLayout, this.SliceAngle[i].startAngle, this.SliceAngle[i].deltaAngle, d2, d, vector);
                    if (bl4) {
                        if (!bl) {
                            blArray[i] = true;
                        }
                        bl3 = true;
                        if (n == 1) {
                            this.drawLabelInSlice(graphics2D, pieLayout, bl3, string2, vector, i);
                        }
                        this.interiorLabel[i] = true;
                    } else {
                        this.interiorLabel[i] = false;
                    }
                    if (bl4) break;
                }
            }
            this.SliceStoredLayout[i].isMulti = bl3;
            this.SliceStoredLayout[i].interiorLabel = this.interiorLabel[i];
            this.SliceStoredLayout[i].label = string;
            this.SliceStoredLayout[i].pl = pieLayout;
            this.SliceStoredLayout[i].SliceLabelLines = vector;
        }
        this.exLayout = new ExLabelLayout();
        this.exLayout.init();
        boolean bl8 = false;
        if (n == 1) {
            bl8 = true;
        }
        this.exLayout.draw(graphics2D, 0, bl8);
        this.exLayout.draw(graphics2D, 1, bl8);
        return blArray;
    }

    double getNormalizedFactor(double d, boolean bl) {
        this.NormalizationFactor = this.getMaxXYNormalized();
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.NormalizationFactor >= 1.0 && this.NormalizationFactor < 2.0) {
            d2 = 2.0 - this.NormalizationFactor;
            double d4 = this.PieRadiusCircumL;
            this.PieRadius = this.PieRadiusCircumL * d2;
            this.PieDiameter = (int)(this.PieRadius * 2.0);
            d3 = d / this.PieRadius;
            int n = (int)(d4 - this.PieRadius);
            this.XOffset += n;
            this.YOffset += n;
        }
        return d3;
    }

    private boolean layoutCircumferenceAllFit(Graphics2D graphics2D) throws ChartException {
        int n;
        this.initMinMax();
        this.initCircumference();
        this.initCircumference2();
        PieLayout pieLayout = null;
        Object var3_3 = null;
        this.drawSlices(graphics2D, 0);
        int n2 = this.fontmet.getAscent();
        double d = (double)n2 / this.PieRadius;
        boolean bl = true;
        String string = "";
        for (n = 0; n < this.SliceDesc.length; ++n) {
            pieLayout = new PieLayout();
            boolean bl2 = false;
            string = this.SliceSecondLabel[n];
            if (string == null || string == "") {
                bl2 = true;
            } else {
                int n3 = this.fontmet.stringWidth(string);
                double d2 = (double)n3 / this.PieRadius;
                bl2 = string == null || string == "" ? true : this.deriveRect(graphics2D, pieLayout, this.SliceAngle[n].startAngle, this.SliceAngle[n].deltaAngle, d2, d, null);
            }
            if (!bl2) {
                bl = false;
                break;
            }
            if (bl2) {
                this.interiorLabel[n] = true;
            }
            this.SliceStoredLayout[n].isMulti = false;
            this.SliceStoredLayout[n].interiorLabel = this.interiorLabel[n];
            this.SliceStoredLayout[n].label = string;
            this.SliceStoredLayout[n].pl = pieLayout;
            this.SliceStoredLayout[n].SliceLabelLines = var3_3;
        }
        if (bl) {
            this.drawBackground(graphics2D);
            this.computeArc();
            this.drawSlices(graphics2D, 1);
            for (n = 0; n < this.SliceDesc.length; ++n) {
                this.drawLabelInSlice(graphics2D, this.SliceStoredLayout[n].pl, false, this.SliceStoredLayout[n].label, null, n);
            }
            return true;
        }
        this.PieRadiusCircumL = this.PieRadius;
        return false;
    }

    private void layoutCircumference(Graphics2D graphics2D) throws ChartException {
        boolean bl;
        double d;
        int n;
        int n2;
        PieLayout pieLayout = null;
        Object var3_3 = null;
        int n3 = this.fontmet.getAscent();
        double d2 = (double)n3 / this.PieRadius;
        String string = "";
        for (n2 = 0; n2 < this.SliceDesc.length; ++n2) {
            pieLayout = new PieLayout();
            this.interiorLabel[n2] = false;
            string = this.SliceSecondLabel[n2];
            n = this.fontmet.stringWidth(string);
            d = (double)n / this.PieRadius;
            pieLayout.placeCircumference(this.SliceAngle[n2].startAngle, this.SliceAngle[n2].deltaAngle, d, d2);
        }
        double d3 = this.PieRadius;
        int n4 = this.XOffset;
        int n5 = this.YOffset;
        d2 = this.getNormalizedFactor(n3, false);
        boolean bl2 = false;
        if (this.NormalizationFactor >= 2.0) {
            bl2 = true;
        }
        this.initMinMax();
        this.initCircumference();
        for (n2 = 0; n2 < this.SliceDesc.length; ++n2) {
            pieLayout = new PieLayout();
            string = this.SliceSecondLabel[n2];
            n = this.fontmet.stringWidth(string);
            d = (double)n / this.PieRadius;
            bl = false;
            if (string == null || string == "") {
                bl = true;
            } else {
                bl = this.deriveRect(graphics2D, pieLayout, this.SliceAngle[n2].startAngle, this.SliceAngle[n2].deltaAngle, d, d2, null);
                if (bl) {
                    // empty if block
                }
            }
            if (bl || bl2) continue;
            pieLayout.placeCircumference(this.SliceAngle[n2].startAngle, this.SliceAngle[n2].deltaAngle, d, d2);
        }
        this.NormalizationFactor = this.getMaxXYNormalized();
        this.PieRadius = d3;
        this.XOffset = n4;
        this.YOffset = n5;
        d2 = this.getNormalizedFactor(n3, false);
        this.PieRadius = this.PieDiameter / 2;
        this.convertCircumLabelOffset();
        this.drawBackground(graphics2D);
        this.computeArc();
        this.drawSlices(graphics2D, 1);
        for (n2 = 0; n2 < this.SliceDesc.length; ++n2) {
            pieLayout = new PieLayout();
            string = this.SliceSecondLabel[n2];
            n = this.fontmet.stringWidth(string);
            d = (double)n / this.PieRadius;
            bl = false;
            bl = string == null || string == "" ? true : this.deriveRect(graphics2D, pieLayout, this.SliceAngle[n2].startAngle, this.SliceAngle[n2].deltaAngle, d, d2, null);
            if (bl) {
                this.interiorLabel[n2] = true;
                this.drawLabelInSlice(graphics2D, pieLayout, false, string, null, n2);
            }
            if (!bl && !bl2) {
                pieLayout.placeCircumference(this.SliceAngle[n2].startAngle, this.SliceAngle[n2].deltaAngle, d, d2);
                this.interiorLabel[n2] = false;
            }
            this.SliceStoredLayout[n2].isMulti = false;
            this.SliceStoredLayout[n2].interiorLabel = this.interiorLabel[n2];
            this.SliceStoredLayout[n2].label = string;
            this.SliceStoredLayout[n2].pl = pieLayout;
            this.SliceStoredLayout[n2].SliceLabelLines = var3_3;
        }
        this.SpreadCircumferenceLabels(graphics2D, this.PieRadius);
        for (n2 = 0; n2 < this.SliceDesc.length; ++n2) {
            if (this.SliceStoredLayout[n2].interiorLabel) continue;
            this.drawLabelInSlice(graphics2D, this.SliceStoredLayout[n2].pl, false, this.SliceStoredLayout[n2].label, null, n2);
        }
    }

    private void SpreadCircumferenceLabels(Graphics2D graphics2D, double d) {
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        int n4 = -1;
        for (int i = 0; i < this.SliceDesc.length; ++i) {
            if (this.SliceStoredLayout[i].interiorLabel) continue;
            if (n == -1) {
                n = i;
                n2 = i;
            } else if (i == n3 + 1) {
                n2 = i;
            } else {
                this.doSpread(n, n2);
                n4 = n;
                n = i;
                n2 = i;
            }
            n3 = i;
        }
        if (n4 != n) {
            this.doSpread(n, n2);
        }
    }

    private void doSpread(int n, int n2) {
        Object object;
        int n3;
        double d = 0.0;
        double d2 = 105.0;
        if (n != -1) {
            double d3 = this.SliceAngle[n].startAngle;
            double d4 = this.SliceAngle[n2].startAngle;
            d = this.clockwise ? d3 + this.SliceAngle[n].deltaAngle - d4 : d4 + this.SliceAngle[n2].deltaAngle - d3;
        }
        if (d > d2) {
            return;
        }
        boolean bl = false;
        Rectangle2D.Double double_ = null;
        Rectangle2D.Double double_2 = null;
        boolean bl2 = true;
        Vector<SpreadCircumferenceLabels> vector = new Vector<SpreadCircumferenceLabels>();
        Vector<SpreadCircumferenceLabels> vector2 = new Vector<SpreadCircumferenceLabels>();
        Vector<SpreadCircumferenceLabels> vector3 = new Vector<SpreadCircumferenceLabels>();
        int n4 = n;
        for (n3 = n; n3 <= n2; ++n3) {
            if (this.SliceStoredLayout[n3].interiorLabel) continue;
            PieLayout pieLayout = this.SliceStoredLayout[n3].pl;
            double d5 = pieLayout.getX();
            double d6 = pieLayout.getY();
            double_2 = new Rectangle2D.Double(d5, d6, pieLayout.labelWidthNormalized, pieLayout.labelHeightNormalized);
            object = new RectangleMinMaxTheta();
            ((RectangleMinMaxTheta)object).getRectTheta(double_2);
            if (n3 > 0 && double_ != null) {
                if (this.overlap(double_2, double_)) {
                    if (bl2) {
                        bl2 = false;
                        vector.add(new SpreadCircumferenceLabels(n4, double_));
                    }
                    vector.add(new SpreadCircumferenceLabels(n3, double_2));
                } else if (vector.size() == 0) {
                    vector2.add(new SpreadCircumferenceLabels(n4, double_));
                } else {
                    vector3.add(new SpreadCircumferenceLabels(n3, double_2));
                }
            }
            double_ = double_2;
            n4 = n3;
        }
        n3 = vector.size() / 2;
        boolean bl3 = false;
        if (vector.size() > 0) {
            SpreadCircumferenceLabels spreadCircumferenceLabels;
            if (vector.size() % 2 == 0) {
                object = (SpreadCircumferenceLabels)vector.elementAt(n3 - 1);
                spreadCircumferenceLabels = (SpreadCircumferenceLabels)vector.elementAt(n3);
                this.adjustFirstPairCircumfereceLabel((SpreadCircumferenceLabels)object, spreadCircumferenceLabels, this.clockwise);
                int n5 = n3;
                while (n5 + 1 < vector.size()) {
                    object = (SpreadCircumferenceLabels)vector.elementAt(n5);
                    spreadCircumferenceLabels = (SpreadCircumferenceLabels)vector.elementAt(n5 + 1);
                    bl3 = !this.clockwise;
                    this.adjustCircumfereceLabel((SpreadCircumferenceLabels)object, spreadCircumferenceLabels, bl3);
                    ++n5;
                }
                for (n5 = n3; n5 > 0; --n5) {
                    object = (SpreadCircumferenceLabels)vector.elementAt(n5);
                    spreadCircumferenceLabels = (SpreadCircumferenceLabels)vector.elementAt(n5 - 1);
                    bl3 = this.clockwise;
                    this.adjustCircumfereceLabel((SpreadCircumferenceLabels)object, spreadCircumferenceLabels, bl3);
                }
            } else {
                this.adjustFirstCircumfereceLabel((SpreadCircumferenceLabels)vector.elementAt(n3));
                int n6 = n3;
                while (n6 + 1 < vector.size()) {
                    object = (SpreadCircumferenceLabels)vector.elementAt(n6);
                    spreadCircumferenceLabels = (SpreadCircumferenceLabels)vector.elementAt(n6 + 1);
                    bl3 = !this.clockwise;
                    this.adjustCircumfereceLabel((SpreadCircumferenceLabels)object, spreadCircumferenceLabels, bl3);
                    ++n6;
                }
                for (n6 = n3; n6 > 0; --n6) {
                    object = (SpreadCircumferenceLabels)vector.elementAt(n6);
                    spreadCircumferenceLabels = (SpreadCircumferenceLabels)vector.elementAt(n6 - 1);
                    bl3 = this.clockwise;
                    this.adjustCircumfereceLabel((SpreadCircumferenceLabels)object, spreadCircumferenceLabels, bl3);
                }
            }
            if (vector2.size() > 0 || vector3.size() > 0) {
                // empty if block
            }
            if (vector2.size() > 0) {
                object = (SpreadCircumferenceLabels)vector2.elementAt(vector2.size() - 1);
                spreadCircumferenceLabels = (SpreadCircumferenceLabels)vector.elementAt(0);
                if (this.overlapAny(vector, ((SpreadCircumferenceLabels)object).boundingRect)) {
                    bl3 = this.clockwise;
                    this.adjustCircumfereceLabel(spreadCircumferenceLabels, (SpreadCircumferenceLabels)object, bl3);
                }
            }
            if (vector3.size() > 0) {
                object = (SpreadCircumferenceLabels)vector3.elementAt(0);
                spreadCircumferenceLabels = (SpreadCircumferenceLabels)vector.elementAt(vector.size() - 1);
                if (this.overlapAny(vector, ((SpreadCircumferenceLabels)object).boundingRect)) {
                    bl3 = !this.clockwise;
                    this.adjustCircumfereceLabel(spreadCircumferenceLabels, (SpreadCircumferenceLabels)object, bl3);
                }
            }
        }
    }

    public Rectangle2D.Double getBoundingRect(int n) {
        PieLayout pieLayout = this.SliceStoredLayout[n].pl;
        Rectangle2D.Double double_ = new Rectangle2D.Double(pieLayout.getX(), pieLayout.getY(), pieLayout.labelWidthNormalized, pieLayout.labelHeightNormalized);
        return double_;
    }

    private void adjustFirstCircumfereceLabel(SpreadCircumferenceLabels spreadCircumferenceLabels) {
        RectangleMinMaxTheta rectangleMinMaxTheta = new RectangleMinMaxTheta();
        rectangleMinMaxTheta.getRectTheta(spreadCircumferenceLabels.boundingRect);
        double d = Math.toDegrees(rectangleMinMaxTheta.thetaMax - rectangleMinMaxTheta.thetaMin);
        double d2 = (d - this.SliceAngle[spreadCircumferenceLabels.index].deltaAngle) / 2.0;
        this.SliceAngle[spreadCircumferenceLabels.index].startAngleCirLabel = this.SliceAngle[spreadCircumferenceLabels.index].startAngle - d2;
        this.SliceAngle[spreadCircumferenceLabels.index].deltaAngleCirLabel = d;
    }

    private void adjustFirstPairCircumfereceLabel(SpreadCircumferenceLabels spreadCircumferenceLabels, SpreadCircumferenceLabels spreadCircumferenceLabels2, boolean bl) {
        RectangleMinMaxTheta rectangleMinMaxTheta = new RectangleMinMaxTheta();
        RectangleMinMaxTheta rectangleMinMaxTheta2 = new RectangleMinMaxTheta();
        rectangleMinMaxTheta.getRectTheta(spreadCircumferenceLabels.boundingRect);
        rectangleMinMaxTheta2.getRectTheta(spreadCircumferenceLabels2.boundingRect);
        double d = Math.toDegrees(rectangleMinMaxTheta.thetaMax - rectangleMinMaxTheta.thetaMin);
        double d2 = Math.toDegrees(rectangleMinMaxTheta2.thetaMax - rectangleMinMaxTheta2.thetaMin);
        double d3 = d - this.SliceAngle[spreadCircumferenceLabels.index].deltaAngle;
        double d4 = d2 - this.SliceAngle[spreadCircumferenceLabels2.index].deltaAngle;
        if (!bl) {
            this.SliceAngle[spreadCircumferenceLabels.index].startAngleCirLabel = this.SliceAngle[spreadCircumferenceLabels.index].startAngle - d3;
            this.SliceAngle[spreadCircumferenceLabels.index].deltaAngleCirLabel = d;
            this.SliceAngle[spreadCircumferenceLabels2.index].startAngleCirLabel = this.SliceAngle[spreadCircumferenceLabels2.index].startAngle;
            this.SliceAngle[spreadCircumferenceLabels2.index].deltaAngleCirLabel = d2;
        } else {
            this.SliceAngle[spreadCircumferenceLabels.index].startAngleCirLabel = this.SliceAngle[spreadCircumferenceLabels.index].startAngle;
            this.SliceAngle[spreadCircumferenceLabels.index].deltaAngleCirLabel = d;
            this.SliceAngle[spreadCircumferenceLabels2.index].startAngleCirLabel = this.SliceAngle[spreadCircumferenceLabels2.index].startAngle - d4;
            this.SliceAngle[spreadCircumferenceLabels2.index].deltaAngleCirLabel = d2;
        }
        this.SliceStoredLayout[spreadCircumferenceLabels.index].pl.placeCircumference(this.SliceAngle[spreadCircumferenceLabels.index].startAngleCirLabel, this.SliceAngle[spreadCircumferenceLabels.index].deltaAngleCirLabel, this.SliceStoredLayout[spreadCircumferenceLabels.index].pl.labelWidthNormalized, this.SliceStoredLayout[spreadCircumferenceLabels.index].pl.labelHeightNormalized);
        this.SliceStoredLayout[spreadCircumferenceLabels2.index].pl.placeCircumference(this.SliceAngle[spreadCircumferenceLabels2.index].startAngleCirLabel, this.SliceAngle[spreadCircumferenceLabels2.index].deltaAngleCirLabel, this.SliceStoredLayout[spreadCircumferenceLabels2.index].pl.labelWidthNormalized, this.SliceStoredLayout[spreadCircumferenceLabels2.index].pl.labelHeightNormalized);
    }

    private void adjustCircumfereceLabel(SpreadCircumferenceLabels spreadCircumferenceLabels, SpreadCircumferenceLabels spreadCircumferenceLabels2, boolean bl) {
        boolean bl2 = false;
        RectangleMinMaxTheta rectangleMinMaxTheta = new RectangleMinMaxTheta();
        rectangleMinMaxTheta.getRectTheta(spreadCircumferenceLabels2.boundingRect);
        double d = Math.toDegrees(rectangleMinMaxTheta.thetaMax - rectangleMinMaxTheta.thetaMin);
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.SliceAngle[spreadCircumferenceLabels.index].deltaAngleCirLabel;
        double d5 = bl ? this.SliceAngle[spreadCircumferenceLabels.index].startAngleCirLabel + d4 : this.SliceAngle[spreadCircumferenceLabels.index].startAngleCirLabel - d4;
        this.SliceAngle[spreadCircumferenceLabels2.index].startAngleCirLabel = d5;
        this.SliceAngle[spreadCircumferenceLabels2.index].deltaAngleCirLabel = d;
        this.SliceStoredLayout[spreadCircumferenceLabels2.index].pl.placeCircumference(d5, d, this.SliceStoredLayout[spreadCircumferenceLabels2.index].pl.labelWidthNormalized, this.SliceStoredLayout[spreadCircumferenceLabels2.index].pl.labelHeightNormalized);
    }

    private boolean overlapAny(Vector vector, Rectangle2D.Double double_) {
        for (int i = 0; i < vector.size(); ++i) {
            SpreadCircumferenceLabels spreadCircumferenceLabels = (SpreadCircumferenceLabels)vector.elementAt(i);
            Rectangle2D.Double double_2 = this.getBoundingRect(spreadCircumferenceLabels.index);
            if (!double_.intersects(double_2.x, double_2.y, double_2.width, double_2.height)) continue;
            return true;
        }
        return false;
    }

    private boolean overlap(Rectangle2D.Double double_, Rectangle2D.Double double_2) {
        return double_2.intersects(double_.x, double_.y, double_.width, double_.height);
    }

    private void doLayout(Graphics2D graphics2D) throws ChartException {
        this.drawBackground(graphics2D);
        this.computeArc();
        this.exLayout.draw(graphics2D, 0, true);
        this.exLayout.draw(graphics2D, 1, true);
        this.redrawEmptySlices(graphics2D, 1);
        this.redrawLabeledSlices(graphics2D, 1);
        for (int i = 0; i < this.SliceDesc.length; ++i) {
            if (!this.SliceStoredLayout[i].interiorLabel) continue;
            this.drawLabelInSlice(graphics2D, this.SliceStoredLayout[i].pl, this.SliceStoredLayout[i].isMulti, this.SliceStoredLayout[i].label, this.SliceStoredLayout[i].SliceLabelLines, i);
        }
    }

    boolean deriveRect(Graphics2D graphics2D, PieLayout pieLayout, double d, double d2, double d3, double d4, Vector vector) {
        boolean bl = false;
        if (d3 < 0.0) {
            return true;
        }
        boolean bl2 = false;
        if (d2 <= 90.0) {
            graphics2D.setColor(Color.white);
            bl2 = pieLayout.deriveRect90(d, d2, (d + d + d2) / 2.0, d3, d4, vector);
        } else if (d2 < 180.0) {
            bl2 = pieLayout.deriveRect180(d, d2, d3, d4, vector);
            double d5 = d + d2;
            if (this.inQuad3(d) && this.inQuad4(d5) || this.inQuad4(d) && this.inQuad1(d5) || this.inQuad1(d) && this.inQuad2(d5) || this.inQuad2(d) && this.inQuad3(d5)) {
                graphics2D.setColor(Color.green);
            } else {
                graphics2D.setColor(Color.blue);
            }
        } else {
            bl2 = pieLayout.deriveRect360(d, d2, d3, d4);
        }
        String string = "";
        int n = 0;
        if (vector != null) {
            string = (String)vector.elementAt(0);
            n = vector.size();
        }
        return bl2;
    }

    public void paint(Graphics graphics) {
        if (this.BI == null || this.SizeChanged) {
            this.SizeChanged = false;
            this.displayWidth = this.getWidth();
            this.displayHeight = this.getHeight();
            this.BI = new BufferedImage(this.displayWidth, this.displayHeight, 1);
        }
        Graphics2D graphics2D = this.BI.createGraphics();
        try {
            this.drawBuffer(graphics2D);
        }
        catch (ChartException chartException) {
            System.out.println(chartException.getMessage());
        }
        graphics.drawImage(this.BI, 0, 0, this);
    }

    private final class ExLabel {
        String pieLabel;
        double startAngle;
        double deltaAngle;
        double midpointAngle;
        int sliceIndex;
        boolean topHemi = false;
        double poleDistance = 0.0;
        int rank = -1;
        boolean rightSide = false;

        boolean isTopHemi() {
            return this.topHemi;
        }

        boolean isBottomHemi() {
            return !this.topHemi;
        }

        boolean notRank() {
            return this.rank == -1;
        }

        double getPoleDistance() {
            return this.poleDistance;
        }

        void setRank(int n) {
            this.rank = n;
        }

        int getRank() {
            return this.rank;
        }

        boolean isRightSide() {
            return this.rightSide;
        }

        ExLabel(String string, double d, double d2, int n) {
            this.pieLabel = string.trim();
            this.startAngle = d;
            this.deltaAngle = d2;
            this.midpointAngle = PieChart.this.getNormalizedAngle(d + d2 / 2.0);
            this.sliceIndex = n;
            if (this.midpointAngle < 180.0) {
                this.topHemi = true;
                if (this.midpointAngle <= 90.0) {
                    this.poleDistance = 90.0 - this.midpointAngle;
                    this.rightSide = true;
                } else {
                    this.poleDistance = this.midpointAngle - 90.0;
                    this.rightSide = false;
                }
            } else {
                this.topHemi = false;
                if (this.midpointAngle <= 270.0) {
                    this.poleDistance = 270.0 - this.midpointAngle;
                    this.rightSide = false;
                } else {
                    this.poleDistance = this.midpointAngle - 270.0;
                    this.rightSide = true;
                }
            }
        }
    }

    private final class ExLabelLayout {
        Vector ExteriorLabels = new Vector();
        LinkedList[][] ExteriorLabelsQuad = new LinkedList[2][2];
        static final int TOP = 0;
        static final int BOTTOM = 1;
        static final int RIGHT = 0;
        static final int LEFT = 1;
        int TopStemLength = 8;
        int minStemHeight = 15;
        int BaseStemLength = 4;
        double SideThreshI2 = 22.0;
        double SideThreshC = 30.0;

        private ExLabelLayout() {
        }

        void init() {
            double d = PieChart.this.initialStartAngle;
            String string = "";
            for (int i = 0; i < PieChart.this.SliceDesc.length; ++i) {
                string = PieChart.this.SliceDesc[i].getLabel();
                if (!PieChart.this.interiorLabel[i]) {
                    this.ExteriorLabels.addElement(new ExLabel(string, d, PieChart.this.percentToAngle(PieChart.this.SliceDesc[i].getValue()), i));
                }
                d += PieChart.this.percentToAngle(PieChart.this.SliceDesc[i].getValue());
            }
            this.partitionQuad();
        }

        void partitionQuad() {
            int n = 0;
            int n2 = 0;
            for (n = 0; n < 2; ++n) {
                for (n2 = 0; n2 < 2; ++n2) {
                    this.ExteriorLabelsQuad[n][n2] = new LinkedList();
                }
            }
            for (int i = 0; i < this.ExteriorLabels.size(); ++i) {
                ExLabel exLabel = (ExLabel)this.ExteriorLabels.elementAt(i);
                n = exLabel.isTopHemi() ? 0 : 1;
                if (this.ExteriorLabelsQuad[n][n2 = exLabel.isRightSide() ? 0 : 1].isEmpty()) {
                    this.ExteriorLabelsQuad[n][n2].addFirst(exLabel);
                    continue;
                }
                ListIterator listIterator = this.ExteriorLabelsQuad[n][n2].listIterator();
                boolean bl = false;
                for (int j = 0; j < this.ExteriorLabelsQuad[n][n2].size(); ++j) {
                    ExLabel exLabel2 = (ExLabel)listIterator.next();
                    if (!(exLabel2.getPoleDistance() > exLabel.getPoleDistance())) continue;
                    this.ExteriorLabelsQuad[n][n2].add(j, exLabel);
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.ExteriorLabelsQuad[n][n2].add(exLabel);
            }
        }

        void drawL(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
            graphics2D.setColor(PieChart.this.getConnectorColor());
            graphics2D.setStroke(PieChart.this.getConnectorStroke());
            graphics2D.drawLine(n, n2, n, n2 - n4);
            graphics2D.drawLine(n - n3, n2 - n4, n, n2 - n4);
        }

        void drawLorDiag(Graphics2D graphics2D, double d, int n, int n2, int n3, int n4) {
            if (PieChart.this.StyleDesc.getStyleType() != 2) {
                this.drawL(graphics2D, n, n2, n3, n4);
            } else if (PieChart.this.E3D.inShadow(d)) {
                this.drawLDiag(graphics2D, n, n2, n3, n4);
            } else {
                this.drawL(graphics2D, n, n2, n3, n4);
            }
        }

        void drawLDiag(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
            graphics2D.setColor(PieChart.this.getConnectorColor());
            graphics2D.setStroke(PieChart.this.getConnectorStroke());
            int n5 = n - n3 / 2;
            graphics2D.drawLine(n, n2, n5, n2 - n4);
            graphics2D.drawLine(n - n3, n2 - n4, n5, n2 - n4);
        }

        void drawI(Graphics2D graphics2D, int n, int n2, int n3) {
            graphics2D.setColor(PieChart.this.getConnectorColor());
            graphics2D.setStroke(PieChart.this.getConnectorStroke());
            graphics2D.drawLine(n, n2, n, n2 - n3);
        }

        void drawI2(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
            graphics2D.setColor(PieChart.this.getConnectorColor());
            graphics2D.setStroke(PieChart.this.getConnectorStroke());
            graphics2D.drawLine(n, n2, n + n3, n2);
            graphics2D.drawLine(n + n3, n2, n + n3, n2 - n4);
        }

        void drawC(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
            graphics2D.setColor(PieChart.this.getConnectorColor());
            graphics2D.setStroke(PieChart.this.getConnectorStroke());
            graphics2D.drawLine(n, n2, n + n3, n2);
            graphics2D.drawLine(n + n3, n2, n + n3, n2 - n5);
            graphics2D.drawLine(n + n3, n2 - n5, n - n4, n2 - n5);
        }

        void draw(Graphics2D graphics2D, int n, boolean bl) {
            int n2 = this.ExteriorLabelsQuad[n][0].size();
            int n3 = this.ExteriorLabelsQuad[n][1].size();
            int n4 = PieChart.this.fontmet.getAscent();
            int n5 = PieChart.this.fontmet.getMaxAscent();
            boolean bl2 = false;
            int n6 = 0;
            if (n3 > 0 || n2 > 0) {
                switch (n) {
                    case 0: {
                        n6 = PieChart.this.YOffset - n5;
                        PieStyleDesc cfr_ignored_0 = PieChart.this.StyleDesc;
                        if (PieChart.this.StyleDesc.getStyleType() == 0) break;
                        n6 -= PieChart.this.Adjust3D.Offset3D_Top;
                        break;
                    }
                    case 1: {
                        n6 = (int)((double)PieChart.this.YOffset + 2.0 * PieChart.this.PieRadius + (double)n5);
                        PieStyleDesc cfr_ignored_1 = PieChart.this.StyleDesc;
                        if (PieChart.this.StyleDesc.getStyleType() == 0) break;
                        n6 += PieChart.this.Adjust3D.Offset3D_Bottom;
                    }
                }
                ListIterator listIterator = null;
                int n7 = 0;
                if (n3 == 1 && n2 == 1 || n3 == 0 || n2 == 0) {
                    if (n3 == 1 && n2 == 1) {
                        listIterator = this.ExteriorLabelsQuad[n][1].listIterator();
                        n7 = this.getmidPointSliceX(listIterator) + PieChart.this.fontmet.getMaxAdvance() / 2;
                    }
                    int n8 = 0;
                    if (n2 > 0) {
                        n8 = 0;
                        listIterator = this.ExteriorLabelsQuad[n][n8].listIterator();
                        this.drawList(graphics2D, n, listIterator, n6, n8, n7, bl);
                        n6 = n == 1 ? (n6 += n4) : (n6 -= n4);
                    }
                    if (n3 > 0) {
                        n8 = 1;
                        listIterator = this.ExteriorLabelsQuad[n][n8].listIterator();
                        this.drawList(graphics2D, n, listIterator, n6, n8, n7, bl);
                    }
                } else {
                    listIterator = this.ExteriorLabelsQuad[n][0].listIterator(this.ExteriorLabelsQuad[n][0].size());
                    this.drawListSplit(graphics2D, n, listIterator, n6, 0, bl);
                    listIterator = this.ExteriorLabelsQuad[n][1].listIterator(this.ExteriorLabelsQuad[n][1].size());
                    this.drawListSplit(graphics2D, n, listIterator, n6, 1, bl);
                }
            }
        }

        private int getmidPointSliceX(ListIterator listIterator) {
            int n = 0;
            if (listIterator.hasNext()) {
                ExLabel exLabel = (ExLabel)listIterator.next();
                double d = Math.toRadians(exLabel.midpointAngle);
                n = (int)Math.round(PieChart.this.PieRadius + (double)PieChart.this.XOffset + PieChart.this.PieRadius * Math.cos(d));
            }
            return n;
        }

        void drawList(Graphics2D graphics2D, int n, ListIterator listIterator, int n2, int n3, int n4, boolean bl) {
            int n5;
            boolean bl2 = false;
            Point2D.Double double_ = PieChart.this.E3D.getShadowOffset();
            ExLabel exLabel = null;
            int n6 = PieChart.this.fontmet.getAscent();
            int n7 = PieChart.this.fontmet.getMaxAscent();
            int n8 = 0;
            int n9 = this.ExteriorLabelsQuad[n][0].size();
            int n10 = this.ExteriorLabelsQuad[n][1].size();
            int n11 = PieChart.this.YOffset;
            int n12 = PieChart.this.YOffset + PieChart.this.PieDiameter;
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            int n16 = 0;
            PieConnectorHelper pieConnectorHelper = new PieConnectorHelper();
            while (listIterator.hasNext()) {
                exLabel = (ExLabel)listIterator.next();
                n5 = exLabel.sliceIndex;
                n14 = PieChart.this.fontmet.stringWidth(exLabel.pieLabel);
                pieConnectorHelper.getSliceMidpoint(exLabel.midpointAngle);
                int n17 = pieConnectorHelper.midpointSliceX;
                int n18 = pieConnectorHelper.midpointSliceY;
                int n19 = 0;
                n13 = 0;
                n19 = n == 0 ? n2 - n8 * n6 : n2 + n8 * n6;
                if (n3 == 0) {
                    if (n9 > 1) {
                        n13 = n17 - n14 - 2 * this.TopStemLength;
                        if (bl) {
                            if (this.rightSideThreshold(exLabel.midpointAngle, this.SideThreshC)) {
                                this.drawC(graphics2D, n17, n18, this.BaseStemLength + 2 * n15, this.TopStemLength, n18 - n19);
                                ++n15;
                            } else {
                                this.drawLorDiag(graphics2D, exLabel.midpointAngle, n17, n18, this.TopStemLength, n18 - n19);
                            }
                        }
                    } else {
                        double d = n == 0 ? (double)(-(2 * n7 / 3)) : (double)(2 * n7 / 3);
                        if (bl) {
                            if (this.rightSideThreshold(exLabel.midpointAngle, this.SideThreshI2)) {
                                this.drawI2(graphics2D, n17, n18, this.BaseStemLength, (int)((double)(n18 - n19) + d));
                            } else {
                                this.drawI(graphics2D, n17, n18, (int)((double)(n18 - n19) + d));
                            }
                        }
                        n13 = (int)((double)PieChart.this.XOffset + PieChart.this.PieRadius - (double)(n14 / 2));
                        n13 = Math.max(n13, n17 - n14 + PieChart.this.fontmet.getMaxAdvance() / 2);
                        if (n4 != 0) {
                            n13 = Math.max(n13, n4);
                        }
                    }
                } else if (n10 > 1) {
                    n13 = n17 + 2 * this.TopStemLength;
                    if (bl) {
                        if (this.leftSideThreshold(exLabel.midpointAngle, this.SideThreshC)) {
                            this.drawC(graphics2D, n17, n18, -this.BaseStemLength - 2 * n16, -this.TopStemLength, n18 - n19);
                            ++n16;
                        } else {
                            this.drawLorDiag(graphics2D, exLabel.midpointAngle, n17, n18, -this.TopStemLength, n18 - n19);
                        }
                    }
                } else {
                    double d = n == 0 ? (double)(-(2 * n7 / 3)) : (double)(2 * n7 / 3);
                    if (bl) {
                        if (this.leftSideThreshold(exLabel.midpointAngle, this.SideThreshI2)) {
                            this.drawI2(graphics2D, n17, n18, -this.BaseStemLength, (int)((double)(n18 - n19) + d));
                        } else {
                            this.drawI(graphics2D, n17, n18, (int)((double)(n18 - n19) + d));
                        }
                    }
                    n13 = (int)((double)PieChart.this.XOffset + PieChart.this.PieRadius - (double)(n14 / 2));
                    n13 = Math.min(n13, n17 - PieChart.this.fontmet.getMaxAdvance() / 2);
                }
                n11 = n19 + n7 / 3 - n6;
                if (bl) {
                    graphics2D.setFont(PieChart.this.font);
                    if (PieChart.this.HilightLabelIndex == n5) {
                        graphics2D.setColor(PieChart.this.HilightLabelColor);
                    } else {
                        graphics2D.setColor(PieChart.this.SliceDesc[n5].getLabelColor());
                    }
                    PieChart.this.SliceLabelLoc[n5].drawStringSetLocSize(graphics2D, exLabel.pieLabel, n13, n19 + n7 / 3, n14, n7);
                }
                n12 = n19 + n7 / 3;
                this.setMinMax(n13, n13 + n14, n11, n12);
                ++n8;
                int n20 = PieChart.this.XOffset - n13;
                if ((n20 -= PieChart.this.Adjust3D.Offset3D_Left) > 0) {
                    PieChart.this.ScoreD.setLeftSpaceNeeded(n20);
                }
                n20 = n13 + n14 - (PieChart.this.XOffset + PieChart.this.PieDiameter);
                if ((n20 -= PieChart.this.Adjust3D.Offset3D_Right) <= 0) continue;
                PieChart.this.ScoreD.setRightSpaceNeeded(n20);
            }
            if (n8 > 0) {
                if (n == 0) {
                    n5 = PieChart.this.YOffset - n11 - PieChart.this.Adjust3D.Offset3D_Top;
                    PieChart.this.ScoreD.setTopSpaceNeeded(n5);
                } else {
                    n5 = n12 - (PieChart.this.YOffset + PieChart.this.PieDiameter + PieChart.this.Adjust3D.Offset3D_Bottom + PieChart.this.Adjust3D.Offset3D_Top);
                    PieChart.this.ScoreD.setBottomSpaceNeeded(n5);
                }
            }
        }

        private boolean rightSideThreshold(double d, double d2) {
            return d < 180.0 ? d < d2 : d > 360.0 - d2;
        }

        private boolean leftSideThreshold(double d, double d2) {
            return d <= 180.0 + d2 && d >= 180.0 - d2;
        }

        void setMinMax(int n, int n2, int n3, int n4) {
            if (n < PieChart.this.minX) {
                PieChart.this.minX = n;
            }
            if (n2 > PieChart.this.maxX) {
                PieChart.this.maxX = n2;
            }
            if (n3 < PieChart.this.minY) {
                PieChart.this.minY = n3;
            }
            if (n4 > PieChart.this.maxY) {
                PieChart.this.maxY = n4;
            }
        }

        void drawListSplit(Graphics2D graphics2D, int n, ListIterator listIterator, int n2, int n3, boolean bl) {
            int n4;
            ExLabel exLabel = null;
            Point2D.Double double_ = PieChart.this.E3D.getShadowOffset();
            int n5 = PieChart.this.fontmet.getAscent();
            int n6 = PieChart.this.fontmet.getMaxAscent();
            int n7 = PieChart.this.YOffset;
            int n8 = PieChart.this.YOffset + PieChart.this.PieDiameter;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            PieConnectorHelper pieConnectorHelper = new PieConnectorHelper();
            while (listIterator.hasPrevious()) {
                exLabel = (ExLabel)listIterator.previous();
                n4 = exLabel.sliceIndex;
                n12 = PieChart.this.fontmet.stringWidth(exLabel.pieLabel);
                pieConnectorHelper.getSliceMidpoint(exLabel.midpointAngle);
                int n13 = pieConnectorHelper.midpointSliceX;
                int n14 = pieConnectorHelper.midpointSliceY;
                n10 = 0;
                int n15 = 0;
                if (n == 0) {
                    n15 = n14 - this.minStemHeight;
                    if (n11 != 0 && n11 - n5 < n15) {
                        n15 = n11 - n5;
                    }
                    n11 = n15;
                } else {
                    n15 = n14 + this.minStemHeight;
                    if (n11 != 0 && n11 + n5 > n15) {
                        n15 = n11 + n5;
                    }
                    n11 = n15;
                }
                if (n3 == 1) {
                    n10 = n13 - n12 - 2 * this.TopStemLength;
                    if (bl) {
                        this.drawLorDiag(graphics2D, exLabel.midpointAngle, n13, n14, this.TopStemLength, n14 - n15);
                    }
                } else {
                    n10 = n13 + 2 * this.TopStemLength;
                    if (bl) {
                        this.drawLorDiag(graphics2D, exLabel.midpointAngle, n13, n14, -this.TopStemLength, n14 - n15);
                    }
                }
                n7 = n15 + n6 / 3 - n5;
                if (bl) {
                    graphics2D.setFont(PieChart.this.font);
                    if (PieChart.this.HilightLabelIndex == n4) {
                        graphics2D.setColor(PieChart.this.HilightLabelColor);
                    } else {
                        graphics2D.setColor(PieChart.this.SliceDesc[n4].getLabelColor());
                    }
                    PieChart.this.SliceLabelLoc[n4].drawStringSetLocSize(graphics2D, exLabel.pieLabel, n10, n15 + n6 / 3, n12, n6);
                }
                n8 = n15 + n6 / 3;
                this.setMinMax(n10, n10 + n12, n7, n8);
                ++n9;
                int n16 = PieChart.this.XOffset - n10;
                if ((n16 -= PieChart.this.Adjust3D.Offset3D_Left) > 0) {
                    PieChart.this.ScoreD.setLeftSpaceNeeded(n16);
                }
                n16 = n10 + n12 - (PieChart.this.XOffset + PieChart.this.PieDiameter);
                if ((n16 -= PieChart.this.Adjust3D.Offset3D_Right) <= 0) continue;
                PieChart.this.ScoreD.setRightSpaceNeeded(n16);
            }
            if (n9 > 0) {
                if (n == 0) {
                    n4 = PieChart.this.YOffset - n7;
                    PieChart.this.ScoreD.setTopSpaceNeeded(n4);
                } else {
                    n4 = n8 - (PieChart.this.YOffset + PieChart.this.PieDiameter + PieChart.this.Adjust3D.Offset3D_Bottom + PieChart.this.Adjust3D.Offset3D_Top);
                    PieChart.this.ScoreD.setBottomSpaceNeeded(n4);
                }
            }
        }
    }

    private final class PieConnectorHelper {
        private double midpointSliceXDouble;
        private double midpointSliceYDouble;
        public int midpointSliceX;
        public int midpointSliceY;

        PieConnectorHelper() {
        }

        public void getSliceMidpoint(double d) {
            double d2 = Math.toRadians(d);
            this.midpointSliceXDouble = PieChart.this.PieRadius + (double)PieChart.this.XOffset + PieChart.this.PieRadius * Math.cos(d2);
            this.midpointSliceYDouble = (double)PieChart.this.YOffset + PieChart.this.PieRadius - PieChart.this.PieRadius * Math.sin(d2);
            PieStyleDesc cfr_ignored_0 = PieChart.this.StyleDesc;
            if (PieChart.this.StyleDesc.getStyleType() != 0 && PieChart.this.E3D.inShadow(d)) {
                Point2D.Double double_ = PieChart.this.E3D.getShadowOffset();
                this.midpointSliceXDouble += double_.x * 0.9;
                this.midpointSliceYDouble += double_.y * 0.9;
            }
            this.midpointSliceX = (int)Math.round(this.midpointSliceXDouble);
            this.midpointSliceY = (int)Math.round(this.midpointSliceYDouble);
        }
    }

    private final class SpreadCircumferenceLabels {
        public Rectangle2D.Double boundingRect;
        public int index;
        double theta1;
        double theta2;
        double theta3;
        double theta4;
        double r1;
        double r2;
        double r3;
        double r4;

        public SpreadCircumferenceLabels(int n, Rectangle2D.Double double_) {
            this.index = n;
            this.boundingRect = double_;
        }
    }

    private final class RectangleMinMaxTheta {
        double thetaMin;
        double thetaMax;
        double TwoPI = Math.PI * 2;
        double HalfPI = 1.5707963267948966;
        double theta1;
        double theta2;
        double theta3;
        double theta4;

        private boolean inQuad2() {
            if (this.theta1 >= this.HalfPI && this.theta1 <= 180.0) {
                return true;
            }
            if (this.theta2 >= this.HalfPI && this.theta2 <= 180.0) {
                return true;
            }
            if (this.theta3 >= this.HalfPI && this.theta3 <= 180.0) {
                return true;
            }
            return this.theta4 >= this.HalfPI && this.theta4 <= 180.0;
        }

        private boolean inQuad2(double d) {
            return d >= this.HalfPI && d <= 180.0;
        }

        private boolean inQuad3() {
            if (this.theta1 <= -this.HalfPI && this.theta1 >= -180.0) {
                return true;
            }
            if (this.theta2 <= -this.HalfPI && this.theta2 >= -180.0) {
                return true;
            }
            if (this.theta3 <= -this.HalfPI && this.theta3 >= -180.0) {
                return true;
            }
            return this.theta4 <= -this.HalfPI && this.theta4 >= -180.0;
        }

        private boolean inQuad3(double d) {
            return d <= -this.HalfPI && d >= -180.0;
        }

        private void adjustTheta() {
            if (this.theta1 >= 0.0 && this.theta2 >= 0.0 && this.theta3 >= 0.0 && this.theta4 >= 0.0) {
                return;
            }
            if (this.theta1 <= 0.0 && this.theta2 <= 0.0 && this.theta3 <= 0.0 && this.theta4 <= 0.0) {
                return;
            }
            if (this.inQuad2() && this.inQuad3()) {
                if (this.inQuad3(this.theta1)) {
                    this.theta1 = this.TwoPI + this.theta1;
                }
                if (this.inQuad3(this.theta2)) {
                    this.theta2 = this.TwoPI + this.theta2;
                }
                if (this.inQuad3(this.theta3)) {
                    this.theta3 = this.TwoPI + this.theta3;
                }
                if (this.inQuad3(this.theta4)) {
                    this.theta4 = this.TwoPI + this.theta4;
                }
            }
        }

        private void getRectTheta(Rectangle2D.Double double_) {
            double d = double_.width / 2.0;
            double d2 = double_.height / 2.0;
            double d3 = double_.x - d;
            double d4 = double_.y - d2;
            this.theta1 = Math.atan2(d4, d3);
            d3 = double_.x + d;
            d4 = double_.y + d2;
            this.theta2 = Math.atan2(d4, d3);
            d3 = double_.x - d;
            d4 = double_.y + d2;
            this.theta3 = Math.atan2(d4, d3);
            d3 = double_.x + d;
            d4 = double_.y - d2;
            this.theta4 = Math.atan2(d4, d3);
            this.adjustTheta();
            this.thetaMin = Math.min(Math.min(this.theta1, this.theta2), Math.min(this.theta3, this.theta4));
            this.thetaMax = Math.max(Math.max(this.theta1, this.theta2), Math.max(this.theta3, this.theta4));
        }
    }

    private final class Effect3D {
        public double extrusionAngle = 0.0;
        public double extrusionAngleRad = Math.toRadians(this.extrusionAngle);
        public double extrusionThickness = 0.1;
        double vanishConstant = 10.0;
        double vanishAdjustRad = Math.atan(1.0 / this.vanishConstant);
        double vanishAdjustDeg = Math.toDegrees(this.vanishAdjustRad);
        Point2D.Double shadowOffsetPoint = new Point2D.Double();
        Point2D.Double vanishPoint = new Point2D.Double();
        public double startCircumX;
        public double startCircumY;
        public double endCircumX;
        public double endCircumY;
        public double midCircumX;
        public double midCircumY;
        public double startCircumXShadow;
        public double startCircumYShadow;
        public double endCircumXShadow;
        public double endCircumYShadow;

        Effect3D() {
        }

        public void setExtrusionThickness(double d) {
            this.extrusionThickness = d;
        }

        private double getExtrusionThickness() {
            return this.extrusionThickness;
        }

        public void setPerspectiveDistance(double d) {
            if (d >= 1.0) {
                this.vanishConstant = d;
            }
            this.setVanishAdjust();
        }

        public void setVanishAdjust() {
            this.vanishAdjustRad = Math.atan(1.0 / this.vanishConstant);
            this.vanishAdjustDeg = Math.toDegrees(this.vanishAdjustRad);
        }

        public void setExtrusionAngle(double d) {
            this.extrusionAngle = d;
            this.extrusionAngleRad = Math.toRadians(this.extrusionAngle);
        }

        public double getExtrusionAngle() {
            return this.extrusionAngle;
        }

        public double getExtrusionAngleRad() {
            return this.extrusionAngleRad;
        }

        public double getShadowStartAngle() {
            return PieChart.this.getNormalizedAngle(this.extrusionAngle - 90.0 + this.vanishAdjustDeg);
        }

        public double getShadowEndAngle() {
            return PieChart.this.getNormalizedAngle(this.extrusionAngle + 90.0 - this.vanishAdjustDeg);
        }

        private boolean outShadow(double d) {
            return !this.inShadow(d);
        }

        public boolean inShadow(double d) {
            double d2;
            double d3 = this.getShadowStartAngle();
            if (d3 > (d2 = this.getShadowEndAngle())) {
                if (d > d3) {
                    return true;
                }
                return d < d2;
            }
            return d > d3 && d < d2;
        }

        public boolean inOutShadow(double d, double d2) {
            return this.inShadow(d) && this.outShadow(d2);
        }

        public boolean outInShadow(double d, double d2) {
            return this.outShadow(d) && this.inShadow(d2);
        }

        public boolean outOutShadow(double d, double d2) {
            return this.outShadow(d) && this.outShadow(d2);
        }

        public boolean oneSliceShadow(double d, double d2, double d3) {
            if (this.outShadow(d) && this.outShadow(d2)) {
                double d4 = this.getShadowStartAngle();
                if (d > this.getShadowStartAngle()) {
                    d4 += 360.0;
                }
                if (d + d3 > d4) {
                    return true;
                }
            }
            return false;
        }

        public boolean inInOutShadow(double d, double d2, double d3) {
            return this.inShadow(d) && this.inShadow(d2) && this.outShadow(d3);
        }

        public Point2D.Double getShadowOffset() {
            boolean bl = false;
            double d = PieChart.this.PieRadius;
            if (bl) {
                System.out.println("shadowoffset pieRadius " + d + " et " + this.extrusionThickness);
            }
            double d2 = d * this.extrusionThickness;
            this.shadowOffsetPoint.x = Math.cos(this.extrusionAngleRad) * d2;
            this.shadowOffsetPoint.y = -Math.sin(this.extrusionAngleRad) * d2;
            if (bl) {
                System.out.println("shadowoffset (" + this.shadowOffsetPoint.x + ", " + this.shadowOffsetPoint.y + ")");
            }
            return this.shadowOffsetPoint;
        }

        public Point2D.Double getShadowOffsetNormalized() {
            Point2D.Double double_ = new Point2D.Double();
            double_ = this.getShadowOffset();
            double_.x /= PieChart.this.PieRadius;
            double_.y /= PieChart.this.PieRadius;
            return double_;
        }

        public void computeCircumference() {
            double d = Math.toRadians(this.getShadowStartAngle());
            double d2 = Math.toRadians(this.getShadowEndAngle());
            double d3 = this.extrusionAngleRad;
            double d4 = (double)PieChart.this.XOffset + (double)PieChart.this.CircumLabelWidthOffsetInt + PieChart.this.PieRadius;
            double d5 = (double)PieChart.this.YOffset + (double)PieChart.this.CircumLabelHeightOffsetInt + PieChart.this.PieRadius;
            this.startCircumX = Math.cos(d) * PieChart.this.PieRadius + d4;
            this.startCircumY = -Math.sin(d) * PieChart.this.PieRadius + d5;
            this.endCircumX = Math.cos(d2) * PieChart.this.PieRadius + d4;
            this.endCircumY = -Math.sin(d2) * PieChart.this.PieRadius + d5;
            this.midCircumX = Math.cos(d3) * PieChart.this.PieRadius + d4;
            this.midCircumY = -Math.sin(d3) * PieChart.this.PieRadius + d5;
        }

        public void computeShadowCircumference() {
            this.getShadowOffset();
            double d = this.getShadowDiameter() / 2.0;
            double d2 = (double)(PieChart.this.XOffset + PieChart.this.CircumLabelWidthOffsetInt) + PieChart.this.PieRadius + this.shadowOffsetPoint.x;
            double d3 = (double)(PieChart.this.YOffset + PieChart.this.CircumLabelHeightOffsetInt) + PieChart.this.PieRadius + this.shadowOffsetPoint.y;
            double d4 = Math.toRadians(this.getShadowStartAngle());
            double d5 = Math.toRadians(this.getShadowEndAngle());
            this.startCircumXShadow = Math.cos(d4) * d + d2;
            this.startCircumYShadow = -Math.sin(d4) * d + d3;
            this.endCircumXShadow = Math.cos(d5) * d + d2;
            this.endCircumYShadow = -Math.sin(d5) * d + d3;
        }

        double getVanishOffsetX() {
            double d = Math.cos(this.extrusionAngleRad) * PieChart.this.PieRadius * this.vanishConstant;
            return d;
        }

        double getVanishOffsetY() {
            double d = -Math.sin(this.extrusionAngleRad) * PieChart.this.PieRadius * this.vanishConstant;
            return d;
        }

        public Point2D.Double getVanishPoint() {
            double d = Math.cos(this.extrusionAngleRad) * PieChart.this.PieRadius;
            double d2 = -Math.sin(this.extrusionAngleRad) * PieChart.this.PieRadius;
            this.vanishPoint.x = this.midCircumX + this.getVanishOffsetX();
            this.vanishPoint.y = this.midCircumY + this.getVanishOffsetY();
            return this.vanishPoint;
        }

        public double getVanishLength() {
            double d = this.getVanishOffsetX();
            double d2 = this.getVanishOffsetY();
            return Math.sqrt(d * d + d2 * d2);
        }

        public double getShadowDiameter() {
            double d = PieChart.this.PieRadius * this.extrusionThickness;
            double d2 = this.getVanishLength();
            return (d2 - d) / d2 * (double)PieChart.this.PieDiameter;
        }

        public boolean isShadow(double d, double d2, double d3) {
            double d4 = PieChart.this.getNormalizedAngle(d + d3 / 2.0);
            if (PieChart.this.E3D.oneSliceShadow(d, d2, d3)) {
                return true;
            }
            return PieChart.this.E3D.inShadow(d) || PieChart.this.E3D.inShadow(d2) || PieChart.this.E3D.inShadow(d4);
        }
    }

    private final class StoredLayout {
        public PieLayout pl;
        public boolean isMulti;
        public String label;
        public Vector SliceLabelLines;
        public boolean interiorLabel;

        private StoredLayout() {
        }
    }

    private final class PieLayout {
        double x1;
        double y1;
        double x2;
        double y2;
        double score = -1.0;
        double separationTop;
        double separationBottom;
        double separationTopEvaluate;
        double separationBottomEvaluate;
        final double almostZero = 0.001;
        public double labelWidthNormalized;
        public double labelHeightNormalized;
        public double x_cir;
        public double y_cir;
        double angleMidRad;

        public double getX() {
            return this.x1;
        }

        public double getY() {
            return this.y1;
        }

        public double getWidth() {
            return this.x2 - this.x1;
        }

        public double getHeight() {
            return this.y2 - this.y1;
        }

        public double getXTr() {
            return this.x1 + 1.0;
        }

        public double getYTr() {
            return 1.0 - this.y2;
        }

        private void offsetCircumference(double d) {
            System.out.println("");
            System.out.println("  offsetCircumference ");
            double d2 = Math.sin(d);
            double d3 = Math.cos(d);
            double d4 = d3 - this.x_cir;
            double d5 = d2 - this.y_cir;
            System.out.println("xdelta " + d4);
            System.out.println("ydelta " + d5);
            this.x1 += d4;
            this.y1 += d5;
        }

        private void placeCircumference(double d, double d2, double d3, double d4) {
            double d5;
            double d6;
            boolean bl = false;
            this.labelWidthNormalized = d3;
            this.labelHeightNormalized = d4;
            if (bl) {
                System.out.println("");
                System.out.println("  placeCircumference " + d + " " + d2);
                System.out.println("  placeCircumference " + d3 + " " + d4);
            }
            double d7 = Math.toRadians(d);
            double d8 = Math.toRadians(d2);
            this.angleMidRad = d7 + d8 / 2.0;
            double d9 = Math.sin(this.angleMidRad);
            this.x_cir = d6 = Math.cos(this.angleMidRad);
            this.y_cir = d9;
            double d10 = d9;
            double d11 = d6;
            d6 *= 1.0 + d3 * 0.65;
            d9 *= 1.0 + d4 * 0.9;
            d11 *= 1.0 + d3 * 0.9;
            d10 *= 1.0 + d4 * 0.9;
            PieStyleDesc cfr_ignored_0 = PieChart.this.StyleDesc;
            if (PieChart.this.StyleDesc.getStyleType() != 0 && PieChart.this.E3D.inShadow(d5 = d + d2 / 2.0)) {
                Point2D.Double double_ = PieChart.this.E3D.getShadowOffsetNormalized();
                d6 += double_.x;
                d9 -= double_.y;
            }
            this.x1 = d6;
            this.x1 = d6 + d4 * 0.1;
            this.y1 = d9 + d4 * 0.65;
            this.x2 = this.x1;
            this.y2 = this.y1;
            if (PieChart.this.xMinTextNormalized > this.x1) {
                PieChart.this.xMinTextNormalized = this.x1;
            }
            if (PieChart.this.yMinTextNormalized > this.y1) {
                PieChart.this.yMinTextNormalized = this.y1;
            }
            if (PieChart.this.xMaxTextNormalized < this.x1) {
                PieChart.this.xMaxTextNormalized = this.x1;
            }
            if (PieChart.this.yMaxTextNormalized < this.y1) {
                PieChart.this.yMaxTextNormalized = this.y1;
            }
            if (PieChart.this.xMinNormalized > d11) {
                PieChart.this.xMinNormalized = d11;
            }
            if (PieChart.this.yMinNormalized > d10) {
                PieChart.this.yMinNormalized = d10;
            }
            if (PieChart.this.xMaxNormalized < d11) {
                PieChart.this.xMaxNormalized = d11;
            }
            if (PieChart.this.yMaxNormalized < d10) {
                PieChart.this.yMaxNormalized = d10;
            }
        }

        public int getQuadDistance(double d, double d2) {
            int n;
            int n2 = PieChart.this.getQuadNumber(d);
            if (n2 == (n = PieChart.this.getQuadNumber(d2))) {
                return 0;
            }
            if (Math.abs(n2 - n) == 1) {
                return 1;
            }
            if (n2 == 4 && n == 1) {
                return 1;
            }
            if (n2 == 1 && n == 4) {
                return 1;
            }
            return 2;
        }

        public boolean deriveRect360(double d, double d2, double d3, double d4) {
            boolean bl = false;
            double d5 = d + d2;
            d5 = PieChart.this.getNormalizedAngle(d5);
            d = PieChart.this.getNormalizedAngle(d);
            boolean bl2 = false;
            double d6 = Math.toRadians(d);
            double d7 = Math.toRadians(d5);
            if (d2 >= 360.0) {
                double d8 = 0.0;
                this.y1 = d8 - d4 / 2.0;
                this.y2 = this.y1 + d4;
                this.x1 = -this.getCircleIntersect(this.y2);
                this.x2 = -this.x1;
                return d3 < this.x2 - this.x1;
            }
            if (PieChart.this.openTopHemisphere(d, d5)) {
                double d9 = 0.4;
                this.y1 = d9 - d4 / 2.0;
                this.y2 = this.y1 + d4;
                this.x1 = -this.getCircleIntersect(this.y2);
                this.x2 = -this.x1;
            } else if (PieChart.this.openBottomHemisphere(d, d5)) {
                double d10 = -0.4;
                this.y1 = d10 - d4 / 2.0;
                this.y2 = this.y1 + d4;
                this.x1 = -this.getCircleIntersect(this.y1);
                this.x2 = -this.x1;
            } else {
                int n = 15;
                if (d > (double)(90 - n) && d < (double)(90 + n) && d5 > (double)(270 - n) && d5 < (double)(270 + n)) {
                    double d11 = 0.0;
                    this.y1 = d11 - d4 / 2.0;
                    this.y2 = this.y1 + d4;
                    this.x1 = -this.getCircleIntersect(this.y1);
                    this.x2 = 0.0;
                    return d3 < this.x2 - this.x1;
                }
                if (d > (double)(270 - n) && d < (double)(270 + n) && d5 > (double)(90 - n) && d5 < (double)(90 + n)) {
                    double d12 = 0.0;
                    this.y1 = d12 - d4 / 2.0;
                    this.y2 = this.y1 + d4;
                    this.x1 = 0.0;
                    this.x2 = this.getCircleIntersect(this.y2);
                    return d3 < this.x2 - this.x1;
                }
                if (d < 180.0) {
                    double d13 = 180.0 - d;
                    double d14 = d5 - 180.0;
                    if (d13 > d14) {
                        double d15 = 0.4;
                        this.y1 = d15 - d4 / 2.0;
                        this.y2 = this.y1 + d4;
                        this.x1 = -this.getCircleIntersect(this.y2);
                        this.x2 = Math.min(this.getXLineIntersect(this.y1, d6), this.getCircleIntersect(this.y2));
                    } else {
                        double d16 = -0.4;
                        this.y1 = d16 - d4 / 2.0;
                        this.y2 = this.y1 + d4;
                        this.x1 = -this.getCircleIntersect(this.y1);
                        this.x2 = Math.min(this.getXLineIntersect(this.y2, d7), this.getCircleIntersect(this.y1));
                    }
                } else {
                    double d17 = d5;
                    double d18 = 360.0 - d;
                    if (d17 > d18) {
                        double d19 = 0.4;
                        this.y1 = d19 - d4 / 2.0;
                        this.y2 = this.y1 + d4;
                        this.x1 = Math.max(this.getXLineIntersect(this.y1, d7), -this.getCircleIntersect(this.y2));
                        this.x2 = this.getCircleIntersect(this.y2);
                    } else {
                        double d20 = -0.4;
                        this.y1 = d20 - d4 / 2.0;
                        this.y2 = this.y1 + d4;
                        this.x1 = Math.max(this.getXLineIntersect(this.y2, d6), -this.getCircleIntersect(this.y1));
                        this.x2 = this.getCircleIntersect(this.y1);
                    }
                }
            }
            return d3 < this.x2 - this.x1;
        }

        public boolean deriveRect180(double d, double d2, double d3, double d4, Vector vector) {
            boolean bl = false;
            double d5 = d + d2;
            d5 = PieChart.this.getNormalizedAngle(d5);
            d = PieChart.this.getNormalizedAngle(d);
            double d6 = d5;
            double d7 = d;
            double d8 = 77.0;
            boolean bl2 = false;
            boolean bl3 = false;
            double d9 = 0.0;
            double d10 = 0.0;
            PieChart.this.test = false;
            if (PieChart.this.inQuad1(d) && PieChart.this.inQuad2(d5) || PieChart.this.inQuad4(d) && PieChart.this.inQuad1(d5) || PieChart.this.inQuad4(d) && PieChart.this.inQuad2(d5)) {
                d9 = Math.toRadians(d);
                d10 = Math.toRadians(d5);
            } else if (PieChart.this.inQuad3(d) && PieChart.this.inQuad4(d5) || PieChart.this.inQuad3(d) && PieChart.this.inQuad1(d5)) {
                d9 = this.mirrorAngleXAxis(d5);
                d10 = this.mirrorAngleXAxis(d);
                bl2 = true;
            } else if (PieChart.this.inQuad1(d) && PieChart.this.inQuad3(d5) || PieChart.this.inQuad2(d) && PieChart.this.inQuad3(d5)) {
                bl3 = true;
                d9 = this.mirrorAngleYAxis(d5);
                d10 = this.mirrorAngleYAxis(d);
            } else if (PieChart.this.inQuad2(d) && PieChart.this.inQuad4(d5)) {
                d9 = this.mirrorAngleXYAxis(d);
                d10 = this.mirrorAngleXYAxis(d5);
                bl3 = true;
                bl2 = true;
            }
            bl = this.straddleQuadLayout(d9, d10, d3, d4, 0.0, bl2, vector);
            if (this.score >= 0.0) {
                this.improveScoreIterate(d9, d10, d3, d4, vector, bl2);
            }
            if (bl3 || bl2) {
                if (bl3 && bl2) {
                    this.mirrorCoordXYAxis();
                } else if (bl3) {
                    this.mirrorCoordYAxis();
                } else if (bl2) {
                    this.mirrorCoordXAxis();
                }
            }
            return bl;
        }

        private boolean straddleQuadLayout(double d, double d2, double d3, double d4, double d5, boolean bl, Vector vector) {
            double d6;
            boolean bl2 = false;
            if (bl2) {
                System.out.println("");
                System.out.println("straddleQuad start/end  " + Math.toDegrees(d) + "," + Math.toDegrees(d2) + " @@@");
            }
            double d7 = (Math.sin(d) + Math.sin(d2)) / 2.0;
            double d8 = Math.sin(d);
            double d9 = Math.sin(d2);
            this.y1 = d7 - d4 / 2.0;
            this.y2 = this.y1 + d4;
            double d10 = this.y1 < 0.0 ? this.getLeftEdge2(this.y1, d) : this.getLeftEdge2(this.y1, d2);
            double d11 = this.y2 < 0.0 ? this.getLeftEdge2(this.y2, d) : this.getLeftEdge2(this.y2, d2);
            this.x1 = Math.max(d10, d11);
            this.x2 = Math.min(this.getRightEdge2(this.y1, d), this.getRightEdge2(this.y2, d));
            if (bl2) {
                System.out.println("StraddleQuad y1/y2/x1/x2 (" + this.y1 + "," + this.y2 + "," + this.x1 + "," + this.x2 + ")");
            }
            this.score = this.computeScore(this.x1, this.x2, this.y1, this.y2, d, d2, d3, d4, vector, bl);
            this.separationTop = this.separationTopEvaluate;
            this.separationBottom = this.separationBottomEvaluate;
            if (bl2) {
                System.out.println("StraddleQuad sep " + this.separationTop + " " + this.separationBottom);
                System.out.println("* initial score is " + this.score);
            }
            if (this.score >= 0.0) {
                return true;
            }
            double d12 = this.getCircleIntersect(this.x1);
            double d13 = Math.min(d12, d6 = this.getCircleIntersect(this.x2));
            double d14 = d13 - d4;
            if (d14 >= -1.0 && d13 < 1.0) {
                this.assignScore(d14, d13, d, d2, d3, d4, vector, bl);
            }
            if (this.score >= 0.0) {
                this.separationTop = this.separationTopEvaluate;
                this.separationBottom = this.separationBottomEvaluate;
                return true;
            }
            d13 = Math.max(d8, d9) + d4 / 2.0;
            d14 = d13 - d4;
            if (d14 >= -1.0 && d13 < 1.0) {
                this.assignScore(d14, d13, d, d2, d3, d4, vector, bl);
            }
            if (this.score >= 0.0) {
                this.separationTop = this.separationTopEvaluate;
                this.separationBottom = this.separationBottomEvaluate;
                return true;
            }
            if (this.score >= 0.0) {
                this.separationTop = this.separationTopEvaluate;
                this.separationBottom = this.separationBottomEvaluate;
                return true;
            }
            d13 = Math.min(d8, d9) + d4 / 2.0;
            d14 = d13 - d4;
            if (d14 >= -1.0 && d13 < 1.0) {
                this.assignScore(d14, d13, d, d2, d3, d4, vector, bl);
            }
            if (this.score >= 0.0) {
                this.separationTop = this.separationTopEvaluate;
                this.separationBottom = this.separationBottomEvaluate;
                return true;
            }
            d14 = Math.max(d8, d9);
            d13 = d14 + d4;
            if (d14 >= -1.0 && d13 < 1.0) {
                this.assignScore(d14, d13, d, d2, d3, d4, vector, bl);
            }
            if (this.score >= 0.0) {
                this.separationTop = this.separationTopEvaluate;
                this.separationBottom = this.separationBottomEvaluate;
                return true;
            }
            d14 = Math.min(d8, d9);
            d13 = d14 + d4;
            if (d14 >= -1.0 && d13 < 1.0) {
                this.assignScore(d14, d13, d, d2, d3, d4, vector, bl);
            }
            if (bl2) {
                System.out.println("final score is " + this.score);
                System.out.println("y1 y2 " + this.y1 + " " + this.y2);
                System.out.println("x1 x2 " + this.x1 + " " + this.x2);
            }
            if (this.score >= 0.0) {
                this.separationTop = this.separationTopEvaluate;
                this.separationBottom = this.separationBottomEvaluate;
                return true;
            }
            return false;
        }

        void assignScore(double d, double d2, double d3, double d4, double d5, double d6, Vector vector, boolean bl) {
            double d7;
            double d8 = Math.max(this.getLeftEdge2(d, d4), this.getLeftEdge2(d2, d4));
            double d9 = this.computeScore(d8, d7 = Math.min(this.getRightEdge2(d, d3), this.getRightEdge2(d2, d3)), d, d2, d3, d4, d5, d6, vector, bl);
            if (d9 > this.score) {
                this.score = d9;
                this.x1 = d8;
                this.x2 = d7;
                this.y1 = d;
                this.y2 = d2;
            }
        }

        void computeRectXCoords(double d, double d2, double d3, double d4) {
            double d5 = this.getLeftEdge(d, d2, d4);
            double d6 = this.getRightEdge(d, d2, d3);
            if (d6 - d5 > this.x2 - this.x1) {
                this.x1 = d5;
                this.x2 = d6;
                this.y1 = d;
                this.y2 = d2;
            }
        }

        void assign(double d, double d2, double d3, double d4) {
            this.x1 = d;
            this.x2 = d2;
            this.y1 = d3;
            this.y2 = d4;
        }

        double getLeftEdge(double d, double d2, double d3) {
            if (d2 > 1.0) {
                return 0.0;
            }
            if (d < 0.0) {
                return 0.0;
            }
            double d4 = this.getXLineIntersect(d, d3);
            double d5 = this.getXLineIntersect(d2, d3);
            double d6 = -this.getCircleIntersect(d2);
            double d7 = Math.max(d4, d6);
            d7 = Math.max(d5, d7);
            return d7;
        }

        double getRightEdge(double d, double d2, double d3) {
            double d4;
            if (d < 0.0) {
                return 0.0;
            }
            if (d2 > 1.0) {
                return 0.0;
            }
            double d5 = this.getXLineIntersect(d, d3);
            double d6 = this.getXLineIntersect(d, d3);
            double d7 = d4 = this.getCircleIntersect(d2);
            if (d5 >= 0.0) {
                d7 = Math.min(d5, d4);
            }
            if (d6 >= 0.0) {
                d7 = Math.min(d6, d7);
            }
            return d7;
        }

        private void mirrorCoordYAxis() {
            double d = this.x1;
            this.x1 = -this.x2;
            this.x2 = -d;
        }

        private void mirrorCoordXAxis() {
            double d = this.y1;
            this.y1 = -this.y2;
            this.y2 = -d;
        }

        private void mirrorCoordXYAxis() {
            this.mirrorCoordXAxis();
            this.mirrorCoordYAxis();
        }

        private double mirrorAngleYAxis(double d) {
            double d2 = 180.0 - d;
            if (d2 < 0.0) {
                d2 += 360.0;
            }
            return Math.toRadians(d2);
        }

        private double mirrorAngleXAxis(double d) {
            double d2 = 360.0 - d;
            if (d2 < 0.0) {
                d2 += 360.0;
            }
            return Math.toRadians(d2);
        }

        private double mirrorAngleXYAxis(double d) {
            double d2 = 180.0 + d;
            if (d2 > 360.0) {
                d2 -= 360.0;
            }
            return Math.toRadians(d2);
        }

        public double getXLineIntersect(double d, double d2) {
            if (Math.abs(Math.sin(d2)) < 0.001) {
                return Math.cos(d2);
            }
            double d3 = d / Math.tan(d2);
            return d3;
        }

        public double getYLineIntersect(double d, double d2) {
            if (Math.abs(Math.cos(d2)) < 0.001) {
                return Math.sin(d2);
            }
            double d3 = d * Math.tan(d2);
            return d3;
        }

        public void swapy1y2() {
            double d = this.y1;
            this.y1 = this.y2;
            this.y2 = d;
        }

        public boolean deriveRect90(double d, double d2, double d3, double d4, double d5, Vector vector) {
            boolean bl = false;
            double d6 = d + d2;
            d6 = PieChart.this.getNormalizedAngle(d6);
            d = PieChart.this.getNormalizedAngle(d);
            d3 = PieChart.this.getNormalizedAngle(d3);
            double d7 = Math.toRadians(d);
            double d8 = Math.toRadians(d6);
            double d9 = Math.toRadians(d3);
            boolean bl2 = false;
            boolean bl3 = false;
            double d10 = 0.0;
            double d11 = 0.0;
            if (PieChart.this.inQuad1(d6)) {
                d10 = d7;
                d11 = d8;
                bl = this.place90(d7, d8, d4, d5, vector, bl2);
            } else if (PieChart.this.inQuad3(d6)) {
                bl2 = true;
                bl3 = true;
                d10 = this.mirrorAngleXYAxis(d);
                d11 = this.mirrorAngleXYAxis(d6);
                bl = this.place90(d10, d11, d4, d5, vector, bl2);
            } else if (PieChart.this.inQuad2(d6)) {
                bl3 = true;
                d10 = this.mirrorAngleYAxis(d6);
                d11 = this.mirrorAngleYAxis(d);
                bl = this.place90(d10, d11, d4, d5, vector, bl2);
            } else if (PieChart.this.inQuad4(d6)) {
                bl2 = true;
                d10 = this.mirrorAngleXAxis(d6);
                d11 = this.mirrorAngleXAxis(d);
                bl = this.place90(d10, d11, d4, d5, vector, bl2);
            }
            if (bl) {
                this.improveScoreIterate(d10, d11, d4, d5, vector, bl2);
            }
            if (bl3 || bl2) {
                if (bl3 && bl2) {
                    this.mirrorCoordXYAxis();
                } else if (bl3) {
                    this.mirrorCoordYAxis();
                } else if (bl2) {
                    this.mirrorCoordXAxis();
                }
            }
            return bl;
        }

        boolean place90(double d, double d2, double d3, double d4, Vector vector, boolean bl) {
            boolean bl2 = false;
            double d5 = Math.sin(d2);
            double d6 = Math.sin(d);
            double d7 = (d5 + d6) / 2.0;
            this.score = -1.0;
            this.y1 = d7 - d4 / 2.0;
            this.y2 = this.y1 + d4;
            if (Math.abs(this.y1) < 1.0 && Math.abs(this.y2) < 1.0) {
                double d8 = this.y1 < 0.0 ? this.getLeftEdge2(this.y1, d) : this.getLeftEdge2(this.y1, d2);
                double d9 = this.y2 < 0.0 ? this.getLeftEdge2(this.y2, d) : this.getLeftEdge2(this.y2, d2);
                this.x1 = Math.max(d8, d9);
                this.x2 = Math.min(this.getRightEdge2(this.y1, d), this.getRightEdge2(this.y2, d));
                this.score = this.computeScore(this.x1, this.x2, this.y1, this.y2, d, d2, d3, d4, vector, bl);
                this.separationTop = this.separationTopEvaluate;
                this.separationBottom = this.separationBottomEvaluate;
            }
            if (this.score >= 0.0) {
                return true;
            }
            d7 = (d5 + d6) / 2.0 + d4 / 4.0;
            double d10 = d7 - d4 / 2.0;
            double d11 = d10 + d4;
            this.guessY(d10, d11, d, d2, d3, d4, vector, bl);
            if (this.score >= 0.0) {
                return true;
            }
            d7 = (d5 + d6) / 2.0 - d4 / 4.0;
            d10 = d7 - d4 / 2.0;
            d11 = d10 + d4;
            this.guessY(d10, d11, d, d2, d3, d4, vector, bl);
            if (this.score >= 0.0) {
                return true;
            }
            d7 = (2.0 * d6 + d5) / 3.0;
            d10 = d7 - d4 / 2.0;
            d11 = d10 + d4;
            this.guessY(d10, d11, d, d2, d3, d4, vector, bl);
            if (this.score >= 0.0) {
                return true;
            }
            d7 = (d6 + 2.0 * d5) / 3.0;
            d10 = d7 - d4 / 2.0;
            d11 = d10 + d4;
            this.guessY(d10, d11, d, d2, d3, d4, vector, bl);
            if (this.score >= 0.0) {
                return true;
            }
            d11 = Math.max(d6, d5) + d4 / 2.0;
            d10 = d11 - d4;
            this.guessY(d10, d11, d, d2, d3, d4, vector, bl);
            if (this.score >= 0.0) {
                return true;
            }
            d11 = Math.min(d6, d5) + d4 / 2.0;
            d10 = d11 - d4;
            this.guessY(d10, d11, d, d2, d3, d4, vector, bl);
            if (this.score >= 0.0) {
                return true;
            }
            d10 = d6;
            d11 = d10 + d4;
            this.guessY(d10, d11, d, d2, d3, d4, vector, bl);
            if (this.score >= 0.0) {
                return true;
            }
            d11 = d6;
            d10 = d11 - d4;
            this.guessY(d10, d11, d, d2, d3, d4, vector, bl);
            if (this.score >= 0.0) {
                return true;
            }
            d10 = d5;
            d11 = d10 + d4;
            this.guessY(d10, d11, d, d2, d3, d4, vector, bl);
            if (this.score >= 0.0) {
                return true;
            }
            d11 = d5;
            d10 = d11 - d4;
            this.guessY(d10, d11, d, d2, d3, d4, vector, bl);
            if (this.score >= 0.0) {
                return true;
            }
            return this.score >= 0.0;
        }

        void guessY(double d, double d2, double d3, double d4, double d5, double d6, Vector vector, boolean bl) {
            double d7;
            double d8;
            double d9;
            double d10;
            double d11 = -1.0;
            if (Math.abs(d) < 1.0 && Math.abs(d2) < 1.0 && (d11 = this.computeScore(d10 = Math.max(d9 = d < 0.0 ? this.getLeftEdge2(d, d3) : this.getLeftEdge2(d, d4), d8 = d2 < 0.0 ? this.getLeftEdge2(d2, d3) : this.getLeftEdge2(d2, d4)), d7 = Math.min(this.getRightEdge2(d, d3), this.getRightEdge2(d2, d3)), d, d2, d3, d4, d5, d6, vector, bl)) > this.score) {
                this.separationTop = this.separationTopEvaluate;
                this.separationBottom = this.separationBottomEvaluate;
                this.assign(d10, d7, d, d2);
                this.score = d11;
            }
        }

        void improveScoreIterate(double d, double d2, double d3, double d4, Vector vector, boolean bl) {
            boolean bl2 = false;
            if (bl2) {
                System.out.println();
            }
            if (bl2) {
                System.out.println("*** Improving Score *** ");
            }
            if (bl2) {
                System.out.println();
            }
            double d5 = this.score;
            this.improveScore(0.9, d, d2, d3, d4, vector, bl);
            this.improveScore(0.7, d, d2, d3, d4, vector, bl);
            this.improveScore(0.5, d, d2, d3, d4, vector, bl);
            this.improveScore(0.3, d, d2, d3, d4, vector, bl);
            if (bl2 && this.score != d5) {
                System.out.println("Improved score " + d5 + " -> " + this.score);
            }
        }

        void improveScore(double d, double d2, double d3, double d4, double d5, Vector vector, boolean bl) {
            double d6 = (this.separationTop - this.separationBottom) / 2.0;
            boolean bl2 = false;
            if (bl2) {
                System.out.println("sep " + this.separationTop + " " + this.separationBottom);
            }
            if (bl2) {
                System.out.println("difference " + d6);
            }
            double d7 = this.score;
            double d8 = this.y1 + (d6 *= d);
            double d9 = this.y2 + d6;
            if (bl2) {
                System.out.println("improveScore: try y1b, y2b (" + d8 + "," + d9 + ")");
            }
            this.guessY(d8, d9, d2, d3, d4, d5, vector, bl);
        }

        double computeScore(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, Vector vector, boolean bl) {
            double d9;
            double d10;
            double d11;
            double d12;
            double d13;
            double d14 = Math.toDegrees(d5);
            double d15 = Math.toDegrees(d6);
            double d16 = -1.0;
            double d17 = 1.0;
            if (d14 < 90.0 || d14 >= 270.0) {
                d16 = Math.min(0.0, Math.sin(d5));
            }
            if (d15 < 90.0 || d15 >= 270.0) {
                d17 = Math.max(0.0, Math.sin(d6));
            }
            if (d3 < d16) {
                return -1.0;
            }
            if (d4 < d16) {
                return -1.0;
            }
            if (d3 > d17) {
                return -1.0;
            }
            if (d4 > d17) {
                return -1.0;
            }
            boolean bl2 = false;
            boolean bl3 = false;
            if (bl3) {
                System.out.println();
                System.out.println("compute score " + d14 + " % " + d15);
                System.out.println("x1 x2 y1 y2 " + d + " " + d2 + " " + d3 + " " + d4);
                if (PieChart.this.inQuad1(d14)) {
                    System.out.print("Start Q1 ");
                } else if (PieChart.this.inQuad2(d14)) {
                    System.out.print("Start Q2 ");
                } else if (PieChart.this.inQuad3(d14)) {
                    System.out.print("Start Q3 ");
                } else if (PieChart.this.inQuad4(d14)) {
                    System.out.print("Start Q4 ");
                }
                if (PieChart.this.inQuad1(d15)) {
                    System.out.println("End Q1");
                } else if (PieChart.this.inQuad2(d15)) {
                    System.out.println("End Q2");
                } else if (PieChart.this.inQuad3(d15)) {
                    System.out.println("End Q3");
                } else if (PieChart.this.inQuad4(d15)) {
                    System.out.println("End Q4 ");
                }
            }
            if (bl3) {
                System.out.println();
                System.out.println("computeScore: " + Math.toDegrees(d5) + ", " + Math.toDegrees(d6) + "| @@@");
            }
            if (vector == null) {
                d13 = (d + d2) / 2.0;
                d12 = d13 - d7 / 2.0;
                d11 = d13 + d7 / 2.0;
                d10 = d12;
                d9 = d11;
            } else {
                String string;
                String string2;
                int n = vector.size() - 1;
                if (!bl) {
                    string2 = (String)vector.elementAt(0);
                    string = (String)vector.elementAt(n);
                } else {
                    string2 = (String)vector.elementAt(n);
                    string = (String)vector.elementAt(0);
                }
                double d18 = (double)PieChart.this.fontmet.stringWidth(string2) / PieChart.this.PieRadius;
                double d19 = (double)PieChart.this.fontmet.stringWidth(string) / PieChart.this.PieRadius;
                double d20 = (d + d2) / 2.0;
                d12 = d20 - d18 / 2.0;
                d11 = d20 + d18 / 2.0;
                d10 = d20 - d19 / 2.0;
                d9 = d20 + d19 / 2.0;
            }
            if (bl3) {
                System.out.println(" x1  " + d + " x2 " + d2);
                System.out.println(" y1  " + d3 + " y2 " + d4);
                System.out.println(" " + d12 + " " + d11 + " " + d10 + " " + d9);
            }
            d13 = this.getCircleIntersect(d3);
            double d21 = 0.0;
            double d22 = -this.getCircleIntersect(d11);
            double d23 = 0.0;
            double d24 = -d13;
            double d25 = 0.0;
            double d26 = -this.getCircleIntersect(d12);
            double d27 = 0.0;
            double d28 = this.getCircleIntersect(d4);
            double d29 = 0.0;
            double d30 = this.getCircleIntersect(d9);
            double d31 = 0.0;
            double d32 = -d28;
            double d33 = 0.0;
            double d34 = this.getCircleIntersect(d10);
            double d35 = 0.0;
            if (PieChart.this.inQuad1(d14)) {
                d13 = this.getRightEdge2(d3, d5);
                d22 = this.getBottomEdge2(d11, d5);
                d26 = this.getBottomEdge2(d12, d5);
            } else if (PieChart.this.inQuad4(d14)) {
                d26 = this.getBottomEdge2(d12, d5);
                d24 = this.getLeftEdge2(d3, d5);
            }
            if (PieChart.this.inQuad1(d15) || PieChart.this.inQuad4(d15)) {
                if (d3 > 0.0) {
                    d24 = this.getLeftEdge2(d3, d6);
                }
                if (d4 > 0.0) {
                    d32 = this.getLeftEdge2(d4, d6);
                }
                d32 = this.getLeftEdge2(d4, d6);
                d34 = this.getTopEdge2(d10, d6);
            } else if (PieChart.this.inQuad2(d15) || PieChart.this.inQuad3(d15)) {
                if (!PieChart.this.inQuad4(d14)) {
                    d24 = this.getLeftEdge2(d3, d6);
                }
                if (d11 <= 0.0) {
                    d22 = this.getBottomEdge2(d11, d6);
                }
                if (d12 <= 0.0) {
                    d26 = this.getBottomEdge2(d12, d6);
                }
                if (d4 > 0.0) {
                    d32 = this.getLeftEdge2(d4, d6);
                }
                if (d3 > 0.0) {
                    d24 = this.getLeftEdge2(d3, d6);
                }
            } else {
                System.out.println("*** NO QUAD angle End *** ");
            }
            if (bl3) {
                System.out.println("XRightBottom " + d13);
                System.out.println("YRightBottom " + d22);
                System.out.println("XLeftBottom " + d24);
                System.out.println("YLeftBottom " + d26);
                System.out.println("XRightTop " + d28);
                System.out.println("YRightTop " + d30);
                System.out.println("XLeftTop " + d32);
                System.out.println("YLeftTop " + d34);
            }
            d25 = d12 - d24;
            d21 = d13 - d9;
            d27 = d3 - d26;
            d23 = d3 - d22;
            d33 = d12 - d32;
            d29 = d28 - d9;
            d35 = d34 - d4;
            d31 = d30 - d4;
            if (bl3) {
                System.out.println("XRightBottomDelta " + d21);
                System.out.println("XLeftBottomDelta " + d25);
                System.out.println("YRightBottomDelta " + d23);
                System.out.println("YLeftBottomDelta " + d27);
                System.out.println("XRightTopDelta " + d29);
                System.out.println("XLeftTopDelta " + d33);
                System.out.println("YRightTopDelta " + d31);
                System.out.println("YLeftTopDelta " + d35);
            }
            double d36 = Math.min(d33, d25);
            double d37 = Math.min(d29, d21);
            double d38 = Math.min(d27, d23);
            double d39 = Math.min(d35, d31);
            double d40 = Math.min(d37, d36);
            double d41 = Math.min(d39, d38);
            if (PieChart.this.testPlace90) {
                System.out.println("left, right XDelta [" + d36 + " , " + d37 + "]");
                System.out.println("bottom, top YDelta [" + d38 + " , " + d39 + "]");
            }
            this.separationTopEvaluate = d39;
            this.separationBottomEvaluate = d38;
            return Math.min(d40, d41);
        }

        double getRightEdge2(double d, double d2) {
            double d3 = this.getCircleIntersect(d);
            double d4 = Math.toDegrees(d2);
            if (!(d4 <= 90.0) || !(d4 > 0.0)) {
                return d3;
            }
            double d5 = this.getXLineIntersect(d, d2);
            if (PieChart.this.test2) {
                System.out.println("XRightCirc " + d3);
                System.out.println("XRightLine " + d5);
            }
            double d6 = Math.min(d3, d5);
            return d6;
        }

        double getCornerIntersect(double d, double d2, double d3) {
            if (Math.abs(Math.cos(d3)) < 0.001) {
                return 1.0;
            }
            if (Math.abs(Math.sin(d3)) < 0.001) {
                return 1.0;
            }
            double d4 = Math.sin(d3) / Math.cos(d3);
            double d5 = Math.cos(d3) / Math.sin(d3);
            double d6 = d2 - d5 * d;
            double d7 = -d6 / (d5 - d4);
            double d8 = d4 * d7;
            double d9 = Math.abs(d - d7) + Math.abs(d2 - d8);
            if (PieChart.this.test2) {
                System.out.println("getCornerIntersect " + d9);
            }
            return d9;
        }

        double getLeftCorner(double d, double d2, double d3) {
            double d4 = -this.getCircleIntersect(d2);
            double d5 = this.getXLineIntersect(d2, d3);
            if (PieChart.this.test2) {
                System.out.println("XLeftLine " + d5);
            }
            double d6 = Math.max(d4, d5);
            double d7 = this.getCornerIntersect(d, d2, d3);
            return d6;
        }

        double getCircleIntersect(double d) {
            double d2 = 0.0;
            d2 = Math.abs(d) >= 1.0 ? 0.0 : Math.sqrt(1.0 - d * d);
            return d2;
        }

        double getLeftEdge2(double d, double d2) {
            double d3 = -this.getCircleIntersect(d);
            double d4 = this.getXLineIntersect(d, d2);
            if (PieChart.this.test2) {
                System.out.println("XLeftLine " + d4 + " " + d3);
            }
            if (d4 == 1.0) {
                return d3;
            }
            double d5 = Math.max(d3, d4);
            return d5;
        }

        double getTopEdge2(double d, double d2) {
            double d3 = this.getCircleIntersect(d);
            double d4 = Math.toDegrees(d2);
            double d5 = this.getYLineIntersect(d, d2);
            double d6 = Math.min(d3, d5);
            return d6;
        }

        double getBottomEdge2(double d, double d2) {
            double d3 = -this.getCircleIntersect(d);
            double d4 = this.getYLineIntersect(d, d2);
            double d5 = Math.max(d3, d4);
            return d5;
        }
    }

    private final class ExternalLabelSpace {
        int space_top = 0;
        int space_bottom = 0;
        int space_left = 0;
        int space_right = 0;

        ExternalLabelSpace() {
        }

        public void init() {
        }
    }

    private final class LayoutScore {
        Vector LabelIntExt = new Vector();

        private LayoutScore() {
        }

        protected void dumpScore() {
            System.out.println();
            System.out.println("Internal/External Labeling");
            for (int i = 0; i < this.LabelIntExt.size(); ++i) {
                ScoreDesc scoreDesc = (ScoreDesc)this.LabelIntExt.elementAt(i);
                scoreDesc.dumpScoreDesc();
            }
        }

        protected boolean isDuplicateMask(boolean[] blArray) {
            for (int i = 0; i < this.LabelIntExt.size(); ++i) {
                ScoreDesc scoreDesc = (ScoreDesc)this.LabelIntExt.elementAt(i);
                if (!scoreDesc.equalMask(blArray)) continue;
                return true;
            }
            return false;
        }

        protected boolean isZeroMask(boolean[] blArray) {
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                return false;
            }
            return true;
        }

        protected boolean isAllOnesMask(boolean[] blArray) {
            for (int i = 0; i < blArray.length; ++i) {
                if (blArray[i]) continue;
                return false;
            }
            return true;
        }
    }

    private final class ScoreDesc {
        boolean[] IE;
        int space_top_needed = 0;
        int space_bottom_needed = 0;
        int space_left_needed = 0;
        int space_right_needed = 0;
        int space_top_available = 0;
        int space_bottom_available = 0;
        int space_left_available = 0;
        int space_right_available = 0;

        ScoreDesc() {
        }

        protected void init() {
            this.space_top_available = 0;
            this.space_bottom_available = 0;
            this.space_left_available = 0;
            this.space_right_available = 0;
            this.space_top_needed = 0;
            this.space_bottom_needed = 0;
            this.space_left_needed = 0;
            this.space_right_needed = 0;
        }

        protected boolean equalMask(boolean[] blArray) {
            if (this.IE.length != blArray.length) {
                return false;
            }
            for (int i = 0; i < blArray.length; ++i) {
                if (this.IE[i] == blArray[i]) continue;
                return false;
            }
            return true;
        }

        protected void initSpaceNeeded() {
            this.space_top_needed = 0;
            this.space_bottom_needed = 0;
            this.space_left_needed = 0;
            this.space_right_needed = 0;
        }

        protected void setTopSpaceNeeded(int n) {
            if (n > this.space_top_needed) {
                this.space_top_needed = n;
            }
        }

        protected void setBottomSpaceNeeded(int n) {
            if (n > this.space_bottom_needed) {
                this.space_bottom_needed = n;
            }
        }

        protected void setLeftSpaceNeeded(int n) {
            if (n > this.space_left_needed) {
                this.space_left_needed = n;
            }
        }

        protected void setRightSpaceNeeded(int n) {
            if (n > this.space_right_needed) {
                this.space_right_needed = n;
            }
        }

        protected void setTopSpaceAvailable(int n) {
            this.space_top_available = n;
        }

        protected void setBottomSpaceAvailable(int n) {
            this.space_bottom_available = n;
        }

        protected void setLeftSpaceAvailable(int n) {
            this.space_left_available = n;
        }

        protected void setRightSpaceAvailable(int n) {
            this.space_right_available = n;
        }

        protected void setMask(boolean[] blArray) {
            this.IE = new boolean[blArray.length];
            for (int i = 0; i < blArray.length; ++i) {
                this.IE[i] = blArray[i];
            }
        }

        void dumpScoreDesc() {
            for (int i = 0; i < this.IE.length; ++i) {
                if (this.IE[i]) {
                    System.out.print("1");
                    continue;
                }
                System.out.print("0");
            }
            System.out.println();
        }

        void dumpScoreDesc(boolean[] blArray) {
            boolean bl = true;
            for (int i = 0; i < blArray.length; ++i) {
                if (blArray[i]) {
                    System.out.print("1");
                    continue;
                }
                System.out.print("0");
            }
            System.out.println();
        }

        boolean enoughYSpace() {
            return this.space_top_available + this.space_bottom_available >= this.space_top_needed + this.space_bottom_needed;
        }

        boolean enoughXSpace() {
            return this.space_left_available + this.space_right_available >= this.space_left_needed + this.space_right_needed;
        }

        protected int getScore() {
            int n = 0;
            for (int i = 0; i < this.IE.length; ++i) {
                if (!this.IE[i]) continue;
                ++n;
            }
            if (n == 0) {
                return n;
            }
            if (this.space_top_available + this.space_bottom_available < this.space_top_needed + this.space_bottom_needed) {
                return -1;
            }
            return n;
        }
    }

    private final class PieSliceLabelLoc {
        public int x = -1;
        public int y = -1;
        public int w = -1;
        public int h = -1;
        int labelHeight = -1;
        int labelWidth = -1;
        int xoffset = 0;
        int yoffset = 0;

        PieSliceLabelLoc() {
        }

        public void drawStringSetLocSize(Graphics2D graphics2D, String string, int n, int n2, int n3, int n4) {
            graphics2D.drawString(string, n + this.xoffset, n2 + this.yoffset);
            this.setLocation(n + this.xoffset, n2 + this.yoffset - n4);
            this.w = n3;
            this.h = n4;
        }

        public void drawString(Graphics2D graphics2D, String string, int n, int n2) {
            graphics2D.drawString(string, n + this.xoffset, n2 + this.yoffset);
        }

        protected void setLocation(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        protected void setSize(int n, int n2) {
            this.w = n;
            this.h = n2;
        }

        protected boolean contains(int n, int n2) {
            int n3 = this.x + this.w;
            int n4 = this.y + this.h;
            return n >= this.x && n <= n3 && n2 >= this.y && n2 <= n4;
        }

        protected void drawLabel(String string) {
        }

        PieSliceLabelLoc(int n, int n2, int n3, int n4) {
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
        }
    }

    private final class PieSliceLabelOffset {
        PieSliceLabelOffset() {
        }
    }

    private final class PieSliceAngle {
        double startAngle = 0.0;
        double deltaAngle = 0.0;
        double startAngleCirLabel = 0.0;
        double deltaAngleCirLabel = 0.0;
        public String[] imageMap = new String[]{null, null};
        public int[] shadowX;
        public int[] shadowY;
        public double startCircumX;
        public double startCircumY;
        public double startCircumXExtra;
        public double startCircumYExtra;
        public double startCircumXTick;
        public double startCircumYTick;
        public double startCircumXInnerTick;
        public double startCircumYInnerTick;
        public double startCircumXInnerTick2;
        public double startCircumYInnerTick2;
        public double endCircumXTick;
        public double endCircumYTick;
        public double endCircumX;
        public double endCircumY;
        public double endCircumXExtra;
        public double endCircumYExtra;
        public double midCircumShadowX;
        public double midCircumShadowY;

        PieSliceAngle() {
        }

        public void setStartAngle(double d) {
            this.startAngle = d;
        }

        public void setDeltaAngle(double d) {
            this.deltaAngle = d;
        }
    }

    private final class CrescentAdjust {
        boolean testCrescent = false;
        public int Offset3D_Top = 0;
        public int Offset3D_Bottom = 0;
        public int Offset3D_Right = 0;
        public int Offset3D_Left = 0;
        public int maxHorzSpace_3DoffsetX = 0;
        public int maxVertSpace_3DoffsetY = 0;

        CrescentAdjust() {
        }

        public PieDim setAdjustPieDiameter(PieDim pieDim) {
            PieDim pieDim2 = new PieDim();
            PieStyleDesc cfr_ignored_0 = PieChart.this.StyleDesc;
            if (PieChart.this.StyleDesc.getStyleType() == 0) {
                return pieDim2;
            }
            double d = PieChart.this.E3D.getExtrusionThickness() / 2.0;
            double d2 = d * Math.abs(Math.cos(PieChart.this.E3D.getExtrusionAngleRad()));
            double d3 = d * Math.abs(Math.sin(PieChart.this.E3D.getExtrusionAngleRad()));
            pieDim2.width = (int)Math.round((double)pieDim.width / (1.0 + d2));
            pieDim2.height = (int)Math.round((double)pieDim.height / (1.0 + d3));
            this.maxHorzSpace_3DoffsetX = pieDim.width - pieDim2.width;
            this.maxVertSpace_3DoffsetY = pieDim.height - pieDim2.height;
            if (Math.sin(PieChart.this.E3D.getExtrusionAngleRad()) > 0.0) {
                this.Offset3D_Top = this.maxVertSpace_3DoffsetY;
            } else {
                this.Offset3D_Bottom = this.maxVertSpace_3DoffsetY;
            }
            if (Math.cos(PieChart.this.E3D.getExtrusionAngleRad()) > 0.0) {
                this.Offset3D_Right = this.maxHorzSpace_3DoffsetX;
            } else {
                this.Offset3D_Left = this.maxHorzSpace_3DoffsetX;
            }
            return pieDim2;
        }
    }

    private final class PieDim {
        public int width = 0;
        public int height = 0;

        PieDim() {
        }
    }
}

