/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.charts.internal;

import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import oracle.sdovis.charts.types.LabelDesc;

public final class LabelUtil2 {
    public static AttributedString getLabelAttributedString(LabelDesc labelDesc) {
        AttributedString attributedString = null;
        if (labelDesc.getTextAttributes() != null) {
            attributedString = new AttributedString(labelDesc.getText(), labelDesc.getTextAttributes());
        }
        return attributedString;
    }

    public static int getLabelWidth(LabelDesc labelDesc, FontRenderContext fontRenderContext) {
        int n = 0;
        if (labelDesc.getText() != null) {
            AttributedString attributedString = LabelUtil2.getLabelAttributedString(labelDesc);
            if (attributedString == null) {
                n = labelDesc.fontmet.stringWidth(labelDesc.getText());
            } else {
                TextLayout textLayout = new TextLayout(attributedString.getIterator(), fontRenderContext);
                n = (int)Math.round(textLayout.getBounds().getWidth());
            }
        }
        return n;
    }

    public static int getLabelHeight(LabelDesc labelDesc, FontRenderContext fontRenderContext) {
        int n = 0;
        if (labelDesc.getText() != null) {
            AttributedString attributedString = LabelUtil2.getLabelAttributedString(labelDesc);
            if (attributedString == null) {
                n = labelDesc.fontmet.getHeight();
            } else {
                TextLayout textLayout = new TextLayout(attributedString.getIterator(), fontRenderContext);
                n = Math.round(textLayout.getAscent() + textLayout.getDescent());
            }
        }
        return n;
    }
}

