/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.charts;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Locale;
import oracle.sdovis.charts.legend.Legend2;
import oracle.sdovis.charts.types.ChartException;
import oracle.sdovis.charts.types.LegendDesc;

public class Chart
extends Component {
    private boolean test = false;
    protected BufferedImage BI = null;
    protected RenderingHints RH = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    protected boolean renderingHintsSet = false;
    protected Legend2 L2 = new Legend2();
    protected Locale ChartLocale = Locale.getDefault();
    protected int border_topbottom_default = 20;
    private int border_bottom = 20;
    private int border_top = 20;
    private int border_left = 10;
    protected int border_right_default;
    private int border_right = this.border_right_default = 10;
    private int border_vert;
    private int border_horz;
    private boolean borderLeftSet = false;
    private boolean borderRightSet = false;
    private boolean borderBottomSet = false;
    private boolean borderTopSet = false;
    private int TotalDisplay_height = 200;
    private int TotalDisplay_width = 300;
    private int lastTotalDisplay_height = 0;
    private int lastTotalDisplay_width = 0;
    Color background = new Color(200, 200, 240);
    Color EdgeColor = Color.black;
    protected int width = 200;
    protected int height = 100;
    private Font titleFont = new Font("sansserif", 1, 14);
    protected ChartLabel t = new ChartLabel("", 4, this.titleFont, 1.8, 1.3);
    private Font subTitleFont = new Font("sansserif", 0, 11);
    protected ChartLabel subt = new ChartLabel("", 4, this.subTitleFont, 1.5, 0.5);
    private Font footnoteFont = new Font("sansserif", 0, 10);
    protected ChartLabel foot = new ChartLabel("", 0, this.footnoteFont, 1.0, 1.0);
    boolean isPieChart = false;

    protected Color getDarkerColor(Color color) {
        Color color2 = color.darker();
        int n = color2.getRed();
        int n2 = color2.getGreen();
        int n3 = color2.getBlue();
        int n4 = color.getAlpha();
        return new Color(n, n2, n3, n4);
    }

    public void setChartAttributes(LegendDesc legendDesc) throws ChartException {
        this.L2.setLegendDesc(legendDesc);
    }

    public void setRenderingHintsChart(RenderingHints renderingHints) {
        this.RH = renderingHints;
        this.renderingHintsSet = true;
    }

    public RenderingHints getRenderingHintsChart() {
        return this.RH;
    }

    public boolean isSetRenderingHintsChart() {
        return this.renderingHintsSet;
    }

    protected String getFontStyle(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "Font.BOLD";
                break;
            }
            case 2: {
                string = "Font.ITALIC";
                break;
            }
            case 0: {
                string = "Font.PLAIN";
            }
        }
        return string;
    }

    protected String emitFont(Font font) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("setFont(new java.awt.Font(\"");
        stringBuffer.append(font.getName());
        stringBuffer.append("\", ");
        int n = font.getStyle();
        String string = this.getFontStyle(n);
        if (string != null) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(n);
        }
        stringBuffer.append(", ");
        stringBuffer.append(font.getSize());
        stringBuffer.append("));\n");
        return stringBuffer.toString();
    }

    protected String emitTitle() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getTitle().getText() != "") {
            stringBuffer.append("// Title \n");
            stringBuffer.append("chs.getTitle().setText(\"");
            stringBuffer.append(this.getTitle().getText());
            stringBuffer.append("\");\n");
            stringBuffer.append("chs.getTitle().");
            stringBuffer.append(this.emitFont(this.getTitle().getFont()));
        }
        if (this.getSubtitle().getText() != "") {
            stringBuffer.append("// Subtitle \n");
            stringBuffer.append("chs.getSubtitle().setText(\"");
            stringBuffer.append(this.getSubtitle().getText());
            stringBuffer.append("\");\n");
            stringBuffer.append("chs.getSubtitle().");
            stringBuffer.append(this.emitFont(this.getSubtitle().getFont()));
        }
        if (this.getFootnote().getText() != "") {
            stringBuffer.append("// Footnote \n");
            stringBuffer.append("chs.getFootnote().setText(\"");
            stringBuffer.append(this.getFootnote().getText());
            stringBuffer.append("\");\n");
            stringBuffer.append("chs.getFootnote().");
            stringBuffer.append(this.emitFont(this.getFootnote().getFont()));
        }
        return stringBuffer.toString();
    }

    protected String emitBackground() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("chs.setBackground(");
        stringBuffer.append(this.emitNewColor(this.getBackground()));
        stringBuffer.append(");\n");
        return stringBuffer.toString();
    }

    protected String emitEdgeColor() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("chs.setEdgeColor(");
        stringBuffer.append(this.emitNewColor(this.getEdgeColor()));
        stringBuffer.append(");\n");
        return stringBuffer.toString();
    }

    protected String emitNewColor(Color color) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("new java.awt.Color(");
        stringBuffer.append(color.getRed());
        stringBuffer.append(",");
        stringBuffer.append(color.getGreen());
        stringBuffer.append(",");
        stringBuffer.append(color.getBlue());
        stringBuffer.append(",");
        stringBuffer.append(color.getAlpha());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected String emitSize() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("chs.setSize(");
        stringBuffer.append(this.getWidth());
        stringBuffer.append(",");
        stringBuffer.append(this.getHeight());
        stringBuffer.append(");\n");
        return stringBuffer.toString();
    }

    protected String emitBorders() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isBorderTopSet()) {
            stringBuffer.append("chs.setBorderTop(");
            stringBuffer.append(this.getBorderTop());
            stringBuffer.append(");\n");
        }
        if (this.isBorderBottomSet()) {
            stringBuffer.append("chs.setBorderBottom(");
            stringBuffer.append(this.getBorderBottom());
            stringBuffer.append(");\n");
        }
        if (this.isBorderRightSet()) {
            stringBuffer.append("chs.setBorderRight(");
            stringBuffer.append(this.getBorderRight());
            stringBuffer.append(");\n");
        }
        if (this.isBorderLeftSet()) {
            stringBuffer.append("chs.setBorderLeft(");
            stringBuffer.append(this.getBorderLeft());
            stringBuffer.append(");\n");
        }
        return stringBuffer.toString();
    }

    protected String emitVersion() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: ");
        stringBuffer.append(Chart.getVersion());
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    protected void initBorderFlags() {
        this.borderLeftSet = false;
        this.borderRightSet = false;
        this.borderBottomSet = false;
        this.borderTopSet = false;
    }

    public static String getVersion() {
        return "Chart Builder 2.37";
    }

    public ChartLabel getTitle() {
        return this.t;
    }

    public ChartLabel getFootnote() {
        return this.foot;
    }

    public ChartLabel getSubtitle() {
        return this.subt;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    protected boolean isPieChart() {
        return this.isPieChart;
    }

    protected void assertPieChart() {
        this.isPieChart = true;
    }

    protected void setSizeInternal(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    protected void setWidthInternal(int n) {
        this.width = n;
    }

    protected void setHeightInternal(int n) {
        this.height = n;
    }

    public Dimension getSize() {
        Dimension dimension = new Dimension(this.width, this.height);
        return dimension;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(this.width, this.height);
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension(this.width, this.height);
        return dimension;
    }

    public void setEdgeColor(Color color) {
        this.EdgeColor = color;
    }

    public Color getEdgeColor() {
        return this.EdgeColor;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public void setTitlesForeground(Color color) {
        this.t.foreground = color;
        this.subt.foreground = color;
        this.foot.foreground = color;
    }

    protected boolean isBorderTopSet() {
        return this.borderTopSet;
    }

    protected boolean isBorderBottomSet() {
        return this.borderBottomSet;
    }

    protected boolean isBorderRightSet() {
        return this.borderRightSet;
    }

    protected boolean isBorderLeftSet() {
        return this.borderLeftSet;
    }

    public void setBorderLeft(int n) {
        if (n >= 0) {
            this.borderLeftSet = true;
            this.border_left = n;
        }
    }

    protected void setBorderLeftInternal(int n) {
        if (n >= 0) {
            this.border_left = n;
        }
    }

    public void setBorderRight(int n) {
        if (n >= 0) {
            this.borderRightSet = true;
            this.border_right = n;
        }
    }

    protected void setBorderRightInternal(int n) {
        if (n >= 0) {
            this.border_right = n;
        }
    }

    public void setBorderTop(int n) {
        if (n >= 0) {
            this.borderTopSet = true;
            this.border_top = n;
        }
    }

    protected void setBorderTopInternal(int n) {
        if (n >= 0) {
            this.border_top = n;
        }
    }

    public void setBorderBottom(int n) {
        if (n >= 0) {
            this.borderBottomSet = true;
            this.border_bottom = n;
        }
    }

    protected void setBorderBottomInternal(int n) {
        if (n >= 0) {
            this.border_bottom = n;
        }
    }

    public int getBorderLeft() {
        return this.border_left;
    }

    public int getBorderRight() {
        return this.border_right;
    }

    public int getBorderTop() {
        return this.border_top;
    }

    public int getBorderBottom() {
        return this.border_bottom;
    }

    public class ChartLabel
    extends Component {
        private int height = 0;
        private String text = "";
        private String[] textLines;
        private boolean multipleLines = false;
        private Font font = new Font("sansserif", 0, 10);
        private int stringWidth;
        private int stringHeight = 1;
        private int characterWidth = 0;
        private double whiteSpaceFactor = 1.0;
        double yOffset = 0.5;
        public static final int LEFT = 0;
        public static final int CENTER = 1;
        public static final int RIGHT = 2;
        public static final int CENTER_PLOT = 4;
        int alignment = 0;
        Color foreground = Color.black;
        private boolean fontMetricsGot = false;
        private FontMetrics fontmet;

        public int getHeight() {
            return this.height;
        }

        protected void setHeight(int n) {
            this.height = n;
        }

        protected ChartLabel() {
            this("", 0);
        }

        protected ChartLabel(String string) {
            this(string, 0);
        }

        public void setForeground(Color color) {
            this.foreground = color;
        }

        protected ChartLabel(String string, int n) {
            this.text = string;
            this.setAlignment(n);
        }

        protected ChartLabel(String string, int n, Font font, double d, double d2) {
            this.text = string;
            this.setAlignment(n);
            this.whiteSpaceFactor = d;
            this.yOffset = d2;
            this.setFont(font);
        }

        public int getAlignment() {
            return this.alignment;
        }

        public synchronized void setAlignment(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 4: {
                    this.alignment = n;
                    return;
                }
            }
            throw new IllegalArgumentException("improper alignment: " + n);
        }

        public void setFontMetrics(Graphics2D graphics2D) {
            if (this.fontMetricsGot) {
                return;
            }
            this.fontmet = graphics2D.getFontMetrics(this.font);
            this.fontMetricsGot = true;
            if (this.multipleLines) {
                this.deriveHeight(this.textLines.length);
            } else {
                this.deriveHeight();
            }
        }

        public int getLineCount() {
            if (this.multipleLines) {
                return this.textLines.length;
            }
            if (this.text == "") {
                return 0;
            }
            return 1;
        }

        public FontMetrics getFontMetrics() {
            return this.fontmet;
        }

        public void setFont(Font font) {
            this.font = font;
            this.fontMetricsGot = false;
            if (this.multipleLines) {
                this.deriveHeight(this.textLines.length);
            } else {
                this.deriveHeight();
            }
        }

        public Font getFont() {
            return this.font;
        }

        public void setWidth(int n) {
            super.setSize(n, this.getHeight());
        }

        public String getText() {
            if (this.multipleLines) {
                return this.textLines[0];
            }
            return this.text;
        }

        public void setText(String string) {
            if (string == null) {
                return;
            }
            this.text = string;
            if (this.multipleLines) {
                this.deriveHeight(this.textLines.length);
            } else {
                this.deriveHeight();
            }
        }

        public void setText(String[] stringArray) {
            if (stringArray == null) {
                return;
            }
            int n = stringArray.length;
            this.multipleLines = true;
            this.textLines = new String[n];
            for (int i = 0; i < n; ++i) {
                this.textLines[i] = stringArray[i];
            }
            this.deriveHeight(n);
        }

        public void setHeightFactor(double d) {
            this.whiteSpaceFactor = d;
        }

        void setYOffset(double d) {
            this.yOffset = d;
        }

        public int getStringWidth() {
            if (this.fontmet != null) {
                if (!this.multipleLines) {
                    this.stringWidth = this.fontmet.stringWidth(this.text);
                } else {
                    int n = 0;
                    this.stringWidth = 0;
                    for (int i = 0; i < this.textLines.length; ++i) {
                        n = this.fontmet.stringWidth(this.textLines[i]);
                        if (this.stringWidth >= n) continue;
                        this.stringWidth = n;
                    }
                }
            }
            return this.stringWidth;
        }

        private void deriveHeight() {
            int n = 0;
            if (this.fontmet != null) {
                n = this.fontmet.getHeight();
                this.stringHeight = this.fontmet.getAscent();
                this.stringWidth = this.fontmet.stringWidth(this.text);
                this.characterWidth = this.fontmet.stringWidth("#");
                int n2 = (int)((double)n * this.whiteSpaceFactor);
                this.setHeight(n2);
            }
        }

        private void deriveHeight(int n) {
            if (this.fontmet != null) {
                int n2 = this.fontmet.getHeight();
                this.stringHeight = this.fontmet.getAscent();
                this.stringWidth = this.fontmet.stringWidth(this.text);
                this.characterWidth = this.fontmet.stringWidth("#");
                int n3 = (int)((double)n2 * this.whiteSpaceFactor) + (n - 1) * this.stringHeight;
                this.setHeight(n3);
            }
        }

        private int getTextXLocation(int n, int n2) {
            boolean bl = false;
            int n3 = 0;
            switch (n) {
                case 0: {
                    n3 = super.getX() + this.characterWidth;
                    break;
                }
                case 1: {
                    n3 = super.getX() + Chart.this.width / 2 - n2 / 2;
                    if (n3 >= super.getX()) break;
                    n3 = super.getX();
                    break;
                }
                case 4: {
                    n3 = super.getX() + Chart.this.getBorderLeft() + (Chart.this.width - Chart.this.getBorderLeft() - Chart.this.getBorderRight()) / 2 - n2 / 2;
                    if (n3 >= super.getX()) break;
                    n3 = super.getX();
                    break;
                }
                case 2: {
                    n3 = super.getX() + (Chart.this.width - n2);
                    if (n3 >= super.getX()) break;
                    n3 = super.getX();
                }
            }
            return n3;
        }

        public void drawBuffer(Graphics2D graphics2D) {
            boolean bl = false;
            int n = 0;
            int n2 = 0;
            this.setFontMetrics(graphics2D);
            graphics2D.setFont(this.font);
            int n3 = this.fontmet.getHeight();
            graphics2D.setColor(this.foreground);
            n2 = super.getY() + (int)(this.yOffset * (double)n3);
            if (this.multipleLines) {
                this.deriveHeight(this.textLines.length);
                for (int i = 0; i < this.textLines.length; ++i) {
                    this.stringWidth = this.fontmet.stringWidth(this.textLines[i]);
                    if (this.stringWidth <= 0) continue;
                    n = this.getTextXLocation(this.alignment, this.stringWidth);
                    if (bl) {
                        System.out.println("drawString " + this.textLines[i] + " " + n + " " + n2);
                    }
                    graphics2D.drawString(this.textLines[i], n, n2);
                    n2 += this.stringHeight;
                }
            } else {
                this.deriveHeight();
                this.stringWidth = this.fontmet.stringWidth(this.text);
                if (this.stringWidth > 0) {
                    n = this.getTextXLocation(this.alignment, this.stringWidth);
                    if (bl) {
                        System.out.println("drawString ." + this.text + ". w =" + this.stringWidth + "( " + n + "," + n2 + ")");
                    }
                    graphics2D.drawString(this.text, n, n2);
                }
            }
        }
    }
}

