/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

class MVHashMap
implements Serializable {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    static final Object NULL_KEY = new Object();
    private static final long serialVersionUID = 362498820763181265L;

    public MVHashMap(int n, float f) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("Illegal initialcapacity: " + n);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal load factor: " + f);
        }
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.loadFactor = f;
        this.threshold = (int)((float)n2 * f);
        this.table = new Entry[n2];
        this.init();
    }

    public MVHashMap(int n) {
        this(n, 0.75f);
    }

    public MVHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 16;
        this.table = new Entry[16];
        this.init();
    }

    void init() {
    }

    static Object maskNull(Object object) {
        return object == null ? NULL_KEY : object;
    }

    static Object unmaskNull(Object object) {
        return object == NULL_KEY ? null : object;
    }

    static int hash(Object object) {
        int n = object.hashCode();
        return n;
    }

    static boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    static int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object get(Object object) {
        Object object2 = MVHashMap.maskNull(object);
        int n = MVHashMap.hash(object2);
        int n2 = MVHashMap.indexFor(n, this.table.length);
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && MVHashMap.eq(object2, entry.key)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return entry;
    }

    public boolean containsKey(Object object) {
        Object object2 = MVHashMap.maskNull(object);
        int n = MVHashMap.hash(object2);
        int n2 = MVHashMap.indexFor(n, this.table.length);
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && MVHashMap.eq(object2, entry.key)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    Entry getEntry(Object object) {
        Object object2 = MVHashMap.maskNull(object);
        int n = MVHashMap.hash(object2);
        int n2 = MVHashMap.indexFor(n, this.table.length);
        Entry entry = this.table[n2];
        while (!(entry == null || entry.hash == n && MVHashMap.eq(object2, entry.key))) {
            entry = entry.next;
        }
        return entry;
    }

    int _put(Object object, Object object2, int n) {
        Object object3 = MVHashMap.maskNull(object);
        int n2 = MVHashMap.hash(object3);
        int n3 = MVHashMap.indexFor(n2, this.table.length);
        Entry entry = this.table[n3];
        while (entry != null) {
            if (entry.hash == n2 && MVHashMap.eq(object3, entry.key)) {
                int n4 = entry.esize;
                entry.value = object2;
                entry.esize = n;
                entry.recordAccess(this);
                return n4;
            }
            entry = entry.next;
        }
        ++this.modCount;
        this.addEntry(n2, object3, object2, n3, n);
        return 0;
    }

    private void putForCreate(Object object, Object object2, int n) {
        Object object3 = MVHashMap.maskNull(object);
        int n2 = MVHashMap.hash(object3);
        int n3 = MVHashMap.indexFor(n2, this.table.length);
        Entry entry = this.table[n3];
        while (entry != null) {
            if (entry.hash == n2 && MVHashMap.eq(object3, entry.key)) {
                entry.value = object2;
                return;
            }
            entry = entry.next;
        }
        this.createEntry(n2, object3, object2, n3, n);
    }

    void resize(int n) {
        Entry[] entryArray = this.table;
        int n2 = entryArray.length;
        if (this.size < this.threshold || n2 > n) {
            return;
        }
        Entry[] entryArray2 = new Entry[n];
        this.transfer(entryArray2);
        this.table = entryArray2;
        this.threshold = (int)((float)n * this.loadFactor);
    }

    void transfer(Entry[] entryArray) {
        Entry[] entryArray2 = this.table;
        int n = entryArray.length;
        for (int i = 0; i < entryArray2.length; ++i) {
            Entry entry;
            Entry entry2 = entryArray2[i];
            if (entry2 == null) continue;
            entryArray2[i] = null;
            do {
                entry = entry2.next;
                int n2 = MVHashMap.indexFor(entry2.hash, n);
                entry2.next = entryArray[n2];
                entryArray[n2] = entry2;
            } while ((entry2 = entry) != null);
        }
    }

    public Object remove(Object object) {
        Entry entry = this.removeEntryForKey(object);
        return entry == null ? entry : entry.value;
    }

    Entry removeEntryForKey(Object object) {
        Entry entry;
        Object object2 = MVHashMap.maskNull(object);
        int n = MVHashMap.hash(object2);
        int n2 = MVHashMap.indexFor(n, this.table.length);
        Entry entry2 = entry = this.table[n2];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (entry2.hash == n && MVHashMap.eq(object2, entry2.key)) {
                ++this.modCount;
                --this.size;
                if (entry == entry2) {
                    this.table[n2] = entry3;
                } else {
                    entry.next = entry3;
                }
                entry2.recordRemoval(this);
                return entry2;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return entry2;
    }

    Entry removeMapping(Object object) {
        Entry entry;
        if (!(object instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry2 = (Map.Entry)object;
        Object object2 = MVHashMap.maskNull(entry2.getKey());
        int n = MVHashMap.hash(object2);
        int n2 = MVHashMap.indexFor(n, this.table.length);
        Entry entry3 = entry = this.table[n2];
        while (entry3 != null) {
            Entry entry4 = entry3.next;
            if (entry3.hash == n && entry3.equals(entry2)) {
                ++this.modCount;
                --this.size;
                if (entry == entry3) {
                    this.table[n2] = entry4;
                } else {
                    entry.next = entry4;
                }
                entry3.recordRemoval(this);
                return entry3;
            }
            entry = entry3;
            entry3 = entry4;
        }
        return entry3;
    }

    public void clear() {
        ++this.modCount;
        Entry[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = null;
        }
        this.size = 0;
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            return this.containsNullValue();
        }
        Entry[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    void addEntry(int n, Object object, Object object2, int n2, int n3) {
        this.table[n2] = new Entry(n, object, object2, this.table[n2], n3);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int n, Object object, Object object2, int n2, int n3) {
        this.table[n2] = new Entry(n, object, object2, this.table[n2], n3);
        ++this.size;
    }

    Iterator newKeyIterator() {
        return new KeyIterator();
    }

    Iterator newValueIterator() {
        return new ValueIterator();
    }

    Iterator newEntryIterator() {
        return new EntryIterator();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.size);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.table = new Entry[n];
        this.init();
        int n2 = objectInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            int n3 = objectInputStream.readInt();
            this.putForCreate(object, object2, n3);
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    public String report(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(1024);
        String string = "";
        for (n2 = 0; n2 < n; ++n2) {
            string = string + "\t";
        }
        stringBuffer.append(string + "   capacity: " + this.capacity() + "\n");
        stringBuffer.append(string + "       size: " + this.size + "\n");
        stringBuffer.append(string + "load factor: " + this.loadFactor() + "\n");
        n2 = 1;
        int n3 = 0;
        long l = 0L;
        for (int i = 0; i < this.capacity(); ++i) {
            Entry entry = this.table[i];
            if (entry != null) {
                ++n3;
            }
            int n4 = 0;
            while (entry != null) {
                l += (long)entry.esize;
                ++n4;
                entry = entry.next;
            }
            if (n4 <= n2) continue;
            n2 = n4;
        }
        stringBuffer.append(string + "    # of chains: " + n3 + "\n");
        stringBuffer.append(string + "max chain depth: " + n2 + "\n");
        stringBuffer.append(string + "avg chain depth: " + (double)this.size / (double)n3 + "\n");
        stringBuffer.append(string + " empty bucket %: " + (double)(this.capacity() - n3) / (double)this.capacity() + "\n");
        stringBuffer.append(string + "total mem size : " + l / 1024L + "KB\n");
        return stringBuffer.toString();
    }

    private class EntryIterator
    extends HashIterator {
        private EntryIterator() {
        }

        public Object next() {
            return this.nextEntry();
        }
    }

    private class KeyIterator
    extends HashIterator {
        private KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private class ValueIterator
    extends HashIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator
    implements Iterator {
        Entry next;
        int expectedModCount;
        int index;
        Entry current;

        HashIterator() {
            this.expectedModCount = MVHashMap.this.modCount;
            Entry[] entryArray = MVHashMap.this.table;
            int n = entryArray.length;
            Entry entry = null;
            if (MVHashMap.this.size != 0) {
                while (n > 0 && (entry = entryArray[--n]) == null) {
                }
            }
            this.next = entry;
            this.index = n;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        Entry nextEntry() {
            if (MVHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry entry = this.next;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            Entry entry2 = entry.next;
            Entry[] entryArray = MVHashMap.this.table;
            int n = this.index;
            while (entry2 == null && n > 0) {
                entry2 = entryArray[--n];
            }
            this.index = n;
            this.next = entry2;
            this.current = entry;
            return this.current;
        }

        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (MVHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object object = this.current.key;
            this.current = null;
            MVHashMap.this.removeEntryForKey(object);
            this.expectedModCount = MVHashMap.this.modCount;
        }
    }

    static class Entry
    implements Map.Entry {
        int esize;
        final Object key;
        Object value;
        final int hash;
        Entry next;

        Entry(int n, Object object, Object object2, Entry entry, int n2) {
            this.value = object2;
            this.next = entry;
            this.key = object;
            this.hash = n;
            this.esize = n2;
        }

        public Object getKey() {
            return MVHashMap.unmaskNull(this.key);
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public void setSize(int n) {
            this.esize = n;
        }

        public int getSize() {
            return this.esize;
        }

        public boolean equals(Object object) {
            Object v;
            Object object2;
            Object k;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object object3 = this.getKey();
            return (object3 == (k = entry.getKey()) || object3 != null && object3.equals(k)) && ((object2 = this.getValue()) == (v = entry.getValue()) || object2 != null && object2.equals(v));
        }

        public int hashCode() {
            return (this.key == NULL_KEY ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        void recordAccess(MVHashMap mVHashMap) {
        }

        void recordRemoval(MVHashMap mVHashMap) {
        }
    }
}

