/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Color;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import oracle.lbs.mapcache.MapCacheServer;
import oracle.lbs.mapcache.cache.MapCache;
import oracle.mapviewer.share.NorthArrow;
import oracle.mapviewer.share.ScaleBar;
import oracle.sdovis.BaseMap;
import oracle.sdovis.BasemapCache;
import oracle.sdovis.CasedLineHelper;
import oracle.sdovis.DBMapMaker;
import oracle.sdovis.DataException;
import oracle.sdovis.Legend;
import oracle.sdovis.LiveFeature;
import oracle.sdovis.MapCacheTheme;
import oracle.sdovis.NsDpHandler;
import oracle.sdovis.Proj;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.StyleCache;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.ThemeList;
import oracle.sdovis.VisConstants;
import oracle.sdovis.VisException;
import oracle.sdovis.XFViewPort;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DataSourceI;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.style.TextStroke;
import oracle.sdovis.util.RectArray;
import oracle.sdovis.util.UserIdentity;

public class VisContext
implements VisConstants {
    public static boolean MAC_OS_X = false;
    public static int BUFFER_LABEL_THEME = 200;
    public static int BUFFER_VECTOR_THEME = 30;
    String masterDataSourceName;
    int masterSRID;
    boolean antialiasing = true;
    Rectangle2D deviceWindow;
    int imageType;
    boolean imageScaling;
    BufferedImage mapImage;
    BufferedImage legendImage;
    Vector liveFeatures;
    Rectangle2D queryWindow;
    int queryWindowSrid;
    SRS srs = new SRS();
    ThemeList themeList;
    boolean textAntialiasing;
    boolean transparent;
    boolean noRequery = false;
    AffineTransform affineXF;
    int deviceType;
    Legend legend;
    Color bgColor;
    Image bgImage;
    String bgImageUrl;
    String footnote;
    String footnotePos;
    String footnoteStyleName;
    StyleText footnoteStyle;
    String title;
    String titlePos;
    String titleStyleName;
    StyleText titleStyle;
    XFViewPort xfViewport;
    Hashtable dynamicStyles;
    boolean ugp;
    boolean bBox = false;
    String mapFileName;
    RectArray limitRects = null;
    RectArray markerLimitRects = null;
    RectArray renderedMarkerLimitRects = null;
    TextStroke textStroke = null;
    int zoomLevels = 4;
    double zoomFactor = 2.0;
    double svgInitScale = 1.0;
    boolean showSVGNavBar = true;
    boolean showSVGInfo = true;
    String svgOnClick = null;
    String svgOnMouseMove = null;
    boolean svgLayersOnly = false;
    boolean svgStyles = true;
    boolean svgLabels = true;
    boolean svgDeviceCoordinateSys = true;
    String[] boundingThemes = null;
    float boundingThemeBorderMargin = 0.05f;
    boolean boundingThemeKeepAspectRatio = true;
    double boundingSizeHint = 0.0;
    boolean renderRasterOnly = false;
    boolean renderRasterBaseMap = false;
    String onRectangleSelect = null;
    String onPolygonSelect = null;
    ScaleBar scaleBar = null;
    double lastMapScale = 0.0;
    private boolean isTileRequest = false;
    private boolean isFOIRequest = false;
    boolean keepThemesOrder = false;
    Vector nsdpHandlers = null;
    MapCache mapCache = null;
    BaseMap.PredefinedThemeDesc[] baseMapThemes = null;
    boolean snapToCachedScale = false;
    String[] rasterThemeNames = null;
    String[] rasterImageNames = null;
    double currentScale = Double.POSITIVE_INFINITY;
    Proj projection = null;
    boolean interrupted = false;
    String svgInfoTipFont = null;
    boolean useCachedBaseMap = false;
    private String cachedBaseMap = null;
    String proxyType = null;
    Properties proxyProperties = null;
    String proxyDataSrc = null;
    UserIdentity userIdentity = null;
    private boolean disableMapPieces = false;
    private CasedLineHelper casedLines = new CasedLineHelper(15);
    private double rotation = 0.0;
    private double lastRotation = 0.0;
    private NorthArrow northArrow = null;
    private DataException dataException = null;
    private boolean isPDFrequest = false;
    private Rectangle2D queryWindowConstraint = null;
    private int markerSequenceFormat = 0;
    private int markerSequence = 0;
    private int themeWindowBuffer = 0;
    private String userLanguage = null;

    public VisContext() {
        this.themeList = new ThemeList();
        this.reset();
    }

    private void destroy() {
        if (this.mapImage != null) {
            this.mapImage.flush();
            this.mapImage = null;
        }
        if (this.legendImage != null) {
            this.legendImage.flush();
            this.legendImage = null;
        }
        if (this.bgImage != null) {
            this.bgImage.flush();
            this.bgImage = null;
        }
        if (this.dynamicStyles != null) {
            this.dynamicStyles.clear();
        }
        if (this.liveFeatures != null) {
            this.liveFeatures.clear();
        }
        if (this.themeList != null) {
            this.themeList.clear();
        }
        if (this.limitRects != null) {
            this.limitRects.reset();
        }
        if (this.markerLimitRects != null) {
            this.markerLimitRects.reset();
        }
        if (this.renderedMarkerLimitRects != null) {
            this.renderedMarkerLimitRects.reset();
        }
        this.boundingThemes = null;
        if (this.casedLines != null) {
            this.casedLines.clear();
        }
        this.dataException = null;
    }

    public void reset() {
        this.destroy();
        this.masterDataSourceName = null;
        this.masterSRID = 0;
        this.antialiasing = true;
        this.deviceWindow = null;
        this.imageType = VisContext.getDefaultImageType();
        this.imageScaling = true;
        this.liveFeatures = null;
        this.queryWindow = null;
        this.queryWindowSrid = 0;
        this.srs = new SRS();
        this.noRequery = false;
        this.bBox = false;
        this.textAntialiasing = true;
        this.transparent = false;
        this.affineXF = null;
        this.deviceType = 1;
        this.legend = null;
        this.bgColor = DEFAULT_MAP_BACKGROUND;
        this.footnote = null;
        this.footnotePos = null;
        this.footnoteStyleName = null;
        this.footnoteStyle = null;
        this.title = null;
        this.titlePos = null;
        this.titleStyleName = null;
        this.titleStyle = null;
        this.xfViewport = new XFViewPort();
        this.ugp = false;
        this.mapFileName = null;
        this.svgOnClick = null;
        this.svgOnMouseMove = null;
        this.zoomLevels = 4;
        this.zoomFactor = 2.0;
        this.svgInitScale = 1.0;
        this.showSVGNavBar = true;
        this.showSVGInfo = true;
        this.boundingThemeBorderMargin = 0.05f;
        this.boundingThemeKeepAspectRatio = true;
        this.scaleBar = null;
        this.lastMapScale = 0.0;
        this.isTileRequest = false;
        this.isFOIRequest = false;
        this.removeAllNsDpHandlers();
        this.baseMapThemes = null;
        this.mapCache = null;
        this.snapToCachedScale = false;
        this.rasterThemeNames = null;
        this.rasterImageNames = null;
        this.currentScale = Double.POSITIVE_INFINITY;
        this.projection = null;
        this.interrupted = false;
        this.useCachedBaseMap = false;
        this.cachedBaseMap = null;
        this.proxyType = null;
        this.proxyProperties = null;
        this.proxyDataSrc = null;
        this.userIdentity = null;
        this.disableMapPieces = false;
        this.rotation = 0.0;
        this.lastRotation = 0.0;
        this.northArrow = null;
        this.dataException = null;
    }

    public String getMasterDataSourceName() {
        return this.masterDataSourceName;
    }

    public void setMasterDataSourceName(String string) {
        this.masterDataSourceName = string;
    }

    public int getMasterSRID() {
        return this.masterSRID;
    }

    public void setMasterSRID(int n) {
        this.masterSRID = n;
        DataSourceI dataSourceI = DSManager.get(this.masterDataSourceName);
        if (dataSourceI != null) {
            SRSCache sRSCache = dataSourceI.getSRSCache();
            this.srs = sRSCache.get(n);
        }
    }

    public boolean getAntialiasing() {
        return this.antialiasing;
    }

    public void setAntialiasing(boolean bl) {
        this.antialiasing = bl;
    }

    public Rectangle2D getDeviceWindow() {
        return this.deviceWindow;
    }

    public void setDeviceWindow(Rectangle2D rectangle2D) throws VisException {
        this.deviceWindow = rectangle2D;
        int n = (int)rectangle2D.getWidth();
        int n2 = (int)rectangle2D.getHeight();
        this.allocateImage(n, n2, this.imageType);
    }

    public int getImageType() {
        return this.imageType;
    }

    public void setImageType(int n) throws VisException {
        int n2 = this.imageType;
        this.imageType = n;
        if (n == 12 || n == 10) {
            this.setDeviceType(3);
        } else {
            this.setDeviceType(1);
        }
        if (n2 != n && this.deviceWindow != null) {
            this.allocateImage((int)this.deviceWindow.getWidth(), (int)this.deviceWindow.getHeight(), this.imageType);
        }
    }

    public boolean getImageScaling() {
        return this.imageScaling;
    }

    public void setImageScaling(boolean bl) {
        this.imageScaling = bl;
    }

    public BufferedImage getMapImage() {
        return this.mapImage;
    }

    public void setMapImage(BufferedImage bufferedImage) {
        this.mapImage = bufferedImage;
    }

    public BufferedImage getLegendImage() {
        return this.legendImage;
    }

    public void setLegendImage(BufferedImage bufferedImage) {
        this.legendImage = bufferedImage;
    }

    public Vector getLiveFeatures() {
        return this.liveFeatures;
    }

    public void setLiveFeatures(Vector vector) {
        this.liveFeatures = vector;
    }

    public void clearLiveFeatures() {
        if (this.liveFeatures != null) {
            this.liveFeatures.clear();
        }
    }

    public void addLiveFeature(StyledFeatureI styledFeatureI) {
        String[] stringArray;
        LiveFeature liveFeature = new LiveFeature();
        if (styledFeatureI.getPoint() != null) {
            stringArray = styledFeatureI.getPoint();
            liveFeature.setCenter(stringArray.getX(), stringArray.getY());
        } else {
            liveFeature.setShape(styledFeatureI.getShape());
        }
        liveFeature.setGeomType(styledFeatureI.getGeomType());
        if (styledFeatureI.getNumAttributes() > 0) {
            int n;
            stringArray = new String[styledFeatureI.getNumAttributes()];
            int n2 = styledFeatureI.getNumRenderableAttributes();
            for (n = 0; n < n2; ++n) {
                stringArray[n] = "" + styledFeatureI.getRenderableAttribute(n).getValue();
            }
            for (n = 0; n < styledFeatureI.getNumIdentifiableAttributes(); ++n) {
                stringArray[n2 + n] = "" + styledFeatureI.getIdentifiableAttribute(n).getValue();
            }
            liveFeature.setAttrs(stringArray);
        }
        liveFeature.setLabel(styledFeatureI.getLabel());
        liveFeature.setMarkerStyleSize(styledFeatureI.getMarkerStyleSize());
        liveFeature.setRadius(styledFeatureI.getRadius());
        if (this.liveFeatures == null) {
            this.liveFeatures = new Vector(32);
        }
        this.liveFeatures.add(liveFeature);
    }

    public Rectangle2D getQueryWindow() {
        return this.queryWindow;
    }

    public void setQueryWindow(Rectangle2D rectangle2D) {
        this.queryWindow = rectangle2D;
    }

    public int getQueryWindowSrid() {
        return this.queryWindowSrid;
    }

    public void setQueryWindowSrid(int n) {
        this.queryWindowSrid = n;
    }

    public SRS getSrs() {
        return this.srs;
    }

    public void setSrs(SRS sRS) {
        this.srs = sRS;
        if (sRS != null) {
            this.masterSRID = sRS.getSRID();
        }
    }

    public ThemeList getThemeList() {
        return this.themeList;
    }

    public void setThemeList(ThemeList themeList) {
        this.themeList = themeList;
    }

    public boolean getTextAntialiasing() {
        return this.textAntialiasing;
    }

    public void setTextAntialiasing(boolean bl) {
        this.textAntialiasing = bl;
    }

    public boolean getTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
    }

    public AffineTransform getAffineXF() {
        return this.affineXF;
    }

    public void setAffineXF(AffineTransform affineTransform) {
        this.affineXF = affineTransform;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(int n) {
        this.deviceType = n;
    }

    public Legend getLegend() {
        return this.legend;
    }

    public void setLegend(Legend legend) {
        this.legend = legend;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(Color color) {
        this.bgColor = color;
    }

    public Image getBgImage() {
        return this.bgImage;
    }

    public void setBgImage(Image image) {
        this.bgImage = image;
    }

    public String getBgImageUrl() {
        return this.bgImageUrl;
    }

    public void setBgImageUrl(String string) {
        this.bgImageUrl = string;
    }

    public String getFootnote() {
        return this.footnote;
    }

    public void setFootnote(String string) {
        this.footnote = string;
    }

    public String getFootnotePos() {
        return this.footnotePos;
    }

    public void setFootnotePos(String string) {
        this.footnotePos = string;
    }

    public String getFootnoteStyleName() {
        return this.footnoteStyleName;
    }

    public void setFootnoteStyleName(String string) {
        this.footnoteStyleName = string;
        if (string == null) {
            return;
        }
        if (this.footnoteStyle != null && !this.footnoteStyle.getModel().getName().equalsIgnoreCase(string)) {
            this.footnoteStyle = null;
        }
    }

    public StyleText getFootnoteStyle() {
        return this.footnoteStyle;
    }

    public void setFootnoteStyle(StyleText styleText) {
        this.footnoteStyle = styleText;
        this.footnoteStyleName = styleText != null ? styleText.getModel().getName() : null;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitlePos() {
        return this.titlePos;
    }

    public void setTitlePos(String string) {
        this.titlePos = string;
    }

    public String getTitleStyleName() {
        return this.titleStyleName;
    }

    public void setTitleStyleName(String string) {
        this.titleStyleName = string;
        if (string == null) {
            return;
        }
        if (this.titleStyle != null && !this.titleStyle.getModel().getName().equalsIgnoreCase(string)) {
            this.titleStyle = null;
        }
    }

    public StyleText getTitleStyle() {
        return this.titleStyle;
    }

    public void setTitleStyle(StyleText styleText) {
        this.titleStyle = styleText;
        this.titleStyleName = styleText != null ? styleText.getModel().getName() : null;
    }

    public XFViewPort getViewportTransform() {
        return this.xfViewport;
    }

    public void setViewportTransform(XFViewPort xFViewPort) {
        this.xfViewport = xFViewPort;
    }

    public Hashtable getDynamicStyles() {
        return this.dynamicStyles;
    }

    public void setDynamicStyles(Hashtable hashtable) {
        this.dynamicStyles = hashtable;
    }

    public void addDynamicStyle(String string, Style style) {
        if (this.dynamicStyles == null) {
            this.dynamicStyles = new Hashtable();
        }
        this.dynamicStyles.put(string.toUpperCase(), style);
    }

    public Style getDynamicStyle(String string) {
        return this.dynamicStyles == null ? null : (Style)this.dynamicStyles.get(string.toUpperCase());
    }

    public void clearDynamicStyles() {
        if (this.dynamicStyles != null) {
            this.dynamicStyles.clear();
        }
    }

    public boolean getUgp() {
        return this.ugp;
    }

    public void setUgp(boolean bl) {
        this.ugp = bl;
    }

    public boolean getBBox() {
        return this.bBox;
    }

    public void setBBox(boolean bl) {
        this.bBox = bl;
    }

    public void setNoQuery(boolean bl) {
        this.noRequery = bl;
    }

    public boolean getNoQuery() {
        return this.noRequery;
    }

    public RectArray getCRArray() {
        return this.limitRects;
    }

    public void setCRArray(RectArray rectArray) {
        this.limitRects = rectArray;
    }

    public RectArray getMarkerCRArray() {
        return this.markerLimitRects;
    }

    public void setMarkerCRArray(RectArray rectArray) {
        this.markerLimitRects = rectArray;
    }

    public RectArray getRenderedMarkerCRArray() {
        return this.renderedMarkerLimitRects;
    }

    public void setRenderedMarkerCRArray(RectArray rectArray) {
        this.renderedMarkerLimitRects = rectArray;
    }

    public TextStroke getTextStroke() {
        return this.textStroke;
    }

    public void setTextStroke(TextStroke textStroke) {
        this.textStroke = textStroke;
    }

    public void setMapFileName(String string) {
        this.mapFileName = string;
    }

    public String getMapFileName() {
        return this.mapFileName;
    }

    public Style resolveStyle(String string) {
        return this.resolveStyle(string, this.masterDataSourceName);
    }

    public Style resolveStyle(String string, String string2) {
        Object object;
        if (string == null) {
            return null;
        }
        if (this.dynamicStyles != null && (object = (Style)this.dynamicStyles.get(string.toUpperCase())) != null) {
            return object;
        }
        if (string2 == null) {
            string2 = this.masterDataSourceName;
        }
        try {
            object = DSManager.get(string2);
            StyleCache styleCache = object.getStyleCache();
            return styleCache.get(string);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static int getDefaultImageType() {
        return MAC_OS_X ? 2 : 1;
    }

    private void allocateImage(int n, int n2, int n3) throws VisException {
        if (this.mapImage != null) {
            this.mapImage.flush();
        }
        this.mapImage = null;
        try {
            this.mapImage = new BufferedImage(n, n2, n3);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            throw new VisException("Out of memory error. Map image size is too big? " + n + " x " + n2, outOfMemoryError);
        }
    }

    public void setSVGZoomLevels(int n) {
        this.zoomLevels = n;
    }

    public int getSVGZoomLevels() {
        return this.zoomLevels;
    }

    public void setSVGZoomFactor(double d) {
        this.zoomFactor = d;
    }

    public double getSVGZoomFactor() {
        return this.zoomFactor;
    }

    public void setSVGInitScale(double d) {
        this.svgInitScale = d;
    }

    public double getSVGInitScale() {
        return this.svgInitScale;
    }

    public void setSVGShowNavigationBar(boolean bl) {
        this.showSVGNavBar = bl;
    }

    public boolean showSVGNavigationBar() {
        return this.showSVGNavBar;
    }

    public void setSVGShowInfo(boolean bl) {
        this.showSVGInfo = bl;
    }

    public boolean getSVGShowInfo() {
        return this.showSVGInfo;
    }

    public void setSVGOnClick(String string) {
        this.svgOnClick = string;
    }

    public void setSVGOnMouseMove(String string) {
        this.svgOnMouseMove = string;
    }

    public String getSVGOnClick() {
        return this.svgOnClick;
    }

    public String getSVGOnMouseMove() {
        return this.svgOnMouseMove;
    }

    public boolean renderSVGLayersOnly() {
        return this.svgLayersOnly;
    }

    public boolean renderSVGStyles() {
        return this.svgStyles;
    }

    public boolean renderSVGLabels() {
        return this.svgLabels;
    }

    public void setSVGLayersOnly(boolean bl) {
        this.svgLayersOnly = bl;
    }

    public void setSVGStyles(boolean bl) {
        this.svgStyles = bl;
    }

    public void setSVGLabels(boolean bl) {
        this.svgLabels = bl;
    }

    public boolean renderSVGInDevCoordSys() {
        return this.svgDeviceCoordinateSys;
    }

    public void setSVGInDevCoordSys(boolean bl) {
        this.svgDeviceCoordinateSys = bl;
    }

    public void setBoundingThemes(String[] stringArray, float f, boolean bl) {
        if (stringArray == null) {
            this.boundingThemes = null;
            return;
        }
        this.boundingThemes = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.boundingThemes[i] = stringArray[i];
        }
        this.boundingThemeBorderMargin = f < 0.0f ? 0.05f : f;
        this.boundingThemeKeepAspectRatio = bl;
    }

    public void setBoundingThemesSizeHint(double d) {
        this.boundingSizeHint = d;
    }

    public String[] getBoundingThemes() {
        return this.boundingThemes;
    }

    public float getBorderMarginForBoundingThemes() {
        return this.boundingThemeBorderMargin;
    }

    public double getBoundingThemesSizeHint() {
        return this.boundingSizeHint;
    }

    public boolean boundingThemesRespectAspectRatio() {
        return this.boundingThemeKeepAspectRatio;
    }

    public boolean renderRasterOnly() {
        return this.renderRasterOnly;
    }

    public void setRenderRasterOnly(boolean bl) {
        this.renderRasterOnly = bl;
    }

    public boolean hasRasterThemes() {
        return this.themeList != null ? this.themeList.hasRasterThemes() : false;
    }

    public void setRenderRasterBaseMapInSVG(boolean bl) {
        this.renderRasterBaseMap = bl;
    }

    public boolean renderRasterBaseMapInSVG() {
        return this.renderRasterBaseMap;
    }

    public void setSVGOnRectangleSelect(String string) {
        this.onRectangleSelect = string;
    }

    public void setSVGOnPolygonSelect(String string) {
        this.onPolygonSelect = string;
    }

    public String getSVGOnRectangleSelect() {
        return this.onRectangleSelect;
    }

    public String getSVGOnPolygonSelect() {
        return this.onPolygonSelect;
    }

    public void setScaleBar(ScaleBar scaleBar) {
        this.scaleBar = scaleBar;
    }

    public ScaleBar getScaleBar() {
        return this.scaleBar;
    }

    public double getLastMapScale() {
        return this.lastMapScale;
    }

    public void setLastMapScale(double d) {
        this.lastMapScale = d;
    }

    public boolean isTileRequest() {
        return this.isTileRequest;
    }

    public boolean isFOIRequest() {
        return this.isFOIRequest;
    }

    public void setIsTileRequest(boolean bl) {
        this.isTileRequest = bl;
        this.bgColor = null;
    }

    public void setIsFOIRequest(boolean bl) {
        this.isFOIRequest = bl;
    }

    public void addNsDpHandler(NsDpHandler nsDpHandler) {
        if (this.nsdpHandlers == null) {
            this.nsdpHandlers = new Vector();
        }
        this.nsdpHandlers.add(nsDpHandler);
    }

    public boolean getKeepThemesOrder() {
        return this.keepThemesOrder;
    }

    public void setKeepThemesOrder(boolean bl) {
        this.keepThemesOrder = bl;
    }

    public void removeNsDp(NsDpHandler nsDpHandler) {
        if (this.nsdpHandlers == null || this.nsdpHandlers.size() == 0) {
            return;
        }
        this.nsdpHandlers.remove(nsDpHandler);
    }

    public void removeAllNsDpHandlers() {
        if (this.nsdpHandlers == null || this.nsdpHandlers.size() == 0) {
            return;
        }
        for (int i = 0; i < this.nsdpHandlers.size(); ++i) {
            NsDpHandler nsDpHandler = (NsDpHandler)this.nsdpHandlers.get(i);
            nsDpHandler.destroy();
        }
        this.nsdpHandlers.removeAllElements();
    }

    public Vector getNsDpHandlers() {
        return this.nsdpHandlers;
    }

    public MapCache getMapCache() {
        return this.mapCache;
    }

    public void removeBaseMapThemes() {
        if (this.baseMapThemes == null || this.baseMapThemes.length == 0) {
            return;
        }
        for (int i = 0; i < this.baseMapThemes.length; ++i) {
            this.themeList.removeTheme(this.baseMapThemes[i].name);
        }
    }

    public void setSnapToCachedZoomLevel(boolean bl) {
        this.snapToCachedScale = bl;
    }

    public boolean snapToCachedScale() {
        return this.snapToCachedScale;
    }

    public boolean mapCacheThemeExists() {
        for (int i = 0; i < this.themeList.size(); ++i) {
            if (!(this.themeList.getTheme(i) instanceof MapCacheTheme)) continue;
            return true;
        }
        return false;
    }

    public void setRasterThemeNames(String[] stringArray) {
        this.rasterThemeNames = stringArray;
    }

    public void setRasterImageNames(String[] stringArray) {
        this.rasterImageNames = stringArray;
    }

    public void setCurrentScale(double d) {
        this.currentScale = d;
    }

    public double getCurrentScale() {
        return this.currentScale;
    }

    public void setScale(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        double d = rectangle2D2.getHeight() / (double)SRS.dpi;
        this.currentScale = rectangle2D.getHeight() / d;
    }

    public void setProjection(Proj proj) {
        this.projection = proj;
    }

    public Proj getProjection() {
        return this.projection;
    }

    public void setInterrupted(boolean bl) {
        this.interrupted = bl;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void setSVGInfoFont(String string) {
        this.svgInfoTipFont = string;
    }

    public String getSVGInfoFont() {
        return this.svgInfoTipFont;
    }

    public void enableCachedBaseMap(String string) {
        this.useCachedBaseMap = true;
        this.cachedBaseMap = string;
    }

    public void disableCachedBaseMap() {
        this.useCachedBaseMap = false;
        this.mapCache = null;
    }

    public void setMapCacheInstance(DBMapMaker dBMapMaker) {
        this.mapCache = MapCacheServer._server.getMapCacheByBaseMap(dBMapMaker.getMasterDataSource(), this.cachedBaseMap, this.masterSRID);
        this.baseMapThemes = VisContext.getBaseMapThemes(dBMapMaker, this.cachedBaseMap);
    }

    public boolean shouldUseCachedBaseMap() {
        return this.useCachedBaseMap;
    }

    private static BaseMap.PredefinedThemeDesc[] getBaseMapThemes(DBMapMaker dBMapMaker, String string) {
        BasemapCache basemapCache = null;
        AbstractDBDataSource abstractDBDataSource = (AbstractDBDataSource)DSManager.get(dBMapMaker.getVisContext().getMasterDataSourceName());
        basemapCache = abstractDBDataSource.getBasemapCache();
        BaseMap baseMap = basemapCache.getOrLoadBasemap(string);
        if (baseMap != null) {
            return baseMap.getThemes();
        }
        return new BaseMap.PredefinedThemeDesc[0];
    }

    public void setDisableMapPieces(boolean bl) {
        this.disableMapPieces = bl;
    }

    public boolean isDisableMapPieces() {
        return this.disableMapPieces;
    }

    public void setCasedLines(CasedLineHelper casedLineHelper) {
        this.casedLines = casedLineHelper;
    }

    public CasedLineHelper getCasedLines() {
        return this.casedLines;
    }

    public void setRotation(double d) {
        this.rotation = d;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setLastRotation(double d) {
        this.lastRotation = d;
    }

    public double getLastRotation() {
        return this.lastRotation;
    }

    public NorthArrow getNorthArrow() {
        return this.northArrow;
    }

    public void setNorthArrow(NorthArrow northArrow) {
        this.northArrow = northArrow;
    }

    public void setDataException(DataException dataException) {
        this.dataException = dataException;
    }

    public DataException getDataException() {
        return this.dataException;
    }

    public void setUserIdentity(UserIdentity userIdentity) {
        this.userIdentity = userIdentity;
    }

    public UserIdentity getUserIdentity() {
        return this.userIdentity;
    }

    public Rectangle2D getExtendedQueryWindow(int n) {
        double d = (double)n * this.queryWindow.getWidth() / this.deviceWindow.getWidth();
        double d2 = (double)n * this.queryWindow.getHeight() / this.deviceWindow.getHeight();
        double d3 = this.queryWindow.getMinX() - d;
        double d4 = this.queryWindow.getMinY() - d2;
        double d5 = this.queryWindow.getMaxX() + d;
        double d6 = this.queryWindow.getMaxY() + d2;
        if (this.queryWindowConstraint != null) {
            if (d3 < this.queryWindowConstraint.getMinX()) {
                d3 = this.queryWindowConstraint.getMinX();
            }
            if (d4 < this.queryWindowConstraint.getMinY()) {
                d4 = this.queryWindowConstraint.getMinY();
            }
            if (d5 > this.queryWindowConstraint.getMaxX()) {
                d5 = this.queryWindowConstraint.getMaxX();
            }
            if (d6 > this.queryWindowConstraint.getMaxY()) {
                d6 = this.queryWindowConstraint.getMaxY();
            }
        }
        double d7 = d5 - d3;
        double d8 = d6 - d4;
        if (this.srs.isGeodetic() && "DECIMAL DEGREE".equals(this.srs.getUnit())) {
            if (d3 < -180.0) {
                d3 = -180.0;
            }
            if (d4 < -90.0) {
                d4 = -90.0;
            }
            if (d3 + d7 > 180.0) {
                d7 = 180.0 - d3;
            }
            if (d4 + d8 > 90.0) {
                d8 = 90.0 - d4;
            }
        }
        return new Rectangle2D.Double(d3, d4, d7, d8);
    }

    public boolean isPDFformatRequest() {
        return this.isPDFrequest;
    }

    public void setPDFformatRequest(boolean bl) {
        this.isPDFrequest = bl;
    }

    public void setQueryWindowConstraint(Rectangle2D rectangle2D) {
        this.queryWindowConstraint = rectangle2D;
    }

    public Rectangle2D getQueryWindowConstraint() {
        return this.queryWindowConstraint;
    }

    public boolean shouldRenderMarkerSequence() {
        return this.markerSequenceFormat != 0;
    }

    public void resetMarkerSequence() {
        this.markerSequence = 0;
    }

    public void enableMarkerSequence(int n) {
        this.markerSequenceFormat = n;
    }

    public String getNextMarkerSequence() {
        if (this.markerSequenceFormat == 0) {
            return null;
        }
        ++this.markerSequence;
        if (this.markerSequenceFormat == 2) {
            if (this.markerSequence > 26) {
                return null;
            }
            return "" + (char)(65 + this.markerSequence - 1);
        }
        return this.markerSequence + "";
    }

    public void setUserLanguage(String string) {
        this.userLanguage = string;
    }

    public String getUserLanguage() {
        return this.userLanguage;
    }

    public boolean shouldReportError() {
        return this.dataException != null && this.isTileRequest();
    }

    protected int getThemeWindowBuffer() {
        return this.themeWindowBuffer;
    }

    protected void setThemeWindowBuffer(int n) {
        this.themeWindowBuffer = n;
    }

    static {
        try {
            String string = System.getProperty("os.name").toLowerCase();
            MAC_OS_X = string.startsWith("mac os x");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

