/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import oracle.sdovis.GeoRasterTheme;
import oracle.sdovis.ImageTheme;
import oracle.sdovis.ShadedReliefTheme;
import oracle.sdovis.Theme;
import oracle.sdovis.WMSMapTheme;

public class ThemeList {
    private Vector mThemes;

    public ThemeList() {
    }

    public ThemeList(String string) {
    }

    public int addTheme(Theme theme) {
        this.initThemes();
        this.mThemes.add(theme);
        return this.mThemes.size() - 1;
    }

    public void addTheme(Theme theme, int n) {
        this.initThemes();
        try {
            this.mThemes.add(n, theme);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
        }
    }

    public void addPredefinedTheme(String string, String string2) {
    }

    public void addPredefinedTheme(String string, String string2, double d, double d2, boolean bl) {
    }

    public void removeTheme(int n) {
        if (this.mThemes == null) {
            return;
        }
        try {
            this.mThemes.remove(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void removeTheme(String string) {
        for (int i = 0; i < this.mThemes.size(); ++i) {
            Theme theme = (Theme)this.mThemes.elementAt(i);
            if (!theme.getName().equalsIgnoreCase(string)) continue;
            this.removeTheme(i);
            return;
        }
    }

    public void setThemeEnabled(String string, boolean bl) {
        Theme theme = this.getTheme(string);
        if (theme == null) {
            return;
        }
        theme.getDecorator().setEnabled(bl);
    }

    public boolean isThemeEnabled(String string) {
        Theme theme = this.getTheme(string);
        return theme.getDecorator().isEnabled();
    }

    public void setAllThemesEnabled(boolean bl) {
    }

    public void clear() {
        if (this.mThemes == null) {
            return;
        }
        Enumeration enumeration = this.mThemes.elements();
        while (enumeration.hasMoreElements()) {
            Theme theme = (Theme)enumeration.nextElement();
            theme.destroy();
        }
        this.mThemes.removeAllElements();
    }

    public Theme getTheme(int n) {
        try {
            return (Theme)this.mThemes.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public Theme getTheme(String string) {
        for (int i = 0; i < this.mThemes.size(); ++i) {
            Theme theme = (Theme)this.mThemes.get(i);
            if (!theme.getName().equalsIgnoreCase(string)) continue;
            return theme;
        }
        return null;
    }

    public Theme getLastMatchingTheme(String string) {
        for (int i = this.mThemes.size() - 1; i >= 0; --i) {
            Theme theme = (Theme)this.mThemes.get(i);
            if (!theme.getName().equalsIgnoreCase(string)) continue;
            return theme;
        }
        return null;
    }

    public Vector getThemes() {
        return this.mThemes;
    }

    public void setThemes(Collection collection) {
        this.mThemes = new Vector(collection);
    }

    public int size() {
        return this.mThemes != null ? this.mThemes.size() : 0;
    }

    public void moveThemeUp(int n) {
        if (this.mThemes == null || n <= 0) {
            return;
        }
        try {
            Object e = this.mThemes.elementAt(n);
            if (e == null) {
                return;
            }
            this.mThemes.insertElementAt(e, n - 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void moveThemeDown(int n) {
        if (this.mThemes == null || n >= this.mThemes.size() - 1) {
            return;
        }
        try {
            Object e = this.mThemes.elementAt(n);
            this.mThemes.insertElementAt(e, n + 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public boolean hasRasterThemes() {
        if (this.mThemes == null || this.mThemes.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.mThemes.size(); ++i) {
            Theme theme = (Theme)this.mThemes.get(i);
            if (!(theme instanceof ImageTheme) && !(theme instanceof GeoRasterTheme) && !(theme instanceof ShadedReliefTheme) && (!(theme instanceof WMSMapTheme) || !((WMSMapTheme)theme).getIsBackgroundImage())) continue;
            return true;
        }
        return false;
    }

    protected void initThemes() {
        if (this.mThemes == null) {
            this.mThemes = new Vector(32);
        }
    }
}

