/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.Bidi;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.LabelingHints;
import oracle.mapviewer.share.style.TextStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LabelHelper;
import oracle.sdovis.MapMaker;
import oracle.sdovis.StyleFactory;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.TextPlacementInfo;
import oracle.sdovis.VectorRenderer;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.MarkerStyleModifiers;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleMarker;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.style.TextPath;
import oracle.sdovis.style.TextStyleModifiers;
import oracle.sdovis.util.BestFitText;
import oracle.sdovis.util.ShapeUtil;
import oracle.spatial.geometry.JGeometry;

public class TextLabeler {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);

    public static boolean applyTextLabel(Graphics2D graphics2D, StyledFeatureI styledFeatureI, StyleText styleText, String string, boolean bl, boolean bl2, boolean bl3, VisContext visContext) throws StyleNotApplicableException {
        if (styleText == null) {
            return false;
        }
        if (((TextStyleModel)styleText.getModel()).isSticky()) {
            bl = true;
        }
        switch (styledFeatureI.getGeomType()) {
            case 1: {
                return TextLabeler.labelPointFeature(graphics2D, styledFeatureI, styleText, string, bl, visContext);
            }
            case 2: 
            case 6: {
                return TextLabeler.labelLineStringWithText(graphics2D, styleText, styledFeatureI.getShape(), string, bl || styledFeatureI.getForceLabel(), bl2, bl3, visContext);
            }
            case 5: {
                if (!styledFeatureI.getGeometry().isOrientedMultiPoint()) {
                    TextPlacementInfo[] textPlacementInfoArray = TextLabeler.findTextLabelPointsOnMultiPoint(styledFeatureI, styleText, string, bl, visContext);
                    if (textPlacementInfoArray != null) {
                        TextStyleModifiers textStyleModifiers = (TextStyleModifiers)styleText.convertToPixelSize(visContext);
                        for (int i = 0; i < textPlacementInfoArray.length; ++i) {
                            TextPlacementInfo textPlacementInfo = textPlacementInfoArray[i];
                            styleText.apply(graphics2D, textPlacementInfo, visContext, (StyleModifiers)textStyleModifiers);
                        }
                    }
                    return true;
                }
                return TextLabeler.labelOrientedMultiPoint(graphics2D, styledFeatureI, styleText, string, bl, visContext);
            }
            case 3: 
            case 7: {
                return TextLabeler.labelPolygonWithText(graphics2D, styleText, styledFeatureI, string, bl || styledFeatureI.getForceLabel(), visContext);
            }
        }
        return false;
    }

    public static TextPlacementInfo findTextLabelPointOnPointFeature(StyledFeatureI styledFeatureI, StyleText styleText, String string, boolean bl, VisContext visContext) {
        float f = 0.0f;
        float f2 = 0.0f;
        TextStyleModifiers textStyleModifiers = (TextStyleModifiers)styleText.convertToPixelSize(visContext);
        Shape shape = StyleText.getStringOutline(string, (TextStyleModel)styleText.getModel(), textStyleModifiers);
        if (shape == null) {
            return null;
        }
        TextPlacementInfo textPlacementInfo = new TextPlacementInfo(string);
        textPlacementInfo.setTextShape(shape);
        Rectangle2D rectangle2D = shape.getBounds2D();
        Rectangle2D rectangle2D2 = styledFeatureI.getShpMBR();
        textPlacementInfo.setTextShapeMBR((Rectangle2D)rectangle2D.clone());
        if (rectangle2D2 == null) {
            rectangle2D2 = new Rectangle2D.Float(0.0f, 0.0f, 5.0f, 3.0f);
        }
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        f = (float)styledFeatureI.getPoint().getX();
        f2 = (float)styledFeatureI.getPoint().getY();
        float f5 = (float)rectangle2D2.getWidth() / 2.0f + 2.0f;
        float f6 = (float)rectangle2D2.getHeight() / 2.0f + 2.0f;
        rectangle2D.setRect(f + f5, f2 - f4 / 2.0f, f3, f4);
        if (!(visContext.isTileRequest() && !visContext.deviceWindow.contains(rectangle2D) || visContext.getCRArray().conflicts(rectangle2D) || visContext.getMarkerCRArray().conflicts(rectangle2D))) {
            textPlacementInfo.setTextCenter(f + f5 + f3 / 2.0f, f2);
            return textPlacementInfo;
        }
        rectangle2D.setRect(f - f5 - f3, f2 - f4 / 2.0f, f3, f4);
        if (!(visContext.isTileRequest() && !visContext.deviceWindow.contains(rectangle2D) || visContext.getCRArray().conflicts(rectangle2D) || visContext.getMarkerCRArray().conflicts(rectangle2D))) {
            textPlacementInfo.setTextCenter(f - f5 - f3 / 2.0f, f2);
            return textPlacementInfo;
        }
        rectangle2D.setRect(f - f3 / 2.0f, f2 - f4 - f6, f3, f4);
        if (!(visContext.isTileRequest() && !visContext.deviceWindow.contains(rectangle2D) || visContext.getCRArray().conflicts(rectangle2D) || visContext.getMarkerCRArray().conflicts(rectangle2D))) {
            textPlacementInfo.setTextCenter(f, f2 - f4 / 2.0f - f6);
            return textPlacementInfo;
        }
        rectangle2D.setRect(f - f3 / 2.0f, f2 + f6, f3, f4);
        if (!(visContext.isTileRequest() && !visContext.deviceWindow.contains(rectangle2D) || visContext.getCRArray().conflicts(rectangle2D) || visContext.getMarkerCRArray().conflicts(rectangle2D))) {
            textPlacementInfo.setTextCenter(f, f2 + f4 / 2.0f + f6);
            return textPlacementInfo;
        }
        rectangle2D.setRect(f + f5 - 2.0f, f2 - f6 + 2.0f, f3, f4);
        if (!(visContext.isTileRequest() && !visContext.deviceWindow.contains(rectangle2D) || visContext.getCRArray().conflicts(rectangle2D) || visContext.getMarkerCRArray().conflicts(rectangle2D))) {
            textPlacementInfo.setTextCenter(f + f5 - 2.0f + f3 / 2.0f, f2 + f4 / 2.0f - f6 + 2.0f);
            return textPlacementInfo;
        }
        rectangle2D.setRect(f + f5 - 2.0f, f2 + f6 - 2.0f, f3, f4);
        if (!(visContext.isTileRequest() && !visContext.deviceWindow.contains(rectangle2D) || visContext.getCRArray().conflicts(rectangle2D) || visContext.getMarkerCRArray().conflicts(rectangle2D))) {
            textPlacementInfo.setTextCenter(f + f5 - 2.0f + f3 / 2.0f, f2 + f4 / 2.0f + f6 - 2.0f);
            return textPlacementInfo;
        }
        rectangle2D.setRect(f - f5 + 2.0f - f3, f2 + f6 - 2.0f, f3, f4);
        if (!(visContext.isTileRequest() && !visContext.deviceWindow.contains(rectangle2D) || visContext.getCRArray().conflicts(rectangle2D) || visContext.getMarkerCRArray().conflicts(rectangle2D))) {
            textPlacementInfo.setTextCenter(f - f5 + 2.0f - f3 / 2.0f, f2 + f4 / 2.0f + f6 - 2.0f);
            return textPlacementInfo;
        }
        rectangle2D.setRect(f - f5 + 2.0f - f3, f2 - f6 + 2.0f, f3, f4);
        if (!(visContext.isTileRequest() && !visContext.deviceWindow.contains(rectangle2D) || visContext.getCRArray().conflicts(rectangle2D) || visContext.getMarkerCRArray().conflicts(rectangle2D))) {
            textPlacementInfo.setTextCenter(f - f5 + 2.0f - f3 / 2.0f, f2 + f4 / 2.0f - f6 + 2.0f);
            return textPlacementInfo;
        }
        if (bl) {
            rectangle2D.setRect(f + f5, f2 - f4 / 2.0f, f3, f4);
            double d = f + f5 + f3 / 2.0f;
            double d2 = f2;
            boolean bl2 = true;
            if (visContext.isTileRequest() && !visContext.deviceWindow.contains(rectangle2D)) {
                rectangle2D.setRect(f - f5 - f3, f2 - f4 / 2.0f, f3, f4);
                d = f - f5 - f3 / 2.0f;
                d2 = f2;
                if (!visContext.deviceWindow.contains(rectangle2D)) {
                    rectangle2D.setRect(f - f3 / 2.0f, f2 + f6, f3, f4);
                    d = f;
                    d2 = f2 + f4 / 2.0f + f6;
                    if (!visContext.deviceWindow.contains(rectangle2D)) {
                        rectangle2D.setRect(f - f3 / 2.0f, f2 - f4 - f6, f3, f4);
                        d = f;
                        d2 = f2 - f4 / 2.0f - f6;
                        if (!visContext.deviceWindow.contains(rectangle2D)) {
                            rectangle2D.setRect(f + f5 - 2.0f, f2 - f6 + 2.0f, f3, f4);
                            d = f + f5 - 2.0f + f3 / 2.0f;
                            d2 = f2 + f4 / 2.0f - f6 + 2.0f;
                            if (!visContext.deviceWindow.contains(rectangle2D)) {
                                rectangle2D.setRect(f + f5 - 2.0f, f2 + f6 - 2.0f, f3, f4);
                                d = f + f5 - 2.0f + f3 / 2.0f;
                                d2 = f2 + f4 / 2.0f + f6 - 2.0f;
                                if (!visContext.deviceWindow.contains(rectangle2D)) {
                                    rectangle2D.setRect(f - f5 + 2.0f - f3, f2 + f6 - 2.0f, f3, f4);
                                    d = f - f5 + 2.0f - f3 / 2.0f;
                                    d2 = f2 + f4 / 2.0f + f6 - 2.0f;
                                    if (!visContext.deviceWindow.contains(rectangle2D)) {
                                        rectangle2D.setRect(f - f5 + 2.0f - f3, f2 - f6 + 2.0f, f3, f4);
                                        d = f - f5 + 2.0f - f3 / 2.0f;
                                        d2 = f2 + f4 / 2.0f - f6 + 2.0f;
                                        if (!visContext.deviceWindow.contains(rectangle2D)) {
                                            bl2 = false;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (bl2) {
                textPlacementInfo.setTextCenter((float)d, (float)d2);
                return textPlacementInfo;
            }
        }
        return null;
    }

    public static TextPlacementInfo findTextLabelPointOnOrientedPoint(StyledFeatureI styledFeatureI, StyleText styleText, String string, boolean bl, VisContext visContext) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        TextStyleModifiers textStyleModifiers = (TextStyleModifiers)styleText.convertToPixelSize(visContext);
        Shape shape = StyleText.getStringOutline(string, (TextStyleModel)styleText.getModel(), textStyleModifiers);
        if (shape == null) {
            return null;
        }
        TextPlacementInfo textPlacementInfo = new TextPlacementInfo(string);
        textPlacementInfo.setTextShape(shape);
        Rectangle2D rectangle2D = shape.getBounds2D();
        textPlacementInfo.setTextShapeMBR(rectangle2D);
        f = (float)styledFeatureI.getPoint().getX();
        f2 = (float)styledFeatureI.getPoint().getY();
        double d = styledFeatureI.getMarkerStyleOrientation();
        LabelingHints labelingHints = ((TextStyleModel)styleText.getModel()).getLabelingHints();
        Object object = labelingHints.get(LabelingHints.KEY_OPOINT_HALIGN);
        Object object2 = labelingHints.get(LabelingHints.KEY_OPOINT_VALIGN);
        if (object == null) {
            object = LabelingHints.VALUE_OPOINT_HALIGN_CENTER;
        }
        if (object2 == null) {
            object2 = LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE;
        }
        double d2 = rectangle2D.getWidth();
        double d3 = rectangle2D.getHeight();
        f3 = LabelingHints.VALUE_OPOINT_HALIGN_CENTER == object ? f : (LabelingHints.VALUE_OPOINT_HALIGN_START == object ? (float)((double)f + d2 / 2.0) : (float)((double)f - d2 / 2.0));
        f4 = LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE == object2 ? f2 : (LabelingHints.VALUE_OPOINT_VALIGN_TOP == object2 ? (float)((double)f2 + d3 / 2.0) : (float)((double)f2 - d3 / 2.0));
        textPlacementInfo.setTextCenter(f3, f4);
        textPlacementInfo.setRotation(d, f, f2);
        Rectangle2D rectangle2D2 = visContext.getDeviceWindow();
        if (!visContext.isTileRequest() || f < 0.0f || (double)f >= rectangle2D2.getWidth() || f2 < 0.0f || (double)f2 >= rectangle2D2.getHeight()) {
            return textPlacementInfo;
        }
        Rectangle2D rectangle2D3 = TextLabeler.getTextMBR(textPlacementInfo);
        if (rectangle2D2.contains(rectangle2D3)) {
            return textPlacementInfo;
        }
        float f5 = visContext.getThemeWindowBuffer();
        if (rectangle2D3.getMinX() < 0.0 && f > f5 || rectangle2D3.getMinY() < 0.0 && f2 > f5 || rectangle2D3.getMaxX() > rectangle2D2.getWidth() && (double)f < rectangle2D2.getWidth() - (double)f5 || rectangle2D3.getMaxY() > rectangle2D2.getHeight() && (double)f2 < rectangle2D2.getHeight() - (double)f5) {
            return null;
        }
        return textPlacementInfo;
    }

    public static TextPlacementInfo[] findTextLabelPointsOnMultiPoint(StyledFeatureI styledFeatureI, StyleText styleText, String string, boolean bl, VisContext visContext) {
        Shape shape = styledFeatureI.getShape();
        if (shape == null) {
            return null;
        }
        PathIterator pathIterator = shape.getPathIterator(null);
        float[] fArray = new float[6];
        Vector<TextPlacementInfo> vector = new Vector<TextPlacementInfo>();
        int n = 0;
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(fArray);
            if (n2 == 0 || n2 == 1) {
                TextPlacementInfo textPlacementInfo;
                StyledFeature styledFeature = new StyledFeature();
                styledFeature.setGeomType(1);
                styledFeature.setPoint(new Point2D.Float(fArray[0], fArray[1]));
                if (styledFeatureI.getMultiPointShapeMBRs() != null) {
                    styledFeature.setMBR(styledFeatureI.getMultiPointShapeMBRs()[n]);
                }
                if ((textPlacementInfo = TextLabeler.findTextLabelPointOnPointFeature(styledFeature, styleText, string, bl, visContext)) != null) {
                    vector.add(textPlacementInfo);
                }
                ++n;
            }
            pathIterator.next();
        }
        return vector.toArray(new TextPlacementInfo[vector.size()]);
    }

    public static TextPlacementInfo findTextLabelPointOnAreaFeature(Graphics2D graphics2D, StyledFeatureI styledFeatureI, StyleText styleText, String string, boolean bl, VisContext visContext) {
        Shape shape = styledFeatureI.getShape();
        if (shape == null) {
            return null;
        }
        TextStyleModifiers textStyleModifiers = (TextStyleModifiers)styleText.convertToPixelSize(visContext);
        Shape shape2 = StyleText.getStringOutline(string, (TextStyleModel)styleText.getModel(), textStyleModifiers);
        if (shape2 == null) {
            return null;
        }
        TextPlacementInfo textPlacementInfo = new TextPlacementInfo(string);
        textPlacementInfo.setTextShape(shape2);
        Rectangle2D rectangle2D = shape2.getBounds2D();
        textPlacementInfo.setTextShapeMBR((Rectangle2D)rectangle2D.clone());
        float f = (float)rectangle2D.getMinX();
        float f2 = (float)rectangle2D.getMinY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        float[] fArray = null;
        if (!visContext.isTileRequest()) {
            fArray = LabelHelper.findLoc4RectInPolygon(graphics2D, shape, (double)((int)f3 + 2), (double)((int)f4 + 2), visContext.getCRArray(), bl, true, null);
        } else {
            fArray = LabelHelper.findLoc4RectInPolygon(shape, (int)f3, (int)f4, visContext.getCRArray(), bl, false, null);
            if (fArray != null) {
                float f5 = fArray[0];
                float f6 = fArray[1] - f4;
                if ((double)(f5 + f3 / 2.0f) >= visContext.deviceWindow.getMinX() && (double)(f5 + f3 / 2.0f) < visContext.deviceWindow.getMaxX() && (double)(f6 + f4 / 2.0f) >= visContext.deviceWindow.getMinY() && (double)(f6 + f4 / 2.0f) < visContext.deviceWindow.getMaxY()) {
                    if (!visContext.deviceWindow.contains(f5, f6) || !visContext.deviceWindow.contains(f5 + f3, f6 + f4)) {
                        fArray = LabelHelper.findLoc4RectInPolygon(shape, (int)f3, (int)f4, visContext.getCRArray(), bl, false, visContext.deviceWindow);
                    }
                } else {
                    fArray = null;
                }
            }
        }
        if (fArray != null) {
            textPlacementInfo.setTextCenter(fArray[0] + f3 / 2.0f, fArray[1] - f4 / 2.0f);
            textPlacementInfo.setRotation(fArray[2], fArray[0], fArray[1]);
            return textPlacementInfo;
        }
        return null;
    }

    private static boolean labelPointFeature(Graphics2D graphics2D, StyledFeatureI styledFeatureI, StyleText styleText, String string, boolean bl, VisContext visContext) throws StyleNotApplicableException {
        int n = (int)visContext.getDeviceWindow().getWidth();
        int n2 = (int)visContext.getDeviceWindow().getHeight();
        float f = (float)styledFeatureI.getPoint().getX();
        float f2 = (float)styledFeatureI.getPoint().getY();
        TextPlacementInfo textPlacementInfo = null;
        if (styledFeatureI.getGeometry() == null || !styledFeatureI.getGeometry().isOrientedPoint() && !styledFeatureI.labelAsOrientedPoint()) {
            if (f < 0.0f || f >= (float)n || f2 < 0.0f || f2 >= (float)n2) {
                return false;
            }
            textPlacementInfo = TextLabeler.findTextLabelPointOnPointFeature(styledFeatureI, styleText, string, bl || styledFeatureI.getForceLabel(), visContext);
        } else {
            if (!visContext.isTileRequest() && (f < 0.0f || f >= (float)n || f2 < 0.0f || f2 >= (float)n2)) {
                return false;
            }
            textPlacementInfo = TextLabeler.findTextLabelPointOnOrientedPoint(styledFeatureI, styleText, string, bl || styledFeatureI.getForceLabel(), visContext);
        }
        if (textPlacementInfo != null) {
            Object object;
            if (!styledFeatureI.isAllowNakedPoints()) {
                styledFeatureI.setAllowNakedPoints(true);
                object = VectorRenderer.getPointOfPointFeature(styledFeatureI, visContext);
                if (object != null) {
                    Style style = null;
                    style = styledFeatureI.getFeatureStyle();
                    if (style == null) {
                        style = MapMaker.getStyleWithName(styledFeatureI.getFeatureStyleName(), styledFeatureI.getDataSource(), visContext);
                    }
                    if (style == null) {
                        style = StyleFactory.getDefaultStyle(1);
                    }
                    if (style instanceof StyleMarker) {
                        Object object2;
                        int n3 = styledFeatureI.getMarkerStyleSize();
                        int n4 = 9;
                        int n5 = 9;
                        StyleMarker styleMarker = (StyleMarker)style;
                        if (n3 > 0) {
                            n4 = n3;
                            n5 = n3;
                        } else {
                            object2 = (MarkerStyleModifiers)styleMarker.convertToPixelSize(visContext);
                            if (object2 != null) {
                                if (((MarkerStyleModifiers)object2).getWidth() > 0) {
                                    n4 = ((MarkerStyleModifiers)object2).getWidth();
                                }
                                if (((MarkerStyleModifiers)object2).getHeight() > 0) {
                                    n5 = ((MarkerStyleModifiers)object2).getHeight();
                                }
                            } else {
                                if (styleMarker.getDesiredWidth() > 0) {
                                    n4 = styleMarker.getDesiredWidth();
                                }
                                if (styleMarker.getDesiredHeight() > 0) {
                                    n5 = styleMarker.getDesiredHeight();
                                }
                            }
                        }
                        object2 = new Rectangle2D.Float((float)(((Point2D)object).getX() - (double)(n4 / 2)), (float)(((Point2D)object).getY() - (double)(n5 / 2)), n4, n5);
                        if (visContext.getCRArray().conflicts((Rectangle2D)object2)) {
                            return true;
                        }
                        VectorRenderer.drawMarkerOnPoint(graphics2D, (StyleMarker)style, styledFeatureI, (Point2D)object, visContext, 9, 9);
                    }
                }
            }
            object = (TextStyleModifiers)styleText.convertToPixelSize(visContext);
            styleText.apply(graphics2D, textPlacementInfo, visContext, (StyleModifiers)object);
        }
        return true;
    }

    private static boolean labelOrientedMultiPoint(Graphics2D graphics2D, StyledFeatureI styledFeatureI, StyleText styleText, String string, boolean bl, VisContext visContext) {
        int[] nArray = styledFeatureI.getGeometry().getElemInfo();
        double[] dArray = styledFeatureI.getGeometry().getOrdinatesArray();
        int n = styledFeatureI.getGeometry().getDimensions();
        float[] fArray = new float[6];
        PathIterator pathIterator = styledFeatureI.getShape().getPathIterator(null);
        int n2 = 0;
        while (!pathIterator.isDone()) {
            int n3 = pathIterator.currentSegment(fArray);
            if (n3 == 0 || n3 == 1) {
                StyledFeature styledFeature = new StyledFeature();
                styledFeature.setPoint(new Point2D.Double(fArray[0], fArray[1]));
                styledFeature.setGeomType(1);
                styledFeature.setFeatureStyle(styledFeatureI.getFeatureStyle());
                styledFeature.setFeatureStyleName(styledFeatureI.getFeatureStyleName());
                styledFeature.setLabelStyle(styledFeatureI.getLabelStyle());
                styledFeature.setLabelStyleName(styledFeatureI.getLabelStyleName());
                int n4 = nArray[n2 * 6] - 1;
                int n5 = nArray[n2 * 6 + 3] - 1;
                int[] nArray2 = new int[]{1, 1, 1, 3, 1, 0};
                double[] dArray2 = new double[n + 2];
                for (int i = 0; i < n + 2; ++i) {
                    dArray2[i] = dArray[n4 + i];
                }
                JGeometry jGeometry = new JGeometry(n * 1000 + 1, styledFeatureI.getGeometry().getSRID(), nArray2, dArray2);
                styledFeature.setGeometry(JSDOGeometry.recast(jGeometry));
                double d = dArray[n5];
                double d2 = dArray[n5 + 1];
                styledFeature.setMarkerStyleOrientation(Math.atan2(-d2, d));
                try {
                    TextLabeler.labelPointFeature(graphics2D, styledFeature, styleText, string, bl, visContext);
                }
                catch (StyleNotApplicableException styleNotApplicableException) {
                    // empty catch block
                }
            }
            pathIterator.next();
            ++n2;
        }
        return true;
    }

    private static boolean labelLineStringWithText(Graphics2D graphics2D, StyleText styleText, Shape shape, String string, boolean bl, boolean bl2, boolean bl3, VisContext visContext) {
        double d;
        TextStyleModifiers textStyleModifiers = (TextStyleModifiers)styleText.convertToPixelSize(visContext);
        double d2 = styleText.getCoarseVisualLength(string);
        if (d2 == 0.0) {
            Rectangle2D rectangle2D = styleText.getVisualBounds(string, textStyleModifiers);
            d2 = rectangle2D.getWidth();
        }
        if (d2 > (d = ShapeUtil.lengthOf(shape)) * 0.9 && !bl) {
            return false;
        }
        Shape shape2 = null;
        try {
            shape2 = ShapeUtil.clipLineString(visContext.getDeviceWindow(), shape);
        }
        catch (Exception exception) {
            log.log(Level.FINER, "exception while clipping a line string.", exception);
            return false;
        }
        if (shape2 == null) {
            return false;
        }
        try {
            Object object;
            Shape shape3 = null;
            char[] cArray = string.toCharArray();
            TextStyleModel textStyleModel = (TextStyleModel)styleText.getModel();
            if (textStyleModel.isStraightLineLabeling() || Bidi.requiresBidi(cArray, 0, cArray.length)) {
                object = new BestFitText();
                TextPath textPath = new TextPath((TextStyleModel)styleText.getModel(), textStyleModifiers);
                shape3 = ((BestFitText)object).putTextOnBestFitLine(textPath, graphics2D, shape2, string, d2, visContext.getCRArray(), bl, bl2, bl3);
            } else {
                object = new TextPath((TextStyleModel)styleText.getModel(), textStyleModifiers);
                shape3 = ((TextPath)object).putTextOnPath(graphics2D, shape2, string, d2, visContext.getCRArray(), bl, bl2, bl3);
            }
            if (shape3 == null) {
                return false;
            }
            object = shape3.getBounds2D();
            if (!visContext.getDeviceWindow().contains((Rectangle2D)object)) {
                return false;
            }
            if (((TextStyleModel)styleText.getModel()).haloEnabled()) {
                styleText.applyHalo(graphics2D, shape3, textStyleModifiers);
            }
            graphics2D.setColor(((TextStyleModel)styleText.getModel()).getColor());
            graphics2D.fill(shape3);
            return true;
        }
        catch (Exception exception) {
            log.log(Level.FINER, "Exception while labeling text along path.", exception);
            return false;
        }
    }

    private static boolean labelPolygonWithText(Graphics2D graphics2D, StyleText styleText, StyledFeatureI styledFeatureI, String string, boolean bl, VisContext visContext) {
        TextPlacementInfo textPlacementInfo = TextLabeler.findTextLabelPointOnAreaFeature(graphics2D, styledFeatureI, styleText, string, bl, visContext);
        if (textPlacementInfo != null) {
            TextStyleModifiers textStyleModifiers = (TextStyleModifiers)styleText.convertToPixelSize(visContext);
            styleText.apply(graphics2D, textPlacementInfo, visContext, (StyleModifiers)textStyleModifiers);
            return true;
        }
        return false;
    }

    private static Rectangle2D getTextMBR(TextPlacementInfo textPlacementInfo) {
        Shape shape = textPlacementInfo.getTextShape();
        Rectangle2D rectangle2D = textPlacementInfo.getTextShapeMBR();
        AffineTransform affineTransform = new AffineTransform();
        double d = textPlacementInfo.getRotation();
        if (d != 0.0) {
            affineTransform.setToRotation(d, textPlacementInfo.getRotationAnchorX(), textPlacementInfo.getRotationAnchorY());
        }
        float f = (float)((double)textPlacementInfo.getTextCenterX() - rectangle2D.getCenterX());
        float f2 = (float)((double)textPlacementInfo.getTextCenterY() - rectangle2D.getCenterY());
        if (f != 0.0f || f2 != 0.0f) {
            affineTransform.translate(f, f2);
        }
        shape = affineTransform.createTransformedShape(shape);
        return shape.getBounds2D();
    }
}

