/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import oracle.sdovis.StyleFactory;
import oracle.sdovis.style.Style;
import oracle.sdovis.util.Base64OutputStream;

public class StyleRowData
implements Serializable {
    public String name = "";
    public String type = null;
    public String description = "";
    public String definition = null;
    public byte[] image = null;
    public Object geometry = null;

    public Style toStyle() {
        if (this.type == null || this.name == null) {
            return null;
        }
        int n = StyleRowData.getTypeCode(this.type);
        if (n == 0) {
            return null;
        }
        Style style = StyleFactory.createStyleObject(n, this.definition, this.image);
        return style;
    }

    public String toXmlFileFormat() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("    <style>\n");
        stringBuffer.append("        <name>" + this.name.toUpperCase() + "</name>\n");
        stringBuffer.append("        <type>" + this.type.toUpperCase() + "</type>\n");
        stringBuffer.append("        <description>" + this.description + "</type>\n");
        stringBuffer.append("        <definition><!CDATA[" + this.definition + "]]</definition>\n");
        stringBuffer.append("        <image>" + StyleRowData.base64Encode(this.image) + "</image>\n");
        stringBuffer.append("        <geometry/>\n");
        stringBuffer.append("    </style>\n");
        return stringBuffer.toString();
    }

    public static String base64Encode(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return "";
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Base64OutputStream base64OutputStream = new Base64OutputStream(byteArrayOutputStream, false);
            base64OutputStream.write(byArray);
            base64OutputStream.flush();
            base64OutputStream.close();
            return byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static int getTypeCode(String string) {
        int n = 0;
        if (string.equalsIgnoreCase("AREA")) {
            n = 4;
        } else if (string.equalsIgnoreCase("COLOR")) {
            n = 1;
        } else if (string.equalsIgnoreCase("LINE")) {
            n = 3;
        } else if (string.equalsIgnoreCase("MARKER")) {
            n = 2;
        } else if (string.equalsIgnoreCase("TEXT")) {
            n = 5;
        } else if (string.equalsIgnoreCase("ADVANCED")) {
            n = 9;
        } else if (string.equalsIgnoreCase("TTF")) {
            n = 99;
        }
        return n;
    }
}

