/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Color;
import java.awt.Font;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.DataException;
import oracle.sdovis.RSBundle;
import oracle.sdovis.StyleCache;
import oracle.sdovis.StyleRowData;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleArea;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleLine;
import oracle.sdovis.style.StyleMarker;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.stylex.AdvancedStyle;
import oracle.sdovis.stylex.BarChartStyle;
import oracle.sdovis.stylex.BucketStyle;
import oracle.sdovis.stylex.CollectionStyle;
import oracle.sdovis.stylex.ColorSchemeStyle;
import oracle.sdovis.stylex.DotDensityStyle;
import oracle.sdovis.stylex.HeatMapStyle;
import oracle.sdovis.stylex.PieChartStyle;
import oracle.sdovis.stylex.VariableMarkerStyle;
import oracle.sdovis.stylex.VariablePieChartStyle;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StyleFactory {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static Style _4Point = new StyleColor(Color.red, Color.red);
    private static Style _4LineString = new StyleColor(null, Color.black);
    private static Style _4Polygon = new StyleColor(new Color(Color.darkGray.getRed(), Color.darkGray.getGreen(), Color.darkGray.getBlue(), 128), Color.black);
    private static Style _4Text = new StyleText(new Font("Dialog", 0, 12), Color.blue, 2.0f);

    public static Style createStyleFromXML(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("class=");
        int n2 = 0;
        if (n < 0) {
            return null;
        }
        n2 = n += 7;
        try {
            while (string.charAt(n2++) != '\"') {
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.err.println(RSBundle.getMsg("MAPVIEWER-01008"));
            return null;
        }
        String string2 = string.substring(n, n2 - 1);
        if (string2 == null || string2.length() < 4) {
            System.err.println(RSBundle.getMsg("MAPVIEWER-01009"));
            return null;
        }
        string2 = string2.toUpperCase();
        try {
            if (string2.equals("COLOR")) {
                return new StyleColor(string);
            }
            if (string2.equals("LINE")) {
                return new StyleLine(string);
            }
            if (string2.equals("TEXT")) {
                return new StyleText(string);
            }
            if (string2.equals("MARKER")) {
                return new StyleMarker(string);
            }
            if (string2.equals("AREA")) {
                return new StyleArea(string, null);
            }
            System.err.println(RSBundle.getMsg("MAPVIEWER-01010"));
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static String getSimpleStyleTypeFromXML(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("class=");
        int n2 = 0;
        if (n < 0) {
            return null;
        }
        n2 = n += 7;
        try {
            while (string.charAt(n2++) != '\"') {
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
        String string2 = string.substring(n, n2 - 1);
        if (string2 == null || string2.length() < 4) {
            return null;
        }
        if ((string2 = string2.toUpperCase()).equals("COLOR")) {
            return "COLOR";
        }
        if (string2.equals("LINE")) {
            return "LINE";
        }
        if (string2.equals("TEXT")) {
            return "TEXT";
        }
        if (string2.equals("MARKER")) {
            return "MARKER";
        }
        if (string2.equals("AREA")) {
            return "AREA";
        }
        return null;
    }

    public static Style getDefaultStyle(int n) {
        switch (n) {
            case 1: 
            case 5: {
                return _4Point;
            }
            case 2: 
            case 6: {
                return _4LineString;
            }
            case 3: 
            case 7: {
                return _4Polygon;
            }
        }
        return null;
    }

    public static Style getDefaultTextStyle() {
        return _4Text;
    }

    public static AdvancedStyle createAdvancedStyle(Document document, StyleCache styleCache, Hashtable hashtable) throws DataException {
        Node node = XMLDOMParser.getSubElement(document, "AdvancedStyle");
        if (node == null) {
            System.err.println("Invalid advanced style definition.");
            return null;
        }
        try {
            Node node2 = XMLDOMParser.getSubElement(node, "BucketStyle");
            if (node2 != null) {
                BucketStyle bucketStyle = new BucketStyle(document);
                bucketStyle.resolveStyles(styleCache, hashtable);
                return bucketStyle;
            }
            node2 = XMLDOMParser.getSubElement(XMLDOMParser.getSubElement(node, "ColorSchemeStyle"), "Buckets");
            if (node2 != null) {
                ColorSchemeStyle colorSchemeStyle = new ColorSchemeStyle(document);
                colorSchemeStyle.resolveStyles(styleCache, hashtable);
                return colorSchemeStyle;
            }
            node2 = XMLDOMParser.getSubElement(XMLDOMParser.getSubElement(node, "VariableMarkerStyle"), "Buckets");
            if (node2 != null) {
                VariableMarkerStyle variableMarkerStyle = new VariableMarkerStyle(document);
                variableMarkerStyle.resolveStyles(styleCache, hashtable);
                return variableMarkerStyle;
            }
            node2 = XMLDOMParser.getSubElement(XMLDOMParser.getSubElement(node, "VariablePieChartStyle"), "Buckets");
            if (node2 != null) {
                VariablePieChartStyle variablePieChartStyle = new VariablePieChartStyle(document);
                variablePieChartStyle.resolveStyles(styleCache, hashtable);
                return variablePieChartStyle;
            }
            node2 = XMLDOMParser.getSubElement(node, "PieChartStyle");
            if (node2 != null) {
                PieChartStyle pieChartStyle = new PieChartStyle(document);
                pieChartStyle.resolveStyles(styleCache, hashtable);
                return pieChartStyle;
            }
            node2 = XMLDOMParser.getSubElement(node, "DotDensityStyle");
            if (node2 != null) {
                DotDensityStyle dotDensityStyle = new DotDensityStyle(document);
                dotDensityStyle.resolveStyles(styleCache, hashtable);
                return dotDensityStyle;
            }
            node2 = XMLDOMParser.getSubElement(node, "CollectionStyle");
            if (node2 != null) {
                CollectionStyle collectionStyle = new CollectionStyle(document);
                collectionStyle.resolveStyles(styleCache, hashtable);
                return collectionStyle;
            }
            node2 = XMLDOMParser.getSubElement(node, "BarChartStyle");
            if (node2 != null) {
                BarChartStyle barChartStyle = new BarChartStyle(document);
                barChartStyle.resolveStyles(styleCache, hashtable);
                return barChartStyle;
            }
            node2 = XMLDOMParser.getSubElement(node, "HeatMapStyle");
            if (node2 != null) {
                HeatMapStyle heatMapStyle = new HeatMapStyle(document);
                heatMapStyle.resolveStyles(styleCache, hashtable);
                return heatMapStyle;
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static AdvancedStyle createAdvancedStyle(Document document) throws DataException {
        Node node = XMLDOMParser.getSubElement(document, "AdvancedStyle");
        if (node == null) {
            System.err.println("Invalid advanced style definition.");
            return null;
        }
        try {
            Node node2 = XMLDOMParser.getSubElement(node, "BucketStyle");
            if (node2 != null) {
                BucketStyle bucketStyle = new BucketStyle(document);
                return bucketStyle;
            }
            node2 = XMLDOMParser.getSubElement(XMLDOMParser.getSubElement(node, "ColorSchemeStyle"), "Buckets");
            if (node2 != null) {
                return new ColorSchemeStyle(document);
            }
            node2 = XMLDOMParser.getSubElement(XMLDOMParser.getSubElement(node, "VariableMarkerStyle"), "Buckets");
            if (node2 != null) {
                VariableMarkerStyle variableMarkerStyle = new VariableMarkerStyle(document);
                return variableMarkerStyle;
            }
            node2 = XMLDOMParser.getSubElement(XMLDOMParser.getSubElement(node, "VariablePieChartStyle"), "Buckets");
            if (node2 != null) {
                VariablePieChartStyle variablePieChartStyle = new VariablePieChartStyle(document);
                return variablePieChartStyle;
            }
            node2 = XMLDOMParser.getSubElement(node, "PieChartStyle");
            if (node2 != null) {
                PieChartStyle pieChartStyle = new PieChartStyle(document);
                return pieChartStyle;
            }
            node2 = XMLDOMParser.getSubElement(node, "DotDensityStyle");
            if (node2 != null) {
                DotDensityStyle dotDensityStyle = new DotDensityStyle(document);
                return dotDensityStyle;
            }
            node2 = XMLDOMParser.getSubElement(node, "CollectionStyle");
            if (node2 != null) {
                CollectionStyle collectionStyle = new CollectionStyle(document);
                return collectionStyle;
            }
            node2 = XMLDOMParser.getSubElement(node, "BarChartStyle");
            if (node2 != null) {
                BarChartStyle barChartStyle = new BarChartStyle(document);
                return barChartStyle;
            }
            node2 = XMLDOMParser.getSubElement(node, "HeatMapStyle");
            if (node2 != null) {
                HeatMapStyle heatMapStyle = new HeatMapStyle(document);
                return heatMapStyle;
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static String[] getStyleNames(Document document) throws DataException {
        Node node = XMLDOMParser.getSubElement(document, "AdvancedStyle");
        if (node == null) {
            System.err.println("Invalid advanced style definition.");
            return null;
        }
        String[] stringArray = null;
        int n = 0;
        try {
            Node node2 = XMLDOMParser.getSubElement(XMLDOMParser.getSubElement(node, "BucketStyle"), "Buckets");
            if (node2 != null) {
                boolean bl = false;
                NodeList nodeList = node2.getChildNodes();
                Object var7_8 = null;
                if (nodeList != null) {
                    n = nodeList.getLength();
                }
                if (n == 0) {
                    bl = true;
                    n = Integer.parseInt(XMLDOMParser.getAttribute(node2, "nbuckets"));
                }
                if (bl) {
                    System.out.println("equal ranged buckets");
                    String string = XMLDOMParser.getAttribute(node2, "styles");
                    if (string != null && string.length() > 5) {
                        ArrayList arrayList = Util.splitBy(string, ",");
                        stringArray = arrayList.toArray(new String[arrayList.size()]);
                    }
                } else {
                    stringArray = new String[n];
                    for (int i = 0; i < n; ++i) {
                        String string;
                        stringArray[i] = "";
                        Node node3 = nodeList.item(i);
                        if (node3.getNodeName().equalsIgnoreCase("RangedBucket")) {
                            string = XMLDOMParser.getAttribute(node3, "style");
                            if (string != null && string.length() > 0) {
                                stringArray[i] = string;
                                continue;
                            }
                            stringArray[i] = "";
                            continue;
                        }
                        if (!node3.getNodeName().equalsIgnoreCase("CollectionBucket")) continue;
                        string = XMLDOMParser.getAttribute(node3, "style");
                        stringArray[i] = string != null && string.length() > 0 ? string : "";
                    }
                }
                return stringArray;
            }
            node2 = XMLDOMParser.getSubElement(node, "VariableMarkerStyle");
            if (node2 != null) {
                stringArray = new String[]{XMLDOMParser.getAttribute(node2, "basemarker")};
                return stringArray;
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void createDynamicStyles(Hashtable hashtable, String string, VisContext visContext) {
        Object object;
        String string2;
        String string3;
        if (hashtable == null || hashtable.size() == 0) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            string2 = (String)hashtable.get(string3);
            if (string2.indexOf("<AdvancedStyle") > 0 || (object = StyleFactory.getSimpleStyleTypeFromXML(string2)) == null) continue;
            if (((String)object).equals("LINE")) {
                vector.add(string3);
                vector.add(string2);
                continue;
            }
            if (((String)object).equals("AREA")) {
                vector2.add(string3);
                vector2.add(string2);
                continue;
            }
            try {
                Style style = StyleFactory.createStyle(string2, string, visContext);
                if (style == null) continue;
                style.getModel().setName(string3);
                visContext.addDynamicStyle(string3, style);
            }
            catch (Exception exception) {
                log.log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); i += 2) {
                string3 = (String)vector.get(i);
                string2 = (String)vector.get(i + 1);
                try {
                    object = StyleFactory.createStyle(string2, string, visContext);
                    if (object == null) continue;
                    object.getModel().setName(string3);
                    visContext.addDynamicStyle(string3, (Style)object);
                    continue;
                }
                catch (Exception exception) {
                    log.log(Level.WARNING, exception.getMessage(), exception);
                }
            }
        }
        if (vector2.size() > 0) {
            for (int i = 0; i < vector2.size(); i += 2) {
                string3 = (String)vector2.get(i);
                string2 = (String)vector2.get(i + 1);
                try {
                    object = StyleFactory.createStyle(string2, string, visContext);
                    if (object == null) continue;
                    object.getModel().setName(string3);
                    visContext.addDynamicStyle(string3, (Style)object);
                    continue;
                }
                catch (Exception exception) {
                    log.log(Level.WARNING, exception.getMessage(), exception);
                }
            }
        }
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            string2 = (String)hashtable.get(string3);
            if (string2.indexOf("<AdvancedStyle") < 0) continue;
            try {
                object = StyleFactory.createStyle(string2, string, visContext);
                if (object == null) continue;
                object.getModel().setName(string3);
                visContext.addDynamicStyle(string3, (Style)object);
            }
            catch (Exception exception) {
                log.log(Level.WARNING, exception.getMessage(), exception);
            }
        }
    }

    public static Style createStyle(String string, String string2, VisContext visContext) throws StyleException {
        Hashtable hashtable;
        int n = StyleUtils.getStyleTypeFromXML(string);
        Style style = null;
        StyleCache styleCache = DSManager.getStyleCache(string2);
        Hashtable hashtable2 = hashtable = visContext == null ? null : visContext.getDynamicStyles();
        if (n == 9) {
            try {
                style = StyleFactory.createAdvancedStyle(XMLDOMParser.parseToDoc(string), styleCache, hashtable);
            }
            catch (Exception exception) {
                throw new StyleException("cannot create dynamic Advanced style.", exception);
            }
        } else {
            int n2 = string.indexOf("<image_marker");
            style = n2 > 0 ? StyleFactory.createImageMarkerStyle(string, n2) : ((n2 = string.indexOf("<image_area")) > 0 ? StyleFactory.createImageAreaStyle(string, n2) : StyleFactory.createStyleFromXML(string));
            if (style != null) {
                style.resolveStyles(styleCache, hashtable);
            }
        }
        return style;
    }

    public static Style createImageMarkerStyle(String string, int n) throws StyleException {
        String string2 = null;
        XMLDOMParser xMLDOMParser = new XMLDOMParser();
        if (xMLDOMParser.parse(string) && ((string2 = xMLDOMParser.getAttribute("image_marker", "url")) == null || string2.trim().length() == 0)) {
            return null;
        }
        try {
            URL uRL = new URL(string2);
            byte[] byArray = Util.readBinaryFromURL(uRL);
            return new StyleMarker(0, byArray, string);
        }
        catch (Exception exception) {
            throw new StyleException("Exception creating URL image marker style", exception);
        }
    }

    public static Style createImageAreaStyle(String string, int n) throws StyleException {
        n = string.indexOf("url=\"", n);
        int n2 = string.indexOf("\"", n + 5);
        if (n < 0 || n2 < 0) {
            return null;
        }
        String string2 = string.substring(n + 5, n2);
        try {
            byte[] byArray = Util.readBinaryFromURL(string2);
            if (byArray == null) {
                throw new StyleException("cannot load area pattern image from: " + string2);
            }
            return new StyleArea(string, byArray);
        }
        catch (Exception exception) {
            throw new StyleException("cannot create image area style", exception);
        }
    }

    public static Style createStyle(StyleRowData styleRowData, String string, VisContext visContext) {
        return null;
    }

    public static Style createStyleObject(int n, String string, byte[] byArray) {
        try {
            switch (n) {
                case 1: {
                    return new StyleColor(string);
                }
                case 2: {
                    if (byArray == null) {
                        return new StyleMarker(string);
                    }
                    return new StyleMarker(0, byArray, string);
                }
                case 3: {
                    return new StyleLine(string);
                }
                case 4: {
                    return new StyleArea(string, byArray);
                }
                case 5: {
                    return new StyleText(string);
                }
                case 9: {
                    return StyleFactory.createAdvancedStyle(XMLDOMParser.parseToDoc(string));
                }
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

