/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.geom.Rectangle2D;
import oracle.sdovis.CoordArray;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.Proj;
import oracle.sdovis.Spheroid;

public class ProjRobinson
implements Proj {
    private static final double[][] Constants = new double[][]{{1.0, 0.0}, {0.9986, 0.062}, {0.9954, 0.124}, {0.99, 0.186}, {0.9822, 0.248}, {0.973, 0.31}, {0.96, 0.372}, {0.9427, 0.434}, {0.9216, 0.4958}, {0.8962, 0.5571}, {0.8679, 0.6176}, {0.835, 0.6769}, {0.7986, 0.7346}, {0.7597, 0.7903}, {0.7186, 0.8435}, {0.6732, 0.8936}, {0.6213, 0.9394}, {0.5722, 0.9761}, {0.5322, 1.0}, {0.5322, 1.0}};
    private double R;
    private double clat;
    private double clon;
    private double easting;
    private double northing;
    private double MultX;
    private double MultY;
    private JSDOGeometry bg;

    public ProjRobinson(double d) {
        this(Spheroid.clarke1866.getSemiMajorAxis(), d, 0.0);
    }

    public ProjRobinson(double d, double d2) {
        this(Spheroid.clarke1866.getSemiMajorAxis(), d, d2);
    }

    public ProjRobinson(double d, double d2, double d3) {
        this.R = d;
        this.clon = Proj.util.Clip(d2 * (Math.PI / 180), Math.PI * -2, Math.PI * 2);
        this.clat = d3 * (Math.PI / 180);
        this.init();
    }

    public double[] save() {
        return new double[]{this.getProjId(), this.R, this.clon, this.clat};
    }

    public double getR() {
        return this.R;
    }

    public Proj.P2 getCenter() {
        return new Proj.P2(this.clon * 57.29577951308232, this.clat * 57.29577951308232);
    }

    public Proj.P2 getOpposite() {
        return null;
    }

    public int getProjId() {
        return 3;
    }

    public Rectangle2D getBoundingBox(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        double d = rectangle2D.getHeight();
        Proj.P2 p2 = new Proj.P2();
        this.forward(rectangle2D.getCenterX(), Proj.util.Clip(rectangle2D.getCenterY() + d / 2.0, -90.0, 90.0), p2);
        double d2 = p2.y - this.northing;
        return new Rectangle2D.Double(this.northing - d2, this.easting - d2, d2 * 2.05, d2 * 2.05);
    }

    public final boolean forward(double d, double d2, Proj.P2 p2) {
        double d3 = Proj.util.Clip(d, -360.0, 360.0) * (Math.PI / 180);
        double d4 = Proj.util.Clip(d2, -90.0, 90.0);
        double d5 = Math.abs(d4) / 5.0;
        int n = (int)d5;
        double d6 = d5 - (double)n;
        double d7 = Constants[n][0] + d6 * (Constants[n + 1][0] - Constants[n][0]);
        double d8 = Constants[n][1] + d6 * (Constants[n + 1][1] - Constants[n][1]);
        double d9 = this.MultX * d7 * Proj.util.adjustLon(d3 - this.clon);
        double d10 = this.MultY * d8;
        if (d4 < 0.0) {
            d10 = -d10;
        }
        p2.set(d9 + this.easting, d10 + this.northing);
        return true;
    }

    public final boolean inverse(double d, double d2, Proj.P2 p2) {
        double d3;
        double d4;
        double d5;
        double d6 = d - this.easting;
        double d7 = d2 - this.northing;
        double d8 = Math.abs(d7 / this.MultY);
        if (d5 >= 1.0) {
            d4 = 90.0;
            d3 = Constants[18][0];
        } else {
            int n = 0;
            for (int i = 0; i < 19; ++i) {
                if (!(Constants[i + 1][1] > d8)) continue;
                n = i;
                break;
            }
            double d9 = (d8 - Constants[n][1]) / (Constants[n + 1][1] - Constants[n][1]);
            d4 = ((double)n + d9) * 5.0;
            d3 = Constants[n][0] + d9 * (Constants[n + 1][0] - Constants[n][0]);
        }
        double d10 = d6 / (d3 * this.MultX) + this.clon;
        d6 = Proj.util.Clip(d10, Math.PI * -2, Math.PI * 2);
        d7 = d7 < 0.0 ? -d4 : d4;
        double d11 = d6 * 57.29577951308232;
        if (d11 > 180.0) {
            d11 -= 360.0;
        } else if (d11 <= -180.0) {
            d11 += 360.0;
        }
        double d12 = d7;
        p2.set(d11, d12);
        return true;
    }

    public void setOffset(double d, double d2) {
        this.easting = d;
        this.northing = d2;
        this.createBoundingGeom();
    }

    public Proj.P2 getOffset() {
        return new Proj.P2(this.easting, this.northing);
    }

    public boolean isOddPoint(double d, double d2) {
        return false;
    }

    public double[] getBoundingGeom() {
        return null;
    }

    public double[] getParallel(double d, double d2) {
        CoordArray coordArray = new CoordArray(1440);
        int n = 360;
        int n2 = 0;
        while (n >= -360) {
            coordArray.add(n, d);
            --n;
            ++n2;
        }
        return coordArray.getAll();
    }

    private void init() {
        this.MultX = 0.8487 * this.R;
        this.MultY = 1.3523 * this.R;
        this.createBoundingGeom();
    }

    private void createBoundingGeom() {
    }
}

