/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.RenderingRule;
import oracle.mapviewer.share.ext.NSDataProvider;
import oracle.mapviewer.share.ext.NSDataSet;
import oracle.mapviewer.share.ext.NSRow;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NSDataProviderDefault
implements NSDataProvider {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);

    public boolean init(Properties properties) {
        return true;
    }

    public NSDataSet buildDataSet(Hashtable hashtable) {
        String string = (String)hashtable.get("file");
        if (string != null) {
            return this.readFromFile(string);
        }
        String string2 = (String)hashtable.get("url");
        if (string2 != null) {
            return this.readFromUrl(string2);
        }
        String string3 = (String)hashtable.get("xml");
        if (string3 != null) {
            return this.buildFromXml(string3);
        }
        String string4 = (String)hashtable.get("xml_url");
        if (string4 != null) {
            return this.buildFromXmlUrl(string4);
        }
        String string5 = (String)hashtable.get("xml_file");
        if (string5 != null) {
            return this.buildFromXmlFile(string5);
        }
        log.severe("Must supply either 'file', 'url', or 'xml' for default NS data provider.");
        return null;
    }

    public void destroy() {
    }

    protected NSDataSet getDataFromReader(BufferedReader bufferedReader) throws IOException {
        Object object;
        String[] stringArray = null;
        String string = bufferedReader.readLine();
        String string2 = string.substring(0, 1);
        if (string.length() > 2 && (string = string.substring(2)) != null && string.length() > 1) {
            stringArray = string.split(string2);
        }
        Vector<Object> vector = new Vector<Object>();
        while ((string = bufferedReader.readLine()) != null) {
            object = this.buildRow(string, string2, stringArray);
            if (object == null) continue;
            vector.add(object);
        }
        object = new NSDataSet(vector);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NSDataSet readFromFile(String string) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            NSDataSet nSDataSet = this.getDataFromReader(bufferedReader);
            return nSDataSet;
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, exception.getMessage(), exception);
            NSDataSet nSDataSet = null;
            return nSDataSet;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NSDataSet readFromUrl(String string) {
        BufferedReader bufferedReader = null;
        InputStream inputStream = null;
        try {
            URL uRL = new URL(string);
            inputStream = uRL.openStream();
            InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
            bufferedReader = new BufferedReader(inputStreamReader);
            NSDataSet nSDataSet = this.getDataFromReader(bufferedReader);
            return nSDataSet;
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, exception.getMessage(), exception);
            NSDataSet nSDataSet = null;
            return nSDataSet;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected NSRow buildRow(String string, String string2, String[] stringArray) {
        if (string == null || string.length() < 1) {
            return null;
        }
        String[] stringArray2 = string.split(string2);
        if (stringArray2 == null || stringArray2.length == 0) {
            return null;
        }
        Field[] fieldArray = new Field[stringArray2.length];
        Field field = new Field(stringArray2[0]);
        field.setKey(true);
        if (stringArray != null && stringArray.length > 0) {
            field.setName(stringArray[0]);
        }
        fieldArray[0] = field;
        for (int i = 1; i < stringArray2.length; ++i) {
            try {
                double d = Double.parseDouble(stringArray2[i]);
                field = new Field(d);
                if (stringArray != null && stringArray.length > i) {
                    field.setName(stringArray[i]);
                }
                fieldArray[i] = field;
                continue;
            }
            catch (Exception exception) {
                log.warning("invalid row field (key=" + stringArray2[0] + ")");
                return null;
            }
        }
        return new NSRow(fieldArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NSDataSet buildFromXml(String string) {
        String string2;
        log.finest("Beginning of NSDP XML:\n" + string);
        log.finest("\nEnd of NSDP XML.");
        XMLDOMParser xMLDOMParser = null;
        try {
            Object object;
            Object object2;
            xMLDOMParser = new XMLDOMParser();
            if (!xMLDOMParser.parse(string)) {
                log.warning("Cannot parse the nsdp xml data document.");
                NSDataSet nSDataSet = null;
                return nSDataSet;
            }
            Node node = xMLDOMParser.getElementNode("nsdp_xml");
            if (node == null) {
                log.warning("root node <nsdp_xml> not found in xml doc.");
                NSDataSet nSDataSet = null;
                return nSDataSet;
            }
            string2 = XMLDOMParser.getAttribute(node, "meta");
            Node node2 = XMLDOMParser.getSubElement(node, "rendering");
            RenderingRule[] renderingRuleArray = null;
            if (node2 != null) {
                renderingRuleArray = StylingRule.getRenderRules(xMLDOMParser, node2);
            }
            Node node3 = XMLDOMParser.getSubElement(node, "table");
            ArrayList arrayList = XMLDOMParser.getSubElements(node3, "tr");
            Node node4 = (Node)arrayList.get(0);
            ArrayList arrayList2 = XMLDOMParser.getSubElements(node4, "th");
            if (arrayList2 == null || arrayList2.size() == 0) {
                log.warning("must specify column headings using <th> element as first row.");
                NSDataSet nSDataSet = null;
                return nSDataSet;
            }
            String[] stringArray = new String[arrayList2.size()];
            String[] stringArray2 = new String[arrayList2.size()];
            String[] stringArray3 = new String[arrayList2.size()];
            for (int i = 0; i < arrayList2.size(); ++i) {
                Node node5 = (Node)arrayList2.get(i);
                stringArray2[i] = XMLDOMParser.getElementValue(node5);
                stringArray[i] = stringArray2[i];
                object2 = XMLDOMParser.getAttribute(node5, "type");
                if (object2 == null) {
                    object2 = i > 0 ? "number" : "string";
                }
                stringArray3[i] = object2;
                object = XMLDOMParser.getAttribute(node5, "id");
                if (object == null || ((String)object).length() <= 0) continue;
                stringArray[i] = object;
            }
            Vector<NSRow> vector = new Vector<NSRow>();
            for (int i = 1; i < arrayList.size(); ++i) {
                object2 = (Node)arrayList.get(i);
                object = this.getRowFromXML(xMLDOMParser, (Node)object2, stringArray, stringArray2, stringArray3);
                if (object == null) continue;
                vector.add((NSRow)object);
            }
            NSDataSet nSDataSet = new NSDataSet(vector);
            if (renderingRuleArray != null) {
                nSDataSet.setCustomRenderingRules(renderingRuleArray);
            }
            if (string2 != null && string2.length() > 0) {
                nSDataSet.setMetadata(string2);
            }
            object2 = nSDataSet;
            return object2;
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, exception.getMessage(), exception);
            string2 = null;
            return string2;
        }
        finally {
            if (xMLDOMParser != null) {
                xMLDOMParser.close();
            }
        }
    }

    protected NSRow getRowFromXML(XMLDOMParser xMLDOMParser, Node node, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        ArrayList arrayList = XMLDOMParser.getSubElements(node, "td");
        Field[] fieldArray = new Field[arrayList.size()];
        for (int i = 0; i < fieldArray.length; ++i) {
            try {
                NamedNodeMap namedNodeMap;
                Field field = null;
                Node node2 = (Node)arrayList.get(i);
                String string = XMLDOMParser.getElementValue(node2);
                String string2 = stringArray3[i];
                if ("number".equalsIgnoreCase(string2) || "double".equalsIgnoreCase(string2)) {
                    double d = 0.0;
                    if (string != null && string.length() > 0) {
                        try {
                            d = Double.parseDouble(string);
                        }
                        catch (Exception exception) {
                            log.warning("cannot parse numeric cell value.");
                        }
                        field = new Field(d);
                    } else {
                        field = new Field();
                        field.setNoData();
                    }
                } else if ("integer".equalsIgnoreCase(string2)) {
                    long l = 0L;
                    if (string != null && string.length() > 0) {
                        try {
                            l = Long.parseLong(string);
                        }
                        catch (Exception exception) {
                            log.warning("cannot parse numeric cell value.");
                        }
                        field = new Field(l);
                    } else {
                        field = new Field();
                        field.setNoData();
                    }
                } else if (string == null) {
                    field = new Field();
                    field.setNoData();
                } else {
                    field = new Field(string);
                }
                if (i == 0) {
                    field.setKey(true);
                    if (field.isNoData()) {
                        log.warning("NSDP key column contains NODATA!");
                    }
                }
                if (stringArray != null && stringArray.length > i) {
                    field.setName(stringArray[i]);
                }
                if (stringArray2 != null && stringArray2.length > i) {
                    field.setDisplayName(stringArray2[i]);
                }
                if ((namedNodeMap = node2.getAttributes()) != null && namedNodeMap.getLength() > 0) {
                    String[] stringArray4 = new String[namedNodeMap.getLength() * 2];
                    for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                        Node node3 = namedNodeMap.item(j);
                        stringArray4[j * 2] = node3.getNodeName();
                        stringArray4[j * 2 + 1] = node3.getNodeValue();
                    }
                    field.setContexts(stringArray4);
                }
                fieldArray[i] = field;
                continue;
            }
            catch (Exception exception) {
                log.warning("invalid row  (key=" + fieldArray[0] + ")");
                log.log(Level.WARNING, "exception when getting a row from XML.", exception);
                return null;
            }
        }
        return new NSRow(fieldArray);
    }

    protected NSDataSet buildFromXmlUrl(String string) {
        byte[] byArray = Util.readBinaryFromURL(string);
        if (byArray != null) {
            try {
                String string2 = new String(byArray, "UTF-8");
                return this.buildFromXml(string2);
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, exception.getMessage(), exception);
                return null;
            }
        }
        return null;
    }

    protected NSDataSet buildFromXmlFile(String string) {
        byte[] byArray = null;
        try {
            byArray = Util.readFile(string);
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, exception.getMessage(), exception);
            return null;
        }
        if (byArray != null) {
            try {
                String string2 = new String(byArray, "UTF-8");
                return this.buildFromXml(string2);
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, exception.getMessage(), exception);
                return null;
            }
        }
        return null;
    }
}

